function solution63

% Definition of beta and modified beta
beta = zeros(1,20);
beta(1) = 241/110;
beta(2) = 4641/1100;

beta_m = zeros(1,20);
beta_m(1) = 241/220;
beta_m(2) = 4641/2200;

% Evaluate alpha values
gamma = cumsum(beta)
gamma_m = cumsum(beta_m)
for N=3:15
 a   = alpha(gamma,  N);
 a_m = alpha(gamma_m,N);
 fprintf('N=%2d: alpha=%9.5f, alpha(modified)=%9.5f\n',N,a,a_m);
end;



% implementation of alpha-formula (6.19)
function a=alpha(gamma,N)

  a = 1 - (gamma(N)-1) * prod(gamma(2:N)-ones(size(gamma(2:N)))) / ...
          (prod(gamma(2:N)) - prod(gamma(2:N)-ones(size(gamma(2:N)))));
