(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1023241,      26843]
NotebookOptionsPosition[    877253,      24802]
NotebookOutlinePosition[    877633,      24818]
CellTagsIndexPosition[    877590,      24815]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Preliminaries", "Title",
 CellChangeTimes->{{3.710562274595291*^9, 
  3.710562278550516*^9}},ExpressionUUID->"fa12775a-e440-4712-852d-\
620818d131fe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.7096113381654005`*^9, 3.709611352884179*^9}, {
   3.7096131714313145`*^9, 3.709613178073697*^9}, 3.709614117048169*^9, 
   3.709614151673237*^9, {3.709870614208662*^9, 3.709870633739951*^9}, {
   3.7098757014626827`*^9, 3.7098757053839064`*^9}, {3.7105100271712503`*^9, 
   3.7105100337493863`*^9}, {3.7105725823472457`*^9, 
   3.7105726092222986`*^9}, {3.7105745595183525`*^9, 3.710574564424613*^9}, {
   3.7109077434521756`*^9, 3.7109077495125213`*^9}, {3.7284719908149543`*^9, 
   3.728472050315071*^9}, {3.730003212672229*^9, 3.730003222062872*^9}, {
   3.7301179952225857`*^9, 3.7301180159882536`*^9}, {3.73011808287901*^9, 
   3.7301180833946342`*^9}, 
   3.7301862686686907`*^9},ExpressionUUID->"59047852-c904-402b-9e31-\
84b46a17c1dc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"#", ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "Automatic", "]"}]}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
    "ContourPlot", ",", "DateListPlot", ",", "Plot", ",", "ListLinePlot", ",",
      "ListPlot", ",", "ListLogPlot", ",", "LogLinearPlot", ",", "LogPlot", 
     ",", "ParametricPlot", ",", "Plot3D", ",", "RegionPlot"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"GraphPlot", ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.7096113381654005`*^9, 3.709611352884179*^9}, {
   3.7096131714313145`*^9, 3.709613178073697*^9}, 3.709614117048169*^9, 
   3.709614151673237*^9, {3.709870614208662*^9, 3.709870633739951*^9}, {
   3.7098757014626827`*^9, 3.7098757053839064`*^9}, {3.7105100271712503`*^9, 
   3.7105100337493863`*^9}, {3.7105725823472457`*^9, 
   3.7105726092222986`*^9}, {3.7105745595183525`*^9, 3.710574564424613*^9}, {
   3.7109077434521756`*^9, 3.7109077495125213`*^9}, {3.7284719908149543`*^9, 
   3.728472050315071*^9}, {3.730003212672229*^9, 3.730003222062872*^9}, {
   3.7301179952225857`*^9, 3.7301180159882536`*^9}, {3.73011808287901*^9, 
   3.7301180833946342`*^9}, {3.7301862686686907`*^9, 
   3.7301862737299786`*^9}},ExpressionUUID->"be69a8af-c433-4d78-bd77-\
9879a532de87"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LaunchKernels", "[", "]"}], ";"}]], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.7096113381654005`*^9, 3.709611352884179*^9}, {
   3.7096131714313145`*^9, 3.709613178073697*^9}, 3.709614117048169*^9, 
   3.709614151673237*^9, {3.709870614208662*^9, 3.709870633739951*^9}, {
   3.7098757014626827`*^9, 3.7098757053839064`*^9}, {3.7105100271712503`*^9, 
   3.7105100337493863`*^9}, {3.7105725823472457`*^9, 
   3.7105726092222986`*^9}, {3.7105745595183525`*^9, 3.710574564424613*^9}, {
   3.7109077434521756`*^9, 3.7109077495125213`*^9}, {3.7284719908149543`*^9, 
   3.728472050315071*^9}, {3.730003212672229*^9, 3.730003222062872*^9}, {
   3.7301179952225857`*^9, 3.7301180159882536`*^9}, {3.73011808287901*^9, 
   3.7301180833946342`*^9}, {3.7301862686686907`*^9, 
   3.730186277972223*^9}},ExpressionUUID->"d150c58b-8960-4fb3-9572-\
81a8d251c0a0"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ReactionKinetics`\>\"", "]"}]], "Input",
 InitializationCell->True,
 EmphasizeSyntaxErrors->
  True,ExpressionUUID->"27731ee5-22a8-43d2-af1d-44069f0596f9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"format", ",", "figurexp"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"format", "[", 
    RowBox[{"x_", ",", "options___"}], "]"}], ":=", 
   RowBox[{"Thread", "[", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", 
          RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", 
          "options"}], "]"}], "&"}], "/@", "x"}], ")"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"figurexp", "[", 
    RowBox[{"filename_", ",", "picturename_"}], "]"}], ":=", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{
     "\"\<d:\\\\__Springer\\\\SpringerAktualis\\\\Figures\\\\\>\"", "<>", 
      "filename", "<>", "\"\<.png\>\""}], ",", "picturename"}], 
    "]"}]}]}]}], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.7096113381654005`*^9, 3.709611352884179*^9}, {
   3.7096131714313145`*^9, 3.709613178073697*^9}, 3.709614117048169*^9, 
   3.709614151673237*^9, {3.709870614208662*^9, 3.709870633739951*^9}, {
   3.7098757014626827`*^9, 3.7098757053839064`*^9}, {3.7105100271712503`*^9, 
   3.7105100337493863`*^9}, {3.7105725823472457`*^9, 
   3.7105726092222986`*^9}, {3.7105745595183525`*^9, 3.710574564424613*^9}, {
   3.7109077434521756`*^9, 3.7109077495125213`*^9}, {3.7284719908149543`*^9, 
   3.728472050315071*^9}, {3.730003212672229*^9, 3.730003222062872*^9}, {
   3.7301179952225857`*^9, 3.7301180159882536`*^9}, {3.73011808287901*^9, 
   3.7301180833946342`*^9}, {3.7301862686686907`*^9, 
   3.7301862992284393`*^9}},ExpressionUUID->"8e86e716-d236-4a03-9104-\
77418a898af3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Introduction", "Title",
 CellChangeTimes->{{3.709556571882634*^9, 
  3.7095565792107735`*^9}},ExpressionUUID->"821e660a-ae23-4a01-b116-\
943c5b26bde0"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723815530143*^9, 
  3.709723817038227*^9}},ExpressionUUID->"9636287c-8921-4a91-94de-\
b1efca56adff"],

Cell[CellGroupData[{

Cell[" Fig. 1.1", "Subsubsection",
 CellChangeTimes->{{3.6336909187221785`*^9, 3.633690930976879*^9}, {
   3.633691637916314*^9, 3.633691650157014*^9}, 3.7095566962110023`*^9, {
   3.7187189421754975`*^9, 3.718718985206828*^9}, {3.718719017688629*^9, 
   3.71871902987615*^9}, {3.728643623900502*^9, 
   3.72864362516613*^9}},ExpressionUUID->"68990d16-3e3a-4f02-bd11-\
9a96892a1a4d"],

Cell["\<\
Citations to Horn and Jackson. Data collected manually from scholar.\
\>", "Text",
 CellChangeTimes->{{3.6336909187221785`*^9, 3.633690930976879*^9}, {
  3.633691637916314*^9, 3.633691650157014*^9}, {3.709570794467724*^9, 
  3.7095708000146103`*^9}, {3.7096102655651517`*^9, 
  3.7096102742996492`*^9}},ExpressionUUID->"20e1aac2-d442-4bf9-bb54-\
49ac9955d824"],

Cell[BoxData[
 RowBox[{
  RowBox[{"cit", "=", 
   RowBox[{"{", 
    RowBox[{
    "3", ",", "4", ",", "8", ",", "9", ",", "12", ",", "13", ",", "19", ",", 
     "26", ",", "28", ",", "33", ",", "34", ",", "38", ",", "42", ",", "46", 
     ",", "49", ",", "53", ",", "58", ",", "64", ",", "66", ",", "73", ",", 
     "76", ",", "79", ",", "87", ",", "93", ",", "101", ",", "107", ",", 
     "114", ",", "120", ",", "122", ",", "127", ",", "134", ",", "146", ",", 
     "159", ",", "179", ",", "188", ",", "207", ",", "235", ",", "263", ",", 
     "298", ",", "353", ",", "412", ",", "475", ",", "537", ",", "581", ",", 
     "649"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6336907892247715`*^9, 3.6336909491639194`*^9}, {
  3.7095569076019273`*^9, 3.709556947086379*^9}, {3.7095569789536977`*^9, 
  3.709557139599834*^9}},ExpressionUUID->"dfccd107-7986-4ee9-8bd0-\
a64b2ef5cc20"],

Cell["\<\
The logarithm of the number of citations of Horn and Jackson (1972) up to a \
certain year. Note the three phases: Up to 1980, and after 2002 and in \
between.\
\>", "Text",
 CellChangeTimes->{{3.7187189862224584`*^9, 3.718718994753724*^9}, {
  3.718719041329299*^9, 
  3.7187190673918505`*^9}},ExpressionUUID->"6afbd8fe-9e25-404a-870c-\
a98e9e557cbb"],

Cell[BoxData[
 RowBox[{"hornjacksoncit", "=", 
  RowBox[{"ListLogPlot", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"1972", ",", "2016"}], "]"}], ",", "cit"}], "}"}], "]"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"PointSize", "[", "Large", "]"}], "]"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.633691037849992*^9, 3.633691050206699*^9}, {
   3.6336911254680033`*^9, 3.6336911265180635`*^9}, {3.6336911794210896`*^9, 
   3.6336912772966876`*^9}, {3.6336916260076327`*^9, 3.633691630277877*^9}, {
   3.709557234183996*^9, 3.709557235152748*^9}, {3.709557464184446*^9, 
   3.70955754023147*^9}, 3.709558279565317*^9, 3.709614108798153*^9, 
   3.7096141564857464`*^9, {3.7140158797346125`*^9, 3.714015892184326*^9}, 
   3.7140160509344177`*^9, {3.7284717166425447`*^9, 3.7284717390175867`*^9}, {
   3.728471778423914*^9, 3.728471793080193*^9}, {3.728471830986517*^9, 
   3.728471835236526*^9}},ExpressionUUID->"022bacaa-e1cb-4f4f-afb9-\
108fe3280d9d"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig1.1\>\"", ",", "hornjacksoncit"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6336916053214493`*^9, 3.6336916171981287`*^9}, {
   3.633691661588668*^9, 3.633691741562242*^9}, {3.634800516581688*^9, 
   3.6348005191658354`*^9}, {3.6351375104930477`*^9, 
   3.6351375291421146`*^9}, {3.728471828611512*^9, 3.728471841611539*^9}, {
   3.7284718850647507`*^9, 3.7284718988460255`*^9}, {3.728472114283946*^9, 
   3.72847211559645*^9}, 
   3.7284798865646152`*^9},ExpressionUUID->"13b6e46f-a7ee-4ac4-9ad3-\
c7975d65c155"]
}, Open  ]]
}, Open  ]],

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.728796632102721*^9, 
  3.728796634493351*^9}},ExpressionUUID->"c46c8b28-fbd0-4bff-94b8-\
5597a057c4ab"]
}, Closed]],

Cell[CellGroupData[{

Cell["Preparations", "Title",
 CellChangeTimes->{{3.709556585195161*^9, 
  3.7095565875389147`*^9}},ExpressionUUID->"ac2d20c3-4b0e-44fe-845d-\
9cdae3aa7400"],

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723828421879*^9, 
  3.709723834238214*^9}},ExpressionUUID->"fee0c949-a159-4990-b237-\
33502f7fa1a6"],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238445418024`*^9, 
  3.7097238504941425`*^9}},ExpressionUUID->"c6f9e77e-82f9-43ba-af41-\
6ea5ce331286"],

Cell[CellGroupData[{

Cell["2.2 The Standard Setting", "Section",
 CellChangeTimes->{{3.7140163213979044`*^9, 3.7140163258261585`*^9}, {
  3.718719332517369*^9, 
  3.7187193366111264`*^9}},ExpressionUUID->"eb35b42d-97a8-4b0a-8f0c-\
753f02f75b8c"],

Cell[CellGroupData[{

Cell["Remark 2.3.2", "Subsubsection",
 CellChangeTimes->{{3.7287967455404444`*^9, 3.728796748290449*^9}, {
  3.7294014629283853`*^9, 
  3.729401464100264*^9}},ExpressionUUID->"ccfd0b81-6666-4096-b2d1-\
a0156a626fdc"],

Cell[BoxData[
 RowBox[{"rd", "=", 
  RowBox[{"ReactionsData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<X\>\""}], "\[Rule]", 
      RowBox[{"2", "\"\<X\>\""}]}], "}"}], ",", 
    RowBox[{"{", "\"\<A\>\"", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7187196580023804`*^9, 3.7187197092524805`*^9}, 
   3.7294014949596977`*^9},ExpressionUUID->"58c254e9-7b1a-4a57-aa96-\
b1e6c6a13cd5"],

Cell[BoxData[
 RowBox[{"rd", "[", "\"\<reactionsteps\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.718719679252425*^9, 3.718719715236868*^9}, {
  3.718719745877552*^9, 
  3.718719752815066*^9}},ExpressionUUID->"1ba2591e-bdcf-46ff-a6a4-\
146dcb5b686c"],

Cell[BoxData[
 RowBox[{"rd", "[", "\"\<fhjgraphedges\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.714016329160349*^9, 3.714016374514948*^9}, {
   3.7187194760332747`*^9, 3.718719477033276*^9}, {3.7187195456740365`*^9, 
   3.71871954789279*^9}, {3.7187195805334787`*^9, 3.7187195957991333`*^9}, 
   3.7187196658773956`*^9, {3.7187197222368813`*^9, 3.718719730924399*^9}, {
   3.730119315809634*^9, 
   3.7301193173408847`*^9}},ExpressionUUID->"908c3245-260d-4ebd-bf7d-\
344357038872"],

Cell[BoxData[
 RowBox[{"rd", "[", "\"\<species\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7187197898307643`*^9, 
  3.71871979583078*^9}},ExpressionUUID->"a2024d4f-5853-4601-a3a8-\
98a746e8ea53"],

Cell[BoxData[
 RowBox[{"rd", "[", "\"\<externalspecies\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7187197898307643`*^9, 
  3.718719802768289*^9}},ExpressionUUID->"1bfcf46d-f896-4b75-8d62-\
92da2846ba6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.6 Simple bimolecular reaction", "Subsubsection",
 CellChangeTimes->{{3.711861276362075*^9, 3.7118612879377456`*^9}, {
  3.728796765384229*^9, 
  3.7287967702748675`*^9}},ExpressionUUID->"9d5141b5-cb64-491d-8d9b-\
93d9e5695d72"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ReactionsData", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[DoubleLeftRightArrow]", 
        "\"\<C\>\""}], "}"}], "]"}], "[", 
     RowBox[{
     "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<species\>\"", ",", 
      "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\"", ",", "\"\<\[Gamma]\>\""}], 
     "]"}], "//", "Normal"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<M = \>\"", ",", "\"\<R = \>\"", ",", "\"\<species\>\"", ",", 
        "\"\<\[Alpha] = \>\"", ",", "\"\<\[Beta] = \>\"", ",", 
        "\"\<\[Gamma] = \>\""}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.711861051712232*^9, 3.71186111072433*^9}, {
  3.711861156286519*^9, 3.7118611827390437`*^9}, {3.7118612484515834`*^9, 
  3.7118612567480803`*^9}, {3.71186145752911*^9, 3.7118614589920797`*^9}, {
  3.7187198099401774`*^9, 3.7187199511748285`*^9}, {3.728796782368641*^9, 
  3.7287968061186857`*^9}, {3.7306961040899897`*^9, 
  3.7306961730901237`*^9}},ExpressionUUID->"a0309dcc-1481-4613-a9ca-\
07f6a34cb425"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.7 Lotka-Volterra reaction", "Subsubsection",
 CellChangeTimes->{{3.7118613218972445`*^9, 3.711861328449587*^9}, {
  3.7287971309786973`*^9, 
  3.728797138541212*^9}},ExpressionUUID->"27c964e0-d3cb-4333-97ec-\
328257935880"],

Cell[BoxData[
 RowBox[{"lvgenuine", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}], "[", 
   RowBox[{
   "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<species\>\"", ",", 
    "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.711861051712232*^9, 3.71186111072433*^9}, {
  3.711861156286519*^9, 3.7118611827390437`*^9}, {3.7118612484515834`*^9, 
  3.7118612567480803`*^9}, {3.711861342537921*^9, 3.7118613783526497`*^9}, {
  3.711861444521493*^9, 
  3.7118614456802607`*^9}},ExpressionUUID->"e54e7606-cc54-498c-a4e4-\
a616e8a342dc"],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"lvgenuine", "\[LeftDoubleBracket]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], "\[RightDoubleBracket]"}]}]], "Input",
 CellChangeTimes->{{3.711861392192822*^9, 3.711861392928308*^9}, {
  3.711861451015794*^9, 
  3.711861451999446*^9}},ExpressionUUID->"e9e05cad-b6e2-4d50-abd2-\
2a462b31b716"],

Cell[BoxData[
 RowBox[{"lv", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{
     RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
   RowBox[{
   "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<species\>\"", ",", 
    "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.711861051712232*^9, 3.71186111072433*^9}, {
  3.711861156286519*^9, 3.7118611827390437`*^9}, {3.7118612484515834`*^9, 
  3.7118612567480803`*^9}, {3.711861342537921*^9, 3.7118613783526497`*^9}, {
  3.711861419056621*^9, 
  3.7118614246643353`*^9}},ExpressionUUID->"e380fca0-1d1e-49d8-baa0-\
0d556f952fb3"],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"lv", "\[LeftDoubleBracket]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], "\[RightDoubleBracket]"}]}]], "Input",Expr\
essionUUID->"84c3dde2-a141-4d05-83d2-bd3d26b4520d"],

Cell[BoxData[
 RowBox[{"ShowVolpertGraph", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"Bipartite", "\[Rule]", "True"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], ",", 
   RowBox[{"EdgeLabeled", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730871175457466*^9, 3.7308711831729097`*^9}, {
   3.7308712303500423`*^9, 3.7308713609284225`*^9}, {3.73087139194411*^9, 
   3.730871401725376*^9}, {3.730871450131722*^9, 3.730871495413061*^9}, {
   3.7308798660148315`*^9, 3.7308799072492857`*^9}, 
   3.7308800552441945`*^9},ExpressionUUID->"69686ae9-802f-4e5c-ac2f-\
e6fbce9131dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.8 Robertson reaction", "Subsubsection",
 CellChangeTimes->{{3.71186149657498*^9, 3.7118615025029078`*^9}, {
  3.72879736921354*^9, 
  3.728797371088541*^9}},ExpressionUUID->"5cacf332-6110-4e97-b4d8-\
2808c9f907a2"],

Cell[BoxData[
 RowBox[{"rob", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Robertson\>\"", "}"}], "]"}], "[", 
   RowBox[{
   "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<species\>\"", ",", 
    "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\"", ",", "\"\<\[Gamma]\>\"", ",", 
    "\"\<S\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.711861514871103*^9, 3.711861553862938*^9}, {
  3.7301866657997565`*^9, 
  3.73018666633101*^9}},ExpressionUUID->"88a8c17c-51d6-4247-b02c-\
e28f960c954f"],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"rob", "\[LeftDoubleBracket]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], 
   "\[RightDoubleBracket]"}]}]], "Input",
 CellChangeTimes->{{3.711861595437482*^9, 
  3.7118615996302624`*^9}},ExpressionUUID->"64fb543a-9a7b-4333-9f87-\
2eda4bab88ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.9 Michaelis-Menten reaction", "Subsubsection",
 CellChangeTimes->{{3.711861676629278*^9, 3.7118616887803335`*^9}, {
  3.728797413072999*^9, 
  3.728797415369879*^9}},ExpressionUUID->"c1741677-551e-455e-8956-\
6bbe04c54913"],

Cell[BoxData[
 RowBox[{"mm", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], "]"}], "[", 
   RowBox[{
   "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<species\>\"", ",", 
    "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\"", ",", "\"\<\[Gamma]\>\"", ",", 
    "\"\<S\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.711861514871103*^9, 3.711861553862938*^9}, {
  3.711861706581123*^9, 3.7118617312764845`*^9}, {3.711861848043851*^9, 
  3.711861849940109*^9}, {3.7187200590500402`*^9, 3.718720061362545*^9}, {
  3.7301866919091835`*^9, 
  3.7301866925341835`*^9}},ExpressionUUID->"74172c01-10cc-4927-b29b-\
1d293c5e8bc7"],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"mm", "\[LeftDoubleBracket]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], 
   "\[RightDoubleBracket]"}]}]], "Input",
 CellChangeTimes->{{3.711861738628357*^9, 3.7118617425719695`*^9}, {
  3.711861852771985*^9, 
  3.711861853986788*^9}},ExpressionUUID->"48f25082-5640-47dd-827f-\
371b95adb785"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.10 Mole reaction", "Subsubsection",
 CellChangeTimes->{{3.7118618822345037`*^9, 3.7118618842588463`*^9}, {
  3.7287974380574226`*^9, 
  3.7287974400105515`*^9}},ExpressionUUID->"90cbe85c-c280-4f9c-bbea-\
060ab192abb2"],

Cell[BoxData[{
 RowBox[{"mole", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Mole\>\"", "}"}], "]"}], "[", 
   RowBox[{
   "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<species\>\"", ",", 
    "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\"", ",", "\"\<\[Gamma]\>\"", ",", 
    "\"\<S\>\""}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"mole", "\[LeftDoubleBracket]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], 
   "\[RightDoubleBracket]"}]}]}], "Input",
 CellChangeTimes->{{3.711861514871103*^9, 3.711861553862938*^9}, {
  3.711861706581123*^9, 3.7118617312764845`*^9}, {3.711861848043851*^9, 
  3.711861849940109*^9}, {3.711861896842183*^9, 3.7118619159378347`*^9}, {
  3.7301867020810795`*^9, 
  3.7301867026435795`*^9}},ExpressionUUID->"b649b018-9c48-44f8-b21b-\
e492114faee0"],

Cell[BoxData[{
 RowBox[{"molesimple", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "\"\<X\>\""}], "->", 
       RowBox[{"3", "\"\<X\>\""}]}], ",", 
      RowBox[{"\"\<X\>\"", "\[DoubleLeftRightArrow]", "0"}]}], "}"}], "]"}], 
   "[", 
   RowBox[{
   "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<species\>\"", ",", 
    "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"molesimple", "\[LeftDoubleBracket]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], "\[RightDoubleBracket]"}]}]}], "Input",
 CellChangeTimes->{{3.711861514871103*^9, 3.711861553862938*^9}, {
  3.711861706581123*^9, 3.7118617312764845`*^9}, {3.711861848043851*^9, 
  3.711861849940109*^9}, {3.711861896842183*^9, 3.7118619159378347`*^9}, {
  3.7118619635223637`*^9, 
  3.711862076039912*^9}},ExpressionUUID->"b4ed77f6-cc77-46d2-b48e-\
dc68ace21ce9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.11 Ogg reaction", "Subsubsection",
 CellChangeTimes->{{3.7118620861596165`*^9, 3.711862088560209*^9}, {
  3.7287974823856354`*^9, 
  3.7287974845418887`*^9}},ExpressionUUID->"317f72e1-b7a3-4918-b794-\
8e8b8784f3ad"],

Cell[BoxData[{
 RowBox[{"ogg", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Ogg\>\"", "}"}], "]"}], "[", 
   RowBox[{
   "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<species\>\"", ",", 
    "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\"", ",", "\"\<\[Gamma]\>\"", ",", 
    "\"\<S\>\""}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"ogg", "\[LeftDoubleBracket]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], 
   "\[RightDoubleBracket]"}]}]}], "Input",
 CellChangeTimes->{{3.711861514871103*^9, 3.711861553862938*^9}, {
  3.711861706581123*^9, 3.7118617312764845`*^9}, {3.711861848043851*^9, 
  3.711861849940109*^9}, {3.711861896842183*^9, 3.7118619159378347`*^9}, {
  3.7118619635223637`*^9, 3.711862076039912*^9}, {3.7118621066281805`*^9, 
  3.711862127791202*^9}, {3.711862175201614*^9, 3.7118623146860313`*^9}, {
  3.730186729237383*^9, 
  3.7301867367530212`*^9}},ExpressionUUID->"1adb1a61-cb32-4b87-9815-\
76efd1341b11"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.12 Frank reaction", "Subsubsection",
 CellChangeTimes->{{3.7118620861596165`*^9, 3.711862088560209*^9}, {
  3.711862369069065*^9, 3.7118623714606476`*^9}, {3.728797519870083*^9, 
  3.7287975229325886`*^9}},ExpressionUUID->"0731e034-ae93-4afa-9aeb-\
c5fa7b7acc95"],

Cell[BoxData[{
 RowBox[{"frank", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Frank\>\"", "}"}], "]"}], "[", 
   RowBox[{
   "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<species\>\"", ",", 
    "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\"", ",", "\"\<\[Gamma]\>\"", ",", 
    "\"\<S\>\""}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"frank", "\[LeftDoubleBracket]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], 
   "\[RightDoubleBracket]"}]}]}], "Input",
 CellChangeTimes->{{3.711861514871103*^9, 3.711861553862938*^9}, {
   3.711861706581123*^9, 3.7118617312764845`*^9}, {3.711861848043851*^9, 
   3.711861849940109*^9}, {3.711861896842183*^9, 3.7118619159378347`*^9}, {
   3.7118619635223637`*^9, 3.711862076039912*^9}, {3.7118621066281805`*^9, 
   3.711862127791202*^9}, {3.711862175201614*^9, 3.7118623146860313`*^9}, {
   3.7140168183923655`*^9, 3.71401682108352*^9}, {3.714016854194416*^9, 
   3.7140169203742075`*^9}, {3.714016988088085*^9, 3.714016989798183*^9}, 
   3.7140252825380793`*^9, {3.730186756549935*^9, 
   3.7301867780343533`*^9}},ExpressionUUID->"e488a7f3-4d72-4c82-a756-\
f7ea0c495dcd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.13 Tur\[AAcute]nyi-Gy\[ODoubleDot]rgyi-Field Version of the \
Oregonator", "Subsubsection",
 CellChangeTimes->{{3.714017026380278*^9, 3.7140170282763863`*^9}, {
  3.714017070562808*^9, 3.714017072027892*^9}, {3.7287975457451334`*^9, 
  3.7287975789483232`*^9}},ExpressionUUID->"0a146e53-c4fc-4825-be8e-\
defd7b271a33"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", "\"\<Tur\[AAcute]nyi-Gy\[ODoubleDot]rgyi-Field\>\"", "}"}], 
   "]"}], "[", 
  RowBox[{
  "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<species\>\"", ",", 
   "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\"", ",", "\"\<\[Gamma]\>\"", ",", 
   "\"\<S\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7140171750467916`*^9, 3.7140171750597925`*^9}, {
  3.7140173576432476`*^9, 3.7140173693429174`*^9}, {3.730186801315648*^9, 
  3.7301868276281986`*^9}},ExpressionUUID->"687b1836-917f-4bc1-916b-\
507e09b5d195"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GetReaction", "[", 
   RowBox[{"{", "\"\<Tur\[AAcute]nyi-Gy\[ODoubleDot]rgyi-Field\>\"", "}"}], 
   "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
    "\"\<X\>\"", "\[Rule]", "\"\<\!\(\*SubscriptBox[\(HBrO\), \(2\)]\)\>\""}],
     ",", 
    RowBox[{
    "\"\<Y\>\"", "\[Rule]", "\"\<\!\(\*SuperscriptBox[\(Br\), \(-\)]\)\>\""}],
     ",", 
    RowBox[{"\"\<P\>\"", "\[Rule]", "\"\<HOBr\>\""}], ",", 
    RowBox[{
    "\"\<A\>\"", "\[Rule]", 
     "\"\<\!\(\*SuperscriptBox[SubscriptBox[\(BrO\), \(3\)], \(-\)]\)\>\""}], 
    ",", 
    RowBox[{
    "\"\<Z\>\"", "\[Rule]", 
     "\"\<\!\(\*SuperscriptBox[\(Ce\), \(\(4\)\(+\)\)]\)\>\""}], ",", 
    RowBox[{
    "\"\<M\>\"", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(CH\), \(2\)]\)(COOH\!\(\*SubscriptBox[\()\), \
\(2\)]\)\>\""}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7140173810735884`*^9, 3.7140174941720657`*^9}, {
  3.7301868569407563`*^9, 
  3.730186861753266*^9}},ExpressionUUID->"74201a7f-f113-4bfb-951a-\
224e40e5951f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "2.3 An Extremely Rapid Introduction to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Section",
 CellChangeTimes->{{3.7140175150532646`*^9, 3.714017519530518*^9}, {
  3.714018875337161*^9, 3.7140188760762033`*^9}, {3.728797603323371*^9, 
  3.728797604057748*^9}},ExpressionUUID->"8b73e01d-2d7f-46e6-b530-\
462fc8862fae"],

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{"\"\<Sage\>\"", ",", "\"\<http://www.sagemath.org/\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.714017548835198*^9, 3.7140175624849777`*^9}, {
  3.7140176228434353`*^9, 
  3.714017625084565*^9}},ExpressionUUID->"64165d92-62b8-4a4e-ac84-\
30ddae8beb49"],

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<Spyder\>\"", ",", 
   "\"\<http://peterwittek.com/spyder-closer-to-a-mathematica-alternative.\
html\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.714017548835198*^9, 3.71401758993055*^9}, {
  3.714017818028612*^9, 
  3.714017820221739*^9}},ExpressionUUID->"d0ba9c68-4a10-4908-9477-\
42cb7f5c347d"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "JordanDecomposition", ",", "NMinimize", ",", "NonlinearModelFit", ",", 
   "InverseLaplaceTransform", ",", "Sin", ",", "ParametricNDSolve", ",", 
   "Plot", ",", "FindClusters", ",", "Manipulate"}], "*)"}]], "Input",Expressi\
onUUID->"e93b4964-1aa3-4eeb-8a94-9be88a61a8cf"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Concentrations", ",", "WeaklyReversibleQ", ",", "SimulationPlot"}],
   "*)"}]], "Input",ExpressionUUID->"0096bf5e-ab29-4a0a-9676-552a959db092"],

Cell[BoxData[
 RowBox[{"(*", "ArcTan", "*)"}]], "Input",ExpressionUUID->"3c46964f-011f-4663-8f37-35dd7267f972"],

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.709613386223614*^9, 
  3.7096134009854593`*^9}},ExpressionUUID->"31e18e3f-ba26-4877-9a54-\
6dcadd120916"],

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7140178754839067`*^9, 
  3.7140178799151573`*^9}},ExpressionUUID->"a36723ac-e864-48d1-adb8-\
3b91f9295671"],

Cell[CellGroupData[{

Cell["2.3.1 How to get help?", "Subsection",
 CellChangeTimes->{{3.714017902272436*^9, 3.714017906074654*^9}, {
  3.7140179421827216`*^9, 3.7140179467659855`*^9}, {3.7287976867297845`*^9, 
  3.7287976880110364`*^9}},ExpressionUUID->"7001d07c-6455-4aee-ae39-\
0e9804201762"],

Cell[BoxData[
 RowBox[{"?", "SocialMediaData"}]], "Input",
 CellChangeTimes->{{3.709613475754743*^9, 
  3.7096134757567425`*^9}},ExpressionUUID->"27c8d5e2-79ed-438b-b96d-\
b3520d6772e1"],

Cell[BoxData[
 RowBox[{"??", "SocialMediaData"}]], "Input",
 CellChangeTimes->{{3.709613475754743*^9, 3.7096134757567425`*^9}, {
  3.714017959511715*^9, 
  3.714017964870023*^9}},ExpressionUUID->"56293842-cfca-4b17-a1a9-\
f4dbca412488"],

Cell[BoxData[
 RowBox[{"?", "Parallel"}]], "Input",
 CellChangeTimes->{{3.7096134848352633`*^9, 
  3.7096134901685658`*^9}},ExpressionUUID->"e7b23247-f01e-4be8-ad51-\
b7290ff96e76"],

Cell[BoxData[
 RowBox[{"?", "*ocat*"}]], "Input",
 CellChangeTimes->{{3.7096134848352633`*^9, 
  3.7096134931357365`*^9}},ExpressionUUID->"3c2f0971-5781-4b36-8f90-\
33b03fb106f2"],

Cell[BoxData[
 RowBox[{"?", "*Plot*"}]], "Input",
 CellChangeTimes->{{3.7096135050894213`*^9, 
  3.7096135050924196`*^9}},ExpressionUUID->"76fd57f4-3164-48b6-b04b-\
acd1e922866a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "2.3.2 Where to get a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function?"
}], "Subsection",
 CellChangeTimes->{{3.7140179885733786`*^9, 3.714017997588895*^9}, {
  3.7287977101985807`*^9, 
  3.7287977117610826`*^9}},ExpressionUUID->"418dd874-20ce-46d0-8f78-\
78f91b6c7cb4"],

Cell[CellGroupData[{

Cell["VariationalMethods", "Subsubsection",
 CellChangeTimes->{{3.728797803073762*^9, 3.7287978059487667`*^9}, 
   3.730690668198572*^9},ExpressionUUID->"c459b24f-391b-478a-8a01-\
a5917c942421"],

Cell[BoxData[
 RowBox[{"<<", "VariationalMethods`"}]], "Input",
 CellChangeTimes->{{3.7096135254885883`*^9, 3.709613539597396*^9}, 
   3.728797793886244*^9},ExpressionUUID->"e92130f1-15a3-4dfd-9e7f-\
4d1543f6d678"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ANOVA", "Subsubsection",
 CellChangeTimes->{{3.7096135254885883`*^9, 3.7096135417264104`*^9}, 
   3.7306906717454576`*^9},ExpressionUUID->"b4713e57-e8fc-4367-8845-\
390eca436ec2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "[", "\"\<ANOVA`\>\"", "]"}], " "}]], "Input",
 CellChangeTimes->{{3.7096135664452095`*^9, 
  3.7096135891640043`*^9}},ExpressionUUID->"3e3624b6-06e9-41c6-9bd8-\
08ae288b2673"],

Cell[BoxData[
 RowBox[{"<<", "SymbolicC`"}]], "Input",
 CellChangeTimes->{{3.7096135664452095`*^9, 
  3.7096135759921017`*^9}},ExpressionUUID->"bc2f8b98-d2f3-4ec7-b8a5-\
9647d5a51c61"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ResonanceAbsorptionLines`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7096136078359146`*^9, 
  3.7096136078515406`*^9}},ExpressionUUID->"f3de6c5a-eb6c-480a-8c33-\
f277920bfb5c"],

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<\!\(\*StyleBox[\"CUDALink\",FontSlant->\"Italic\"]\) Overview\>\"", 
   ",", "\"\<http://reference.wolfram.com/language/CUDALink/tutorial/Overview.\
html\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7140180645747337`*^9, 
  3.7140181246581726`*^9}},ExpressionUUID->"1f4e341f-a630-44e1-8f14-\
066a5f4f81f5"],

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<SystemModeler\>\"", ",", 
   "\"\<https://www.youtube.com/watch?v=4yLw7vWe9PU\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7096136239296956`*^9, 3.7096136239296956`*^9}, {
   3.7140181549929094`*^9, 3.7140181643684464`*^9}, 
   3.714018235960546*^9},ExpressionUUID->"c24cc613-0877-4644-95c4-\
6e7c63c47260"],

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<Optica\>\"", ",", 
   "\"\<https://www.wolfram.com/products/applications/optica/\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7096136323984623`*^9, 3.7096136323984623`*^9}, {
   3.7140181714978533`*^9, 3.7140181810164*^9}, 
   3.7140183380753927`*^9},ExpressionUUID->"4a4aa172-388d-4f04-92ee-\
80fccf88e6ff"],

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<ReplaceVariables\>\"", ",", 
   "\"\<http://library.wolfram.com/infocenter/TechNotes/4186/\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7096136406797285`*^9, 3.7096136406797285`*^9}, {
   3.7140181732529535`*^9, 3.7140181901079197`*^9}, 
   3.714018398112832*^9},ExpressionUUID->"bb38f6e3-5458-4aed-b931-\
aa116b1bd73d"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4 First Steps with the Package", "Section",
 CellChangeTimes->{{3.7140185205528436`*^9, 3.7140185300923896`*^9}, {
  3.72879784335509*^9, 
  3.7287978575113688`*^9}},ExpressionUUID->"be513f2e-faae-4b6d-a35b-\
00b0be7adb41"],

Cell["For the preparatory steps see the part Preliminaries above.", "Text",
 CellChangeTimes->{{3.728797910886471*^9, 
  3.728797938058401*^9}},ExpressionUUID->"a9cb7fa3-d1a9-4006-b16f-\
7e47f64fb65d"],

Cell[CellGroupData[{

Cell["Palettes", "Subsubsection",
 CellChangeTimes->{{3.730437479473383*^9, 
  3.730437480942135*^9}},ExpressionUUID->"fcd9a7e1-77a1-44c1-a824-\
36dabd94a0a9"],

Cell[BoxData[
 RowBox[{"OpenReactionKineticsNamesPalette", "[", "]"}]], "Input",
 CellChangeTimes->{{3.7301994472116084`*^9, 
  3.7301994534599648`*^9}},ExpressionUUID->"cede5cd2-a282-45cb-b373-\
3d59f36e2c43"],

Cell[BoxData[
 RowBox[{"OpenReactionKineticsPalette", "[", "]"}]], "Input",
 CellChangeTimes->{{3.7304374871296463`*^9, 
  3.7304374962390404`*^9}},ExpressionUUID->"62ec1199-3634-4824-aec3-\
f55f59f42265"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some of the most important functions", "Subsubsection",
 CellChangeTimes->{{3.7304376392080708`*^9, 
  3.7304376469893355`*^9}},ExpressionUUID->"cac920a8-2363-4dc3-97dd-\
1e066b46f3c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"robertson", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<B\>\""}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\"\<B\>\""}], "\[Rule]", 
      RowBox[{
       RowBox[{"\"\<B\>\"", "+", "\"\<C\>\""}], "\[Rule]", 
       RowBox[{"\"\<A\>\"", "+", "\"\<C\>\""}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7096136753985467`*^9, 3.7096136753985467`*^9}, {
  3.7096137749182153`*^9, 3.7096137936352863`*^9}, {3.7140185969412184`*^9, 
  3.714018608283868*^9}},ExpressionUUID->"98ceeca0-e4c0-4049-9094-\
033963ea15ce"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", "robertson", "}"}], "]"}], "[", 
  RowBox[{"\"\<species\>\"", ",", "\"\<M\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7096136850079403`*^9, 3.7096136850079403`*^9}, {
  3.7140185731408544`*^9, 
  3.714018586034593*^9}},ExpressionUUID->"0bd68ef3-a6dc-4128-b0d8-\
6e218f1a3e84"],

Cell[BoxData[
 RowBox[{"robertson2", "=", 
  RowBox[{"GetReaction", "[", "\"\<Robertson\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.709613696070462*^9, 3.7096137197736335`*^9}, {
  3.7287981329337816`*^9, 
  3.7287981370900393`*^9}},ExpressionUUID->"514d2f9d-a98f-4e25-af83-\
40e5c029147f"],

Cell[BoxData[
 RowBox[{"lotkavolterra", "=", 
  RowBox[{"GetReaction", "[", "\"\<Lotka-Volterra\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.7096137157580004`*^9, 3.7096137157580004`*^9}, 
   3.7096138488024464`*^9, 
   3.728798196496406*^9},ExpressionUUID->"a190ead0-c58f-4791-9c16-\
22772da24dac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{
    RowBox[{"{", "lotkavolterra", "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"A", ",", "B"}], "}"}]}], "]"}], "[", 
  RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "M", ",", "R"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7096137363205404`*^9, 3.7096137363205404`*^9}, {
  3.7096138119803376`*^9, 
  3.709613839738927*^9}},ExpressionUUID->"74344a7a-778a-49e0-880d-\
3eeb9ad9a2f5"],

Cell[BoxData[
 RowBox[{"Information", "[", "\"\<ReactionKinetics`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.709613748758065*^9, 
  3.709613748758065*^9}},ExpressionUUID->"ebf18895-8055-4339-8dc2-\
3a2263d48d43"],

Cell[BoxData["Reactions"], "Input",
 CellChangeTimes->{{3.718720300050515*^9, 3.7187203165349183`*^9}, {
  3.729403007874382*^9, 
  3.729403036811939*^9}},ExpressionUUID->"5ac6aa46-1607-4af7-a5da-\
6763fe6d0be5"],

Cell[BoxData["Models"], "Input",
 CellChangeTimes->{{3.7301872016758056`*^9, 
  3.730187202660184*^9}},ExpressionUUID->"e473a054-061e-45bb-ae06-\
7a374397c37d"],

Cell[BoxData[
 RowBox[{"FilterReactions", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Triangle\>\"", "}"}], ",", 
   RowBox[{"{", "\"\<A\>\"", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.730609518145456*^9},ExpressionUUID->"ce4669f9-8bda-4c25-bc2c-\
ea01c1a23b9e"],

Cell[BoxData[
 RowBox[{"ToReversible", "[", 
  RowBox[{"{", "\"\<Triangle\>\"", "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.730186895003332*^9, 3.7301869089721084`*^9}, 
   3.730609521501649*^9},ExpressionUUID->"2e59902b-35de-482d-8ed7-\
2e2b505bcc39"],

Cell[BoxData[
 RowBox[{"DeleteAutocatalysis", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"0", "\[Rule]", "\"\<X\>\""}], ",", 
    RowBox[{"\"\<X\>\"", "\[Rule]", 
     RowBox[{"2", "\"\<X\>\""}]}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.730186915597121*^9, 
  3.7301869457846804`*^9}},ExpressionUUID->"4e13e6bd-3282-47fe-aeb6-\
e6c368c16aba"],

Cell[BoxData[
 RowBox[{"WeaklyReversibleQ", "[", 
  RowBox[{"{", "\"\<Triangle\>\"", "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7301869635034647`*^9, 3.730186980659748*^9}, 
   3.730609530913186*^9},ExpressionUUID->"a3a79730-8033-4d27-b6f8-\
fd0b338257d8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "\"\<Robertson\>\"", "}"}], "]"}], "[", 
    RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.730437801974013*^9, 3.730437831145944*^9}, 
   3.730437867681534*^9},ExpressionUUID->"16864b89-66d0-418d-b284-\
445cb29c9880"],

Cell[BoxData[
 RowBox[{"FromStoichiometry", "[", 
  RowBox[{"\[Alpha]", ",", "\[Beta]", ",", 
   RowBox[{"{", 
    RowBox[{"A", ",", "B", ",", "C"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7301869862066355`*^9, 3.7301870476755023`*^9}, {
  3.7304378366459565`*^9, 
  3.7304378588221416`*^9}},ExpressionUUID->"d138b7d1-1b1f-49cb-9b4e-\
96d2574bd147"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphs of reactions", "Title",
 CellChangeTimes->{{3.709556593460801*^9, 3.709556594820179*^9}, {
  3.718720407738221*^9, 
  3.7187204092538505`*^9}},ExpressionUUID->"90b20476-3cbe-4c1a-96fd-\
c1be0fc54506"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"2de6aa78-1951-4329-a7a0-\
ec1c55d35b29"],

Cell[CellGroupData[{

Cell["Fig. 3.1", "Subsubsection",
 CellChangeTimes->{{3.612174318979169*^9, 3.612174328953739*^9}, {
   3.718720435800776*^9, 3.7187204435195413`*^9}, 3.718720513954441*^9, {
   3.7286436098379745`*^9, 
   3.728643638744281*^9}},ExpressionUUID->"a440f012-1553-412f-9520-\
d0142793eb8e"],

Cell[BoxData[
 RowBox[{"gyorgyifield", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Belousov-Zhabotinsky\>\"", "}"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.612174149911499*^9, 3.612174176489019*^9}, {
  3.612174273869589*^9, 3.6121742815970306`*^9}, {3.7140190412546635`*^9, 
  3.7140190418296986`*^9}},ExpressionUUID->"df199375-5dd0-4208-b7c1-\
d14480779cf7"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.1\>\"", ",", "gyorgyifield"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6349101671978645`*^9, 3.634910180721638*^9}, {
  3.6349102176947527`*^9, 3.634910221049945*^9}, {3.7284803563601027`*^9, 
  3.7284803708459315`*^9}},ExpressionUUID->"986b756e-a544-48ca-bf2d-\
b2fadc6aefc1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.2", "Subsubsection",
 CellChangeTimes->{{3.6121745133192844`*^9, 3.6121745209877234`*^9}, {
   3.71872051726663*^9, 3.718720517674653*^9}, 
   3.7286436453224196`*^9},ExpressionUUID->"50a9d85d-fd72-4603-aafe-\
bbf2ce6e177f"],

Cell[BoxData[
 RowBox[{"irrevtriangle", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Triangle\>\"", "}"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.550478828719098*^9, 3.550478861247904*^9}, {
   3.612174533647447*^9, 3.612174534885518*^9}, 3.612174576076874*^9, {
   3.7140190777797537`*^9, 3.7140190784517937`*^9}, 
   3.7306095404687333`*^9},ExpressionUUID->"a9d70427-1fd8-40b1-82c5-\
0770c4cb3a07"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.2\>\"", ",", "irrevtriangle"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.612174548508297*^9, 3.612174552628533*^9}, {
  3.6349103024496007`*^9, 3.634910315856367*^9}, {3.7284804455202074`*^9, 
  3.728480453765681*^9}},ExpressionUUID->"e403619d-06cc-4ae8-a8e3-\
2d444ee40224"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.3", "Subsubsection",
 CellChangeTimes->{{3.634886308868246*^9, 3.634886313846531*^9}, {
   3.718720537802806*^9, 3.718720540841984*^9}, 
   3.7286436497443027`*^9},ExpressionUUID->"73e48c27-d266-456a-8ea8-\
904d27e5e3ca"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bzdata", "=", 
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Belousov-Zhabotinsky\>\"", "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{"transitiveclosure", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"EdgeList", "[", 
      RowBox[{"TransitiveClosureGraph", "[", 
       RowBox[{"Graph", "[", 
        RowBox[{"bzdata", "[", "\"\<fhjgraphedges\>\"", "]"}], "]"}], "]"}], 
      "]"}], "/.", 
     RowBox[{"DirectedEdge", "\[Rule]", "Rule"}]}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"Method", "->", "\"\<CircularEmbedding\>\""}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.634884934436633*^9, 3.634884973696879*^9}, {
   3.6348850805419903`*^9, 3.6348850951148233`*^9}, {3.7109203915314865`*^9, 
   3.7109204317577868`*^9}, {3.7109204720790977`*^9, 3.7109204722011046`*^9}, 
   3.728646165082038*^9, {3.73018723914463*^9, 3.7301872398790054`*^9}, {
   3.73096836957918*^9, 
   3.730968379436745*^9}},ExpressionUUID->"5831caf3-7240-4319-99b3-\
e7e9b128b502"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.3\>\"", ",", "transitiveclosure"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.61217425745965*^9, 3.612174268260268*^9}, {
   3.612174306500455*^9, 3.61217431113172*^9}, {3.6348860458092003`*^9, 
   3.6348860797131395`*^9}, {3.6348861420637054`*^9, 
   3.6348861541283956`*^9}, {3.6348862771304307`*^9, 3.634886288811099*^9}, {
   3.634910270717786*^9, 3.6349102871587257`*^9}, {3.71007258702636*^9, 
   3.710072597007928*^9}, 3.7109214098898015`*^9, {3.728480498407239*^9, 
   3.7284805023904667`*^9}, {3.7284819889637613`*^9, 
   3.728481992979397*^9}},ExpressionUUID->"13932ef2-27d2-4b1c-a839-\
f5cd7c21aafe"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.4", "Subsubsection",
 CellChangeTimes->{
  3.6121769570600395`*^9, {3.718720750796003*^9, 3.7187207528761225`*^9}, 
   3.728643654634937*^9},ExpressionUUID->"c38c9b86-f2d6-44ab-863b-\
77f9cd858371"],

Cell[BoxData[
 RowBox[{"robertsonFHJ", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Robertson\>\"", "}"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.550478828719098*^9, 3.550478861247904*^9}, {
   3.612174533647447*^9, 3.612174534885518*^9}, 3.612174576076874*^9, 
   3.612177527351241*^9, {3.6121775584888954`*^9, 3.6121775602516985`*^9}, {
   3.714019593968315*^9, 
   3.7140195951013803`*^9}},ExpressionUUID->"63430af3-78ba-444f-b7f8-\
88b9bce71858"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.4\>\"", ",", "robertsonFHJ"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.612177015513342*^9, 3.6121770200373497`*^9}, {
  3.6349104168761454`*^9, 3.6349104300839005`*^9}, {3.7284805563220944`*^9, 
  3.728480582509646*^9}},ExpressionUUID->"c04b5715-e6ad-4ed4-8e1c-\
c84da8357acc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.5", "Subsubsection",
 CellChangeTimes->{{3.634910655863815*^9, 3.634910659091999*^9}, {
   3.7187207629877005`*^9, 3.718720763714743*^9}, 
   3.728643658759946*^9},ExpressionUUID->"9dc315a5-4d2f-4470-b7f6-\
aeba2db5b860"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fh", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<G\>\"", "\[LeftArrow]", 
     RowBox[{"2", "\"\<J\>\""}], "\[LeftRightArrow]", "\"\<H\>\"", 
     "\[LeftArrow]", " ", "\"\<G\>\"", "\[LeftArrow]", 
     RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], " ", "\[LeftRightArrow]", " ", 
     "\"\<C\>\"", " ", "\[RightArrow]", " ", 
     RowBox[{"\"\<D\>\"", "+", "\"\<E\>\""}], " ", "\[LeftRightArrow]", " ", 
     "\"\<F\>\""}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.634908926680911*^9, 3.6349090868700733`*^9}, 
   3.635138280078066*^9, 
   3.7096146372366867`*^9},ExpressionUUID->"c51a4e56-8326-4a0e-95cd-\
fbbb3fc1560b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", "fh", "]"}], "[", 
  "\"\<fhjweaklyconnectedcomponents\>\"", "]"}]], "Input",ExpressionUUID->\
"0e98d3df-14e7-4de4-974f-60dfdc5897dc"],

Cell[BoxData[
 RowBox[{"weakly", "=", 
  RowBox[{"First", "@", 
   RowBox[{"First", "@", 
    RowBox[{
     RowBox[{"ReactionsData", "[", "fh", "]"}], "[", 
     "\"\<fhjweaklyconnectedcomponents\>\"", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.634909093402447*^9, 3.634909173330019*^9}, {
  3.7100728965100813`*^9, 
  3.710072896695094*^9}},ExpressionUUID->"0584a64b-719a-45fc-9c7d-\
409e99394835"],

Cell[BoxData[
 RowBox[{"fhweakly", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", "weakly", "}"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "500"}], ",", 
    RowBox[{"VertexLabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "24"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6349092263780527`*^9, 3.6349092420569496`*^9}, {
  3.6349093363593435`*^9, 3.6349093494220905`*^9}, {3.6349100005533333`*^9, 
  3.6349100047295723`*^9}, {3.710072902722434*^9, 3.710072904124518*^9}, {
  3.714019628287281*^9, 3.714019628781308*^9}, {3.7140472788587327`*^9, 
  3.7140473628845434`*^9}, {3.715087050717965*^9, 
  3.715087052072042*^9}},ExpressionUUID->"69e7b158-85b8-46ce-b76a-\
48aec8734e20"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.5\>\"", ",", "fhweakly"}], "]"}]], "Input",
 CellChangeTimes->{{3.6349106775330544`*^9, 3.6349106953640738`*^9}, {
  3.728480639259756*^9, 
  3.728480654916038*^9}},ExpressionUUID->"8a126430-121e-4675-9d65-\
a68820685707"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.6", "Subsubsection",
 CellChangeTimes->{{3.634910665643374*^9, 3.6349106714917088`*^9}, {
   3.718720826842358*^9, 3.7187208275703993`*^9}, 
   3.7286436644943314`*^9},ExpressionUUID->"43737555-5270-47b0-b532-\
0a803b75c9f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", "fh", "]"}], "[", 
  "\"\<fhjstronglyconnectedcomponents\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.6349093714613514`*^9, 
  3.6349093932535973`*^9}},ExpressionUUID->"e1efd8cd-6b7e-4247-9253-\
1d6725f1b575"],

Cell[BoxData[
 RowBox[{"strongly", "=", 
  RowBox[{"First", "/@", 
   RowBox[{
    RowBox[{"ReactionsData", "[", "fh", "]"}], "[", 
    "\"\<fhjstronglyconnectedcomponents\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6349093960297565`*^9, 3.634909452981014*^9}, {
  3.634909493609338*^9, 
  3.6349094967775187`*^9}},ExpressionUUID->"01834079-2fbd-4d4d-86c5-\
91e1870a4084"],

Cell[BoxData[
 RowBox[{"fhstrongly", "=", 
  RowBox[{"Column", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ShowFHJGraph", "[", 
      RowBox[{
       RowBox[{"{", "#", "}"}], ",", 
       RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
       RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}], "&"}], "/@", 
    "strongly"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.634909514794549*^9, 3.6349096132331796`*^9}, {
   3.634909991200798*^9, 3.6349099947229996`*^9}, 3.709614912363945*^9, 
   3.7096149468952627`*^9, {3.7140474293323493`*^9, 3.714047453962759*^9}, {
   3.718720852978859*^9, 3.7187208661926117`*^9}, {3.7187209486723375`*^9, 
   3.718720948950351*^9}, {3.718720988638625*^9, 3.7187210036704855`*^9}, {
   3.7187210722124133`*^9, 
   3.718721156736075*^9}},ExpressionUUID->"790aec4e-6fdf-439c-9117-\
fbdcb28ca078"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.6\>\"", ",", "fhstrongly"}], "]"}]], "Input",
 CellChangeTimes->{{3.634910755239499*^9, 3.634910769195297*^9}, 
   3.7100729558034763`*^9, 3.7140196791441913`*^9, 3.7187226399846087`*^9, {
   3.728480722447419*^9, 
   3.7284807416349573`*^9}},ExpressionUUID->"80ceec5a-7198-46cf-b5a0-\
0d11afa47b7c"],

Cell[BoxData[
 RowBox[{"terminal", "=", 
  RowBox[{"First", "/@", 
   RowBox[{
    RowBox[{"ReactionsData", "[", "fh", "]"}], "[", 
    "\"\<fhjterminalstronglyconnectedcomponents\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6349096553325877`*^9, 
  3.6349096805490303`*^9}},ExpressionUUID->"a6c8847b-8e96-428d-a224-\
32fb07f80e6b"],

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ShowFHJGraph", "[", 
     RowBox[{
      RowBox[{"{", "#", "}"}], ",", 
      RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
      RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}], "&"}], "/@", 
   "terminal"}], "]"}]], "Input",
 CellChangeTimes->{{3.634909699682124*^9, 3.634909703523344*^9}, {
   3.7096149284264765`*^9, 3.7096149295046034`*^9}, {3.7140196686555915`*^9, 
   3.7140196695856466`*^9}, 3.718720881170472*^9, {3.7187212080018005`*^9, 
   3.718721209251804*^9}},ExpressionUUID->"37b2f44c-c344-4dbf-83b8-\
278bf707c1fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.7", "Subsubsection",
 CellChangeTimes->{{3.612179657475954*^9, 3.612179675516986*^9}, {
   3.7100734009479675`*^9, 3.71007340168701*^9}, {3.7187212200487003`*^9, 
   3.7187212267674637`*^9}, 
   3.7286436709162197`*^9},ExpressionUUID->"126f8e61-f1f5-40c4-ba61-\
4c850038fc9e"],

Cell[BoxData[
 RowBox[{"sm", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Petri\>\"", "}"}], "]"}], "[", 
   RowBox[{"\"\<species\>\"", ",", "\"\<complexes\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7187214600022945`*^9, 3.7187214814554605`*^9}, {
  3.7187215397524495`*^9, 3.718721570221259*^9}, {3.7301872868478465`*^9, 
  3.7301873177385335`*^9}},ExpressionUUID->"bc4c0dfc-8d68-4cdf-8b24-\
c2ac78ff4319"],

Cell[BoxData[
 RowBox[{"petriV", "=", 
  RowBox[{
   RowBox[{"ShowVolpertGraph", "[", 
    RowBox[{
     RowBox[{"{", "\"\<Petri\>\"", "}"}], ",", 
     RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "500"}], ",", 
     RowBox[{"Method", "->", "\"\<SpringEmbedding\>\""}], ",", 
     RowBox[{"Indexed", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(CO\), \(2\)]\)\>\"", ",", "\"\<NaOH\>\"", 
        ",", "\"\<\!\(\*SubscriptBox[\(O\), \(2\)]\)\>\""}], "}"}]}]}], "]"}],
    "/.", 
   RowBox[{"format", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", "sm", "]"}], ",", "Bold", ",", "12"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.718721484830467*^9, 3.718721528049303*^9}, {
   3.7187215733306403`*^9, 3.7187216108932133`*^9}, {3.7187216929402494`*^9, 
   3.7187217006121387`*^9}, 3.730187338597947*^9, {3.730187401363697*^9, 
   3.7301874071762085`*^9}, {3.730891899687025*^9, 3.7308919606871443`*^9}, {
   3.730892015374752*^9, 
   3.7308920624685946`*^9}},ExpressionUUID->"2ad68830-443b-4701-ac1c-\
1fff164f8e18"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.7\>\"", ",", "petriV"}], "]"}]], "Input",
 CellChangeTimes->{{3.612179701452469*^9, 3.612179712669111*^9}, {
   3.635347120211646*^9, 3.6353471297941947`*^9}, {3.710073513436412*^9, 
   3.710073519984785*^9}, {3.728480826057001*^9, 3.728480843619531*^9}, 
   3.7284814092710176`*^9},ExpressionUUID->"5db78fbf-af57-4c4a-8408-\
c5b187ae420f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.8", "Subsubsection",
 CellChangeTimes->{{3.612181238930009*^9, 3.612181240841118*^9}, {
   3.7187217233934336`*^9, 3.7187217255809383`*^9}, 
   3.7286436753537283`*^9},ExpressionUUID->"1c76a83d-66ea-486f-9923-\
ba7469e43d4d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"alias", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
     "\"\<A\>\"", "\[Rule]", 
      "\"\<\!\(\*SubscriptBox[\(CH\), \(2\)]\)(COOH\!\(\*SubscriptBox[\()\), \
\(2\)]\)\>\""}], ",", 
     RowBox[{
     "\"\<B\>\"", "\[Rule]", 
      "\"\<\!\(\*SubsuperscriptBox[\(BrO\), \(3\), \(-\)]\)\>\""}], ",", 
     RowBox[{
     "\"\<H\>\"", "\[Rule]", "\"\<\!\(\*SuperscriptBox[\(H\), \(+\)]\)\>\""}],
      ",", 
     RowBox[{
     "\"\<M\>\"", "\[Rule]", 
      "\"\<CHBr(COOH\!\(\*SubscriptBox[\()\), \(2\)]\)\>\""}], ",", 
     RowBox[{"\"\<P\>\"", "\[Rule]", "\"\<HCOOH\>\""}], ",", 
     RowBox[{
     "\"\<Q\>\"", "\[Rule]", "\"\<\!\(\*SubscriptBox[\(CO\), \(2\)]\)\>\""}], 
     ",", 
     RowBox[{
     "\"\<S\>\"", "\[Rule]", "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)O\>\""}], 
     ",", 
     RowBox[{"\"\<T\>\"", "\[Rule]", "\"\<HOBr\>\""}], ",", 
     RowBox[{
     "\"\<U\>\"", "\[Rule]", "\"\<\!\(\*SubscriptBox[\(BrO\), \(2\)]\)\>\""}],
      ",", 
     RowBox[{
     "\"\<W\>\"", "\[Rule]", "\"\<\!\(\*SubscriptBox[\(Br\), \(2\)]\)\>\""}], 
     ",", 
     RowBox[{
     "\"\<X\>\"", "\[Rule]", 
      "\"\<\!\(\*SubscriptBox[\(HBrO\), \(2\)]\)\>\""}], ",", 
     RowBox[{
     "\"\<Y\>\"", "\[Rule]", 
      "\"\<\!\(\*SuperscriptBox[\(Br\), \(-\)]\)\>\""}], ",", 
     RowBox[{"\"\<Z\>\"", "\[Rule]", "\"\<Ce(IV)\>\""}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7100736863573136`*^9, 3.7100737004301186`*^9}, {
   3.7100737835258784`*^9, 3.7100739161514716`*^9}, {3.7100739481333036`*^9, 
   3.710074004682542*^9}, 3.7140262398679028`*^9, {3.7187218722999735`*^9, 
   3.71872191337818*^9}},ExpressionUUID->"831e9c09-fa06-48df-9aab-\
7dbdefd33089"],

Cell[BoxData[
 RowBox[{"sm", "=", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"ReactionsData", "[", 
      RowBox[{"{", "\"\<Clarke\>\"", "}"}], "]"}], "[", 
     RowBox[{"\"\<species\>\"", ",", "\"\<complexes\>\""}], "]"}], "]"}], "/.",
    "alias"}]}]], "Input",
 CellChangeTimes->{{3.522078648464734*^9, 3.522078665892731*^9}, {
  3.7187219160500603`*^9, 3.7187219258000803`*^9}, {3.7187220270190277`*^9, 
  3.7187220695816126`*^9}, {3.7187221664255495`*^9, 3.7187222125975156`*^9}, {
  3.7301874370668907`*^9, 
  3.73018745694193*^9}},ExpressionUUID->"bc5250b7-8938-4c72-8132-\
9b2a70c92540"],

Cell[BoxData[
 RowBox[{"clarkeV", "=", 
  RowBox[{
   RowBox[{"ShowVolpertGraph", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"GetReaction", "[", 
       RowBox[{"{", "\"\<Clarke\>\"", "}"}], "]"}], "/.", "alias"}], ",", 
     RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
     RowBox[{"EdgeLabeling", "\[Rule]", "False"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
     RowBox[{"Numbered", "\[Rule]", "True"}]}], "]"}], "/.", 
   RowBox[{"format", "[", 
    RowBox[{"sm", ",", "Bold", ",", "12"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.522078445806143*^9, 3.5220785153831224`*^9}, {
   3.6121812791143074`*^9, 3.612181307280918*^9}, {3.612181404774494*^9, 
   3.6121814158771296`*^9}, {3.6121814735884304`*^9, 3.612181524474341*^9}, {
   3.6121817113060274`*^9, 3.6121817119870663`*^9}, {3.6353471784439774`*^9, 
   3.6353472078016567`*^9}, {3.6353472431756797`*^9, 3.6353472715113*^9}, {
   3.708064629663352*^9, 3.708064671335307*^9}, 3.710074368244364*^9, {
   3.710074563200529*^9, 3.71007456392957*^9}, {3.718722078066003*^9, 
   3.718722142175504*^9}, {3.730187474145089*^9, 
   3.7301875430045986`*^9}},ExpressionUUID->"a92b7a76-2f03-4688-b57c-\
454a6e52fad2"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.8\>\"", ",", "clarkeV"}], "]"}]], "Input",
 CellChangeTimes->{{3.612181685989579*^9, 3.6121816957961397`*^9}, {
  3.6353472889903*^9, 3.6353472970937634`*^9}, {3.728480860275814*^9, 
  3.7284808741664677`*^9}},ExpressionUUID->"98a279c9-f335-4038-a454-\
18b44632be74"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.9", "Subsubsection",
 CellChangeTimes->{{3.708065317774069*^9, 3.708065323883458*^9}, {
   3.7187222483788357`*^9, 3.718722249050712*^9}, 
   3.7286436859318733`*^9},ExpressionUUID->"e6a4a06a-0e28-49ad-b513-\
ec08f5c0c3dd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"labels", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<2B\>\"", ",", "\"\<B+C\>\"", ",", "\"\<B\>\"", ",", "\"\<A+C\>\"", 
     ",", "\"\<A\>\""}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"i", "=", "1"}], ";"}], "\n", 
 RowBox[{"SCLRobertson", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
      "\"\<B\>\"", "\[UndirectedEdge]", 
       "\"\<\!\(\*SubscriptBox[\(L\), \(1\)]\)\>\""}], ",", 
      RowBox[{
      "\"\<B\>\"", "\[UndirectedEdge]", 
       "\"\<\!\(\*SubscriptBox[\(L\), \(1\)]\)\>\""}], ",", 
      RowBox[{
      "\"\<B\>\"", "\[UndirectedEdge]", 
       "\"\<\!\(\*SubscriptBox[\(L\), \(2\)]\)\>\""}], ",", 
      RowBox[{
      "\"\<A\>\"", "\[UndirectedEdge]", 
       "\"\<\!\(\*SubscriptBox[\(L\), \(1\)]\)\>\""}], ",", 
      RowBox[{
      "\"\<A\>\"", "\[UndirectedEdge]", 
       "\"\<\!\(\*SubscriptBox[\(L\), \(2\)]\)\>\""}]}], "}"}], ",", 
    RowBox[{"EdgeShapeFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"labels", "[", 
            RowBox[{"[", 
             RowBox[{"i", "++"}], "]"}], "]"}], ",", 
           RowBox[{"Mean", "@", "#"}]}], "]"}], ",", 
         RowBox[{"Line", "@", "#"}]}], "}"}], "&"}], ")"}]}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", "\"\<SpringEmbedding\>\""}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.7080889619794493`*^9, 3.7080889619794493`*^9}, {
   3.708089002807654*^9, 3.7080891455891843`*^9}, {3.7080891821361313`*^9, 
   3.708089214229944*^9}, 3.708145108041193*^9, {3.709615438443098*^9, 
   3.709615438771224*^9}, {3.7100746374187765`*^9, 
   3.7100746710707026`*^9}},ExpressionUUID->"8d784ebe-a1ec-4f47-ad95-\
76e5015625de"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.708088430487726*^9, 
  3.7080884478147182`*^9}},ExpressionUUID->"bf06e64a-aca9-408e-a260-\
768f9716dbeb"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.9\>\"", ",", "SCLRobertson"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7080662786665754`*^9, 3.7080662893540964`*^9}, {
  3.7100746047099032`*^9, 3.7100746068940287`*^9}, {3.710074688282689*^9, 
  3.710074690279804*^9}, {3.7284809395572195`*^9, 
  3.728480955213501*^9}},ExpressionUUID->"884ed2e5-3eb8-43fb-a858-\
5b26d65e9aa8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.10", "Subsubsection",
 CellChangeTimes->{
  3.7097236178680196`*^9, {3.7187222638007402`*^9, 3.7187222792538977`*^9}, 
   3.728643691603759*^9},ExpressionUUID->"9a8f53bd-7113-4386-ad06-\
281cad48e430"],

Cell[BoxData[
 RowBox[{
  RowBox[{"edelstein", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"X", "\[DoubleLeftRightArrow]", 
      RowBox[{"2", "X"}]}], ",", 
     RowBox[{
      RowBox[{"X", "+", "Y"}], "\[DoubleLeftRightArrow]", "Z", 
      "\[DoubleLeftRightArrow]", "Y"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7097231726796474`*^9, 
  3.7097232538829327`*^9}},ExpressionUUID->"510322c5-8ef4-4ef5-89bc-\
74cfcc53ee7f"],

Cell[BoxData[
 RowBox[{"edelsteincomplexes", "=", 
  RowBox[{
   RowBox[{"GraphPlot", "[", 
    RowBox[{
     RowBox[{"Flatten", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<X\>\"", "\[Rule]", "\"\< 0 \>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\< X \>\"", "\[Rule]", "\"\< X \>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<  X  \>\"", "\[Rule]", "\"\<Y\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<Z\>\"", "\[Rule]", "\"\<0\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\< Y \>\"", "\[Rule]", "\"\<  0  \>\""}], "}"}]}], 
       "}"}]}], ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}], "/.", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ReactionsData", "[", 
       RowBox[{"Flatten", "@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<X\>\"", "\[Rule]", "\"\< 0 \>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\"\< X \>\"", "\[Rule]", "\"\< X \>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\"\<  X  \>\"", "\[Rule]", "\"\<Y\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\"\<Z\>\"", "\[Rule]", "\"\<0\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\"\< Y \>\"", "\[Rule]", "\"\<  0  \>\""}], "}"}]}], 
         "}"}]}], "]"}], "[", "\"\<species\>\"", "]"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<X\>\"", ",", "\"\<0\>\"", ",", "\"\<X\>\"", ",", "\"\<Y\>\"", ",", 
       "\"\<Z\>\"", ",", "\"\<Y\>\"", ",", "\"\<0\>\""}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7100785455025787`*^9, 3.7100785717210803`*^9}, {
  3.7100786482074594`*^9, 
  3.7100786800072794`*^9}},ExpressionUUID->"31368b24-83d3-4f50-9ca0-\
11de9729084f"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.10\>\"", ",", "edelsteincomplexes"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.709723499320917*^9, 3.7097235072896786`*^9}, {
   3.7100746138474255`*^9, 3.710074614220448*^9}, 3.7100786924639945`*^9, {
   3.728481040869917*^9, 
   3.7284810539793186`*^9}},ExpressionUUID->"750616a0-9671-43be-8eb1-\
cffa11cfbad8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.11", "Subsubsection",
 CellChangeTimes->{{3.635344605684824*^9, 3.6353446082689714`*^9}, {
   3.7187222928476725`*^9, 3.718722294160177*^9}, 
   3.72864369691627*^9},ExpressionUUID->"44497e00-c924-40c7-a0b5-\
ebbbed7e1185"],

Cell[BoxData[
 RowBox[{"complexgraphedelstein", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Z", "\[Rule]", "0"}], ",", 
      RowBox[{"0", "\[Rule]", "X"}], ",", 
      RowBox[{"0", "\[Rule]", "Y"}], ",", 
      RowBox[{"X", "\[Rule]", "Y"}], ",", "\[IndentingNewLine]", 
      RowBox[{"X", "\[Rule]", "X"}]}], "}"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.635345051922347*^9, 3.6353451242714853`*^9}, {
  3.709723304008031*^9, 
  3.7097233263986998`*^9}},ExpressionUUID->"0e76c4aa-d01f-468f-8bb8-\
70b3727e2f60"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig3.11\>\"", ",", "complexgraphedelstein"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6353451971976566`*^9, 3.6353451990037594`*^9}, {
  3.635345335449564*^9, 3.6353453446890926`*^9}, {3.6353453874005356`*^9, 
  3.635345389466654*^9}, {3.7284810764324875`*^9, 
  3.728481083104375*^9}},ExpressionUUID->"5502588d-d78c-406f-83bf-\
bca460eca7dd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"99dff737-c900-46c8-a40f-\
163a7939560d"],

Cell[CellGroupData[{

Cell["Remark 3.2", "Subsubsection",
 CellChangeTimes->{{3.729403168843447*^9, 
  3.7294031726403284`*^9}},ExpressionUUID->"2ae39465-1253-4dbc-9c73-\
1d4f17fe621a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"fhj", ",", "sm"}], "}"}], " ", "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "\"\<Belousov-Zhabotinsky\>\"", "}"}], "]"}], "[", 
    RowBox[{"\"\<fhjgraphedges\>\"", ",", "\"\<complexes\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7097239403652887`*^9, 3.7097239403672915`*^9}, {
   3.7097239891760855`*^9, 3.7097239907761755`*^9}, {3.7301876096766033`*^9, 
   3.730187610707855*^9}, {3.730187655848569*^9, 3.730187688176756*^9}, {
   3.7301877740050507`*^9, 3.7301877754581757`*^9}, 
   3.730437964400474*^9},ExpressionUUID->"b72523e6-dcf4-4fdf-be9d-\
51ad3a24f986"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", "fhj", "}"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}], "/.", 
  RowBox[{"format", "[", 
   RowBox[{"sm", ",", "Bold", ",", "12"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7097239628775797`*^9, 3.7097239628795795`*^9}, {
  3.7097239994236727`*^9, 3.709724012359413*^9}, {3.7301876304110174`*^9, 
  3.730187643411044*^9}, {3.730187691754889*^9, 3.7301876928017654`*^9}, {
  3.730187751583131*^9, 3.730187756880017*^9}, {3.730437971494238*^9, 
  3.730437971900489*^9}},ExpressionUUID->"ff1b2f6c-3d3c-459a-9f50-\
e8afe283dc07"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 3.4", "Subsubsection",
 CellChangeTimes->{{3.729403196202876*^9, 3.72940319867163*^9}, {
  3.7294033380937786`*^9, 
  3.729403342109411*^9}},ExpressionUUID->"d4d685c7-0b2f-417f-a8ff-\
109c41a98ffb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", "\"\<Robertson\>\"", "}"}], "]"}], "[", "\"\<deficiency\>\"", 
  "]"}]], "Input",
 CellChangeTimes->{{3.7118920655650253`*^9, 
  3.711892083844846*^9}},ExpressionUUID->"9ed65bb1-7c94-476b-be1e-\
812d17f1a795"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mass conservation", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 
  3.7096139310971584`*^9}},ExpressionUUID->"c8f7b3ed-c1ad-4e65-9c73-\
a5374b2656b2"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"79340305-ada1-47e2-a66a-\
3b96dc45e683"],

Cell[CellGroupData[{

Cell["Fig. 4.1", "Subsubsection",
 CellChangeTimes->{{3.7188644559440436`*^9, 3.71886445661592*^9}, 
   3.7286437035725336`*^9},ExpressionUUID->"84750d02-e6e0-49b1-a5f7-\
024977a2dc4b"],

Cell[BoxData[
 RowBox[{"simplex2d", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "x"}], "/", "2"}], "+", "5"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "7"}], ",", "13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "9"}], ",", "8"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Thick", ",", "Pink"}], "]"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}], ",", 
    RowBox[{"Prolog", "\[Rule]", 
     RowBox[{"First", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Red", ",", "Thick", ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"6", ",", "2"}], "}"}]}], "}"}], "]"}], ",", "Black", 
         ",", 
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"6", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<initial\\nconcentration\>\"", ",", "18"}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"8", ",", "3.7"}], "}"}]}], "]"}], ",", "Blue", ",", 
         "Thick", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "4"}], ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"8", ",", 
              RowBox[{"-", "4"}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<stoichiometric\\nsubspace\>\"", ",", "18"}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"8", ",", 
             RowBox[{"-", "6"}]}], "}"}]}], "]"}]}], "}"}], "]"}]}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.63551291494538*^9, 3.6355129188296022`*^9}, {
   3.6355129699655266`*^9, 3.6355132909688873`*^9}, {3.6355165654771786`*^9, 
   3.635516926293816*^9}, {3.635518316441328*^9, 3.635518334175342*^9}, {
   3.635742976392679*^9, 3.6357430070234313`*^9}, 3.6357431967372828`*^9, {
   3.7097266987475557`*^9, 3.7097267014663095`*^9}, {3.718864889741767*^9, 
   3.718864890257393*^9}, {3.7188657594309683`*^9, 3.7188658140717*^9}, {
   3.718866214119357*^9, 3.7188662316037645`*^9}, {3.718866298478897*^9, 
   3.7188662989945216`*^9}},ExpressionUUID->"ed96dfa1-f509-436c-95f7-\
eb9a6ab3622e"],

Cell[BoxData[
 RowBox[{"simplex2D", "=", 
  RowBox[{"GraphicsColumn", "[", 
   RowBox[{"{", 
    RowBox[{"simplex2d", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"White", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "7"}], ",", "11"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "13"}], "}"}]}], "]"}]}], "}"}], "]"}]}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7188658757436953`*^9, 3.718866035025257*^9}, {
  3.7188660833534765`*^9, 3.7188660849472303`*^9}, {3.7188661373067074`*^9, 
  3.7188661864318027`*^9}, {3.7188662635569534`*^9, 3.718866312541423*^9}, {
  3.718866363072775*^9, 3.718866363916525*^9}, {3.7188664517448215`*^9, 
  3.7188664696823587`*^9}},ExpressionUUID->"da701f49-d1c9-4a43-86cf-\
7ab0ace5127c"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig4.1A\>\"", ",", "simplex2D"}], "]"}]], "Input",
 CellChangeTimes->{{3.6355133014514866`*^9, 3.6355133020205193`*^9}, {
   3.7284843204924717`*^9, 3.7284843329751835`*^9}, 
   3.728484401601116*^9},ExpressionUUID->"248f33e1-4176-4563-b6a0-\
0dacd489fb56"],

Cell[BoxData[
 RowBox[{"simplex", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Opacity", "[", "0.7", "]"}], ",", "Blue", ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.5"}], ",", 
           RowBox[{"-", "1.5"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.5", ",", "1.5", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1.5", ",", 
           RowBox[{"-", "1.5"}]}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<stoichiometric\\nsubspace\>\"", ",", "18"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "1.5"}]}], "}"}]}], "]"}], ",", "Pink", ",", 
      RowBox[{"Triangle", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
      "Red", ",", "Thick", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{".66", ",", ".66", ",", ".66"}], "}"}]}], "}"}], "]"}], ",",
       "Black", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{".66", ",", ".66", ",", ".66"}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<initial\\nconcentration\>\"", ",", "18"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1.4", ",", "1.2"}], "}"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"Axes", "\[Rule]", "False"}], ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2."}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2."}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", "3"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"10", ",", 
       RowBox[{"-", "1.35"}], ",", "2"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.635517534672613*^9, 3.6355176142621655`*^9}, {
   3.6355176622569103`*^9, 3.635517901979622*^9}, {3.6355179397697835`*^9, 
   3.6355179994221954`*^9}, {3.635518145502551*^9, 3.6355182956641397`*^9}, {
   3.6355183520623655`*^9, 3.635518353063422*^9}, {3.635518429059769*^9, 
   3.6355184874281073`*^9}, {3.6355185232821584`*^9, 
   3.6355186367176466`*^9}, {3.6355186862934823`*^9, 3.635518698950206*^9}, {
   3.635519054881564*^9, 3.63551907369164*^9}, {3.6355191916143847`*^9, 
   3.6355192346368456`*^9}, {3.635519325816061*^9, 3.635519437559452*^9}, {
   3.6355279762501106`*^9, 3.635527984424525*^9}, {3.635528042472227*^9, 
   3.6355280896945095`*^9}, {3.6355281256525726`*^9, 3.635528136120191*^9}, {
   3.635528195947296*^9, 3.6355282958372717`*^9}, {3.6355283460391607`*^9, 
   3.635528460373761*^9}, {3.6355285019800344`*^9, 3.6355285102792487`*^9}, {
   3.6355285960793996`*^9, 3.6355285964226003`*^9}, {3.6355286718955326`*^9, 
   3.6355287129198074`*^9}, 3.635528803293766*^9, {3.635528904506744*^9, 
   3.635529020530549*^9}, {3.6357430192661314`*^9, 3.6357430457376456`*^9}, {
   3.635743148142503*^9, 3.635743159881174*^9}, {3.708169498935342*^9, 
   3.7081695130291204`*^9}, {3.7081697322639246`*^9, 3.708169846748523*^9}, {
   3.709727021404436*^9, 3.709727033060708*^9}, {3.710078951360823*^9, 
   3.7100789653196197`*^9}, {3.710079028362232*^9, 3.710079057366892*^9}, {
   3.710079111007967*^9, 3.7100793020279007`*^9}, {3.7100793635124264`*^9, 
   3.7100794097100687`*^9}, {3.7100794557147055`*^9, 3.710079505510555*^9}, {
   3.710079576952647*^9, 3.7100796721260962`*^9}, {3.7100797039229193`*^9, 
   3.7100797647904053`*^9}, {3.7188646005693274`*^9, 
   3.7188646014287033`*^9}, {3.718864645647541*^9, 3.7188646558663096`*^9}, {
   3.7188648555073247`*^9, 3.718864856304202*^9}, {3.7188649600231543`*^9, 
   3.7188649674919195`*^9}, {3.7188650468358254`*^9, 3.718865054788965*^9}, {
   3.7188650863984013`*^9, 3.718865132601617*^9}, {3.718865166898559*^9, 
   3.7188652028830037`*^9}, 3.718865603008788*^9, {3.718865652243258*^9, 
   3.718865677180807*^9}},ExpressionUUID->"dc0f1871-73b3-4fa0-92ee-\
5b3fe4c5585a"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig4.1B\>\"", ",", "simplex"}], "]"}]], "Input",
 CellChangeTimes->{{3.718864664366327*^9, 3.718864667272582*^9}, {
  3.728484466263818*^9, 
  3.728484489704161*^9}},ExpressionUUID->"c7c42884-a67b-413a-b8b0-\
903d9b3a09d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 4.2", "Subsubsection",
 CellChangeTimes->{{3.7188644681159425`*^9, 3.71886446869407*^9}, 
   3.7286437235256968`*^9},ExpressionUUID->"0d244654-6570-4f03-ab30-\
fe8a43574c4f"],

Cell[BoxData[
 RowBox[{"cone", "=", 
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "\[GreaterEqual]", 
      RowBox[{"x", "/", "2"}]}], "\[And]", 
     RowBox[{"y", "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"-", "2"}], "x"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"Frame", "\[Rule]", "None"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Arrowheads", "[", "Automatic", "]"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3.2"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", " ", "18"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.635589643472193*^9, 3.635589654531825*^9}, {
   3.635589899267823*^9, 3.635590012081276*^9}, {3.6355900486713686`*^9, 
   3.635590065969358*^9}, 3.635590116142228*^9, {3.635590298576662*^9, 
   3.6355904216447015`*^9}, {3.635590830256073*^9, 3.6355908320151734`*^9}, {
   3.635593617290482*^9, 3.6355936208266845`*^9}, {3.635593650867402*^9, 
   3.6355936892966003`*^9}},ExpressionUUID->"d28aa450-498d-4c60-baa5-\
42c1e6617e69"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig4.2A\>\"", ",", "cone"}], "]"}]], "Input",
 CellChangeTimes->{{3.635590837355479*^9, 3.635590846830021*^9}, {
  3.728484547863493*^9, 
  3.728484560120947*^9}},ExpressionUUID->"bf8436ff-50c3-4368-8f6a-\
192121829bab"],

Cell[BoxData[
 RowBox[{"cone3D", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"RegionPlot3D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"0", "\[LessEqual]", "x"}], "&&", 
       RowBox[{"0", "\[LessEqual]", "y"}], "&&", 
       RowBox[{"0", "\[LessEqual]", "z"}], "&&", 
       RowBox[{
        RowBox[{"x", "+", "y", "+", "z"}], "\[LessEqual]", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1.2"}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "3"}], ",", 
      RowBox[{"Boxed", "->", "False"}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.2", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.2", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1.2"}], "}"}]}], "}"}], "]"}]}], 
      "}"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6355906981085143`*^9, 3.6355907436191177`*^9}, {
  3.63559079681816*^9, 3.6355908211525517`*^9}, {3.635744653183586*^9, 
  3.6357449091832285`*^9}},
 CellID->29675792,ExpressionUUID->"9c8a9fd1-a5cf-49ef-ad1c-ebd3c6623ee4"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig4.2B\>\"", ",", "cone3D"}], "]"}]], "Input",
 CellChangeTimes->{{3.6357449131644564`*^9, 3.6357449235330496`*^9}, {
  3.7284845771834817`*^9, 
  3.7284845857147455`*^9}},ExpressionUUID->"6edf3da5-7c2d-4133-8818-\
8e1b2d172620"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"9b633dec-6c42-4676-a2ef-\
674ffff2b00e"],

Cell[CellGroupData[{

Cell["4.1 Preliminaries", "Subchapter",
 CellChangeTimes->{{3.7141008559805503`*^9, 3.714100861140577*^9}, {
  3.728798675953223*^9, 
  3.728798677000101*^9}},ExpressionUUID->"631934b4-6c1a-4d1d-983e-\
5483c07c30d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<X\>\""}], "\[Rule]", 
      RowBox[{"2", "\"\<X\>\""}]}], "}"}], ",", 
    RowBox[{"{", "\"\<A\>\"", "}"}]}], "]"}], "[", 
  RowBox[{
  "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<\[Alpha]\>\"", ",", 
   "\"\<\[Beta]\>\"", ",", "\"\<species\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7141008717246294`*^9, 3.7141009542970324`*^9}, {
  3.730696944013505*^9, 
  3.7306969530760217`*^9}},ExpressionUUID->"ad015f9b-1f23-45bc-ad85-\
9ccea4eced64"],

Cell[CellGroupData[{

Cell["Example 4.1", "Subsubsection",
 CellChangeTimes->{{3.7304382713229475`*^9, 
  3.730438274494831*^9}},ExpressionUUID->"7c9b5683-0f62-4ad4-831a-\
c11fadaa2197"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", 
    RowBox[{"0", "\[Rule]", "\"\<X\>\""}], "}"}], "]"}], "[", 
  RowBox[{
  "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<\[Alpha]\>\"", ",", 
   "\"\<\[Beta]\>\"", ",", "\"\<species\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7141008717246294`*^9, 3.714100977169142*^9}, {
  3.7304382806823416`*^9, 
  3.730438296369873*^9}},ExpressionUUID->"f3e34e86-400f-4316-8922-\
61a588265023"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], "]"}], "[", 
  RowBox[{
  "\"\<M\>\"", ",", "\"\<R\>\"", ",", "\"\<\[Alpha]\>\"", ",", 
   "\"\<\[Beta]\>\"", ",", "\"\<species\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7141010382014427`*^9, 3.71410104864351*^9}, {
  3.730438303182386*^9, 
  3.730438307479268*^9}},ExpressionUUID->"6c4e8c7d-a958-4367-ba4a-\
675d0db5a935"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Theorem 4.7", "Subsubsection",
 CellChangeTimes->{{3.73043834394809*^9, 
  3.730438346401221*^9}},ExpressionUUID->"dd5f712a-13a5-4759-a9ec-\
bca2390577be"],

Cell[BoxData[
 RowBox[{"MassConservationRelations", "[", 
  RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7097272483269234`*^9, 3.709727319070975*^9}, {
  3.72984633763008*^9, 3.729846349114478*^9}, {3.729846379848914*^9, 
  3.729846417895862*^9}, {3.7301884293969564`*^9, 3.7301884370375967`*^9}, {
  3.730438369370015*^9, 
  3.7304383719168944`*^9}},ExpressionUUID->"770e12e0-12d7-4505-a2d6-\
0986ee846e8e"],

Cell[BoxData[
 RowBox[{"MassConservationRelations", "[", 
  RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7097272483269234`*^9, 3.709727319070975*^9}, {
  3.72984633763008*^9, 3.729846349114478*^9}, {3.729846379848914*^9, 
  3.729846417895862*^9}, {3.729846927928109*^9, 3.7298469421937623`*^9}, {
  3.730188465693903*^9, 
  3.7301884667564063`*^9}},ExpressionUUID->"30d872f8-6a04-4a94-81ba-\
1cff4f27f3ec"],

Cell[BoxData[
 RowBox[{"MassConservationRelations", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7097272483269234`*^9, 3.709727319070975*^9}, {
   3.72984633763008*^9, 3.729846349114478*^9}, {3.729846379848914*^9, 
   3.729846417895862*^9}, {3.729846927928109*^9, 3.7298469421937623`*^9}, {
   3.72984697389695*^9, 3.7298469789907093`*^9}, 3.729847013928278*^9, {
   3.73018847180329*^9, 
   3.7301884729907937`*^9}},ExpressionUUID->"5138a872-cb77-428b-9eb4-\
7348724fb56c"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Triangle\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a0", ",", "b0", ",", "c0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7302095425267763`*^9, 3.7302095425267763`*^9}, 
   3.7306095554285927`*^9},ExpressionUUID->"e3472c10-df33-44f8-89a3-\
09976d186125"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{
   RowBox[{"ToReversible", "[", 
    RowBox[{"{", "\"\<Triangle\>\"", "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a0", ",", "b0", ",", "c0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7302095425267763`*^9, 3.7302095425267763`*^9}, {
   3.730438455854559*^9, 3.7304384693077106`*^9}, 
   3.730609560120802*^9},ExpressionUUID->"393b328d-60d9-4a3c-bebf-\
e8492c4f3a8b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 4.9 Lotka-Volterra is not mass conserving", "Subsubsection",
 CellChangeTimes->{{3.714102099903115*^9, 3.7141021114831734`*^9}, {
  3.714103146107238*^9, 3.7141031502992597`*^9}, {3.728803423770709*^9, 
  3.728803426864463*^9}, {3.728803510786502*^9, 
  3.728803519364644*^9}},ExpressionUUID->"0460232f-eb23-4398-8a8a-\
595b9581f99f"],

Cell[BoxData[
 RowBox[{"MassConservationRelations", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7097272483269234`*^9, 3.709727319070975*^9}, {
   3.72984633763008*^9, 3.729846349114478*^9}, {3.729846379848914*^9, 
   3.729846417895862*^9}, {3.729846927928109*^9, 3.7298469421937623`*^9}, {
   3.72984697389695*^9, 3.7298469789907093`*^9}, 3.729847013928278*^9, {
   3.73018847180329*^9, 
   3.7301884729907937`*^9}},ExpressionUUID->"e66a0844-3754-493e-96d8-\
d3861916029d"],

Cell[BoxData[
 RowBox[{"gamma", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{
     RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
   "\[Gamma]", "]"}]}]], "Input",
 CellChangeTimes->{{3.714102209707653*^9, 
  3.714102226403734*^9}},ExpressionUUID->"6f925681-8ae1-4979-ba59-\
4e9d2742e8b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m", ",", "r"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], ";", 
  RowBox[{"Maximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Lambda]", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", "gamma", "]"}], ".", 
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Rho]", "#"], "&"}], ",", "m"}], "]"}]}], 
       "\[Equal]", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{"0", ",", "r"}], "]"}]}], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Rho]", "#"], "&"}], ",", "m"}], "]"}], 
        "\[GreaterEqual]", 
        RowBox[{"\[Lambda]", " ", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{"1", ",", "m"}], "]"}]}]}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Rho]", "#"], "&"}], ",", "m"}], "]"}], ".", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"1", ",", "m"}], "]"}]}], "\[Equal]", "1"}]}], "}"}], ",", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Array", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Rho]", "#"], "&"}], ",", "m"}], "]"}], ",", 
      RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.709791914320525*^9, 3.709792181649169*^9}, {
   3.709792213821107*^9, 3.709792266071209*^9}, {3.7097922995712748`*^9, 
   3.709792332930715*^9}, {3.7097923788214293`*^9, 3.7097923793370557`*^9}, {
   3.7097927521808505`*^9, 3.7097927870715437`*^9}, 
   3.7141022304477544`*^9},ExpressionUUID->"5a894d95-3cf8-4cc8-83ee-\
fd038bf3e705"],

Cell["\<\
However, it is mass conserving if the genuine reaction steps are considered.\
\>", "Text",
 CellChangeTimes->{{3.7301888526634097`*^9, 
  3.730188876772829*^9}},ExpressionUUID->"0955b2b4-2492-4919-966d-\
7126ba43f916"],

Cell[BoxData[
 RowBox[{"gamma", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}], "[", "\[Gamma]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.714102209707653*^9, 3.714102226403734*^9}, 
   3.7301888298977404`*^9},ExpressionUUID->"b71d8194-60d9-406d-8848-\
36bfa020cb53"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m", ",", "r"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}]}], ";", 
  RowBox[{"Maximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Lambda]", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", "gamma", "]"}], ".", 
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Rho]", "#"], "&"}], ",", "m"}], "]"}]}], 
       "\[Equal]", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{"0", ",", "r"}], "]"}]}], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Rho]", "#"], "&"}], ",", "m"}], "]"}], 
        "\[GreaterEqual]", 
        RowBox[{"\[Lambda]", " ", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{"1", ",", "m"}], "]"}]}]}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Rho]", "#"], "&"}], ",", "m"}], "]"}], ".", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"1", ",", "m"}], "]"}]}], "\[Equal]", "1"}]}], "}"}], ",", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Array", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Rho]", "#"], "&"}], ",", "m"}], "]"}], ",", 
      RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.709791914320525*^9, 3.709792181649169*^9}, {
   3.709792213821107*^9, 3.709792266071209*^9}, {3.7097922995712748`*^9, 
   3.709792332930715*^9}, {3.7097923788214293`*^9, 3.7097923793370557`*^9}, {
   3.7097927521808505`*^9, 3.7097927870715437`*^9}, 3.7141022304477544`*^9, {
   3.730188833397745*^9, 
   3.730188834303999*^9}},ExpressionUUID->"ddfd077e-29ba-4072-97c4-\
4d0930727830"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 4.10 The methanol-formic acid esterification", "Subsubsection",
 CellChangeTimes->{{3.714102312912158*^9, 3.714102325700219*^9}, {
  3.7141031240231323`*^9, 3.7141031283351526`*^9}, {3.728803484973953*^9, 
  3.728803501770861*^9}},ExpressionUUID->"7e68e11e-dea6-445e-babb-\
cadb11b0a26b"],

Cell[BoxData[
 RowBox[{"AtomConservingQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<HCOOH\>\"", "+", "\"\<CH3OH\>\""}], "\[Rule]", 
    RowBox[{"\"\<HCOOCH3\>\"", "+", "\"\<H2O\>\""}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7097291693043785`*^9, 
  3.709729236351385*^9}},ExpressionUUID->"66e7b9f6-dc88-473e-b881-\
dd4b178c641c"],

Cell[BoxData[
 RowBox[{"MassConservationRelations", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<HCOOH\>\"", "+", "\"\<CH3OH\>\""}], "\[Rule]", 
    RowBox[{"\"\<HCOOCH3\>\"", "+", "\"\<H2O\>\""}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.714102349532339*^9, 3.7141024093326287`*^9}, {
  3.714102453568845*^9, 3.714102509481118*^9}, {3.7301888898509836`*^9, 
  3.730188927663557*^9}},ExpressionUUID->"5c535681-117f-41d8-89ea-\
3e021c838a53"],

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"MassConservationRelations", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<HCOOH\>\"", "+", "\"\<CH3OH\>\""}], "\[Rule]", 
      RowBox[{"\"\<HCOOCH3\>\"", "+", "\"\<H2O\>\""}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Rho]", "\"\<CH3OH\>\""], ",", 
     SubscriptBox["\[Rho]", "\"\<HCOOH\>\""], ",", 
     SubscriptBox["\[Rho]", "\"\<H2O\>\""], ",", 
     SubscriptBox["\[Rho]", "\"\<HCOOH\>\""], ",", 
     SubscriptBox["\[Rho]", "\"\<HCOOCH3\>\""]}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.714102349532339*^9, 3.7141024093326287`*^9}, {
  3.714102453568845*^9, 3.714102509481118*^9}, {3.7301888898509836`*^9, 
  3.730188927663557*^9}, {3.730188980351159*^9, 3.7301891434764795`*^9}, {
  3.7304385928704524`*^9, 
  3.7304386087142334`*^9}},ExpressionUUID->"f5a94b39-a721-459d-a40f-\
be90ca4c34a9"],

Cell[BoxData[
 RowBox[{"gam", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<HCOOH\>\"", "+", "\"\<CH3OH\>\""}], "\[Rule]", 
      RowBox[{"\"\<HCOOCH3\>\"", "+", "\"\<H2O\>\""}]}], "}"}], "]"}], "[", 
   "\[Gamma]", "]"}]}]], "Input",
 CellChangeTimes->{{3.7141025423452787`*^9, 
  3.7141025926895266`*^9}},ExpressionUUID->"178e0db3-cc5f-4243-b665-\
058f7b60cd8c"],

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["\[Rho]", "1"], ",", 
            SubscriptBox["\[Rho]", "2"], ",", 
            SubscriptBox["\[Rho]", "3"], ",", 
            SubscriptBox["\[Rho]", "4"]}], "}"}], ".", "gam"}], ")"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], "}"}], ",", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Rho]", "1"], ",", 
         SubscriptBox["\[Rho]", "2"], ",", 
         SubscriptBox["\[Rho]", "3"], ",", 
         SubscriptBox["\[Rho]", "4"]}], "}"}], ">", "0"}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Rho]", "1"], ",", 
     SubscriptBox["\[Rho]", "2"], ",", 
     SubscriptBox["\[Rho]", "3"], ",", 
     SubscriptBox["\[Rho]", "4"]}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellChangeTimes->{{3.7304387548551445`*^9, 3.7304389532305317`*^9}, {
  3.7304389932149844`*^9, 
  3.730439013386902*^9}},ExpressionUUID->"1b419c43-3943-4978-84d6-\
df2867e96fe6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 4.12 ", "Subsubsection",
 CellChangeTimes->{{3.7288038040370765`*^9, 3.728803819302732*^9}, {
  3.728803972865532*^9, 3.728803983678053*^9}, {3.7304391476371613`*^9, 
  3.730439148012162*^9}},ExpressionUUID->"ce559a70-e293-4d45-ac3f-\
cb24684e8e8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"atomm", "=", 
    RowBox[{
     RowBox[{"ToAtomMatrix", "[", 
      RowBox[{"{", 
       RowBox[{
       "\"\<HCOOH\>\"", ",", "\"\<CH3OH\>\"", ",", "\"\<HCOOCH3\>\"", ",", 
        "\"\<H2O\>\""}], "}"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.7301891944453297`*^9, 3.730189225648512*^9}, {
  3.7301892580362434`*^9, 
  3.7301892919851856`*^9}},ExpressionUUID->"ad56822e-d29c-4cc3-bd6d-\
e229002cf136"],

Cell["\<\
Here we see that the number of atoms are conserved in each reaction step.\
\>", "Text",
 CellChangeTimes->{{3.730137152365921*^9, 
  3.730137186740988*^9}},ExpressionUUID->"d48a37cb-c6f6-4df7-bea7-\
0fa2c573cc3a"],

Cell[BoxData[
 RowBox[{"atomm", ".", "gam"}]], "Input",
 CellChangeTimes->{{3.7301892939432974`*^9, 
  3.730189306260003*^9}},ExpressionUUID->"dab928b9-b7e9-42ef-b96b-\
353ff2e137ad"],

Cell[BoxData["AbsoluteConcentrationRobustness"], "Input",
 CellChangeTimes->{{3.730880363651041*^9, 3.7308803676510506`*^9}, {
  3.7308804940106716`*^9, 
  3.730880502541939*^9}},ExpressionUUID->"bef78550-4beb-4d3b-8a29-\
2721a6b5ad69"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 4.13 ", "Subsubsection",
 CellChangeTimes->{{3.7288038040370765`*^9, 3.728803819302732*^9}, {
  3.728803972865532*^9, 
  3.728803983678053*^9}},ExpressionUUID->"67b7c8a3-b6e1-4b61-ac95-\
1d72cbe36bbe"],

Cell[BoxData[
 RowBox[{"tam", "=", 
  RowBox[{"ToAtomMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\"\<HCOOH\>\"", ",", "\"\<CH3OH\>\"", ",", "\"\<HCOOCH3\>\"", ",", 
      "\"\<H2O\>\""}], "}"}], ",", 
    RowBox[{"FormattedOutput", "\[Rule]", "True"}], ",", 
    RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7097291693043785`*^9, 3.709729252351416*^9}, 
   3.7205965136425705`*^9, {3.730189331975478*^9, 
   3.730189358014967*^9}},ExpressionUUID->"e473f59b-1a49-4b5a-b6eb-\
22a00219a5f0"],

Cell["\<\
Note that the automatic order of the atoms is different from those taken in \
Example 4.12.\
\>", "Text",
 CellChangeTimes->{{3.730439223527935*^9, 
  3.7304392691374006`*^9}},ExpressionUUID->"fb8b60f7-5523-4cd7-84c0-\
b0c943d14dd9"],

Cell[BoxData[
 RowBox[{"AtomConservingQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<HCOOH\>\"", "+", "\"\<CH3OH\>\""}], "\[Rule]", 
    RowBox[{"\"\<HCOOCH3\>\"", "+", "\"\<H2O\>\""}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7097291693043785`*^9, 
  3.709729236351385*^9}},ExpressionUUID->"fd57c018-8709-4888-8210-\
1f0103a0d8ed"],

Cell[BoxData[
 RowBox[{"FromAtomMatrix", "[", 
  RowBox[{"atomm", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<C\>\"", ",", "\"\<H\>\"", ",", "\"\<O\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.730189374965937*^9, 3.7301894193414774`*^9}, {
  3.7301894631409883`*^9, 
  3.730189464730077*^9}},ExpressionUUID->"3f7641b1-844d-46aa-8750-\
5bdd40d1cb2e"],

Cell["\<\
There is no formatting of the output and no checking, these are your tasks.\
\>", "Text",
 CellChangeTimes->{{3.7097930934158926`*^9, 3.709793104009664*^9}, {
  3.7141042400441246`*^9, 
  3.7141042694242687`*^9}},ExpressionUUID->"6afc18f7-575e-4d15-a545-\
0a9edcd3b2d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 4.17 ", "Subsubsection",
 CellChangeTimes->{{3.728804041850042*^9, 
  3.728804047693802*^9}},ExpressionUUID->"26f25687-2f16-4481-a709-\
f146fdab3fb9"],

Cell[BoxData[
 RowBox[{"AcyclicVolpertGraphQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", "\"\<U\>\""}], ",", 
    RowBox[{
     RowBox[{"\"\<Y\>\"", "+", "\"\<Z\>\""}], "\[Rule]", "\"\<V\>\""}]}], 
   "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.730609983668579*^9, 3.7306099836715775`*^9}, {
  3.730697241404545*^9, 
  3.7306972460451784`*^9}},ExpressionUUID->"34d60615-0e2f-4d2b-b8fe-\
191a02ef5dd5"],

Cell[BoxData[
 RowBox[{"vg", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", "\"\<U\>\""}], ",", 
      RowBox[{
       RowBox[{"\"\<Y\>\"", "+", "\"\<Z\>\""}], "\[Rule]", "\"\<V\>\""}]}], 
     "}"}], "]"}], "[", "\"\<volpertgraph\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.730137596491789*^9, 
  3.7301375987261686`*^9}},ExpressionUUID->"175e9058-538c-4c25-b23c-\
3b2585dddff5"],

Cell[BoxData[
 RowBox[{"AcyclicGraphQ", "[", 
  RowBox[{"Graph", "[", 
   RowBox[{"First", "/@", 
    RowBox[{"vg", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7288040912407627`*^9, 3.7288041190376906`*^9}, {
   3.730137486163449*^9, 3.7301375269135284`*^9}, 3.7301377669139977`*^9, {
   3.7301903548540063`*^9, 3.7301903635035005`*^9}, {3.7301904489663954`*^9, 
   3.7301904490284004`*^9}, {3.7301905733561373`*^9, 
   3.7301905826374054`*^9}},ExpressionUUID->"5deadfce-87d6-414f-a422-\
63190ffc98a9"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Decompositions", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 3.7096139310971584`*^9}, {
  3.7097241358684864`*^9, 
  3.709724141482806*^9}},ExpressionUUID->"6a485d68-1b99-4ebf-9a28-\
6d8418261510"],

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"d7f777ea-f953-41ec-b8af-\
55bedfd38520"],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"ac57b396-2b57-43f8-8d2e-\
45ecd130f7d7"],

Cell[CellGroupData[{

Cell["Section 5.2.1", "Subsubsection",
 CellChangeTimes->{{3.730969052513939*^9, 
  3.7309690594514527`*^9}},ExpressionUUID->"6085ec1f-b493-4cc5-9d73-\
bf7c22551e0e"],

Cell[BoxData[
 RowBox[{"??", "ElementaryReactions"}]], "Input",
 CellChangeTimes->{{3.7309691524047594`*^9, 
  3.73096915284226*^9}},ExpressionUUID->"6e0d5be1-e4a1-4405-94b0-\
820607d150fb"],

Cell[BoxData[
 RowBox[{"ElementaryReactions", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<H2\>\"", ",", "\"\<O2\>\"", ",", "\"\<H2O\>\"", ",", "\"\<C\>\"", 
     ",", "\"\<O\>\"", ",", "\"\<CO\>\""}], "}"}], ",", "2"}], "]"}]], "Input",
 CellChangeTimes->{{3.7309690959202747`*^9, 
  3.7309690959202747`*^9}},ExpressionUUID->"a30530ef-c30a-485b-80a3-\
a1d94db37914"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 5.3", "Subsubsection",
 CellChangeTimes->{{3.714105284329565*^9, 3.7141052866415753`*^9}, {
  3.729062602794157*^9, 
  3.7290626062316647`*^9}},ExpressionUUID->"9c65f59f-27e4-4f64-b078-\
88e2afd98588"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Z", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "2", ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "1", ",", "1", ",", "0", ",", "1"}], 
      "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.73069779857751*^9, 
  3.7306978017025146`*^9}},ExpressionUUID->"19c38eef-5304-41d1-9847-\
d9268ae0abc0"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Z", ".", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "1"], ",", 
       SubscriptBox["x", "2"], ",", 
       SubscriptBox["x", "3"], ",", 
       SubscriptBox["x", "4"], ",", 
       SubscriptBox["x", "5"], ",", 
       SubscriptBox["x", "6"]}], "}"}]}], "\[Equal]", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"], ",", 
     SubscriptBox["x", "3"], ",", 
     SubscriptBox["x", "4"], ",", 
     SubscriptBox["x", "5"], ",", 
     SubscriptBox["x", "6"]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7141052926816053`*^9, 3.7141053709459896`*^9}, {
   3.7304397365601892`*^9, 3.730439751450842*^9}, 
   3.7304402653424726`*^9},ExpressionUUID->"6d9df51c-671d-49c9-ba07-\
2683cb64a10e"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Z", ".", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "1"], ",", 
       SubscriptBox["x", "2"], ",", 
       SubscriptBox["x", "3"], ",", 
       SubscriptBox["x", "4"], ",", 
       SubscriptBox["x", "5"], ",", 
       SubscriptBox["x", "6"]}], "}"}]}], "\[Equal]", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7141052926816053`*^9, 3.7141053709459896`*^9}, {
  3.7141054406783314`*^9, 3.714105445522352*^9}, {3.7304397671227484`*^9, 
  3.7304397787165213`*^9}, {3.7304402928581533`*^9, 
  3.7304403037800474`*^9}},ExpressionUUID->"26bf8083-d416-4129-90c6-\
a8d4500c5a3a"],

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Z", ".", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["x", "1"], ",", 
           SubscriptBox["x", "2"], ",", 
           SubscriptBox["x", "3"], ",", 
           SubscriptBox["x", "4"], ",", 
           SubscriptBox["x", "5"], ",", 
           SubscriptBox["x", "6"]}], "}"}]}], "\[Equal]", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["x", "1"], ",", 
          SubscriptBox["x", "2"], ",", 
          SubscriptBox["x", "3"], ",", 
          SubscriptBox["x", "4"], ",", 
          SubscriptBox["x", "5"], ",", 
          SubscriptBox["x", "6"]}], "}"}], "\[GreaterEqual]", "0"}], "]"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"]}], "}"}], ",", "Integers"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.729074199731554*^9, 3.7290742031534367`*^9}, {
   3.7290742969973693`*^9, 3.7290742999504995`*^9}, {3.730439806622826*^9, 
   3.730439825107236*^9}, 
   3.7304403566864023`*^9},ExpressionUUID->"f2a9cef7-7451-4729-94b3-\
e8f91ad2ffa6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"Sort", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"red", "/.", 
       RowBox[{"Equal", "\[Rule]", "Rule"}]}], "/.", 
      RowBox[{"And", "\[Rule]", "List"}]}], "/.", 
     RowBox[{"Or", "\[Rule]", "List"}]}], ",", "1"}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.729074303153632*^9, 
  3.729074449419544*^9}},ExpressionUUID->"a9c3599c-f3a2-42bc-8966-\
5b0635a364fb"],

Cell["How to get this using Solve?", "Text",
 CellChangeTimes->{{3.729074471357085*^9, 
  3.7290744852633653`*^9}},ExpressionUUID->"92281682-ada1-4b5e-9dec-\
8147a8a4bfe7"],

Cell["Ugly alternatives follow.", "Text",
 CellChangeTimes->{{3.714106354547624*^9, 3.714106370479701*^9}, {
  3.7290742777317066`*^9, 
  3.729074283419219*^9}},ExpressionUUID->"6ea63998-f26d-402b-ab14-\
35992385506d"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Z", ".", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["x", "1"], ",", 
          SubscriptBox["x", "2"], ",", 
          SubscriptBox["x", "3"], ",", 
          SubscriptBox["x", "4"], ",", 
          SubscriptBox["x", "5"], ",", 
          SubscriptBox["x", "6"]}], "}"}]}], "\[Equal]", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "1"], ",", 
         SubscriptBox["x", "2"], ",", 
         SubscriptBox["x", "3"], ",", 
         SubscriptBox["x", "4"], ",", 
         SubscriptBox["x", "5"], ",", 
         SubscriptBox["x", "6"]}], "}"}], "\[GreaterEqual]", "0"}], "]"}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"]}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellChangeTimes->{{3.7141052926816053`*^9, 3.7141053709459896`*^9}, {
   3.7141054406783314`*^9, 3.714105445522352*^9}, {3.7304397671227484`*^9, 
   3.7304397787165213`*^9}, {3.730439844404149*^9, 3.730439851091663*^9}, 
   3.7304399133886595`*^9, 
   3.7304403677801714`*^9},ExpressionUUID->"b85a83e9-b36e-4d2e-95a6-\
fcc41d420256"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Z", ".", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["x", "1"], ",", 
           SubscriptBox["x", "2"], ",", 
           SubscriptBox["x", "3"], ",", 
           SubscriptBox["x", "4"], ",", 
           SubscriptBox["x", "5"], ",", 
           SubscriptBox["x", "6"]}], "}"}]}], "\[Equal]", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["x", "1"], ",", 
          SubscriptBox["x", "2"], ",", 
          SubscriptBox["x", "3"], ",", 
          SubscriptBox["x", "4"], ",", 
          SubscriptBox["x", "5"], ",", 
          SubscriptBox["x", "6"]}], "}"}], "\[GreaterEqual]", "0"}], "]"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"], ",", 
      SubscriptBox["x", "3"], ",", 
      SubscriptBox["x", "4"], ",", 
      SubscriptBox["x", "5"], ",", 
      SubscriptBox["x", "6"]}], "}"}], ",", "Integers", ",", "5"}], "]"}], "//",
   "Column"}]], "Input",
 CellChangeTimes->{{3.7141062759272394`*^9, 3.714106311155411*^9}, {
   3.7304400148732333`*^9, 3.73044002620138*^9}, 
   3.730440377686442*^9},ExpressionUUID->"c0bbbd27-b879-4371-8897-\
fc817472a129"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Z", ".", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["x", "1"], ",", 
           SubscriptBox["x", "2"], ",", 
           SubscriptBox["x", "3"], ",", 
           SubscriptBox["x", "4"], ",", 
           SubscriptBox["x", "5"], ",", 
           SubscriptBox["x", "6"]}], "}"}]}], "\[Equal]", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["x", "1"], ",", 
          SubscriptBox["x", "2"], ",", 
          SubscriptBox["x", "3"], ",", 
          SubscriptBox["x", "4"], ",", 
          SubscriptBox["x", "5"], ",", 
          SubscriptBox["x", "6"]}], "}"}], "\[GreaterEqual]", "0"}], "]"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"], ",", 
      SubscriptBox["x", "3"], ",", 
      SubscriptBox["x", "4"], ",", 
      SubscriptBox["x", "5"], ",", 
      SubscriptBox["x", "6"]}], "}"}], ",", "Integers", ",", "15"}], "]"}], "//",
   "Column"}]], "Input",
 CellChangeTimes->{{3.7141062759272394`*^9, 3.714106328495496*^9}, {
   3.7304400375920267`*^9, 3.7304400474045477`*^9}, 
   3.730440386936462*^9},ExpressionUUID->"775e27a0-aee4-4878-b0bf-\
7c44d239482b"],

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"Delete", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", "Z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", "5", "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.730440401623989*^9, 
  3.7304404569522247`*^9}},ExpressionUUID->"23502f53-653f-4476-9345-\
db069a7d8ed3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "2", ",", "1", ",", "1"}], "}"}]}], "}"}], ".", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["x", "1"], ",", 
           SubscriptBox["x", "2"], ",", 
           SubscriptBox["x", "4"], ",", 
           SubscriptBox["x", "6"]}], "}"}]}], "\[Equal]", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["x", "1"], ",", 
          SubscriptBox["x", "2"], ",", 
          SubscriptBox["x", "4"], ",", 
          SubscriptBox["x", "6"]}], "}"}], "\[GreaterEqual]", "0"}], "]"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"], ",", 
      SubscriptBox["x", "4"], ",", 
      SubscriptBox["x", "6"]}], "}"}], ",", "Integers", ",", "5"}], "]"}], "//",
   "Column"}]], "Input",
 CellChangeTimes->{{3.7141062759272394`*^9, 3.714106311155411*^9}, {
  3.7304400148732333`*^9, 3.73044002620138*^9}, {3.730440177904804*^9, 
  3.7304402179361305`*^9}},ExpressionUUID->"38378a08-7edf-4da7-9660-\
aca44ff628a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 5.4", "Subsubsection",
 CellChangeTimes->{{3.714106566524658*^9, 3.7141065707926807`*^9}, {
  3.7290745279040723`*^9, 
  3.7290745327322063`*^9}},ExpressionUUID->"39c51fdf-e51c-438b-b685-\
f314a4e4947a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"gam", "=", 
    RowBox[{
     RowBox[{"ReactionsData", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"\"\<H\>\"", "+", "\"\<O2\>\""}], "\[Rule]", 
         RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}]}], ",", 
        RowBox[{
         RowBox[{"\"\<O\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
         RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}]}], ",", 
        RowBox[{
         RowBox[{"\"\<OH\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
         RowBox[{"\"\<H\>\"", "+", "\"\<H2O\>\""}]}], ",", 
        RowBox[{
         RowBox[{"2", "\"\<H\>\""}], "\[Rule]", "\"\<H2\>\""}], ",", 
        RowBox[{
         RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}], "\[DoubleLeftRightArrow]", 
         "\"\<H2O\>\""}]}], "}"}], "]"}], "[", "\[Gamma]", "]"}]}], ")"}], "//",
   "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.7141066199929237`*^9, 3.7141066695971622`*^9}, {
  3.7141071888198996`*^9, 3.7141071915879126`*^9}, {3.7141072457961783`*^9, 
  3.714107247764188*^9}, {3.7141073435846567`*^9, 3.714107349440686*^9}, {
  3.7141074909413767`*^9, 3.714107494569395*^9}, {3.730440523796104*^9, 
  3.7304405388742576`*^9}},ExpressionUUID->"e95aab66-355b-40db-96b1-\
c23a91d07369"],

Cell[BoxData[
 RowBox[{"Decompositions", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<H\>\"", "+", "\"\<O2\>\"", "+", 
      RowBox[{"3", "\"\<H2\>\""}]}], "\[Rule]", 
     RowBox[{
      RowBox[{"3", "\"\<H\>\""}], "+", 
      RowBox[{"2", "\"\<H2O\>\""}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<H\>\"", "+", "\"\<O2\>\""}], "\[Rule]", 
      RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<O\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<OH\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<H2O\>\""}]}], ",", 
     RowBox[{
      RowBox[{"2", "\"\<H\>\""}], "\[Rule]", "\"\<H2\>\""}], ",", 
     RowBox[{
      RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}], "\[DoubleLeftRightArrow]", 
      "\"\<H2O\>\""}]}], "}"}], ",", "10", ",", 
   RowBox[{"Method", "\[Rule]", "LPBased"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7308827320425396`*^9, 3.730882821542711*^9}, {
  3.7308828532771473`*^9, 3.730882854464652*^9}, {3.7308828845584593`*^9, 
  3.730882901933494*^9}},ExpressionUUID->"a3b6dcb1-1883-4142-b806-\
a57aaac505ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"overallgam", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7141067116413736`*^9, 3.714106796233782*^9}, {
  3.7141068522660575`*^9, 3.714106876630175*^9}, {3.714107031346933*^9, 
  3.714107040855175*^9}},ExpressionUUID->"258bab00-2714-4111-982f-\
36e21bf278ff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gam", ".", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["z", "1"], ",", 
           SubscriptBox["z", "2"], ",", 
           SubscriptBox["z", "3"], ",", 
           SubscriptBox["z", "4"], ",", 
           SubscriptBox["z", "5"], ",", 
           SubscriptBox["z", "6"]}], "}"}]}], "\[Equal]", "overallgam"}], 
       "}"}], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{"2", "\[GreaterEqual]", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["z", "1"], ",", 
          SubscriptBox["z", "2"], ",", 
          SubscriptBox["z", "3"], ",", 
          SubscriptBox["z", "4"], ",", 
          SubscriptBox["z", "5"], ",", 
          SubscriptBox["z", "6"]}], "}"}], "\[GreaterEqual]", "0"}], "]"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["z", "1"], ",", 
      SubscriptBox["z", "2"], ",", 
      SubscriptBox["z", "3"], ",", 
      SubscriptBox["z", "4"], ",", 
      SubscriptBox["z", "5"], ",", 
      SubscriptBox["z", "6"]}], "}"}], ",", "Integers", ",", "10"}], "]"}], "//",
   "Column"}]], "Input",
 CellChangeTimes->{{3.7141068813462*^9, 3.7141069742226534`*^9}, 
   3.714107061271278*^9, {3.7141074372131147`*^9, 3.7141074443411493`*^9}, {
   3.714107523305535*^9, 3.7141075402016163`*^9}, {3.729074609076104*^9, 
   3.7290746136229877`*^9}, {3.7290746572636986`*^9, 
   3.7290746587012014`*^9}, {3.7304406386244535`*^9, 
   3.7304406713432674`*^9}, {3.7304407101714673`*^9, 
   3.7304407107495947`*^9}, {3.7308829766836395`*^9, 
   3.730882985371154*^9}},ExpressionUUID->"fcd27b93-8f7f-4005-bf0b-\
16cecc5d5571"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Section 5.3.1", "Subsubsection",
 CellChangeTimes->{{3.7302048480219545`*^9, 
  3.7302048678188686`*^9}},ExpressionUUID->"2ee1f8d9-b4d5-469d-a3a2-\
48644585ee7d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "MyContejeanDevie", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MyContejeanDevie", "[", "A_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", 
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "A", "]"}]}], ",", 
      RowBox[{"B", "=", 
       RowBox[{"{", "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"P", "=", 
      RowBox[{"IdentityMatrix", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"P", "=!=", 
        RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B", "=", 
         RowBox[{"Union", "[", 
          RowBox[{"B", ",", 
           RowBox[{"Select", "[", 
            RowBox[{"P", ",", 
             RowBox[{
              RowBox[{"ZeroVectorQ", "[", 
               RowBox[{"#", ".", "A"}], "]"}], "&"}]}], "]"}]}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Q", "=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"Complement", "[", 
            RowBox[{"P", ",", "B"}], "]"}], ",", 
           RowBox[{"Function", "[", 
            RowBox[{"p", ",", 
             RowBox[{"And", "@@", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"!", 
                  RowBox[{"ComponentwiseLessEqualQ", "[", 
                   RowBox[{"#", ",", "p"}], "]"}]}], "&"}], "/@", "B"}], 
               ")"}]}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"P", "=", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{
           RowBox[{"Union", "@@", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"q", ".", "A"}], ")"}], ".", 
                  RowBox[{"(", 
                   RowBox[{"A", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ")"}]}], "<", "0"}], ",", 
                RowBox[{"q", "+", 
                 RowBox[{"UnitVector", "[", 
                  RowBox[{"n", ",", "i"}], "]"}]}], ",", "Null"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"q", ",", "Q"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ",", 
           "Null"}], "]"}]}], ";", 
        RowBox[{"Print", "[", 
         RowBox[{"{", 
          RowBox[{"B", ",", "Q", ",", "P"}], "}"}], "]"}], ";"}]}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"B", ",", "Q", ",", "P"}], "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.709795215203672*^9, 3.709795215205674*^9}, {
   3.7097958095527105`*^9, 3.7097958128879013`*^9}, 3.709796428646171*^9, {
   3.709796509224454*^9, 3.7097965215838537`*^9}, {3.73020487130325*^9, 
   3.7302049050533156`*^9}, {3.7302049521471577`*^9, 3.730204968694065*^9}, {
   3.7302052192258067`*^9, 3.73020522178831*^9}, 3.7302053242728853`*^9, {
   3.730205355726071*^9, 3.7302053988199053`*^9}, {3.7302057073361363`*^9, 
   3.7302057780550237`*^9}},ExpressionUUID->"3eeb0e51-ff48-45b2-8235-\
2338d5ff4843"],

Cell[BoxData[
 RowBox[{"MyContejeanDevie", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{
  3.7097964920525465`*^9, {3.7302049780690813`*^9, 3.730204979506587*^9}, {
   3.7302058243832383`*^9, 
   3.7302058295238733`*^9}},ExpressionUUID->"ecdb6a15-bf86-4c06-aaa3-\
736658902793"],

Cell[BoxData[
 RowBox[{"MyContejeanDevie", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{
  3.7097964920525465`*^9, {3.7302049780690813`*^9, 3.730204979506587*^9}, {
   3.7302058243832383`*^9, 
   3.7302058456176567`*^9}},ExpressionUUID->"170d0822-2d1f-4946-a5ae-\
b09fa218781d"],

Cell[BoxData[
 RowBox[{"MyContejeanDevie", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{
  3.7097964920525465`*^9, {3.709796541615144*^9, 3.709796551865163*^9}, {
   3.730204982303467*^9, 3.7302049835378428`*^9}, {3.730205050600475*^9, 
   3.730205084225541*^9}, {3.7302054868825808`*^9, 3.730205507335743*^9}, {
   3.7302055650389805`*^9, 
   3.730205572742121*^9}},ExpressionUUID->"06f16e52-0202-48b2-98cd-\
cc2b8162c1a1"],

Cell[BoxData[
 RowBox[{"MyContejeanDevie", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{
  3.7097964920525465`*^9, {3.709796541615144*^9, 3.709796551865163*^9}, {
   3.730204982303467*^9, 3.7302049835378428`*^9}, {3.730205050600475*^9, 
   3.730205117538106*^9}, {3.730205273100912*^9, 
   3.730205284444683*^9}},ExpressionUUID->"2b7a641f-e7ae-4729-8adc-\
d3b0a1619561"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 5.11", "Subsubsection",
 CellChangeTimes->{{3.7123826321922693`*^9, 3.7123826705139*^9}, {
  3.729074903686056*^9, 
  3.7290749135298247`*^9}},ExpressionUUID->"e829bea4-dbf5-471a-9b71-\
2ac6b5c227e8"],

Cell["(Continuation of 5.4)", "Text",
 CellChangeTimes->{{3.7290753096399746`*^9, 3.729075314718108*^9}, {
  3.730138069430213*^9, 
  3.7301380848677435`*^9}},ExpressionUUID->"e14b8369-8868-4cc4-a601-\
5296024af341"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Riffle", "[", 
   RowBox[{
    RowBox[{"VolpertIndexing", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"\"\<H\>\"", "+", "\"\<O2\>\""}], "\[Rule]", 
         RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\"\<O\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
         RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\"\<OH\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
         RowBox[{"\"\<H\>\"", "+", "\"\<H2O\>\""}]}], ",", 
        RowBox[{
         RowBox[{"2", "\"\<H\>\""}], "\[Rule]", "\"\<H2\>\""}], ",", 
        RowBox[{
         RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}], "\[DoubleLeftRightArrow]", 
         "\"\<H2O\>\""}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<OH\>\"", ",", "\"\<H2O\>\""}], "}"}], ",", 
      RowBox[{"Verbose", "\[Rule]", "True"}]}], "]"}], ",", "\"\<  \>\""}], 
   "]"}], "//", "Row"}]], "Input",
 CellChangeTimes->{{3.7123826773976336`*^9, 3.712382686477682*^9}, {
  3.71238272742447*^9, 3.7123828332097726`*^9}, {3.7123828724081163`*^9, 
  3.7123828921538324`*^9}, {3.7123830575979395`*^9, 3.7123830593500175`*^9}, {
  3.729075057326982*^9, 3.729075058420731*^9}, {3.7290751468115315`*^9, 
  3.7290752217960544`*^9}, {3.7301384096652565`*^9, 3.730138416118391*^9}, {
  3.7301907688877707`*^9, 3.730190783247173*^9}, {3.730190816465989*^9, 
  3.7301908182472415`*^9}, {3.730190853934811*^9, 
  3.7301908632004557`*^9}},ExpressionUUID->"ec4484cc-15ea-43f1-aea4-\
7ac810cc63ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 5.12", "Subsubsection",
 CellChangeTimes->{{3.7123826321922693`*^9, 3.7123826705139*^9}, {
  3.729074903686056*^9, 3.7290749135298247`*^9}, {3.7304411010316076`*^9, 
  3.730441101359733*^9}},ExpressionUUID->"b581df21-4446-4396-892e-\
0da7a5c0b262"],

Cell[BoxData[
 RowBox[{
  RowBox[{"reactionsteps", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<H\>\"", "+", "\"\<O_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<O\>\"", "+", "\"\<H_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "\"\<OH\>\""}], "+", "\"\<H_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<H_2O\>\""}]}]}], "}"}]}], ";"}]], "Input",\
ExpressionUUID->"e79c5c96-df55-4dab-8d6e-ed3bfb6aa036"],

Cell[BoxData[
 RowBox[{"CoveringDecompositionSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "\"\<H_2\>\""}], "+", "\"\<O_2\>\""}], "\[Rule]", " ", 
     RowBox[{"\"\<H\>\"", "+", "\"\<H_2O\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<H\>\"", "+", "\"\<O_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<O\>\"", "+", "\"\<H_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "\"\<OH\>\""}], "+", "\"\<H_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<H_2O\>\""}]}]}], "}"}], ",", 
   RowBox[{"ObjectiveFunction", "\[Rule]", "GreedySelection"}], ",", 
   RowBox[{"Verbose", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730441110781629*^9, 3.7304411107972527`*^9}, {
  3.7308817676732264`*^9, 
  3.730881809126433*^9}},ExpressionUUID->"c6ff13f5-3b77-4fc3-ad30-\
1a69d943bf0b"],

Cell[BoxData[
 RowBox[{"Decompositions", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "\"\<H_2\>\""}], "+", "\"\<O_2\>\""}], "\[Rule]", " ", 
     RowBox[{"\"\<H\>\"", "+", "\"\<H_2O\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<H\>\"", "+", "\"\<O_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<O\>\"", "+", "\"\<H_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "\"\<OH\>\""}], "+", "\"\<H_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<H_2O\>\""}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730441110781629*^9, 3.7304411107972527`*^9}, {
  3.7308811765001955`*^9, 3.730881189109595*^9}, {3.730881667766782*^9, 
  3.730881676626173*^9}, {3.7308818697359285`*^9, 
  3.7308818712515535`*^9}},ExpressionUUID->"51ebeb07-049c-466f-9c6e-\
ad786d51f54f"],

Cell[BoxData[
 RowBox[{"Decompositions", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "\"\<H_2\>\""}], "+", "\"\<O_2\>\""}], "\[Rule]", " ", 
     RowBox[{"\"\<H\>\"", "+", "\"\<H_2O\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<H\>\"", "+", "\"\<O_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<O\>\"", "+", "\"\<H_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "\"\<OH\>\""}], "+", "\"\<H_2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<H_2O\>\""}]}]}], "}"}], ",", "10", ",", 
   RowBox[{"Method", "\[Rule]", "LPBased"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730441110781629*^9, 3.7304411107972527`*^9}, {
  3.7308811765001955`*^9, 3.730881189109595*^9}, {3.730881667766782*^9, 
  3.730881676626173*^9}, {3.7308818697359285`*^9, 
  3.730881893944125*^9}},ExpressionUUID->"a16980fa-8604-4b25-8730-\
5af4a2414986"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Induced", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 3.7096139310971584`*^9}, {
  3.7097241548265724`*^9, 
  3.7097241615069532`*^9}},ExpressionUUID->"644a6aa5-cbd2-473d-88ac-\
0deace544432"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"004c0b99-8609-4751-bf5e-\
0eb2c84cf6ed"],

Cell[CellGroupData[{

Cell["Fig. 6.1", "Subsubsection",
 CellChangeTimes->{{3.7285655824048233`*^9, 3.7285655837959037`*^9}, {
   3.7285659864715505`*^9, 3.728565987034052*^9}, 
   3.7286437695101614`*^9},ExpressionUUID->"c9f35050-4567-4e76-a63f-\
a67674a95693"],

Cell[BoxData[
 RowBox[{"gH", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Labeled", "[", 
       RowBox[{"1", ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(CH\), \(3\)]\)OH\>\"", ",", "Bold", ",", 
          "16"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{"2", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)O\>\"", ",", 
          RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", "Bold", 
          ",", "16"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{"3", ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(HCOOCH\), \(3\)]\)\>\"", ",", "Bold", ",", 
          "16"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{"4", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<HCOOH\>\"", ",", "Bold", ",", "16"}], "]"}]}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"1", "\[DirectedEdge]", "2"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<8/12 \>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<w(c(t))\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
            "]"}]}], "}"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"1", "\[DirectedEdge]", "3"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<16/12 \>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<w(c(t))\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
            "]"}]}], "}"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"4", "\[DirectedEdge]", "2"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<4/12 \>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<w(c(t))\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
            "]"}]}], "}"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"4", "\[DirectedEdge]", "3"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<8/12 \>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<w(c(t))\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
            "]"}]}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
    RowBox[{"VertexSize", "\[Rule]", "Tiny"}], ",", 
    RowBox[{"EdgeShapeFunction", "\[Rule]", 
     RowBox[{"GraphElementData", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<FilledArrow\>\"", ",", 
        RowBox[{"\"\<ArrowSize\>\"", "\[Rule]", ".07"}]}], "}"}], "]"}]}], 
    ",", 
    RowBox[{"ImagePadding", "\[Rule]", "70"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", "\"\<SpringEmbedding\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5744272308630695`*^9, 3.5744272318630705`*^9}, {
   3.5744273003181667`*^9, 3.57442730258317*^9}, {3.5744273448532286`*^9, 
   3.5744273932332964`*^9}, {3.574427639483641*^9, 3.5744277344037743`*^9}, {
   3.574427828410757*^9, 3.5744278407974653`*^9}, {3.574427919270954*^9, 
   3.574428012766302*^9}, {3.5744281008661113`*^9, 3.574428292281379*^9}, {
   3.574428324171424*^9, 3.574428324886425*^9}, {3.5744283565364695`*^9, 
   3.574428433486577*^9}, {3.5744284643866205`*^9, 3.574428618011835*^9}, {
   3.5744286648669004`*^9, 3.574428712111967*^9}, {3.639480849021982*^9, 
   3.639480877606617*^9}, {3.6394810260201063`*^9, 3.6394810283852415`*^9}, {
   3.6394810938979883`*^9, 3.6394811034165325`*^9}, {3.6394811842311554`*^9, 
   3.6394812602435026`*^9}, {3.639481299124727*^9, 3.6394813135065494`*^9}, {
   3.6394814393917494`*^9, 3.6394814585878477`*^9}, {3.7109217872474165`*^9, 
   3.710921808057605*^9}, {3.7109218795156965`*^9, 3.7109218863440876`*^9}, 
   3.710930288457247*^9, {3.710930321053113*^9, 
   3.710930346827589*^9}},ExpressionUUID->"9de3ae2e-b170-4184-ba32-\
a3923449f862"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig6.1A\>\"", ",", "gH"}], "]"}]], "Input",
 CellChangeTimes->{{3.636861347875415*^9, 3.6368613599971085`*^9}, {
  3.709797433788764*^9, 3.7097974433200307`*^9}, {3.7285656808464622`*^9, 
  3.728565692937155*^9}, {3.728565870752575*^9, 
  3.7285658713932004`*^9}},ExpressionUUID->"92d02842-2250-4294-b9a0-\
27c74981b5b1"],

Cell[BoxData[
 RowBox[{"gC", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Labeled", "[", 
       RowBox[{"1", ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(CH\), \(3\)]\)OH\>\"", ",", "Bold", ",", 
          "16"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{"3", ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(HCOOCH\), \(3\)]\)\>\"", ",", "Bold", ",", 
          "16"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{"2", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<HCOOH\>\"", ",", "Bold", ",", "16"}], "]"}]}], "]"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"2", "\[DirectedEdge]", "3"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<1/4 \>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<w(c(t))\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
            "]"}]}], "}"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"1", "\[DirectedEdge]", "3"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<1/4 \>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<w(c(t))\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
            "]"}]}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
    RowBox[{"VertexSize", "\[Rule]", "Tiny"}], ",", 
    RowBox[{"EdgeShapeFunction", "\[Rule]", 
     RowBox[{"GraphElementData", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<FilledArrow\>\"", ",", 
        RowBox[{"\"\<ArrowSize\>\"", "\[Rule]", ".07"}]}], "}"}], "]"}]}], 
    ",", 
    RowBox[{"ImagePadding", "\[Rule]", "70"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5744272308630695`*^9, 3.5744272318630705`*^9}, {
   3.5744273003181667`*^9, 3.57442730258317*^9}, {3.5744273448532286`*^9, 
   3.5744273932332964`*^9}, {3.574427639483641*^9, 3.5744277344037743`*^9}, {
   3.574427828410757*^9, 3.5744278407974653`*^9}, {3.574427919270954*^9, 
   3.574428012766302*^9}, {3.5744281008661113`*^9, 3.574428292281379*^9}, {
   3.574428324171424*^9, 3.574428324886425*^9}, {3.5744283565364695`*^9, 
   3.574428433486577*^9}, {3.5744284643866205`*^9, 3.574428618011835*^9}, {
   3.5744286648669004`*^9, 3.574428712111967*^9}, 3.5744292452277136`*^9, {
   3.5744293924429197`*^9, 3.574429490438057*^9}, {3.5744296074002876`*^9, 
   3.5744296080263233`*^9}, {3.6394809005499296`*^9, 
   3.6394809033580904`*^9}, {3.639481012051307*^9, 3.639481016536564*^9}, {
   3.6394814827562304`*^9, 3.639481483059247*^9}, {3.7109219254583287`*^9, 
   3.710922093056926*^9}, {3.710922226965595*^9, 3.7109222279816523`*^9}, {
   3.710922482973255*^9, 3.7109225288748827`*^9}, {3.7109303637975655`*^9, 
   3.7109303760082617`*^9}},ExpressionUUID->"56f5f659-66bc-4428-97c0-\
2b9288dc0063"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig6.1B\>\"", ",", "gC"}], "]"}]], "Input",
 CellChangeTimes->{{3.636861347875415*^9, 3.6368613714297624`*^9}, 
   3.7097974571169343`*^9, 3.7109303837117033`*^9, {3.728565719191657*^9, 
   3.728565724791978*^9}, {3.7285658643306875`*^9, 
   3.7285658646431875`*^9}},ExpressionUUID->"d1b7800f-5e26-4f5a-b5dc-\
eacc5f135664"],

Cell[BoxData[
 RowBox[{"gO", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Labeled", "[", 
       RowBox[{"1", ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(CH\), \(3\)]\)OH\>\"", ",", "Bold", ",", 
          "16"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{"2", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)O\>\"", ",", 
          RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", "Bold", 
          ",", "16"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{"3", ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(HCOOCH\), \(3\)]\)\>\"", ",", "Bold", ",", 
          "16"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{"4", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<HCOOH\>\"", ",", "Bold", ",", "16"}], "]"}]}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"1", "\[DirectedEdge]", "2"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<1/6 \>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<w(c(t))\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
            "]"}]}], "}"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"1", "\[DirectedEdge]", "3"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<2/6 \>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<w(c(t))\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
            "]"}]}], "}"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"4", "\[DirectedEdge]", "2"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<2/6 \>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<w(c(t))\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
            "]"}]}], "}"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"4", "\[DirectedEdge]", "3"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<4/6 \>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<w(c(t))\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
            "]"}]}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
    RowBox[{"VertexSize", "\[Rule]", "Tiny"}], ",", 
    RowBox[{"EdgeShapeFunction", "\[Rule]", 
     RowBox[{"GraphElementData", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<FilledArrow\>\"", ",", 
        RowBox[{"\"\<ArrowSize\>\"", "\[Rule]", ".07"}]}], "}"}], "]"}]}], 
    ",", 
    RowBox[{"ImagePadding", "\[Rule]", "70"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", "\"\<SpringEmbedding\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5744272308630695`*^9, 3.5744272318630705`*^9}, {
   3.5744273003181667`*^9, 3.57442730258317*^9}, {3.5744273448532286`*^9, 
   3.5744273932332964`*^9}, {3.574427639483641*^9, 3.5744277344037743`*^9}, {
   3.574427828410757*^9, 3.5744278407974653`*^9}, {3.574427919270954*^9, 
   3.574428012766302*^9}, {3.5744281008661113`*^9, 3.574428292281379*^9}, {
   3.574428324171424*^9, 3.574428324886425*^9}, {3.5744283565364695`*^9, 
   3.574428433486577*^9}, {3.5744284643866205`*^9, 3.574428618011835*^9}, {
   3.5744286648669004`*^9, 3.574428712111967*^9}, 3.5744292452277136`*^9, {
   3.574429306137799*^9, 3.5744293586678724`*^9}, {3.639480919893036*^9, 
   3.6394809235012426`*^9}, {3.639480991284119*^9, 3.639480997139454*^9}, {
   3.639481491556733*^9, 3.639481491795747*^9}, {3.7109225861261625`*^9, 
   3.7109226195590763`*^9}, {3.7109303903170815`*^9, 
   3.7109304138334265`*^9}},ExpressionUUID->"b727511d-5607-4376-afef-\
794f0f622a33"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig6.1C\>\"", ",", "gO"}], "]"}]], "Input",
 CellChangeTimes->{{3.636861347875415*^9, 3.6368613661494603`*^9}, 
   3.709797467257579*^9, 3.7109304234309783`*^9, {3.7285657443570995`*^9, 
   3.72856575098948*^9}, {3.7285658563931713`*^9, 
   3.728565856986924*^9}},ExpressionUUID->"345c4524-c4bd-4167-aed0-\
24b92a4378f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 6.2", "Subsubsection",
 CellChangeTimes->{{3.728565630481577*^9, 3.728565631671645*^9}, {
   3.7285659781590357`*^9, 3.728565979205912*^9}, 
   3.728643799588346*^9},ExpressionUUID->"0ed5bfb7-aeb7-4d98-b576-\
12d49cbd86b9"],

Cell[TextData[{
 "If volume (",
 Cell[BoxData[
  FormBox["V", TraditionalForm]],ExpressionUUID->
  "1589be94-d524-44ad-9766-7db42de231d9"],
 ") and the residence time (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "res"], TraditionalForm]],ExpressionUUID->
  "d4b081f3-af83-43e7-b59f-7d18944c2789"],
 ") are considered to be infinity, then we can use our built-in funcions. "
}], "Text",
 CellChangeTimes->{{3.7301919717338743`*^9, 3.730192050171526*^9}, 
   3.7301966322540627`*^9, {3.730442024115946*^9, 3.7304420371940975`*^9}, {
   3.7304420815691833`*^9, 3.730442086475443*^9}, {3.730442175944367*^9, 
   3.7304421949131546`*^9}, 
   3.730968755657837*^9},ExpressionUUID->"e41d0d76-2ec5-4ac9-b37b-\
91d2f62b661e"],

Cell[BoxData[
 RowBox[{"DeterministicModel", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"k0", ",", "0", ",", "A"}], "}"}], "}"}], ",", 
   RowBox[{"{", "Q", "}"}], ",", 
   RowBox[{"{", "C0", "}"}], ",", "Infinity", ",", "Ta", ",", "Infinity", ",",
    "1", ",", "P2"}], "]"}]], "Input",
 CellChangeTimes->{{3.7301911248728433`*^9, 3.73019118540421*^9}, {
  3.730191218748023*^9, 3.7301912898887897`*^9}, {3.7301913246701074`*^9, 
  3.7301913312482443`*^9}, {3.7301917812335014`*^9, 3.7301917814835*^9}, {
  3.7301919378900566`*^9, 3.7301919612338552`*^9}, {3.7301920744215755`*^9, 
  3.7301920786872063`*^9}, {3.7309687776350965`*^9, 
  3.730968800780422*^9}},ExpressionUUID->"952d58f8-eb3d-4754-8263-\
2a80eaba08d4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "comb", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"comb", "[", "Q_", "]"}], " ", ":=", " ", 
   RowBox[{"ReplaceAll", "@@", 
    RowBox[{"Concentrations", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "8322"}], "}"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"-", "Q"}], "}"}], ",", 
      RowBox[{"{", "C0", "}"}], ",", "Infinity", ",", "Ta", ",", "Infinity", 
      ",", "1", ",", "P2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "300"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "100"}], "}"}]}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7301926476762743`*^9, 3.7301926718169518`*^9}, {
  3.730196000425923*^9, 3.7301960008009214`*^9}, {3.7301961016448684`*^9, 
  3.7301961099417596`*^9}, {3.730196140629322*^9, 3.730196184660657*^9}, {
  3.7301962171763473`*^9, 3.730196221020104*^9}, {3.7301963926923113`*^9, 
  3.7301963952391944`*^9}, {3.730968818263424*^9, 
  3.7309688270659275`*^9}},ExpressionUUID->"b92291a9-a38f-44a4-9ae5-\
8268339394b2"],

Cell[BoxData[
 RowBox[{"temperaturec", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"First", "[", 
        RowBox[{"comb", "[", 
         RowBox[{"-", "100"}], "]"}], "]"}], "]"}], ",", 
      RowBox[{"Evaluate", "[", 
       RowBox[{"First", "[", 
        RowBox[{"comb", "[", "600", "]"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Red"}], "}"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<t\>\"", ",", "Italic", ",", "Bold", ",", "16"}], "]"}], 
       ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<c(t)\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
        "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Row", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<Q\>\"", ",", "Italic", ",", "14"}], "]"}], ",", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\< = -100\>\"", ",", "14"}], "]"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Row", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<Q\>\"", ",", "Italic", ",", "14"}], "]"}], ",", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\< = 600\>\"", ",", "14"}], "]"}]}], "}"}], "]"}]}], 
        "}"}], ",", "Above"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7301911248728433`*^9, 3.73019118540421*^9}, {
  3.730191218748023*^9, 3.7301912898887897`*^9}, {3.7301913246701074`*^9, 
  3.7301913312482443`*^9}, {3.7301917812335014`*^9, 3.7301917814835*^9}, {
  3.7301919378900566`*^9, 3.7301919612338552`*^9}, {3.7301920744215755`*^9, 
  3.730192260286067*^9}, {3.730192297579204*^9, 3.7301923826900783`*^9}, {
  3.7301924131118207`*^9, 3.7301925066291227`*^9}, {3.7301925419885683`*^9, 
  3.730192661004427*^9}, {3.7301961180511513`*^9, 3.730196125644916*^9}, {
  3.7301962123325863`*^9, 3.730196258004554*^9}, {3.7301963977079473`*^9, 
  3.7301964063954654`*^9}},ExpressionUUID->"fccffba7-8206-4631-b53d-\
f7517588deb9"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig6.2A\>\"", ",", "temperaturec"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6368621135412087`*^9, 3.636862126901973*^9}, {
   3.6368622973897247`*^9, 3.6368622985817924`*^9}, 3.7097975706484065`*^9, 
   3.710930510853984*^9, {3.7285660012528296`*^9, 
   3.7285660148153577`*^9}},ExpressionUUID->"ab001014-d727-4eb6-8c23-\
63743fa7bd1d"],

Cell[BoxData[
 RowBox[{"temperatureT", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"Last", "[", 
        RowBox[{"comb", "[", 
         RowBox[{"-", "100"}], "]"}], "]"}], "]"}], ",", 
      RowBox[{"Evaluate", "[", 
       RowBox[{"Last", "[", 
        RowBox[{"comb", "[", "600", "]"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Red"}], "}"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<t\>\"", ",", "Italic", ",", "Bold", ",", "16"}], "]"}], 
       ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<T(t)\>\"", ",", "Italic", ",", "Bold", ",", "16"}], 
        "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Row", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<Q\>\"", ",", "Italic", ",", "14"}], "]"}], ",", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\< = -100\>\"", ",", "14"}], "]"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Row", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<Q\>\"", ",", "Italic", ",", "14"}], "]"}], ",", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\< = 600\>\"", ",", "14"}], "]"}]}], "}"}], "]"}]}], 
        "}"}], ",", "Above"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730196377051659*^9, 
  3.7301964208954935`*^9}},ExpressionUUID->"e0fd7a0e-e2ee-428d-8088-\
3d29695fd372"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig6.2B\>\"", ",", "temperatureT"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.636862143900945*^9, 3.636862144404974*^9}, {
   3.6368622922384295`*^9, 3.6368622945975647`*^9}, 3.709797562789015*^9, 
   3.7109305383905597`*^9, {3.7285660334091425`*^9, 
   3.7285660426747856`*^9}},ExpressionUUID->"064c38aa-a805-43be-aab2-\
73f3d9b41bb6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 6.3", "Subsubsection",
 CellChangeTimes->{{3.7285660669873343`*^9, 3.72856606812796*^9}, 
   3.7286438017914753`*^9},ExpressionUUID->"11375171-71cc-41f6-8453-\
e399bee610be"],

Cell[TextData[{
 "Volume (",
 Cell[BoxData[
  FormBox["V", TraditionalForm]],ExpressionUUID->
  "39756c44-0e2f-45b8-9473-40a74aa1e8ac"],
 ") and the residence time (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "res"], TraditionalForm]],ExpressionUUID->
  "07d2c6e6-57f0-45c8-8eb8-55db4f3bcc09"],
 ") are considered to be infinity with vanishing enthalpies."
}], "Text",
 CellChangeTimes->{{3.7301919717338743`*^9, 3.730192050171526*^9}, {
  3.730196611130242*^9, 
  3.730196627004052*^9}},ExpressionUUID->"18587ed7-3f5e-4bed-967c-\
23ddae58d52f"],

Cell[BoxData[
 RowBox[{"DeterministicModel", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"k0", ",", "0", ",", "A"}], "}"}], "}"}], ",", 
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", "C0", "}"}], ",", "Infinity", ",", "Ta", ",", "Infinity", ",",
    "1", ",", "P2"}], "]"}]], "Input",
 CellChangeTimes->{{3.7301964687705884`*^9, 3.73019646902059*^9}, {
  3.730968863289002*^9, 
  3.730968871225457*^9}},ExpressionUUID->"9fbdbb34-93e7-4689-b566-\
81a83596f000"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "comb2", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"comb2", "[", "Q_", "]"}], " ", ":=", " ", 
   RowBox[{"ReplaceAll", "@@", 
    RowBox[{"Concentrations", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "8322"}], "}"}], "}"}], ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", "C0", "}"}], ",", "Infinity", ",", "Ta", ",", "Infinity", 
      ",", "1", ",", "P2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "300"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "100"}], "}"}]}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7301964934425106`*^9, 3.730196498614396*^9}, {
  3.7309688751416807`*^9, 
  3.73096888299113*^9}},ExpressionUUID->"d54a4613-9cc7-4ed0-ae65-\
b1b9a709cfc9"],

Cell[BoxData[
 RowBox[{"temperaturediff", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"First", "[", 
         RowBox[{"comb", "[", 
          RowBox[{"-", "100"}], "]"}], "]"}], "-", 
        RowBox[{"First", "[", 
         RowBox[{"comb2", "[", 
          RowBox[{"-", "100"}], "]"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"First", "[", 
         RowBox[{"comb", "[", "600", "]"}], "]"}], "-", 
        RowBox[{"First", "[", 
         RowBox[{"comb2", "[", "600", "]"}], "]"}]}]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Red"}], "}"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<t\>\"", ",", "Italic", ",", "Bold", ",", "16"}], "]"}], 
       ",", 
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\[CapitalDelta]c(t)\>\"", ",", "Italic", ",", "Bold", ",", 
         "16"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<T\>\"", ",", "Italic", ",", "14"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\< = 300 K\>\"", ",", "14"}], "]"}]}], "}"}], "]"}], 
       ",", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<T\>\"", ",", "Italic", ",", "14"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\< is changing with time\>\"", ",", "14"}], "]"}]}], 
         "}"}], "]"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730196543458233*^9, 
  3.7301965775833025`*^9}},ExpressionUUID->"724a0466-fbe0-46e9-8b8a-\
3b30ecd017d6"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig6.3\>\"", ",", "temperaturediff"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6368621879094625`*^9, 3.636862189053528*^9}, {
   3.636862284117965*^9, 3.636862287085135*^9}, 3.709797877883382*^9, 
   3.7109306223983736`*^9, {3.7285660825342383`*^9, 
   3.7285660939561357`*^9}},ExpressionUUID->"66a6860c-dab9-43b5-b08d-\
64f904bc6818"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 6.4", "Subsubsection",
 CellChangeTimes->{{3.7285661452218604`*^9, 3.7285661463312387`*^9}, 
   3.728643838385296*^9},ExpressionUUID->"0e6d2dd2-0537-4b3d-a204-\
2db76bd5278f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nds", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"c", "[", 
           RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "==", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"c", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "-", 
         RowBox[{"c", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"c", "[", 
         RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "0.01"}], "x"}], "]"}], 
         RowBox[{"Sin", "[", 
          RowBox[{"8", "x"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"c", "[", 
         RowBox[{"t", ",", "0"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"c", "[", 
         RowBox[{"t", ",", "\[Pi]"}], "]"}], "==", "0"}]}], "}"}], ",", "c", 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6090474611554375`*^9, 3.6090475453052506`*^9}, 
   3.609047683006127*^9, {3.6090477430655622`*^9, 3.609047751652053*^9}, {
   3.6096551273090553`*^9, 3.609655140283798*^9}, {3.609655231860036*^9, 
   3.6096552543403215`*^9}, {3.6096553571412015`*^9, 
   3.6096554146114883`*^9}, {3.6096554626202345`*^9, 
   3.6096555121820693`*^9}, {3.6115820091569614`*^9, 
   3.6115821687450895`*^9}, {3.6368622619596977`*^9, 
   3.6368622663599496`*^9}, {3.6368628236088223`*^9, 3.6368628701754856`*^9}, 
   3.6369005134301996`*^9, {3.6380284070492196`*^9, 3.6380284593561115`*^9}, {
   3.6380285551870794`*^9, 3.638028568415903*^9}, {3.638029063409409*^9, 
   3.638029064038445*^9}, {3.639552699175576*^9, 3.6395527087301226`*^9}, {
   3.6395538528685637`*^9, 3.6395539002262726`*^9}, 3.709802181172696*^9, {
   3.7141095661741467`*^9, 3.714109588987454*^9}, 3.7141096391043234`*^9},
 CellID->125414378,ExpressionUUID->"6440319d-e584-4d47-a3a3-56b878f8b264"],

Cell[BoxData[
 RowBox[{"diffusion", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"c", "[", 
       RowBox[{"t", ",", "x"}], "]"}], "/.", "nds"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}], ",", " ", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\< t\>\"", ",", "Italic", ",", "16"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"\"\< x\>\"", "<>", "\"\<  \>\""}], ",", "Italic", ",", 
         "16"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<c  \>\"", ",", "Italic", ",", "16"}], "]"}]}], "}"}]}], 
    ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "100"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "2", ",", "2"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.709802185282082*^9, 3.709802202828988*^9}, {
  3.710922897498994*^9, 3.7109228988690715`*^9}, {3.710922941157494*^9, 
  3.71092301305761*^9}, {3.714109595256811*^9, 
  3.714109624600491*^9}},ExpressionUUID->"e478d82b-0a20-42c0-9b37-\
496f5025ad85"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig6.4\>\"", ",", "diffusion"}], "]"}]], "Input",
 CellChangeTimes->{{3.7098022095633755`*^9, 3.7098022318602943`*^9}, 
   3.7100819849075418`*^9, {3.728566156300008*^9, 
   3.7285661729928813`*^9}},ExpressionUUID->"df110def-4b7b-409f-a3c9-\
b305af7260af"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 6.5", "Subsubsection",
 CellChangeTimes->{{3.7285662055907454`*^9, 3.728566206485798*^9}, 
   3.728643848291566*^9},ExpressionUUID->"4780abde-4d85-4694-baac-\
e4a1205977c5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ar", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", " ", 
     RowBox[{
      RowBox[{"2", "\"\<X\>\""}], "\[Rule]", " ", 
      RowBox[{"\"\<X\>\"", "\[Rule]", " ", 
       RowBox[{
       "0", " ", "\[ShortLeftArrow]", "\"\<Y\>\"", " ", "\[ShortLeftArrow]", 
        " ", 
        RowBox[{"2", "\"\<Y\>\""}]}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7150873531015615`*^9, 3.7150873542421885`*^9}, 
   3.7286466426454716`*^9},ExpressionUUID->"f25ac3ca-0e00-4409-a962-\
cdf4d2ccfb80"],

Cell[BoxData[
 RowBox[{"generalizedlv", "=", 
  RowBox[{
   RowBox[{"ShowFHJGraph", "[", 
    RowBox[{"ar", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"#", ",", "Italic", ",", "16"}], "]"}], "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{
       "\"\<c\>\"", ",", "\"\<b\>\"", ",", "\"\<a\>\"", ",", "\"\<e\>\"", 
        ",", "\"\<f\>\""}], "}"}]}], ",", 
     RowBox[{"DirectedEdges", "->", "True"}], ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
     RowBox[{"EdgeRenderingFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Arrowheads", "[", "0.025", "]"}], ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"#", ",", "0.1"}], "]"}], ",", 
          RowBox[{"Inset", "[", 
           RowBox[{"#3", ",", 
            RowBox[{"Mean", "[", "#1", "]"}], ",", "Bottom"}], "]"}]}], "}"}],
         "&"}], ")"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "800"}]}], "]"}], "/.", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ReactionsData", "[", "ar", "]"}], "[", "\"\<complexes\>\"", 
      "]"}], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"ToString", "[", "#", "]"}], ",", "14"}], "]"}], "&"}], "/@", 
       RowBox[{
        RowBox[{"ReactionsData", "[", "ar", "]"}], "[", "\"\<complexes\>\"", 
        "]"}]}], ")"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.639647260765333*^9, 3.6396474921165657`*^9}, {
   3.71410983516955*^9, 3.714109845872164*^9}, {3.7150855388683558`*^9, 
   3.7150855734753356`*^9}, {3.715085610424452*^9, 3.7150856168908215`*^9}, 
   3.7150857505724773`*^9, {3.7150857883186417`*^9, 3.7150858320519447`*^9}, {
   3.7150859034427085`*^9, 3.7150859334115176`*^9}, {3.715085975927225*^9, 
   3.7150859915678816`*^9}, {3.7150860238023195`*^9, 
   3.7150863340562515`*^9}, {3.7150863649000607`*^9, 
   3.7150863658375635`*^9}, {3.715086402697011*^9, 3.7150864355251994`*^9}, {
   3.715086499150324*^9, 3.7150865053534613`*^9}, {3.715086831963958*^9, 
   3.71508688279218*^9}, {3.7150869359172845`*^9, 3.7150869745111103`*^9}, {
   3.715087202680668*^9, 3.715087217463513*^9}, {3.7150873299608927`*^9, 
   3.7150875838207617`*^9}, {3.7150876569927807`*^9, 
   3.715087922399551*^9}},ExpressionUUID->"d12422e4-fd25-47d3-996d-\
9e52f5a0140a"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig6.5\>\"", ",", "generalizedlv"}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.715087949477727*^9, {3.728566218160467*^9, 
   3.728566234254389*^9}},ExpressionUUID->"437752c8-bf24-45a8-bb98-\
9348ccd1c701"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"9a131250-6a2d-416f-9b2e-\
5b130782d2dd"],

Cell["\<\
6.2 Heuristic Derivation of the Induced Kinetic Differential Equation\
\>", "Subsubsection",
 CellChangeTimes->{{3.7141099912614903`*^9, 3.714110010602598*^9}, {
  3.7290781454484797`*^9, 
  3.7290781470578585`*^9}},ExpressionUUID->"9d90d175-7161-43f7-b547-\
e71106e7e1d3"],

Cell[CellGroupData[{

Cell["(Robertson reaction, p. 77)", "Subsubsection",
 CellChangeTimes->{{3.712405827841268*^9, 3.7124058323876967`*^9}, {
  3.7290781841360564`*^9, 3.72907820387047*^9}, {3.7290782680424705`*^9, 
  3.7290782700424733`*^9}},ExpressionUUID->"e6d2fb1f-8cb4-4566-8edd-\
8d1419738bb5"],

Cell[BoxData[
 RowBox[{"First", "@", 
  RowBox[{"DeterministicModel", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Robertson\>\"", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.712405834512975*^9, 3.712405874061413*^9}, {
  3.7141099682231703`*^9, 
  3.7141099733204613`*^9}},ExpressionUUID->"36493308-508d-49fc-a05f-\
234c43d110b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
6.3 Equivalent Forms of the Induced Kinetic Differential Equations,
p. 80\
\>", "Subsubsection",
 CellChangeTimes->{{3.714110042841443*^9, 3.7141100630666027`*^9}, {
  3.7290782217455053`*^9, 3.7290782231517572`*^9}, {3.730442616523354*^9, 
  3.730442624601497*^9}},ExpressionUUID->"bd6ff6b2-14b1-44b7-883e-\
d28e1d6b005a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gamma", "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{
      RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
      RowBox[{"ExternalSpecies", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}], "[", 
    "\"\<\[Gamma]\>\"", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.712406590313859*^9, 3.712406634358138*^9}, {
  3.7141102926987524`*^9, 3.714110293585803*^9}, {3.7290783150269375`*^9, 
  3.729078317073818*^9}, {3.7304426733047156`*^9, 
  3.730442673914091*^9}},ExpressionUUID->"9df425b0-f1dd-4a19-8bd7-\
59d63f883e25"],

Cell[BoxData[
 RowBox[{
  RowBox[{"alpha", "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{
      RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
      RowBox[{"ExternalSpecies", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}], "[", 
    "\"\<\[Alpha]\>\"", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.712406664982017*^9, 3.7124066688430367`*^9}, 
   3.7124067275306225`*^9, 3.729078319183194*^9, {3.730442661929695*^9, 
   3.730442667507829*^9}},ExpressionUUID->"4d6ba9a5-3e2e-4daa-acea-\
4760116af1a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"gamma", ".", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "1"], ",", 
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", "3"]}], "}"}], "]"}]}], ")"}], ".", 
  RowBox[{"Times", "@@", 
   SuperscriptBox[
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "alpha"]}]}]], "Input",
 CellChangeTimes->{{3.714110358304508*^9, 3.714110384606015*^9}, 
   3.714110435719943*^9},ExpressionUUID->"2224b2aa-e59f-41b5-885b-\
a5f2dad20ac4"],

Cell["Mind the dot!", "Text",
 CellChangeTimes->{{3.714110454668027*^9, 
  3.7141104612294025`*^9}},ExpressionUUID->"8f784922-169d-4b60-a7bf-\
028bebd6c5a3"],

Cell[BoxData[
 RowBox[{"gamma", ".", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"]}], "}"}], 
    RowBox[{"Times", "@@", 
     SuperscriptBox[
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "alpha"]}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.7124066454199743`*^9, 3.712406734633729*^9}, {
  3.7141102983810773`*^9, 
  3.714110311655837*^9}},ExpressionUUID->"70c7031a-6c7f-4b6a-9f0f-\
66a2d6dc30ad"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.714110106745104*^9, 3.7141101552308807`*^9}, {
  3.7141101985113583`*^9, 3.7141102140942497`*^9}, {3.714110270048456*^9, 
  3.71411027695485*^9}},ExpressionUUID->"425a30aa-0032-4b37-99df-\
35d29d04daf0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3.2 Complexes emphasized", "Subsubsection",
 CellChangeTimes->{{3.7124084814832096`*^9, 3.712408485567035*^9}, {
  3.7141189953911242`*^9, 3.714119009662943*^9}, {3.714119299037514*^9, 
  3.714119299406535*^9}, {3.729078358839327*^9, 
  3.729078360548425*^9}},ExpressionUUID->"7e2b713a-cc02-4214-aee6-\
08a2d4171457"],

Cell["\<\
How do we onstruct the matix of complex vectors? Let us do this on the \
example of the Michaelis-Menten reaction.\
\>", "Text",
 CellChangeTimes->{{3.7290801255864754`*^9, 3.729080158227165*^9}, 
   3.729080371868206*^9, {3.730442785929934*^9, 
   3.7304427943362036`*^9}},ExpressionUUID->"a5d53028-d0ad-496d-8ed3-\
91bdec2bf4b4"],

Cell[BoxData[
 RowBox[{"Y1", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], "]"}], "[", 
   "\"\<complexes\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.7124085031609945`*^9, 3.7124085486742797`*^9}, {
   3.7124086189364924`*^9, 3.712408627208511*^9}, 
   3.7290798089469824`*^9},ExpressionUUID->"bd7837b3-ba06-4f7b-89c6-\
9dcc9f75b787"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"ToExpression", ",", "Y1", ",", 
    RowBox[{"{", 
     RowBox[{"-", "1"}], "}"}]}], "]"}], "/.", 
  RowBox[{"E", "->", "EE"}]}]], "Input",
 CellChangeTimes->{
  3.7290798122811747`*^9},ExpressionUUID->"06dcdca6-1d0f-4ea3-a671-\
c44ea0022c6f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"CoefficientArrays", "[", 
    RowBox[{
     RowBox[{"EE", "+", "S"}], ",", 
     RowBox[{"{", 
      RowBox[{"EE", ",", "S", ",", "C", ",", "P"}], "}"}]}], "]"}], "]"}], 
  "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7290795240125713`*^9, 3.72907954829387*^9}, {
  3.729079743444232*^9, 
  3.7290797552869067`*^9}},ExpressionUUID->"0129fb41-cfb1-4a31-875b-\
408404e73092"],

Cell[BoxData[
 RowBox[{"Y2", "=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"DeleteDuplicates", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Normal", "[", 
        RowBox[{"CoefficientArrays", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"EE", ",", "S", ",", "C", ",", "P"}], "}"}]}], "]"}], 
        "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{"ToExpression", ",", "Y1", ",", 
         RowBox[{"{", 
          RowBox[{"-", "1"}], "}"}]}], "]"}], "/.", 
       RowBox[{"E", "->", "EE"}]}], ")"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7290796695239954`*^9, 3.7290797111723814`*^9}, {
   3.729079778756251*^9, 3.729079779358284*^9}, {3.7290798381826577`*^9, 
   3.729079989075189*^9}, {3.729080279024276*^9, 3.7290802822117825`*^9}, 
   3.7301806848400116`*^9},ExpressionUUID->"3f6a1ebe-0351-4b14-b5d9-\
78de83eae7ae"],

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.729079863773118*^9, 
  3.7290798680933666`*^9}},ExpressionUUID->"c4cb7eea-5b2a-47a9-8565-\
67a260332fbf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "K", "]"}], ";", 
  RowBox[{"K", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", 
       RowBox[{"l", ",", "j"}]], 
      RowBox[{"Boole", "[", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ReactionsData", "[", 
           RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], "]"}], "[", 
          "\"\<reactionsteps\>\"", "]"}], ",", 
         RowBox[{"RightArrow", "[", 
          RowBox[{
           RowBox[{
           "Y1", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], ",", 
           RowBox[{
           "Y1", "\[LeftDoubleBracket]", "l", "\[RightDoubleBracket]"}]}], 
          "]"}]}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "3"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7141110625368395`*^9, 3.714111243143179*^9}, {
  3.7141113199955826`*^9, 3.7141113932487755`*^9}, {3.714111618001649*^9, 
  3.7141116271771736`*^9}, {3.7141187633048334`*^9, 3.7141188001889467`*^9}, {
  3.7141188837187304`*^9, 3.714118893161271*^9}, {3.730180713402569*^9, 
  3.7301807150119467`*^9}},ExpressionUUID->"d21222fe-fd6a-4373-bd1e-\
0a40c1b7f524"],

Cell["\<\
Now let us construct the right hand side of the induced kineetic differential \
equation.\
\>", "Text",
 CellChangeTimes->{{3.729080378711971*^9, 3.729080402555768*^9}, 
   3.7304428553050714`*^9},ExpressionUUID->"95acb202-a1e1-443e-80c3-\
2bbf98c1c1c1"],

Cell[BoxData[
 RowBox[{"Y2", ".", 
  RowBox[{"(", 
   RowBox[{"K", "-", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", "K", "]"}], ".", 
      RowBox[{"ConstantArray", "[", 
       RowBox[{"1", ",", "3"}], "]"}]}], "]"}]}], ")"}], ".", 
  RowBox[{"(", 
   RowBox[{"Times", "@@", 
    SuperscriptBox[
     RowBox[{"{", 
      RowBox[{"e", ",", "s", ",", "c", ",", "p"}], "}"}], "Y2"]}], 
   ")"}]}]], "Input",
 CellChangeTimes->{{3.714111691946883*^9, 3.714111757786652*^9}, 
   3.7141179864303455`*^9, {3.7141182551327333`*^9, 3.7141182843014035`*^9}, {
   3.71411859641328*^9, 3.714118599544456*^9}, {3.7290802447898335`*^9, 
   3.729080259914863*^9}, {3.729080302102446*^9, 
   3.729080308430583*^9}},ExpressionUUID->"b8cc1e3a-c99d-454f-8749-\
1288093aeac1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3.3 Network structure emphasized", "Subsubsection",
 CellChangeTimes->{{3.7141191264106274`*^9, 3.714119136826225*^9}, {
  3.7141192719829636`*^9, 3.714119305306873*^9}, {3.729080435524582*^9, 
  3.729080437696461*^9}},ExpressionUUID->"c7c7f6dd-c62f-432a-9b02-\
dea63165c4ab"],

Cell[BoxData[
 RowBox[{"ShowFHJGraph", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7124087232331667`*^9, 3.712408825920351*^9}, {
  3.730180954324915*^9, 
  3.7301809586061716`*^9}},ExpressionUUID->"12808716-b3a0-4d07-935e-\
9ac1a531e99e"],

Cell[BoxData[
 RowBox[{"\[CapitalEpsilon]", "=", 
  RowBox[{"IncidenceMatrix", "[", 
   RowBox[{"Graph", "[", 
    RowBox[{
     RowBox[{"ReactionsData", "[", 
      RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}], "[", 
     "\"\<fhjgraphedges\>\"", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7301809674186907`*^9, 3.730180975824958*^9}, {
  3.730181070840768*^9, 3.7301810905751815`*^9}, {3.730181122512744*^9, 
  3.7301811257627497`*^9}, {3.730196690316677*^9, 3.7301966946760597`*^9}, {
  3.730968601024268*^9, 
  3.7309686073992805`*^9}},ExpressionUUID->"49797228-79ff-4ce2-9b0b-\
d70d62b96212"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"\[CapitalEpsilon]", ",", 
   RowBox[{"TableHeadings", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"ReactionsData", "[", 
        RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}], "[", 
       "\"\<complexes\>\"", "]"}], ",", " ", 
      RowBox[{
       RowBox[{"ReactionsData", "[", 
        RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}], "[", 
       "\"\<fhjgraphedges\>\"", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730442956899021*^9, 3.730443021867897*^9}, {
  3.7304430691492395`*^9, 
  3.7304430824148893`*^9}},ExpressionUUID->"259d21c7-e196-4cb9-95fe-\
43d1d11ab59f"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"ToExpression", ",", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{
      RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
    "\"\<complexes\>\"", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",ExpressionUUID->"68efb01c-\
7e11-45c7-b107-212390bb567f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Normal", "[", 
     RowBox[{"CoefficientArrays", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        RowBox[{"X", ",", "Y"}], "}"}]}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{"Map", "[", 
    RowBox[{"ToExpression", ",", 
     RowBox[{
      RowBox[{"ReactionsData", "[", 
       RowBox[{
        RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
      "\"\<complexes\>\"", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"-", "1"}], "}"}]}], "]"}]}], "/.", 
  RowBox[{
   RowBox[{"{", "0", "}"}], "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7301815439198213`*^9, 3.7301815453573213`*^9}, {
  3.7301815983261747`*^9, 
  3.730181636279374*^9}},ExpressionUUID->"e36d4686-9686-437a-be70-\
4055438a6388"],

Cell[BoxData[
 RowBox[{"YY", "=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"Last", "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Normal", "[", 
          RowBox[{"CoefficientArrays", "[", 
           RowBox[{"#", ",", 
            RowBox[{"{", 
             RowBox[{"X", ",", "Y"}], "}"}]}], "]"}], "]"}], "&"}], "/@", 
        RowBox[{"(", 
         RowBox[{"Map", "[", 
          RowBox[{"ToExpression", ",", 
           RowBox[{
            RowBox[{"ReactionsData", "[", 
             RowBox[{
              RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
            "\"\<complexes\>\"", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"-", "1"}], "}"}]}], "]"}], ")"}]}], ")"}], "/.", 
      RowBox[{
       RowBox[{"{", "0", "}"}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], ")"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.730181392075771*^9, 3.7301814434664965`*^9}, 
   3.7301814738728056`*^9, {3.7301815058416204`*^9, 3.7301815096697516`*^9}, {
   3.7301816636544275`*^9, 3.730181699638873*^9}, {3.730181736763945*^9, 
   3.730181748295219*^9}, {3.730181807639083*^9, 3.7301819268736925`*^9}, {
   3.7301820342801523`*^9, 
   3.7301820565770726`*^9}},ExpressionUUID->"18d7e62b-1d6f-480e-af7e-\
6f6b497a668d"],

Cell[BoxData[
 RowBox[{"YY", ".", "\[CapitalEpsilon]", ".", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"]}], "}"}], " ", 
    RowBox[{"Times", "@@", 
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], 
       RowBox[{
        RowBox[{"ReactionsData", "[", 
         RowBox[{
          RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
        "\"\<\[Alpha]\>\"", "]"}]], ")"}]}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.7301811473409176`*^9, 3.730181259122386*^9}, {
  3.7301813020443463`*^9, 3.730181329903775*^9}, {3.730181931545576*^9, 
  3.7301819324987044`*^9}, {3.730181982389426*^9, 3.7301819893894386`*^9}, {
  3.7301820621708307`*^9, 
  3.7301820821396203`*^9}},ExpressionUUID->"8d636c8e-2970-4493-89e6-\
fe1c185eb405"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3.4 Reaction rate coefficients emphasized", "Subsubsection",
 CellChangeTimes->{{3.7141193101811523`*^9, 3.7141193242869606`*^9}, {
  3.7292409633201976`*^9, 
  3.729240964976451*^9}},ExpressionUUID->"60b172e8-aa08-490c-ad66-\
723deb684187"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "rhs", ",", "k1", ",", "k2", ",", "k3", ",", "dd", ",", "ff", ",", "gg"}], 
   "]"}], ";", 
  RowBox[{
   RowBox[{"rhs", "[", 
    RowBox[{"{", 
     RowBox[{"k1_", ",", "k2_", ",", "k3_"}], "}"}], "]"}], ":=", 
   RowBox[{"RightHandSide", "[", 
    RowBox[{
     RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"ExternalSpecies", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.712409442874403*^9, 3.712409486889805*^9}, {
  3.712409517389762*^9, 3.712409575507033*^9}, {3.714119350968488*^9, 
  3.714119366150357*^9}, {3.730443149508771*^9, 
  3.730443150024397*^9}},ExpressionUUID->"d1fc426e-d767-460e-bc95-\
e9dbbd2d8a97"],

Cell[BoxData[
 RowBox[{"rhs", "[", 
  RowBox[{"{", 
   RowBox[{"dd", ",", "ff", ",", "hh"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7124095844685917`*^9, 
  3.7124095915929437`*^9}},ExpressionUUID->"2b8562b3-501e-4e89-a540-\
9d566679e945"],

Cell[BoxData[
 RowBox[{"G", "=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"rhs", "/@", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7124095991777687`*^9, 3.7124096198266907`*^9}, {
  3.712409706777235*^9, 
  3.7124097094729366`*^9}},ExpressionUUID->"2c894ae2-a0cd-4c92-94f8-\
40675cc36cb9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rhs", "[", 
   RowBox[{"{", 
    RowBox[{"\[Kappa]1", ",", "\[Kappa]2", ",", "\[Kappa]3"}], "}"}], "]"}], 
  "\[Equal]", 
  RowBox[{"G", ".", 
   RowBox[{"{", 
    RowBox[{"\[Kappa]1", ",", "\[Kappa]2", ",", "\[Kappa]3"}], 
    "}"}]}]}]], "Input",
 CellChangeTimes->{{3.712409442874403*^9, 3.7124094973584814`*^9}, {
  3.712409628437525*^9, 3.7124097187300105`*^9}, {3.712409777333243*^9, 
  3.7124097868281045`*^9}},ExpressionUUID->"b5f948ee-559a-4d06-8d7c-\
f7ca4e4480f8"],

Cell["Returning to", "Text",
 CellChangeTimes->{{3.7304432297276783`*^9, 
  3.730443232149559*^9}},ExpressionUUID->"15036d89-f4fc-4555-ab2e-\
17f8e682661a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 6.11", "Subsubsection",
 CellChangeTimes->{{3.7304432383526955`*^9, 
  3.730443241618327*^9}},ExpressionUUID->"c7c4fc42-65e9-4411-a63f-\
4d035b501a45"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", "\"\<Mole\>\"", "}"}], "]"}], "[", "\"\<fhjgraphedges\>\"", 
  "]"}]], "Input",
 CellChangeTimes->{{3.7304433249934893`*^9, 
  3.7304433525716686`*^9}},ExpressionUUID->"2bff77ed-d907-456d-9f79-\
f7e0abec11d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "rhs", "]"}], ";", 
  RowBox[{
   RowBox[{"rhs", "[", 
    RowBox[{"{", 
     RowBox[{"k1_", ",", "k2_", ",", "km2_", ",", "k3_", ",", "km3_"}], "}"}],
     "]"}], ":=", 
   RowBox[{"RightHandSide", "[", 
    RowBox[{
     RowBox[{"{", "\"\<Mole\>\"", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k1", ",", "k2", ",", "km2", ",", "k3", ",", "km3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7304432784465227`*^9, 3.730443305102827*^9}, {
  3.7304433632435646`*^9, 3.730443413399912*^9}, {3.7304435996346517`*^9, 
  3.730443640759733*^9}, {3.730443685291069*^9, 
  3.7304437020723515`*^9}},ExpressionUUID->"551691c5-87fd-403d-b34a-\
749d6c465cc6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"rhs", "/@", 
     RowBox[{"IdentityMatrix", "[", "5", "]"}]}], "]"}], ".", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", 
      RowBox[{"-", "2"}]], ",", 
     SubscriptBox["k", "3"], ",", 
     SubscriptBox["k", 
      RowBox[{"-", "3"}]]}], "}"}]}], "\[Equal]", 
  RowBox[{"rhs", "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", 
      RowBox[{"-", "2"}]], ",", 
     SubscriptBox["k", "3"], ",", 
     SubscriptBox["k", 
      RowBox[{"-", "3"}]]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7304434459937277`*^9, 3.730443455587495*^9}, {
  3.7304435085719824`*^9, 3.730443527790761*^9}, {3.7304436512128773`*^9, 
  3.7304436815566864`*^9}, {3.730443728697405*^9, 
  3.730443741963056*^9}},ExpressionUUID->"a987d9b0-f781-4365-8cee-\
5421f244ee19"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3.5 Evolution equation for the reaction extent", "Subsubsection",
 CellChangeTimes->{{3.712410107556094*^9, 3.7124101111871595`*^9}, {
  3.714119407376719*^9, 3.714119416793257*^9}, {3.729240997132763*^9, 
  3.7292409989765177`*^9}},ExpressionUUID->"1d310eb6-6685-4915-8459-\
9773d2620bc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"alpha", ",", "gamma"}], "}"}], "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], "]"}], "[", 
    RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<\[Gamma]\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7301967346136384`*^9, 
  3.730196742488655*^9}},ExpressionUUID->"1ab8cbf1-3b5d-436e-8523-\
7a3833cabe36"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"v", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"w", "'"}], "[", "t", "]"}]}], "}"}], "==", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}], 
      RowBox[{"Times", "@@", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"e0", ",", "s0", ",", "0", ",", "0"}], "}"}], "+", 
          RowBox[{"gamma", ".", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"u", "[", "t", "]"}], ",", 
             RowBox[{"v", "[", "t", "]"}], ",", 
             RowBox[{"w", "[", "t", "]"}]}], "}"}]}]}], ")"}], "alpha"]}]}]}],
     "]"}], "//", "Expand"}], "//", "Column"}]], "Input",
 CellChangeTimes->{{3.712410119327211*^9, 3.7124101861235576`*^9}, {
  3.712410366372428*^9, 
  3.712410440879572*^9}},ExpressionUUID->"6740321f-e5a3-44bf-9223-\
b45af9bca7ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.5 Polynomial and Kinetic Differential Equations", "Section",
 CellChangeTimes->{{3.7124589660583296`*^9, 3.712458969914589*^9}, {
  3.7141196227980533`*^9, 3.7141196434912395`*^9}, {3.72924090300758*^9, 
  3.7292409041638317`*^9}},ExpressionUUID->"52be1dd3-b686-4b2b-a11d-\
a069ec2e5679"],

Cell[CellGroupData[{

Cell["Example 6.26", "Subsubsection",
 CellChangeTimes->{{3.712459016267826*^9, 3.7124590187869396`*^9}, {
  3.729241057039131*^9, 
  3.729241067523526*^9}},ExpressionUUID->"29851799-5473-4ab6-a457-\
75fdbc164880"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CrossEffectQ", "[", 
   RowBox[{"polyval_", ",", "vars_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"M", "=", 
      RowBox[{"Length", "[", "vars", "]"}]}], "}"}], ",", 
    RowBox[{"And", "@@", 
     RowBox[{"(", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"Negative", "[", "#", "]"}], "]"}], "&"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"MapThread", "[", 
          RowBox[{"ReplaceAll", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"MonomialList", "[", 
              RowBox[{"polyval", ",", "vars"}], "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Thread", "[", 
                RowBox[{"vars", "\[Rule]", "#"}], "]"}], "&"}], " ", "/@", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"IdentityMatrix", "[", "M", "]"}]}], ")"}]}]}], 
            "}"}]}], "]"}], "]"}]}], "]"}], ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7124590212400594`*^9, 3.7124590485599117`*^9}, {
   3.712459084926659*^9, 3.712459106080737*^9}, {3.712459145842223*^9, 
   3.7124592627799425`*^9}, 3.71245933242745*^9, 
   3.7124594133371153`*^9},ExpressionUUID->"7788ead9-b36d-4489-b73f-\
3c450a4612be"],

Cell[BoxData[
 RowBox[{"CrossEffectQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"c", "-", 
      RowBox[{"4", "y", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"5", "x", " ", "y"}], "+", 
      RowBox[{"6", "z"}], "+", 
      RowBox[{"7", "w"}]}], ",", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{"-", "b"}], " ", "x", " ", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712459439956872*^9, 
  3.7124594731915245`*^9}},ExpressionUUID->"41af5e85-05fe-4559-9329-\
7aa20fed538a"],

Cell["Second solution", "Text",
 CellChangeTimes->{{3.7124595298065405`*^9, 3.7124595325085254`*^9}, {
  3.730443868744554*^9, 
  3.7304438691508036`*^9}},ExpressionUUID->"15ae7ca6-ffa4-4a3d-947d-\
63f276a74155"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CrossEffectQ2", "[", 
   RowBox[{"polyval_", ",", "vars_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"M", "=", 
       RowBox[{"Length", "[", "vars", "]"}]}], ",", "L"}], "}"}], ",", "\n", 
    RowBox[{
     RowBox[{
      RowBox[{"L", "[", "i_", "]"}], ":=", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", 
           RowBox[{"polyval", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "]"}], "===", "Plus"}], ",", 
         RowBox[{"Apply", "[", 
          RowBox[{"List", ",", 
           RowBox[{"polyval", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"polyval", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "}"}]}], "]"}], "/.", 
       RowBox[{"MapThread", "[", 
        RowBox[{"Rule", ",", 
         RowBox[{"{", 
          RowBox[{"vars", ",", 
           RowBox[{"ReplacePart", "[", 
            RowBox[{
             RowBox[{"ConstantArray", "[", 
              RowBox[{"1", ",", "M"}], "]"}], ",", " ", 
             RowBox[{
              RowBox[{"{", "i", "}"}], "\[Rule]", "0"}]}], "]"}]}], "}"}]}], 
        "]"}]}]}], ";", "\n", 
     RowBox[{"And", "@@", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "\[GreaterEqual]", "0"}], "&"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"L", "[", "i", "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "M"}], "}"}]}], "]"}], "]"}]}], 
       "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7124590212400594`*^9, 3.7124590485599117`*^9}, {
   3.712459084926659*^9, 3.712459106080737*^9}, {3.712459145842223*^9, 
   3.7124592627799425`*^9}, 3.7124594342007947`*^9, {3.712459510203595*^9, 
   3.7124596302730007`*^9}},ExpressionUUID->"24d121be-a11d-4da3-8af9-\
7abf3563b589"],

Cell[BoxData[
 RowBox[{"CrossEffectQ2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"c", "-", 
      RowBox[{"4", "y", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"5", "x", " ", "y"}], "+", 
      RowBox[{"6", "z"}], "+", 
      RowBox[{"7", "w"}]}], ",", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{"-", "b"}], " ", "x", " ", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712459439956872*^9, 3.7124594731915245`*^9}, 
   3.712459649848319*^9},ExpressionUUID->"47ce7a19-b59c-4555-ad54-\
01fed2dbad75"],

Cell[BoxData[
 RowBox[{
  RowBox[{"harmonic", "=", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "x"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.730182288098065*^9, 
  3.730182333504402*^9}},ExpressionUUID->"15ce9b16-4696-48a5-a8f9-\
525ad7ed9b53"],

Cell[BoxData[
 RowBox[{"CrossEffectQ", "[", 
  RowBox[{"harmonic", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7301822963637047`*^9, 
  3.7301823725201063`*^9}},ExpressionUUID->"c569c74e-53e1-4e9c-bea4-\
7ae9a9dba0f3"],

Cell[BoxData[
 RowBox[{"CrossEffectQ2", "[", 
  RowBox[{"harmonic", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7301822963637047`*^9, 
  3.7301823618013353`*^9}},ExpressionUUID->"52f0ccc8-904e-4ee8-8fe3-\
590dde27611f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"\[Sigma]", ",", "\[Beta]", ",", "x", ",", "y"}], "]"}], ";", 
  RowBox[{"lorenz", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Sigma]", " ", 
      RowBox[{"(", 
       RowBox[{"y", " ", "-", "z"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"\[Rho]", " ", "x"}], "-", 
      RowBox[{"x", " ", "z"}]}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", 
      RowBox[{"\[Beta]", " ", "z"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7304439004321175`*^9, 
  3.730444053619915*^9}},ExpressionUUID->"c98a3ac2-9937-4ec9-8191-\
fcfe8d0a46af"],

Cell[BoxData[
 RowBox[{"Through", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"CrossEffectQ", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "&"}], ",", 
     RowBox[{
      RowBox[{"CrossEffectQ2", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "&"}]}], "}"}], 
   "[", "lorenz", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7304440677605677`*^9, 
  3.7304441443388414`*^9}},ExpressionUUID->"04bd681a-aa94-40d4-89b6-\
60cc85fcd2d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 6.30 ", "Subsubsection",
 CellChangeTimes->{
  3.7141197983811097`*^9, {3.729241094320453*^9, 3.7292410955704565`*^9}, {
   3.7304442690422096`*^9, 
   3.7304442812766104`*^9}},ExpressionUUID->"fb4f8094-8372-4749-8cee-\
1b985f616bec"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<N2O5\>\"", "\[Rule]", 
     RowBox[{
      RowBox[{"2", "\"\<NO2\>\""}], "+", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "\"\<O2\>\""}]}]}], "}"}], ",", 
   RowBox[{"{", "k", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730196799363764*^9, 3.7301968543482475`*^9}, {
  3.730196901503834*^9, 
  3.730196902961914*^9}},ExpressionUUID->"8016d5b8-3588-467e-b4e0-\
141bac471e7d"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<NH4NO2\>\"", "\[Rule]", 
     RowBox[{"\"\<N2\>\"", "+", 
      RowBox[{"2", "\"\<H2O\>\""}]}]}], "}"}], ",", 
   RowBox[{"{", "k", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730196799363764*^9, 
  3.7301968939577007`*^9}},ExpressionUUID->"cfdd897b-d158-43f3-88ae-\
8ce57975134f"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\"\<NO2\>\""}], "\[Rule]", 
     RowBox[{
      RowBox[{"2", "\"\<NO\>\""}], "+", "\"\<O2\>\""}]}], "}"}], ",", 
   RowBox[{"{", "k", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730196799363764*^9, 
  3.730196916838603*^9}},ExpressionUUID->"d70ac236-fe42-4619-87b6-\
2174f72ac04b"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "\"\<NO\>\""}], "+", "\"\<O2\>\""}], "\[Rule]", 
     RowBox[{"2", "\"\<NO2\>\""}]}], "}"}], ",", 
   RowBox[{"{", "k", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730196799363764*^9, 
  3.7301969440730314`*^9}},ExpressionUUID->"89ecded9-6fbe-4f38-a491-\
fef243791e63"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 6.31", "Subsubsection",
 CellChangeTimes->{
  3.7141197983811097`*^9, {3.729241094320453*^9, 3.7292410955704565`*^9}, {
   3.7301969580730605`*^9, 3.730196969979335*^9}, {3.7304442916360054`*^9, 
   3.7304442926360073`*^9}},ExpressionUUID->"ea4eb9a0-c79f-4b03-bea1-\
0fa417338b3e"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\"\<NH3\>\""}], "\[Rule]", 
     RowBox[{"\"\<N2\>\"", "+", 
      RowBox[{"3", "\"\<H2\>\""}]}]}], "}"}], ",", 
   RowBox[{"{", "k", "}"}], ",", 
   RowBox[{"MassAction", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.73019697960435*^9, 
  3.7301969936981297`*^9}},ExpressionUUID->"5c7f8693-5a75-4b51-92b7-\
1e33b1cfa451"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "\"\<NO2\>\""}], "+", "\"\<F2\>\""}], "\[Rule]", 
     RowBox[{"2", "\"\<NO2F\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\"\<NO2\>\"", "\"\<F2\>\""}], "}"}], ",", 
   RowBox[{"MassAction", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.73019697960435*^9, 
  3.7301970259481926`*^9}},ExpressionUUID->"93e2e6cb-3596-4efc-beff-\
82cd87002e99"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<H2\>\"", "+", "\"\<Br2\>\""}], "\[Rule]", 
     RowBox[{"2", "\"\<HBr\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\"\<H2\>\"", 
     SuperscriptBox["\"\<Br2\>\"", 
      FractionBox["1", "2"]]}], "}"}], ",", 
   RowBox[{"MassAction", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.73019697960435*^9, 3.730197072995159*^9}, {
  3.730444398886217*^9, 
  3.730444410417488*^9}},ExpressionUUID->"8de2fff0-acbe-4f82-bed1-\
ca5c018c90ad"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<CH3CHO\>\"", "\[Rule]", 
     RowBox[{"\"\<CH4\>\"", "+", "\"\<CO\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", 
     SuperscriptBox["\"\<CH3CHO\>\"", 
      FractionBox["3", "2"]]}], "}"}], ",", 
   RowBox[{"MassAction", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.73019697960435*^9, 3.730197115776493*^9}, {
  3.7304444223237605`*^9, 
  3.7304444293237734`*^9}},ExpressionUUID->"5c600d11-f0fe-47eb-94ec-\
d9651e624b7e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "K", "]"}], ";", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<S\>\"", "\[Rule]", "\"\<P\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", " ", 
      SubscriptBox["e", "0"], " ", 
      RowBox[{"\"\<S\>\"", "/", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["K", "M"], "+", "\"\<S\>\""}], ")"}]}]}], "}"}], ",", 
    RowBox[{"MassAction", "\[Rule]", "False"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.73019697960435*^9, 3.730197217104816*^9}, {
  3.730444368276782*^9, 
  3.730444389542446*^9}},ExpressionUUID->"ffe2db4c-5b9d-401b-bc24-\
49126b41aaa7"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<H2\>\"", "+", "\"\<Br2\>\""}], "\[Rule]", 
     RowBox[{"2", "\"\<HBr\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\"\<H2\>\"", 
     RowBox[{
      RowBox[{"\"\<Br2\>\"", "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"KK", "\"\<HBr\>\""}], "+", "\"\<Br2\>\""}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"MassAction", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730197241339238*^9, 
  3.7301972630892825`*^9}},ExpressionUUID->"92c3c69a-ee01-4648-bedb-\
17d3a3c3e8f2"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stationary", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 3.7096139310971584`*^9}, {
  3.7097241728756065`*^9, 
  3.7097241786889396`*^9}},ExpressionUUID->"bcdf597f-fe59-4f80-880d-\
43aa68eec81c"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"6f098ca5-476c-4812-98bb-\
77b23c7f1b96"],

Cell[CellGroupData[{

Cell["Uniqueness of Stationary Points", "Subchapter",
 CellChangeTimes->{{3.5744287251969852`*^9, 3.574428730486993*^9}, {
  3.6379406681445045`*^9, 3.6379406744313154`*^9}, {3.709870685177552*^9, 
  3.7098706864275546`*^9}, {3.714121003520125*^9, 
  3.714121038970154*^9}},ExpressionUUID->"71191337-4aeb-4507-8560-\
9ebcce713e48"],

Cell[CellGroupData[{

Cell["Fig. 7.1", "Subsubsection",
 CellChangeTimes->{{3.7285667894092264`*^9, 3.728566790706104*^9}, 
   3.728643866869727*^9},ExpressionUUID->"5d6e4062-9b80-422e-90e3-\
16561f9564d5"],

Cell[BoxData[
 RowBox[{"statpoints", "=", 
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "/.", 
        RowBox[{"Rest", "[", 
         RowBox[{"StationaryPoints", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2", "\"\<X\>\""}], "\[DoubleLeftRightArrow]", 
             "\"\<Y\>\""}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"u", ",", "v"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}]}], "]"}], "/.", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Last", "[", 
         RowBox[{"First", "[", 
          RowBox[{"GammaLeftNullSpace", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"2", "\"\<X\>\""}], "\[DoubleLeftRightArrow]", 
              "\"\<Y\>\""}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"u", ",", "v"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}], "]"}], "/.", 
        RowBox[{"Plus", "\[Rule]", "Rule"}]}], ")"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], "]"}]}], ",", 
    RowBox[{"Prolog", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed", ",", 
          RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", 
            RowBox[{"-", "2"}]}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Dashing", "[", 
           RowBox[{"{", "}"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], "]"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], "]"}], ",", "Green", ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<S\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Kunstler Script\>\""}], ",", 
           "Bold", ",", "16"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "]"}], ",", "Red", ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<reaction\\nsimplex\>\"", ",", "Bold", ",", "16"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<(\!\(\*SubscriptBox[\(x\), \(0\)]\),\!\(\*SubscriptBox[\(y\), \
\(0\)]\))\>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "1"}], "}"}]}], "]"}], ",", "Blue", ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<E\>\"", ",", "Italic", ",", "Bold", ",", "16"}], "]"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "8"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", "Bold", ",", "Italic", ",", "12"}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7105983694575214`*^9, 3.710598461633803*^9}, {
  3.710598520629179*^9, 3.710598565083723*^9}, {3.7105987151113157`*^9, 
  3.7105987314662523`*^9}, {3.7105990030198035`*^9, 3.71059900313381*^9}, {
  3.710599141758747*^9, 3.710599149182173*^9}, {3.7105992947895117`*^9, 
  3.710599345428413*^9}, {3.710930651523041*^9, 3.7109306519280615`*^9}, {
  3.730197286339326*^9, 
  3.7301972927612166`*^9}},ExpressionUUID->"28b97972-9704-4d78-825f-\
9908c6e3d8e3"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig7.1\>\"", ",", "statpoints"}], "]"}]], "Input",
 CellChangeTimes->{{3.6379420351255064`*^9, 3.6379420520650544`*^9}, {
   3.7098709498811955`*^9, 3.7098709585843368`*^9}, 3.7109306555182676`*^9, {
   3.728566911363267*^9, 
   3.7285669285612535`*^9}},ExpressionUUID->"12b73b5c-0e5c-440e-a7d7-\
30f8f388faf4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 7.2", "Subsubsection",
 CellChangeTimes->{{3.7285668089405146`*^9, 3.728566812190521*^9}, 
   3.728643878416624*^9},ExpressionUUID->"bf25bc44-aff5-40d4-adef-\
9085f176e2df"],

Cell[BoxData[
 RowBox[{"hjreaction", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "\"\<X\>\""}], "+", "\"\<Y\>\""}], "\[Rule]", 
       RowBox[{"3", " ", "\"\<X\>\""}]}], ",", 
      RowBox[{
       RowBox[{"3", " ", "\"\<X\>\""}], "\[Rule]", 
       RowBox[{"\"\<X\>\"", "+", 
        RowBox[{"2", " ", "\"\<Y\>\""}]}]}], ",", 
      RowBox[{
       RowBox[{"\"\<X\>\"", "+", 
        RowBox[{"2", " ", "\"\<Y\>\""}]}], "\[Rule]", 
       RowBox[{"3", " ", "\"\<Y\>\""}]}], ",", 
      RowBox[{
       RowBox[{"3", " ", "\"\<Y\>\""}], "\[Rule]", 
       RowBox[{
        RowBox[{"2", " ", "\"\<X\>\""}], "+", "\"\<Y\>\""}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"1", ",", "16"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\[CurlyEpsilon]", ",", "16"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"1", ",", "16"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\[CurlyEpsilon]", ",", "16"}], "]"}]}], "}"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"Method", "\[Rule]", "\"\<SpringEmbedding\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.637997032284379*^9, 3.637997107675691*^9}, {
  3.637997141170607*^9, 3.637997147498969*^9}, {3.6379971865852046`*^9, 
  3.63799724909378*^9}, {3.637997348508466*^9, 3.6379973539887795`*^9}, {
  3.637997424762828*^9, 3.6379974467690864`*^9}, {3.6379974934567566`*^9, 
  3.637997494727829*^9}, {3.6379978340702386`*^9, 3.637997979768572*^9}, {
  3.6402655350502977`*^9, 3.640265546173117*^9}, {3.640265641754485*^9, 
  3.6402657087098026`*^9}, {3.6402657399566574`*^9, 3.64026575254588*^9}, {
  3.6402658101879807`*^9, 3.6402658209052*^9}, {3.708839332986631*^9, 
  3.7088393553460493`*^9}},ExpressionUUID->"7527b3d6-0a40-41a1-a13d-\
5fb78545058f"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig7.2\>\"", ",", "hjreaction"}], "]"}]], "Input",
 CellChangeTimes->{{3.6379969082482843`*^9, 3.6379969135975904`*^9}, 
   3.70987100108442*^9, {3.728567034641709*^9, 3.7285670412667217`*^9}, 
   3.7285670745480375`*^9},ExpressionUUID->"1eec6799-40da-4da0-9ae0-\
dfd623c108c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 7.3", "Subsubsection",
 CellChangeTimes->{{3.728566825467348*^9, 3.7285668268144255`*^9}, 
   3.728643887244767*^9},ExpressionUUID->"29295aa4-cff8-45e2-8078-\
2088429e23fc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "statcurves", ",", "m", ",", "n", ",", "u", ",", "a", ",", "b", ",", 
    "\[Epsilon]", ",", "x", ",", "y"}], "]"}], ";", 
  RowBox[{
   RowBox[{"statcurves", "[", "u_", "]"}], ":=", 
   RowBox[{"PowerExpand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "/.", 
       RowBox[{"Cases", "[", 
        RowBox[{
         RowBox[{"Last", "[", 
          RowBox[{"Simplify", "[", 
           RowBox[{
            RowBox[{"StationaryPoints", "[", 
             RowBox[{
              RowBox[{"{", "\"\<Horn-Jackson\>\"", "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Epsilon]", ",", "1", ",", "\[Epsilon]", ",", "1"}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"m", ",", "n"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"Assumptions", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"0", "<", "\[Epsilon]", "<", 
               FractionBox["1", "6"]}], ")"}]}]}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"a_", "?", "TrueQ"}], ",", "b___"}], "}"}], "\[Rule]", 
          RowBox[{"{", "b", "}"}]}]}], "]"}]}], "/.", 
      RowBox[{"m", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"u", "-", "n"}], ")"}]}]}], "/.", 
     RowBox[{"\[Epsilon]", "\[Rule]", 
      RowBox[{"1", "/", "12"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.710926505599616*^9, 3.710926552017276*^9}, {
  3.710926673314221*^9, 3.7109266758163643`*^9}, {3.7141213952945595`*^9, 
  3.7141214170478053`*^9}, {3.730182536707925*^9, 3.730182537426676*^9}, {
  3.730197346323818*^9, 
  3.7301973541988335`*^9}},ExpressionUUID->"9da814cd-393f-411c-9b5d-\
cb71d673c047"],

Cell[BoxData[
 RowBox[{"hornjackson", "=", 
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"statcurves", "[", "u", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", "2.5"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], "]"}]}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Dashed", ",", "Green", ",", 
       RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"-", "2"}]}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"Dashing", "[", 
        RowBox[{"{", "0", "}"}], "]"}], ",", "Red", ",", 
       RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1.7"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.7", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1.0", ",", "0.7"}], "}"}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<(\!\(\*SubscriptBox[\(x\), \(0\)]\),\!\(\*SubscriptBox[\(y\), \
\(0\)]\))\>\"", ",", "Italic", ",", "Bold", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.4", ",", "0.7"}], "}"}]}], "]"}], ",", "Green", ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<S\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Kunstler Script\>\""}], ",", 
           "Bold", ",", "16"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.5"}], ",", "1.8"}], "}"}]}], "]"}], ",", "Red", 
       ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<simplex\>\"", ",", "Bold", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.8", ",", "1.4"}], "}"}]}], "]"}], ",", "Blue", ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<E\>\"", ",", "Italic", ",", "Bold", ",", "10"}], "]"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"1.85", ",", "0.5"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<E\>\"", ",", "Italic", ",", "Bold", ",", "10"}], "]"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"1.4", ",", "1.1"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<E\>\"", ",", "Italic", ",", "Bold", ",", "10"}], "]"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"0.2", ",", "1.8"}], "}"}]}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2.0"}], ",", "2.1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", "Bold", ",", "Italic", ",", "12"}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}], ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7109266027381787`*^9, 3.7109266415954046`*^9}, {
   3.7109266798425937`*^9, 3.7109267533418026`*^9}, {3.7109267910649643`*^9, 
   3.7109269131989613`*^9}, 
   3.71093067579243*^9},ExpressionUUID->"57f60476-22a2-4a7f-8fe3-\
171c7457ba97"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig7.3\>\"", ",", "hornjackson"}], "]"}]], "Input",
 CellChangeTimes->{{3.6379427948348866`*^9, 3.637942814113989*^9}, 
   3.7098711317878003`*^9, 3.7109269279148006`*^9, {3.728567053110493*^9, 
   3.728567061673012*^9}},ExpressionUUID->"4944ee24-c2c4-4dad-818c-\
08f5b0308aef"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 7.4", "Subsubsection",
 CellChangeTimes->{{3.7285668407562237`*^9, 3.7285668429313483`*^9}, 
   3.728643898572914*^9},ExpressionUUID->"00b2e660-6493-40d2-b296-\
3b0605d607b1"],

Cell[BoxData[
 RowBox[{"wegscheider", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ToReversible", "[", "\"\<Wegscheider\>\"", "]"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "16"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "1"], ",", 
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", "3"], ",", 
       SubscriptBox["k", "4"]}], "}"}]}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"Method", "\[Rule]", "\"\<SpringEmbedding\>\""}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7016670192075977`*^9, 3.701667021988854*^9}, {
  3.7016672008642035`*^9, 3.7016672942081366`*^9}, {3.7018451230993013`*^9, 
  3.7018451314897795`*^9}, {3.709871352303858*^9, 
  3.7098713871633015`*^9}},ExpressionUUID->"e20a7b1c-f2ba-460c-9d2f-\
082d97199a07"],

Cell[BoxData[
 RowBox[{
  RowBox[{"figurexp", "[", 
   RowBox[{"\"\<TothNagyPapp-Fig7.4A\>\"", ",", "wegscheider"}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.7098714112727222`*^9, {3.7285671303293962`*^9, 
   3.7285671402200403`*^9}},ExpressionUUID->"50a16243-b454-48a9-b90b-\
02e8acf591b4"],

Cell[BoxData[
 RowBox[{"triangle", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ToReversible", "[", "\"\<Triangle\>\"", "]"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "16"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "1"], ",", 
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", "3"], ",", 
       SubscriptBox["k", "4"], ",", 
       SubscriptBox["k", "5"], ",", 
       SubscriptBox["k", "6"]}], "}"}]}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5504788783838534`*^9, 3.550478904806331*^9}, {
   3.6380701191196513`*^9, 3.638070143735059*^9}, 3.701666587150011*^9, {
   3.7109270434694185`*^9, 3.7109270534689913`*^9}, 
   3.730609569964571*^9},ExpressionUUID->"344f7429-668c-42ea-af51-\
ca479abebb3d"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig7.4B\>\"", ",", "triangle"}], "]"}]], "Input",
 CellChangeTimes->{
  3.7098714194446135`*^9, 3.710930741947218*^9, {3.7285671514388123`*^9, 
   3.7285671589700775`*^9}},ExpressionUUID->"d4f61544-0aba-45d5-a322-\
d77939cca9ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 7.5", "Subsubsection",
 CellChangeTimes->{{3.7285672417358637`*^9, 3.728567242923366*^9}, 
   3.7286439180573273`*^9},ExpressionUUID->"7fc02df2-a23f-48ea-958d-\
74ee85ed242f"],

Cell[BoxData[
 RowBox[{"compli", "=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"ToReversible", "[", "\"\<Wegscheider\>\"", "]"}], ",", 
    RowBox[{"ToReversible", "[", "\"\<Triangle\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.640924290080907*^9, 3.640924326224961*^9}, 
   3.730609580948968*^9},ExpressionUUID->"a74986ce-c2f3-488f-b9d0-\
b6b26d90f308"],

Cell[BoxData[
 RowBox[{"complig", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", "compli", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "16"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "1"], ",", 
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", "7"], ",", 
       SubscriptBox["k", "8"], ",", 
       SubscriptBox["k", "3"], ",", 
       SubscriptBox["k", "4"], ",", 
       SubscriptBox["k", "5"], ",", 
       SubscriptBox["k", "6"]}], "}"}]}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5504788783838534`*^9, 3.550478904806331*^9}, {
  3.6380701191196513`*^9, 3.638070143735059*^9}, {3.640924348126994*^9, 
  3.6409244123205957`*^9}, {3.6409244466695604`*^9, 3.640924476720279*^9}, {
  3.6409245809422407`*^9, 3.6409245995893073`*^9}, {3.7017525370712175`*^9, 
  3.70175255264511*^9}, {3.715088653519448*^9, 
  3.7150887107877254`*^9}},ExpressionUUID->"3920eaeb-e940-4a67-a0b2-\
a690a6af8129"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig7.5\>\"", ",", "complig"}], "]"}]], "Input",
 CellChangeTimes->{{3.6409258329464626`*^9, 3.640925841557475*^9}, 
   3.709871635538786*^9, {3.7285672545952635`*^9, 3.728567267923415*^9}, 
   3.728567321189144*^9},ExpressionUUID->"0bef21aa-7fd6-4033-88f6-\
9a6f42a49bd8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 7.6", "Subsubsection",
 CellChangeTimes->{{3.7285675356072903`*^9, 3.728567537059373*^9}, 
   3.728643967713674*^9},ExpressionUUID->"539ffc67-fe61-40a7-82e1-\
3f5adf527bbd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"abscorb", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", 
      RowBox[{"2", "\"\<Y\>\""}]}], ",", 
     RowBox[{"\"\<Y\>\"", "\[Rule]", "\"\<X\>\""}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.710927200705422*^9, 
  3.710927225861863*^9}},ExpressionUUID->"2d3ec95a-8df0-4dfc-bcdc-\
12e0c32de205"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", "abscorb", "}"}], "]"}], "[", "\"\<reactionsteps\>\"", 
  "]"}]], "Input",
 CellChangeTimes->{{3.7109272276369667`*^9, 
  3.7109272473320923`*^9}},ExpressionUUID->"bd6e9e2d-ee84-4ecc-9d49-\
a32c64cc05e0"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", "abscorb", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"u", "-", "m"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7109272535884514`*^9, 3.7109273190271997`*^9}, {
  3.710927349153924*^9, 3.710927380963745*^9}, {3.710927533307472*^9, 
  3.7109276122249875`*^9}, {3.710927729700717*^9, 3.710927730002733*^9}, {
  3.710927769090974*^9, 3.7109277696740055`*^9}, {3.7109279936118298`*^9, 
  3.7109280238595624`*^9}, {3.7109282989853163`*^9, 3.710928300611412*^9}, {
  3.710928345702994*^9, 
  3.710928406892497*^9}},ExpressionUUID->"1563a8cf-5992-48c1-8744-\
59eddcc97808"],

Cell[BoxData[
 RowBox[{"absconcrob", "=", 
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "8"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], "]"}]}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed", ",", 
          RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", 
            RowBox[{"-", "4"}]}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Dashing", "[", 
           RowBox[{"{", "}"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], "]"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "7"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"7", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4", ",", "0"}], "}"}], ",", "0.16"}], "]"}], ",", "Green", 
       ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<S\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Kunstler Script\>\""}], ",", 
           "Bold", ",", "16"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "]"}], ",", "Red", ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<reaction\\nsimplex\>\"", ",", "Bold", ",", "16"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"7.5", ",", "1.5"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "5"}], "}"}], ",", "0.16"}], "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4", ",", "3"}], "}"}], ",", "0.16"}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<(\!\(\*SubscriptBox[\(x\), \(0\)]\),\!\(\*SubscriptBox[\(y\), \
\(0\)]\))\>\"", ",", "Bold", ",", "16"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "6"}], "}"}]}], "]"}], ",", "Blue", ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<E\>\"", ",", "Italic", ",", "Bold", ",", "16"}], "]"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"3.5", ",", "7"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<stationary point\>\"", ",", "Bold", ",", "16"}], "]"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "3"}], "}"}]}], "]"}]}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "9"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", "Bold", ",", "Italic", ",", "12"}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6379412369391036`*^9, 3.637941397105585*^9}, {
   3.6379414331572485`*^9, 3.6379415873499193`*^9}, {3.637941620047577*^9, 
   3.6379416545724373`*^9}, {3.637941687426095*^9, 3.63794184932818*^9}, {
   3.6379418821350374`*^9, 3.637942031131899*^9}, {3.637996368415408*^9, 
   3.6379963724216375`*^9}, {3.6379990603813796`*^9, 
   3.6379990610094156`*^9}, {3.6402636916593513`*^9, 3.64026370250137*^9}, 
   3.6402637427806406`*^9, {3.6402638286587915`*^9, 3.6402638381280084`*^9}, {
   3.640263870201665*^9, 3.6402640125519147`*^9}, {3.6402643283900695`*^9, 
   3.6402643908213787`*^9}, {3.6402644813937073`*^9, 
   3.6402645085282593`*^9}, {3.6402645554014816`*^9, 3.640264555931883*^9}, {
   3.6402661832158365`*^9, 3.6402661836682367`*^9}, {3.7017542798860226`*^9, 
   3.701754323473518*^9}, {3.701754389950327*^9, 3.701754532583493*^9}, {
   3.7017545884546947`*^9, 3.701754664119027*^9}, {3.701754699301041*^9, 
   3.7017549843633657`*^9}, {3.701755019596385*^9, 3.701755079256801*^9}, {
   3.701755135206006*^9, 3.701755199074662*^9}, 3.7098717765333333`*^9, 
   3.710930755135976*^9},ExpressionUUID->"d6866011-8c85-487c-a491-\
45d7812084ee"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig7.6\>\"", ",", "absconcrob"}], "]"}]], "Input",
 CellChangeTimes->{{3.701755216807678*^9, 3.7017552224920034`*^9}, 
   3.709871786861478*^9, 3.710930762401389*^9, {3.7285673871736503`*^9, 
   3.728567398751796*^9}},ExpressionUUID->"bbc12566-5a0b-4621-b067-\
44a2af712f6c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 7.7", "Subsubsection",
 CellChangeTimes->{{3.7285676224642644`*^9, 3.72856762430337*^9}, 
   3.728643977041817*^9},ExpressionUUID->"377e7ad3-a916-420d-8b6e-\
674f06669b82"],

Cell[BoxData[
 RowBox[{"specoregonator", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Oregonator\>\"", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "16", ",", "Bold"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "1"], ",", 
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", "3"], ",", 
       SubscriptBox["k", "4"], ",", 
       SubscriptBox["k", "5"]}], "}"}]}], ",", 
    RowBox[{"ExternalSpecies", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<P\>\"", ",", "\"\<Q\>\""}], 
      "}"}]}], ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.640959022389778*^9, 3.6409590503948193`*^9}, {
   3.6409590897178764`*^9, 3.640959117046918*^9}, {3.7019309885380325`*^9, 
   3.7019310900828476`*^9}, 3.7206032526869984`*^9, {3.7301828141303434`*^9, 
   3.730182814505344*^9}, {3.7301828580054297`*^9, 
   3.730182873114834*^9}},ExpressionUUID->"67e440bd-62d8-49ac-ad9b-\
7f88ec64a34a"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig7.7\>\"", ",", "specoregonator"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.640959121966926*^9, 3.6409591404389544`*^9}, {
   3.6409592953702135`*^9, 3.640959296102215*^9}, {3.7098720970541477`*^9, 
   3.7098721012943897`*^9}, {3.7285676341099324`*^9, 3.728567646026615*^9}, 
   3.728567684414812*^9},ExpressionUUID->"b6b37e64-7657-4f39-962d-\
47570f4009b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 7.8", "Subsubsection",
 CellChangeTimes->{{3.7285677156796017`*^9, 3.728567717043681*^9}, 
   3.7286439884793406`*^9},ExpressionUUID->"a0980852-39f4-47df-a38b-\
baf88111c455"],

Cell[BoxData[
 RowBox[{
  RowBox[{"idkhidh", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
       "\"\<E\>\"", "+", "\"\<\!\(\*SubscriptBox[\(I\), \(p\)]\)\>\""}], 
       "\[LeftRightArrow]", "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\""}], 
      "\[Rule]", 
      RowBox[{"\"\<E\>\"", "+", "\"\<I\>\""}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\"", "+", "\"\<I\>\""}], 
       "\[LeftRightArrow]", "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)I\>\""}], 
      "\[Rule]", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\"", "+", 
       "\"\<\!\(\*SubscriptBox[\(I\), \(p\)]\)\>\""}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.7098722629130154`*^9, {3.7109284394503613`*^9, 3.710928441453476*^9}, {
   3.71092854576945*^9, 3.710928549631671*^9}, {3.7109285896399612`*^9, 
   3.71092859291715*^9}},ExpressionUUID->"cea98ac9-7b67-449e-9c41-\
79f985299b9a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"idkhidhspecies", "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", "idkhidh", "]"}], "[", "\"\<species\>\"", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7109286262380586`*^9, 
  3.710928631355351*^9}},ExpressionUUID->"9060892b-c721-45f1-a730-\
53d5b3e0deee"],

Cell[BoxData[
 RowBox[{"idh", "=", 
  RowBox[{
   RowBox[{"ShowFHJGraph", "[", 
    RowBox[{"idkhidh", ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
     RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
     RowBox[{"ComplexColors", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "Pink", ",", "Blue", ",", "Blue", ",", "Blue", ",", "Blue", ",", 
        "Pink"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], "/.", 
   RowBox[{"Thread", "[", 
    RowBox[{"idkhidhspecies", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", 
          RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", "14"}], 
         "]"}], "&"}], "/@", "idkhidhspecies"}], ")"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7109284601405473`*^9, 3.710928515819735*^9}, {
   3.71092855622505*^9, 3.7109286977641535`*^9}, 
   3.730182900958637*^9},ExpressionUUID->"ed0f93d5-9557-4f5b-aec1-\
3f910e950eb4"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig7.8\>\"", ",", "idh"}], "]"}]], "Input",
 CellChangeTimes->{{3.709872251131744*^9, 3.709872253694248*^9}, 
   3.710928523079151*^9, {3.72856772190796*^9, 
   3.7285677308864717`*^9}},ExpressionUUID->"647ff4a0-cff7-4cc1-acb0-\
da88007662e3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"7d03d53b-bfc8-4750-a8db-\
315a45d9d3b0"],

Cell[CellGroupData[{

Cell["Example 7.4", "Subsubsection",
 CellChangeTimes->{{3.7291672343288717`*^9, 
  3.729167245625769*^9}},ExpressionUUID->"8d143937-1404-4bdd-9418-\
6386282a8dd1"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", "\[Rule]", " ", "\"\<X\>\""}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730444602714738*^9, 
  3.7304446199178963`*^9}},ExpressionUUID->"7c4c841a-95ca-4e9e-ae1d-\
54ea36500abc"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\"\<X\>\""}], "\[DoubleLeftRightArrow]", "\"\<X\>\""}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7291671439693213`*^9, 
  3.729167190500662*^9}},ExpressionUUID->"f5258ae4-2075-4ee6-9ec0-\
fec843513327"],

Cell["\<\
The negative stationary point, as physically uninteresting, is eliminated.\
\>", "Text",
 CellChangeTimes->{{3.729167255360163*^9, 
  3.7291672755320787`*^9}},ExpressionUUID->"09009ec2-8c87-4c39-9a1e-\
5ce393c49f1c"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"X", "+", "Y"}], "\[Rule]", 
      RowBox[{
       RowBox[{"2", "X"}], "+", 
       RowBox[{"3", "Y"}]}]}], ",", 
     RowBox[{"X", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "X"}], "+", 
       RowBox[{"2", "Y"}]}]}], ",", 
     RowBox[{"Y", "\[Rule]", 
      RowBox[{"X", "+", 
       RowBox[{"3", "Y"}]}]}], ",", 
     RowBox[{"0", "\[Rule]", 
      RowBox[{"X", "+", 
       RowBox[{"2", "Y"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304446699961214`*^9, 
  3.73044483141831*^9}},ExpressionUUID->"078a3e40-07ee-4bd0-bd25-\
0ce85f8e11f0"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"%", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304448352464447`*^9, 
  3.7304448511683493`*^9}},ExpressionUUID->"9cc7b30e-72dc-4019-9797-\
a5c1e5a4298a"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"X", "+", "Y"}], "\[Rule]", 
      RowBox[{
       RowBox[{"2", "X"}], "+", 
       RowBox[{"3", "Y"}]}]}], ",", 
     RowBox[{"X", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "X"}], "+", 
       RowBox[{"2", "Y"}]}]}], ",", 
     RowBox[{"Y", "\[Rule]", 
      RowBox[{"X", "+", 
       RowBox[{"3", "Y"}]}]}], ",", 
     RowBox[{"0", "\[Rule]", 
      RowBox[{"X", "+", 
       RowBox[{"2", "Y"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304446699961214`*^9, 3.7304447420275106`*^9}, {
  3.7304448067307615`*^9, 
  3.730444812355773*^9}},ExpressionUUID->"2e7fc78f-9bdf-4f86-97e3-\
1ee40add7d9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remark 7.6", "Subsubsection",
 CellChangeTimes->{{3.7291673086258917`*^9, 
  3.7291673123759003`*^9}},ExpressionUUID->"1bb6a8b7-1419-4408-ae28-\
97cbe72b54d3"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", " ", "\"\<Y\>\""}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.729167325016549*^9, 
  3.7291673400634546`*^9}},ExpressionUUID->"a4d09fb5-7926-419a-b5d6-\
9c76854b8e3f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["7.4 Uniqueness of Stationary Points", "Subsubsection",
 CellChangeTimes->{{3.7291679620334196`*^9, 
  3.7291679737053175`*^9}},ExpressionUUID->"abe802fc-62bc-446b-b076-\
cb3bdd684ed5"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\"\<X\>\""}], "\[DoubleLeftRightArrow]", " ", 
     "\"\<Y\>\""}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", 
      RowBox[{"-", "1"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "0"], ",", 
     SubscriptBox["y", "0"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "*"], ",", 
     SuperscriptBox["y", "*"]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7291676986579046`*^9, 3.7291677328454714`*^9}, {
  3.7291678870957737`*^9, 
  3.7291679090801907`*^9}},ExpressionUUID->"08bd5827-a0fe-4708-808d-\
00faf898fc9a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "*"], "==", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "1"], "/", 
      SubscriptBox["k", 
       RowBox[{"-", "1"}]]}], 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["x", "*"], ")"}], "2"]}]}], "/.", 
   RowBox[{"%", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.729168138877516*^9, 
  3.7291681712057047`*^9}},ExpressionUUID->"b9486378-46ef-4001-b65e-\
94f23c17321d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.10", "Subsubsection",
 CellChangeTimes->{{3.7291712342711797`*^9, 
  3.7291712426149445`*^9}},ExpressionUUID->"c2a0c90b-62c4-4d24-93df-\
ae713a8d0274"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"GetReaction", "[", "\"\<Lotka-Volterra\>\"", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "0"], ",", 
     SubscriptBox["y", "0"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "*"], ",", 
     SuperscriptBox["y", "*"]}], "}"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7098748259768224`*^9, 3.709874871914413*^9}, 
   3.7287982026839185`*^9, 3.729170878442358*^9, {3.7291712783181396`*^9, 
   3.7291713037244406`*^9}, 3.7291713984746237`*^9, {3.729171456849739*^9, 
   3.729171460818495*^9}},ExpressionUUID->"49e837c9-2c90-4eaa-8838-\
698dc5c033ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.11", "Subsubsection",
 CellChangeTimes->{{3.7291712342711797`*^9, 3.7291712426149445`*^9}, {
  3.729171450349725*^9, 
  3.729171450755976*^9}},ExpressionUUID->"600e2995-d231-4317-827e-\
65a6b6f2403b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"StationaryPoints", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "\"\<X\>\""}], "\[DoubleLeftRightArrow]", 
       RowBox[{"2", "\"\<X\>\""}]}], ",", 
      RowBox[{"\"\<X\>\"", "\[DoubleLeftRightArrow]", "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "3"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "0"]}], "}"}], ",", 
    RowBox[{"{", 
     SubscriptBox["x", "0"], "}"}], ",", 
    RowBox[{"{", 
     SuperscriptBox["x", "*"], "}"}]}], "]"}], "//", "ToRadicals"}]], "Input",
 CellChangeTimes->{{3.7098748259768224`*^9, 3.709874871914413*^9}, 
   3.7287982026839185`*^9, 3.729170878442358*^9, {3.7291712783181396`*^9, 
   3.7291713037244406`*^9}, 3.7291713984746237`*^9, {3.7291714735372705`*^9, 
   3.729171577349973*^9}, {3.7301974245739727`*^9, 3.7301974249645977`*^9}, {
   3.7307006855496316`*^9, 
   3.7307006885808864`*^9}},ExpressionUUID->"290ae7f4-1df4-45e6-9530-\
66bede5ec6e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.12", "Subsubsection",
 CellChangeTimes->{{3.7291716300063267`*^9, 3.729171635600088*^9}, 
   3.7291750453960075`*^9},ExpressionUUID->"672e7efb-e24c-4980-9e30-\
cd44c27363ec"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "->", 
     RowBox[{
      RowBox[{"2", "\"\<X\>\""}], "+", "\"\<Y\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["k", "1"], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "0"], ",", 
     SubscriptBox["y", "0"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "*"], ",", 
     SuperscriptBox["y", "*"]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7098748259768224`*^9, 3.709874871914413*^9}, 
   3.7287982026839185`*^9, 3.729170878442358*^9, {3.7291712783181396`*^9, 
   3.7291713037244406`*^9}, 3.7291713984746237`*^9, {3.7291714735372705`*^9, 
   3.729171577349973*^9}, {3.7291716505376177`*^9, 
   3.729171721569008*^9}},ExpressionUUID->"785ffd0a-7f6a-40ce-8a81-\
08f33a8396c1"],

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"gamma", "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", "\"\<U\>\""}], 
       ",", 
       RowBox[{
        RowBox[{"\"\<Y\>\"", "+", "\"\<Z\>\""}], "\[Rule]", "\"\<V\>\""}]}], 
      "}"}], "]"}], "[", "\[Gamma]", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.713072597846643*^9, 3.713072651220764*^9}, {
  3.7130728085268726`*^9, 
  3.7130728123707285`*^9}},ExpressionUUID->"931feb7d-c908-4c9a-99f0-\
41baecbf910f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", "\"\<U\>\""}], ",", 
     RowBox[{
      RowBox[{"\"\<Y\>\"", "+", "\"\<Z\>\""}], "\[Rule]", "\"\<V\>\""}]}], 
    "}"}], "]"}], "[", "\"\<species\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.713072927546838*^9, 
  3.713072932306754*^9}},ExpressionUUID->"6e564c51-e2d8-4792-ae47-\
7e5d1f4da99e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NullSpace", "[", 
   RowBox[{"Transpose", "[", "gamma", "]"}], "]"}], ".", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "u", ",", "z", ",", "v"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.713072656627276*^9, 3.7130726676331625`*^9}, {
  3.730197476464699*^9, 
  3.7301974881365957`*^9}},ExpressionUUID->"dc2b4014-1111-4331-a171-\
1ed9d568fd14"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", "\"\<U\>\""}], ",", 
    RowBox[{
     RowBox[{"\"\<Y\>\"", "+", "\"\<Z\>\""}], "\[Rule]", "\"\<V\>\""}]}], 
   "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.713072656627276*^9, 3.7130726676331625`*^9}, {
  3.7301974560584087`*^9, 
  3.7301974718084397`*^9}},ExpressionUUID->"4a456977-2607-4b9e-ad4b-\
7720b294c9b3"],

Cell["\<\
We are looking for nonnegative vectors. One can get those like this:\
\>", "Text",
 CellChangeTimes->{{3.729180743128191*^9, 
  3.7291807593469696`*^9}},ExpressionUUID->"709723c4-f103-4fd8-bfdc-\
831de0aaf846"],

Cell[BoxData[
 RowBox[{"fi", "=", 
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Transpose", "[", "gamma", "]"}], ".", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
        "\[Equal]", "0"}], "]"}], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{"1", "\[GreaterEqual]", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
        "\[GreaterEqual]", "0"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"#", "\[Element]", "Integers"}], ")"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ">", 
        RowBox[{"a", "+", "b", "+", "c", "+", "d", "+", "e"}], ">", "0"}], 
       "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "8"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.7130729781709385`*^9, 3.7130731697719793`*^9}, 
   3.7130732235016413`*^9, {3.713073261727865*^9, 3.713073271401984*^9}, {
   3.713073341064821*^9, 3.7130733448102007`*^9}, {3.7291807723157473`*^9, 
   3.7291808023158064`*^9}, {3.72918086131592*^9, 
   3.729180861940922*^9}},ExpressionUUID->"28dc5e71-984f-419a-9257-\
617df71ed23e"],

Cell["Note the order of variables.", "Text",
 CellChangeTimes->{{3.7291812826173973`*^9, 
  3.7291812894611607`*^9}},ExpressionUUID->"e7ae6404-41f3-4f3b-95d2-\
8a9209677866"],

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "d", ",", "c", ",", "e"}], "}"}], "/.", 
    "fi"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7291808089720697`*^9, 3.7291808365189962`*^9}, {
  3.729181269508001*^9, 
  3.7291812714767504`*^9}},ExpressionUUID->"bf387967-7985-46d5-99b2-\
1d03788ea297"],

Cell[BoxData[
 RowBox[{
  RowBox[{"StationaryPoints", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", "\"\<U\>\""}], ",", 
      RowBox[{
       RowBox[{"\"\<Y\>\"", "+", "\"\<Z\>\""}], "\[Rule]", "\"\<V\>\""}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "0"], ",", 
      SubscriptBox["y", "0"], ",", 
      SubscriptBox["u", "0"], ",", 
      SubscriptBox["z", "0"], ",", 
      SubscriptBox["v", "0"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox["x", "*"], ",", 
      SuperscriptBox["y", "*"], ",", 
      SuperscriptBox["z", "*"], ",", 
      SuperscriptBox["u", "*"], ",", 
      SuperscriptBox["v", "*"]}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.7130739203271623`*^9, 3.713073969657014*^9}, {
  3.7130740500964317`*^9, 3.71307409735765*^9}, {3.729181307211196*^9, 
  3.7291813662581863`*^9}},ExpressionUUID->"1d28c2f3-9627-47fa-b0c8-\
090591d0cac0"],

Cell["How to make this more transparent?", "Text",
 CellChangeTimes->{{3.713074117394497*^9, 3.713074125771137*^9}, {
  3.7291813872113533`*^9, 
  3.7291813937113647`*^9}},ExpressionUUID->"97dd7bf5-2228-40aa-bcc4-\
696b55ede144"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.16", "Subsubsection",
 CellChangeTimes->{{3.7291716300063267`*^9, 3.729171635600088*^9}, {
  3.7291750453960075`*^9, 
  3.7291750635522923`*^9}},ExpressionUUID->"e4f8321e-aabb-42d6-b2e6-\
36310003c50a"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<X\>\"", "->", "\"\<Y\>\""}], ",", 
     RowBox[{
      RowBox[{"2", "\"\<Y\>\""}], "->", 
      RowBox[{"2", "\"\<X\>\""}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "0"], ",", 
     SubscriptBox["y", "0"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "*"], ",", 
     SuperscriptBox["y", "*"]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7098748259768224`*^9, 3.709874871914413*^9}, 
   3.7287982026839185`*^9, 3.729170878442358*^9, {3.7291712783181396`*^9, 
   3.7291713037244406`*^9}, 3.7291713984746237`*^9, {3.7291714735372705`*^9, 
   3.729171577349973*^9}, {3.7291716505376177`*^9, 3.729171721569008*^9}, {
   3.7291750798023252`*^9, 
   3.7291750998961115`*^9}},ExpressionUUID->"2ca7d1e0-2ff8-4082-b0ac-\
75b31a67e8e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<X\>\"", "->", "\"\<Y\>\""}], ",", 
      RowBox[{
       RowBox[{"2", "\"\<Y\>\""}], "->", 
       RowBox[{"2", "\"\<X\>\""}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox["x", "*"], ",", 
      SuperscriptBox["y", "*"]}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "*"], "\[Rule]", 
     RowBox[{"2", 
      SubscriptBox["k", "2"], "c"}]}], ",", 
    RowBox[{
     SuperscriptBox["y", "*"], "\[Rule]", 
     SqrtBox[
      RowBox[{
       SubscriptBox["k", "1"], "c"}]]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.729175731323293*^9, 
  3.7291758174172106`*^9}},ExpressionUUID->"3a28823b-de0c-49f7-9c7a-\
3519a00088e0"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"GetReaction", "[", "\"\<Ivanova\>\"", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "0"], ",", 
     SubscriptBox["y", "0"], ",", 
     SubscriptBox["z", "0"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "*"], ",", 
     SuperscriptBox["y", "*"], ",", 
     SuperscriptBox["z", "*"]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7098748259768224`*^9, 3.709874871914413*^9}, 
   3.7287982026839185`*^9, 
   3.729170878442358*^9},ExpressionUUID->"40e663f3-19a4-412c-a1e4-\
a745130eb06f"],

Cell[TextData[{
 "Note,  however,  that the reaction has a nolinear first integral, as well: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", ",", "y", ",", "z"}], ")"}], "\[RightTeeArrow]", 
    RowBox[{
     SuperscriptBox["x", 
      SubscriptBox["k", "2"]], 
     SuperscriptBox["y", 
      SubscriptBox["k", "3"]], 
     SuperscriptBox["z", 
      SubscriptBox["k", "1"]]}]}], TraditionalForm]],ExpressionUUID->
  "84544c3b-f277-420d-91ec-e696750bd8f5"],
 " which is only fulfilled by the given stationary points if a certain \
relation holds between the reaction rate coefficients and initial \
concentrations."
}], "Text",
 CellChangeTimes->{{3.7291708830048656`*^9, 
  3.7291710326770325`*^9}},ExpressionUUID->"f81b3387-bad6-4d82-b333-\
614d7faf3566"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.28", "Subsubsection",
 CellChangeTimes->{{3.7291799267657204`*^9, 
  3.7291799327813587`*^9}},ExpressionUUID->"599ebded-a16d-44b3-a9ce-\
ae6fbbad6074"],

Cell["\<\
Note that GetReaction is not needed if one applies ToReversible.\
\>", "Text",
 CellChangeTimes->{{3.729180186016228*^9, 
  3.7291802088443975`*^9}},ExpressionUUID->"1252a6c6-c7c0-4bf9-abb7-\
1c225e09e903"],

Cell[BoxData[
 RowBox[{"complicated", "=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"GetReaction", "[", 
     RowBox[{"{", "\"\<Wegscheider\>\"", "}"}], "]"}], ",", 
    RowBox[{"ToReversible", "[", "\"\<Triangle\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.709875212727578*^9, 3.70987523397762*^9}, {
   3.72879820271517*^9, 3.72879820271517*^9}, {3.7291799756251917`*^9, 
   3.729180015922145*^9}, {3.7291801476255255`*^9, 3.7291801778443413`*^9}, {
   3.730197529324176*^9, 3.7301975308554296`*^9}, 
   3.730609592698991*^9},ExpressionUUID->"18c3bd32-132a-4447-a5b3-\
cffcce55412f"],

Cell[BoxData[
 RowBox[{"DetailedBalanced", "[", 
  RowBox[{"complicated", ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "7"], ",", 
     SubscriptBox["k", "8"], ",", 
     SubscriptBox["k", "3"], ",", 
     SubscriptBox["k", "4"], ",", 
     SubscriptBox["k", "5"], ",", 
     SubscriptBox["k", "6"]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.709875013774066*^9, 
  3.7098750837429514`*^9}},ExpressionUUID->"7c725d25-72a3-4488-bd63-\
fd648dd31f0d"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"ExampleData", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NetworkGraph\>\"", ",", "\"\<MetabolicNetworkEscherichiaColi\>\""}],
      "}"}], "]"}], "*"}]}]], "Input",
 CellChangeTimes->{{3.7098753776698885`*^9, 3.7098754054845705`*^9}, {
  3.7098754408127656`*^9, 3.709875442781519*^9}, {3.7307008217935553`*^9, 
  3.7307008277779417`*^9}},ExpressionUUID->"76957c4a-377d-4460-8910-\
8dcc5b4c8a06"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.31", "Subsubsection",
 CellChangeTimes->{{3.729180298391447*^9, 
  3.7291803040945826`*^9}},ExpressionUUID->"dd6947ba-0593-47f0-a817-\
3cdcf270bbdf"],

Cell[BoxData[
 RowBox[{"AbsoluteConcentrationRobustness", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<X\>\"", " ", "\[DoubleLeftRightArrow]", "\"\<Y\>\""}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7291803062195873`*^9, 3.729180349610297*^9}, {
  3.7301975428242006`*^9, 
  3.7301975537304745`*^9}},ExpressionUUID->"09106187-ef25-4743-82b3-\
8f2d6bde1fa4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.32", "Subsubsection",
 CellChangeTimes->{{3.729180298391447*^9, 3.7291803040945826`*^9}, {
  3.729180379766607*^9, 
  3.7291803802041073`*^9}},ExpressionUUID->"4e151619-2f63-4ffb-aa60-\
a6f48e39a7ac"],

Cell[BoxData[
 RowBox[{"AbsoluteConcentrationRobustness", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"\"\<X\>\"", " ", "+", "\"\<Y\>\""}], "->", 
     RowBox[{"2", "\"\<Y\>\""}]}], ",", 
    RowBox[{"\"\<Y\>\"", "\[Rule]", "\"\<X\>\""}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7291803062195873`*^9, 3.729180349610297*^9}, {
  3.729180389735376*^9, 3.7291804123291698`*^9}, {3.730197558464859*^9, 
  3.7301975619179907`*^9}},ExpressionUUID->"e438f593-73d8-454c-a550-\
d6d955bd314b"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Transient", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 3.7096139310971584`*^9}, {
  3.7097241728756065`*^9, 3.7097241786889396`*^9}, {3.709807462247489*^9, 
  3.7098074673117795`*^9}},ExpressionUUID->"13ec504a-9ea2-4484-92fb-\
f7972e86bbb1"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"4d38b30a-344c-453c-8370-\
3baf6a970db3"],

Cell[CellGroupData[{

Cell["Fig. 8.1", "Subsubsection",
 CellChangeTimes->{{3.728571502882264*^9, 3.728571503694764*^9}, 
   3.7286440126981373`*^9},ExpressionUUID->"3472313c-d537-4a8a-a20c-\
7fbe8abc66bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ds1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["s11", "\[Prime]"], "[", "t", "]"}], "==", 
           RowBox[{
            RowBox[{"k3", "/", "k2"}], "-", 
            RowBox[{"k3", " ", 
             RowBox[{"s21", "[", "t", "]"}]}]}]}], ",", " ", 
          RowBox[{
           RowBox[{
            SuperscriptBox["s21", "\[Prime]"], "[", "t", "]"}], "==", 
           RowBox[{"k1", " ", 
            RowBox[{"s11", "[", "t", "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"s11", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{"s21", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"s11", "[", "t", "]"}], ",", 
          RowBox[{"s21", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"k1", ">", "0"}], ",", 
        RowBox[{"k2", ">", "0"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.641643167945483*^9, 3.6416434243521485`*^9}, {
   3.641643591426705*^9, 3.641643630696951*^9}, {3.641643840375944*^9, 
   3.641643854881774*^9}, {3.6416440939464474`*^9, 3.641644116841757*^9}, {
   3.641644147249496*^9, 3.641644161607317*^9}, {3.641644843597325*^9, 
   3.641644844891399*^9}, {3.6416449419939528`*^9, 3.641644945984181*^9}, 
   3.6416462084653907`*^9, {3.6416468191573205`*^9, 3.641646845762842*^9}, {
   3.6416471268929214`*^9, 3.641647131914209*^9}, {3.641647895106861*^9, 
   3.641647950650038*^9}, {3.6416490386352673`*^9, 3.6416490469507427`*^9}, 
   3.64164914393429*^9, {3.6455873075013914`*^9, 3.6455874260181704`*^9}, {
   3.702177727102515*^9, 3.702177727816556*^9}, {3.70987600045856*^9, 
   3.709876061661805*^9}, 3.7098761720526457`*^9, {3.7301975712305083`*^9, 
   3.7301975721055098`*^9}},ExpressionUUID->"1489ea29-3c6d-4083-8ebb-\
16ef993b0803"],

Cell[BoxData[
 RowBox[{"sensitivitystat", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"s11", "[", "t", "]"}], ",", 
         RowBox[{"s21", "[", "t", "]"}]}], "}"}], "/.", "ds1"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"k1", "\[Rule]", "1"}], ",", 
        RowBox[{"k2", "\[Rule]", "2"}], ",", 
        RowBox[{"k3", "\[Rule]", "3"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "16"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", "Thick", "]"}], ",", 
       RowBox[{"Directive", "[", "Dashed", "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<The effect of \!\(\*SubscriptBox[\(k\), \(1\)]\) on the variables.\
\\nStationary case\>\"", ",", "16"}], "]"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "1"], ",", 
       SubscriptBox["x", "2"]}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Range", "[", "10", "]"}], 
        RowBox[{"\[Pi]", "/", "2"}]}], ",", "Automatic"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.641643167945483*^9, 3.6416434243521485`*^9}, {
   3.641643591426705*^9, 3.641643630696951*^9}, {3.641643840375944*^9, 
   3.641643854881774*^9}, {3.6416440939464474`*^9, 3.641644116841757*^9}, {
   3.641644147249496*^9, 3.641644161607317*^9}, {3.641644843597325*^9, 
   3.641644844891399*^9}, {3.6416449419939528`*^9, 3.641644945984181*^9}, 
   3.6416462084653907`*^9, {3.6416468191573205`*^9, 3.641646845762842*^9}, {
   3.6416471268929214`*^9, 3.641647131914209*^9}, {3.641647895106861*^9, 
   3.641647950650038*^9}, {3.6416490386352673`*^9, 3.6416490469507427`*^9}, 
   3.64164914393429*^9, {3.6455873075013914`*^9, 3.6455874260181704`*^9}, {
   3.702177727102515*^9, 3.702177727816556*^9}, {3.70987600045856*^9, 
   3.709876094130619*^9}, {3.7098761299744387`*^9, 3.7098761316463175`*^9}, 
   3.7098761619901257`*^9, {3.71266047168028*^9, 
   3.712660491757097*^9}},ExpressionUUID->"a269a150-d48b-4ce3-af66-\
5aaaff7bc18e"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.1A\>\"", ",", "sensitivitystat"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.641647144486928*^9, 3.6416471527274*^9}, 
   3.709875956067848*^9, {3.728571509210399*^9, 3.728571543632343*^9}, 
   3.7285716312106376`*^9},ExpressionUUID->"e469829c-12c0-4f1b-acfc-\
13fc1a059be8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nds1", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "\[Prime]"], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"k1", " ", 
            RowBox[{"x", "[", "t", "]"}]}], "-", 
           RowBox[{"k2", " ", 
            RowBox[{"x", "[", "t", "]"}], 
            RowBox[{"y", "[", "t", "]"}]}]}]}], ",", 
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "\[Prime]"], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"k2", " ", 
            RowBox[{"x", "[", "t", "]"}], 
            RowBox[{"y", "[", "t", "]"}]}], "-", 
           RowBox[{"k3", " ", 
            RowBox[{"y", "[", "t", "]"}]}]}]}], ",", 
         RowBox[{
          RowBox[{
           SuperscriptBox["s11", "\[Prime]"], "[", "t", "]"}], "==", 
          RowBox[{
           RowBox[{"x", "[", "t", "]"}], "+", 
           RowBox[{"k1", " ", 
            RowBox[{"s11", "[", "t", "]"}]}], "-", 
           RowBox[{"k2", " ", 
            RowBox[{"s11", "[", "t", "]"}], 
            RowBox[{"y", "[", "t", "]"}]}], "-", 
           RowBox[{"k2", " ", 
            RowBox[{"x", "[", "t", "]"}], 
            RowBox[{"s21", "[", "t", "]"}]}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           SuperscriptBox["s21", "\[Prime]"], "[", "t", "]"}], "==", 
          RowBox[{
           RowBox[{"k2", " ", 
            RowBox[{"s11", "[", "t", "]"}], 
            RowBox[{"y", "[", "t", "]"}]}], "+", 
           RowBox[{"k2", " ", 
            RowBox[{"x", "[", "t", "]"}], 
            RowBox[{"s21", "[", "t", "]"}]}], "-", 
           RowBox[{"k3", " ", 
            RowBox[{"s21", "[", "t", "]"}]}]}]}], ",", 
         RowBox[{
          RowBox[{"x", "[", "0", "]"}], "\[Equal]", "4"}], ",", 
         RowBox[{
          RowBox[{"y", "[", "0", "]"}], "\[Equal]", "5"}], ",", 
         RowBox[{
          RowBox[{"s11", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"s21", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k1", "\[Rule]", "1"}], ",", 
         RowBox[{"k2", "\[Rule]", "2"}], ",", 
         RowBox[{"k3", "\[Rule]", "3"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], ",", 
        RowBox[{"y", "[", "t", "]"}], ",", 
        RowBox[{"s11", "[", "t", "]"}], ",", 
        RowBox[{"s21", "[", "t", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "66"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"sensitivitytrans", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"s11", "[", "t", "]"}], ",", 
        RowBox[{"s21", "[", "t", "]"}]}], "}"}], "/.", "nds1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "16"}], "}"}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<The effect of \!\(\*SubscriptBox[\(k\), \(1\)]\) on the variables.\
\\nTransient case\>\"", ",", "16"}], "]"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "1"], ",", 
       SubscriptBox["x", "2"]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "->", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", "Thick", "]"}], ",", 
       RowBox[{"Directive", "[", "Dashed", "]"}]}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Range", "[", "10", "]"}], 
        RowBox[{"\[Pi]", "/", "2"}]}], ",", "Automatic"}], "}"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.641643167945483*^9, 3.6416434243521485`*^9}, {
   3.641643591426705*^9, 3.641643630696951*^9}, {3.641643840375944*^9, 
   3.641643854881774*^9}, {3.6416440939464474`*^9, 3.641644116841757*^9}, {
   3.641644147249496*^9, 3.641644161607317*^9}, {3.641644843597325*^9, 
   3.641644844891399*^9}, {3.6416449419939528`*^9, 3.641644945984181*^9}, 
   3.6416462084653907`*^9, {3.6416468191573205`*^9, 3.641646845762842*^9}, {
   3.6416471268929214`*^9, 3.641647131914209*^9}, {3.641647289768238*^9, 
   3.6416474649192557`*^9}, {3.6416475020643806`*^9, 3.6416477597221174`*^9}, 
   3.641647794334097*^9, {3.641647976451514*^9, 3.6416479912433596`*^9}, {
   3.641648051287794*^9, 3.641648076822255*^9}, {3.6416481152674537`*^9, 
   3.6416481235859294`*^9}, {3.641648966360133*^9, 3.6416489676002045`*^9}, 
   3.641649159932205*^9, 3.64558745189465*^9, {3.7021777700409746`*^9, 
   3.702177770690013*^9}, {3.709876243787161*^9, 3.7098762446309133`*^9}, 
   3.7126605142332926`*^9},ExpressionUUID->"65ab2452-d12f-4e67-a3cc-\
09a8417ad059"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.1B\>\"", ",", "sensitivitytrans"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6416472743273544`*^9, 3.6416472782515793`*^9}, 
   3.709876231177761*^9, 3.7109287702633057`*^9, {3.728571557101118*^9, 
   3.728571567523014*^9}},ExpressionUUID->"fc26ec23-6aa9-43f9-8ca0-\
abbbbd593d1a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.2", "Subsubsection",
 CellChangeTimes->{{3.728571656195063*^9, 3.7285716573981905`*^9}, 
   3.728644044963825*^9},ExpressionUUID->"6490bc86-6928-4ec2-9ec3-\
8521cfa5b922"],

Cell[BoxData[
 RowBox[{"blowup", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"k", " ", "x"}]], "/.", 
     RowBox[{"{", 
      RowBox[{"k", "\[Rule]", "2"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0.01", ",", "1"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*SubscriptBox[\(c\), \(0\)]\)\>\"", ",", "16"}], 
        "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*SubscriptBox[\(t\), \(*\)]\)\>\"", ",", "16"}], 
        "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "->", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6454464107885604`*^9, 3.645446522080926*^9}, {
  3.6454465617361937`*^9, 3.6454465887267375`*^9}, {3.645446635812431*^9, 
  3.645446654140479*^9}},ExpressionUUID->"46ca7ba4-fd00-4fc2-b57a-\
3f10bcd5595d"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.2\>\"", ",", "blowup"}], "]"}]], "Input",
 CellChangeTimes->{{3.641969995638706*^9, 3.641970004708225*^9}, {
  3.7285716681169615`*^9, 
  3.7285716975232687`*^9}},ExpressionUUID->"f092f491-59c3-4e88-93c5-\
788b6ac222b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.3", "Subsubsection",
 CellChangeTimes->{{3.7285717616796446`*^9, 3.7285717641796494`*^9}, 
   3.7286440609169827`*^9},ExpressionUUID->"c12d753c-2aab-4023-9ce3-\
fa532a460061"],

Cell[BoxData[
 RowBox[{"kinsub", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\"\<F\>\"", "\[Equilibrium]", 
        RowBox[{"\"\<D\>\"", "+", "\"\<E\>\""}]}], "\[LeftArrow]", 
       RowBox[{"\"\<C\>\"", "\[Equilibrium]", 
        RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}]}]}], "\[Rule]", 
      RowBox[{"\"\<G\>\"", "\[Rule]", 
       RowBox[{
        RowBox[{"\"\<H\>\"", "\[Equilibrium]", 
         RowBox[{"2", "\"\<J\>\""}]}], "\[Rule]", "\"\<G\>\""}]}]}], "}"}], 
    ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.644051184816352*^9, 3.644051227226411*^9}, {
  3.6440512727184763`*^9, 
  3.644051385228634*^9}},ExpressionUUID->"8eeec56b-4b62-4928-b922-\
d69029148744"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.3\>\"", ",", "kinsub"}], "]"}]], "Input",
 CellChangeTimes->{{3.64405140832067*^9, 3.644051425550694*^9}, {
  3.7285717461327395`*^9, 
  3.728571769929661*^9}},ExpressionUUID->"bedb4de6-c2ba-4c30-a5b1-\
27b8f3d477c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.4", "Subsubsection",
 CellChangeTimes->{{3.7285717915859528`*^9, 3.7285717929453306`*^9}, 
   3.728644063791987*^9},ExpressionUUID->"a33dd808-ba43-4ec1-baec-\
3d2642819c8f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"a", ",", "b", ",", "d", ",", "e", ",", "f"}], "]"}], ";", 
  RowBox[{"example3a", "=", 
   RowBox[{"ShowFHJGraph", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<X\>\"", "\[LeftArrow]", 
        RowBox[{"\"\<X\>\"", "+", "\"\<Z\>\""}]}], "->", 
       RowBox[{
        RowBox[{"\"\<Z\>\"", "\[LeftArrow]", 
         RowBox[{"\"\<Y\>\"", "+", "\"\<Z\>\""}]}], "->", 
        RowBox[{
         RowBox[{"\"\<Y\>\"", "\[LeftArrow]", 
          RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}]}], "\[Rule]", 
         "\"\<X\>\""}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "e", ",", "f", ",", "d", ",", "c", ",", "a"}], "}"}], 
     ",", 
     RowBox[{"DirectedEdges", "->", "True"}], ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "All"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7105722669331822`*^9, 3.710572331711892*^9}, {
  3.710572364230754*^9, 3.7105725483159304`*^9}, {3.7307016199201155`*^9, 
  3.730701620279492*^9}},ExpressionUUID->"4ceeefaa-9f13-41e8-95e0-\
59d067fa4807"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.4A\>\"", ",", "example3a"}], "]"}]], "Input",
 CellChangeTimes->{{3.710574330076294*^9, 3.710574340545059*^9}, {
  3.728571807757859*^9, 
  3.728571822789139*^9}},ExpressionUUID->"39453167-1e66-42e2-b88e-\
5d392acf3b9d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"a", ",", "b", ",", "d", ",", "e", ",", "f"}], "]"}], ";", 
  RowBox[{"example3b", "=", 
   RowBox[{"ShowFHJGraph", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"2", "\"\<Y\>\""}], "+", "\"\<Z\>\""}], "\[LeftArrow]", 
         RowBox[{"2", "\"\<Y\>\""}]}], "->", 
        RowBox[{"\"\<X\>\"", "+", 
         RowBox[{"2", "\"\<Y\>\""}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"\"\<X\>\"", "+", 
          RowBox[{"2", "\"\<Z\>\""}]}], "\[LeftArrow]", 
         RowBox[{"2", "\"\<Z\>\""}]}], "->", 
        RowBox[{"\"\<Y\>\"", "+", 
         RowBox[{"2", "\"\<Z\>\""}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"2", "\"\<X\>\""}], "+", "\"\<Y\>\""}], "\[LeftArrow]", 
         RowBox[{"2", "\"\<X\>\""}]}], "\[Rule]", 
        RowBox[{
         RowBox[{"2", "\"\<X\>\""}], "+", "\"\<Z\>\""}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "a", ",", "b", ",", "d", ",", "c", ",", "e"}], 
      "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7105722669331822`*^9, 3.710572331711892*^9}, {
   3.710572364230754*^9, 3.7105725483159304`*^9}, {3.710574382549257*^9, 
   3.7105745382214355`*^9}, 3.710574595346545*^9, {3.7307016673420825`*^9, 
   3.730701667670209*^9}},ExpressionUUID->"5ff11107-aed7-4608-b835-\
0d6d35a4e3ec"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.4B\>\"", ",", "example3b"}], "]"}]], "Input",
 CellChangeTimes->{{3.7105746316747437`*^9, 3.7105746321903687`*^9}, {
   3.7285718276016483`*^9, 3.7285718382422953`*^9}, 
   3.7285718696954803`*^9},ExpressionUUID->"14a276a7-e89d-4add-9379-\
5bd50d774dd5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.5", "Subsubsection",
 CellChangeTimes->{{3.728572028945792*^9, 3.728572030352046*^9}, 
   3.7286440845576534`*^9},ExpressionUUID->"12d554b9-d1e1-4dc0-861a-\
92056c319572"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "2"}], ";", 
  RowBox[{"b", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1", "=", 
   RowBox[{"StreamPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"b", " ", "x", " ", "y"}]}], ",", 
       RowBox[{
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"a", " ", "x", " ", "y"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1.5"}], "}"}], ",", 
     RowBox[{"StreamPoints", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"Directive", "[", 
            RowBox[{"Red", ",", "Thick"}], "]"}]}], "}"}], ",", "Automatic"}],
         "}"}], "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"b", " ", "x"}], "a"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"fig3a", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"s1", ",", "s2"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.541137145406946*^9, 3.541137267104946*^9}, {
  3.541137309625946*^9, 3.5411373386909466`*^9}, {3.5411373730099463`*^9, 
  3.5411373788799467`*^9}, {3.5411374288589463`*^9, 3.5411374780659466`*^9}, {
  3.541137519236946*^9, 3.541137631005946*^9}, {3.5411376816149464`*^9, 
  3.541137701446946*^9}, {3.5411377440379467`*^9, 3.541137757979946*^9}, {
  3.5411377898249464`*^9, 3.5411377901859465`*^9}, {3.5411391363539467`*^9, 
  3.5411391496269464`*^9}, {3.710574828722004*^9, 3.710574830081382*^9}},
 CellID->333142762,ExpressionUUID->"73cd7896-5338-4de3-bd58-d70ee1142418"],

Cell[BoxData[
 RowBox[{
  RowBox[{"figurexp", "[", 
   RowBox[{"\"\<TothNagyPapp-Fig8.5\>\"", ",", "fig3a"}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7105748455189133`*^9, 3.7105748633470716`*^9}, {
  3.7285720038676176`*^9, 
  3.728572008055127*^9}},ExpressionUUID->"1e9b7cb4-a1dd-4178-a7a4-\
c60a695cfe36"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.6", "Subsubsection",
 CellChangeTimes->{{3.7285720415864415`*^9, 3.728572042836444*^9}, 
   3.7286440948701725`*^9},ExpressionUUID->"26fc109e-9b7f-4286-8c5d-\
ccb19552846a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"a", ",", "b", ",", "d"}], "]"}], ";", 
  RowBox[{"example4", "=", 
   RowBox[{"ShowFHJGraph", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(X\), \(1\)]\)\>\"", "+", "\"\<Z\>\""}], "->", 
       RowBox[{
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(X\), \(1\)]\)\>\"", "+", 
          "\"\<\!\(\*SubscriptBox[\(Y\), \(1\)]\)\>\""}], "\[LeftArrow]", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(Y\), \(1\)]\)\>\"", "+", "\"\<Z\>\""}]}], "->", 
        RowBox[{
         RowBox[{
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(X\), \(2\)]\)\>\"", "+", 
           "\"\<\!\(\*SubscriptBox[\(Y\), \(1\)]\)\>\""}], "\[LeftArrow]", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(X\), \(2\)]\)\>\"", "+", "\"\<Z\>\""}]}], 
         "->", 
         RowBox[{
          RowBox[{
           RowBox[{
           "\"\<\!\(\*SubscriptBox[\(X\), \(2\)]\)\>\"", "+", 
            "\"\<\!\(\*SubscriptBox[\(Y\), \(2\)]\)\>\""}], "\[LeftArrow]", 
           RowBox[{
           "\"\<\!\(\*SubscriptBox[\(Y\), \(2\)]\)\>\"", "+", "\"\<Z\>\""}]}],
           "->", 
          RowBox[{
           RowBox[{
           "\"\<\!\(\*SubscriptBox[\(X\), \(1\)]\)\>\"", "+", 
            "\"\<\!\(\*SubscriptBox[\(Y\), \(2\)]\)\>\""}], "\[LeftArrow]", 
           RowBox[{
           "\"\<\!\(\*SubscriptBox[\(X\), \(1\)]\)\>\"", "+", 
            "\"\<Z\>\""}]}]}]}]}]}], "}"}], ",", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", "Italic", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{
        "a", ",", "a", ",", "c", ",", "c", ",", "d", ",", "d", ",", "b", ",", 
         "b"}], "}"}]}], ")"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7105722669331822`*^9, 3.710572331711892*^9}, {
  3.710572364230754*^9, 3.7105725483159304`*^9}, {3.7105754178075056`*^9, 
  3.710575419135634*^9}, {3.7105754603388395`*^9, 3.710575737558131*^9}, {
  3.71057578004259*^9, 3.710575817917664*^9}, {3.710575848573974*^9, 
  3.710575883620917*^9}, {3.7105759231366196`*^9, 3.7105759440272865`*^9}, {
  3.7307016813108597`*^9, 
  3.7307016816858616`*^9}},ExpressionUUID->"725c1ebe-1fac-49ba-b86d-\
765e005a9980"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.6\>\"", ",", "example4"}], "]"}]], "Input",
 CellChangeTimes->{{3.710574330076294*^9, 3.710574340545059*^9}, {
  3.7105757489487786`*^9, 3.710575751714409*^9}, {3.7285720968209248`*^9, 
  3.728572112352206*^9}},ExpressionUUID->"39d096b5-d708-4f3c-b33a-\
71c658fa93d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.7", "Subsubsection",
 CellChangeTimes->{{3.72857214044601*^9, 3.7285721407428856`*^9}, 
   3.7286441056201935`*^9},ExpressionUUID->"2b5c5d14-1a75-405c-8adb-\
01f4aec55082"],

Cell[BoxData[
 RowBox[{
  RowBox[{"defone", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "\"\<\!\(\*SubscriptBox[\(A\), \(1\)]\)\>\""}], 
      "\[Equilibrium]", "\"\<\!\(\*SubscriptBox[\(A\), \(2\)]\)\>\"", 
      "\[Equilibrium]", 
      RowBox[{"2", "\"\<\!\(\*SubscriptBox[\(A\), \(3\)]\)\>\""}], 
      "\[Equilibrium]", "\"\<\!\(\*SubscriptBox[\(A\), \(4\)]\)\>\""}], ",", 
     RowBox[{"\"\<\!\(\*SubscriptBox[\(A\), \(2\)]\)\>\"", "\[Equilibrium]", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(A\), \(1\)]\)\>\"", "+", 
       "\"\<\!\(\*SubscriptBox[\(A\), \(3\)]\)\>\""}], "\[Equilibrium]", 
      RowBox[{"2", "\"\<\!\(\*SubscriptBox[\(A\), \(3\)]\)\>\""}]}], ",", 
     RowBox[{
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(A\), \(1\)]\)\>\"", "+", 
       "\"\<\!\(\*SubscriptBox[\(A\), \(4\)]\)\>\""}], "\[RightArrow]", 
      "\"\<\!\(\*SubscriptBox[\(A\), \(5\)]\)\>\"", "\[RightArrow]", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(A\), \(6\)]\)\>\"", "\[Equilibrium]", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(A\), \(1\)]\)\>\"", "+", 
        "\"\<\!\(\*SubscriptBox[\(A\), \(4\)]\)\>\""}]}]}], ",", 
     RowBox[{
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(A\), \(3\)]\)\>\"", "+", 
       "\"\<\!\(\*SubscriptBox[\(A\), \(5\)]\)\>\""}], "\[Equilibrium]", 
      RowBox[{"2", "\"\<\!\(\*SubscriptBox[\(A\), \(7\)]\)\>\""}]}]}], 
    "}"}]}], ";"}]], "Input",ExpressionUUID->"c3570fc1-b341-41cc-a06a-\
68e1dc3fddd5"],

Cell[BoxData[
 RowBox[{"defione", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"defone", ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{
      RowBox[{"StringReplace", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ReactionsData", "[", 
          RowBox[{"{", 
           RowBox[{"defone", "[", 
            RowBox[{"[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "}"}], "]"}], 
         "[", "\"\<deficiency\>\"", "]"}], ",", 
        RowBox[{
        "\"\<\[Delta]\>\"", "\[Rule]", 
         "\"\<\!\(\*SubscriptBox[\(\[Delta]\), \(1\)]\) \>\""}]}], "]"}], 
      "<>", "\"\<\\n\\n\>\"", "<>", 
      RowBox[{"StringReplace", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ReactionsData", "[", 
          RowBox[{"{", 
           RowBox[{"defone", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "}"}], "]"}], "[", 
         "\"\<deficiency\>\"", "]"}], ",", 
        RowBox[{
        "\"\<\[Delta]\>\"", "\[Rule]", 
         "\"\< \!\(\*SubscriptBox[\(\[Delta]\), \(2\)]\) \>\""}]}], "]"}], "<>",
       "\[IndentingNewLine]", 
      RowBox[{"StringReplace", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ReactionsData", "[", 
          RowBox[{"{", 
           RowBox[{"defone", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "}"}], "]"}], "[", 
         "\"\<deficiency\>\"", "]"}], ",", 
        RowBox[{
        "\"\<\[Delta]\>\"", "\[Rule]", 
         "\"\<    \!\(\*SubscriptBox[\(\[Delta]\), \(3\)]\)\>\""}]}], 
       "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6440765095487614`*^9, 3.6440765111408525`*^9}, {
   3.644076565158942*^9, 3.644076790102808*^9}, {3.6472368878481073`*^9, 
   3.647236901118126*^9}, {3.694872743594037*^9, 3.694872754140932*^9}, {
   3.69487298773514*^9, 3.6948730247352114`*^9}, {3.6948730978134794`*^9, 
   3.694873188563657*^9}, {3.6948732295949864`*^9, 3.694873236923126*^9}, {
   3.694873268751313*^9, 3.694873270157566*^9}, {3.694873304235759*^9, 
   3.6948734229703646`*^9}, {3.7023685143155193`*^9, 3.7023685173456926`*^9}, 
   3.7024852079041605`*^9, {3.703395418200492*^9, 3.7033954454349203`*^9}, 
   3.710570820579107*^9},ExpressionUUID->"c0cfcc0c-4b23-4b15-9a50-\
b9f0466ef3ac"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.7\>\"", ",", "defione"}], "]"}]], "Input",
 CellChangeTimes->{{3.6440767974712296`*^9, 3.644076807497803*^9}, {
  3.728572180774214*^9, 
  3.7285722020555058`*^9}},ExpressionUUID->"67e7e987-1b4b-49f3-bbd0-\
f084a26848ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.8", "Subsubsection",
 CellChangeTimes->{{3.728572209383645*^9, 3.728572210493023*^9}, 
   3.7286441157764635`*^9},ExpressionUUID->"6992ea7f-7e1e-4e0e-8c11-\
b81be8033ecc"],

Cell[BoxData[
 RowBox[{"reversibletriangle", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ToReversible", "[", "\"\<Triangle\>\"", "]"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "16", ",", "Bold"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)\>\"", ",", 
       "\"\<\!\(\*SubscriptBox[\(k\), \(-1\)]\)\>\"", ",", 
       "\"\<\!\(\*SubscriptBox[\(k\), \(2\)]\)\>\"", ",", 
       "\"\<\!\(\*SubscriptBox[\(k\), \(-2\)]\)\>\"", ",", 
       "\"\<\!\(\*SubscriptBox[\(k\), \(3\)]\)\>\"", ",", 
       "\"\<\!\(\*SubscriptBox[\(k\), \(-3\)]\)\>\""}], "}"}]}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5504788783838534`*^9, 3.550478904806331*^9}, {
   3.5695836441564455`*^9, 3.5695836564641495`*^9}, {3.6978658904099045`*^9, 
   3.697865995973951*^9}, 
   3.7306096084958973`*^9},ExpressionUUID->"feb73613-3653-4e08-b4a7-\
d99c9a470e43"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.8\>\"", ",", "reversibletriangle"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6978660106587954`*^9, 3.6978660231085052`*^9}, {
  3.728572220430542*^9, 
  3.7285722283211823`*^9}},ExpressionUUID->"369ef10c-efd2-4cb8-a4fc-\
dbbaecc17001"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.9", "Subsubsection",
 CellChangeTimes->{{3.728573846846508*^9, 3.7285738478308845`*^9}, 
   3.728644125292107*^9},ExpressionUUID->"1264d9e1-0864-40c2-91a4-\
5d00875a3000"],

Cell[BoxData[
 RowBox[{"sclfhj", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[Equilibrium]", "\"\<D\>\"",
        "\[Equilibrium]", 
       RowBox[{"2", "\"\<C\>\""}]}], ",", 
      RowBox[{
       RowBox[{"2", "\"\<E\>\""}], "\[Equilibrium]", "\"\<C\>\"", 
       "\[Equilibrium]", "\"\<F\>\""}], ",", 
      RowBox[{
       RowBox[{"\"\<A\>\"", "+", "\"\<G\>\""}], "\[Equilibrium]", 
       "\"\<H\>\""}], ",", 
      RowBox[{
       RowBox[{"\"\<I\>\"", "+", "\"\<J\>\""}], "\[Equilibrium]", 
       RowBox[{"2", "\"\<B\>\""}], "\[Equilibrium]", "\"\<K\>\"", 
       "\[Equilibrium]", 
       RowBox[{"\"\<I\>\"", "+", "\"\<J\>\""}]}]}], "}"}], ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.648791835628253*^9, 3.6487918442447453`*^9}, {
   3.64879192526538*^9, 3.6487920536768084`*^9}, 
   3.6487920943208675`*^9},ExpressionUUID->"db063798-bf0c-484f-a786-\
c061a0fdf1ca"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.9\>\"", ",", "sclfhj"}], "]"}]], "Input",
 CellChangeTimes->{{3.6487921169629073`*^9, 3.648792124422918*^9}, {
  3.7285738649090414`*^9, 
  3.728573874299686*^9}},ExpressionUUID->"4edb6ec7-1660-43d3-afcb-\
f90bec18be8a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.10", "Subsubsection",
 CellChangeTimes->{{3.7285739916905413`*^9, 3.7285739931749196`*^9}, 
   3.7286441347921257`*^9},ExpressionUUID->"11c154d5-b343-443e-ac49-\
e88b36bcc8c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "[", "l_", "]"}], ":=", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"Style", "[", 
       RowBox[{"l", ",", "Bold"}], "]"}], "}"}], "}"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6487910430235624`*^9, 3.6487910677055984`*^9}, {
  3.648791112477662*^9, 3.6487911605965943`*^9}, {3.6487912079873047`*^9, 
  3.6487912157397485`*^9}},ExpressionUUID->"b1d64e82-7626-4641-be75-\
e377f552be63"],

Cell[BoxData[
 RowBox[{"scl", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<G\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(3\)]\)\>\"", "]"}]}], 
        ",", "\"\<A+G\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<H\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(3\)]\)\>\"", "]"}]}], 
        ",", "\"\<H\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<A\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(3\)]\)\>\"", "]"}]}], 
        ",", "\"\<A\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<C\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(2\)]\)\>\"", "]"}]}], 
        ",", "\"\<C\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<F\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(2\)]\)\>\"", "]"}]}], 
        ",", "\"\<F\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<E\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(2\)]\)\>\"", "]"}]}], 
        ",", "\"\<2E\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<A\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(1\)]\)\>\"", "]"}]}], 
        ",", "\"\<A+B\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<C\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(1\)]\)\>\"", "]"}]}], 
        ",", "\"\<2C\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<D\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(1\)]\)\>\"", "]"}]}], 
        ",", "\"\<D\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<B\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(1\)]\)\>\"", "]"}]}], 
        ",", "\"\<A+B\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<B\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(4\)]\)\>\"", "]"}]}], 
        ",", "\"\<2B\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<K\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(4\)]\)\>\"", "]"}]}], 
        ",", "\"\<K\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<J\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(4\)]\)\>\"", "]"}]}], 
        ",", "\"\<I+J\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<I\>\"", "\[Rule]", 
         RowBox[{
         "gr", "[", "\"\<\!\(\*SubscriptBox[\(L\), \(4\)]\)\>\"", "]"}]}], 
        ",", "\"\<I+J\>\""}], "}"}]}], "}"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.648790160834323*^9, 3.648790287566501*^9}, {
  3.6487903518665915`*^9, 3.648790353966594*^9}, {3.648790533776846*^9, 
  3.648790559576882*^9}, {3.648791059883586*^9, 3.648791088775628*^9}, {
  3.6487911385017014`*^9, 3.6487911753394375`*^9}, {3.6487912390430813`*^9, 
  3.648791509472598*^9}, {3.6487915421084642`*^9, 3.648791553851136*^9}, {
  3.6487915918033066`*^9, 
  3.648791654219877*^9}},ExpressionUUID->"e054dd7a-e58b-4f41-8a54-\
2eccd1b01299"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.10\>\"", ",", "scl"}], "]"}]], "Input",
 CellChangeTimes->{{3.648791640159073*^9, 3.6487916626733603`*^9}, {
  3.728574004237444*^9, 
  3.7285740125968313`*^9}},ExpressionUUID->"be3492bd-64c1-45b1-bc01-\
f4aaccfec0af"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.11", "Subsubsection",
 CellChangeTimes->{
  3.7105703269903965`*^9, {3.728644153807788*^9, 
   3.7286441571515446`*^9}},ExpressionUUID->"1742d999-f196-4268-91ef-\
d30cc267291e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"volpertivanova", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[Rule]", " ", 
      RowBox[{"2", "\"\<B\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<D\>\""}], "\[Rule]", " ", 
      RowBox[{"2", "\"\<D\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<B\>\"", "+", "\"\<C\>\""}], "\[Rule]", " ", 
      RowBox[{"2", "\"\<C\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<D\>\"", "+", "\"\<E\>\""}], "\[Rule]", " ", 
      RowBox[{"2", "\"\<E\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<C\>\"", "+", "\"\<A\>\""}], "\[Rule]", " ", 
      RowBox[{"2", "\"\<A\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<E\>\"", "+", "\"\<A\>\""}], "\[Rule]", " ", 
      RowBox[{"2", "\"\<A\>\""}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.662102349493968*^9, 3.6621024296140804`*^9}, {
   3.7040385905266347`*^9, 3.704038636460451*^9}, {3.71057112619061*^9, 
   3.710571130917881*^9}, 
   3.7286469781773796`*^9},ExpressionUUID->"29d51e7f-42e2-4dd9-88ab-\
0a3c1890ddec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"con", "=", 
   RowBox[{"Concentrations", "[", 
    RowBox[{"volpertivanova", ",", 
     RowBox[{"{", 
      RowBox[{
      "100", ",", "100", ",", "660", ",", "660", ",", "600", ",", "360"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"vi", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"ReplaceAll", "@@", "con"}], ")"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "0.1"}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{"\"\<t\>\"", ",", "\"\<a(t)\>\""}], "}"}]}], ")"}]}], ",", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7105712597952614`*^9, 3.71057130884907*^9}, {
  3.710571348264329*^9, 
  3.7105713488833637`*^9}},ExpressionUUID->"d7d45f2a-4b17-47f4-88de-\
3907d7ca6844"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.11\>\"", ",", "vi"}], "]"}]], "Input",
 CellChangeTimes->{{3.710571356721814*^9, 3.710571362433139*^9}, {
  3.728574067159439*^9, 
  3.7285740739563274`*^9}},ExpressionUUID->"a5e7ecf7-4859-4352-a92f-\
c08933fd02ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.12", "Subsubsection",
 CellChangeTimes->{{3.728574151940854*^9, 3.728574154268984*^9}, 
   3.7286441655890617`*^9},ExpressionUUID->"bec0a47c-c4ad-4941-8be5-\
3859957c554b"],

Cell[BoxData[
 RowBox[{"vivg", "=", 
  RowBox[{"ShowVolpertGraph", "[", 
   RowBox[{"volpertivanova", ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
    RowBox[{"SingleLetterItalics", "\[Rule]", "\"\<False\>\""}], ",", 
    RowBox[{"Numbered", "\[Rule]", "True"}], ",", 
    RowBox[{"EdgeLabeled", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.662102518656206*^9, 3.662102532748229*^9}, {
  3.6621026897440643`*^9, 3.662102698071541*^9}, {3.662102739277898*^9, 
  3.6621027869006214`*^9}, {3.699023348212756*^9, 3.6990233525877647`*^9}, {
  3.705585491867985*^9, 3.705585503744667*^9}, {3.71057117912164*^9, 
  3.7105711796876726`*^9}, {3.730877629619831*^9, 
  3.730877631322961*^9}},ExpressionUUID->"d2c56977-958e-4362-a28c-\
58758f22e088"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.12\>\"", ",", "vivg"}], "]"}]], "Input",
 CellChangeTimes->{{3.710571189228218*^9, 3.710571208691334*^9}, {
  3.72857416701901*^9, 
  3.728574173565897*^9}},ExpressionUUID->"0dad1e3e-da37-4028-9092-\
9f563ac690e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.13", "Subsubsection",
 CellChangeTimes->{{3.7285746195198946`*^9, 3.728574622410525*^9}, 
   3.728644174479704*^9},ExpressionUUID->"d11b8c07-0d8f-4c92-9894-\
9054b6f00bbb"],

Cell[BoxData[
 RowBox[{"gradsys", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "\"\<X\>\""}], "\[RightArrow]", 
       RowBox[{
        RowBox[{"3", "\"\<X\>\""}], "+", 
        RowBox[{"3", "\"\<Y\>\""}]}]}], ",", 
      RowBox[{
       RowBox[{"2", "\"\<Y\>\""}], "\[RightArrow]", 
       RowBox[{
        RowBox[{"3", "\"\<X\>\""}], "+", 
        RowBox[{"3", "\"\<Y\>\""}]}]}], ",", 
      RowBox[{
       RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[RightArrow]", 
       RowBox[{
        RowBox[{"3", "\"\<X\>\""}], "+", 
        RowBox[{"3", "\"\<Y\>\""}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "2"], ",", 
      RowBox[{"3", 
       SubscriptBox["k", "2"]}]}], "}"}], ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.699375587583709*^9, 3.699375632661923*^9}, {
  3.699376662067052*^9, 3.699376697991107*^9}, {3.710929069583448*^9, 
  3.7109290824001813`*^9}},ExpressionUUID->"5b3e74db-8049-4c77-9254-\
8e8f9cbc1736"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.13\>\"", ",", "gradsys"}], "]"}]], "Input",
 CellChangeTimes->{{3.6993763359445477`*^9, 3.699376353366456*^9}, {
  3.728574636051175*^9, 
  3.7285746531137094`*^9}},ExpressionUUID->"0b135ee5-18e1-41c8-8fa2-\
698117378e53"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.14", "Subsubsection",
 CellChangeTimes->{{3.7285747010044284`*^9, 3.7285747027544317`*^9}, 
   3.7286441867922277`*^9},ExpressionUUID->"7472bd12-ffda-48b1-a2ae-\
c68c90ecf42f"],

Cell[BoxData[
 RowBox[{"hamsys", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "\"\<X\>\""}], "\[Rule]", " ", 
       RowBox[{
        RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", " ", 
        RowBox[{
         RowBox[{"2", "\"\<X\>\""}], "+", "\"\<Y\>\""}]}]}], ",", 
      RowBox[{
       RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", " ", 
       RowBox[{
        RowBox[{"2", "\"\<Y\>\""}], "\[Rule]", 
        RowBox[{
         RowBox[{"2", "\"\<X\>\""}], "+", "\"\<Y\>\""}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "\"\<1/2\>\""}], "}"}], ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6994578707298117`*^9, 3.699458013761342*^9}, {
  3.6994580615270605`*^9, 3.699458078511469*^9}, {3.699510481052834*^9, 
  3.699510516287278*^9}, {3.699510552552975*^9, 3.699510561474867*^9}, {
  3.69951063189688*^9, 3.699510634506259*^9}, {3.7105715075389137`*^9, 
  3.7105715112264204`*^9}},ExpressionUUID->"fabde943-ce9d-46ad-9718-\
48a8a4a5a82e"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.14\>\"", ",", "hamsys"}], "]"}]], "Input",
 CellChangeTimes->{{3.6995106395375195`*^9, 3.6995106426937733`*^9}, {
  3.7285747141763287`*^9, 
  3.728574722582595*^9}},ExpressionUUID->"84cd5c77-dc96-4aae-852b-\
24510f93bf25"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 8.15", "Subsubsection",
 CellChangeTimes->{{3.7285747602857933`*^9, 3.728574765192054*^9}, 
   3.7286441966672473`*^9},ExpressionUUID->"20680bc3-b96e-42e2-9667-\
3592c5f5520c"],

Cell[BoxData[
 RowBox[{"cresys", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", "\"\<X\>\""}], "\[RightArrow]", 
        RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}]}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"2", "\"\<Y\>\""}], "\[RightArrow]", 
       RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"2", "k"}], ",", "k"}], "}"}], ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7105703384279194`*^9, 3.7105703384279194`*^9}, 
   3.7105714889138775`*^9, {3.7105715199139385`*^9, 
   3.7105715844609385`*^9}},ExpressionUUID->"d6eba4be-767b-4aa6-a18f-\
fdbaa0316350"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig8.15\>\"", ",", "cresys"}], "]"}]], "Input",
 CellChangeTimes->{{3.710571595960964*^9, 3.7105716049766045`*^9}, {
  3.7285747467857676`*^9, 
  3.728574754910782*^9}},ExpressionUUID->"54a3fbf0-1f74-4056-8865-\
d4b7268d0ffd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"d1b72095-b9f1-4c34-8738-\
77ff09979b5c"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["e", "0"], ",", 
     SubscriptBox["s", "0"], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "s", ",", "c", ",", "p"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7097272483269234`*^9, 3.709727319070975*^9}, {
  3.7301885118502417`*^9, 
  3.7301885157252502`*^9}},ExpressionUUID->"0d953a14-5fd3-4328-9ea6-\
a3457bb582cc"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Triangle\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "0"], ",", 
     SubscriptBox["b", "0"], ",", 
     SubscriptBox["c", "0"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7097272483269234`*^9, 3.7097273508027925`*^9}, {
   3.7097274911198277`*^9, 3.709727538099286*^9}, 3.7301885355221643`*^9, 
   3.7306096552928653`*^9},ExpressionUUID->"b1c6fa10-fb69-4a7d-9187-\
faf8c0e2d242"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{
   RowBox[{"ToReversible", "[", 
    RowBox[{"{", "\"\<Triangle\>\"", "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "0"], ",", 
     SubscriptBox["b", "0"], ",", 
     SubscriptBox["c", "0"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7097276383338585`*^9, 3.709727646099498*^9}, 
   3.7301885400065484`*^9, 
   3.730609660561289*^9},ExpressionUUID->"9023057a-f530-4b6b-b0cf-\
1a9dc473d49a"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x0", ",", "y0"}], "}"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.709728740866041*^9, 3.709728740866041*^9}, {
   3.709728852288134*^9, 3.709728859381898*^9}, {3.7097288931163397`*^9, 
   3.7097289685696115`*^9}, {3.709729054210405*^9, 3.70972906783543*^9}, {
   3.7100808276292667`*^9, 3.7100808767490826`*^9}, {3.7141017098747416`*^9, 
   3.714101742842904*^9}, 
   3.7301885453503065`*^9},ExpressionUUID->"3bfa35fa-f40e-4df0-8a88-\
7002ea8f575b"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a0", ",", "x0", ",", "y0", ",", "b0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.709728740866041*^9, 3.709728740866041*^9}, {
   3.709728852288134*^9, 3.709728859381898*^9}, {3.7097288931163397`*^9, 
   3.7097289685696115`*^9}, {3.709729054210405*^9, 3.70972906783543*^9}, {
   3.7100808276292667`*^9, 3.7100808767490826`*^9}, {3.7141017098747416`*^9, 
   3.7141017742390585`*^9}, 
   3.73018854892844*^9},ExpressionUUID->"aded7be7-f2ce-45ac-85f6-\
55fdcc3cfbe2"],

Cell[CellGroupData[{

Cell["Example 8.16", "Subsubsection",
 CellChangeTimes->{{3.729182429075951*^9, 
  3.729182437310342*^9}},ExpressionUUID->"768dd80c-53ab-4ebb-bd37-\
8cc85f275204"],

Cell[BoxData[
 RowBox[{"Row", "@", 
  RowBox[{"Riffle", "[", 
   RowBox[{
    RowBox[{"VolpertIndexing", "[", 
     RowBox[{
      RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<E\>\"", ",", "\"\<S\>\""}], "}"}], ",", 
      RowBox[{"Verbose", "\[Rule]", "True"}]}], "]"}], ",", "\"\<  \>\""}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.72918244099785*^9, 3.729182515243566*^9}, {
  3.730445333423608*^9, 
  3.7304453630955415`*^9}},ExpressionUUID->"2dd44c52-5a11-49b9-bc64-\
e4d412ed247d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.20", "Subsubsection",
 CellChangeTimes->{{3.729183012365813*^9, 
  3.7291830165533223`*^9}},ExpressionUUID->"b9939d78-d170-4495-9365-\
655f08f42ea8"],

Cell[BoxData[
 RowBox[{"con", "=", 
  RowBox[{"ReplaceAll", "@@", 
   RowBox[{"Concentrations", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "\"\<X\>\""}], " ", "\[Rule]", 
        RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}]}], ",", 
       RowBox[{"0", "\[Rule]", "\"\<Y\>\""}], ",", 
       RowBox[{
        RowBox[{"2", "\"\<Y\>\""}], "->", 
        RowBox[{"3", "\"\<X\>\""}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.77"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.712666113488967*^9, 3.712666194708202*^9}, {
  3.7291830230533333`*^9, 3.729183037490862*^9}, {3.7301976927448597`*^9, 
  3.730197699592248*^9}},ExpressionUUID->"b710d0ba-1a6e-4ce9-be46-\
8394799a7442"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"con", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.", ",", "0.8"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712666203096901*^9, 
  3.7126662954410114`*^9}},ExpressionUUID->"4d6ea6e7-dbe8-4b6d-9614-\
5511f445d878"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.32", "Subsubsection",
 CellChangeTimes->{{3.712680779965563*^9, 3.7126807833821597`*^9}, {
  3.7291828115675335`*^9, 
  3.7291828150977373`*^9}},ExpressionUUID->"d874666f-9ab9-4246-a208-\
af0582064b5a"],

Cell[BoxData[
 RowBox[{"Last", "/@", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\"\<H\>\"", "\[Equilibrium]", 
        RowBox[{"2", "\"\<J\>\""}]}], "\[Rule]", 
       RowBox[{
        RowBox[{"\"\<G\>\"", "\[LeftArrow]", 
         RowBox[{
          RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[Equilibrium]", 
          "\"\<C\>\""}]}], "\[Rule]", 
        RowBox[{
         RowBox[{"\"\<D\>\"", "+", "\"\<E\>\""}], "\[Equilibrium]", 
         "\"\<F\>\""}]}]}], ",", 
      RowBox[{"\"\<G\>\"", "\[Rule]", "\"\<H\>\""}]}], "}"}], "]"}], "[", 
   "\"\<fhjterminalstronglyconnectedcomponents\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.712680785880191*^9, 3.712680841453212*^9}, {
  3.729182840187175*^9, 
  3.7291828636175137`*^9}},ExpressionUUID->"71a5d31b-5025-4b8c-b894-\
4301a7c2efe4"],

Cell[BoxData[
 RowBox[{"Last", "/@", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<Z\>\"", "\[LeftArrow]", "\"\<X\>\""}], "\[Rule]", 
      "\"\<Y\>\""}], "}"}], "]"}], "[", 
   "\"\<fhjterminalstronglyconnectedcomponents\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.712680785880191*^9, 3.7126808810052824`*^9}, {
  3.729182907912484*^9, 
  3.7291829146156216`*^9}},ExpressionUUID->"eef09176-fa6a-4a35-b510-\
9c91d9c136db"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.36", "Subsubsection",
 CellChangeTimes->{{3.729183226663105*^9, 
  3.729183231256866*^9}},ExpressionUUID->"c8ea18dd-6743-4731-8c37-\
58ca58cfd2fd"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<X\>\"", "\[LeftArrow]", " ", 
       RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}]}], "\[Rule]", " ", 
      "\"\<Y\>\""}], ",", 
     RowBox[{
      RowBox[{"2", "\"\<X\>\""}], "\[Rule]", 
      RowBox[{
       RowBox[{"2", "\"\<X\>\""}], "+", "\"\<Y\>\""}]}], ",", 
     RowBox[{
      RowBox[{"2", "\"\<Y\>\""}], "\[Rule]", 
      RowBox[{"\"\<X\>\"", "+", 
       RowBox[{"2", "\"\<Y\>\""}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.729183236194377*^9, 
  3.729183368498082*^9}},ExpressionUUID->"f9532ffd-4c67-4c75-8706-\
47428b2f4e2c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.65", "Subsubsection",
 CellChangeTimes->{{3.713004078119842*^9, 3.7130040826411424`*^9}, {
  3.7291837329736433`*^9, 3.729183737020528*^9}, {3.7304455968459983`*^9, 
  3.730445597314748*^9}},ExpressionUUID->"6714a319-4aec-4c0a-9239-\
f0a5194f5543"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "Y"}], "\[Rule]", 
      RowBox[{
       RowBox[{"2", "X"}], "\[Rule]", 
       RowBox[{
        RowBox[{"2", "X"}], "+", "Y"}]}]}], ",", 
     RowBox[{"0", "\[Rule]", " ", 
      RowBox[{"X", "\[Rule]", "Y"}]}], ",", 
     RowBox[{"Y", "\[Rule]", "0"}], ",", 
     RowBox[{"Y", "\[Rule]", "X"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "6", ",", "3", ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304455999085045`*^9, 3.730445814127672*^9}, {
  3.7304458443873205`*^9, 3.73044586538736*^9}, {3.730445899028053*^9, 
  3.7304459732938213`*^9}},ExpressionUUID->"510acac3-45a4-4016-a4b9-\
3f248714098b"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "Y"}], "\[Rule]", 
      RowBox[{
       RowBox[{"2", "X"}], "\[Rule]", 
       RowBox[{
        RowBox[{"2", "X"}], "+", "Y"}]}]}], ",", 
     RowBox[{"0", "\[Rule]", " ", 
      RowBox[{"X", "\[Rule]", "Y"}]}], ",", 
     RowBox[{"Y", "\[Rule]", "0"}], ",", 
     RowBox[{"Y", "\[Rule]", "X"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "6", ",", "3", ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304455999085045`*^9, 3.730445814127672*^9}, {
  3.7304458443873205`*^9, 3.73044586538736*^9}, {3.730445899028053*^9, 
  3.73044599571574*^9}},ExpressionUUID->"0bbd9f76-6843-4b0b-9ac7-\
6ddd00cd04e4"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"6", " ", "x"}], "+", 
       SuperscriptBox["x", "2"], "-", 
       RowBox[{"6", " ", "y"}], "-", 
       SuperscriptBox["y", "2"]}], ",", 
      RowBox[{"2", "-", 
       RowBox[{"6", " ", "x"}], "+", 
       RowBox[{"3", " ", "y"}], "+", 
       SuperscriptBox["y", "2"]}]}], "}"}], "\[Equal]", "0"}], ",", "Reals"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.7304460104345193`*^9, 3.73044601885641*^9}, {
  3.7307315793562927`*^9, 
  3.7307315808719177`*^9}},ExpressionUUID->"b5ef6688-299b-4342-b859-\
0825250363a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.66", "Subsubsection",
 CellChangeTimes->{{3.713004078119842*^9, 3.7130040826411424`*^9}, {
  3.7291837329736433`*^9, 
  3.729183737020528*^9}},ExpressionUUID->"863ea350-1541-414b-a7e5-\
d909d7346a88"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[Equilibrium]", "\"\<D\>\"", 
      "\[Equilibrium]", 
      RowBox[{"2", "\"\<C\>\""}]}], ",", 
     RowBox[{
      RowBox[{"2", "\"\<E\>\""}], "\[Equilibrium]", "\"\<C\>\"", 
      "\[Equilibrium]", "\"\<F\>\""}], ",", 
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<G\>\""}], "\[Equilibrium]", 
      "\"\<H\>\""}], ",", 
     RowBox[{
      RowBox[{"\"\<I\>\"", "+", "\"\<J\>\""}], "\[Equilibrium]", 
      RowBox[{"2", "\"\<B\>\""}], "\[Equilibrium]", "\"\<K\>\"", 
      "\[Equilibrium]", 
      RowBox[{"\"\<I\>\"", "+", "\"\<J\>\""}]}]}], "}"}], "]"}], "[", 
  RowBox[{"\"\<deficiency\>\"", ",", "\"\<species\>\"", ",", "\"\<M\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.648791835628253*^9, 3.6487918442447453`*^9}, {
   3.64879192526538*^9, 3.6487920536768084`*^9}, 3.6487920943208675`*^9, {
   3.7130041023738613`*^9, 3.7130041221111093`*^9}, {3.713004200446754*^9, 
   3.7130042088720074`*^9}},ExpressionUUID->"1be2b678-e484-4049-b10c-\
07141e262adf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<A\>\""}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<B\>\""}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<C\>\""}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<D\>\""}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<E\>\""}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<F\>\""}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<G\>\""}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<H\>\""}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<I\>\""}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<J\>\""}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "\"\<K\>\""}], ",", 
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[Equilibrium]", "\"\<D\>\"", 
      "\[Equilibrium]", 
      RowBox[{"2", "\"\<C\>\""}]}], ",", 
     RowBox[{
      RowBox[{"2", "\"\<E\>\""}], "\[Equilibrium]", "\"\<C\>\"", 
      "\[Equilibrium]", "\"\<F\>\""}], ",", 
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<G\>\""}], "\[Equilibrium]", 
      "\"\<H\>\""}], ",", 
     RowBox[{
      RowBox[{"\"\<I\>\"", "+", "\"\<J\>\""}], "\[Equilibrium]", 
      RowBox[{"2", "\"\<B\>\""}], "\[Equilibrium]", "\"\<K\>\"", 
      "\[Equilibrium]", 
      RowBox[{"\"\<I\>\"", "+", "\"\<J\>\""}]}]}], "}"}], "]"}], "[", 
  "\"\<deficiency\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.648791835628253*^9, 3.6487918442447453`*^9}, {
   3.64879192526538*^9, 3.6487920536768084`*^9}, 3.6487920943208675`*^9, {
   3.7130041023738613`*^9, 
   3.713004193337488*^9}},ExpressionUUID->"f29160f7-845c-4552-b91a-\
d20f93f3acb6"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numeric", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 3.7096139310971584`*^9}, {
  3.7097241728756065`*^9, 3.7097241786889396`*^9}, {3.7098074825676517`*^9, 
  3.7098074899290037`*^9}},ExpressionUUID->"9d321898-a020-4950-9882-\
cd524bdfd4bd"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"4972cdba-19e5-44fa-bb9d-\
1d98fb6e1e75"],

Cell[CellGroupData[{

Cell["Fig. 9.1", "Subsubsection",
 CellChangeTimes->{{3.7285764541614065`*^9, 3.728576455520785*^9}, 
   3.7286442062141395`*^9},ExpressionUUID->"3f1609a9-bdf8-4b47-9a50-\
1a20a65bab13"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"param", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "1"], "\[Rule]", " ", "40"}], ",", 
     RowBox[{
      SubscriptBox["k", 
       RowBox[{"-", "1"}]], "\[Rule]", " ", "5"}], ",", 
     RowBox[{
      SubscriptBox["k", 
       RowBox[{"-", "2"}]], "\[Rule]", "0.5"}], ",", 
     RowBox[{
      SubscriptBox["e", "0"], "\[Rule]", "0.01"}], ",", 
     RowBox[{
      SubscriptBox["s", "0"], "\[Rule]", "0.1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tfin", "=", "12"}], ";"}]}], "Input",
 CellChangeTimes->{{3.710824994756344*^9, 3.710825024115778*^9}, {
  3.710825085178399*^9, 3.7108251551941605`*^9}, {3.710825356286501*^9, 
  3.710825359111662*^9}, {3.7108269837412567`*^9, 3.710827008756931*^9}, {
  3.7109295259815865`*^9, 
  3.710929533742028*^9}},ExpressionUUID->"576f0dff-27f1-4c9c-b988-\
a93fba43d861"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mmreaction", "=", 
   RowBox[{"GetReaction", "[", "\"\<Michaelis-Menten\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.710929292606221*^9, 3.710929304723918*^9}, 
   3.710929469313341*^9, 
   3.728798202871417*^9},ExpressionUUID->"1d7eee88-90ee-4bce-b019-\
d6bd4df2447a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mmcoordfunc", "=", 
   RowBox[{"ReplaceAll", "@@", 
    RowBox[{"Concentrations", "[", 
     RowBox[{
      RowBox[{"{", "mmreaction", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "5", ",", "0.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.01", ",", "0.1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", "tfin"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "s", ",", "c", ",", "p"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7109293077570877`*^9, 3.710929461297879*^9}, {
  3.7109295407994328`*^9, 
  3.7109295440686197`*^9}},ExpressionUUID->"5c6eb377-ea7d-4f99-b8d8-\
bc79f0cfd1bb"],

Cell[BoxData[
 RowBox[{"exact", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"mmcoordfunc", "\[LeftDoubleBracket]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "\[RightDoubleBracket]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "tfin"}]}], "}"}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<t\>\"", ",", "Italic"}], "]"}], ",", 
       RowBox[{"Row", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"#", ",", "Italic"}], "]"}], "&"}], "/@", 
         RowBox[{"{", "\"\<s(t),c(t)\>\"", "}"}]}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.710929481648043*^9, 3.7109294972139373`*^9}, {
   3.7109295500229588`*^9, 3.71092956856402*^9}, 3.712823253134945*^9, {
   3.7128232845456257`*^9, 
   3.7128233462736597`*^9}},ExpressionUUID->"57111269-2e02-4926-b9b4-\
cd65d4be5412"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.1A\>\"", ",", "exact"}], "]"}]], "Input",
 CellChangeTimes->{{3.710832396189112*^9, 3.7108324078922606`*^9}, {
  3.7285764262238493`*^9, 
  3.7285764477551427`*^9}},ExpressionUUID->"51546a36-8403-4094-b92f-\
dd45911c896f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"souter", "[", "t_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["s", "0"], 
      FractionBox[
       RowBox[{"K", " ", 
        RowBox[{"ProductLog", "[", 
         FractionBox[
          RowBox[{
           SubscriptBox["s", "0"], 
           SuperscriptBox[
            RowBox[{"(", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox[
                SubscriptBox["s", "0"], 
                RowBox[{
                 SubscriptBox["s", "0"], "+", 
                 FractionBox[
                  RowBox[{
                   SubscriptBox["k", 
                    RowBox[{"-", "1"}]], "+", 
                   SubscriptBox["k", 
                    RowBox[{"-", "2"}]]}], 
                  SubscriptBox["k", "1"]]}]], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}], " ", 
                "\[Tau]"}]}]], ")"}], 
            FractionBox["1", 
             RowBox[{"1", "-", "\[Alpha]"}]]], " "}], "K"], "]"}]}], 
       SubscriptBox["s", "0"]]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"K", "\[Rule]", 
        FractionBox[
         RowBox[{
          SubscriptBox["k", 
           RowBox[{"-", "1"}]], "+", 
          SubscriptBox["k", 
           RowBox[{"-", "2"}]]}], 
         SubscriptBox["k", "1"]]}], ",", 
       RowBox[{"\[Alpha]", "\[Rule]", 
        FractionBox[
         SubscriptBox["s", "0"], 
         RowBox[{
          SubscriptBox["s", "0"], "+", 
          FractionBox[
           RowBox[{
            SubscriptBox["k", 
             RowBox[{"-", "1"}]], "+", 
            SubscriptBox["k", 
             RowBox[{"-", "2"}]]}], 
           SubscriptBox["k", "1"]]}]]}], ",", 
       RowBox[{"\[Beta]", "->", 
        FractionBox[
         SubscriptBox["k", 
          RowBox[{"-", "1"}]], 
         RowBox[{
          SubscriptBox["k", 
           RowBox[{"-", "1"}]], "+", 
          SubscriptBox["k", 
           RowBox[{"-", "2"}]]}]]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"\[Tau]", "\[Rule]", 
      RowBox[{"t", " ", 
       SubscriptBox["k", "1"], 
       SubscriptBox["e", "0"]}]}], "}"}]}], "/.", "param"}]}]], "Input",
 CellChangeTimes->{{3.7108284391347275`*^9, 3.710828514666125*^9}, {
  3.7108286374944906`*^9, 3.7108286909320946`*^9}, {3.710828769260373*^9, 
  3.710828853776164*^9}, {3.7108289015418816`*^9, 3.710828995792066*^9}, {
  3.7108290477609186`*^9, 3.710829063432823*^9}, {3.710829143120479*^9, 
  3.710829172276786*^9}, {3.7108294527614803`*^9, 
  3.7108294534802322`*^9}},ExpressionUUID->"df503c34-c3be-4e47-878f-\
7edd0e321d1b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"couter", "[", "t_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"souter", "[", "t", "]"}], 
      RowBox[{
       RowBox[{"\[Alpha]", " ", 
        RowBox[{"souter", "[", "t", "]"}]}], "+", "1", "-", "\[Alpha]"}]], "/.", 
     RowBox[{"\[Alpha]", "\[Rule]", 
      FractionBox[
       SubscriptBox["s", "0"], 
       RowBox[{
        SubscriptBox["s", "0"], "+", 
        FractionBox[
         RowBox[{
          SubscriptBox["k", 
           RowBox[{"-", "1"}]], "+", 
          SubscriptBox["k", 
           RowBox[{"-", "2"}]]}], 
         SubscriptBox["k", "1"]]}]]}]}], "/.", "param"}], ")"}]}]], "Input",Ex\
pressionUUID->"fc6175e2-28a1-47d4-93c2-7023c6514fb6"],

Cell[BoxData[
 RowBox[{"approx", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Piecewise", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.1", ",", 
           RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "tfin"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"souter", "[", 
            RowBox[{"t", "-", "tfin"}], "]"}], ",", 
           RowBox[{"tfin", "\[LessEqual]", "t", "\[LessEqual]", 
            RowBox[{"2", "tfin"}]}]}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Piecewise", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "-", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", 
                FractionBox[
                 SubscriptBox["e", "0"], 
                 RowBox[{
                  SubscriptBox["s", "0"], "+", 
                  FractionBox[
                   RowBox[{
                    SubscriptBox["k", 
                    RowBox[{"-", "1"}]], "+", 
                    SubscriptBox["k", 
                    RowBox[{"-", "2"}]]}], 
                   SubscriptBox["k", "1"]]}]]}], " ", "t", " ", 
               SubscriptBox["k", "1"], 
               SubscriptBox["e", "0"]}], "]"}]}], "/.", "param"}], ",", 
           RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "tfin"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"couter", "[", 
            RowBox[{"t", "-", "tfin"}], "]"}], ",", 
           RowBox[{"tfin", "\[LessEqual]", "t", "\[LessEqual]", 
            RowBox[{"2", "tfin"}]}]}], "}"}]}], "}"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "tfin"}]}], "}"}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ",", 
    RowBox[{"PlotRange", "->", "All"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", "tfin"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", "Red", ",", "Blue"}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<t\>\"", ",", "Italic"}], "]"}], ",", 
       RowBox[{"Row", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"#", ",", "Italic"}], "]"}], "&"}], "/@", 
         RowBox[{"{", "\"\<S(t),C(t)\>\"", "}"}]}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7108301727941413`*^9, 3.7108302225598617`*^9}, {
  3.710830435747778*^9, 3.7108304410446644`*^9}, {3.7108305266542063`*^9, 
  3.710830530747966*^9}, {3.7108307946703553`*^9, 3.71083080104537*^9}, {
  3.7108309150612164`*^9, 3.7108309223893566`*^9}, {3.710830996436375*^9, 
  3.71083103763958*^9}, {3.710831489671715*^9, 3.710831614765711*^9}, {
  3.7108316602345486`*^9, 3.710831671906446*^9}, {3.7108317125002756`*^9, 
  3.710831772703518*^9}, {3.7108319054069023`*^9, 3.7108319296569505`*^9}, {
  3.71083199056332*^9, 3.7108320904853897`*^9}, {3.710832120516698*^9, 
  3.7108322587669697`*^9}, {3.7108322924545355`*^9, 3.710832354689031*^9}, {
  3.7128231755552006`*^9, 3.712823263526951*^9}, {3.7128233639986315`*^9, 
  3.7128233695020447`*^9}, {3.7301979487744837`*^9, 
  3.7301979626807623`*^9}},ExpressionUUID->"3764497d-19ba-44a2-8058-\
c26706686dc0"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.1B\>\"", ",", "approx"}], "]"}]], "Input",
 CellChangeTimes->{{3.7108324202516603`*^9, 3.710832425236045*^9}, {
  3.728576481989585*^9, 
  3.7285764881458473`*^9}},ExpressionUUID->"f4dbc531-fc37-49c8-b9cc-\
d0cf9d787445"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 9.2", "Subsubsection",
 CellChangeTimes->{{3.728576595755432*^9, 3.728576596942935*^9}, 
   3.728644225995429*^9},ExpressionUUID->"e15fb3de-2766-4543-a447-\
f3ebe64b3db3"],

Cell[BoxData[
 RowBox[{"square", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "X", "\[DoubleLeftRightArrow]", "Y", "\[DoubleLeftRightArrow]", "Z", 
      "\[DoubleLeftRightArrow]", "U", "\[DoubleLeftRightArrow]", "X"}], "}"}],
     ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "1"], ",", 
       SubscriptBox["k", 
        RowBox[{"-", "1"}]], ",", 
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", 
        RowBox[{"-", "2"}]], ",", 
       SubscriptBox["k", "3"], ",", 
       SubscriptBox["k", 
        RowBox[{"-", "3"}]], ",", 
       SubscriptBox["k", "4"], ",", 
       SubscriptBox["k", 
        RowBox[{"-", "4"}]]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.710392138735772*^9, 3.7103921982631807`*^9}, {
  3.710396091907156*^9, 3.7103960933092356`*^9}, {3.71059013043827*^9, 
  3.7105902341389885`*^9}, {3.728576726896316*^9, 3.7285767283025665`*^9}, {
  3.728576772005777*^9, 
  3.72857683528715*^9}},ExpressionUUID->"0c6dd3ed-d699-4fa7-ae1b-\
6a3539b4037a"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.2\>\"", ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.710396096791439*^9, 3.7103961054949365`*^9}, {
  3.7285766267867446`*^9, 
  3.7285766351305094`*^9}},ExpressionUUID->"69cbbabb-2392-4741-9a39-\
af0c5e42c02a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 9.3", "Subsubsection",
 CellChangeTimes->{{3.728576605239826*^9, 3.728576606208578*^9}, 
   3.728644233479819*^9},ExpressionUUID->"dd61a2dc-817d-44e4-80ff-\
f0e5a72d30e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"trispecies", "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "\"\<Triangle\>\"", "}"}], "]"}], "[", "\"\<species\>\"", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.710929728742194*^9, 3.710929750750456*^9}, 
   3.7306096625294*^9},ExpressionUUID->"266cae3e-c127-4a6a-8319-7b5e3173df07"],

Cell[BoxData[
 RowBox[{"triangleA", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Triangle\>\"", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.52284347092426*^9, 3.522843503669133*^9}, {
   3.541313101338811*^9, 3.5413131391508417`*^9}, {3.710589969649063*^9, 
   3.7105899716991816`*^9}, {3.7109296436113214`*^9, 3.710929783078307*^9}, {
   3.712826592403735*^9, 3.712826627214198*^9}, 
   3.73060966535256*^9},ExpressionUUID->"ef18e903-3bd9-41b7-a67d-\
cea5c9024ea1"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.3A\>\"", ",", "triangleA"}], "]"}]], "Input",
 CellChangeTimes->{{3.7105899791916122`*^9, 3.7105899928273916`*^9}, {
  3.7285769393811045`*^9, 
  3.7285769495061255`*^9}},ExpressionUUID->"3acae987-f72d-4758-bc54-\
acc82fe6697f"],

Cell[BoxData[
 RowBox[{"triangleB", "=", 
  RowBox[{
   RowBox[{"ShowFHJGraph", "[", 
    RowBox[{
     RowBox[{"{", "\"\<Triangle\>\"", "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["k", "1"], ",", 
        SubscriptBox["k", "2"], ",", 
        SubscriptBox["k", "3"]}], "}"}]}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<SpringEmbedding\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
     RowBox[{"StronglyConnectedComponentsColors", "\[Rule]", 
      RowBox[{"{", "Pink", "}"}]}]}], "]"}], "/.", 
   RowBox[{"Thread", "[", 
    RowBox[{"trispecies", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", "18"}], "]"}], "&"}], "/@", "trispecies"}], 
      ")"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7109298199714184`*^9, 3.7109298338772182`*^9}, {
   3.71282669297661*^9, 3.7128267785776787`*^9}, 3.7306096672936707`*^9, 
   3.730731788294201*^9},ExpressionUUID->"561a33f1-61bd-42af-b882-\
35fa7f82a9a9"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.3B\>\"", ",", "triangleB"}], "]"}]], "Input",
 CellChangeTimes->{{3.710590029402485*^9, 3.710590030067524*^9}, {
  3.728576962881151*^9, 
  3.7285769724124165`*^9}},ExpressionUUID->"e771617e-8f60-4f48-bf3d-\
800d455d6175"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 9.4", "Subsubsection",
 CellChangeTimes->{{3.728576910490423*^9, 3.7285769129748025`*^9}, 
   3.728644248792349*^9},ExpressionUUID->"01d04d34-1ca8-4c2a-a4b1-\
534d1ad8a921"],

Cell["\<\
Form the book by Deuflhard and Bornemann who give the reaction rate \
coefficients (pp. 17--18), but no concentrations, still one can reproduce \
theri results quite well.\
\>", "Text",
 CellChangeTimes->{{3.521963709640333*^9, 3.5219637291954517`*^9}, {
  3.7286442712767677`*^9, 
  3.728644333073763*^9}},ExpressionUUID->"6b4ba302-aac6-43c9-b616-\
de46f4206475"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"a", ",", "y", ",", "x", ",", "p"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"oreg", "=", 
  RowBox[{
   RowBox[{"GetReaction", "[", "\"\<Oregonator\>\"", "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"fOregonator", "\[Rule]", "1"}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.521962403173608*^9, 3.521962428328047*^9}, {
   3.521962501019204*^9, 3.5219625115738077`*^9}, 3.728798202902671*^9, {
   3.7307318373724213`*^9, 
   3.73073186234122*^9}},ExpressionUUID->"e9219eba-a1cd-403d-8b88-\
4b9e557a0546"],

Cell[BoxData[
 RowBox[{"or", "=", 
  RowBox[{"oreg", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<A\>\""}], ",", 
     RowBox[{"\"\<Q\>\"", "\[Rule]", "\"\<P\>\""}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.521963019293848*^9, 
  3.5219630535608077`*^9}},ExpressionUUID->"bbcd9e30-042e-4469-8a59-\
16a97cc0dfe4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"cin", "=", 
   RowBox[{"Concentrations", "[", 
    RowBox[{
     RowBox[{"{", "or", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"134", "/", "100"}], ",", 
       RowBox[{"16", " ", 
        SuperscriptBox["10", "8"]}], ",", 
       RowBox[{"8", " ", 
        SuperscriptBox["10", "3"]}], ",", 
       RowBox[{"4", " ", 
        SuperscriptBox["10", "7"]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["10", 
         RowBox[{"-", "1"}]]}], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]], ",", 
       RowBox[{"6", " ", 
        SuperscriptBox["10", 
         RowBox[{"-", "2"}]]}], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "y", ",", "x", ",", "p", ",", "z"}], "}"}]}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.541317588752054*^9, 3.541317611007289*^9}, {
   3.710659244056571*^9, 3.710659246650325*^9}, 3.710767176576582*^9, {
   3.7107674276261024`*^9, 3.7107674367979946`*^9}, 
   3.7107678483300505`*^9},ExpressionUUID->"d8b806ff-4ea8-4ee7-adc1-\
2c82fb74a7b0"],

Cell[BoxData[
 RowBox[{"bzdeuflhardA", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "/.", 
      RowBox[{"Last", "[", "cin", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"\"\<t\>\"", ",", "\"\<ln(x(t))\>\""}], "}"}]}], ")"}]}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "28"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.541317588752054*^9, 3.541317611007289*^9}, {
   3.710659244056571*^9, 3.710659246650325*^9}, 3.710767176576582*^9, {
   3.7107674276261024`*^9, 3.710767455157407*^9}, {3.710767490235599*^9, 
   3.7107675629544926`*^9}, {3.710767706470398*^9, 3.7107677578923745`*^9}, {
   3.710767820517494*^9, 3.7107678577050686`*^9}, {3.710769174837146*^9, 
   3.710769179305904*^9}, {3.710770348433196*^9, 
   3.710770362823844*^9}},ExpressionUUID->"e3686549-5ca7-4182-8d71-\
91c9050cfeff"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.4A\>\"", ",", "bzdeuflhardA"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.710767862580079*^9, 3.7107678775176077`*^9}, {
  3.728577113147069*^9, 3.7285771197720823`*^9}, {3.7285771598659105`*^9, 
  3.7285771604440365`*^9}},ExpressionUUID->"fb660d44-7057-4303-a96d-\
9be646786996"],

Cell[BoxData[
 RowBox[{
  RowBox[{"con", "=", 
   RowBox[{"Concentrations", "[", 
    RowBox[{
     RowBox[{"{", "or", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"134", "/", "100"}], ",", 
       RowBox[{"16", " ", 
        SuperscriptBox["10", "8"]}], ",", 
       RowBox[{"8", " ", 
        SuperscriptBox["10", "3"]}], ",", 
       RowBox[{"4", " ", 
        SuperscriptBox["10", "7"]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["10", 
         RowBox[{"-", "1"}]]}], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]], ",", 
       RowBox[{"6", " ", 
        SuperscriptBox["10", 
         RowBox[{"-", "2"}]]}], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "y", ",", "x", ",", "p", ",", "z"}], "}"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<BDF\>\""}], ",", " ", 
     RowBox[{"WorkingPrecision", "\[Rule]", "32"}], ",", " ", 
     RowBox[{"MaxSteps", "\[Rule]", 
      SuperscriptBox["10", "6"]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.521962783356353*^9, 3.5219629295647154`*^9}, {
  3.5219629700580316`*^9, 3.5219630016998415`*^9}, {3.521963062917343*^9, 
  3.5219631502953405`*^9}, {3.5219631842242813`*^9, 3.521963187611475*^9}, {
  3.521963420380789*^9, 3.521963421646861*^9}, {3.521963498102234*^9, 
  3.5219635034445395`*^9}, {3.5219635724304857`*^9, 3.5219635976179256`*^9}, {
  3.521963675522382*^9, 3.5219636781765337`*^9}, {3.521964011990627*^9, 
  3.521964058215271*^9}, {3.521964088906026*^9, 3.5219641059089985`*^9}, {
  3.5219641558878574`*^9, 3.521964191498894*^9}, {3.7106591219325457`*^9, 
  3.7106591310470657`*^9}, {3.710659233806549*^9, 3.710659234447175*^9}, {
  3.710767938970852*^9, 3.7107679688459125`*^9}, {3.710768099752417*^9, 
  3.710768149346266*^9}},ExpressionUUID->"317c95a3-e698-4c30-9018-\
29391fb45dcf"],

Cell[BoxData[
 RowBox[{"bzdeuflhardB", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "/.", 
      RowBox[{"Last", "[", "con", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"\"\<t\>\"", ",", "\"\<ln(x(t))\>\""}], "}"}]}], ")"}]}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "28"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.521962783356353*^9, 3.5219629295647154`*^9}, {
   3.5219629700580316`*^9, 3.5219630016998415`*^9}, {3.521963062917343*^9, 
   3.5219631502953405`*^9}, {3.5219631842242813`*^9, 3.521963187611475*^9}, {
   3.521963420380789*^9, 3.521963421646861*^9}, {3.521963498102234*^9, 
   3.5219635034445395`*^9}, {3.5219635724304857`*^9, 
   3.5219635976179256`*^9}, {3.521963675522382*^9, 3.5219636781765337`*^9}, {
   3.521964011990627*^9, 3.521964058215271*^9}, {3.521964088906026*^9, 
   3.5219641059089985`*^9}, {3.5219641558878574`*^9, 3.521964191498894*^9}, {
   3.7106591219325457`*^9, 3.7106591310470657`*^9}, {3.710659233806549*^9, 
   3.710659234447175*^9}, {3.710767938970852*^9, 3.7107679736427937`*^9}, {
   3.71076918969655*^9, 3.710769193399682*^9}, 
   3.710770383902012*^9},ExpressionUUID->"dd5db4f6-412f-4d61-a724-\
592f71be6ff5"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.4B\>\"", ",", "bzdeuflhardB"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7107681713463078`*^9, 3.7107681853195853`*^9}, {
  3.7285770996157928`*^9, 
  3.7285771085064354`*^9}},ExpressionUUID->"4f7fafb3-ba64-41ab-9c36-\
b48ff67b1fe5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 9.5", "Subsubsection",
 CellChangeTimes->{{3.7285772864755335`*^9, 3.72857729028804*^9}, 
   3.728644350542549*^9},ExpressionUUID->"726e0960-448b-4d27-a18f-\
dfe61a82c819"],

Cell[BoxData[
 RowBox[{"bzdeuflhardStiff", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", 
       RowBox[{"Last", "[", "con", "]"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "11.6", ",", "12.4"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Red"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Blue"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<t\>\"", ",", "Bold", ",", "12"}], "]"}], ",", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<(\>\"", ",", "Bold", ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<ln(x(t))\>\"", ",", "Red", ",", "Bold", ",", "12"}], 
           "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<, \>\"", ",", "Bold", ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<ln(z(t))\>\"", ",", "Blue", ",", "Bold", ",", "12"}], 
           "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<)\>\"", ",", "Bold", ",", "12"}], "]"}]}], "}"}], 
        "]"}]}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQB2IQbZf+OnmO7StHNSGjMhCdetuxGkRLpZrVg+gHUXfb
QHRe8cmJIDpAl30aiDaZWAymc/R7NoNosc1bwHSDq/NeEL3a8h2Y7jrWewxE
8xzbfBJER20vuAyitZYdBdPmm+v/gvU9dmOeCxL/J8MOolvEbDlBdEhmDT+I
/vjtvTCIzrpu69a69LXjhMZEdxDtcN4yBEQ7+fuBaQvB+IxdQPrIxC05IJrH
8dxeEC1ziP0YiL50aN9pEM1yWOEsiF56mPcSiF52WB5MxxxZeR1EF7h43gCr
c91/B0RfOzH1F4iuO1XHvhtI3/WK5QLRh82cmjiXvXa8YFjXDqJ/PJnUDaL1
6pfPAdGBRpcWguhJiRmLQDQAo67Aug==
  "],ExpressionUUID->"047bf6ba-9eca-4e00-a66f-f1fd17e6fea0"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.5\>\"", ",", "bzdeuflhardStiff"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7107691189776726`*^9, 3.710769124258922*^9}, {
  3.728577304491192*^9, 
  3.7285773149912148`*^9}},ExpressionUUID->"c4cee7e4-0a0f-4dbc-a4e4-\
54523d079407"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 9.6", "Subsubsection",
 CellChangeTimes->{{3.7285774532102337`*^9, 3.728577456397741*^9}, 
   3.7286443646207*^9},ExpressionUUID->"885a47d8-4388-4f43-bbb2-15b39056ccdd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rob", "=", 
   RowBox[{"GetReaction", "[", "\"\<Robertson\>\"", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.706417993115324*^9, 3.7064180091466055`*^9}, {
   3.706418040459166*^9, 3.706418041521668*^9}, 3.728647063318169*^9, 
   3.72879820293392*^9},ExpressionUUID->"2b2bf2f1-8b2e-45d1-a196-\
413410e93295"],

Cell[BoxData[
 RowBox[{
  RowBox[{"conrob", "=", 
   RowBox[{"Concentrations", "[", 
    RowBox[{
     RowBox[{"{", "rob", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.04", ",", " ", 
       RowBox[{"3", " ", 
        SuperscriptBox["10", "7"]}], ",", 
       SuperscriptBox["10", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SuperscriptBox["10", "10"]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.706418026974766*^9, 3.70641811757644*^9}, {
   3.706418157166707*^9, 3.706418164305114*^9}, 
   3.7064991716237016`*^9},ExpressionUUID->"8f594a11-e057-4783-a00b-\
b1785b27275d"],

Cell[BoxData[
 RowBox[{"robertsonexact", "=", 
  RowBox[{"LogLinearPlot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        SuperscriptBox["10", "4"], ",", "1"}], "}"}], 
      RowBox[{"(", 
       RowBox[{"ReplaceAll", "@@", "conrob"}], ")"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]], ",", 
      SuperscriptBox["10", "10"]}], "}"}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<a\>\"", ",", "\"\<\!\(\*SuperscriptBox[\(10\), \(4\)]\) b\>\"", 
       ",", "\"\<c\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<time\>\"", ",", "\"\<comcentrations\>\""}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.706418189490556*^9, 3.706418291781952*^9}, {
  3.706418758998704*^9, 3.7064187669518423`*^9}, {3.7064188094363003`*^9, 
  3.7064188183425674`*^9}, {3.706418853686388*^9, 3.7064189297602234`*^9}, {
  3.7064190212916527`*^9, 3.7064190955105476`*^9}, {3.706499187951858*^9, 
  3.7064991949674983`*^9}, {3.706499358920941*^9, 3.706499361467822*^9}, {
  3.7064997304529185`*^9, 3.7065000048597054`*^9}, {3.7065000401097755`*^9, 
  3.7065000838442354`*^9}, {3.7065019371334023`*^9, 3.706502060383645*^9}, {
  3.706502207212055*^9, 3.7065022483527613`*^9}, {3.7109053116419106`*^9, 
  3.7109053150301046`*^9}, {3.710907784678534*^9, 
  3.7109078046556773`*^9}},ExpressionUUID->"91ca0b2d-0589-4cbc-8bd8-\
a89308edf588"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.6A\>\"", ",", "robertsonexact"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7109079755044613`*^9, 3.710907986584096*^9}, {
  3.728577478429035*^9, 
  3.728577492100935*^9}},ExpressionUUID->"15659a3b-f9e4-4769-8422-\
4e7514c266de"],

Cell[BoxData[
 RowBox[{"dm", "=", 
  RowBox[{"DeterministicModel", "[", 
   RowBox[{
    RowBox[{"{", "rob", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.04", ",", " ", 
      RowBox[{"3", " ", 
       SuperscriptBox["10", "7"]}], ",", 
      SuperscriptBox["10", "4"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7109053790787735`*^9, 3.7109053800408287`*^9}, {
  3.710905410647581*^9, 
  3.710905444838538*^9}},ExpressionUUID->"aaaf0a13-e7ce-4ab6-a640-\
ece62f847b49"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nds", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "0.04`"}], " ", 
          RowBox[{"a", "[", "t", "]"}]}], "+", 
         RowBox[{"10000", " ", 
          RowBox[{"b", "[", "t", "]"}], " ", 
          RowBox[{"c", "[", "t", "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", "t", "]"}], "+", 
         RowBox[{"b", "[", "t", "]"}], "+", 
         RowBox[{"c", "[", "t", "]"}]}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"30000000", " ", 
         SuperscriptBox[
          RowBox[{"b", "[", "t", "]"}], "2"]}]}], ",", 
       RowBox[{
        RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{"c", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "[", "t", "]"}], ",", 
       RowBox[{"b", "[", "t", "]"}], ",", 
       RowBox[{"c", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]], ",", 
       SuperscriptBox["10", "10"]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7109057116038165`*^9, 3.7109057887832355`*^9}, {
   3.7109058409922247`*^9, 3.710905842177294*^9}, {3.710907662355528*^9, 
   3.710907675741295*^9}, 
   3.7109079136769214`*^9},ExpressionUUID->"870154e8-fc5d-4a7b-b2e2-\
6975089606c4"],

Cell[BoxData[
 RowBox[{"robertsonDAE", "=", 
  RowBox[{"LogLinearPlot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         SuperscriptBox["10", "4"], ",", "1"}], "}"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "[", "t", "]"}], ",", 
         RowBox[{"b", "[", "t", "]"}], ",", 
         RowBox[{"c", "[", "t", "]"}]}], "}"}]}], "/.", "nds"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]], ",", 
      SuperscriptBox["10", "10"]}], "}"}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<a\>\"", ",", "\"\<\!\(\*SuperscriptBox[\(10\), \(4\)]\)b\>\"", 
       ",", "\"\<c\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", "12", ",", "Bold"}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"\"\<time\>\"", ",", "\"\<comcentrations\>\""}], "}"}]}], 
      ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", "12"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.706418189490556*^9, 3.706418291781952*^9}, {
  3.706418758998704*^9, 3.7064187669518423`*^9}, {3.7064188094363003`*^9, 
  3.7064188183425674`*^9}, {3.706418853686388*^9, 3.7064189297602234`*^9}, {
  3.7064190212916527`*^9, 3.7064190955105476`*^9}, {3.706499187951858*^9, 
  3.7064991949674983`*^9}, {3.706499358920941*^9, 3.706499361467822*^9}, {
  3.7064997304529185`*^9, 3.7065000048597054`*^9}, {3.7065000401097755`*^9, 
  3.7065000838442354`*^9}, {3.7065019371334023`*^9, 3.706502060383645*^9}, {
  3.706502207212055*^9, 3.7065022483527613`*^9}, {3.7109053116419106`*^9, 
  3.7109053150301046`*^9}, {3.7109053473259563`*^9, 3.7109053549643917`*^9}, {
  3.7109058232282066`*^9, 3.710905848602661*^9}, {3.7109076950754013`*^9, 
  3.7109077151255503`*^9}, {3.7109078166563663`*^9, 
  3.71090789636693*^9}},ExpressionUUID->"22948f73-0049-4ad1-a8bb-\
526581aa9593"],

Cell["Quite similar to the exact figure.", "Text",
 CellChangeTimes->{{3.7109079420525455`*^9, 
  3.7109079563703685`*^9}},ExpressionUUID->"ee93a177-6842-4739-b166-\
a223013ccfb3"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.6B\>\"", ",", "robertsonDAE"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7105903933424263`*^9, 3.7105904059830756`*^9}, {
  3.728577497772823*^9, 
  3.728577506850965*^9}},ExpressionUUID->"ac92e434-46f2-48bf-8576-\
817474afd1a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 9.7", "Subsubsection",
 CellChangeTimes->{{3.7285775642885747`*^9, 3.728577566554205*^9}, 
   3.7286443783863535`*^9},ExpressionUUID->"e48b8529-3045-45b9-ad78-\
ad26183e7d1f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"param", ",", "tfin", ",", "exact"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"param", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "1"], "\[Rule]", " ", "1"}], ",", 
     RowBox[{
      SubscriptBox["k", 
       RowBox[{"-", "1"}]], "\[Rule]", " ", "0.625"}], ",", 
     RowBox[{
      SubscriptBox["k", 
       RowBox[{"-", "2"}]], "\[Rule]", "0.375"}], ",", 
     RowBox[{
      SubscriptBox["e", "0"], "\[Rule]", "0.1"}], ",", 
     RowBox[{
      SubscriptBox["s", "0"], "\[Rule]", "1.0"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"tfin", "=", "12"}], ";", 
  RowBox[{"exact", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"s", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["k", "1"]}], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["e", "0"], "-", 
             RowBox[{"c", "[", "t", "]"}]}], ")"}], 
           RowBox[{"s", "[", "t", "]"}]}], "+", 
          RowBox[{
           SubscriptBox["k", 
            RowBox[{"-", "1"}]], " ", 
           RowBox[{"c", "[", "t", "]"}]}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"c", "'"}], "[", "t", "]"}], "==", 
         RowBox[{
          RowBox[{
           SubscriptBox["k", "1"], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["e", "0"], "-", 
             RowBox[{"c", "[", "t", "]"}]}], ")"}], 
           RowBox[{"s", "[", "t", "]"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["k", 
              RowBox[{"-", "1"}]], "+", 
             SubscriptBox["k", 
              RowBox[{"-", "2"}]]}], ")"}], " ", 
           RowBox[{"c", "[", "t", "]"}]}]}]}], ",", 
        RowBox[{
         RowBox[{"s", "[", "0", "]"}], "\[Equal]", 
         SubscriptBox["s", "0"]}], ",", 
        RowBox[{
         RowBox[{"c", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], "/.", 
      "param"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tfin"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dae", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"s", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["k", "1"]}], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["e", "0"], "-", 
             RowBox[{"c", "[", "t", "]"}]}], ")"}], 
           RowBox[{"s", "[", "t", "]"}]}], "+", 
          RowBox[{
           SubscriptBox["k", 
            RowBox[{"-", "1"}]], " ", 
           RowBox[{"c", "[", "t", "]"}]}]}]}], ",", 
        RowBox[{"0", "==", 
         RowBox[{
          RowBox[{
           SubscriptBox["k", "1"], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["e", "0"], "-", 
             RowBox[{"c", "[", "t", "]"}]}], ")"}], 
           RowBox[{"s", "[", "t", "]"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["k", 
              RowBox[{"-", "1"}]], "+", 
             SubscriptBox["k", 
              RowBox[{"-", "2"}]]}], ")"}], " ", 
           RowBox[{"c", "[", "t", "]"}]}]}]}], ",", 
        RowBox[{
         RowBox[{"s", "[", "0", "]"}], "\[Equal]", 
         SubscriptBox["s", "0"]}]}], "}"}], "/.", "param"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tfin"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7108269631787176`*^9, 3.7108269749287395`*^9}, 
   3.7286470972401104`*^9},ExpressionUUID->"5fe5d309-4fdf-4528-a0df-\
6b250e137431"],

Cell[BoxData[
 RowBox[{"michaelisDAE", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "[", "t", "]"}], "/.", "exact"}], ",", 
       RowBox[{
        RowBox[{"s", "[", "t", "]"}], "/.", "dae"}]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tfin"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"\"\<t\>\"", ",", "\"\<s(t)\>\""}], "}"}]}], ")"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7108257642771173`*^9, 3.71082577992144*^9}, 
   3.710825833614008*^9, {3.710826685225048*^9, 
   3.7108268610847664`*^9}},ExpressionUUID->"a2ff8867-e495-42ff-a7f2-\
ce3e8d77b319"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.7\>\"", ",", "michaelisDAE"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7108268793816833`*^9, 3.7108268849441895`*^9}, {
  3.728577589932335*^9, 
  3.7285776049951973`*^9}},ExpressionUUID->"46770fb7-03d2-4626-a69b-\
3fc1f9121f1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 9.8", "Subsubsection",
 CellChangeTimes->{{3.7285776662977066`*^9, 3.728577668313822*^9}, 
   3.7286444205583096`*^9},ExpressionUUID->"1142e1f9-ab16-401b-9f3f-\
d34546389cec"],

Cell[BoxData[
 RowBox[{"revtri", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ToReversible", "[", "\"\<Triangle\>\"", "]"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "16", ",", "Bold"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "10", ",", "6", ",", "4", ",", "10"}], 
      "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.700809807217392*^9, {3.7008098505768523`*^9, 3.700809876483153*^9}, {
   3.710590563249009*^9, 3.710590563608384*^9}, 
   3.7306096683967366`*^9},ExpressionUUID->"5ee36278-a3a5-4267-97f1-\
515d07dcf191"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig9.8\>\"", ",", "revtri"}], "]"}]], "Input",
 CellChangeTimes->{{3.700809712389081*^9, 3.700809813889281*^9}, {
  3.700809891858183*^9, 3.7008098959831915`*^9}, {3.7285776866368713`*^9, 
  3.7285777033278275`*^9}},ExpressionUUID->"54be22fc-dac9-47c0-af17-\
882bec7cb34d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 3.709723882195959*^9}, 
   3.7143678836476707`*^9, 
   3.7292285803631997`*^9},ExpressionUUID->"feaad711-c9f1-4b8b-aea2-\
6630fddc1c93"],

Cell[CellGroupData[{

Cell["Example 9.2", "Subsubsection",
 CellChangeTimes->{{3.712808521913056*^9, 3.7128085267832484`*^9}, 
   3.7143678836486692`*^9, {3.7143679956670933`*^9, 3.714368010338998*^9}, 
   3.7292285803631997`*^9, {3.7292286173945217`*^9, 
   3.729228620425778*^9}},ExpressionUUID->"1f624a41-f892-43fd-ad8e-\
2c34bf77200c"],

Cell[BoxData[
 RowBox[{"First", "@", 
  RowBox[{"VolpertIndexing", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Robertson\>\"", "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.712808512874771*^9, 3.7128085505119715`*^9}, 
   3.7143678836496706`*^9, {3.7143679956670933`*^9, 3.714368010338998*^9}, 
   3.7292285803631997`*^9, {3.7307320054039993`*^9, 
   3.730732018685276*^9}},ExpressionUUID->"54dfb051-3d19-4744-98c6-\
60f0afe34135"],

Cell[BoxData[
 RowBox[{"First", "@", 
  RowBox[{"VolpertIndexing", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<E\>\"", ",", "\"\<S\>\""}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.712808512874771*^9, 3.712808634762308*^9}, 
   3.7143678836496706`*^9, {3.7143679956670933`*^9, 3.714368010338998*^9}, 
   3.7292285803631997`*^9},ExpressionUUID->"00a85358-d999-4fef-81bd-\
70c6b7695d9b"],

Cell[BoxData[
 RowBox[{"VolpertIndexing", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<E\>\"", ",", "\"\<S\>\""}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712808512874771*^9, 3.712808646767982*^9}, 
   3.714367883650671*^9, {3.7143679956670933`*^9, 3.714368010338998*^9}, 
   3.7292285803631997`*^9},ExpressionUUID->"4dea4989-8f97-4e32-8d4b-\
29a9553df92e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.5", "Subsubsection",
 CellChangeTimes->{{3.7292288034730124`*^9, 
  3.729228809394898*^9}},ExpressionUUID->"2456b37b-9a58-4b95-b7ad-\
5c4e5583d3f9"],

Cell[BoxData[
 RowBox[{"VolpertIndexing", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<A\>\"", "\[Rule]", 
     RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<C\>\""}]}], "}"}], ",", " ", 
   RowBox[{"{", "\"\<A\>\"", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712808512874771*^9, 3.712808646767982*^9}, 
   3.714367883650671*^9, {3.7143679956670933`*^9, 3.714368010338998*^9}, 
   3.7292285803631997`*^9, {3.7292287981136255`*^9, 
   3.729228853082485*^9}},ExpressionUUID->"cf00e8b1-3170-432a-9c94-\
96896f01af2b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Page 213.", "Subsubsection",
 CellChangeTimes->{{3.730446313903861*^9, 
  3.7304463203569984`*^9}},ExpressionUUID->"13d3d45c-0d30-4abe-b03d-\
aec8d3561684"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["e", "0"], ",", 
     SubscriptBox["s", "0"], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "s", ",", "c", ",", "p"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730446324294506*^9, 3.7304463383971696`*^9}, {
  3.7307322613263755`*^9, 
  3.730732269076391*^9}},ExpressionUUID->"3270722f-f555-4077-bc4e-\
87ea91fde2e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.23", "Subsubsection",
 CellChangeTimes->{{3.7292292913489656`*^9, 
  3.7292292967708516`*^9}},ExpressionUUID->"b135897a-b759-4f96-b8ee-\
c97c1cadbc33"],

Cell[BoxData[
 RowBox[{
  RowBox[{"quad", "=", 
   RowBox[{"{", 
    RowBox[{
    "X", "\[DoubleLeftRightArrow]", "Y", "\[DoubleLeftRightArrow]", "Z", 
     "\[DoubleLeftRightArrow]", "U", "\[DoubleLeftRightArrow]", "X"}], 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7103911494681225`*^9, 3.710391194305687*^9}, {
   3.710391264955735*^9, 3.710391267095859*^9}, 3.7143678836516695`*^9, {
   3.7143679956670933`*^9, 3.714368010338998*^9}, 
   3.7292285803631997`*^9},ExpressionUUID->"ff40148f-4ed2-4986-97ce-\
73d067233c8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"M", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.710391385313628*^9, 3.710391426331975*^9}, 
   3.7143678836536713`*^9, {3.7143679956670933`*^9, 3.714368010338998*^9}, 
   3.7292285803631997`*^9},ExpressionUUID->"3f25fb7f-7fc0-4550-ad04-\
6d59becaf5fc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"K", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["k", 
          RowBox[{"-", "4"}]]}], "-", 
        SubscriptBox["k", "1"]}], ",", 
       SubscriptBox["k", "1"], ",", "0", ",", 
       SubscriptBox["k", 
        RowBox[{"-", "4"}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", 
        RowBox[{"-", "1"}]], ",", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["k", 
          RowBox[{"-", "1"}]]}], "-", 
        SubscriptBox["k", "2"]}], ",", 
       SubscriptBox["k", "2"], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SubscriptBox["k", 
        RowBox[{"-", "2"}]], ",", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["k", 
          RowBox[{"-", "2"}]]}], "-", 
        SubscriptBox["k", "3"]}], ",", 
       SubscriptBox["k", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "4"], ",", "0", ",", 
       SubscriptBox["k", 
        RowBox[{"-", "3"}]], ",", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["k", 
          RowBox[{"-", "3"}]]}], "-", 
        SubscriptBox["k", "4"]}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7103922939526644`*^9, 3.710392301328085*^9}, {
   3.7103923434144936`*^9, 3.710392382207715*^9}, 3.710392446039373*^9, 
   3.7143678836586704`*^9, {3.7143679956670933`*^9, 3.714368010354622*^9}, 
   3.7292285803631997`*^9},ExpressionUUID->"6c016f92-d1d6-4764-9151-\
9cdfb398aa89"],

Cell[BoxData[
 RowBox[{
  RowBox[{"M", ".", "K"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.730198343994007*^9, 
  3.730198351806523*^9}},ExpressionUUID->"82ce8e51-3322-41f5-b892-\
cb1e408cb5b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Khat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "d"}], "-", "g"}], ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", 
       RowBox[{
        RowBox[{"-", "b"}], "-", "h"}], ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", 
       RowBox[{
        RowBox[{"-", "c"}], "-", "f"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.729239341756732*^9, 
  3.729239355116133*^9}},ExpressionUUID->"4771353c-e6c5-42aa-ac74-\
ca8b4568f681"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Khat", ".", "M"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.730198343994007*^9, 
  3.7301983685565553`*^9}},ExpressionUUID->"10daf517-ba58-4a2f-bc57-\
2c792c64d214"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"M", ".", "K"}], "\[Equal]", 
      RowBox[{"Khat", ".", "M"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d", ",", "g", ",", "h", ",", "f"}], 
      "}"}]}], "]"}], "/.", 
   RowBox[{"And", "\[Rule]", "List"}]}], "//", "Column"}]], "Input",
 CellChangeTimes->{{3.7112006336299877`*^9, 3.7112007027969513`*^9}, 
   3.71436788366167*^9, {3.7143679956670933`*^9, 3.714368010354622*^9}, 
   3.7292285803788266`*^9, {3.729239373663045*^9, 3.729239377038052*^9}, {
   3.7301984152285223`*^9, 
   3.730198433369182*^9}},ExpressionUUID->"5dc31ef3-7b9d-4566-a996-\
e91c6e1698ef"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"M", ".", "K"}], "\[Equal]", 
      RowBox[{"Khat", ".", "M"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d", ",", "g", ",", "h", ",", "f", ",", 
       SubscriptBox["k", "1"], ",", 
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", "3"], ",", 
       SubscriptBox["k", "4"], ",", 
       SubscriptBox["k", 
        RowBox[{"-", "1"}]], ",", 
       SubscriptBox["k", 
        RowBox[{"-", "2"}]], ",", 
       SubscriptBox["k", 
        RowBox[{"-", "3"}]], ",", 
       SubscriptBox["k", 
        RowBox[{"-", "4"}]]}], "}"}]}], "]"}], "//", "Flatten"}], "//", 
  "Column"}]], "Input",
 CellChangeTimes->{{3.7301989272295227`*^9, 
  3.730198985854636*^9}},ExpressionUUID->"b8fbf1a7-4cae-47b5-a0ec-\
d8936761351f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"List", "@@", "%"}], "/.", 
  RowBox[{"Equal", "\[Rule]", "Rule"}]}]], "Input",
 CellChangeTimes->{{3.7292393959755883`*^9, 
  3.729239412678747*^9}},ExpressionUUID->"37c9d59c-0955-4991-9b73-\
10662a381244"],

Cell[BoxData[
 RowBox[{"Khat", "/.", "%"}]], "Input",
 CellChangeTimes->{{3.7292394434131804`*^9, 
  3.7292394499444437`*^9}},ExpressionUUID->"c56c1bf5-5fd5-4145-a915-\
39b806c367f4"],

Cell[BoxData[
 RowBox[{"K", "/.", "%%"}]], "Input",
 CellChangeTimes->{{3.7292394583507104`*^9, 
  3.729239462194468*^9}},ExpressionUUID->"934de54f-e207-401e-ab5d-\
04cecac29f0b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.36", "Subsubsection",
 CellChangeTimes->{{3.7304567410527773`*^9, 
  3.7304567522559233`*^9}},ExpressionUUID->"7e21b1a7-9c68-4769-8407-\
c6667bd1c8a4"],

Cell[BoxData[
 RowBox[{"Plus", "@@", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Ivanova\>\"", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730456762193446*^9, 
  3.7304568420217237`*^9}},ExpressionUUID->"5fdc598e-becf-4ffb-b004-\
e9cc64e912df"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Y", ",", "Z"}], "]"}], ";", 
  RowBox[{"rh", "=", 
   RowBox[{"RightHandSide", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"X", "\[Rule]", 
        RowBox[{"2", "X"}]}], ",", 
       RowBox[{"Y", "\[Rule]", 
        RowBox[{"X", "+", 
         RowBox[{"2", "Y"}]}]}], ",", 
       RowBox[{"X", "\[Rule]", 
        RowBox[{"X", "+", 
         RowBox[{"2", "Z"}]}]}], ",", 
       RowBox[{"Z", "\[Rule]", 
        RowBox[{"Y", "+", "Z"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7304568694749026`*^9, 3.7304569786001167`*^9}, {
  3.7304570459596233`*^9, 
  3.7304570576315227`*^9}},ExpressionUUID->"33373288-0840-4b03-8570-\
5aa0b185a7e7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"rh", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"rh", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"rh", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"rh", "[", 
     RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}]], "Input",ExpressionUUID->\
"1d1d1045-9dbd-4763-a3cc-7bb98ca0ba2c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"rh", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", 
     RowBox[{"rh", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"rh", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", 
     RowBox[{"rh", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"z", "\[Rule]", 
     RowBox[{"x", "-", "\[Eta]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"x", "-", "\[Xi]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.730456981834499*^9, 3.730457018147069*^9}, {
  3.7304570836003222`*^9, 3.730457138100429*^9}, {3.730457171975494*^9, 
  3.730457192819285*^9}},ExpressionUUID->"cc26103f-0e81-4d6a-af1c-\
35eb161f351b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["P. 227-228", "Subsubsection",
 CellChangeTimes->{{3.730458037433305*^9, 
  3.7304580514901114`*^9}},ExpressionUUID->"f10ec9b2-eb72-45ac-a06c-\
e5c3371bf17c"],

Cell[BoxData[
 RowBox[{"ShowFHJGraph", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Triangle\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "3"]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.73045802720372*^9, 
  3.7306096694947987`*^9},ExpressionUUID->"196ca35f-e326-498a-81fc-\
5b50f5ba3b73"],

Cell[BoxData[
 RowBox[{"ShowFHJGraph", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Triangle\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "3"]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "All"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"StronglyConnectedComponentsColors", "\[Rule]", 
    RowBox[{"{", "Pink", "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7292399232400384`*^9, 3.7292400115527115`*^9}, {
   3.7292400417871456`*^9, 3.7292400777403417`*^9}, 3.7301990671618423`*^9, 
   3.7306096705228586`*^9},ExpressionUUID->"e490c3cb-a299-4909-af0a-\
f8188ef352fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.6.1 Numerical and symbolic linear algebra", "Subsubsection",
 CellChangeTimes->{{3.712838272569831*^9, 3.7128382875046244`*^9}, 
   3.7143678836786714`*^9, 3.7292285803788266`*^9, {3.729240113256035*^9, 
   3.7292401151154137`*^9}},ExpressionUUID->"4988d3e3-7241-40bc-a3f6-\
3272951b4328"],

Cell[BoxData[
 RowBox[{"rhs", "=", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", "\[Rule]", 
      RowBox[{
       RowBox[{
       "X1", "\[DoubleLeftRightArrow]", "X2", "\[DoubleLeftRightArrow]", "X3",
         "\[DoubleLeftRightArrow]", "X4", "\[DoubleLeftRightArrow]", "X5", 
        "\[DoubleLeftRightArrow]", "X6", "\[DoubleLeftRightArrow]", "X7", 
        "\[DoubleLeftRightArrow]", "X8"}], "\[Rule]", "0"}]}], "}"}], ",", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["k", "0"], "}"}], ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            SubscriptBox["k", "#"], "&"}], "/@", 
           RowBox[{"Range", "[", "7", "]"}]}], ",", 
          RowBox[{
           RowBox[{
            SubscriptBox["k", "#"], "&"}], "/@", 
           RowBox[{"-", 
            RowBox[{"Range", "[", "7", "]"}]}]}]}], "}"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       SubscriptBox["k", "8"], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "#"], "&"}], "/@", 
     RowBox[{"Range", "[", "8", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.7128389189440613`*^9, {3.712839327876485*^9, 3.7128393598917336`*^9}, 
   3.7128394921770725`*^9, 3.7143678836816707`*^9, 3.714367923321268*^9, 
   3.7292285803788266`*^9, 3.729240164849886*^9, {3.7292402190218673`*^9, 
   3.7292402655688324`*^9}},ExpressionUUID->"15a132a2-a86c-4d5c-89f9-\
9c3895209015"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rhs", "/.", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "i_"], "\[Rule]", 
     RowBox[{
      SubscriptBox["k", "0"], 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Product", "[", 
          RowBox[{
           SubscriptBox["k", "l"], ",", 
           RowBox[{"{", 
            RowBox[{"l", ",", 
             RowBox[{"10", "-", "j"}], ",", "8"}], "}"}]}], "]"}], 
         RowBox[{
          RowBox[{"Product", "[", 
           RowBox[{
            SubscriptBox["k", 
             RowBox[{"-", "l"}]], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "i", ",", 
              RowBox[{"8", "-", "j"}]}], "}"}]}], "]"}], "/", 
          RowBox[{"Product", "[", 
           RowBox[{
            SubscriptBox["k", "l"], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "i", ",", "8"}], "}"}]}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", 
          RowBox[{"9", "-", "i"}]}], "}"}]}], "]"}]}]}], "}"}]}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.712838501853195*^9, 3.7128385039355907`*^9}, {
   3.7128386100133753`*^9, 3.712838890926174*^9}, 3.7128393938013477`*^9, 
   3.714367883683671*^9, 3.714367923321268*^9, 3.7292285803788266`*^9, {
   3.7292402986001472`*^9, 
   3.729240346834617*^9}},ExpressionUUID->"6ef7ed33-920a-4ee0-bb34-\
6d3ebb59860a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.42", "Subsubsection",
 CellChangeTimes->{{3.7304575323668237`*^9, 
  3.7304575413512163`*^9}},ExpressionUUID->"06a6ef47-19d5-4012-b13c-\
cb750c84899f"],

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"orig", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "x"}], "+", 
        RowBox[{"3", "y"}], "+", 
        RowBox[{"3", "z"}]}], "==", "2"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"3", " ", "x"}], "+", "y", "+", "z"}], "==", "4"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "x"}], "-", 
        RowBox[{"2", "y"}], "+", 
        RowBox[{"3", "z"}]}], "==", "10"}]}], "}"}]}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304573545852284`*^9, 
  3.7304574324603777`*^9}},ExpressionUUID->"bd20c908-7d58-4c17-b41f-\
2b2f3feb1ff3"],

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"trafo", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "x"}], "+", 
        RowBox[{"3", "y"}], "+", 
        RowBox[{"3", "z"}]}], "==", "2"}], ",", 
      RowBox[{
       RowBox[{"y", "+", "z"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{"5", "z"}], "==", "10"}]}], "}"}]}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304573545852284`*^9, 3.7304574324603777`*^9}, {
  3.730457462522938*^9, 
  3.7304574886011133`*^9}},ExpressionUUID->"ac9e9653-b50b-4f8a-88cf-\
cac85f8c6751"],

Cell[BoxData[
 RowBox[{"Solve", "[", "orig", "]"}]], "Input",
 CellChangeTimes->{{3.7304574960386286`*^9, 
  3.730457500757387*^9}},ExpressionUUID->"84c46906-e408-4938-9c0d-\
d52cf3673fb3"],

Cell[BoxData[
 RowBox[{"Solve", "[", "trafo", "]"}]], "Input",
 CellChangeTimes->{{3.7304574960386286`*^9, 
  3.7304575096792803`*^9}},ExpressionUUID->"4eedec35-1c78-4296-b640-\
8c463a4e5d90"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.43", "Subsubsection",
 CellChangeTimes->{{3.7304575323668237`*^9, 3.730457566898143*^9}, 
   3.7304578506876116`*^9},ExpressionUUID->"2670de50-8c63-44c1-ab6e-\
2261d4574b79"],

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"x", " ", "y"}]}], ",", 
     RowBox[{"x", "-", 
      SuperscriptBox["y", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304575682106485`*^9, 
  3.7304576029450865`*^9}},ExpressionUUID->"20702e06-5d82-458d-8ce7-\
574edf24396a"],

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"x", " ", "y"}]}], ",", 
     RowBox[{"x", "-", 
      SuperscriptBox["y", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304575682106485`*^9, 
  3.7304576150857353`*^9}},ExpressionUUID->"8846e811-c058-4f61-9248-\
3473626722a3"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"x", " ", "y"}]}], "\[Equal]", "0"}], ",", 
    RowBox[{
     RowBox[{"x", "-", 
      SuperscriptBox["y", "2"]}], "\[Equal]", "0"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.730457665648337*^9, 
  3.7304576995390253`*^9}},ExpressionUUID->"43446ec7-71e9-4e58-af57-\
34640f9c5a8e"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "-", 
       RowBox[{"x", " ", "y"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "-", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304576868983765`*^9, 
  3.730457694007765*^9}},ExpressionUUID->"98201ea1-73f0-4143-8b29-\
dd27ac263add"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Eliminate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "-", 
         RowBox[{"x", " ", "y"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"x", "-", 
         SuperscriptBox["y", "2"]}], "\[Equal]", "0"}]}], "}"}], ",", "x"}], 
    "]"}], ",", "y"}], "]"}]], "Input",
 CellChangeTimes->{{3.714367883693673*^9, 3.7143679082274895`*^9}, 
   3.714367965010784*^9, 3.714368010354622*^9, 3.7292285803788266`*^9, {
   3.7292414655555544`*^9, 3.7292414829149637`*^9}},
 NumberMarks->False,ExpressionUUID->"091d73ff-8370-4ff7-99e3-4b149b53f464"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Eliminate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "-", 
         RowBox[{"x", " ", "y"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"x", "-", 
         SuperscriptBox["y", "2"]}], "\[Equal]", "0"}]}], "}"}], ",", "y"}], 
    "]"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.714367883693673*^9, 3.7143679082274895`*^9}, 
   3.714367965010784*^9, 3.714368010354622*^9, 3.7292285803788266`*^9, {
   3.7292414655555544`*^9, 3.7292415007431235`*^9}},
 NumberMarks->False,ExpressionUUID->"31ebb274-0d64-4e3a-a1d5-ca577357d6d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.6.4.1 Black box use", "Subsubsection",
 CellChangeTimes->{{3.7292415638369985`*^9, 
  3.7292415778213997`*^9}},ExpressionUUID->"c0a1a2b1-cd2a-4d15-9fff-\
9d84a8411245"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"ClearAll", "[", 
    RowBox[{"A", ",", "B", ",", "a", ",", "b"}], "]"}], ";", 
   RowBox[{
    RowBox[{"Concentrations", "[", 
     RowBox[{
      RowBox[{"{", "\"\<Triangle\>\"", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["k", "1"], ",", 
        SubscriptBox["k", "2"], ",", 
        SubscriptBox["k", "3"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a0", ",", "b0", ",", "c0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], "//", 
    "Simplify"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.7292415816807814`*^9, 3.729241648868416*^9}, {
   3.729241679039897*^9, 3.7292417518790708`*^9}, 3.729241803857046*^9, 
   3.730199096325512*^9, {3.730460702440235*^9, 3.7304607100808725`*^9}, 
   3.7306096716059213`*^9, {3.730732815697322*^9, 
   3.7307328226817207`*^9}},ExpressionUUID->"8dd8865f-9a03-48ae-84c5-\
f7b5582369a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.6.4.2 Use of built-in options of Mathematica", "Subsubsection",
 CellChangeTimes->{{3.7292415638369985`*^9, 3.7292415778213997`*^9}, {
  3.7292418148416758`*^9, 
  3.729241836470914*^9}},ExpressionUUID->"0c4a579a-80a4-4c7d-8719-\
d0fac793f436"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"cin", "=", 
   RowBox[{"Concentrations", "[", 
    RowBox[{
     RowBox[{"or", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"\"\<A\>\"", "+", "\"\<Y\>\""}], "\[Rule]", "\"\<X\>\""}], 
        ",", 
        RowBox[{
         RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", "\"\<P\>\""}], 
        ",", 
        RowBox[{
         RowBox[{"\"\<A\>\"", "+", "\"\<X\>\""}], "\[Rule]", 
         RowBox[{
          RowBox[{"2", "\"\<X\>\""}], "+", "\"\<Z\>\""}]}], ",", 
        RowBox[{
         RowBox[{"2", "\"\<X\>\""}], "\[Rule]", "\"\<P\>\""}], ",", 
        RowBox[{"\"\<Z\>\"", "\[Rule]", "\"\<Y\>\""}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"134", "/", "100"}], ",", 
       RowBox[{"16", "*", 
        SuperscriptBox["10", "8"]}], ",", 
       RowBox[{"8", "*", 
        SuperscriptBox["10", "3"]}], ",", 
       RowBox[{"4", "*", 
        SuperscriptBox["10", "7"]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"5", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "1"}]]}], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]], ",", 
       RowBox[{"6", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "2"}]]}], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "y", ",", "x", ",", "p", ",", "z"}], "}"}]}], "]"}]}],
   ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "/.", 
     RowBox[{"Last", "[", "cin", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", "\"\<x(t)\>\""}], "}"}]}], ")"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.729241850224701*^9, 3.7292418502287016`*^9}, {
  3.729241898967494*^9, 
  3.7292419566723804`*^9}},ExpressionUUID->"dd24ff23-b833-45b5-8f24-\
c71cfd6060e0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"con", "=", 
   RowBox[{"Concentrations", "[", 
    RowBox[{"or", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"134", "/", "100"}], ",", 
       RowBox[{"16", "*", 
        SuperscriptBox["10", "8"]}], ",", 
       RowBox[{"8", "*", 
        SuperscriptBox["10", "3"]}], ",", 
       RowBox[{"4", "*", 
        SuperscriptBox["10", "7"]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"5", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "1"}]]}], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]], ",", 
       RowBox[{"6", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "2"}]]}], ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "}"}], ",", "\n", 
     RowBox[{"{", 
      RowBox[{"0", ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "y", ",", "x", ",", "p", ",", "z"}], "}"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<BDF\>\""}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "32"}], ",", 
     RowBox[{"MaxSteps", "\[Rule]", 
      SuperscriptBox["10", "6"]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "/.", 
     RowBox[{"Last", "[", "con", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", "\"\<x(t)\>\""}], "}"}]}], ")"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.729241864019491*^9, 3.7292418762941947`*^9}, {
  3.729242003688096*^9, 
  3.72924202506314*^9}},ExpressionUUID->"51e7c6ad-172f-4115-af9b-\
ddc8e03fff2b"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Stochastic", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 3.7096139310971584`*^9}, {
  3.7097241728756065`*^9, 3.7097241786889396`*^9}, {3.7098075036477795`*^9, 
  3.709807507257162*^9}, {3.712893291395601*^9, 
  3.712893297531554*^9}},ExpressionUUID->"0239921e-cf04-49d9-98d7-\
1fb15f1b5da9"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"bbd20199-d969-41c5-9694-\
0258d31e34dd"],

Cell[CellGroupData[{

Cell["Fig. 10.1", "Subsubsection",
 CellChangeTimes->{{3.7285813147806683`*^9, 3.7285813170306726`*^9}, 
   3.72864448540805*^9},ExpressionUUID->"047247d2-708d-4c54-a7ca-\
477b2161394a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"wrstatespace", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ContourPlot3D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", " ", "+", " ", 
            RowBox[{"y", "/", "2"}], " ", "+", " ", 
            RowBox[{"z", "/", "4"}]}], " ", "\[Equal]", 
           RowBox[{"#", "/", "4"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"n", "/", "4"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"y", ",", "0", ",", 
            RowBox[{"n", "/", "2"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"z", ",", "0", ",", "n"}], "}"}], ",", 
          RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
          RowBox[{"ContourStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Orange", ",", 
             RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
             RowBox[{"Specularity", "[", 
              RowBox[{"White", ",", "10"}], "]"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Axes", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"#", ",", "Bold", ",", "16"}], "]"}], "&"}], "/@", 
             RowBox[{"{", 
              RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], 
              "}"}]}], ")"}]}], ",", 
          RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
          RowBox[{"Ticks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Range", "[", 
              RowBox[{"0", ",", 
               RowBox[{"n", "/", "4"}]}], "]"}], ",", 
             RowBox[{"Range", "[", 
              RowBox[{"n", "/", "2"}], "]"}], ",", 
             RowBox[{"Range", "[", "n", "]"}]}], "}"}]}], ",", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Bold", ",", " ", "14"}], "]"}]}]}], "]"}], 
        ",", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"RGBColor", "[", 
              RowBox[{
               RowBox[{"#", "/", "n"}], ",", "1", ",", 
               RowBox[{"#", "/", "n"}]}], "]"}], ",", 
             RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
             RowBox[{"Point", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}], " ", "/.", 
            " ", 
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"x", " ", "+", " ", 
                  RowBox[{"y", "/", "2"}], " ", "+", " ", 
                  RowBox[{"z", "/", "4"}]}], " ", "\[Equal]", 
                 RowBox[{"#", "/", "4"}]}], ",", " ", 
                RowBox[{"x", " ", "\[Element]", " ", "Integers"}], ",", " ", 
                RowBox[{"y", " ", "\[Element]", " ", "Integers"}], ",", " ", 
                RowBox[{"z", " ", "\[Element]", " ", "Integers"}], ",", " ", 
                RowBox[{"x", " ", ">=", " ", "0"}], ",", " ", 
                RowBox[{"y", " ", ">=", " ", "0"}], ",", " ", 
                RowBox[{"z", " ", ">=", " ", "0"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}]}], "]"}]}], 
           ")"}]}], "]"}]}], "}"}], "&"}], "/@", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "n"}], "]"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBGIQveDACUbJta8db7feZwLRb3uu8oPoxDgfDRDtmpRm
DqID9JzsQLTZJ2kPEM0TyhUIovM4J4WBaCGWuA4Q3dNl8AlEr55s9xlsnvQK
BikgfWjPNyYQfV/0PhuIPmfmyQui1UWWCoFo54VKoiD65L40ORD9aEWFEoi+
F2RtCNZ/aKYFiG4tybUF0X8Wbw0E0XxLmaJAdBVfQBqILtnmnAWiC4p9wfSz
lpByEH1r7ex2EO0i/rEHRAv9ON8Ldkf/78kgehN7+WoQLfA8YAOITsvz3QZ2
R6L5LhB93ucrmDZecvsgiE6yPHIWRB9bGH0ZRKssjwfTW9zEb4Ld05UEpjlV
G++B3Tlrx1MQXV48Q0AaFE6ftQVBdE5ZM6sakK79ZsAGogH2YsCW
  "],ExpressionUUID->"ccd2a4c6-56c7-44b1-8589-1371fecc232c"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig10.1\>\"", ",", "wrstatespace"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.714635918123489*^9, 3.714635932842268*^9}, {
  3.7285813445932274`*^9, 
  3.728581356546376*^9}},ExpressionUUID->"f71a76d0-440b-4b10-a786-\
fbe932b9be9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 10.2", "Subsubsection",
 CellChangeTimes->{{3.728581463905961*^9, 3.728581466046589*^9}, 
   3.7286444943768167`*^9},ExpressionUUID->"c43aa409-0362-45b4-9b06-\
0eaf733f0b48"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"size", "=", "0.065"}], ";"}], "\n", 
 RowBox[{"lotkavolterrastatespace", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "0"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "2"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], ",", "size"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "3"}], "}"}], ",", "size"}], "]"}], ",", "Black", 
      ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<X\>\"", ",", "16"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.2", ",", 
          RowBox[{"-", "0.15"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Y\>\"", ",", "16"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.15"}], ",", "3.2"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<(0,0)\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.16"}], ",", 
          RowBox[{"-", "0.16"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2.1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.9", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "1.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1.1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1.9", ",", "2.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.1", ",", "2.9"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1.1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.9", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2.1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.9", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "2.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2.1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1.1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0.1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.9", ",", "1.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.1", ",", "1.9"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1.1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.9", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<(1,1)\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.25", ",", "0.85"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<. . .\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.3", ",", "0.05"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<. . .\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.3", ",", "1.05"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<. . .\>\"", ",", "14"}], "]"}], ",", "14"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"3.3", ",", "2.05"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<. . .\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.3", ",", "3.05"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.05", ",", "3.3"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.05", ",", "3.37"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.05", ",", "3.44"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.05", ",", "3.3"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.05", ",", "3.37"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.05", ",", "3.44"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.05", ",", "3.3"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.05", ",", "3.37"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.05", ",", "3.44"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.05", ",", "3.3"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.05", ",", "3.37"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<.\>\"", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.05", ",", "3.44"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<(x,y)\>\"", ",", "Italic", ",", "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.75", ",", "1.9"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)x\>\"", ",", "Italic", ",", 
          "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.5", ",", "2.15"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(2\)]\)xy\>\"", ",", "Italic", ",", 
          "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.4", ",", "2.3"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(3\)]\)y\>\"", ",", "Italic", ",", 
          "14"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.8", ",", "1.5"}], "}"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.709391531776147*^9, 3.7093915404856453`*^9}, {
   3.7093917594121675`*^9, 3.709391759700184*^9}, {3.7093923203732524`*^9, 
   3.7093923205322614`*^9}, {3.709392507475954*^9, 3.7093925116361923`*^9}, 
   3.7307329926674576`*^9},ExpressionUUID->"16ae1143-39fe-40a1-9a71-\
eebb5260cd68"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig10.2\>\"", ",", "lotkavolterrastatespace"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7107721361892385`*^9, 3.7107721431336336`*^9}, 
   3.7240757998758044`*^9, {3.7285815867812004`*^9, 
   3.728581595484342*^9}},ExpressionUUID->"918e1f33-7085-44f5-8349-\
72ea1aa5ca66"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 10.3", "Subsubsection",
 CellChangeTimes->{{3.7285816405156803`*^9, 3.728581642000058*^9}, 
   3.7286445048299627`*^9},ExpressionUUID->"9653c61b-ee5b-438a-95fb-\
7b7e5c32ad7f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "2", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"stochblowup", "=", 
  RowBox[{"SimulationPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<0\>\"", "\[Rule]", "\"\<Y\>\""}], ",", 
      RowBox[{
       RowBox[{"2", "\"\<X\>\""}], "\[Rule]", 
       RowBox[{
        RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", 
        RowBox[{
         RowBox[{"2", "\"\<Y\>\""}], "\[Rule]", 
         RowBox[{"3", "\"\<X\>\""}]}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "1", ",", "0.2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "2", ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "15", ",", "Bold"}], "]"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"GridLinesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Dashed"}], "]"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Thickness", "[", "0.005", "]"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"LineLegend", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Orange"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\""}], "}"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"22", ",", "Italic"}], "}"}]}]}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "700"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "2.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "90"}], "}"}]}], "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7239857901900053`*^9, 3.723986032532124*^9}, {
  3.723986087267168*^9, 3.723986263394267*^9}, {3.7239866123238354`*^9, 
  3.723986621906454*^9}, {3.723986673624612*^9, 3.7239867061829133`*^9}, {
  3.723986738857307*^9, 3.723986770563758*^9}, {3.723986815346553*^9, 
  3.723986909547408*^9}, {3.7239869407790747`*^9, 3.723986963227825*^9}, {
  3.723990432227065*^9, 3.7239906164538784`*^9}, {3.7239952491877513`*^9, 
  3.723995265201605*^9}, {3.7239953164022512`*^9, 3.723995325826048*^9}, {
  3.7239953827381196`*^9, 3.7239954568210487`*^9}, {3.723995492024699*^9, 
  3.7239955529616613`*^9}, {3.72406820114927*^9, 3.724068211383666*^9}, {
  3.72407587622318*^9, 3.7240758801994057`*^9}, {3.724077999635915*^9, 
  3.7240781386361856`*^9}},ExpressionUUID->"35c9e197-3338-4554-a19a-\
46188847f48f"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig10.3\>\"", ",", "stochblowup"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.72406822803995*^9, 3.724068231211831*^9}, {
  3.7285816723751197`*^9, 
  3.728581684500142*^9}},ExpressionUUID->"9e6ed457-b455-4af6-a53d-\
2ef6ce4e4b65"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 10.4", "Subsubsection",
 CellChangeTimes->{{3.7285817309689827`*^9, 3.728581734859614*^9}, 
   3.728644514423732*^9},ExpressionUUID->"82e6216c-cf6f-47d1-8ead-\
7a8c1a966d7a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"color", " ", "=", " ", "Black"}], ";"}], "\n", 
 RowBox[{"stochproc", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0.32"}], "}"}], ",", "0.09"}], "]"}], ",", 
      RowBox[{"Opacity", "[", "0.3", "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.5", ",", "0.1", ",", "0.5"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "0.8"}], "]"}], ",", "Red", ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "1.7"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.1", ",", "0.9", ",", "0.1"}], "]"}], ",", 
      RowBox[{"Rotate", "[", 
       RowBox[{
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.18"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2.8", ",", "2.32"}], "}"}]}], "]"}], ",", "45"}], "]"}], 
      ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.6", ",", "0.2", ",", "0.6"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "3.5"}], "]"}], ",", "Blue", 
      ",", 
      RowBox[{"Rotate", "[", 
       RowBox[{
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3.6", ",", 
            RowBox[{"-", "1.7"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3.2", ",", "4"}], "}"}]}], "]"}], ",", 
        RowBox[{"-", "45"}]}], "]"}], ",", "\[IndentingNewLine]", "Orange", 
      ",", 
      RowBox[{"Rotate", "[", 
       RowBox[{
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2.9"}], ",", 
            RowBox[{"-", "2.4"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3.2", ",", "4"}], "}"}]}], "]"}], ",", "45"}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Opacity", "[", "1", "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Poisson\>\"", ",", "Bold", ",", "9.5", ",", "color"}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5.1"}], ",", "3.15"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Birth-death\>\"", ",", "Bold", ",", "9.5", ",", "color"}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0.01"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Markov\\n population\>\"", ",", "9.5", ",", "Bold", ",", 
          "color"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "1.2"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Induced kinetic Markov\>\"", ",", "Bold", ",", "10.5", ",", 
          "color"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "1.99"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Markov\>\"", ",", "Bold", ",", "12", ",", "color"}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.4", ",", "3"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Martingale\>\"", ",", "Bold", ",", "12", ",", "color"}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"-", "1.8"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Stationary\>\"", ",", "Bold", ",", "12", ",", "color"}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4.5"}], ",", 
          RowBox[{"-", "3.2"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\>\"", ",", "Bold", ",", "13", ",", "White"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2.9"}], "}"}]}], "]"}], ",", "Black", ",", 
      RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.045"}], ",", "0.35"}], "}"}]}], "}"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Thick", ",", "Gray"}], "]"}]}], ",", 
    RowBox[{"Background", "\[Rule]", "LightGray"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "800"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7089302524871407`*^9, 3.7089302564063644`*^9}, {
   3.7089311694785395`*^9, 3.7089311697705555`*^9}, {3.7089314673645735`*^9, 
   3.708931470371745*^9}, {3.7089601878966317`*^9, 3.7089601883916597`*^9}, 
   3.728647124927665*^9},ExpressionUUID->"aba32035-4f1b-4c4f-aa1d-\
5ebd10df3090"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig10.4\>\"", ",", "stochproc"}], "]"}]], "Input",
 CellChangeTimes->{{3.7107720509673553`*^9, 3.7107720571557107`*^9}, {
  3.724075362339498*^9, 3.724075364084601*^9}, {3.7285817573596582`*^9, 
  3.7285817650002985`*^9}},ExpressionUUID->"a6303d7e-316a-4fb0-be50-\
f6a149da3237"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"f3498d07-6ddd-41fe-9ab2-\
9eb8a5c3b51d"],

Cell[BoxData[
 RowBox[{"AdjacencyGraph", "@", 
  RowBox[{"DependencyGraph", "[", 
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730386481568178*^9, 
  3.730386610568429*^9}},ExpressionUUID->"14f1cd6f-a735-4e26-bbb0-\
9c2e0505cd9c"],

Cell[BoxData[
 RowBox[{"ShowDependencyGraph", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7308705072016883`*^9, 
  3.73087052683681*^9}},ExpressionUUID->"9c6f178d-07c8-4f8e-967c-\
264ed07a2e0b"],

Cell[BoxData[
 RowBox[{"ShowDependencyGraph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", 
     RowBox[{"\"\<Y\>\"", "\[Rule]", 
      RowBox[{"\"\<Z\>\"", "\[Rule]", "\"\<T\>\""}]}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", "\"\<Z\>\"", "}"}]}]}], "]"}]], "Input",ExpressionUUID->\
"34befdde-affe-40b8-a685-d62c35140c1b"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAwAGIQDQEf7BnQQPKxIyaL1t2wnb9Zep0DSH6ju1GwaIF9
1HGm7ku6H+xLdwTVz32+yf7yj8ptt1d+sNd+vdHr1pKD9gteellmZn2039ol
5jIj+4S9xIcHOpwJn+yfz6x1f2xz1v6Gi9JD9vLP9nx7mw+c23re3nyTZA7L
zC/2k+932UxbfN4+dIKSwZ51X+31Vro8XM9+1t43Y3XNi4Xf7Bc4vspcJ37C
/k/uk5/s8d/tHZsThL9aHLRfNG2+3vtr3+2dbp/N0P64EeqPH/bWxWXTuted
2Gu+cx5YfuksvUyg/P7nRx6B9Uv+7wXp379cdCXY/Fo94Syg+fsvHpYH29+/
Mx1k/37/pWJg9/nbLQe5b7+emTzY/QVyM0Hu318idw/sv8OOPSD/7X/S5wH2
/w83eZD/94e7VoDDx415Gyh89vPcYwSH3+O3IaDw22++HBK+Tx6Bw3c/w4nn
b9q0BfYXc8jogPgCa5MbXV+27X/9930dSH2JlP35Muul+5/1NoDN45q1bsrk
Zdv25+k+dQbZd6qBPd2T4fD+uTY+YPecUBPitN9xev+h+CCwex+dSNsgmHJp
v2tTJNg/EY5dBz7surb/rrcw2L/mC9d+Wth+a7/vkx2g8N7/afvE5/I1d/e/
UdUHh1dPVN2uPdH3909VyAaF935IeD/YP9PQsPdH0yPbm0+qwPKRoRNB4W0/
Q7gbrD83Zj84vmaFLQGbf6HbBRTe9o789WD774vNBMe32dQosPvmzr4BTg8p
G39ygNy/p/oUOL1M/fwhDeQ/3vl7welJ6V0H2P9WSwLA6e3EKg5w+HQnPAen
xw+s7xtA4ZezYjs4vTJcOPsSFL6F3cUWoPQMAEj+iyA=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.041582132564841494`, 0.7}}], 
      ArrowBox[{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 1}], ArrowBox[{1, 2}], 
      ArrowBox[{2, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
        41, 42, 43, 44, 45, 46, 47, 48, 2}]}, {InsetBox[
       FrameBox[
        RowBox[{"\<\"X\"\>", "\[RightArrow]", "\<\"Y\"\>"}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox[
        RowBox[{"\<\"Y\"\>", "\[RightArrow]", "\<\"Z\"\>"}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1., 0.}, {0., 8.979318433952318*^-11}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Input",
 CellChangeTimes->{{3.7308705810559163`*^9, 
  3.7308705827460127`*^9}},ExpressionUUID->"347555dc-34f6-4e29-82c7-\
4ea655049eed"],

Cell[BoxData[
 RowBox[{"ShowDependencyGraph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", 
     RowBox[{"\"\<Y\>\"", "\[Rule]", 
      RowBox[{"\"\<Z\>\"", "\[Rule]", "\"\<T\>\""}]}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",ExpressionU\
UID->"7c9b35b4-c070-448b-81a6-07f6cd99c3aa"],

Cell[CellGroupData[{

Cell["p. 259", "Subsubsection",
 CellChangeTimes->{{3.7304610130189667`*^9, 
  3.7304610175502253`*^9}},ExpressionUUID->"3e2ea42e-6903-424a-a60c-\
6bc543800621"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"m", ",", "n"}], "]"}], ";", 
  RowBox[{"k", " ", 
   RowBox[{"Times", "@@", 
    RowBox[{"FactorialPower", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", "23"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7304609012062464`*^9, 3.730460979847026*^9}, {
  3.730461022690863*^9, 
  3.7304610267689924`*^9}},ExpressionUUID->"7f2b61c3-c93a-4bbb-bfd0-\
b442506e973c"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inverse", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 3.7096139310971584`*^9}, {
  3.7097241728756065`*^9, 3.7097241786889396`*^9}, {3.709807517585307*^9, 
  3.7098075272415752`*^9}, {3.712546310616922*^9, 
  3.7125463159316974`*^9}},ExpressionUUID->"9b62fb72-ebe4-4f31-b6ff-\
7e084ad3c682"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"83de4827-0f76-4735-94d0-\
73b6dbd78fa0"],

Cell[CellGroupData[{

Cell["Fig. 11.1", "Subsubsection",
 CellChangeTimes->{{3.7285822175967875`*^9, 3.7285822190058675`*^9}, 
   3.7286445294862604`*^9},ExpressionUUID->"67b0ca66-81f4-4c1c-bd03-\
64d795db48e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "sol", "]"}], ";", 
  RowBox[{"sol", ":=", 
   RowBox[{"First", "[", 
    RowBox[{"ReplaceAll", "@@", 
     RowBox[{"Concentrations", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", "\[DoubleLeftRightArrow]", "X"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.33", ",", "0.72"}], "}"}], ",", 
       RowBox[{"{", "0.2", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "20"}], "}"}]}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7304695397326455`*^9, 3.730469542232649*^9}, {
  3.73046961656092*^9, 3.7304696297484474`*^9}, {3.7304696742485323`*^9, 
  3.730469697701704*^9}, {3.730469731436146*^9, 3.7304697435299177`*^9}, {
  3.730469802655033*^9, 
  3.7304698127175536`*^9}},ExpressionUUID->"6390389d-c044-4d72-97ee-\
e5ea4e0dc0e4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"times", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "100"}], "]"}], "/", "5"}], "]"}]}], ";", 
  RowBox[{"SeedRandom", "[", "100", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"times", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"sol", "/.", 
         RowBox[{"t", "\[Rule]", "times"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.025"}], ",", "0.025"}], "}"}], ",", "101"}], 
          "]"}]}], ")"}]}]}], "}"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.73046965463912*^9, 3.7304696599516306`*^9}, {
   3.7304698485770006`*^9, 3.730469877373929*^9}, 
   3.730733622225379*^9},ExpressionUUID->"dc852909-3dde-4444-abab-\
84ecc089a2b2"],

Cell[BoxData[
 RowBox[{"simdata", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{"data", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"PointSize", "[", "0.015", "]"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.73046965463912*^9, 
  3.7304696599516306`*^9}},ExpressionUUID->"2dad9881-4c82-47da-a38b-\
e855f674fde7"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.1\>\"", ",", "simdata"}], "]"}]], "Input",
 CellChangeTimes->{{3.6249791834722013`*^9, 3.6249792005074315`*^9}, {
  3.7043423444920487`*^9, 3.7043423632264605`*^9}, {3.7285822610712786`*^9, 
  3.7285822680836773`*^9}},ExpressionUUID->"fc91ef13-c525-4060-92f5-\
779d2b95b21b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 11.2", "Subsubsection",
 CellChangeTimes->{{3.7285822289074345`*^9, 3.728582229508468*^9}, 
   3.7286445383300285`*^9},ExpressionUUID->"d373a9f9-46b4-4329-a225-\
fb8afa5e72c5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "a", ",", "b", ",", "model", ",", "nlm", ",", "pl", ",", "lp", ",", 
    "fitted"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"model", "[", 
    RowBox[{
     RowBox[{"a_", "?", "NumberQ"}], ",", 
     RowBox[{"b_", "?", "NumberQ"}], ",", 
     RowBox[{"c_", "?", "NumberQ"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"model", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], "=", 
     RowBox[{"First", "[", 
      RowBox[{"x", "/.", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
            RowBox[{"a", "-", 
             RowBox[{"b", " ", 
              RowBox[{"x", "[", "t", "]"}]}]}]}], ",", 
           RowBox[{
            RowBox[{"x", "[", "0", "]"}], "\[Equal]", "c"}]}], "}"}], ",", 
         "x", ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "20"}], "}"}]}], "]"}]}], "]"}]}], ")"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7105881719547863`*^9, 3.7105881932664113`*^9}, 
   3.728647153693346*^9, {3.730470144218202*^9, 
   3.730470144640078*^9}},ExpressionUUID->"4b18a4c8-e0fd-4e84-b503-\
50187d4a4af7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nlm", "=", 
   RowBox[{"NonlinearModelFit", "[", 
    RowBox[{"data", ",", 
     RowBox[{
      RowBox[{"model", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", ".1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", ".1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "1"}], "}"}]}], "}"}], ",", "t"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.613878959485917*^9, 3.6138789792737565`*^9}, {
   3.6138795470262675`*^9, 3.6138795653845043`*^9}, {3.6138801829173317`*^9, 
   3.6138801932619514`*^9}, {3.614081856614357*^9, 3.614081858954361*^9}, {
   3.614082622980712*^9, 3.6140826353681383`*^9}, {3.6140827111558933`*^9, 
   3.614082712899299*^9}, {3.614084288439109*^9, 3.614084293419919*^9}, 
   3.7286471626621137`*^9},
 CellID->151944537,ExpressionUUID->"57c89d24-13b2-4c18-bc56-8c3d3d84c6e6"],

Cell[BoxData[
 RowBox[{"pl", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"nlm", "[", "t", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", 
       RowBox[{"Thickness", "[", "0.015", "]"}]}], "]"}]}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"First", "@", "simdata"}]}], ",", 
    RowBox[{"ImagePadding", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"10", ",", " ", "10"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6249783276355934`*^9, 3.624978384983301*^9}, {
   3.624978462954238*^9, 3.62497846413984*^9}, {3.624978520206339*^9, 
   3.624978528396353*^9}, 3.624979043680086*^9, {3.7105883180166545`*^9, 
   3.710588318891656*^9}},ExpressionUUID->"63a5b259-4bc3-4aee-bc5d-\
008a935bc682"],

Cell[BoxData[
 RowBox[{"lp", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"nlm", "[", "\"\<FitResiduals\>\"", "]"}], ",", 
    RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
    RowBox[{"ImagePadding", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"10", ",", " ", "10"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6249788271907043`*^9, 3.6249789297605705`*^9}, 
   3.6249789661926546`*^9},ExpressionUUID->"85eae8ee-5965-4b0c-98e9-\
c84d510d6846"],

Cell[BoxData[
 RowBox[{"fitted", "=", 
  RowBox[{"GraphicsRow", "[", 
   RowBox[{"{", 
    RowBox[{"pl", ",", "lp"}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6249784839986753`*^9, 3.624978499739103*^9}, {
  3.6249787277491035`*^9, 3.624978739027923*^9}, {3.624978979648424*^9, 
  3.624979021309807*^9}, {3.6249790637142324`*^9, 3.624979074140829*^9}, {
  3.6249791090288706`*^9, 
  3.6249791111504745`*^9}},ExpressionUUID->"8e74566d-b75d-43cb-8853-\
919909f61383"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.2\>\"", ",", "fitted"}], "]"}]], "Input",
 CellChangeTimes->{{3.6249792307090845`*^9, 3.624979240240701*^9}, {
  3.704342471539172*^9, 3.704342482773569*^9}, {3.7285823107541227`*^9, 
  3.7285823226268015`*^9}},ExpressionUUID->"a042c122-a6a4-4421-9d9b-\
89ecf152b731"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nlm", "[", "\"\<Properties\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.730470417227558*^9, 3.730470424868197*^9}, 
   3.7307336494129305`*^9},ExpressionUUID->"08a1d7bf-4600-45a7-954f-\
170650380ab5"],

Cell["One can also use the function Concentrations.", "Text",
 CellChangeTimes->{{3.7308768978553753`*^9, 
  3.730876910386649*^9}},ExpressionUUID->"7195de7c-d5ea-42e5-bdf3-\
438e4cca3da4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"a", ",", "b", ",", "model2", ",", "nlm2", ",", "pl2"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"model2", "[", 
    RowBox[{
     RowBox[{"a_", "?", "NumberQ"}], ",", 
     RowBox[{"b_", "?", "NumberQ"}], ",", 
     RowBox[{"c_", "?", "NumberQ"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"model", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], "=", 
     RowBox[{"Function", "[", 
      RowBox[{"t", ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{"First", "[", 
         RowBox[{"ReplaceAll", "@@", 
          RowBox[{"Concentrations", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", "\[DoubleLeftRightArrow]", "X"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.33", ",", "0.72"}], "}"}], ",", 
            RowBox[{"{", "0.2", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "20"}], "}"}]}], "]"}]}], "]"}], "]"}]}], 
      "]"}]}], ")"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7105881719547863`*^9, 3.7105881932664113`*^9}, 
   3.728647153693346*^9, {3.730470144218202*^9, 3.730470144640078*^9}, {
   3.7308764122606754`*^9, 3.730876416073186*^9}, {3.7308764519013767`*^9, 
   3.730876454463883*^9}, {3.7308765168077555`*^9, 3.7308765472921877`*^9}, 
   3.7308766546361475`*^9, {3.7308768353240023`*^9, 3.7308768454958963`*^9}, {
   3.73087700335558*^9, 3.730877007871214*^9}, {3.7308770759807224`*^9, 
   3.7308770955004425`*^9}},ExpressionUUID->"eb3f7a8f-496a-4e9a-9ba0-\
1a3e477b048f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nlm2", "=", 
   RowBox[{"NonlinearModelFit", "[", 
    RowBox[{"data", ",", 
     RowBox[{
      RowBox[{"model2", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", ".1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", ".1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "1"}], "}"}]}], "}"}], ",", "t"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.613878959485917*^9, 3.6138789792737565`*^9}, {
   3.6138795470262675`*^9, 3.6138795653845043`*^9}, {3.6138801829173317`*^9, 
   3.6138801932619514`*^9}, {3.614081856614357*^9, 3.614081858954361*^9}, {
   3.614082622980712*^9, 3.6140826353681383`*^9}, {3.6140827111558933`*^9, 
   3.614082712899299*^9}, {3.614084288439109*^9, 3.614084293419919*^9}, 
   3.7286471626621137`*^9, {3.730876461448271*^9, 3.7308764650264015`*^9}, {
   3.7308765813703814`*^9, 3.7308765883703947`*^9}, {3.730877034871267*^9, 
   3.730877056980685*^9}},
 CellID->38679433,ExpressionUUID->"24b03421-b956-4a5f-832d-96dd1cabc42a"],

Cell[BoxData[
 RowBox[{"pl2", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"nlm2", "[", "t", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", 
       RowBox[{"Thickness", "[", "0.015", "]"}]}], "]"}]}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"First", "@", "simdata"}]}], ",", 
    RowBox[{"ImagePadding", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"10", ",", " ", "10"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6249783276355934`*^9, 3.624978384983301*^9}, {
   3.624978462954238*^9, 3.62497846413984*^9}, {3.624978520206339*^9, 
   3.624978528396353*^9}, 3.624979043680086*^9, {3.7105883180166545`*^9, 
   3.710588318891656*^9}, {3.730876673323685*^9, 3.7308766755893145`*^9}, 
   3.730876857636545*^9},ExpressionUUID->"29e42d55-6b32-441c-af15-\
c7b27cd99c50"],

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{"pl2", ",", "lp"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{
  3.7308769784805317`*^9},ExpressionUUID->"21c69e25-3ef2-4a70-bdf8-\
54f8ca33fe3c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 11.3", "Subsubsection",
 CellChangeTimes->{{3.728582243181252*^9, 3.728582243866291*^9}, 
   3.7286445535175576`*^9},ExpressionUUID->"6f89f6fd-c551-4569-9b9b-\
6690b31e91df"],

Cell[BoxData[
 RowBox[{
  RowBox[{"craciunpantea1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(A\), \(0\)]\)\>\"", " ", "\[RightArrow]", " ", 
      RowBox[{"2", "\"\<\!\(\*SubscriptBox[\(A\), \(2\)]\)\>\""}]}], ",", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(A\), \(0\)]\)\>\"", " ", "\[RightArrow]", " ", 
      RowBox[{"2", "\"\<\!\(\*SubscriptBox[\(A\), \(1\)]\)\>\""}]}], ",", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(A\), \(0\)]\)\>\"", " ", "\[RightArrow]", " ", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(A\), \(1\)]\)\>\"", " ", "+", 
       "\"\<\!\(\*SubscriptBox[\(A\), \(2\)]\)\>\""}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6157232611366434`*^9, 3.6157233654846115`*^9}, {
  3.615723655169181*^9, 3.6157237027189007`*^9}, {3.6157237421371555`*^9, 
  3.615723790579926*^9}, {3.6157241273131857`*^9, 3.615724129113289*^9}, {
  3.71093102854463*^9, 
  3.710931068095896*^9}},ExpressionUUID->"26fe0db0-b20b-45cb-9364-\
5ad6e6759947"],

Cell[BoxData[
 RowBox[{"cp1", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"craciunpantea1", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "3"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6157234750138764`*^9, 3.6157234865245347`*^9}, {
   3.6157237088082485`*^9, 3.615723725502204*^9}, 3.710588458016927*^9, {
   3.710588488563862*^9, 3.7105885014076366`*^9}, {3.710931089538122*^9, 
   3.7109310948564267`*^9}},ExpressionUUID->"47ab12db-5cfb-4d30-a4f8-\
d056c3d1f169"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.3A\>\"", ",", "cp1"}], "]"}]], "Input",
 CellChangeTimes->{{3.710588517001419*^9, 3.710588541485841*^9}, {
  3.7285824377283955`*^9, 
  3.7285824452118216`*^9}},ExpressionUUID->"174259f8-6794-47a6-ba26-\
c22ce7b94134"],

Cell[BoxData[
 RowBox[{"cp2", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"craciunpantea1", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4", ",", "1"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6157234750138764`*^9, 3.6157234865245347`*^9}, {
   3.6157237088082485`*^9, 3.615723725502204*^9}, {3.615723830271196*^9, 
   3.6157238413428297`*^9}, 3.7105884201731033`*^9, 
   3.710588513704537*^9},ExpressionUUID->"96e19dd0-e131-49cb-81fd-\
10aca5432cbf"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.3B\>\"", ",", "cp2"}], "]"}]], "Input",
 CellChangeTimes->{{3.7105885580483713`*^9, 3.7105885587046213`*^9}, {
  3.7285824505371284`*^9, 
  3.728582457690534*^9}},ExpressionUUID->"4463386b-2422-4a03-a090-\
853b90195f5b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 11.4", "Subsubsection",
 CellChangeTimes->{{3.7285824982498593`*^9, 3.728582499956957*^9}, 
   3.7286445675488353`*^9},ExpressionUUID->"1d3d270f-b398-435b-bda6-\
398ded78b00c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dyneqsteps1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "1"], " ", "\[Equilibrium]", " ", 
      RowBox[{
       RowBox[{"2", 
        SubscriptBox["X", "1"]}], " ", "+", " ", 
       SubscriptBox["X", "2"]}]}], ",", " ", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["X", "2"]}], "\[Equilibrium]", 
      RowBox[{
       RowBox[{"3", 
        SubscriptBox["X", "1"]}], " ", "+", " ", 
       SubscriptBox["X", "2"]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"dyneq1", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"dyneqsteps1", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "2"}], "}"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.6159597130429893`*^9, 3.6159598022127457`*^9}, 
   3.710588800139776*^9, {3.7144726741318984`*^9, 3.7144726909600563`*^9}, {
   3.7302929188916073`*^9, 
   3.730292925355978*^9}},ExpressionUUID->"2186af9f-8b94-49c1-8a8b-\
06b276012480"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.4A\>\"", ",", "dyneq1"}], "]"}]], "Input",
 CellChangeTimes->{{3.710588770340069*^9, 3.710588778865556*^9}, {
  3.728582510544565*^9, 
  3.7285825191570587`*^9}},ExpressionUUID->"e3dfce75-8f45-4712-993a-\
4050800629d8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dyneqsteps2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "1"], " ", "\[Equilibrium]", " ", 
      RowBox[{
       RowBox[{"2", 
        SubscriptBox["X", "1"]}], " ", "+", " ", 
       SubscriptBox["X", "2"]}]}], " ", "\[RightArrow]", " ", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["X", "2"]}], "\[Equilibrium]", 
      RowBox[{
       RowBox[{"3", 
        SubscriptBox["X", "1"]}], " ", "+", " ", 
       SubscriptBox["X", "2"]}]}], " ", "\[LeftArrow]", "  ", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["X", "1"]}], " ", "+", " ", 
      SubscriptBox["X", "2"]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"dyneq2", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"dyneqsteps2", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "1", ",", "3", ",", "2", ",", "3"}], 
      "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6159597130429893`*^9, 3.6159598878100963`*^9}, {
   3.615959973485447*^9, 3.61595997531065*^9}, 3.7105888106173735`*^9, {
   3.7144726967881927`*^9, 3.714472712975725*^9}, {3.730292838403*^9, 
   3.7302928602062483`*^9}, {3.7302929323393774`*^9, 
   3.7302929330834184`*^9}},ExpressionUUID->"29bd8bd7-d2af-4016-a142-\
1b9e7c7215a4"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.4B\>\"", ",", "dyneq2"}], "]"}]], "Input",
 CellChangeTimes->{{3.7105887894911633`*^9, 3.71058878976118*^9}, {
  3.728582523381297*^9, 
  3.72858253443493*^9}},ExpressionUUID->"66c8fc8b-70f9-4309-90ee-\
2fcf1df0a885"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 11.5", "Subsubsection",
 CellChangeTimes->{{3.7285826460873237`*^9, 3.728582647007377*^9}, 
   3.7286445827207384`*^9},ExpressionUUID->"19df5bca-541b-4443-a49a-\
de6e4007b35f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"szeder1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["A", "1"]}], " ", "\[RightArrow]", " ", 
      SubscriptBox["A", "2"]}], ",", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["A", "1"]}], " ", "\[RightArrow]", " ", 
      RowBox[{
       SubscriptBox["A", "1"], "+", 
       SubscriptBox["A", "2"]}]}], ",", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["A", "1"]}], " ", "\[RightArrow]", " ", 
      RowBox[{"3", 
       SubscriptBox["A", "1"]}]}], ",", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["A", "1"]}], " ", "\[RightArrow]", " ", 
      RowBox[{
       RowBox[{"2", 
        SubscriptBox["A", "1"]}], "+", 
       SubscriptBox["A", "2"]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.615701789946562*^9, 
  3.6157018859800544`*^9}},ExpressionUUID->"cd8a4eb5-be69-4090-93c0-\
1f317a822727"],

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"szeder1", ",", 
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{"1", "&"}], ",", "4"}], "]"}], ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6157018890562305`*^9, 3.6157019359369116`*^9}, {
  3.6157019780483203`*^9, 3.615701990711045*^9}, {3.6157020209747753`*^9, 
  3.6157020582209063`*^9}, {3.615702158853662*^9, 3.6157021596507072`*^9}, {
  3.6157027117562857`*^9, 
  3.615702718734685*^9}},ExpressionUUID->"7c6bf17f-415b-424d-8aaa-\
1d5040411d87"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.5A\>\"", ",", "s1"}], "]"}]], "Input",
 CellChangeTimes->{{3.710588941008597*^9, 3.71058894760236*^9}, {
  3.728582666068469*^9, 
  3.7285826849945526`*^9}},ExpressionUUID->"78f205a0-b4d2-43de-bc23-\
aac007c4b82e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"szeder2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["A", "1"]}], " ", "\[RightArrow]", " ", 
      SubscriptBox["A", "2"]}], ",", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["A", "1"]}], " ", "\[RightArrow]", " ", 
      RowBox[{
       SubscriptBox["A", "1"], "+", 
       SubscriptBox["A", "2"]}]}], ",", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["A", "1"]}], " ", "\[RightArrow]", " ", 
      RowBox[{"3", 
       SubscriptBox["A", "1"]}]}], ",", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["A", "1"]}], " ", "\[RightArrow]", " ", 
      RowBox[{
       RowBox[{"2", 
        SubscriptBox["A", "1"]}], "+", 
       SubscriptBox["A", "2"]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["A", "1"], "+", 
       SubscriptBox["A", "2"]}], "\[Rule]", 
      SubscriptBox["A", "2"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["A", "1"], "+", 
       SubscriptBox["A", "2"]}], "\[Rule]", 
      RowBox[{
       RowBox[{"2", 
        SubscriptBox["A", "1"]}], "+", 
       SubscriptBox["A", "2"]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.615701789946562*^9, 3.6157018859800544`*^9}, {
  3.6157020861345024`*^9, 
  3.6157021352923145`*^9}},ExpressionUUID->"c60318f3-6579-45dc-ac2c-\
adf00dfae645"],

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"szeder2", ",", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "0.1", ",", "0.1", ",", "1.9", ",", "0.1", ",", "0.1"}], "}"}],
     ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6157018890562305`*^9, 3.6157019359369116`*^9}, {
  3.6157019780483203`*^9, 3.615701990711045*^9}, {3.6157020209747753`*^9, 
  3.6157020582209063`*^9}, {3.615702141314659*^9, 3.6157021666571083`*^9}, {
  3.6157027235599613`*^9, 
  3.6157027609811015`*^9}},ExpressionUUID->"0aff12c1-2b38-4eef-84fc-\
ea4f9915da09"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.5B\>\"", ",", "s2"}], "]"}]], "Input",
 CellChangeTimes->{{3.710589406511338*^9, 3.710589407122374*^9}, {
  3.7285826933900323`*^9, 
  3.7285826994693823`*^9}},ExpressionUUID->"9c373903-a05d-460e-8fdd-\
a990375dc71f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 11.6", "Subsubsection",
 CellChangeTimes->{{3.72858279372178*^9, 3.7285827945778284`*^9}, 
   3.7286445985020213`*^9},ExpressionUUID->"9a915a77-ea32-45c5-b4b4-\
1b0c88f79499"],

Cell[BoxData[
 RowBox[{
  RowBox[{"origr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"X", "+", "Y"}], "\[DoubleLeftRightArrow]", 
       RowBox[{"X", "+", 
        RowBox[{"2", "Y"}]}], "\[DoubleLeftRightArrow]", 
       RowBox[{
        RowBox[{"2", "X"}], "+", 
        RowBox[{"3", "Y"}]}]}], "\[Rule]", " ", 
      RowBox[{
       RowBox[{"2", "Y"}], "\[LeftArrow]", 
       RowBox[{"X", "+", "Y"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", "Y"}], "\[DoubleLeftRightArrow]", 
      RowBox[{"X", "+", 
       RowBox[{"2", "Y"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.7053160010934486`*^9},ExpressionUUID->"a0748e1d-6068-4190-b931-\
3b36ccf78a8b"],

Cell[BoxData[
 RowBox[{"orig", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"origr", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "16"}], "]"}], "&"}], "/@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(2\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(5\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(4\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(8\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(3\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(7\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(6\)]\)\>\""}], "}"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(2\)]\)\>\"", "\[Rule]", " ", 
          "\"\<11/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(5\)]\)\>\"", "\[Rule]", " ", 
          "\"\<11/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(4\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(8\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(3\)]\)\>\"", "\[Rule]", "1"}], " ", 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(7\)]\)\>\"", "\[Rule]", " ", "3"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(6\)]\)\>\"", "\[Rule]", " ", 
          "\"\<1/10\>\""}]}], "}"}]}], ")"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "1300"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7053003944762497`*^9, 3.7053003992575045`*^9}, {
   3.7053005750855665`*^9, 3.7053005950387297`*^9}, {3.7053006263512917`*^9, 
   3.7053007023045645`*^9}, {3.7053009556019354`*^9, 
   3.7053010269770746`*^9}, {3.705312859778368*^9, 3.7053128884659233`*^9}, {
   3.7053129501847954`*^9, 3.7053129899817467`*^9}, {3.70531303996622*^9, 
   3.7053130442318525`*^9}, {3.7053130954038277`*^9, 
   3.7053131285601425`*^9}, {3.7053155489363146`*^9, 3.705315564592595*^9}, {
   3.705315704030368*^9, 3.705315729842918*^9}, {3.7053159422027082`*^9, 
   3.7053159627496223`*^9}, 3.705316005421581*^9, 
   3.7105891612572966`*^9},ExpressionUUID->"d6f4fba5-b50b-463c-be71-\
94a6096554f2"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.6A\>\"", ",", "orig"}], "]"}]], "Input",
 CellChangeTimes->{{3.705315572514487*^9, 3.705315577545747*^9}, {
  3.7285828213513618`*^9, 
  3.7285828253465915`*^9}},ExpressionUUID->"fd21d670-e8a7-40d0-b78c-\
dd8a91747c28"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sparser", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"X", "+", "Y"}], "\[DoubleLeftRightArrow]", 
       RowBox[{"X", "+", 
        RowBox[{"2", "Y"}]}], "\[DoubleLeftRightArrow]", 
       RowBox[{
        RowBox[{"2", "X"}], "+", 
        RowBox[{"3", "Y"}]}]}], "\[Rule]", " ", 
      RowBox[{
       RowBox[{"2", "Y"}], "\[LeftArrow]", 
       RowBox[{"X", "+", "Y"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", "Y"}], "\[Rule]", " ", 
      RowBox[{"X", "+", 
       RowBox[{"2", "Y"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.705299931787841*^9, 3.7053000514912014`*^9}, {
   3.7053000843818903`*^9, 3.70530020250712*^9}, {3.7053002562728505`*^9, 
   3.705300291241669*^9}, {3.7053003268354883`*^9, 3.705300351944913*^9}, {
   3.7053135497681513`*^9, 3.7053135569385624`*^9}, 
   3.705316204984473*^9},ExpressionUUID->"c4e786c2-12fc-4abc-bb80-\
b48f4992a532"],

Cell[BoxData[
 RowBox[{"sparse", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"sparser", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "16"}], "]"}], "&"}], "/@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(2\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(3\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(4\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(5\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(6\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(7\)]\)\>\""}], "}"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(2\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(3\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(4\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(5\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(6\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(7\)]\)\>\"", "\[Rule]", " ", 
          "3"}]}], "}"}]}], ")"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "1000"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7053003944762497`*^9, 3.7053003992575045`*^9}, {
   3.7053005750855665`*^9, 3.7053005950387297`*^9}, {3.7053006263512917`*^9, 
   3.7053007329296246`*^9}, {3.7053009234768724`*^9, 
   3.7053009439300375`*^9}, {3.7053151942324953`*^9, 3.705315223435676*^9}, {
   3.7053156410771203`*^9, 3.705315651749015*^9}, {3.705316208546979*^9, 
   3.7053162469533043`*^9}, 
   3.710589235141526*^9},ExpressionUUID->"e64527a3-4ee6-407b-b3bb-\
34adca172df4"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.6B\>\"", ",", "sparse"}], "]"}]], "Input",
 CellChangeTimes->{{3.705315657592778*^9, 3.7053156637490387`*^9}, {
  3.7285828296378384`*^9, 
  3.728582838397338*^9}},ExpressionUUID->"242deb2a-839a-41ac-b9f2-\
397f27dd18f8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"denser", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "X"}], "+", 
       RowBox[{"3", "Y"}]}], "\[DoubleLeftRightArrow]", 
      RowBox[{"X", "+", "Y"}], "\[DoubleLeftRightArrow]", 
      RowBox[{"X", "+", 
       RowBox[{"2", "Y"}]}], "\[DoubleLeftRightArrow]", 
      RowBox[{
       RowBox[{"2", "X"}], "+", 
       RowBox[{"3", "Y"}]}], "\[DoubleLeftRightArrow]", 
      RowBox[{"2", "Y"}], "\[DoubleLeftRightArrow]", 
      RowBox[{"X", "+", "Y"}]}], ",", 
     RowBox[{
      RowBox[{"2", "Y"}], "\[DoubleLeftRightArrow]", 
      RowBox[{"X", "+", 
       RowBox[{"2", "Y"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{3.705313597649895*^9, 
  3.705316025780998*^9},ExpressionUUID->"3c6b7d76-7a35-4932-846e-\
391c57bbd64f"],

Cell[BoxData[
 RowBox[{"dense", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"denser", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "16"}], "]"}], "&"}], "/@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(2\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(3\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(4\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(5\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(6\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(7\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(8\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(9\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(10\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(11\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(12\)]\)\>\""}], "}"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)\>\"", "\[Rule]", 
          "\"\<3/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(2\)]\)\>\"", "\[Rule]", " ", 
          "\"\<3/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(3\)]\)\>\"", "\[Rule]", 
          "\"\<1/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(4\)]\)\>\"", "\[Rule]", 
          "\"\<11/10\>\""}], " ", ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(5\)]\)\>\"", "\[Rule]", 
          "\"\<11/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(6\)]\)\>\"", "\[Rule]", " ", 
          "\"\<1/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(7\)]\)\>\"", "\[Rule]", " ", 
          "\"\<13/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(8\)]\)\>\"", "\[Rule]", 
          "\"\<29/30\>\""}], " ", ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(9\)]\)\>\"", "\[Rule]", 
          "\"\<29/30\>\""}], " ", ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(10\)]\)\>\"", "\[Rule]", 
          "\"\<13/10\>\""}], " ", ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(11\)]\)\>\"", "\[Rule]", " ", 
          "\"\<1/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(12\)]\)\>\"", "\[Rule]", 
          "\"\<1/10\>\""}]}], "}"}]}], ")"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "800"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7053003944762497`*^9, 3.7053003992575045`*^9}, {
   3.7053005750855665`*^9, 3.7053005950387297`*^9}, {3.7053006263512917`*^9, 
   3.7053007023045645`*^9}, {3.7053007471796527`*^9, 
   3.7053009074612155`*^9}, {3.7053015852125425`*^9, 3.705301589196924*^9}, {
   3.7053016303063793`*^9, 3.705301635603266*^9}, {3.705313481146222*^9, 
   3.705313524933728*^9}, {3.7053136134538*^9, 3.7053136261135235`*^9}, {
   3.7053136956615067`*^9, 3.705313707175167*^9}, {3.7053144621151485`*^9, 
   3.70531446774016*^9}, {3.705314901575674*^9, 3.705314902106925*^9}, {
   3.705315592733275*^9, 3.705315618061449*^9}, {3.70531602995288*^9, 
   3.7053161810313005`*^9}, 
   3.710589256482745*^9},ExpressionUUID->"5010b8ae-c097-476b-9f84-\
57cb9b46f802"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig11.6C\>\"", ",", "dense"}], "]"}]], "Input",
 CellChangeTimes->{{3.705315625686465*^9, 3.705315629733349*^9}, {
  3.728582843986658*^9, 
  3.7285828503060226`*^9}},ExpressionUUID->"fc73fbe0-8ac1-452d-8f4c-\
4856ac02e552"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"da8df4da-ce5e-4548-ae95-\
009573508ebb"],

Cell[CellGroupData[{

Cell["11.5 Identifiablility and Uniqueness Questions", "Subsubsection",
 CellChangeTimes->{{3.7125492084257665`*^9, 3.7125492183644495`*^9}, {
  3.729245209308745*^9, 
  3.729245222105644*^9}},ExpressionUUID->"bb82f8ad-ef1f-4a13-9239-\
79c3fbcd96ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"craciunpantea1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(A\), \(0\)]\)\>\"", " ", "\[RightArrow]", " ", 
      RowBox[{"2", "\"\<\!\(\*SubscriptBox[\(A\), \(2\)]\)\>\""}]}], ",", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(A\), \(0\)]\)\>\"", " ", "\[RightArrow]", " ", 
      RowBox[{"2", "\"\<\!\(\*SubscriptBox[\(A\), \(1\)]\)\>\""}]}], ",", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(A\), \(0\)]\)\>\"", " ", "\[RightArrow]", " ", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(A\), \(1\)]\)\>\"", " ", "+", 
       "\"\<\!\(\*SubscriptBox[\(A\), \(2\)]\)\>\""}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6157232611366434`*^9, 3.6157233654846115`*^9}, {
  3.615723655169181*^9, 3.6157237027189007`*^9}, {3.6157237421371555`*^9, 
  3.615723790579926*^9}, {3.6157241273131857`*^9, 3.615724129113289*^9}, {
  3.71093102854463*^9, 
  3.710931068095896*^9}},ExpressionUUID->"6b10b313-3689-4483-9d6e-\
dfddf4ec015f"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", "craciunpantea1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712549292727527*^9, 
  3.712549329402987*^9}},ExpressionUUID->"1a96240c-2681-4f52-bd22-\
cc0e42d76312"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", "craciunpantea1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712549292727527*^9, 3.712549329402987*^9}, {
  3.712549375519667*^9, 
  3.712549382261829*^9}},ExpressionUUID->"62c416bf-8a78-4501-a0da-\
b2185ceb26f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Theorem 11.8 ", "Subsubsection",
 CellChangeTimes->{{3.7125805786468697`*^9, 3.7125805841321893`*^9}, {
  3.7292452813557615`*^9, 3.7292452869495215`*^9}, {3.730199275444769*^9, 
  3.7301992761958117`*^9}},ExpressionUUID->"683c243a-297e-424a-bea6-\
a0418cc0a9af"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"X", " ", "+", " ", "Y"}], " ", "\[Rule]", " ", 
      RowBox[{"2", "X"}]}], ",", " ", 
     RowBox[{
      RowBox[{"X", " ", "+", " ", "Y"}], " ", "\[Rule]", " ", 
      RowBox[{"2", "Y"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712549292727527*^9, 3.712549329402987*^9}, {
  3.712549375519667*^9, 3.712549382261829*^9}, {3.7125522563428373`*^9, 
  3.7125523075774174`*^9}, {3.7304705102589912`*^9, 
  3.7304705172746267`*^9}},ExpressionUUID->"a22e4845-e70e-4536-869a-\
9ca3e589b234"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 11.13", "Subsubsection",
 CellChangeTimes->{{3.7292453470277653`*^9, 
  3.72924535188715*^9}},ExpressionUUID->"cd67976b-4e90-4f75-b15f-\
58dc8e93a520"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Y", "\[Rule]", 
      RowBox[{"3", "X"}]}], ",", 
     RowBox[{"X", "\[Rule]", 
      RowBox[{"3", "Y"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7125811156422215`*^9, 
  3.7125811333204627`*^9}},ExpressionUUID->"4a2fe142-8873-4e8b-bc2f-\
7d9d7944f1cd"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Programs", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 3.7096139310971584`*^9}, {
  3.7097241728756065`*^9, 3.7097241786889396`*^9}, {3.709807517585307*^9, 
  3.7098075272415752`*^9}, {3.7098075689291563`*^9, 
  3.709807573538539*^9}},ExpressionUUID->"f85da745-7d88-4a00-b3bb-\
0af67f0c22ab"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"699a2fb6-9a2b-4c8d-8ee3-\
bc70030efa81"],

Cell[CellGroupData[{

Cell["Fig. 12.1", "Subsubsection",
 CellChangeTimes->{{3.728583125376772*^9, 3.728583126288825*^9}, 
   3.7286446427989836`*^9},ExpressionUUID->"9ee7f45a-bdc8-4d4f-88ac-\
88209ce1d453"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "500", "]"}], ";", 
  RowBox[{"sp1", "=", 
   RowBox[{
    RowBox[{"SimulationPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<X\>\"", " ", "\[Equilibrium]", " ", "\"\<Y\>\""}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"3.8", ",", "8.3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "10"}], "}"}], ",", "1", ",", 
      RowBox[{"Verbose", "\[Rule]", "True"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], "//", 
    "Timing"}]}]}]], "Input",
 CellChangeTimes->{{3.555212428872157*^9, 3.5552124290641685`*^9}, {
  3.6214218143585224`*^9, 3.6214219597328377`*^9}, {3.621422052690154*^9, 
  3.621422063864794*^9}, {3.7119864801219454`*^9, 3.7119864970373263`*^9}, {
  3.728583179022843*^9, 3.728583190905383*^9}, {3.7285832334070377`*^9, 
  3.728583234228341*^9}},ExpressionUUID->"952d5631-b8df-437e-88ce-\
e428dfe8b999"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";", 
  RowBox[{"sp2", "=", 
   RowBox[{
    RowBox[{"SimulationPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<X\>\"", " ", "\[Equilibrium]", " ", "\"\<Y\>\""}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"3.8", ",", "8.3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "10"}], "}"}], ",", "1", ",", 
      RowBox[{"Verbose", "\[Rule]", "True"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], "//", 
    "Timing"}]}]}]], "Input",
 CellChangeTimes->{{3.555212428872157*^9, 3.5552124290641685`*^9}, {
   3.6214218143585224`*^9, 3.6214219682273235`*^9}, {3.6214220461307793`*^9, 
   3.6214220678810234`*^9}, 3.711986511022719*^9, {3.728583200327279*^9, 
   3.728583207108543*^9}},ExpressionUUID->"5726a8ae-ba7d-4597-9029-\
3fe981e69ab6"],

Cell[BoxData[
 RowBox[{"differentsimul", "=", 
  RowBox[{"Column", "[", 
   RowBox[{"Last", "/@", 
    RowBox[{"{", 
     RowBox[{"sp1", ",", "sp2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.621421975315729*^9, 3.621422028985799*^9}, {
  3.621422302930467*^9, 3.6214223055216155`*^9}, {3.621422535434766*^9, 
  3.621422543707239*^9}, {3.7105808809435005`*^9, 3.710580882836605*^9}, {
  3.711986520056716*^9, 
  3.711986522986947*^9}},ExpressionUUID->"aacd29cd-9fff-4160-b117-\
d579da4bd1b2"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig12.1\>\"", ",", "differentsimul"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7105808480506153`*^9, 3.710580858126191*^9}, {
  3.7285831571405926`*^9, 
  3.72858316721817*^9}},ExpressionUUID->"4ca2612d-7053-42bc-8d2d-\
9a83851fd293"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"94b55a7e-8b49-4c84-be45-\
e4f2de0e7571"],

Cell[BoxData["OpenReactionKineticsPalette"], "Input",
 CellChangeTimes->{{3.7307341243201094`*^9, 3.7307341313513713`*^9}, {
  3.730734161507682*^9, 
  3.7307341620701833`*^9}},ExpressionUUID->"44c3a584-03c5-4de8-9d1b-\
3a4bc40706a5"],

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<ReactionKinetics`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.730470838478381*^9, 3.730470838494007*^9}, {
  3.7304708876816015`*^9, 
  3.7304708981816225`*^9}},ExpressionUUID->"5f6f5f30-ff38-4cb0-be5d-\
99e400163c21"],

Cell[BoxData[
 RowBox[{"Information", "[", "\"\<ReactionKinetics`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.730470850822156*^9, 3.730470850822156*^9}, {
  3.7304709064316387`*^9, 
  3.7304709079628916`*^9}},ExpressionUUID->"bfb6648a-31d4-454c-a392-\
5996ba714e12"],

Cell[BoxData[
 RowBox[{"?", "Concentrations"}]], "Input",
 CellChangeTimes->{{3.7292455235593596`*^9, 
  3.7292455336375046`*^9}},ExpressionUUID->"9a81fce1-f1d0-4df9-8ad0-\
421d8f7aa08e"],

Cell[BoxData[
 RowBox[{"?", "Simulation"}]], "Input",ExpressionUUID->"dd258b76-6675-4c45-9f43-3b2e8095f92d"],

Cell[BoxData[
 RowBox[{"?", "SimulationPlot"}]], "Input",
 CellChangeTimes->{{3.729245551075038*^9, 
  3.729245563231312*^9}},ExpressionUUID->"9a9440e4-b4c7-425c-9eed-\
a63bfc77646d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SimulationPlot2D", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0.1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12"}], "}"}], ",", "10", ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.730891597983308*^9, 
  3.7308917702023993`*^9}},ExpressionUUID->"27be06b0-6b50-4e69-bbc1-\
d027a767e224"],

Cell[BoxData[
 RowBox[{"Options", "[", "ShowFHJGraph", "]"}]], "Input",
 CellChangeTimes->{{3.729245582778226*^9, 
  3.729245595418875*^9}},ExpressionUUID->"75134310-1d51-485e-a9db-\
0c1c6a2be114"],

Cell[BoxData[
 RowBox[{"?", "ShowFHJGraph"}]], "Input",
 CellChangeTimes->{{3.7304709682598844`*^9, 
  3.7304709693848867`*^9}},ExpressionUUID->"2436049f-9331-4b45-bb98-\
5506dd19aef1"],

Cell[BoxData["Models"], "Input",
 CellChangeTimes->{{3.7307343200861173`*^9, 
  3.7307343209767437`*^9}},ExpressionUUID->"95cbaa0f-88f2-4977-9bfc-\
ed2a8c100edc"],

Cell[BoxData["Reactions"], "Input",
 CellChangeTimes->{{3.730734307664217*^9, 
  3.73073430944547*^9}},ExpressionUUID->"45838817-0dda-419a-8670-\
716a5b078a87"],

Cell["Or in a more complicated way, if you prefer:", "Text",
 CellChangeTimes->{{3.730734503617728*^9, 
  3.730734516274*^9}},ExpressionUUID->"167c7541-bda0-454d-b2f2-03c7be3a9374"],

Cell[BoxData[
 RowBox[{"GetReaction", "[", "\"\<Models\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.730734270945396*^9, 
  3.7307342720391474`*^9}},ExpressionUUID->"124ffa12-2fde-40ee-a3be-\
6bbe711a58f5"],

Cell[BoxData[
 RowBox[{"GetReaction", "[", "\"\<Models\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7292456179970455`*^9, 3.729245647637729*^9}, {
  3.729245737038066*^9, 3.72924574530054*^9}, {3.7301994006989446`*^9, 
  3.730199401368984*^9}},ExpressionUUID->"480964ea-9f5f-4272-b0a6-\
ff55b170c422"],

Cell[BoxData[
 RowBox[{"iva", "=", 
  RowBox[{"GetReaction", "[", "\"\<Ivanova\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.729245708220109*^9, 3.7292457270614967`*^9}, {
  3.73019933833737*^9, 3.730199338597386*^9}, {3.7301993910103865`*^9, 
  3.7301993939835567`*^9}},ExpressionUUID->"2404d8fd-706e-44ac-8ed5-\
264ecdd7815f"],

Cell[BoxData[
 RowBox[{"DeterministicModel", "[", 
  RowBox[{"iva", ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.729245754130046*^9, 
  3.7292457878829813`*^9}},ExpressionUUID->"ab4abbdb-b28d-4cf5-bc92-\
d54adc68f323"],

Cell[BoxData[
 RowBox[{"ShowVolpertGraph", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Glyoxylate Cycle\>\"", "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "800"}], ",", 
   RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
   RowBox[{"Numbered", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.72924586438636*^9, 
  3.729245864390358*^9}},ExpressionUUID->"e0e93763-ef54-4127-ad5e-\
b4d0dc6521b0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", "iva", "]"}], "[", 
  RowBox[{
  "\"\<\[Gamma]\>\"", ",", "\"\<deficiency\>\"", ",", 
   "\"\<reactionsteporders\>\"", ",", "\"\<complexes\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.729245883806473*^9, 3.7292459144582276`*^9}, {
  3.7301994204820776`*^9, 
  3.7301994210081053`*^9}},ExpressionUUID->"96eaa8cb-28cc-400b-8b5c-\
c664547312fe"],

Cell[BoxData[
 RowBox[{"Through", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Normal", ",", "MatrixForm"}], "}"}], "[", 
   RowBox[{
    RowBox[{"ReactionsData", "[", "iva", "]"}], "[", "\"\<\[Gamma]\>\"", 
    "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7292459413687687`*^9, 
  3.7292459489181995`*^9}},ExpressionUUID->"50192383-e7fd-417b-8f62-\
1690eafdc88c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Appendix", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 3.7096139310971584`*^9}, {
  3.7097241728756065`*^9, 3.7097241786889396`*^9}, {3.709807517585307*^9, 
  3.7098075272415752`*^9}, {3.7098075887260704`*^9, 
  3.709807594522957*^9}},ExpressionUUID->"bc868344-1097-40cd-bcec-\
b02508843818"],

Cell[CellGroupData[{

Cell["Figures", "Chapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"1d72a944-a341-4894-87dd-\
3086e55812ce"],

Cell[CellGroupData[{

Cell["Fig. 13.1", "Subsubsection",
 CellChangeTimes->{{3.728583312503558*^9, 3.728583314800438*^9}, 
   3.728644682236559*^9},ExpressionUUID->"877c2ffc-5d9f-4c9f-bf7c-\
6b524a36b7bc"],

Cell[BoxData[
 RowBox[{"graphforesttreeetc", "=", 
  RowBox[{"Row", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Graph", "[", 
       RowBox[{"#", ",", 
        RowBox[{"GraphLayout", "\[Rule]", "\"\<CircularEmbedding\>\""}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "200"}], ",", 
        RowBox[{"EdgeStyle", "\[Rule]", "Thick"}], ",", 
        RowBox[{"VertexSize", "\[Rule]", "Small"}]}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "\[UndirectedEdge]", "2"}], ",", 
         RowBox[{"2", "\[UndirectedEdge]", "3"}], ",", 
         RowBox[{"3", "\[UndirectedEdge]", "4"}], ",", 
         RowBox[{"4", "\[UndirectedEdge]", "5"}], ",", 
         RowBox[{"5", "\[UndirectedEdge]", "6"}], ",", 
         RowBox[{"6", "\[UndirectedEdge]", "1"}], ",", 
         RowBox[{"6", "\[UndirectedEdge]", "4"}], ",", 
         RowBox[{"2", "\[UndirectedEdge]", "6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"3", "\[UndirectedEdge]", "4"}], ",", 
         RowBox[{"4", "\[UndirectedEdge]", "5"}], ",", 
         RowBox[{"6", "\[UndirectedEdge]", "1"}], ",", 
         RowBox[{"6", "\[UndirectedEdge]", "4"}], ",", 
         RowBox[{"2", "\[UndirectedEdge]", "6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"3", "\[UndirectedEdge]", "5"}], ",", 
         RowBox[{"6", "\[UndirectedEdge]", "1"}], ",", 
         RowBox[{"6", "\[UndirectedEdge]", "4"}], ",", 
         RowBox[{"2", "\[UndirectedEdge]", "6"}]}], "}"}]}], "}"}]}], ",", 
    "\"\<      \>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.71057671645955*^9, 3.710576848522108*^9}, {
   3.710576900963112*^9, 3.7105769267435875`*^9}, 3.710576995704348*^9, 
   3.71057703192317*^9, {3.710578001275751*^9, 3.710578032510189*^9}, {
   3.7105780643696256`*^9, 3.710578170854208*^9}, {3.7105795186537204`*^9, 
   3.710579630935189*^9}, {3.7105796986540728`*^9, 3.710579729544757*^9}, {
   3.7105797748260956`*^9, 3.710579873045038*^9}, {3.710580266248929*^9, 
   3.710580271264566*^9}, {3.710580311842769*^9, 3.710580410467964*^9}, {
   3.710580441530525*^9, 
   3.710580443452403*^9}},ExpressionUUID->"48a008c4-32c2-403b-aeb6-\
e8d92248a461"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig13.1\>\"", ",", "graphforesttreeetc"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7105804488117905`*^9, 3.7105804571086793`*^9}, {
  3.728583331784848*^9, 3.728583337737983*^9}, {3.7285834509744368`*^9, 
  3.728583451393459*^9}},ExpressionUUID->"60e0156a-e9c9-4db3-8839-\
a68f5f6853bd"]
}, Open  ]]
}, Open  ]],

Cell["Calculations", "Chapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"4bbb4d74-fda8-4bc2-a173-\
29b1872e035b"]
}, Closed]],

Cell[CellGroupData[{

Cell["Solutions", "Title",
 CellChangeTimes->{{3.7096139267519107`*^9, 3.7096139310971584`*^9}, {
  3.7097241728756065`*^9, 3.7097241786889396`*^9}, {3.709807517585307*^9, 
  3.7098075272415752`*^9}, {3.709807605351103*^9, 
  3.7098076095698614`*^9}},ExpressionUUID->"81106095-4a1d-4a8a-aa4e-\
ad9a8491d5ca"],

Cell[CellGroupData[{

Cell["Introduction", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 
  3.710510138562091*^9}},ExpressionUUID->"c9474d64-36da-4906-bd92-\
82faedda890a"],

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"16b53de9-d1bf-4aa6-8bad-\
09e1a05679e8"],

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"6c0b4c1b-6c65-4a8e-866f-\
f024ca1f971a"]
}, Closed]],

Cell[CellGroupData[{

Cell["Preparations", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 
  3.710510169093401*^9}},ExpressionUUID->"448f170f-855c-43e1-8f1f-\
f0f725555975"],

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"79d1ebf3-087e-4fc4-b3c2-\
0fc8a0076276"],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"079e1dae-1ebc-42d6-8073-\
c385fd381ee6"],

Cell[CellGroupData[{

Cell["Solution 2.1", "Subsubsection",
 CellChangeTimes->{{3.7304713331043468`*^9, 
  3.730471335494978*^9}},ExpressionUUID->"a1e7c9af-9018-49c7-9ce7-\
b4b4a853dfac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"x", ",", "y", ",", "p", ",", "a", ",", "m", ",", "M"}], "]"}], 
  ";", 
  RowBox[{"dm1", "=", 
   RowBox[{
    RowBox[{"DeterministicModel", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"X", "+", "Y"}], "\[Rule]", 
         RowBox[{"2", "P"}]}], ",", 
        RowBox[{
         RowBox[{"Y", "+", "A"}], "\[Rule]", 
         RowBox[{"X", "+", "P"}]}], ",", 
        RowBox[{
         RowBox[{"2", "X"}], "\[Rule]", 
         RowBox[{"P", "+", "A"}]}], ",", 
        RowBox[{
         RowBox[{"X", "+", "A"}], "\[Rule]", 
         RowBox[{
          RowBox[{"2", "X"}], "+", 
          RowBox[{"2", "Z"}]}]}], ",", 
        RowBox[{
         RowBox[{"X", "+", "Z"}], "\[Rule]", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "2"}], "X"}], "+", "A"}]}], ",", 
        RowBox[{
         RowBox[{"M", "+", "Z"}], "\[Rule]", 
         RowBox[{
          RowBox[{"2", "M"}], "+", "Z"}]}], ",", 
        RowBox[{
         RowBox[{"Z", "+", "M"}], "\[Rule]", 
         RowBox[{
          RowBox[{"1", "/", "2"}], "Y"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["k", "1"], ",", 
        SubscriptBox["k", "2"], ",", 
        SubscriptBox["k", "3"], ",", 
        SubscriptBox["k", "4"], ",", 
        SubscriptBox["k", "5"], ",", 
        SubscriptBox["k", "6"], ",", 
        RowBox[{"2", 
         SubscriptBox["k", "6"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "p", ",", "a", ",", "z", ",", "m"}], 
       "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.730471338198111*^9, 3.7304714975109215`*^9}, {
  3.7304717305426245`*^9, 3.7304717496207876`*^9}, {3.73047195040243*^9, 
  3.7304719601055737`*^9}, {3.7304720148244314`*^9, 3.7304720992152205`*^9}, {
  3.7307348652903075`*^9, 3.730734879587211*^9}, {3.730734980024907*^9, 
  3.730734989259301*^9}},ExpressionUUID->"3e411d9a-7de2-4347-a320-\
a3070fda3100"],

Cell[BoxData[
 RowBox[{"dm2", "=", 
  RowBox[{
   RowBox[{"DeterministicModel", "[", 
    RowBox[{
     RowBox[{"{", "\"\<Tur\[AAcute]nyi-Gy\[ODoubleDot]rgyi-Field\>\"", "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "1"], ",", 
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", "3"], ",", 
       SubscriptBox["k", "4"], ",", 
       SubscriptBox["k", "5"], ",", 
       SubscriptBox["k", "6"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "p", ",", "a", ",", "z", ",", "m"}], 
      "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7304716017611237`*^9, 3.7304716337924376`*^9}, {
  3.7304717369020123`*^9, 
  3.7304717561676774`*^9}},ExpressionUUID->"8c9ff642-68d4-4bf6-8199-\
3166928f11e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Last", "/@", "dm1"}], "-", 
  RowBox[{"Last", "/@", "dm2"}]}]], "Input",
 CellChangeTimes->{{3.7304717668864503`*^9, 3.7304717714802055`*^9}, {
  3.7304718062458997`*^9, 
  3.730471831074072*^9}},ExpressionUUID->"ec0bc094-395b-4d7d-a1a2-\
8620340eeaa9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 2.4", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 
  3.7292463294989796`*^9}},ExpressionUUID->"02888583-46a6-43da-b6ad-\
fb796494c643"],

Cell[BoxData[
 RowBox[{
  RowBox[{"robertson", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", " ", "\[Rule]", " ", "\"\<B\>\""}], ",", 
     RowBox[{
      RowBox[{"2", "\"\<B\>\""}], "\[Rule]", 
      RowBox[{
       RowBox[{"\"\<B\>\"", "+", "\"\<C\>\""}], "\[Rule]", 
       RowBox[{"\"\<A\>\"", "+", "\"\<C\>\""}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.729246370905309*^9, 
  3.7292464327960553`*^9}},ExpressionUUID->"f0147ad6-22c6-4da2-9854-\
07349a200d04"],

Cell[BoxData[
 RowBox[{"FullForm", "[", "robertson", "]"}]], "Input",
 CellChangeTimes->{{3.7292463329208603`*^9, 3.729246354842778*^9}, 
   3.729246448389835*^9, {3.7304721916841516`*^9, 
   3.7304722571530304`*^9}},ExpressionUUID->"77407ef5-f774-4e92-a801-\
d2fbdd169170"],

Cell[BoxData[
 RowBox[{"TreeForm", "[", "robertson", "]"}]], "Input",
 CellChangeTimes->{{3.7292463329208603`*^9, 3.729246354842778*^9}, 
   3.729246448389835*^9, {3.729246562637645*^9, 
   3.729246568184533*^9}},ExpressionUUID->"a748ca02-d477-465d-8c1c-\
c5d823ab154f"],

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"Level", "[", 
   RowBox[{"robertson", ",", 
    RowBox[{"{", 
     RowBox[{"-", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7292465352469654`*^9, 
  3.72924654613761*^9}},ExpressionUUID->"37c3eb64-928b-4d4c-a2c6-\
238151a19bf5"],

Cell["\<\
A more precise solution (not neglecting real coeffiients) is:\
\>", "Text",
 CellChangeTimes->{{3.7304725012941337`*^9, 
  3.730472544028591*^9}},ExpressionUUID->"8f3d6a81-e2a9-4cdc-845c-\
972296518a53"],

Cell[BoxData[
 RowBox[{"species", "=", 
  RowBox[{"Cases", "[", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"Level", "[", 
      RowBox[{"robertson", ",", 
       RowBox[{"{", 
        RowBox[{"-", "1"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"Except", "[", 
     RowBox[{"_Integer", "|", "_Real"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7292465845908165`*^9, 3.7292465942783337`*^9}, {
  3.730472367028245*^9, 3.7304723689657493`*^9}, {3.7304724638409348`*^9, 
  3.7304724856534767`*^9}},ExpressionUUID->"28a339cb-aca5-4eb0-b2ae-\
7f492e48e04d"],

Cell["Do not forget symbolic coefficents, like \[Pi]: ", "Text",
 CellChangeTimes->{{3.7304725703880177`*^9, 
  3.730472585388048*^9}},ExpressionUUID->"1da08b8c-892d-4f49-9622-\
673ecd58661a"],

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2", ",", "\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\"", ",", "\[Pi]"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"Not", "[", 
     RowBox[{"NumericQ", "[", "#", "]"}], "]"}], "&"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7304725633723803`*^9, 
  3.730472699247645*^9}},ExpressionUUID->"09cda2af-8717-4dd0-b1ff-\
3d86140bc156"],

Cell[BoxData[
 RowBox[{"M", "=", 
  RowBox[{"Length", "[", "species", "]"}]}]], "Input",
 CellChangeTimes->{{3.7292466036533504`*^9, 
  3.729246612747118*^9}},ExpressionUUID->"f50052d8-b04d-494b-9519-\
76b812db7c18"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", "robertson", "]"}], "[", 
  RowBox[{"\"\<M\>\"", ",", "\"\<species\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7292466226846375`*^9, 
  3.729246624747142*^9}},ExpressionUUID->"9e554db4-80e7-428a-9bb2-\
ed621a3f3e32"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 2.5", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.729246643137803*^9, 
  3.7292466433565536`*^9}},ExpressionUUID->"686b446d-c99b-4a7d-b87a-\
ea50f8a83ca5"],

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"revlv", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"X", "\[LeftRightArrow]", 
      RowBox[{"2", "X"}]}], ",", 
     RowBox[{
      RowBox[{"X", "+", "Y"}], "\[LeftRightArrow]", 
      RowBox[{"2", "Y"}]}], ",", 
     RowBox[{"Y", "\[LeftRightArrow]", "0"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.729246664590969*^9, 3.7292467253098383`*^9}, {
  3.7292467557474003`*^9, 3.7292468207006493`*^9}, {3.7302950749415364`*^9, 
  3.730295083379057*^9}, {3.7304735059243217`*^9, 
  3.7304735113305826`*^9}},ExpressionUUID->"0a8cd536-6a21-445a-8155-\
a82f42605c0c"],

Cell["\<\
Note that the FullForm may depend on which sign you use for reversible \
reaction steps.\
\>", "Text",
 CellChangeTimes->{{3.7292468282787895`*^9, 
  3.729246863919484*^9}},ExpressionUUID->"cd096545-2c1e-4514-a96e-\
1fd8343ad322"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"revlv", "/.", 
    RowBox[{
     RowBox[{"LeftRightArrow", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Rule", "[", 
        RowBox[{"a", ",", "b"}], "]"}], ",", 
       RowBox[{"Rule", "[", 
        RowBox[{"b", ",", "a"}], "]"}]}], "}"}]}]}], "//", "Flatten"}], "//", 
  "Union"}]], "Input",
 CellChangeTimes->{{3.7292468849820285`*^9, 3.729246916153961*^9}, {
  3.730473473721133*^9, 3.730473475127386*^9}, {3.730473558440049*^9, 
  3.730473559783803*^9}},ExpressionUUID->"9784a52a-f3b6-49e2-934a-\
516d3c1ea7d4"],

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"Union", ",", 
   RowBox[{
    RowBox[{"ReactionsData", "[", "revlv", "]"}], "[", 
    RowBox[{"\"\<R\>\"", ",", "\"\<reactionsteps\>\""}], "]"}], ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7292469360602493`*^9, 3.7292469377165036`*^9}, {
   3.730295261645029*^9, 3.730295315442008*^9}, {3.730295391692156*^9, 
   3.7302953964109163`*^9}, 3.7304735747369556`*^9, {3.7307357349941826`*^9, 
   3.7307357359372344`*^9}},ExpressionUUID->"bd2caaef-925f-4cce-bfb0-\
718abb18ce15"],

Cell[BoxData[
 RowBox[{"ToReversible", "[", 
  RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7302954363172445`*^9, 
  3.7302954537235284`*^9}},ExpressionUUID->"623badeb-f465-45bf-ab7b-\
5338701adda3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 2.6", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.729246643137803*^9, 3.7292466433565536`*^9}, {3.729246960700923*^9, 
  3.729246961482175*^9}},ExpressionUUID->"7c48e482-72ab-4163-920a-\
f94105cb2b40"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bimol", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[Rule]", "\"\<C\>\""}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[Alpha]", "=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"bimol", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "#"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], "}"}]}], 
    "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Beta]", "=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"bimol", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], "}"}]}], 
    "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.72924697646658*^9, 
  3.729247087169921*^9}},ExpressionUUID->"3b91d052-ad7b-4612-945d-\
f3af958e2918"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReactionsData", "[", "bimol", "]"}], "[", 
   RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\""}], "]"}], "//", 
  "Normal"}]], "Input",
 CellChangeTimes->{{3.7292470356698203`*^9, 3.729247045044838*^9}, {
  3.7292471030605764`*^9, 
  3.729247116607479*^9}},ExpressionUUID->"22e850f7-e6c2-4481-a5a8-\
c26bbb4392c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 2.7", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.729246643137803*^9, 3.7292466433565536`*^9}, {3.729246960700923*^9, 
  3.729246961482175*^9}, {3.729247149357542*^9, 
  3.7292471499356685`*^9}},ExpressionUUID->"cdaadfd7-3c4c-438f-8ea2-\
e19b9cfe8399"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\"\<E\>\"", "+", "\"\<S1\>\""}], "\[DoubleLeftRightArrow]", 
        "\"\<ES1\>\"", "\[DoubleLeftRightArrow]", 
        "\"\<\!\(\*SuperscriptBox[\(ES1\), \(*\)]\)\>\""}], "\[Rule]", 
       RowBox[{
       "\"\<\!\(\*SuperscriptBox[\(E\), \(*\)]\)\>\"", "+", "\"\<P1\>\""}]}], 
      ",", 
      RowBox[{
       RowBox[{
        RowBox[{
        "\"\<\!\(\*SuperscriptBox[\(E\), \(*\)]\)\>\"", "+", "\"\<S2\>\""}], 
        "\[DoubleLeftRightArrow]", 
        "\"\<\!\(\*SuperscriptBox[\(ES2\), \(*\)]\)\>\"", 
        "\[DoubleLeftRightArrow]", "\"\<ES2\>\""}], "\[Rule]", 
       RowBox[{"\"\<E\>\"", "+", "\"\<P2\>\""}]}]}], "}"}], "]"}], "[", 
   "\[Gamma]", "]"}], "//", "MatrixRank"}]], "Input",
 CellChangeTimes->{{3.7292471390450225`*^9, 
  3.729247329154769*^9}},ExpressionUUID->"5de9bd26-0ace-4ede-b2b1-\
1651e4e612d0"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphs of Reactions", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
  3.7105101742965355`*^9, 3.710510175702789*^9}, {3.729247393951771*^9, 
  3.7292473968111515`*^9}},ExpressionUUID->"74f5f79d-413f-413d-8012-\
67dc44e772fb"],

Cell[CellGroupData[{

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"9995a6f1-5b4f-446d-82c1-\
81e60fb18327"],

Cell[CellGroupData[{

Cell["Fig. 14.1", "Subsubsection",
 CellChangeTimes->{{3.728583490789713*^9, 3.728583492893834*^9}, 
   3.7286446988772163`*^9},ExpressionUUID->"241420ed-7fb1-41ec-91b5-\
6df90a11482f"],

Cell[BoxData[
 RowBox[{"wrongwr", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<A\>\"", "->", 
        RowBox[{"\"\<B\>\"", "->", 
         RowBox[{"\"\<C\>\"", "\[Rule]", "\"\<A\>\""}]}]}], ",", 
       RowBox[{"\"\<C\>\"", "\[Rule]", 
        RowBox[{"\"\<D\>\"", "\[Rule]", 
         RowBox[{"\"\<E\>\"", "\[Rule]", 
          RowBox[{"\"\<F\>\"", "\[Rule]", "\"\<D\>\""}]}]}]}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{"x_String", "\[Rule]", 
       RowBox[{"Style", "[", 
        RowBox[{"x", ",", "14", ",", "Bold"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"DirectedEdges", "->", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.714368088719778*^9, 3.7143681773137026`*^9}, {
  3.714541071696868*^9, 3.7145411696345615`*^9}, {3.7302959522088795`*^9, 
  3.730295952615126*^9}},ExpressionUUID->"3382bb97-fcf5-4267-989e-\
013770d1d581"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.1\>\"", ",", "wrongwr"}], "]"}]], "Input",
 CellChangeTimes->{{3.7143682144192667`*^9, 3.7143682179661484`*^9}, {
  3.7285836412703357`*^9, 
  3.728583651904941*^9}},ExpressionUUID->"af4d9c68-cb82-423a-851b-\
d4c13e5d3c68"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.2", "Subsubsection",
 CellChangeTimes->{{3.728583732919093*^9, 3.72858373399722*^9}, 
   3.728644722814764*^9},ExpressionUUID->"aef98bca-eac4-484e-aa79-\
dac1d58f0829"],

Cell[BoxData[
 RowBox[{
  RowBox[{"glyoxylateshort", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<oxaloacetate\>\"", "+", "\"\<acetyl-CoA\>\""}], 
      "\[LeftRightArrow]", "\"\<citrate\>\"", "\[LeftRightArrow]", 
      "\"\<isocitrate\>\"", "\[LeftRightArrow]", 
      RowBox[{"\"\<succinate\>\"", "+", "\"\<glyoxylate\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<glyoxylate\>\"", "+", "\"\<acetyl-CoA\>\""}], 
      "\[LeftRightArrow]", "\"\<malate\>\"", "\[LeftRightArrow]", 
      "\"\<oxaloacetate\>\""}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.634823136669907*^9, 3.63482315551474*^9}, {
  3.6348231949984093`*^9, 3.6348234732560987`*^9}, {3.635424113865218*^9, 
  3.6354241146072607`*^9}, {3.6354245638209543`*^9, 3.6354246256144886`*^9}, {
  3.717312307069481*^9, 
  3.7173123513039427`*^9}},ExpressionUUID->"62529b3c-f83b-40e7-9ef0-\
ee2d969846b7"],

Cell[BoxData[
 RowBox[{"glyox0", "=", 
  RowBox[{"ShowVolpertGraph", "[", 
   RowBox[{
    RowBox[{"{", "glyoxylateshort", "}"}], ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "800"}], ",", 
    RowBox[{"GraphLayout", "->", "\"\<CircularEmbedding\>\""}], ",", 
    RowBox[{"Numbered", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.634823476953305*^9, 3.63482351951118*^9}, {
   3.6348235655156603`*^9, 3.6348235719428716`*^9}, {3.634823629116972*^9, 
   3.634823680912464*^9}, {3.634823870577597*^9, 3.634823884617622*^9}, {
   3.634823998872223*^9, 3.6348240307066746`*^9}, {3.6348240812505655`*^9, 
   3.6348240862908535`*^9}, {3.634824352137424*^9, 3.6348243733846617`*^9}, 
   3.6351393215876365`*^9, {3.6351394805817304`*^9, 3.6351394930494432`*^9}, {
   3.635139529326518*^9, 3.6351395637174854`*^9}, {3.635421523077034*^9, 
   3.635421527004258*^9}, {3.6354241096889796`*^9, 3.635424110365018*^9}, {
   3.635424640271327*^9, 3.6354246412913857`*^9}, {3.710510473203371*^9, 
   3.7105104962815404`*^9}, 
   3.717312364007094*^9},ExpressionUUID->"1e406ab2-97bd-4b41-9769-\
954f3953524b"],

Cell[BoxData[
 RowBox[{"glyox", "=", 
  RowBox[{"ShowVolpertGraph", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", "glyoxylateshort", "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{"x_String", "\[Rule]", 
       RowBox[{"Style", "[", 
        RowBox[{"x", ",", "16", ",", "Bold"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"DirectedEdges", "->", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "800"}], ",", 
    RowBox[{"GraphLayout", "->", "\"\<CircularEmbedding\>\""}], ",", 
    RowBox[{"Numbered", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.634823476953305*^9, 3.63482351951118*^9}, {
   3.6348235655156603`*^9, 3.6348235719428716`*^9}, {3.634823629116972*^9, 
   3.634823680912464*^9}, {3.634823870577597*^9, 3.634823884617622*^9}, {
   3.634823998872223*^9, 3.6348240307066746`*^9}, {3.6348240812505655`*^9, 
   3.6348240862908535`*^9}, {3.634824352137424*^9, 3.6348243733846617`*^9}, 
   3.6351393215876365`*^9, {3.6351394805817304`*^9, 3.6351394930494432`*^9}, {
   3.635139529326518*^9, 3.6351395637174854`*^9}, {3.635421523077034*^9, 
   3.635421527004258*^9}, {3.6354241096889796`*^9, 3.635424110365018*^9}, {
   3.635424640271327*^9, 3.6354246412913857`*^9}, {3.710510473203371*^9, 
   3.7105104962815404`*^9}, {3.717312364007094*^9, 3.7173123844915075`*^9}, {
   3.7173124283040943`*^9, 
   3.7173124465072527`*^9}},ExpressionUUID->"efb21e2b-24bf-4600-b344-\
c21b5da4f035"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.2\>\"", ",", "glyox"}], "]"}]], "Input",
 CellChangeTimes->{{3.7105107020631948`*^9, 3.7105107110163355`*^9}, {
  3.7285837228096995`*^9, 3.7285837273409567`*^9}, {3.728583766356659*^9, 
  3.7285837666691604`*^9}},ExpressionUUID->"fe88d5dc-b86f-403f-9239-\
da684687c7c5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"25e6a0aa-b9e1-402a-b509-\
d0b0661e47f1"],

Cell[CellGroupData[{

Cell["Solution 3.2", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.7292474361549788`*^9, 
  3.7292474380924826`*^9}},ExpressionUUID->"30b8e8e4-756e-4e3e-bae4-\
62fee87df766"],

Cell[BoxData[
 RowBox[{"fhj", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Triangle\>\"", "}"}], "]"}], "[", 
   "\"\<fhjgraphedges\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.711893157502946*^9, 3.711893216283159*^9}, {
   3.7301997782378645`*^9, 3.7301997788316174`*^9}, 
   3.7306096806514378`*^9},ExpressionUUID->"383d3eff-dd89-40f5-96cb-\
3716f5744c0d"],

Cell[BoxData[
 RowBox[{"WeaklyReversibleQ", "[", "fhj", "]"}]], "Input",
 CellChangeTimes->{{3.711894347534434*^9, 
  3.711894359628214*^9}},ExpressionUUID->"9ea70698-6ca6-4c82-8637-\
6bf168ef2925"],

Cell[BoxData[
 RowBox[{"tc", "=", 
  RowBox[{"TransitiveClosureGraph", "[", 
   RowBox[{"Graph", "[", "fhj", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7118937979925375`*^9, 3.7118937988081455`*^9}, {
  3.730968409350458*^9, 
  3.7309684222932*^9}},ExpressionUUID->"0514ad7a-662a-476d-a785-797c23d7dde6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetricGraphQ1", "[", "g_", "]"}], ":=", 
  RowBox[{
   RowBox[{"AdjacencyMatrix", "[", "g", "]"}], "==", 
   RowBox[{"Transpose", "[", 
    RowBox[{"AdjacencyMatrix", "[", "g", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7118936013336625`*^9, 3.7118936462992477`*^9}, {
  3.7118938706276445`*^9, 3.711893885034999*^9}, {3.7118939487367287`*^9, 
  3.711894084987095*^9}},ExpressionUUID->"6e962e61-e6c1-49dc-b4be-\
6e4b0418514a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetricGraphQ2", "[", "g_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", "=", 
      RowBox[{"AdjacencyMatrix", "[", "g", "]"}]}], "}"}], ",", 
    RowBox[{"a", "==", 
     RowBox[{"Transpose", "[", "a", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7118936013336625`*^9, 3.7118936462992477`*^9}, {
   3.7118938706276445`*^9, 3.711893885034999*^9}, {3.7118939487367287`*^9, 
   3.711893996752528*^9}, 
   3.7118941157801423`*^9},ExpressionUUID->"428b891c-cdf6-461e-a9a1-\
ac14bd83c093"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetricGraphQ3", "[", "g_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{"AdjacencyMatrix", "[", "g", "]"}]}], ";", 
    RowBox[{"a", "==", 
     RowBox[{"Transpose", "[", "a", "]"}]}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.7118936013336625`*^9, 3.7118936462992477`*^9}, {
  3.7118938706276445`*^9, 3.711893885034999*^9}, {3.7118939487367287`*^9, 
  3.711894183778598*^9}},ExpressionUUID->"0e478a40-8c4a-47f0-a66c-\
c59a785ef8f2"],

Cell[BoxData[
 RowBox[{"SymmetricGraphQ1", "[", "tc", "]"}]], "Input",
 CellChangeTimes->{{3.711893657920215*^9, 3.711893688221417*^9}, {
   3.7118938104589667`*^9, 3.711893811377427*^9}, {3.711893899409066*^9, 
   3.711893904050638*^9}, 3.711894003991549*^9, 
   3.7118941917047987`*^9},ExpressionUUID->"3df61e14-55f4-409a-a0d2-\
be93a556fe84"],

Cell[BoxData[
 RowBox[{"SymmetricGraphQ2", "[", "tc", "]"}]], "Input",
 CellChangeTimes->{{3.711893657920215*^9, 3.711893688221417*^9}, {
   3.7118938104589667`*^9, 3.711893811377427*^9}, {3.711893899409066*^9, 
   3.711893904050638*^9}, 3.711894003991549*^9, {3.7118940491250334`*^9, 
   3.711894052158631*^9}, {3.711894194817268*^9, 
   3.7118941951276445`*^9}},ExpressionUUID->"8a6c56f2-527e-432f-a000-\
a63d699dc76f"],

Cell[BoxData[
 RowBox[{"SymmetricGraphQ3", "[", "tc", "]"}]], "Input",
 CellChangeTimes->{{3.711893657920215*^9, 3.711893688221417*^9}, {
   3.7118938104589667`*^9, 3.711893811377427*^9}, {3.711893899409066*^9, 
   3.711893904050638*^9}, 3.711894003991549*^9, {3.7118940491250334`*^9, 
   3.711894052158631*^9}, {3.711894194817268*^9, 3.7118941951276445`*^9}, {
   3.7309684492114725`*^9, 
   3.7309684528521037`*^9}},ExpressionUUID->"612a6ebe-ddb5-4cc3-85bf-\
c932ea83193d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 3.3", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.7292474361549788`*^9, 3.7292474380924826`*^9}, {3.7292475436864395`*^9, 
  3.7292475440301895`*^9}},ExpressionUUID->"a4367548-a5fd-4845-8b88-\
831c67e42833"],

Cell[BoxData[
 RowBox[{"rg", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "\"\<Robertson\>\"", "}"}], "]"}], "[", 
    "\"\<fhjgraphedges\>\"", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.711945180341221*^9, 3.71194522472563*^9}, {
  3.7301998060972924`*^9, 3.730199806722294*^9}, {3.730296405116012*^9, 
  3.7302964058816414`*^9}, {3.730968655868126*^9, 
  3.7309686701806536`*^9}},ExpressionUUID->"25d6b05d-1690-4229-8464-\
be6bae2ff600"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"IncidenceMatrix", "[", "rg", "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"VertexList", "[", "rg", "]"}], ",", 
      RowBox[{"EdgeList", "[", "rg", "]"}]}], "}"}]}], ",", 
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.711945236771609*^9, 3.711945302829378*^9}, {
  3.730296409147271*^9, 
  3.730296416897287*^9}},ExpressionUUID->"be459b77-7388-45e3-9c70-\
0d99aa14e6eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 3.4", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.7292474361549788`*^9, 3.7292474380924826`*^9}, {3.7292475436864395`*^9, 
  3.7292475440301895`*^9}, {3.729247699311743*^9, 
  3.7292476997179937`*^9}},ExpressionUUID->"04696935-6fa0-490e-9ba4-\
059b2ddec404"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ReactionsData", "[", "#", "]"}], "[", "\"\<deficiency\>\"", 
     "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], ",", 
     RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
     RowBox[{"{", "\"\<Robertson\>\"", "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7292476272803526`*^9, 
  3.7292476411553793`*^9}},ExpressionUUID->"34795c7f-507d-43f7-9b4a-\
df9cf5933d40"],

Cell["The result changes if external species are eliminated.", "Text",
 CellChangeTimes->{{3.7292476707960625`*^9, 
  3.7292476844992137`*^9}},ExpressionUUID->"601b9481-55e4-4e61-a7cf-\
9eb9fbad7f73"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
  "\"\<deficiency\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7119453172459307`*^9, 
  3.7119453955798316`*^9}},ExpressionUUID->"af7529ed-fbf2-4e36-bb5e-\
344cf5fc9329"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 3.7", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.7292474361549788`*^9, 3.7292474380924826`*^9}, {3.7292475436864395`*^9, 
  3.7292475440301895`*^9}, {3.7292477316555557`*^9, 
  3.7292477325930576`*^9}},ExpressionUUID->"2624526d-8223-4a43-8d58-\
23679f6a145d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "#", "}"}], "]"}], "[", "\"\<deficiency\>\"", "]"}], "&"}], 
  "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", "\[Rule]", 
      RowBox[{"X", "\[Rule]", 
       RowBox[{"2", "X"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"X", "\[Rule]", 
       RowBox[{"Z", "+", "X"}]}], ",", 
      RowBox[{"Y", "\[Rule]", 
       RowBox[{"Z", "+", "Y"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"X", "\[Rule]", 
      RowBox[{"2", "X"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7119456320244913`*^9, 
  3.7119457101912823`*^9}},ExpressionUUID->"6ca6a89a-f9eb-487d-a6f7-\
fb9542a01840"]
}, Open  ]],

Cell["Solution 3.8", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.7292474361549788`*^9, 3.7292474380924826`*^9}, {3.7292475436864395`*^9, 
  3.7292475440301895`*^9}, {3.7292477655774975`*^9, 
  3.7292477665462494`*^9}},ExpressionUUID->"728c135f-128e-4320-82a1-\
1d4bd3482996"],

Cell[CellGroupData[{

Cell["1.", "Subsection",
 CellChangeTimes->{{3.711947267836322*^9, 
  3.711947268483751*^9}},ExpressionUUID->"200c7679-de42-4b74-a41d-\
b05a9f4f4078"],

Cell[BoxData[
 RowBox[{
  RowBox[{"complexes", "[", "reaction_", "]"}], ":=", 
  RowBox[{"Union", "@", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"ReplaceAll", "[", 
      RowBox[{
       RowBox[{"h_", "[", "x___", "]"}], "\[Rule]", 
       RowBox[{"List", "[", "x", "]"}]}], "]"}], "/@", "reaction"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.711945740533387*^9, 3.7119458545179076`*^9}, {
  3.711946084067999*^9, 3.711946099364132*^9}, {3.7119461370511045`*^9, 
  3.7119461496044197`*^9}, {3.711946195826044*^9, 3.7119462079130535`*^9}, {
  3.7119465856143045`*^9, 
  3.711946595068569*^9}},ExpressionUUID->"80e38466-fda5-4530-8162-\
4cf40614243b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalNu]", "[", "reaction_", "]"}], ":=", 
  RowBox[{"Length", "[", 
   RowBox[{"complexes", "[", "reaction", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7292478079838305`*^9, 
  3.7292478468120313`*^9}},ExpressionUUID->"b1a8a8d5-e042-460e-9578-\
772c196e5b32"],

Cell[BoxData[
 RowBox[{"Sort", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"complexes", "[", 
     RowBox[{"GetReaction", "[", "\"\<Lotka-Volterra\>\"", "]"}], "]"}], ",", 
    RowBox[{
     RowBox[{"ReactionsData", "[", 
      RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}], "[", 
     "\"\<complexes\>\"", "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.71194585976038*^9, 3.711946036850713*^9}, {
   3.7119466071095457`*^9, 3.711946617987753*^9}, 3.7287982031682963`*^9, {
   3.72924787296833*^9, 3.729247908562153*^9}, 3.729248194015835*^9, {
   3.7302965626788225`*^9, 
   3.730296565647578*^9}},ExpressionUUID->"e4466623-19f0-4715-b304-\
989d5304a15b"],

Cell["How to show that they are identical? First possibility:", "Text",
 CellChangeTimes->{{3.729248095250017*^9, 
  3.729248109828171*^9}},ExpressionUUID->"57e02b24-364a-4302-bd14-\
43816fe8e24f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"symmetricDifference", "[", 
   RowBox[{"A_", ",", "B_"}], "]"}], ":=", 
  RowBox[{"Union", "[", 
   RowBox[{
    RowBox[{"Complement", "[", 
     RowBox[{"A", ",", "B"}], "]"}], ",", 
    RowBox[{"Complement", "[", 
     RowBox[{"B", ",", "A"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.72924792507781*^9, 3.729247925827811*^9}, {
  3.7292480033123374`*^9, 
  3.729248055609315*^9}},ExpressionUUID->"5f69756c-363b-4aa0-9136-\
cdff4e01a4f2"],

Cell[BoxData[
 RowBox[{"symmetricDifference", "[", 
  RowBox[{
   RowBox[{"complexes", "[", 
    RowBox[{"GetReaction", "[", "\"\<Lotka-Volterra\>\"", "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}], "[", 
    "\"\<complexes\>\"", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.729248059718698*^9, 3.7292480806718645`*^9}, 
   3.729248188500201*^9},ExpressionUUID->"4f3ddad8-578b-4428-82ca-\
9c1191aeb694"],

Cell["Second possibility :", "Text",
 CellChangeTimes->{{3.7292481137813034`*^9, 
  3.729248126421953*^9}},ExpressionUUID->"ac3b620a-d097-44a7-94a3-\
75871ba16990"],

Cell[BoxData[
 RowBox[{"Equal", "@@", 
  RowBox[{"Sort", "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"complexes", "[", 
      RowBox[{"GetReaction", "[", "\"\<Lotka-Volterra\>\"", "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"ReactionsData", "[", 
       RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], "]"}], "[", 
      "\"\<complexes\>\"", "]"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7302966066007824`*^9, 
  3.7302966090539117`*^9}},ExpressionUUID->"fe6510be-1ece-4127-aacf-\
d4e5dd98eff4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.", "Subsection",
 CellChangeTimes->{{3.7119472879156237`*^9, 
  3.711947289163452*^9}},ExpressionUUID->"89531241-f0c5-4027-8b37-\
d82a1e722fc7"],

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<X\>\""}], "\[Rule]", 
      RowBox[{"2", " ", "\"\<X\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", 
      RowBox[{"2", " ", "\"\<Y\>\""}]}], ",", 
     RowBox[{"\"\<Y\>\"", "->", "\"\<B\>\""}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.711947295273499*^9, 3.7119473050209584`*^9}, {
  3.711947381643725*^9, 
  3.7119474277312613`*^9}},ExpressionUUID->"dace345e-55c4-4ac1-b883-\
38af22df58c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.", "Subsection",
 CellChangeTimes->{{3.7119477443980722`*^9, 
  3.7119477447903337`*^9}},ExpressionUUID->"dd4b7dad-2d2f-4ab9-99c7-\
7b78a18ed5fb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\[Alpha]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[Alpha]", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"DeleteCases", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Alpha]", "[", 
            RowBox[{"[", 
             RowBox[{"m", ",", "r"}], "]"}], "]"}], "\[NotEqual]", "0"}], ",", 
          RowBox[{"Labeled", "[", 
           RowBox[{
            RowBox[{"DirectedEdge", "[", 
             RowBox[{
              RowBox[{"X", "[", "m", "]"}], ",", "r"}], "]"}], ",", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"[", 
              RowBox[{"m", ",", "r"}], "]"}], "]"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "3"}], "}"}]}], "]"}], "]"}], ",", "Null"}], "]"}],
    ",", 
   RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.711947747988453*^9, 3.7119477492873135`*^9}, {
  3.7119479674758773`*^9, 3.7119480113869705`*^9}, {3.7292482720941133`*^9, 
  3.72924828867227*^9}, {3.730296731413526*^9, 3.730296745022929*^9}, {
  3.730519586088048*^9, 
  3.730519591822433*^9}},ExpressionUUID->"25406c21-31c6-4207-86da-\
a1c65d1fda19"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.", "Subsection",
 CellChangeTimes->{{3.711951090358988*^9, 
  3.7119510909743943`*^9}},ExpressionUUID->"ed00efb4-b68f-4d90-8597-\
3432323c5f06"],

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"WeaklyConnectedComponents", "[", 
   RowBox[{"Graph", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\"\<A\>\"", "+", "\"\<X\>\""}], "\[Rule]", 
       RowBox[{"2", "\"\<X\>\""}]}], ",", 
      RowBox[{
       RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", 
       RowBox[{"2", "\"\<Y\>\""}]}], ",", 
      RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<Y\>\""}]}], "}"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.711951092989729*^9, 
  3.7119511281510267`*^9}},ExpressionUUID->"f363c0ea-63f4-4afc-88f8-\
95dbe12a2b03"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\"\<A\>\"", "+", "\"\<X\>\""}], "\[Rule]", 
       RowBox[{"2", "\"\<X\>\""}]}], ",", 
      RowBox[{
       RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", 
       RowBox[{"2", "\"\<Y\>\""}]}], ",", 
      RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<Y\>\""}]}], "}"}], "]"}], "[", 
   "\"\<fhjweaklyconnectedcomponents\>\"", "]"}], "//", "Length"}]], "Input",
 CellChangeTimes->{{3.7119511328881655`*^9, 3.711951172949708*^9}, {
  3.7292484204381533`*^9, 
  3.729248422485032*^9}},ExpressionUUID->"8292c61c-1fa4-4e18-884d-\
f15383ef4a9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\"\<A\>\"", "+", "\"\<X\>\""}], "\[Rule]", 
        RowBox[{"2", "\"\<X\>\""}]}], ",", 
       RowBox[{
        RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", 
        RowBox[{"2", "\"\<Y\>\""}]}], ",", 
       RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<Y\>\""}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
   "\"\<fhjweaklyconnectedcomponents\>\"", "]"}], "//", "Length"}]], "Input",
 CellChangeTimes->{{3.7119511328881655`*^9, 3.711951166625517*^9}, 
   3.7292484391725645`*^9},ExpressionUUID->"3fedf357-fa75-45ce-89c8-\
c8d86c7fc67c"],

Cell[CellGroupData[{

Cell["Solution 3.9", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.7292474361549788`*^9, 3.7292474380924826`*^9}, {3.7292475436864395`*^9, 
  3.7292475440301895`*^9}, {3.7292477655774975`*^9, 3.7292477665462494`*^9}, {
  3.729248476297638*^9, 
  3.729248477485139*^9}},ExpressionUUID->"c7223ef0-1d77-4f86-9c23-\
6e183041ea14"],

Cell["See among the Figures.", "Text",
 CellChangeTimes->{{3.711951553240676*^9, 
  3.7119515596329117`*^9}},ExpressionUUID->"3bbe6cd1-3181-461c-bdc6-\
930c1967116a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 3.10", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.7292474361549788`*^9, 3.7292474380924826`*^9}, {3.7292475436864395`*^9, 
  3.7292475440301895`*^9}, {3.7292477655774975`*^9, 3.7292477665462494`*^9}, {
  3.7292485050789433`*^9, 
  3.72924850606332*^9}},ExpressionUUID->"8c1695a0-b6cb-4f98-a36b-\
5b40624c0edd"],

Cell[BoxData[
 RowBox[{"Row", "@", 
  RowBox[{"VolpertIndexing", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<\!\(\*SubscriptBox[\(Cl\), \(2\)]\)\>\"", "\[Rule]", 
       RowBox[{"2", "\"\<\!\(\*SuperscriptBox[\(Cl\), \(*\)]\)\>\""}]}], ",", 
      RowBox[{
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(CH\), \(4\)]\)\>\"", "+", 
        "\"\<\!\(\*SuperscriptBox[\(Cl\), \(*\)]\)\>\""}], "\[Rule]", 
       RowBox[{
       "\"\<*\!\(\*SubscriptBox[\(CH\), \(3\)]\)\>\"", "+", "\"\<HCl\>\""}]}],
       ",", 
      RowBox[{
       RowBox[{
       "\"\<*\!\(\*SubscriptBox[\(CH\), \(3\)]\)\>\"", "+", 
        "\"\<\!\(\*SubscriptBox[\(Cl\), \(2\)]\)\>\""}], "\[Rule]", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(CH\), \(3\)]\)Cl\>\"", "+", 
        "\"\<\!\(\*SuperscriptBox[\(Cl\), \(*\)]\)\>\""}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(Cl\), \(2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(CH\), \(4\)]\)\>\""}], "}"}], ",", 
    RowBox[{"Verbose", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7119518974597416`*^9, 3.711951910157155*^9}, {
   3.7119519973879523`*^9, 3.7119521547802343`*^9}, 3.711952198477186*^9, {
   3.7119522436170945`*^9, 3.711952274173341*^9}, 3.71195230506781*^9, {
   3.7119525005283155`*^9, 3.711952550096157*^9}, {3.7119525831750727`*^9, 
   3.7119526142326517`*^9}, {3.7305198045728517`*^9, 
   3.73051980786973*^9}},ExpressionUUID->"fc1b85c3-8720-417f-84f0-\
b8d63056c02f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 3.11", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.7292474361549788`*^9, 3.7292474380924826`*^9}, {3.7292475436864395`*^9, 
  3.7292475440301895`*^9}, {3.7292477655774975`*^9, 3.7292477665462494`*^9}, {
  3.7292485050789433`*^9, 
  3.7292485325321226`*^9}},ExpressionUUID->"e652972d-74d5-451b-949f-\
547f5dd8fc19"],

Cell[BoxData[
 RowBox[{"Row", "@", 
  RowBox[{"VolpertIndexing", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<\!\(\*SubscriptBox[\(Cl\), \(2\)]\)\>\"", "\[Rule]", 
       RowBox[{"2", "\"\<\!\(\*SuperscriptBox[\(Cl\), \(*\)]\)\>\""}]}], ",", 
      RowBox[{
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(CH\), \(4\)]\)\>\"", "+", 
        "\"\<\!\(\*SuperscriptBox[\(Cl\), \(*\)]\)\>\""}], "\[Rule]", 
       RowBox[{
       "\"\<*\!\(\*SubscriptBox[\(CH\), \(3\)]\)\>\"", "+", "\"\<HCl\>\""}]}],
       ",", 
      RowBox[{
       RowBox[{
       "\"\<*\!\(\*SubscriptBox[\(CH\), \(3\)]\)\>\"", "+", 
        "\"\<\!\(\*SubscriptBox[\(Cl\), \(2\)]\)\>\""}], "\[Rule]", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(CH\), \(3\)]\)Cl\>\"", "+", 
        "\"\<\!\(\*SuperscriptBox[\(Cl\), \(*\)]\)\>\""}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SuperscriptBox[\(Cl\), \(*\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(CH\), \(4\)]\)\>\""}], "}"}], ",", 
    RowBox[{"Verbose", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7119518974597416`*^9, 3.711951910157155*^9}, {
   3.7119519973879523`*^9, 3.7119521547802343`*^9}, 3.711952198477186*^9, {
   3.7119522436170945`*^9, 3.711952274173341*^9}, 3.71195230506781*^9, {
   3.7119525005283155`*^9, 3.711952550096157*^9}, {3.7119525831750727`*^9, 
   3.7119526142326517`*^9}, {3.7119526770672836`*^9, 
   3.7119526814671965`*^9}, {3.730519818979127*^9, 
   3.730519821088507*^9}},ExpressionUUID->"7c621ec4-7ae7-4965-8779-\
60e52da2a578"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 3.14", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.7292474361549788`*^9, 3.7292474380924826`*^9}, {3.7292475436864395`*^9, 
  3.7292475440301895`*^9}, {3.7292477655774975`*^9, 3.7292477665462494`*^9}, {
  3.7292485050789433`*^9, 3.72924850606332*^9}, {3.7292485747978296`*^9, 
  3.7292485755947065`*^9}, {3.729248613141655*^9, 
  3.729248614001032*^9}},ExpressionUUID->"fe0088af-031a-4844-952c-\
5319a8f55dd6"],

Cell[BoxData[
 RowBox[{"AcyclicGraphQ", "[", 
  RowBox[{"Graph", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"X", "\[Rule]", "Y"}], ",", 
     RowBox[{
      RowBox[{"X", "+", "Y"}], "\[Rule]", "Z"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7119529057127757`*^9, 3.7119529594243617`*^9}, {
  3.711953013010868*^9, 3.711953035767946*^9}, {3.730199882284943*^9, 
  3.730199885519323*^9}},ExpressionUUID->"b3dbbe8c-3d69-4694-ab96-\
e3d60e462e96"],

Cell[BoxData[
 RowBox[{"AcyclicVolpertGraphQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"X", "\[Rule]", "Y"}], ",", 
    RowBox[{
     RowBox[{"X", "+", "Y"}], "\[Rule]", "Z"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7306121579631405`*^9, 3.7306121789631805`*^9}, {
  3.730612293119656*^9, 
  3.730612301494672*^9}},ExpressionUUID->"42d836af-b346-426a-9b08-\
91216021ebfc"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mass conservation", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
   3.7105101937340746`*^9, 3.710510199765337*^9}, 
   3.7187230996820645`*^9},ExpressionUUID->"30846070-2302-4063-a8fc-\
54777ad90997"],

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"96500001-0ec9-44de-aa3f-\
07ec80e2298f"],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"e63a440d-529d-4e75-9ecf-\
e47ffa69b4d8"],

Cell[CellGroupData[{

Cell["Solution 4.3", "Subsubsection",
 CellChangeTimes->{{3.7292463221864643`*^9, 3.7292463294989796`*^9}, {
  3.7292474361549788`*^9, 3.7292474380924826`*^9}, {3.7292475436864395`*^9, 
  3.7292475440301895`*^9}, {3.7292477655774975`*^9, 3.7292477665462494`*^9}, {
  3.7292485050789433`*^9, 3.72924850606332*^9}, {3.7292485747978296`*^9, 
  3.7292485755947065`*^9}, {3.729248613141655*^9, 3.729248614001032*^9}, {
  3.7292487280637555`*^9, 
  3.729248730641885*^9}},ExpressionUUID->"700b2469-c836-421c-8193-\
5f2529892bd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MQ", "[", 
    RowBox[{"gamma_", ",", "m_", ",", "r_"}], "]"}], ":=", 
   RowBox[{"Quiet", "[", 
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{"Maximize", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"lambda", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Transpose", "[", "gamma", "]"}], ".", 
            RowBox[{"Array", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"rho", "[", "#", "]"}], "&"}], ",", "m"}], "]"}]}], 
           "\[Equal]", 
           RowBox[{"ConstantArray", "[", 
            RowBox[{"0", ",", "r"}], "]"}]}], ",", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{"Array", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"rho", "[", "#", "]"}], "&"}], ",", "m"}], "]"}], 
            "\[GreaterEqual]", 
            RowBox[{"lambda", " ", 
             RowBox[{"ConstantArray", "[", 
              RowBox[{"1", ",", "m"}], "]"}]}]}], "]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Array", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"rho", "[", "#", "]"}], "&"}], ",", "m"}], "]"}], ".", 
            RowBox[{"ConstantArray", "[", 
             RowBox[{"1", ",", "m"}], "]"}]}], "\[Equal]", "1"}]}], "}"}], 
        ",", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"rho", "[", "#", "]"}], "&"}], ",", "m"}], "]"}], ",", 
          RowBox[{"{", "lambda", "}"}]}], "]"}]}], "]"}], "]"}], ">", "0"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.730200203332444*^9, 3.7302002236553974`*^9}, {
  3.730200281862748*^9, 3.7302002965034013`*^9}, {3.7307363019242196`*^9, 
  3.7307363801743727`*^9}},ExpressionUUID->"c3dd5d31-f50e-46fa-ac48-\
b897b19883d0"],

Cell["Let us try the function on the given examples.", "Text",
 CellChangeTimes->{{3.730297360461632*^9, 3.730297386039807*^9}, {
  3.7302976523767414`*^9, 
  3.7302976595486298`*^9}},ExpressionUUID->"8116872d-fc4e-4534-858d-\
16445e89f9e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"reac1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[DoubleLeftRightArrow]", 
      "\"\<C\>\""}], "\[Rule]", 
     RowBox[{
      RowBox[{"2", "\"\<D\>\""}], "\[DoubleLeftRightArrow]", 
      RowBox[{"\"\<B\>\"", "+", "\"\<E\>\""}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7302982938311243`*^9, 
  3.730298309174901*^9}},ExpressionUUID->"355e5601-a0d6-4d11-8aaa-\
caecb751ff39"],

Cell[BoxData[
 RowBox[{"ex1", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Gamma]1", ",", "m1", ",", "r1"}], "}"}], "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", "reac1", "]"}], "[", 
    RowBox[{"\[Gamma]", ",", "\"\<M\>\"", ",", "\"\<R\>\""}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7302975470640373`*^9, 3.73029757251721*^9}, {
  3.7302976648767653`*^9, 3.7302976667673965`*^9}, {3.730298302346763*^9, 
  3.7302983038311405`*^9}},ExpressionUUID->"7e3940fd-cf6f-4939-94f8-\
e8f8a5f827ff"],

Cell[BoxData[
 RowBox[{"MQ", "@@", "ex1"}]], "Input",
 CellChangeTimes->{{3.730297678501794*^9, 
  3.7302976844705544`*^9}},ExpressionUUID->"2dee84ff-cd5a-4d24-8779-\
f71c59bda91e"],

Cell[BoxData[
 RowBox[{"m1", "-", 
  RowBox[{"MatrixRank", "[", "\[Gamma]1", "]"}]}]], "Input",
 CellChangeTimes->{{3.730297803642663*^9, 
  3.7302978181270657`*^9}},ExpressionUUID->"6dd99a47-3050-4166-ad33-\
71e1a2912ae7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"m1", ",", 
   RowBox[{"MatrixRank", "[", "\[Gamma]1", "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.730297803642663*^9, 3.7302978181270657`*^9}, {
  3.730298257549801*^9, 
  3.7302982672841945`*^9}},ExpressionUUID->"f1b84ad6-02e3-48ad-be1e-\
81dade3aed67"],

Cell[BoxData[
 RowBox[{"MassConservationRelations", "[", 
  RowBox[{"{", "reac1", "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.730298391096938*^9, 
  3.730298392050063*^9}},ExpressionUUID->"93c0fef9-168f-4e13-ba41-\
8855044d2e55"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{"{", "reac1", "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.730298391096938*^9, 3.730298392050063*^9}, {
  3.7308772551034746`*^9, 
  3.730877260009736*^9}},ExpressionUUID->"0caefb9d-1b8c-4657-b261-\
de5d65bccb22"],

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"MassConservationRelations", "[", "reac1", "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"ReactionsData", "[", "reac1", "]"}], "[", "\"\<variables\>\"", 
     "]"}], "/.", 
    RowBox[{"c", "\[Rule]", "\[Rho]"}]}], ",", "Integers"}], "]"}]], "Input",
 CellChangeTimes->{{3.7292488625327663`*^9, 3.7292490281580915`*^9}, {
  3.7292491127207565`*^9, 3.729249149205203*^9}, {3.7301306681196413`*^9, 
  3.730130676030094*^9}, {3.7302004119880004`*^9, 3.7302004385789237`*^9}, {
  3.7302984008469543`*^9, 
  3.730298411878228*^9}},ExpressionUUID->"654eaf1d-1b78-4478-ab62-\
65a5c0aafa49"],

Cell[BoxData[
 RowBox[{
  RowBox[{"reac2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "\"\<M\>\""}], "+", "\"\<N2\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<M\>\""}], "\[Rule]", 
      RowBox[{"\"\<CH4\>\"", "+", "\"\<B\>\""}]}], ",", 
     RowBox[{
      RowBox[{"2", "\"\<M\>\""}], "\[Rule]", "\"\<C2H6\>\""}], ",", 
     RowBox[{
      RowBox[{"\"\<M\>\"", "+", "\"\<B\>\""}], "\[Rule]", "\"\<MED\>\""}], 
     ",", 
     RowBox[{
      RowBox[{"\"\<M\>\"", "+", "\"\<A\>\""}], "\[Rule]", "\"\<C\>\""}], ",", 
     RowBox[{
      RowBox[{"\"\<M\>\"", "+", "\"\<C\>\""}], "\[Rule]", "\"\<TMH\>\""}]}], 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.730298319815547*^9, 
  3.7302983338936987`*^9}},ExpressionUUID->"4c2e08fc-da4f-4528-ab8c-\
b28c9bffaf34"],

Cell[BoxData[
 RowBox[{"ex2", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Gamma]2", ",", "m2", ",", "r2"}], "}"}], "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", "reac2", "]"}], "[", 
    RowBox[{"\[Gamma]", ",", "\"\<M\>\"", ",", "\"\<R\>\""}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7302976182516747`*^9, 3.730297626095441*^9}, {
  3.730297670642401*^9, 3.730297672204905*^9}, {3.730298328784315*^9, 
  3.730298330284317*^9}},ExpressionUUID->"2083f16c-b8b5-4eac-a72b-\
f0a0e7a21453"],

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MQ", "@@", "ex2"}], ",", 
    RowBox[{"m2", "-", 
     RowBox[{"MatrixRank", "[", "\[Gamma]2", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"m2", ",", 
      RowBox[{"MatrixRank", "[", "\[Gamma]2", "]"}]}], "}"}], ",", 
    RowBox[{"MassConservationRelations", "[", 
     RowBox[{"{", "reac2", "}"}], "]"}], ",", 
    RowBox[{"FindInstance", "[", 
     RowBox[{
      RowBox[{"MassConservationRelations", "[", "reac2", "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"ReactionsData", "[", "reac2", "]"}], "[", 
        "\"\<variables\>\"", "]"}], "/.", 
       RowBox[{"c", "\[Rule]", "\[Rho]"}]}], ",", "Integers"}], "]"}]}], 
   "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7302984533626833`*^9, 
  3.730298539128476*^9}},ExpressionUUID->"5bdb689b-354d-400d-aea8-\
c2b72fdacbb9"],

Cell["\<\
An alternative solution may give simpler solutions for the mass vector.\
\>", "Text",
 CellChangeTimes->{{3.730298718613201*^9, 
  3.730298741816372*^9}},ExpressionUUID->"153dad8d-eee5-4206-ba85-\
df0cd2973157"],

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Rho]", "[", "#", "]"}], "&"}], ",", "m1"}], "]"}], ".", 
        RowBox[{
         RowBox[{"ReactionsData", "[", "reac1", "]"}], "[", "\[Gamma]", 
         "]"}]}], "\[Equal]", "0"}], "]"}], ",", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"Array", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Rho]", "[", "#", "]"}], "&"}], ",", "m1"}], "]"}], ">", 
       "0"}], "]"}]}], "]"}], ",", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Rho]", "[", "#", "]"}], "&"}], ",", "m1"}], "]"}], ",", 
   "Integers"}], "]"}]], "Input",
 CellChangeTimes->{{3.7292493051079173`*^9, 3.729249430920663*^9}, {
  3.7302986220192647`*^9, 
  3.730298643613055*^9}},ExpressionUUID->"dee973b2-ebdc-4cf3-b6f0-\
38a323c9b4a2"],

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Rho]", "[", "#", "]"}], "&"}], ",", "m2"}], "]"}], ".", 
        RowBox[{
         RowBox[{"ReactionsData", "[", "reac2", "]"}], "[", "\[Gamma]", 
         "]"}]}], "\[Equal]", "0"}], "]"}], ",", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"Array", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Rho]", "[", "#", "]"}], "&"}], ",", "m2"}], "]"}], ">", 
       "0"}], "]"}]}], "]"}], ",", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Rho]", "[", "#", "]"}], "&"}], ",", "m2"}], "]"}], ",", 
   "Integers"}], "]"}]], "Input",
 CellChangeTimes->{{3.7292493051079173`*^9, 3.7292493794986873`*^9}, {
   3.7292512901960726`*^9, 3.7292513579305797`*^9}, {3.729251390055642*^9, 
   3.7292514906183367`*^9}, 3.7292516079466934`*^9, {3.729251939837967*^9, 
   3.7292519454629803`*^9}, {3.7302986711756086`*^9, 
   3.7302987076756797`*^9}},ExpressionUUID->"4ddbf31a-f72a-445b-a51d-\
12c598091c25"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Decompositions", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
  3.71051020984348*^9, 
  3.7105102156559916`*^9}},ExpressionUUID->"1544e1a3-e5ec-49c1-992f-\
0dc8b7e6309b"],

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"72194827-c20d-4967-896a-\
97aaa9124d8d"],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"337e1685-a9be-4d63-9965-\
72af25a70bc9"],

Cell[CellGroupData[{

Cell["Solution 5.2", "Subsubsection",
 CellChangeTimes->{{3.7302009096865873`*^9, 
  3.730200923077238*^9}},ExpressionUUID->"978e3b0d-2117-439b-901e-\
ec26bc881ed4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MLD", "[", "M_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "#", "]"}], "\[Equal]", "1"}], "&&", 
     RowBox[{
      RowBox[{"Min", "[", 
       RowBox[{"Abs", "[", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ">", "0"}]}], "&"}], 
   "[", 
   RowBox[{"NullSpace", "[", 
    RowBox[{"Transpose", "[", "M", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.71239159032568*^9, 
  3.71239159032568*^9}},ExpressionUUID->"745cfe19-fedf-4df9-b593-\
92ab395fefdf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Z", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "2", ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "1", ",", "1", ",", "0", ",", "1"}], 
      "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7123916446056213`*^9, 
  3.7123916799972925`*^9}},ExpressionUUID->"fb14dc53-8fae-4065-a32e-\
15dcc75a478a"],

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Transpose", "[", "Z", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7302990848951693`*^9, 
  3.730299100692075*^9}},ExpressionUUID->"635b7957-40f9-4831-a11e-\
efd1d9bf873a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"Rest", "[", 
    RowBox[{"Subsets", "[", 
     RowBox[{"Transpose", "[", "Z", "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7123916893409224`*^9, 3.712391712996783*^9}, 
   3.730200986592986*^9},ExpressionUUID->"0dd82378-6dea-429d-be7b-\
6da51a0534f1"],

Cell[BoxData[
 RowBox[{"Column", "/@", 
  RowBox[{"(", 
   RowBox[{"sel", "=", 
    RowBox[{"Select", "[", 
     RowBox[{"r", ",", 
      RowBox[{
       RowBox[{"MLD", "[", "#", "]"}], "&"}]}], "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.7302988718791294`*^9, 3.7302988932229185`*^9}, {
  3.730298930301115*^9, 3.7302989416917624`*^9}, {3.7302991965203867`*^9, 
  3.730299204504777*^9}},ExpressionUUID->"72e409f8-6158-4d0a-af81-\
310924453267"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 5.3", "Subsubsection",
 CellChangeTimes->{{3.7302009096865873`*^9, 3.730200923077238*^9}, {
  3.730201019733677*^9, 
  3.7302010199211764`*^9}},ExpressionUUID->"0225fc2b-ff1f-4d74-bfbc-\
708d382d20cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DependenceType", "[", 
   RowBox[{"A_", ",", "set_"}], "]"}], ":=", 
  RowBox[{"Switch", "[", 
   RowBox[{
    RowBox[{"NullSpace", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"A", "\[LeftDoubleBracket]", "set", "\[RightDoubleBracket]"}], 
      "]"}], "]"}], ",", 
    RowBox[{"{", "}"}], ",", "\"\<I\>\"", ",", 
    RowBox[{"_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "#", "]"}], "\[GreaterEqual]", "2"}], "||", 
        RowBox[{
         RowBox[{"Min", "[", 
          RowBox[{"Abs", "[", "#", "]"}], "]"}], "\[Equal]", "0"}]}], "&"}], 
      ")"}]}], ",", "\"\<D\>\"", ",", "_", ",", "\"\<S\>\""}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.712391913824441*^9, 3.712391913824441*^9}, 
   3.712392004871432*^9, {3.7302990246606755`*^9, 
   3.7302990296450596`*^9}},ExpressionUUID->"b08a641b-e50e-498f-813d-\
e25d5a4a2eb7"],

Cell[BoxData[
 RowBox[{"DependenceType", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "Z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712391913824441*^9, 3.712391913824441*^9}, {
   3.712392004871432*^9, 3.712392023185136*^9}, {3.71239205524727*^9, 
   3.7123921140896826`*^9}, 
   3.712392160808992*^9},ExpressionUUID->"9b9a6e60-2940-48c6-baa7-\
3f0960fb2031"],

Cell[BoxData[
 RowBox[{"DependenceType", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "Z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712391913824441*^9, 3.712391913824441*^9}, {
  3.712392004871432*^9, 3.712392023185136*^9}, {3.71239205524727*^9, 
  3.7123921683668375`*^9}},ExpressionUUID->"9524b993-3397-4562-8240-\
6df8b08e3be8"],

Cell[BoxData[
 RowBox[{"DependenceType", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "Z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712391913824441*^9, 3.712391913824441*^9}, {
  3.712392004871432*^9, 3.712392023185136*^9}, {3.71239205524727*^9, 
  3.7123921683668375`*^9}, {3.7123934681373425`*^9, 
  3.712393487660406*^9}},ExpressionUUID->"9295c12e-abb2-47ab-b0db-\
d6e6e42b50ed"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "MDSIter", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MDSIter", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"set_", ",", 
        RowBox[{"type", ":", 
         RowBox[{"(", 
          RowBox[{"\"\<U\>\"", "|", "\"\<S\>\"", "|", "\"\<I\>\""}], 
          ")"}]}]}], "}"}], ",", "A_", ",", "m_", ",", "sol_"}], "}"}], "/;", 
    RowBox[{"set", "===", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"First", "[", "set", "]"}], ",", "m"}], "]"}]}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"set", ",", "type"}], "}"}], ",", "A", ",", "m", ",", "sol"}], 
   "}"}]}], "\n", 
 RowBox[{
  RowBox[{"MDSIter", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"set_", ",", "\"\<D\>\""}], "}"}], ",", "A_", ",", "m_", ",", 
      "sol_"}], "}"}], "/;", 
    RowBox[{"set", "===", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"First", "[", "set", "]"}], ",", "m"}], "]"}]}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Delete", "[", 
       RowBox[{"set", ",", 
        RowBox[{"-", "2"}]}], "]"}], ",", "\"\<U\>\""}], "}"}], ",", "A", ",",
     "m", ",", "sol"}], "}"}]}], "\n", 
 RowBox[{
  RowBox[{"MDSIter", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"T___", ",", "tt_", ",", "m_"}], "}"}], ",", "type_"}], "}"}],
      ",", "A_", ",", "m_", ",", "sol_"}], "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"T", ",", 
        RowBox[{"tt", "+", "1"}]}], "}"}], ",", "\"\<U\>\""}], "}"}], ",", 
    "A", ",", "m", ",", "sol"}], "}"}]}], "\n", 
 RowBox[{
  RowBox[{"MDSIter", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"T___", ",", "tt_"}], "}"}], ",", "\"\<I\>\""}], "}"}], ",", 
      "A_", ",", "m_", ",", "sol_"}], "}"}], "/;", 
    RowBox[{"tt", "<", "m"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"T", ",", "tt", ",", 
        RowBox[{"tt", "+", "1"}]}], "}"}], ",", "\"\<U\>\""}], "}"}], ",", 
    "A", ",", "m", ",", "sol"}], "}"}]}], "\n", 
 RowBox[{
  RowBox[{"MDSIter", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"T___", ",", "tt_"}], "}"}], ",", "\"\<D\>\""}], "}"}], ",", 
      "A_", ",", "m_", ",", "sol_"}], "}"}], "/;", 
    RowBox[{"tt", "<", "m"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"T", ",", 
        RowBox[{"tt", "+", "1"}]}], "}"}], ",", "\"\<U\>\""}], "}"}], ",", 
    "A", ",", "m", ",", "sol"}], "}"}]}], "\n", 
 RowBox[{
  RowBox[{"MDSIter", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"T___", ",", "tt_"}], "}"}], ",", "\"\<S\>\""}], "}"}], ",", 
      "A_", ",", "m_", ",", "sol_"}], "}"}], "/;", 
    RowBox[{"tt", "<", "m"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"T", ",", 
        RowBox[{"tt", "+", "1"}]}], "}"}], ",", "\"\<U\>\""}], "}"}], ",", 
    "A", ",", "m", ",", "sol"}], "}"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MDSIter", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"set_", ",", "\"\<U\>\""}], "}"}], ",", "A_", ",", "m_", ",", 
      "sol_"}], "}"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"tt", "=", 
      RowBox[{"DependenceType", "[", 
       RowBox[{"A", ",", "set"}], "]"}]}], ";", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"set", ",", "tt"}], "}"}], ",", "A", ",", "m", ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"tt", "===", "\"\<S\>\""}], ",", 
         RowBox[{"Append", "[", 
          RowBox[{"sol", ",", "set"}], "]"}], ",", "sol"}], "]"}]}], "}"}]}], 
    ")"}]}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MinimalDependentSubsets", "[", "A_", "]"}], ":=", 
  RowBox[{"Last", "[", 
   RowBox[{"FixedPoint", "[", 
    RowBox[{"MDSIter", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "\"\<U\>\""}], "}"}], ",", "A", ",", 
       RowBox[{
        RowBox[{"Length", "[", "A", "]"}], "+", "1"}], ",", 
       RowBox[{"{", "}"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.712391913824441*^9, 3.712391913824441*^9}, 
   3.712392004871432*^9, {3.712392225324778*^9, 3.7123922619966507`*^9}, {
   3.7123923785762577`*^9, 3.7123923911213007`*^9}, 
   3.7302062820716333`*^9},ExpressionUUID->"d946fbaf-4a1a-42eb-a73b-\
5469611f6650"],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"mds", "=", 
   RowBox[{"MinimalDependentSubsets", "[", 
    RowBox[{"Transpose", "[", "Z", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712392192965517*^9, 3.7123922034816155`*^9}, {
  3.7123924139187164`*^9, 3.712392414590639*^9}, {3.7123961136585836`*^9, 
  3.7123961159515395`*^9}},ExpressionUUID->"24404e96-f8e2-4d21-9c46-\
96d50bca7661"],

Cell[BoxData[
 RowBox[{"Length", "[", "mds", "]"}]], "Input",
 CellChangeTimes->{{3.730299142317156*^9, 
  3.7302991793172245`*^9}},ExpressionUUID->"378edcd2-bed6-4b3f-9c47-\
da7fb1cebc43"],

Cell[BoxData[
 RowBox[{"Length", "[", "sel", "]"}]], "Input",
 CellChangeTimes->{{3.730299350270687*^9, 
  3.7302993592238293`*^9}},ExpressionUUID->"ce3b1675-b6be-4b9e-8e37-\
1ef598c03861"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 5.4", "Subsubsection",
 CellChangeTimes->{{3.7302009096865873`*^9, 3.730200923077238*^9}, {
  3.730201019733677*^9, 3.7302010199211764`*^9}, {3.730201314890504*^9, 
  3.730201315265507*^9}},ExpressionUUID->"ecf212d9-25c9-47ef-9e27-\
ea458f649a04"],

Cell[BoxData[
 RowBox[{
  RowBox[{"szalkai", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<CO\>\"", ",", "\"\<CO2\>\"", ",", "\"\<O2\>\"", ",", "\"\<H2\>\"", 
     ",", "\"\<CH2O\>\"", ",", "\"\<CH3OH\>\"", ",", "\"\<C2H5OH\>\"", ",", 
     "\"\<(CH3)2CO\>\"", ",", "\"\<CH4\>\"", ",", "\"\<CH3CHO\>\"", ",", 
     "\"\<H2O\>\""}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7123941428096676`*^9, 3.712394151106822*^9}, {
  3.7123942366386395`*^9, 3.7123943412315865`*^9}, {3.712395674263253*^9, 
  3.712395676920138*^9}, {3.730201439625121*^9, 
  3.7302014505001435`*^9}},ExpressionUUID->"9726daa0-5ce3-43a8-b262-\
189dad9aa26d"],

Cell[BoxData[
 RowBox[{"ToAtomMatrix", "[", 
  RowBox[{"szalkai", ",", 
   RowBox[{"FormattedOutput", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7123953143250265`*^9, 
  3.7123953216131725`*^9}},ExpressionUUID->"744ce81e-0834-4232-93b1-\
b2783144d6d2"],

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Zszalkai", "=", 
   RowBox[{"Most", "/@", 
    RowBox[{"Transpose", "[", 
     RowBox[{
      RowBox[{"ToAtomMatrix", "[", "szalkai", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7123953459190836`*^9, 3.712395363856544*^9}, {
  3.7123955201532297`*^9, 3.7123955209507236`*^9}, {3.712395637623288*^9, 
  3.712395640498565*^9}, {3.712395984075949*^9, 3.7123959851848392`*^9}, {
  3.7302015265940447`*^9, 3.730201535265936*^9}, {3.7302015842660303`*^9, 
  3.730201598031683*^9}},ExpressionUUID->"75e16032-b4b2-4a37-9e7b-\
7cfc7f2beb16"],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"t1", "=", 
    RowBox[{"MLD", "/@", 
     RowBox[{"Rest", "[", 
      RowBox[{"Subsets", "[", "Zszalkai", "]"}], "]"}]}]}], ";"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.712395469372783*^9, 3.712395470029258*^9}, {
   3.712395539121986*^9, 3.7123955696287255`*^9}, 3.71239600774454*^9, 
   3.712396173842757*^9, {3.7123962348096714`*^9, 3.7123962606227517`*^9}, {
   3.71239632772847*^9, 3.712396372452094*^9}, 3.712396431044677*^9, {
   3.730299448224004*^9, 3.7302994506458826`*^9}, {3.7302995272241573`*^9, 
   3.7302995275991592`*^9}, {3.730299561692975*^9, 
   3.730299566849236*^9}},ExpressionUUID->"a62784d6-6cbd-4a5c-91b3-\
e42fa7ba0751"],

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{"t1", ",", "True"}], "]"}]], "Input",
 CellChangeTimes->{{3.712396393935141*^9, 3.712396412497307*^9}, {
  3.730299530864789*^9, 3.730299530989791*^9}, {3.730299573317998*^9, 
  3.7302995743648753`*^9}},ExpressionUUID->"9e56291c-3a02-461a-aea2-\
d2668fad17d1"],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"t2", "=", 
    RowBox[{"MinimalDependentSubsets", "[", "Zszalkai", "]"}]}], ";"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7123954027232184`*^9, 3.7123954109196978`*^9}, 
   3.712395550419267*^9, {3.712395994169407*^9, 3.712395997294509*^9}, 
   3.71239616231007*^9, {3.712396202792206*^9, 3.7123962077595057`*^9}, 
   3.712396441606926*^9, {3.7302994298333426`*^9, 3.730299435473979*^9}, {
   3.730299534974174*^9, 3.7302995351304255`*^9}, {3.7302995796773853`*^9, 
   3.7302995854273977`*^9}},ExpressionUUID->"dde9e835-70aa-4f0f-87dc-\
a381e1c3037e"],

Cell[BoxData[
 RowBox[{"Length", "[", "t2", "]"}]], "Input",
 CellChangeTimes->{{3.7123962188723545`*^9, 3.7123962242785554`*^9}, {
  3.7302994408177395`*^9, 3.730299443692743*^9}, {3.730299539427307*^9, 
  3.730299539708559*^9}, {3.730299593411787*^9, 
  3.7302995946461654`*^9}},ExpressionUUID->"984119e6-c093-4852-bee4-\
c4657f5d5f31"],

Cell["The second version is mch faster.", "Text",
 CellChangeTimes->{{3.73029960083368*^9, 
  3.730299620079136*^9}},ExpressionUUID->"3115f231-40cb-48b0-9739-\
5fd5b1cdb4dd"],

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"MinimalDependentSubsets", "[", 
   RowBox[{"Most", "/@", 
    RowBox[{"Transpose", "[", 
     RowBox[{
      RowBox[{"ToAtomMatrix", "[", "szalkai", "]"}], "\[LeftDoubleBracket]", 
      "2", "\[RightDoubleBracket]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.712396491721936*^9, 3.7123965012181654`*^9}, {
  3.7123965375768013`*^9, 3.71239654021624*^9}, {3.7302015476253333`*^9, 
  3.7302015561566043`*^9}, {3.7302994764428096`*^9, 
  3.730299480099066*^9}},ExpressionUUID->"2834e998-5134-48fb-b828-\
8b3898cdd6a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 5.5", "Subsubsection",
 CellChangeTimes->{{3.7302009096865873`*^9, 3.730200923077238*^9}, {
  3.730201019733677*^9, 3.7302010199211764`*^9}, {3.730201314890504*^9, 
  3.730201315265507*^9}, {3.730201641297392*^9, 
  3.7302016433130226`*^9}},ExpressionUUID->"22395b0b-155a-4693-b871-\
2bee73f2a064"],

Cell[BoxData[
 RowBox[{"VolpertIndexing", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<H\>\"", "+", "\"\<O2\>\""}], "\[Rule]", 
      RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<OH\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<H2O\>\""}]}], ",", 
     RowBox[{
      RowBox[{"2", "\"\<H\>\""}], "\[Rule]", "\"\<H2\>\""}], ",", 
     RowBox[{
      RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}], "\[DoubleLeftRightArrow]", 
      "\"\<H2O\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<H\>\"", ",", "\"\<H2\>\"", ",", "\"\<O2\>\""}], "}"}], ",", 
   RowBox[{"Verbose", "\[Rule]", "True"}]}], "]"}]], "Input",ExpressionUUID->\
"30092b47-5d02-40f9-8738-c807373e3361"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 5.6", "Subsubsection",
 CellChangeTimes->{{3.7302009096865873`*^9, 3.730200923077238*^9}, {
  3.730201019733677*^9, 3.7302010199211764`*^9}, {3.730201314890504*^9, 
  3.730201315265507*^9}, {3.7302016963912506`*^9, 
  3.7302016968443756`*^9}},ExpressionUUID->"535c46c9-77fe-4b44-bbaf-\
29d1772d5bb1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "MyOmittable1", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MyOmittable1", "[", 
    RowBox[{"gamma_", ",", "b_"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", ",", "r", ",", "zs", ",", "optval", ",", "optz"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", "r"}], "}"}], "=", 
       RowBox[{"Dimensions", "[", "gamma", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"zs", "=", 
       RowBox[{"Array", "[", 
        RowBox[{"z", ",", "r"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"1", "-", 
       RowBox[{"FixedPoint", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"\[Chi]", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{"optval", ",", "optz"}], "}"}], "=", 
             RowBox[{"Minimize", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"\[Chi]", ".", "zs"}], ",", 
                 RowBox[{
                  RowBox[{"And", "@@", 
                   RowBox[{"Thread", "[", 
                    RowBox[{
                    RowBox[{"gamma", ".", "zs"}], "\[Equal]", "b"}], "]"}]}], 
                  "&&", 
                  RowBox[{"And", "@@", 
                   RowBox[{"Thread", "[", 
                    RowBox[{"zs", "\[GreaterEqual]", "0"}], "]"}]}], "&&", 
                  RowBox[{
                   RowBox[{"\[Chi]", ".", "zs"}], "\[GreaterEqual]", 
                   "1"}]}]}], "}"}], ",", "zs"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"\[Chi]", " ", "*", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"Boole", "[", 
                RowBox[{"Thread", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"zs", "/.", "optz"}], ")"}], " ", "\[Equal]", " ", 
                  "0"}], "]"}], "]"}]}], ")"}]}]}]}], "]"}], ",", 
         RowBox[{"Array", "[", 
          RowBox[{
           RowBox[{"1", "&"}], ",", "r"}], "]"}]}], "]"}]}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.712405054364255*^9, 3.712405054364255*^9}, {
   3.712405160012766*^9, 3.712405194713852*^9}, 3.730201984192257*^9, {
   3.7302020436226587`*^9, 3.7302020491589756`*^9}, {3.730202110621496*^9, 
   3.7302021286755295`*^9}, 3.7302023945476027`*^9, {3.7302024392976866`*^9, 
   3.7302024394539375`*^9}, {3.730202474157134*^9, 3.7302024819071474`*^9}, {
   3.7302033459713387`*^9, 3.730203356190106*^9}, {3.730213245845795*^9, 
   3.7302132473457966`*^9}, {3.730299654631116*^9, 3.7302996590133657`*^9}, {
   3.7302998593288374`*^9, 3.730299860836924*^9}, {3.7308838060758877`*^9, 
   3.7308838075290155`*^9}, {3.730887364288763*^9, 3.730887376304412*^9}, {
   3.7308878347917523`*^9, 3.7308878371048837`*^9}, {3.7308878676616344`*^9, 
   3.730887873228953*^9}, {3.7308882821093903`*^9, 3.730888296406291*^9}, {
   3.730888329046982*^9, 3.730888478781649*^9}, {3.730888569453701*^9, 
   3.7308885990631332`*^9}, {3.730888645094472*^9, 3.730888647250729*^9}, {
   3.7308886874851832`*^9, 3.7308886876414337`*^9}, {3.7308887296727643`*^9, 
   3.730888747266548*^9}, 3.7308888269229546`*^9, {3.730889041376504*^9, 
   3.7308890747828236`*^9}, 
   3.73089012182439*^9},ExpressionUUID->"049fc557-0aa4-4d83-b5c7-\
edd3c494820c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "reac", ",", "overall1", ",", "overall2", ",", "gammareac", ",", 
    "gammaoverall1", ",", "gammaoverall2"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reac", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<X\>\"", "\[Rule]", 
      RowBox[{"2", "\"\<Y\>\""}]}], ",", 
     RowBox[{
      RowBox[{"3", "\"\<A\>\""}], "\[Rule]", 
      RowBox[{"4", "\"\<B\>\""}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"overall1", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"Inner", "[", 
     RowBox[{"Plus", ",", 
      RowBox[{"Sequence", "@@", "reac"}], ",", "Rule"}], "]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"overall2", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", 
     RowBox[{"2", "\"\<Y\>\""}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"gammareac", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ReactionsData", "[", "reac", "]"}], "[", "\"\<\[Gamma]\>\"", 
    "]"}], "//", "Normal"}]}], "\[IndentingNewLine]", 
 RowBox[{"gammaoverall1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ReactionsData", "[", "overall1", "]"}], "[", "\"\<\[Gamma]\>\"", 
    "]"}], "//", "Normal"}]}], "\[IndentingNewLine]", 
 RowBox[{"gammaoverall2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ReactionsData", "[", "overall2", "]"}], "[", "\"\<\[Gamma]\>\"", 
    "]"}], "//", "Normal"}]}]}], "Input",
 CellChangeTimes->{{3.730202852595373*^9, 3.7302028682360287`*^9}, {
  3.7302030197519493`*^9, 3.730203075658309*^9}, {3.730203107705246*^9, 
  3.730203112720882*^9}, {3.730204475364975*^9, 3.730204494615013*^9}, {
  3.7308822784262643`*^9, 3.730882294929208*^9}, {3.730883047574404*^9, 
  3.7308830478087797`*^9}, {3.730887406413846*^9, 3.7308875233047*^9}, {
  3.730888674313282*^9, 
  3.7308886850320525`*^9}},ExpressionUUID->"fe4fdbf2-2cd4-43bc-b576-\
a8e88fcf81bc"],

Cell[BoxData[
 RowBox[{"MyOmittable1", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "3"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.73020215153784*^9, 3.730202229152283*^9}, {
   3.7302025898917336`*^9, 3.730202591719865*^9}, {3.7302026467668457`*^9, 
   3.7302026486887255`*^9}, 3.7302028500484943`*^9, {3.7302031305646667`*^9, 
   3.7302031365021763`*^9}, {3.7302032058616896`*^9, 
   3.7302032272679806`*^9}, {3.7302032677993097`*^9, 3.730203270174314*^9}, {
   3.730203636362531*^9, 3.7302037306439643`*^9}, 3.730203873551299*^9, {
   3.7302045120837984`*^9, 3.730204517849433*^9}, {3.730204552552629*^9, 
   3.7302045717557898`*^9}, 3.7302998632490654`*^9, {3.7308873926950693`*^9, 
   3.7308873927888174`*^9}, {3.730887427445137*^9, 3.730887437445156*^9}, 
   3.7308874946640177`*^9, {3.730887545148492*^9, 
   3.7308875583047676`*^9}},ExpressionUUID->"1820fe16-895a-4077-a76b-\
459fb78d6cca"],

Cell["Neither of the reaction steps can be omitted.", "Text",
 CellChangeTimes->{{3.730299827011986*^9, 3.730299845872066*^9}, {
  3.7308874928983927`*^9, 
  3.7308874977577777`*^9}},ExpressionUUID->"1ac23a09-f4ff-4c85-b57a-\
3fc760658bb0"],

Cell[BoxData[
 RowBox[{"MyOmittable1", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "0"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.73020215153784*^9, 3.730202229152283*^9}, {
   3.7302025898917336`*^9, 3.730202591719865*^9}, {3.7302026467668457`*^9, 
   3.7302026486887255`*^9}, 3.7302028500484943`*^9, {3.7302031305646667`*^9, 
   3.7302031365021763`*^9}, {3.7302032058616896`*^9, 
   3.7302032272679806`*^9}, {3.7302032677993097`*^9, 3.730203270174314*^9}, {
   3.730203636362531*^9, 3.7302037306439643`*^9}, 3.730203873551299*^9, {
   3.7302045120837984`*^9, 3.730204517849433*^9}, {3.730204552552629*^9, 
   3.7302045717557898`*^9}, 3.7302998632490654`*^9, {3.7308873926950693`*^9, 
   3.7308873927888174`*^9}, {3.730887427445137*^9, 3.730887437445156*^9}, {
   3.7308874865546274`*^9, 3.7308875030546603`*^9}, {3.730887546851619*^9, 
   3.7308875683985405`*^9}},ExpressionUUID->"c7e33bad-8a7f-4dbb-b683-\
70dd36ebc1dd"],

Cell["In the second example the second step can be omitted.", "Text",
 CellChangeTimes->{{3.730299827011986*^9, 3.730299845872066*^9}, {
  3.7308874928983927`*^9, 3.7308874977577777`*^9}, {3.730889281533219*^9, 
  3.7308893053301396`*^9}, {3.730889677362118*^9, 3.730889686580886*^9}, {
  3.730889718627824*^9, 
  3.7308897226590815`*^9}},ExpressionUUID->"72c4a598-29d0-423f-abcb-\
cb46a9316fa5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "rddecomp", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rddecomp", "=", 
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\"\<H\>\"", "+", "\"\<O2\>\""}], "\[Rule]", 
       RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}]}], ",", 
      RowBox[{
       RowBox[{"\"\<O\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
       RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}]}], ",", 
      RowBox[{
       RowBox[{"\"\<OH\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
       RowBox[{"\"\<H\>\"", "+", "\"\<H2O\>\""}]}], ",", 
      RowBox[{
       RowBox[{"2", "\"\<H\>\""}], "\[Rule]", "\"\<H2\>\""}], ",", 
      RowBox[{
       RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}], "\[DoubleLeftRightArrow]", 
       "\"\<H2O\>\""}]}], "}"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7308893213926725`*^9, 3.730889352658358*^9}, {
  3.7308895205024366`*^9, 
  3.7308895218149405`*^9}},ExpressionUUID->"b27fb308-e0c5-42fc-9fff-\
fe64c4519cba"],

Cell[BoxData[
 RowBox[{"rddecomp", "[", "\[Gamma]", "]"}]], "Input",
 CellChangeTimes->{{3.7308893392677107`*^9, 
  3.7308893563302417`*^9}},ExpressionUUID->"11256983-8433-4967-b1e0-\
b3afc18384b5"],

Cell[BoxData[
 RowBox[{"rddecomp", "[", "\"\<species\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7308893593927464`*^9, 
  3.7308893633458776`*^9}},ExpressionUUID->"0f91028f-9c99-4922-9498-\
54b97a316883"],

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<H\>\"", "+", "\"\<O2\>\"", "+", 
     RowBox[{"3", "\"\<H2\>\""}]}], "\[Rule]", 
    RowBox[{
     RowBox[{"3", "\"\<H\>\""}], "+", 
     RowBox[{"2", "\"\<H2O\>\""}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{
  3.73088943786165*^9, {3.73088954275248*^9, 
   3.7308895430337296`*^9}},ExpressionUUID->"681c0373-3a9d-4635-9f2b-\
0b789a0d3033"],

Cell[BoxData[
 RowBox[{"MyOmittable1", "[", 
  RowBox[{
   RowBox[{"rddecomp", "[", "\[Gamma]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.73088937223652*^9, 
  3.73088950722116*^9}},ExpressionUUID->"af3613d6-0d50-4f92-b607-\
206112667892"],

Cell["\<\
That is, the last three reaction steps can be omitted. And, really, we find a \
decomposition below only consructed from the first three reaction steps.\
\>", "Text",
 CellChangeTimes->{{3.7308896075807323`*^9, 
  3.730889668908977*^9}},ExpressionUUID->"a6c0aa20-2636-4542-9bb1-\
eaaf87dfa841"],

Cell[BoxData[
 RowBox[{"Decompositions", "[", 
  RowBox[{"b", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<H\>\"", "+", "\"\<O2\>\""}], "\[Rule]", 
      RowBox[{"\"\<O\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<O\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<OH\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<OH\>\"", "+", "\"\<H2\>\""}], "\[Rule]", 
      RowBox[{"\"\<H\>\"", "+", "\"\<H2O\>\""}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7308895766275454`*^9, 
  3.7308895845494337`*^9}},ExpressionUUID->"e90083c4-a503-467e-ae67-\
1188353e59d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 5.7", "Subsubsection",
 CellChangeTimes->{{3.7302009096865873`*^9, 3.730200923077238*^9}, {
  3.730201019733677*^9, 3.7302010199211764`*^9}, {3.730201314890504*^9, 
  3.730201315265507*^9}, {3.7302016963912506`*^9, 3.7302016968443756`*^9}, {
  3.7302040489578924`*^9, 
  3.7302040492547655`*^9}},ExpressionUUID->"75035a1b-e19c-49fb-b8b4-\
fbde8999c3a5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"reac", ",", "overall", ",", "gammareac", ",", "gammaoverall"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reac", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<X\>\"", "\[Rule]", 
      RowBox[{"2", "\"\<Y\>\""}]}], ",", 
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<B\>\""}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"overall1", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"Inner", "[", 
     RowBox[{"Plus", ",", 
      RowBox[{"Sequence", "@@", "reac"}], ",", "Rule"}], "]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"overall2", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", 
     RowBox[{"2", "\"\<Y\>\""}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"gammareac", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ReactionsData", "[", "reac", "]"}], "[", "\"\<\[Gamma]\>\"", 
    "]"}], "//", "Normal"}]}], "\[IndentingNewLine]", 
 RowBox[{"gammaoverall1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ReactionsData", "[", "overall1", "]"}], "[", "\"\<\[Gamma]\>\"", 
    "]"}], "//", "Normal"}]}], "\[IndentingNewLine]", 
 RowBox[{"gammaoverall2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ReactionsData", "[", "overall2", "]"}], "[", "\"\<\[Gamma]\>\"", 
    "]"}], "//", "Normal"}]}]}], "Input",
 CellChangeTimes->{{3.730883076574459*^9, 
  3.7308831048713913`*^9}},ExpressionUUID->"4dafcc29-3c36-442d-b694-\
03788e70f2c6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MyOmittable2", "[", 
    RowBox[{"gamma_", ",", "b_"}], "]"}], ":=", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"Length", "[", 
       RowBox[{"First", "[", "gamma", "]"}], "]"}], "]"}], ",", 
     RowBox[{"Union", "[", 
      RowBox[{"Last", "/@", 
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"CoveringDecompositionSet", "[", 
          RowBox[{"b", ",", "gamma"}], "]"}], ",", 
         RowBox[{"_", "?", "Positive"}]}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7302040393484974`*^9, 3.7302040393484974`*^9}, {
  3.7302040722391863`*^9, 3.7302040853017125`*^9}, {3.7302041972863064`*^9, 
  3.730204200005063*^9}, {3.730882548635931*^9, 3.730882551057807*^9}, {
  3.7308831926996875`*^9, 
  3.7308831933403134`*^9}},ExpressionUUID->"70b1cdb4-0d48-449c-acfc-\
c5c4f0a7b899"],

Cell[BoxData[
 RowBox[{"MyOmittable2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.73020409734861*^9, {3.7302041372236876`*^9, 3.7302041606456103`*^9}, {
   3.730204209239455*^9, 3.730204223145733*^9}, {3.730204719302951*^9, 
   3.7302047220373325`*^9}, 3.730882516412892*^9, {3.7308834261063957`*^9, 
   3.7308834409970517`*^9}, {3.73088350579405*^9, 
   3.7308835101378083`*^9}},ExpressionUUID->"a9e39abb-2675-4cd1-8af8-\
ed8eccfa61f7"],

Cell[BoxData[
 RowBox[{"MyOmittable2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "0"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.73020409734861*^9, {3.7302041372236876`*^9, 3.7302041606456103`*^9}, {
   3.730204209239455*^9, 3.730204223145733*^9}, {3.730204719302951*^9, 
   3.7302047220373325`*^9}, 3.730882516412892*^9, 3.7308830338868775`*^9, {
   3.730883118433918*^9, 3.730883119215169*^9}, 3.7308834279970226`*^9, {
   3.7308835150753183`*^9, 
   3.730883519247201*^9}},ExpressionUUID->"026cdf4e-9169-4541-b0e3-\
fa8c67cb1cb1"],

Cell[BoxData[
 RowBox[{"CoveringDecompositionSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730881014281126*^9, 3.7308810177186346`*^9}, {
  3.7308824616437545`*^9, 3.7308824693862004`*^9}, {3.73088250009896*^9, 
  3.7308825062723136`*^9}},ExpressionUUID->"8e44a925-6afa-4acc-a052-\
01715b4d1b2d"],

Cell[BoxData[
 RowBox[{"CoveringDecompositionSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730881014281126*^9, 3.7308810177186346`*^9}, {
  3.7308824616437545`*^9, 3.7308824693862004`*^9}, {3.73088250009896*^9, 
  3.7308825062723136`*^9}, {3.730883130980817*^9, 
  3.730883135012074*^9}},ExpressionUUID->"6fbd35fa-8016-423d-a466-\
8347e4ef39a9"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Induced", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
  3.7105102298903947`*^9, 
  3.7105102346404047`*^9}},ExpressionUUID->"44a96b7d-99ae-476f-ac1f-\
dbe60de698f8"],

Cell[CellGroupData[{

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"d8990e12-1808-40c0-ae88-\
012f1698157b"],

Cell[CellGroupData[{

Cell["Fig. 14.3", "Subsubsection",
 CellChangeTimes->{{3.7285838236692724`*^9, 3.7285838250598984`*^9}, 
   3.7286447518773212`*^9},ExpressionUUID->"d5d282c5-4ada-43b4-a514-\
32d100f9e583"],

Cell[BoxData[
 RowBox[{"lv", "=", 
  RowBox[{"GetReaction", "[", "\"\<Lotka-Volterra\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.637845522335019*^9, 3.637845530563489*^9}, {
   3.6378455606362095`*^9, 3.6378455852846193`*^9}, 3.7287982031995444`*^9, {
   3.730301726448384*^9, 
   3.73030173185465*^9}},ExpressionUUID->"1f335cdc-f60b-4e05-b382-\
c05244b38a44"],

Cell[BoxData[
 RowBox[{"re", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"lv", ",", 
     RowBox[{"ExternalSpecies", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}], "[", 
   "\"\<fhjgraphedges\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.7105109529855595`*^9, 3.710510969907468*^9}, {
  3.730206308477935*^9, 
  3.7302063089623127`*^9}},ExpressionUUID->"cf8a5a37-e884-4ee6-9913-\
44104d2e7905"],

Cell[BoxData[
 RowBox[{
  RowBox[{"small", "=", 
   RowBox[{"ReplaceAll", "@@", 
    RowBox[{"Concentrations", "[", 
     RowBox[{
      RowBox[{"{", "re", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.637845355963503*^9, 3.6378455047410126`*^9}, {
   3.637845898040508*^9, 3.637845903007792*^9}, 3.6378459538246984`*^9, {
   3.637845985189492*^9, 3.6378460368904495`*^9}, {3.6378460974609137`*^9, 
   3.637846128268676*^9}, {3.6378462614292927`*^9, 3.637846266948608*^9}, 
   3.7287145997132187`*^9},ExpressionUUID->"904856a8-c0ad-4c2a-bcc5-\
1600123bfd08"],

Cell[BoxData[
 RowBox[{
  RowBox[{"large", "=", 
   RowBox[{"ReplaceAll", "@@", 
    RowBox[{"Concentrations", "[", 
     RowBox[{
      RowBox[{"{", "re", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.637845355963503*^9, 3.6378455047410126`*^9}, {
   3.637845898040508*^9, 3.637845903007792*^9}, 3.6378459538246984`*^9, {
   3.637845985189492*^9, 3.6378460368904495`*^9}, {3.6378460974609137`*^9, 
   3.6378461558962564`*^9}, {3.637846297155336*^9, 3.6378463021626225`*^9}, 
   3.7287146019163485`*^9},ExpressionUUID->"4967c0c6-f3d1-471e-8c83-\
a7709906d0ce"],

Cell[BoxData[
 RowBox[{"lvtwocurves1", "=", 
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"{", 
      RowBox[{"small", ",", "large"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Thickness", "[", "0.01", "]"}], "]"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<smaller\\ninitial\\nvalue\>\"", ",", 
       "\"\<larger\\ninitial\\nvalue\>\""}], "}"}]}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5"}], "}"}], "]"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.637846176192417*^9, 3.6378462395720425`*^9}, {
  3.6378462798453455`*^9, 
  3.6378466169456267`*^9}},ExpressionUUID->"2916751b-ff96-4c23-9faf-\
90cc6b3f91fb"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.3\>\"", ",", "lvtwocurves1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6378466215888925`*^9, 3.6378466728718257`*^9}, {
  3.728583851169324*^9, 
  3.72858385963809*^9}},ExpressionUUID->"565076af-4eb8-448e-a7b9-\
2ee708063ccc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.4", "Subsubsection",
 CellChangeTimes->{{3.7285838417474318`*^9, 3.7285838444193115`*^9}, 
   3.7286447672992268`*^9},ExpressionUUID->"9b43ad7a-9cf4-4d3e-8046-\
8dbef39dd2b3"],

Cell[BoxData[
 RowBox[{"lvtwocurves2", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"{", 
      RowBox[{"small", "-", "large"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Thickness", "[", "0.01", "]"}], "]"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\[CapitalDelta]x\>\"", ",", "\"\<\[CapitalDelta]y\>\""}], 
      "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.637846176192417*^9, 3.6378462395720425`*^9}, {
  3.6378462798453455`*^9, 3.6378466169456267`*^9}, {3.6378467279099736`*^9, 
  3.637846799443065*^9}},ExpressionUUID->"5a4325d9-67b7-42b4-9c5c-\
067533c1eb7e"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.4\>\"", ",", "lvtwocurves2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6378466215888925`*^9, 3.6378466728718257`*^9}, {
  3.637846814322916*^9, 3.637846816874062*^9}, {3.7285838648881006`*^9, 
  3.7285838745131197`*^9}},ExpressionUUID->"18298397-90b7-4eb9-8507-\
6d6005e57928"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.5", "Subsubsection",
 CellChangeTimes->{{3.728583975685193*^9, 3.728583978325823*^9}, 
   3.728644775455492*^9},ExpressionUUID->"fe2add60-0ed8-4e47-9444-\
0374518d3ef7"],

Cell[BoxData[
 RowBox[{"gOH", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Labeled", "[", 
       RowBox[{"1", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<HCOOH\>\"", ",", "Bold", ",", "16"}], "]"}]}], "]"}], 
      ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{"2", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)O\>\"", ",", 
          RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", "Bold", 
          ",", "16"}], "]"}]}], "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{"3", ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(CH\), \(3\)]\)OH\>\"", ",", "Bold", ",", 
          "16"}], "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"1", "\[DirectedEdge]", "2"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<1/2 w(c(t))\>\"", ",", "Bold", ",", "16"}], "]"}]}], 
       "]"}], ",", 
      RowBox[{"Labeled", "[", 
       RowBox[{
        RowBox[{"3", "\[DirectedEdge]", "2"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<1/2 w(c(t))\>\"", ",", "Bold", ",", "16"}], "]"}]}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
    RowBox[{"VertexSize", "\[Rule]", "Small"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "500"}], ",", 
    RowBox[{"ImagePadding", "\[Rule]", "50"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", "\"\<LinearEmbedding\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5744272308630695`*^9, 3.5744272318630705`*^9}, {
  3.5744273003181667`*^9, 3.57442730258317*^9}, {3.5744273448532286`*^9, 
  3.5744273932332964`*^9}, {3.574427639483641*^9, 3.5744277344037743`*^9}, {
  3.574427828410757*^9, 3.5744278407974653`*^9}, {3.574427919270954*^9, 
  3.574428012766302*^9}, {3.5744281008661113`*^9, 3.574428292281379*^9}, {
  3.574428324171424*^9, 3.574428324886425*^9}, {3.5744283565364695`*^9, 
  3.574428433486577*^9}, {3.5744284643866205`*^9, 3.574428618011835*^9}, {
  3.5744286648669004`*^9, 3.574428712111967*^9}, {3.613634752400132*^9, 
  3.6136347687110653`*^9}, {3.613634799093803*^9, 3.613635021124502*^9}, {
  3.613635064789*^9, 3.6136350714283795`*^9}, {3.730301909667494*^9, 
  3.7303019896051493`*^9}, {3.73030203271461*^9, 
  3.7303020705115576`*^9}},ExpressionUUID->"2562521b-71ad-4ac4-9686-\
b8ea51b3a76a"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.5\>\"", ",", "gOH"}], "]"}]], "Input",
 CellChangeTimes->{{3.6378546839740343`*^9, 3.637854723031268*^9}, {
  3.728584019513406*^9, 
  3.7285840287946715`*^9}},ExpressionUUID->"bdd7bf2e-7d02-4f03-b194-\
9d170ded0e48"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.6", "Subsubsection",
 CellChangeTimes->{{3.728583996091481*^9, 3.7285839986071143`*^9}, 
   3.728644784471134*^9},ExpressionUUID->"30800093-9dc9-4483-9b4a-\
87d4d0dcc30c"],

Cell[BoxData[
 RowBox[{"gHrev", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<H\>\"", "\[Rule]", "\"\<OH\>\""}], ",", 
         "\"\<\!\(\*SubscriptBox[\(w\), \(1\)]\)/2+\!\(\*SubscriptBox[\(w\), \
\(-3\)]\)/6\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<OH\>\"", "\[Rule]", "\"\<H\>\""}], ",", 
         "\"\<\!\(\*SubscriptBox[\(w\), \(-1\)]\)/2+\!\(\*SubscriptBox[\(w\), \
\(3\)]\)/6\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)\>\"", "\[Rule]", 
          "\"\<H\>\""}], ",", 
         "\"\<2\!\(\*SubscriptBox[\(w\), \
\(2\)]\)/4+2\!\(\*SubscriptBox[\(w\), \(3\)]\)/6\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<H\>\"", "\[Rule]", 
          "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)\>\""}], ",", 
         "\"\<2\!\(\*SubscriptBox[\(w\), \
\(-2\)]\)/4+2\!\(\*SubscriptBox[\(w\), \(-3\)]\)/6\>\""}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)\>\"", "\[Rule]", 
          "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)O\>\""}], ",", 
         "\"\<4\!\(\*SubscriptBox[\(w\), \(3\)]\)/6\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)O\>\"", "\[Rule]", 
          "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)\>\""}], ",", 
         "\"\<4\!\(\*SubscriptBox[\(w\), \(-3\)]\)/6\>\""}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)\>\"", "\[Rule]", 
          "\"\<OH\>\""}], ",", 
         "\"\<2\!\(\*SubscriptBox[\(w\), \(2\)]\)/4\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<OH\>\"", "\[Rule]", 
          "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)\>\""}], ",", 
         "\"\<2\!\(\*SubscriptBox[\(w\), \(-2\)]\)/4\>\""}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)O\>\"", "\[Rule]", 
          "\"\<OH\>\""}], ",", 
         "\"\<2\!\(\*SubscriptBox[\(w\), \(-3\)]\)/6\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<OH\>\"", "\[Rule]", 
          "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)O\>\""}], ",", 
         "\"\<2\!\(\*SubscriptBox[\(w\), \(3\)]\)/6\>\""}], "}"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{"x_String", "\[Rule]", 
       RowBox[{"Style", "[", 
        RowBox[{"x", ",", 
         RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", "16", ",", 
         "Bold"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "1600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.526032361940986*^9, 3.5260326228869114`*^9}, {
   3.6397187283141212`*^9, 3.639718728969322*^9}, {3.6397197291838818`*^9, 
   3.639719786247531*^9}, {3.6397198362983932`*^9, 3.6397198637189617`*^9}, {
   3.639719894341714*^9, 3.6397201767267685`*^9}, {3.6397205107632475`*^9, 
   3.6397205154445148`*^9}, {3.7105111859547653`*^9, 3.710511294704977*^9}, {
   3.7105113305487967`*^9, 3.7105113319706745`*^9}, {3.717313190857521*^9, 
   3.7173132178888226`*^9}, {3.7173132589514027`*^9, 
   3.7173132743576827`*^9}, {3.717313327139037*^9, 3.717313339045312*^9}, {
   3.7173135528582277`*^9, 3.7173135681707573`*^9}, {3.717314096859291*^9, 
   3.7173141073280616`*^9}, 3.7287146460414343`*^9, 3.730302171183628*^9, 
   3.7303022188399715`*^9, {3.7303022510744104`*^9, 
   3.7303022775744624`*^9}},ExpressionUUID->"8adb74bb-6abe-4209-8df8-\
36a0198b8dbe"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.6A\>\"", ",", "gHrev"}], "]"}]], "Input",
 CellChangeTimes->{{3.6378555278182993`*^9, 3.637855541918106*^9}, {
  3.7285840459353333`*^9, 
  3.7285840565759764`*^9}},ExpressionUUID->"ba664ef0-a92a-491e-b54d-\
379e0a7268e1"],

Cell[BoxData[
 RowBox[{"gOrev", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(O\), \(2\)]\)\>\"", "\[Rule]", 
          "\"\<OH\>\""}], ",", 
         "\"\<2\!\(\*SubscriptBox[\(w\), \(1\)]\)/4\\n\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<OH\>\"", "\[Rule]", 
          "\"\<\!\(\*SubscriptBox[\(O\), \(2\)]\)\>\""}], ",", 
         "\"\<\\n2\!\(\*SubscriptBox[\(w\), \(-1\)]\)/4\\n\\n\>\""}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(O\), \(2\)]\)\>\"", "\[Rule]", 
          "\"\<O\>\""}], ",", 
         "\"\<2\!\(\*SubscriptBox[\(w\), \(1\)]\)/4\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<O\>\"", "\[Rule]", 
          "\"\<\!\(\*SubscriptBox[\(O\), \(2\)]\)\>\""}], ",", 
         "\"\<\\n\\n2\!\(\*SubscriptBox[\(w\), \(-1\)]\)/4\>\""}], "}"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<O\>\"", "\[Rule]", "\"\<OH\>\""}], ",", 
         "\"\<\!\(\*SubscriptBox[\(w\), \(2\)]\)/2\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<OH\>\"", "\[Rule]", "\"\<O\>\""}], ",", 
         "\"\<\!\(\*SubscriptBox[\(w\), \(-2\)]\)/2\>\""}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<OH\>\"", "\[Rule]", 
          "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)O\>\""}], ",", 
         "\"\<\!\(\*SubscriptBox[\(w\), \(3\)]\)/2\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(H\), \(2\)]\)O\>\"", "\[Rule]", 
          "\"\<OH\>\""}], ",", 
         "\"\<\!\(\*SubscriptBox[\(w\), \(-3\)]\)/2\>\""}], "}"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{"x_String", "\[Rule]", 
       RowBox[{"Style", "[", 
        RowBox[{"x", ",", 
         RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", "16", ",", 
         "Bold"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5260323682493467`*^9, 3.5260323698834405`*^9}, {
   3.5260326666784163`*^9, 3.526032750401205*^9}, {3.6397187328693295`*^9, 
   3.6397187334933305`*^9}, {3.6397202093776255`*^9, 
   3.6397202472232924`*^9}, {3.6397202999669847`*^9, 
   3.6397204196350346`*^9}, {3.7173136107958407`*^9, 3.717313782311801*^9}, 
   3.730302183183653*^9},ExpressionUUID->"541c0ad7-8a28-46a3-ae2e-\
8b97f2f17bde"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.6B\>\"", ",", "gOrev"}], "]"}]], "Input",
 CellChangeTimes->{{3.6378555278182993`*^9, 3.637855529486395*^9}, {
  3.7285840639666157`*^9, 
  3.728584072935384*^9}},ExpressionUUID->"2a4f0942-1e72-4cf7-a230-\
186705289f45"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.7", "Subsubsection",
 CellChangeTimes->{{3.728584215982537*^9, 3.7285842187481675`*^9}, 
   3.7286447987367873`*^9},ExpressionUUID->"39f124ba-70a9-47f9-993c-\
7ef9c0aa6b69"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ndstemp", "=", 
   RowBox[{"ParametricNDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"c", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["10", 
          RowBox[{"-", 
           FractionBox["1000", 
            RowBox[{"T", "[", "t", "]"}]]}]], " ", 
         RowBox[{"c", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"-", "Q"}], " ", 
         SuperscriptBox["10", 
          RowBox[{"-", 
           FractionBox["1000", 
            RowBox[{"T", "[", "t", "]"}]]}]], 
         RowBox[{"c", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"c", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{"T", "[", "0", "]"}], "\[Equal]", "300"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "T"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10000"}], "}"}], ",", 
     RowBox[{"{", "Q", "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.567010090782268*^9, 3.5670103035324364`*^9}, {
   3.6115871243265324`*^9, 3.6115872740480957`*^9}, {3.6115873955720463`*^9, 
   3.611587396367092*^9}, {3.611587508121484*^9, 3.611587508839525*^9}, 
   3.611588234736044*^9, {3.611588332692647*^9, 3.6115883383159685`*^9}, {
   3.611630841547014*^9, 3.61163084200204*^9}, 3.6116310310048504`*^9, {
   3.6116313718973484`*^9, 3.611631372305372*^9}, {3.611632208566203*^9, 
   3.6116322089092226`*^9}, {3.611632402624303*^9, 3.6116324285117836`*^9}, {
   3.636899195540821*^9, 3.636899221739319*^9}, {3.636899261690604*^9, 
   3.6368992636477165`*^9}, {3.6368993063761597`*^9, 3.636899337265927*^9}, {
   3.636899698815606*^9, 3.636899699942671*^9}, {3.636899949269932*^9, 
   3.6368999498289633`*^9}, {3.6369005586427855`*^9, 3.636900558986805*^9}, 
   3.637654569070622*^9, {3.637654624499792*^9, 3.6376546408657284`*^9}, {
   3.63765511031658*^9, 3.6376551325048485`*^9}, {3.702916797158536*^9, 
   3.7029167971625366`*^9}, {3.710511484049098*^9, 3.7105114870491037`*^9}, 
   3.712477558829294*^9, 3.728714672260236*^9, {3.7303024052778387`*^9, 
   3.730302444293537*^9}},ExpressionUUID->"2f08817a-2162-4481-9461-\
527e0a9b25f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mult1", "=", "300"}], ";", 
  RowBox[{"exocT", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"mult1", " ", 
          RowBox[{
           RowBox[{"c", "[", 
            RowBox[{"-", "100"}], "]"}], "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{"T", "[", 
           RowBox[{"-", "100"}], "]"}], "[", "t", "]"}]}], "}"}], "/.", 
       "ndstemp"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "500"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{"{", 
          RowBox[{"Thick", ",", "Red"}], "}"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"{", 
          RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<t\>\"", ",", "Italic", ",", "Bold", ",", "16"}], "]"}], 
        ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ToString", "[", "mult1", "]"}], "<>", 
           "\"\<c(t),T(t)\>\""}], ",", "Italic", ",", "Bold", ",", "16"}], 
         "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ToString", "[", "mult1", "]"}], "<>", "\"\<c\>\""}], ",", 
          "\"\<T\>\""}], "}"}], ",", "Above"}], "]"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.609049355061763*^9, 3.6090493591749983`*^9}, {
   3.6090494274529033`*^9, 3.609049439775608*^9}, {3.6090495750983477`*^9, 
   3.6090495925203447`*^9}, {3.6115873498194294`*^9, 
   3.6115873820022707`*^9}, {3.6115875136858025`*^9, 
   3.6115875141248274`*^9}, {3.611587547851756*^9, 3.6115875553331842`*^9}, {
   3.611587618689808*^9, 3.611587639898021*^9}, {3.6115879545860205`*^9, 
   3.611588038725833*^9}, {3.6116307524749193`*^9, 3.6116307914301476`*^9}, {
   3.6116308565928745`*^9, 3.6116308760659885`*^9}, {3.611631383023985*^9, 
   3.6116313832910004`*^9}, {3.6116314709230127`*^9, 3.611631479059478*^9}, 
   3.6116324716192493`*^9, {3.636862108454918*^9, 3.6368621098469973`*^9}, {
   3.6368623957043476`*^9, 3.6368624007586365`*^9}, {3.636899403898738*^9, 
   3.636899406420882*^9}, {3.6368994552226734`*^9, 3.6368994645892096`*^9}, {
   3.636899496892057*^9, 3.6368995257697086`*^9}, {3.636899574828515*^9, 
   3.636899593135562*^9}, {3.6369006438086567`*^9, 3.6369006659659243`*^9}, {
   3.6369008070109916`*^9, 3.636900840466905*^9}, {3.6369009890474033`*^9, 
   3.636901007061434*^9}, {3.636901077387456*^9, 3.636901077610469*^9}, {
   3.6374985699088697`*^9, 3.63749859884692*^9}, {3.637654705943451*^9, 
   3.637654713180865*^9}, {3.637654745254699*^9, 3.637654745916737*^9}, {
   3.639721603269169*^9, 3.6397216297580156`*^9}, {3.639721702968944*^9, 
   3.6397217920461006`*^9}, {3.639721884883066*^9, 3.6397218894538746`*^9}, {
   3.6397219810436354`*^9, 3.6397220278749175`*^9}, {3.639722077732605*^9, 
   3.639722093037232*^9}, {3.6397221530037374`*^9, 3.6397221661233606`*^9}, {
   3.6397223025954*^9, 3.63972230813341*^9}, {3.710511564408629*^9, 
   3.71051159817432*^9}, {3.712477398422471*^9, 3.7124775015902104`*^9}, {
   3.7124775527769237`*^9, 3.7124775680236874`*^9}, {3.712477619869464*^9, 
   3.712477620388756*^9}, {3.7124776730130205`*^9, 3.71247772641646*^9}, {
   3.712477767507179*^9, 3.712477830966996*^9}, {3.7124780105494647`*^9, 
   3.712478054097839*^9}, {3.712478169863716*^9, 
   3.7124782680229425`*^9}},ExpressionUUID->"98cb2abd-28e7-4fef-9b7d-\
9d68845754dd"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.7A\>\"", ",", "exocT"}], "]"}]], "Input",
 CellChangeTimes->{{3.6368621135412087`*^9, 3.636862126901973*^9}, {
  3.6368622973897247`*^9, 3.6368622985817924`*^9}, {3.6376545860005903`*^9, 
  3.6376545930309925`*^9}, {3.6397223640293083`*^9, 3.639722369504918*^9}, {
  3.728584231373191*^9, 
  3.7285842410919614`*^9}},ExpressionUUID->"f2cbf4f4-bdf2-42a9-b4ae-\
69a29c7d8b5b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mult", "=", "300"}], ";", 
  RowBox[{"endocT", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"mult", " ", 
          RowBox[{
           RowBox[{"c", "[", "600", "]"}], "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{"T", "[", "600", "]"}], "[", "t", "]"}]}], "}"}], "/.", 
       "ndstemp"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "500"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{"{", 
          RowBox[{"Thick", ",", "Red"}], "}"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"{", 
          RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<t\>\"", ",", "Italic", ",", "Bold", ",", "16"}], "]"}], 
        ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ToString", "[", "mult", "]"}], "<>", 
           "\"\<c(t),T(t)\>\""}], ",", "Italic", ",", "Bold", ",", "16"}], 
         "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ToString", "[", "mult", "]"}], "<>", "\"\<c\>\""}], ",", 
          "\"\<T\>\""}], "}"}], ",", "Above"}], "]"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6397221950146112`*^9, 3.6397223198958306`*^9}, {
   3.7124775177319803`*^9, 3.7124775743442783`*^9}, 3.7124776670573206`*^9, {
   3.7124778685949926`*^9, 3.7124779172767825`*^9}, {3.7124779472822328`*^9, 
   3.7124779583350644`*^9}, 3.7124779953336053`*^9, {3.712478255526331*^9, 
   3.71247825688618*^9}},ExpressionUUID->"d24abf7e-5922-40c5-b5f4-\
df3bd793ebf4"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.7B\>\"", ",", "endocT"}], "]"}]], "Input",
 CellChangeTimes->{{3.636862143900945*^9, 3.636862144404974*^9}, {
  3.6368622922384295`*^9, 3.6368622945975647`*^9}, {3.637654602208517*^9, 
  3.6376546026945453`*^9}, {3.639722378350133*^9, 3.6397223837165427`*^9}, {
  3.7285842480919757`*^9, 
  3.7285842551076145`*^9}},ExpressionUUID->"e92e1b59-c2aa-4c04-8ce8-\
7ad8b8a2a087"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"7a96c0ae-9483-4087-9582-\
afa1a4e9cf53"],

Cell[CellGroupData[{

Cell["Solution 6.4", "Subsubsection",
 CellChangeTimes->{{3.712462983152072*^9, 3.7124629841599197`*^9}, {
  3.7303026093876133`*^9, 
  3.7303026164188747`*^9}},ExpressionUUID->"be072f19-6350-4e90-bcd2-\
0d010e554a88"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Y", ",", "r"}], "]"}], ";", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Y", ",", "r"}], "}"}], "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{
      RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
    RowBox[{"\"\<complexes\>\"", ",", "\"\<fhjgraphedges\>\""}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.712463443462889*^9, 3.7124634558674335`*^9}, 
   3.7124635261133413`*^9, {3.730302906950693*^9, 3.7303029250601044`*^9}, {
   3.7303032212325583`*^9, 3.7303032390138435`*^9}, {3.7307374209469147`*^9, 
   3.7307374648614335`*^9}},ExpressionUUID->"b2a0651b-bb58-4de2-8327-\
8242304909b8"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{"Outer", "[", 
      RowBox[{"SameQ", ",", "Y", ",", 
       RowBox[{"Last", "/@", "r"}]}], "]"}], "]"}], "-", 
    RowBox[{"Boole", "[", 
     RowBox[{"Outer", "[", 
      RowBox[{"SameQ", ",", "Y", ",", 
       RowBox[{"First", "/@", "r"}]}], "]"}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Y", ",", "r"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"TableAlignments", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Right", ",", "Top"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7124631608236785`*^9, 3.7124632703492994`*^9}, {
  3.730302974325827*^9, 
  3.7303029769039555`*^9}},ExpressionUUID->"860e6af6-533e-4c41-896e-\
0543b374d52f"],

Cell["Shorter, but less easy to read.", "Text",
 CellChangeTimes->{{3.730354337496447*^9, 
  3.7303543515589724`*^9}},ExpressionUUID->"d831b8ae-2887-4cba-a1ff-\
9856a8b12827"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Subtract", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Boole", "[", 
        RowBox[{"Outer", "[", 
         RowBox[{"SameQ", ",", "Y", ",", 
          RowBox[{"#", "/@", "r"}]}], "]"}], "]"}], "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{"Last", ",", "First"}], "}"}]}], ")"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Y", ",", "r"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"TableAlignments", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Right", ",", "Top"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.730354313605773*^9},ExpressionUUID->"38cca91e-bfab-431c-9890-\
4dbb46cf42ae"],

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"TableForm", "[", 
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{"Outer", "[", 
      RowBox[{"SameQ", ",", "Y", ",", 
       RowBox[{"Last", "/@", "r"}]}], "]"}], "]"}], "-", 
    RowBox[{"Boole", "[", 
     RowBox[{"Outer", "[", 
      RowBox[{"SameQ", ",", "Y", ",", 
       RowBox[{"First", "/@", "r"}]}], "]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7124631608236785`*^9, 3.7124632703492994`*^9}, {
  3.7124636232254243`*^9, 
  3.712463652378885*^9}},ExpressionUUID->"c19cd94b-936d-45a9-907a-\
96a55a99b602"],

Cell["\<\
A very short solution using the built-in function IncidenceMatrix of \
Mathematica.\
\>", "Text",
 CellChangeTimes->{{3.730354543371848*^9, 3.730354572778157*^9}, 
   3.7303546881377583`*^9, 
   3.730612916824*^9},ExpressionUUID->"31b0851c-1647-47ff-aea9-c77d563e5398"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"IncidenceMatrix", "[", 
    RowBox[{"Graph", "[", "r", "]"}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Y", ",", "r"}], "}"}]}], ",", 
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730354602793838*^9, 3.7303546728252263`*^9}, {
  3.7303547311378407`*^9, 
  3.7303547596535215`*^9}},ExpressionUUID->"7e286165-d158-4761-9874-\
0e129ff3aae4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 6.6", "Subsubsection",
 CellChangeTimes->{{3.712465860201313*^9, 3.712465866890232*^9}, {
  3.730303127247999*^9, 
  3.7303031307323813`*^9}},ExpressionUUID->"8040a812-60f6-45ba-9fd0-\
8157fe32f4f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Y", ",", "r"}], "]"}], ";", 
  RowBox[{"Y", "=", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], "]"}], "[", 
    "\"\<complexes\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.71246587130646*^9, 3.7124658853999233`*^9}, {
  3.730303162482443*^9, 
  3.7303031744043417`*^9}},ExpressionUUID->"8900a1a5-cf1f-4fb6-84b6-\
f09f5babbee1"],

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], "]"}], "[", 
   "\"\<fhjgraphedges\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.71246587130646*^9, 3.7124658853999233`*^9}, {
  3.712465921398218*^9, 3.712465929880849*^9}, {3.7303548109504986`*^9, 
  3.730354816184882*^9}},ExpressionUUID->"df7d33a4-b4d4-4948-b46d-\
29dbdd8eecc5"],

Cell["\<\
A version different from that given as solution to Problem 6.4 above follows.\
\>", "Text",
 CellChangeTimes->{{3.7303548327786646`*^9, 3.7303548584037156`*^9}, {
  3.7306129923397713`*^9, 
  3.730613005371049*^9}},ExpressionUUID->"893deef9-d9b4-4679-9273-\
94747784b3aa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gg", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"Which", "[", 
   RowBox[{
    RowBox[{"a", "===", 
     RowBox[{"b", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"a", "===", 
     RowBox[{"b", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ",", "1", ",", "True", ",", "0"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.71246587130646*^9, 3.7124658853999233`*^9}, {
  3.712465921398218*^9, 
  3.7124659498525963`*^9}},ExpressionUUID->"2bce7b44-93b3-4fca-a18d-\
27f22a79b84a"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Outer", "[", 
    RowBox[{"gg", ",", "Y", ",", "r"}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Y", ",", "r"}], "}"}]}], ",", 
   RowBox[{"TableAlignments", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Right", ",", "Top"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.71246587130646*^9, 3.7124658853999233`*^9}, {
  3.712465921398218*^9, 
  3.7124660023066425`*^9}},ExpressionUUID->"cdbd660e-88a1-4320-8f22-\
30abb680bde1"],

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"TableForm", "[", 
   RowBox[{"Outer", "[", 
    RowBox[{"gg", ",", "Y", ",", "r"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7124660450555773`*^9, 
  3.712466058511282*^9}},ExpressionUUID->"9a3c81c8-b188-40de-a575-\
63926a88ece0"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"IncidenceMatrix", "[", 
    RowBox[{"Graph", "[", "r", "]"}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Y", ",", "r"}], "}"}]}], ",", 
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]], "Input",Expressi\
onUUID->"2ddb5a2a-2c5d-4364-9239-d15350e91de3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 6.7", "Subsubsection",
 CellChangeTimes->{{3.712465860201313*^9, 3.712465866890232*^9}, {
  3.730303127247999*^9, 3.7303031307323813`*^9}, {3.730303285701434*^9, 
  3.730303286170185*^9}},ExpressionUUID->"6cc2d81a-bd58-4bb9-9c54-\
add6d9250bff"],

Cell[BoxData[
 RowBox[{"mole", "=", 
  RowBox[{"GetReaction", "[", "\"\<Mole\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.712466102043058*^9, 3.712466110461207*^9}, 
   3.728798203262045*^9},ExpressionUUID->"40a4cb49-c4c2-4bbe-bbd6-\
225a1fe8d696"],

Cell[BoxData[
 RowBox[{"Times", "@@@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"Union", "@", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Transpose", "/@", 
        RowBox[{
         RowBox[{"ReactionsData", "[", 
          RowBox[{"{", "mole", "}"}], "]"}], "[", 
         RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\""}], "]"}]}], ",", 
       "1"}], "]"}]}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.7124661192231493`*^9, 3.7124661994551163`*^9}, {
  3.712466234509579*^9, 3.7124662425227757`*^9}, {3.7124662790885763`*^9, 
  3.712466280792667*^9}, {3.7124663143204813`*^9, 3.7124663253805585`*^9}, {
  3.712466429295868*^9, 3.712466431111307*^9}, {3.730303387779759*^9, 
  3.7303034043266664`*^9}},ExpressionUUID->"dd792698-0ee6-4812-91a3-\
2337a66a8c1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 6.9", "Subsubsection",
 CellChangeTimes->{{3.712465860201313*^9, 3.712465866890232*^9}, {
  3.730303127247999*^9, 3.7303031307323813`*^9}, {3.730303285701434*^9, 
  3.730303286170185*^9}, {3.7303034924987144`*^9, 
  3.7303034933737154`*^9}},ExpressionUUID->"24936b84-74e9-41cc-990e-\
21221e31ed59"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", 
  RowBox[{"A", ",", "G", ",", "\[Alpha]", ",", "\[Gamma]"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"G", "[", 
   RowBox[{"\[Alpha]_", ",", "\[Gamma]_"}], "]"}], ":=", 
  RowBox[{"\[Gamma]", ".", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"Times", "@@", 
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "\[Alpha]"], ")"}]}], 
    "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.7303052291602707`*^9, 3.730305235988408*^9}, 
   3.7303059985211463`*^9},ExpressionUUID->"0e9be54e-9822-4ca0-bd95-\
e526b9afe088"],

Cell[BoxData[
 RowBox[{"G", "@@", 
  RowBox[{"Normal", "[", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "\"\<Mole\>\"", "}"}], "]"}], "[", 
    RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<\[Gamma]\>\""}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7303038101555834`*^9, 3.730303827327495*^9}, {
  3.7303038675775733`*^9, 3.7303038700150757`*^9}, {3.7303039117964077`*^9, 
  3.7303039629058843`*^9}, {3.730306015302431*^9, 3.730306017208683*^9}, {
  3.7303060831931887`*^9, 
  3.7303060896307015`*^9}},ExpressionUUID->"1cc25b38-f22b-4238-91c1-\
b14f71b62bc6"],

Cell[BoxData[
 RowBox[{"%", ".", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["k", "1"], ",", 
    SubscriptBox["k", "2"], ",", 
    SubscriptBox["k", "3"], ",", 
    SubscriptBox["k", "4"], ",", "k"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7303060308962135`*^9, 3.7303060639431515`*^9}, {
   3.7303061763652463`*^9, 3.730306176912122*^9}, 
   3.7303549519351482`*^9},ExpressionUUID->"052785d2-3f21-4054-874d-\
992c5e7401b8"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Mole\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "3"], ",", 
     SubscriptBox["k", "4"], ",", "k"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730306099411972*^9, 3.7303061187870083`*^9}, {
  3.730306149990196*^9, 3.7303061596308413`*^9}, {3.7303549250132203`*^9, 
  3.7303549418413773`*^9}},ExpressionUUID->"06c5f771-be89-4b1f-bd82-\
351320b6890f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 6.10", "Subsubsection",
 CellChangeTimes->{{3.7124697088613834`*^9, 3.7124697094080997`*^9}, {
  3.7303034707486706`*^9, 3.7303034760455575`*^9}, {3.7303062717248077`*^9, 
  3.7303062725529346`*^9}},ExpressionUUID->"4021757f-3dec-4545-8bdc-\
cad38fde14e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"b", ",", "a", ",", "e", ",", "f"}], "]"}], ";", 
  RowBox[{"Factor", "/@", 
   RowBox[{"RightHandSide", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<X\>\"", "+", "\"\<Y\>\""}], "\[Rule]", " ", 
       RowBox[{
        RowBox[{"2", "\"\<X\>\""}], "\[Rule]", " ", 
        RowBox[{"\"\<X\>\"", "\[Rule]", " ", 
         RowBox[{
         "0", " ", "\[ShortLeftArrow]", "\"\<Y\>\"", " ", "\[ShortLeftArrow]",
           " ", 
          RowBox[{"2", "\"\<Y\>\""}]}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "b", ",", "a", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7303062815529523`*^9, 3.7303062948342276`*^9}, {
  3.730306343974949*^9, 
  3.7303064348501263`*^9}},ExpressionUUID->"8986c6f1-c60a-4f81-96e5-\
402ad9f9e9dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 6.11", "Subsubsection",
 CellChangeTimes->{{3.7124697088613834`*^9, 3.7124697094080997`*^9}, {
  3.7303034707486706`*^9, 3.7303034760455575`*^9}, {3.7303064846158504`*^9, 
  3.7303064852564754`*^9}},ExpressionUUID->"4ddf678f-afd4-4086-b0a7-\
d3faebae8ad2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Y", ",", "x", ",", "y"}], "]"}], ";", 
  RowBox[{"DeterministicModel", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "X"}], "+", "Y"}], "\[Rule]", 
      RowBox[{"X", "+", 
       RowBox[{"2", "Y"}]}]}], "}"}], ",", 
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730306509178396*^9, 
  3.7303065698347654`*^9}},ExpressionUUID->"8534e428-ec79-4bc4-9dcd-\
038ac186b856"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 6.12", "Subsubsection",
 CellChangeTimes->{{3.7124697088613834`*^9, 3.7124697094080997`*^9}, {
  3.7303034707486706`*^9, 
  3.7303034760455575`*^9}},ExpressionUUID->"eb16680e-8ec2-4cab-bdfe-\
7d4ad1618201"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceAll", "@@", 
   RowBox[{"Concentrations", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", "\[Rule]", 
       RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<C\>\""}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a0", ",", "b0", ",", "c0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "t"}], "]"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a0", "\[Rule]", 
     SubscriptBox["a", "0"]}], ",", 
    RowBox[{"b0", "\[Rule]", 
     SubscriptBox["b", "0"]}], ",", 
    RowBox[{"c0", "\[Rule]", 
     SubscriptBox["c", "0"]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.712469712017167*^9, 3.7124697353767285`*^9}, {
  3.7124698741578536`*^9, 3.712469910939046*^9}, {3.730303580389512*^9, 
  3.730303698499117*^9}},ExpressionUUID->"a4f9a57e-8b9e-40ed-91cd-\
5af466145c75"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 6.15", "Subsubsection",
 CellChangeTimes->{{3.7124697088613834`*^9, 3.7124697094080997`*^9}, {
  3.7303034707486706`*^9, 3.7303034760455575`*^9}, {3.7303066269598775`*^9, 
  3.730306628225506*^9}},ExpressionUUID->"d46f45c6-c0cd-4a22-a19c-\
0af14fcd87e1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"x", ",", "y", ",", "eq"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eq", "=", 
  RowBox[{
   RowBox[{"DeterministicModel", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "X"}], "\[Rule]", 
       RowBox[{"3", "X"}]}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "x", "}"}]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.73030663019426*^9, 3.7303066312567606`*^9}, {
  3.7303067910250053`*^9, 3.73030684279073*^9}, {3.730306916368998*^9, 
  3.730306942900298*^9}, {3.7303070190879507`*^9, 3.7303070358067317`*^9}, {
  3.730307111900631*^9, 3.730307122963153*^9}, {3.730307172932001*^9, 
  3.7303071767132587`*^9}, {3.730307571135907*^9, 3.7303075793390455`*^9}, {
  3.7303076227453775`*^9, 3.730307639198538*^9}, {3.730307682011121*^9, 
  3.730307686698631*^9}, {3.7303550801420517`*^9, 3.7303551930495157`*^9}, {
  3.730613089168089*^9, 
  3.730613100777485*^9}},ExpressionUUID->"516a5ca4-3c55-4edd-a6c2-\
fb1b11a21aa6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "[", "t_", "]"}], ":=", 
  RowBox[{
   SubscriptBox["x", "0"], "+", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       SubscriptBox["c", "k"], 
       RowBox[{"k", "!"}]], 
      SuperscriptBox["t", "k"]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "5"}], "}"}]}], "]"}], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "t", "]"}], "6"]}]}]], "Input",
 CellChangeTimes->{{3.73030663019426*^9, 3.7303066312567606`*^9}, {
  3.7303067910250053`*^9, 3.73030684279073*^9}, {3.730306916368998*^9, 
  3.730306942900298*^9}, {3.7303070190879507`*^9, 3.7303070358067317`*^9}, {
  3.730307111900631*^9, 3.730307122963153*^9}, {3.730307172932001*^9, 
  3.7303071767132587`*^9}, {3.730307571135907*^9, 3.7303075793390455`*^9}, {
  3.7303076227453775`*^9, 3.730307639198538*^9}, {3.730307682011121*^9, 
  3.730307686698631*^9}, {3.7303550801420517`*^9, 
  3.7303551296268845`*^9}},ExpressionUUID->"ef02ccf7-2a6d-4788-a1c5-\
c32f565c3295"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "[", "t", "]"}], "/.", 
  RowBox[{"First", "@", 
   RowBox[{"Solve", "@", 
    RowBox[{"LogicalExpand", "[", "eq", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.730307531807703*^9, 3.730307557745253*^9}, {
  3.7303076556829443`*^9, 3.730307670229848*^9}, {3.730355208210385*^9, 
  3.7303552084403973`*^9}},ExpressionUUID->"387ee168-16d7-4b52-a4a3-\
caa9975a3bd9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "x", "]"}], ";", 
  RowBox[{
   RowBox[{"ReplaceAll", "@@", 
    RowBox[{"Concentrations", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "X"}], "\[Rule]", 
        RowBox[{"3", "X"}]}], "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "x0", "}"}], ",", 
      RowBox[{"{", "x", "}"}], ",", "t"}], "]"}]}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.730307279447837*^9, 3.7303073182135344`*^9}, {
   3.7303073495260954`*^9, 3.7303073787605295`*^9}, {3.730307742761239*^9, 
   3.7303077540268865`*^9}, 
   3.730307859464595*^9},ExpressionUUID->"86345d6c-aea5-46a2-b33a-\
6eec0b01bebb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 6.18", "Subsubsection",
 CellChangeTimes->{{3.7303078110894985`*^9, 
  3.730307815089507*^9}},ExpressionUUID->"2153adc5-5755-4df7-aa88-\
194e319e7bd9"],

Cell[BoxData[
 RowBox[{"?", "*Atom*"}]], "Input",
 CellChangeTimes->{{3.7303078423551855`*^9, 
  3.730307845214566*^9}},ExpressionUUID->"ce96d78e-77f7-4d1f-ae70-\
79542cac96b7"],

Cell[BoxData[
 RowBox[{"AtomConservingQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<HCOOH\>\"", "+", "\"\<CH3OH\>\""}], "\[Rule]", 
    RowBox[{"\"\<HCOOCH3\>\"", "+", "\"\<H2O\>\""}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7303078183238864`*^9, 3.730307820636392*^9}, 
   3.7303552854030123`*^9},ExpressionUUID->"f3255fdf-d4f6-4593-8683-\
3c478b3cae94"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 6.22", "Subsubsection",
 CellChangeTimes->{{3.7303078110894985`*^9, 3.730307815089507*^9}, {
  3.7303079191834607`*^9, 
  3.730307920136588*^9}},ExpressionUUID->"e450bd30-01b3-4b3d-b1aa-\
ec8f6c385e0a"],

Cell["See Fig. 14.7", "Text",
 CellChangeTimes->{{3.730307925308471*^9, 
  3.7303079363241186`*^9}},ExpressionUUID->"5afce474-49e1-4900-b663-\
7b88b9bedad9"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stationary", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
  3.7105102467029285`*^9, 
  3.710510249124808*^9}},ExpressionUUID->"c6b3047e-d8b1-4014-af21-\
37bd86c920b1"],

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"1eaaadff-63f5-41ea-b5ae-\
50216d3ed70a"],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"d4ba3008-8915-4fa2-b1a0-\
b131bebce928"],

Cell[CellGroupData[{

Cell["Solution 7.1", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
   3.7303081835433517`*^9, 3.7303081889964857`*^9}, 
   3.7303555817629657`*^9},ExpressionUUID->"d4426faf-698a-432e-9951-\
33956b74d1d6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "gb", "]"}], ";", 
  RowBox[{"Column", "[", 
   RowBox[{"gb", "=", 
    RowBox[{"GroebnerBasis", "[", 
     RowBox[{
      RowBox[{"poly", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", "x"}], "+", 
            RowBox[{"3", "y"}], "+", "z"}], ")"}]}], ",", 
         RowBox[{"y", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", "x"}], "-", 
            RowBox[{"2", "y"}], "+", "z"}], ")"}]}], ",", 
         RowBox[{"z", 
          RowBox[{"(", 
           RowBox[{"2", "+", "y", "-", "z"}], ")"}]}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7130841476824083`*^9, 3.713084170909321*^9}, {
  3.7130842029705467`*^9, 3.713084233416569*^9}, {3.7303558083538585`*^9, 
  3.73035581556927*^9}, {3.7303563992166166`*^9, 3.7303564007791195`*^9}, {
  3.730356573623208*^9, 
  3.7303565804669724`*^9}},ExpressionUUID->"d760995a-2ed9-4a87-b2e1-\
1914715f37af"],

Cell[BoxData[
 RowBox[{"TeXForm", "[", "gb", "]"}]], "Input",
 CellChangeTimes->{{3.7130846296978693`*^9, 
  3.71308463476969*^9}},ExpressionUUID->"39eaa7ad-1c91-4f35-af91-\
eb510543b473"],

Cell[BoxData[
 RowBox[{"TeXForm", "@", 
  RowBox[{"TableForm", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/.", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", "x"}], "+", 
             RowBox[{"3", "y"}], "+", "z"}], ")"}]}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"y", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"3", "x"}], "-", 
             RowBox[{"2", "y"}], "+", "z"}], ")"}]}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"z", 
           RowBox[{"(", 
            RowBox[{"2", "+", "y", "-", "z"}], ")"}]}], "\[Equal]", "0"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ",", 
    RowBox[{"TableHeadings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}], 
      "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7130844279552927`*^9, 3.71308452017801*^9}, {
  3.713084996972983*^9, 
  3.713085000113387*^9}},ExpressionUUID->"2b8ba274-fee9-4471-a607-\
59665b372772"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "x"}], "+", 
         RowBox[{"3", "y"}], "+", "z"}], ")"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", "x"}], "-", 
         RowBox[{"2", "y"}], "+", "z"}], ")"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"z", 
       RowBox[{"(", 
        RowBox[{"2", "+", "y", "-", "z"}], ")"}]}], "\[Equal]", "0"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7303577668442907`*^9, 
  3.7303577682349195`*^9}},ExpressionUUID->"0e5164a1-169b-45b8-a4e7-\
8193f4d6181c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.3", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
   3.7303081835433517`*^9, 3.7303081889964857`*^9}, 
   3.730357867985113*^9},ExpressionUUID->"9a111237-6cb7-4578-b571-\
be79b29a6f5e"],

Cell[BoxData[
 RowBox[{"Factor", "/@", 
  RowBox[{
   RowBox[{"DeterministicModel", "[", 
    RowBox[{
     RowBox[{"{", "\"\<Horn-Jackson\>\"", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "1", ",", "\[Epsilon]", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730357906828946*^9, 
  3.7303579912353544`*^9}},ExpressionUUID->"8c64a381-ae77-41a4-b67d-\
d687a18792ee"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[Epsilon]", " ", 
         SuperscriptBox[
          RowBox[{"x", "[", "t", "]"}], "2"]}], "-", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], " ", 
         RowBox[{"y", "[", "t", "]"}]}], "+", 
        RowBox[{"2", " ", "\[Epsilon]", " ", 
         RowBox[{"x", "[", "t", "]"}], " ", 
         RowBox[{"y", "[", "t", "]"}]}], "+", 
        RowBox[{"2", " ", "\[Epsilon]", " ", 
         SuperscriptBox[
          RowBox[{"y", "[", "t", "]"}], "2"]}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]", "\[Rule]", 
        FractionBox["1", "12"]}], "}"}]}], ")"}], "\[Equal]", "0"}], ",", 
   RowBox[{"y", "[", "t", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7303580320010595`*^9, 
  3.7303580969543123`*^9}},ExpressionUUID->"303a34b7-7618-4ba7-adff-\
f88cea856ff4"],

Cell[BoxData[
 RowBox[{"stat", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "\[Epsilon]", " ", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{"x", " ", "y"}], "+", 
      RowBox[{"2", " ", "\[Epsilon]", " ", "x", " ", "y"}], "+", 
      RowBox[{"2", " ", "\[Epsilon]", " ", 
       SuperscriptBox["y", "2"]}]}], "\[Equal]", "0"}], ",", "y"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7303580320010595`*^9, 3.7303580969543123`*^9}, {
  3.730358286642182*^9, 3.730358309579728*^9}, {3.73035834456417*^9, 
  3.7303583624392056`*^9}},ExpressionUUID->"edfe1cf9-5e07-4adb-8dbb-\
f0d8008328b5"],

Cell[BoxData[
 RowBox[{"ev", "=", 
  RowBox[{
   RowBox[{"EigensystemJacobian", "[", 
    RowBox[{
     RowBox[{"{", "\"\<Horn-Jackson\>\"", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "1", ",", "\[Epsilon]", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "/.", "stat"}]}]], "Input",
 CellChangeTimes->{{3.730358173079462*^9, 3.7303582557202487`*^9}, {
  3.7303583172516174`*^9, 3.730358319017247*^9}, {3.730892336516003*^9, 
  3.7308923409066377`*^9}},ExpressionUUID->"a7843eaf-ad91-4887-a564-\
d075fbef90c8"],

Cell["See also Fig. 7.3", "Text",
 CellChangeTimes->{{3.7303581194231052`*^9, 
  3.7303581387200193`*^9}},ExpressionUUID->"c5d3e799-2fb9-4ee0-93a9-\
fce1258c5c6a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.4", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
  3.7303081835433517`*^9, 3.7303081889964857`*^9}, {3.7306152852961903`*^9, 
  3.7306152859524403`*^9}},ExpressionUUID->"1c25d77c-ca1c-4763-b56c-\
b70359033e08"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "Z", "]"}], ";", 
  RowBox[{
   RowBox[{"Rest", "@", 
    RowBox[{"StationaryPoints", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"X", "+", "Y"}], "\[Rule]", "U"}], ",", 
        RowBox[{
         RowBox[{"Y", "+", "Z"}], "\[Rule]", "V"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k1", ",", "k2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x0", ",", "y0", ",", "0", ",", "z0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "u", ",", "z", ",", "v"}], "}"}]}], 
     "]"}]}], "//", "TableForm"}]}]], "Input",
 CellChangeTimes->{{3.7306153247962675`*^9, 
  3.7306154704371767`*^9}},ExpressionUUID->"a8090dd5-d5ab-47d7-adf4-\
e8d973af865e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.7", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
   3.7303081835433517`*^9, 3.7303081889964857`*^9}, 
   3.7306155672811174`*^9},ExpressionUUID->"8c322028-4425-4084-922b-\
3709728d1405"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\"\<A\>\"", "\[Equilibrium]", "\"\<B\>\""}], ",", 
   RowBox[{
    RowBox[{"2", " ", "\"\<A\>\""}], "\[Equilibrium]", 
    RowBox[{"2", "\"\<B\>\""}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.730616066391465*^9, 
  3.730616069610223*^9}},ExpressionUUID->"5c6d6d1a-5c31-40c9-86f6-\
d5cf15fb7499"],

Cell[BoxData[
 RowBox[{"DeterministicModel", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "\[Equilibrium]", "\"\<B\>\""}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\"\<A\>\""}], "\[Equilibrium]", 
      RowBox[{"2", "\"\<B\>\""}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["\"\<A\>\"", "2"], ",", "\"\<B\>\"", ",", "\"\<A\>\"", 
     ",", 
     SuperscriptBox["\"\<B\>\"", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"MassAction", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730615622156223*^9, 3.7306157153751554`*^9}, 
   3.7306160801258683`*^9},ExpressionUUID->"56c01f1e-80cc-4372-936c-\
531dc887f2f5"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "\[Equilibrium]", "\"\<B\>\""}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\"\<A\>\""}], "\[Equilibrium]", 
      RowBox[{"2", "\"\<B\>\""}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["\"\<A\>\"", "2"], ",", "\"\<B\>\"", ",", "\"\<A\>\"", 
     ",", 
     SuperscriptBox["\"\<B\>\"", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"MassAction", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730615622156223*^9, 3.7306157256876764`*^9}, 
   3.7306160873290076`*^9},ExpressionUUID->"0520efc5-0ce3-4f3e-b32e-\
a780f125eeac"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "\[Equilibrium]", "\"\<B\>\""}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\"\<A\>\""}], "\[Equilibrium]", 
      RowBox[{"2", "\"\<B\>\""}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["\"\<A\>\"", "2"], ",", "\"\<B\>\"", ",", "\"\<A\>\"", 
     ",", 
     SuperscriptBox["\"\<B\>\"", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x0", ",", "y0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "*"], ",", 
     SubscriptBox["y", "*"]}], "}"}], ",", 
   RowBox[{"MassAction", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7306157390627036`*^9, 3.7306157530314784`*^9}, {
  3.7306160921258907`*^9, 
  3.7306161271415854`*^9}},ExpressionUUID->"3281aedf-0f3c-4289-8f72-\
f2a286b6e280"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.8", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
  3.7303081835433517`*^9, 3.7303081889964857`*^9}, {3.7306162109230013`*^9, 
  3.7306162132042556`*^9}},ExpressionUUID->"fe732191-6c62-416f-ac31-\
7869e6c298ef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x_", ",", "y_", ",", "u_", ",", "z_", ",", "v_"}], "]"}], ":=", 
  FractionBox[
   SuperscriptBox["x", 
    SubscriptBox["k", "2"]], 
   SuperscriptBox["z", 
    SubscriptBox["k", "1"]]]}]], "Input",
 CellChangeTimes->{{3.7306163150794525`*^9, 
  3.7306163550639057`*^9}},ExpressionUUID->"a7f80202-4acc-4d76-8d3f-\
9968f9a22227"],

Cell[BoxData[
 RowBox[{"rh", "=", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "+", "Y"}], "\[Rule]", "U"}], ",", 
      RowBox[{
       RowBox[{"Y", "+", "Z"}], "\[Rule]", "V"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "u", ",", "z", ",", "v"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7306162640637293`*^9, 3.730616307563814*^9}, {
  3.730616392173355*^9, 
  3.730616392907731*^9}},ExpressionUUID->"33aa42fa-0d53-4ae9-9408-\
b6cc616052be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"\[Psi]", "[", 
     RowBox[{"x", ",", "y", ",", "u", ",", "z", ",", "v"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "u", ",", "z", ",", "v"}], "}"}], ",", 
      "1"}], "}"}]}], "]"}], ".", "rh"}]], "Input",
 CellChangeTimes->{{3.7306163657670536`*^9, 
  3.7306163975483637`*^9}},ExpressionUUID->"06f256fc-2b0e-4587-b91b-\
bfa92015ad1c"],

Cell[BoxData[
 RowBox[{"MatrixRank", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "y", ",", "u", ",", "z", ",", "v"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "u", ",", "z", ",", "v"}], "}"}], ",", 
        "1"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.730616425751547*^9, 3.730616495954808*^9}, {
  3.730616605423771*^9, 
  3.730616605705021*^9}},ExpressionUUID->"f3cdb03a-ab7b-4002-9f3f-\
aacb8d980117"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.9", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
   3.7303081835433517`*^9, 3.7303081889964857`*^9}, 
   3.730616641580094*^9},ExpressionUUID->"e3b76d9a-0624-40a7-9134-\
ea647e95768e"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"X", "\[DoubleLeftRightArrow]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2"}], "}"}], ",", 
   RowBox[{"{", "x0", "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["x", "*"], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730616644423848*^9, 
  3.7306166951583223`*^9}},ExpressionUUID->"4edb817f-d798-480a-8dd0-\
5970b8ea10dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.11", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
  3.7303081835433517`*^9, 3.7303081889964857`*^9}, {3.730616739002157*^9, 
  3.730616739424032*^9}},ExpressionUUID->"50fc3eb1-9125-4f1d-aa3a-\
46eef848280d"],

Cell[BoxData[
 RowBox[{"Concentrations", "[", 
  RowBox[{
   RowBox[{"ToReversible", "[", "\"\<Triangle\>\"", "]"}], ",", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{"k", "[", "#", "]"}], ",", "6"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a0", ",", "b0", ",", "c0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730616742189665*^9, 
  3.7306167865960007`*^9}},ExpressionUUID->"369516c1-443c-4370-8c68-\
cb4ab062ba60"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.12", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
  3.7303081835433517`*^9, 3.7303081889964857`*^9}, {3.730616845799239*^9, 
  3.7306168466429915`*^9}},ExpressionUUID->"a107ec6e-2c56-4866-b8f9-\
78a21210ca15"],

Cell[BoxData[
 RowBox[{"DeterministicModel", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Wegscheider\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "3"], ",", 
     SubscriptBox["k", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7306168781118045`*^9, 
  3.7306169721591797`*^9}},ExpressionUUID->"79f2a848-7240-4117-ba19-\
e4b8b34f57b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.13", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
  3.7303081835433517`*^9, 3.7303081889964857`*^9}, {3.730617023174903*^9, 
  3.730617023534279*^9}},ExpressionUUID->"8c689e12-d30e-4af9-a912-\
04b2cb2ca6fc"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "Y"}], "\[Rule]", 
     RowBox[{
      RowBox[{"3", "X"}], "\[Rule]", 
      RowBox[{
       RowBox[{"2", "X"}], "+", "Y"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7306170251436586`*^9, 
  3.7306170689874926`*^9}},ExpressionUUID->"566e9eb8-3bf4-423b-b3b7-\
3b029c3c085d"],

Cell[BoxData[
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "Y"}], "\[DoubleLeftRightArrow]", 
     RowBox[{"3", "X"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7306170251436586`*^9, 
  3.730617094331292*^9}},ExpressionUUID->"6fd109d3-63ff-4d63-8c1f-\
88d8e3d73833"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.14", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
  3.7303081835433517`*^9, 3.7303081889964857`*^9}, {3.7306171167219625`*^9, 
  3.730617117206337*^9}},ExpressionUUID->"6ab987a7-753d-4ff9-b58c-\
4052324bfa8b"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x0", ",", "y0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "*"], ",", 
     SubscriptBox["y", "*"]}], "}"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7306171227532225`*^9, 3.7306172065190115`*^9}, {
  3.7306191689939003`*^9, 
  3.730619175556413*^9}},ExpressionUUID->"2780e245-78a3-4d50-928b-\
9d5bdea0e029"],

Cell[BoxData[
 RowBox[{"olv", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["k", "3"], 
          RowBox[{"Log", "[", "x", "]"}]}], "+", 
         RowBox[{
          SubscriptBox["k", "1"], 
          RowBox[{"Log", "[", "y", "]"}]}], "-", 
         RowBox[{
          SubscriptBox["k", "2"], "x"}], "-", 
         RowBox[{
          SubscriptBox["k", "2"], "y"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", "1"}], "}"}]}], "]"}], 
      "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7306192198064985`*^9, 3.730619275462859*^9}, {
  3.730619307275421*^9, 3.7306193470254974`*^9}, {3.730619461275722*^9, 
  3.73061947602575*^9}},ExpressionUUID->"20628c60-d243-482b-aabf-\
6a1391840d29"],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["k", "3"], 
      RowBox[{"Log", "[", "x", "]"}]}], "+", 
     RowBox[{
      SubscriptBox["k", "1"], 
      RowBox[{"Log", "[", "y", "]"}]}], "-", 
     RowBox[{
      SubscriptBox["k", "2"], "x"}], "-", 
     RowBox[{
      SubscriptBox["k", "2"], "y"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "}"}]}], "]"}], "/.", 
  "olv"}]], "Input",
 CellChangeTimes->{{3.730619364384904*^9, 3.730619381853691*^9}, {
  3.730619468150735*^9, 
  3.7306194691507363`*^9}},ExpressionUUID->"69b811ac-1b4c-4a65-b02b-\
9a126a7f0031"],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["k", "3"], 
      RowBox[{"Log", "[", "x", "]"}]}], "+", 
     RowBox[{
      SubscriptBox["k", "1"], 
      RowBox[{"Log", "[", "y", "]"}]}], "-", 
     RowBox[{
      SubscriptBox["k", "2"], "x"}], "-", 
     RowBox[{
      SubscriptBox["k", "2"], "y"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "}"}]}], "]"}], "/.", 
  "olv"}]], "Input",ExpressionUUID->"08b0fdb8-6836-4b52-9c71-13eed6d4cd4a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.15", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
  3.7303081835433517`*^9, 3.7303081889964857`*^9}, {3.7306199706204667`*^9, 
  3.730619973807974*^9}},ExpressionUUID->"23b9a72a-5516-4b7a-aa75-\
82b871c01617"],

Cell[BoxData[
 RowBox[{"rs", "=", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", "\"\<Ivanova\>\"", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7306199797142353`*^9, 
  3.730620014433053*^9}},ExpressionUUID->"1838fc25-9e28-4ac7-b82a-\
fac9935ea73e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"x", "+", "y", "+", "z"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CurlyPhi]", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox["x", 
     SubscriptBox["k", "2"]], 
    SuperscriptBox["y", 
     SubscriptBox["k", "3"]], 
    SuperscriptBox["z", 
     SubscriptBox["k", "1"]]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7306200218705683`*^9, 
  3.7306200823706865`*^9}},ExpressionUUID->"fc68322b-7066-4e84-978d-\
a26038aaf497"],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"\[Psi]", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "1"}], "}"}]}], "]"}], 
  ".", "rs"}]], "Input",
 CellChangeTimes->{{3.730620096433213*^9, 
  3.7306201541989512`*^9}},ExpressionUUID->"7e59b36f-abec-4bac-b237-\
c6021995fd43"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CurlyPhi]", "[", 
      RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "1"}], "}"}]}], "]"}], 
   ".", "rs"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.730620096433213*^9, 
  3.730620172808362*^9}},ExpressionUUID->"4119985b-49d8-467f-a358-\
4767d7eccfd3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.16", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
  3.7303081835433517`*^9, 3.7303081889964857`*^9}, {3.7306202288084717`*^9, 
  3.7306202294334726`*^9}},ExpressionUUID->"167bf759-19dc-4779-9d75-\
dff45f2a2123"],

Cell[BoxData[
 RowBox[{"AbsoluteConcentrationRobustness", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7306202395741186`*^9, 
  3.7306202821210756`*^9}},ExpressionUUID->"9ff2622c-38fa-4be7-af38-\
a0d97e71a588"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.18", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
  3.7303081835433517`*^9, 3.7303081889964857`*^9}, {3.7306203548087187`*^9, 
  3.73062035565247*^9}},ExpressionUUID->"8c2950d4-bae8-4daf-890a-\
2227ae6ae602"],

Cell[BoxData[
 RowBox[{"Options", "[", "AbsoluteConcentrationRobustness", "]"}]], "Input",
 CellChangeTimes->{{3.7306205735778055`*^9, 
  3.7306205839344015`*^9}},ExpressionUUID->"cee16339-fc82-4080-a2cd-\
3a0ce5f41705"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"AbsoluteConcentrationRobustness", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
        "\"\<E\>\"", "+", "\"\<\!\(\*SubscriptBox[\(I\), \(p\)]\)\>\""}], 
        "\[LeftRightArrow]", "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\""}], 
       "\[Rule]", 
       RowBox[{"\"\<E\>\"", "+", "\"\<I\>\""}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\"", "+", "\"\<I\>\""}], 
        "\[LeftRightArrow]", "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)I\>\""}],
        "\[Rule]", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\"", "+", 
        "\"\<\!\(\*SubscriptBox[\(I\), \(p\)]\)\>\""}]}]}], "}"}], ",", 
    RowBox[{"TimeLimit", "\[Rule]", "600"}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.7306204468185472`*^9, 3.7306204809505005`*^9}, {
  3.730620873302518*^9, 3.730620883583788*^9}, {3.7308774593538733`*^9, 
  3.7308774638382587`*^9}},ExpressionUUID->"e19bb9ad-e4c8-4bcc-aaa7-\
63add03caecf"],

Cell["Cf. also with Fig. 7.8", "Text",
 CellChangeTimes->{{3.730620505062882*^9, 
  3.7306205183426437`*^9}},ExpressionUUID->"c20b1169-cbdb-489b-996f-\
80ea429b471c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"a", ",", "b", ",", "d", ",", "e"}], "]"}], ";", 
  RowBox[{"rihs", "=", 
   RowBox[{"RightHandSide", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
         "\"\<E\>\"", "+", "\"\<\!\(\*SubscriptBox[\(I\), \(p\)]\)\>\""}], 
         "\[LeftRightArrow]", "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\""}],
         "\[Rule]", 
        RowBox[{"\"\<E\>\"", "+", "\"\<I\>\""}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\"", "+", "\"\<I\>\""}], 
         "\[LeftRightArrow]", 
         "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)I\>\""}], "\[Rule]", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\"", "+", 
         "\"\<\!\(\*SubscriptBox[\(I\), \(p\)]\)\>\""}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "1"], ",", 
       SubscriptBox["k", 
        RowBox[{"-", "1"}]], ",", 
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", "3"], ",", 
       SubscriptBox["k", 
        RowBox[{"-", "3"}]], ",", 
       SubscriptBox["k", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7306214283036027`*^9, 3.730621539432026*^9}, {
  3.7306315759835453`*^9, 
  3.7306315783116746`*^9}},ExpressionUUID->"7904bc0c-aee3-4adb-9e3d-\
63e2f11b0b5f"],

Cell[BoxData[
 RowBox[{"?", "MassConservationRelations"}]], "Input",
 CellChangeTimes->{{3.730631832952799*^9, 
  3.730631833468424*^9}},ExpressionUUID->"38f30bf7-ce33-4345-8596-\
56294064907e"],

Cell[BoxData[
 RowBox[{"MassConservationRelations", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
       "\"\<E\>\"", "+", "\"\<\!\(\*SubscriptBox[\(I\), \(p\)]\)\>\""}], 
       "\[LeftRightArrow]", "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\""}], 
      "\[Rule]", 
      RowBox[{"\"\<E\>\"", "+", "\"\<I\>\""}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\"", "+", "\"\<I\>\""}], 
       "\[LeftRightArrow]", "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)I\>\""}], 
      "\[Rule]", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(EI\), \(p\)]\)\>\"", "+", 
       "\"\<\!\(\*SubscriptBox[\(I\), \(p\)]\)\>\""}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7306317935152206`*^9, 
  3.7306318238121614`*^9}},ExpressionUUID->"b32d4dd5-8a4f-4d7d-b4a0-\
56496b8fe259"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rihs", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       FractionBox[
        RowBox[{
         SubscriptBox["k", 
          RowBox[{"-", "1"}]], "+", 
         SubscriptBox["k", "2"]}], 
        RowBox[{"a", " ", 
         SubscriptBox["k", "1"]}]], "c"}]}], ",", 
     RowBox[{"e", "\[Rule]", 
      RowBox[{
       FractionBox[
        SubscriptBox["k", "2"], 
        SubscriptBox["k", "4"]], "c"}]}], ",", 
     RowBox[{"d", "\[Rule]", " ", 
      FractionBox[
       SubscriptBox["k", "2"], 
       SubscriptBox["k", "3"]]}]}], "}"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.7306315830148087`*^9, 3.730631705280678*^9}, {
  3.7306317408276205`*^9, 3.7306317495932646`*^9}, {3.730632042343834*^9, 
  3.7306320766564016`*^9}},ExpressionUUID->"dff076fc-c6f7-43a0-a325-\
6391e77cfe63"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 7.19", "Subsubsection",
 CellChangeTimes->{{3.7130988324410043`*^9, 3.713098839236224*^9}, {
  3.7303081835433517`*^9, 
  3.7303081889964857`*^9}},ExpressionUUID->"f28009cd-dc6a-4273-bc23-\
d13c08b7434d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"lilipota", ",", "f2", ",", "y0", ",", "f", ",", "XX", ",", "x"}], 
   "]"}], ";", 
  RowBox[{
   RowBox[{"lilipota", "[", 
    RowBox[{"f2_", ",", "y0_", ",", "f_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"f", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"f", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["f", "2"], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"f", "-", "f2"}], ")"}], "y0"}]}], ")"}]}], "-", 
    SuperscriptBox["f", "2"]}]}], ";"}], "\n", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"XX", "[", 
         RowBox[{"f2_", ",", "y0_", ",", "\[CurlyPhi]_"}], "]"}], ":=", 
        RowBox[{"x", "/.", 
         RowBox[{"NSolve", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"lilipota", "[", 
             RowBox[{"f2", ",", "y0", ",", 
              SuperscriptBox["10", "\[CurlyPhi]"]}], "]"}], "\[Equal]", "0"}],
            ",", 
           RowBox[{"{", "x", "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Distribute", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[CurlyPhi]", ",", 
           RowBox[{"XX", "[", 
            RowBox[{"f2", ",", "y0", ",", "\[CurlyPhi]"}], "]"}]}], "}"}], 
         ",", "List"}], "]"}]}], ")"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyPhi]", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.2"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f2", ",", 
       RowBox[{"1", "/", "135"}]}], "}"}], ",", "0.0009", ",", "0.0075", ",", 
     "0.0001"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y0", ",", 
       RowBox[{"10", "/", "27"}]}], "}"}], ",", "0.24", ",", "0.38", ",", 
     "0.01"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7130988432772694`*^9, 3.7130989445605526`*^9}, {
   3.7130990437909236`*^9, 3.713099200748701*^9}, {3.7130992880551186`*^9, 
   3.713099340095744*^9}, 
   3.7303081293557444`*^9},ExpressionUUID->"74e4c711-9968-47d7-a777-\
3f02a2e47166"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Transient", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
  3.7105102569685726`*^9, 
  3.7105102587810764`*^9}},ExpressionUUID->"e719ab93-8d7b-4256-bd31-\
5bfc125ab086"],

Cell[CellGroupData[{

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"c169eb7d-eda2-487a-9b6f-\
badf878d71f6"],

Cell[CellGroupData[{

Cell["Fig. 14.8", "Subsubsection",
 CellChangeTimes->{{3.728584360248444*^9, 3.728584361795323*^9}, 
   3.7286448209712057`*^9},ExpressionUUID->"aa8e7597-2323-41c4-9875-\
d690d2202ec0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "1"}], ";", 
  RowBox[{"b", "=", "2.5"}], ";"}], "\n", 
 RowBox[{"sp", "=", 
  RowBox[{"StreamPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "-", "x", "-", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "2"], "y"}]}], ",", 
      RowBox[{
       RowBox[{"b", " ", "x"}], "-", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "2"], "y"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "10"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.550813373092783*^9, 3.5508133814802628`*^9}, {
   3.550813585192914*^9, 3.5508135893431516`*^9}, 
   3.7287146979946613`*^9},ExpressionUUID->"f7007aff-24ff-41e0-b366-\
8a0b157e39ca"],

Cell[BoxData[
 RowBox[{"cp", "=", 
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "-", "x", "-", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "2"], "y"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", "x"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "2"], "y"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"ContourStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Red"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed", ",", "Blue"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5508130283090625`*^9, 3.5508130627980347`*^9}, {
   3.5508131254336176`*^9, 3.550813147034853*^9}, {3.5508133935939555`*^9, 
   3.550813484533157*^9}, {3.550813597059593*^9, 3.550813639610027*^9}, {
   3.55081697778996*^9, 3.5508169812141557`*^9}, {3.550817033674156*^9, 
   3.5508170569944897`*^9}, {3.5508170889603186`*^9, 3.5508170938826*^9}, 
   3.550817144671505*^9, {3.550817218157708*^9, 3.5508172183817205`*^9}, {
   3.55083081861961*^9, 3.5508308220748076`*^9}, {3.5508327094697604`*^9, 
   3.550832710253805*^9}, {3.55083332331087*^9, 3.5508333251589756`*^9}, {
   3.5508333761898947`*^9, 3.5508333771729507`*^9}, {3.5508340807021904`*^9, 
   3.550834144435836*^9}, 3.5508343496165714`*^9, {3.710567135349018*^9, 
   3.710567137364646*^9}},ExpressionUUID->"be90cd78-8dc3-4853-ba5f-\
01b5b3d76fd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x0", "=", "10.5"}], ";", 
  RowBox[{"brusselatorBendixson", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"sp", ",", "cp", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             FractionBox["1", 
              RowBox[{"b", "+", "1"}]], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             FractionBox["1", 
              RowBox[{"b", "+", "1"}]], ",", 
             FractionBox[
              RowBox[{"b", 
               RowBox[{"(", 
                RowBox[{"b", "+", "1"}], ")"}]}], "a"]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             FractionBox[
              RowBox[{"b", 
               RowBox[{"(", 
                RowBox[{"b", "+", "1"}], ")"}]}], "a"]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x0", ",", 
             RowBox[{"2", "-", "x0", "+", 
              FractionBox[
               RowBox[{"b", 
                RowBox[{"(", 
                 RowBox[{"b", "+", "1"}], ")"}]}], "a"]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             FractionBox["1", 
              RowBox[{"b", "+", "1"}]], ",", "0"}], "}"}]}], "}"}], "]"}], 
        ",", 
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           FractionBox["b", "a"]}], "}"}], "]"}], ",", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            FractionBox["b", "a"]}], "}"}], ",", "0.3"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
           "\"\<\!\(\*OverscriptBox[\(x\), \(.\)]\) = 0\>\"", ",", "Bold", 
            ",", "Medium", ",", "Red"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "1"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
           "\"\<\!\(\*OverscriptBox[\(y\), \(.\)]\) = 0\>\"", ",", "Bold", 
            ",", "Medium", ",", "Blue"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "5"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "12"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5508135765284185`*^9, {3.5508137018855886`*^9, 3.5508137064528503`*^9}, {
   3.550816564173302*^9, 3.5508166525783587`*^9}, {3.5508166896564794`*^9, 
   3.5508167274866433`*^9}, {3.5508168211830025`*^9, 
   3.5508169225207987`*^9}, {3.550816995152953*^9, 3.5508170122769322`*^9}, {
   3.550817177860403*^9, 3.550817226215169*^9}, {3.550830458423008*^9, 
   3.5508304923129463`*^9}, {3.550830649948962*^9, 3.5508306646678047`*^9}, {
   3.5508327197513485`*^9, 3.550832728854869*^9}, {3.5508327662710094`*^9, 
   3.550832824364332*^9}, {3.550833104452352*^9, 3.5508331207052813`*^9}, {
   3.5508331672279425`*^9, 3.550833265102541*^9}, {3.5508333004315615`*^9, 
   3.5508333011726036`*^9}, {3.55083333187836*^9, 3.5508333497693834`*^9}, {
   3.550833390234698*^9, 3.5508333910967474`*^9}, {3.5508334985408926`*^9, 
   3.5508335762433367`*^9}, {3.5508339423512774`*^9, 
   3.5508339831396103`*^9}, {3.550834254107108*^9, 3.550834318209775*^9}, {
   3.5508344158753614`*^9, 3.550834606937289*^9}, {3.550904981413479*^9, 
   3.5509050546686687`*^9}, {3.550905087742561*^9, 3.5509051331261563`*^9}, {
   3.5509052588143454`*^9, 3.5509053493355227`*^9}, {3.710566937802705*^9, 
   3.7105669445630903`*^9}},ExpressionUUID->"eb1084a2-71a9-4454-8b27-\
340f38dc93ad"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.8\>\"", ",", "brusselatorBendixson"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7105669484103107`*^9, 3.710566958503888*^9}, {
  3.7285843770141015`*^9, 
  3.72858438629537*^9}},ExpressionUUID->"1fcfee80-94fe-4e54-9d85-\
3e5e2738ed00"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.9", "Subsubsection",
 CellChangeTimes->{{3.72858443729547*^9, 3.728584440139225*^9}, 
   3.728644831814977*^9},ExpressionUUID->"a9568ddf-a6e9-4191-b217-\
2428838e30be"],

Cell[BoxData[
 RowBox[{"parabola", "=", 
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}], 
          SubscriptBox["k", "2"]}], "-", 
         RowBox[{
          SubscriptBox["k", "1"], 
          SubscriptBox["k", "3"]}]}], ")"}], "2"], "\[GreaterEqual]", 
      RowBox[{"4", "b", " ", 
       SubscriptBox["k", "1"], 
       SubscriptBox["k", "2"], 
       SubscriptBox["k", "3"]}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["k", "1"], "\[Rule]", "1"}], ",", 
       RowBox[{
        SubscriptBox["k", "2"], "\[Rule]", "1"}], ",", 
       RowBox[{
        SubscriptBox["k", "3"], "\[Rule]", "1"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", 
      RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5212634217453866`*^9, 3.521263513295623*^9}, {
  3.7105643617999372`*^9, 
  3.710564364003066*^9}},ExpressionUUID->"b623e636-337e-4b88-ad0c-\
2703ff7c30a0"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.9\>\"", ",", "parabola"}], "]"}]], "Input",
 CellChangeTimes->{{3.7105643678155737`*^9, 3.7105643757999654`*^9}, {
  3.728584469108033*^9, 
  3.7285844774361734`*^9}},ExpressionUUID->"ee09307b-29a9-41b0-9e03-\
7b9f6b0b36fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.10", "Subsubsection",
 CellChangeTimes->{{3.728584499592467*^9, 3.728584501795596*^9}, 
   3.728644839283742*^9},ExpressionUUID->"089e9422-7198-474b-90ee-\
b95aa9f1201a"],

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["k", "3"], "-", 
         SubscriptBox["k", "2"]}], ")"}]}], "\[GreaterEqual]", "0"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["k", "1"], "\[Rule]", "1"}], ",", 
       RowBox[{
        SubscriptBox["k", "2"], "\[Rule]", "2"}], ",", 
       RowBox[{
        SubscriptBox["k", "3"], "\[Rule]", "3"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", 
      RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{"Row", "[", 
      RowBox[{
      "{", "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)=1, \
\!\(\*SubscriptBox[\(k\), \(2\)]\)=2, \!\(\*SubscriptBox[\(k\), \
\(3\)]\)=3\>\"", "}"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5212668027597694`*^9, 3.5212669896584597`*^9}, {
  3.522862280807124*^9, 
  3.5228623051745176`*^9}},ExpressionUUID->"a72e6ebc-528d-44c9-bc72-\
30b57823c5bc"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.10A\>\"", ",", "p1"}], "]"}]], "Input",
 CellChangeTimes->{{3.7105664585522594`*^9, 3.7105664654546523`*^9}, {
  3.728584507076857*^9, 
  3.7285845130924935`*^9}},ExpressionUUID->"e10a97f4-6b30-477e-8acd-\
d28c801b7e61"],

Cell[BoxData[
 RowBox[{"p2", "=", 
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["k", "3"], "-", 
         SubscriptBox["k", "2"]}], ")"}]}], "\[GreaterEqual]", "0"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["k", "1"], "\[Rule]", "1"}], ",", 
       RowBox[{
        SubscriptBox["k", "2"], "\[Rule]", "3"}], ",", 
       RowBox[{
        SubscriptBox["k", "3"], "\[Rule]", "2"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", 
      RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{"Row", "[", 
      RowBox[{
      "{", "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)=1, \
\!\(\*SubscriptBox[\(k\), \(2\)]\)=3, \!\(\*SubscriptBox[\(k\), \
\(3\)]\)=2\>\"", "}"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5212668027597694`*^9, 3.5212669896584597`*^9}, {
  3.522862280807124*^9, 
  3.5228623051745176`*^9}},ExpressionUUID->"2e42f9c5-101a-42a6-89c3-\
0e551fe041ac"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.10B\>\"", ",", "p2"}], "]"}]], "Input",
 CellChangeTimes->{{3.7105664739721427`*^9, 3.710566485510801*^9}, {
  3.72858451826438*^9, 
  3.7285845247018905`*^9}},ExpressionUUID->"9f11103a-0119-4179-b711-\
271553878e62"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.11", "Subsubsection",
 CellChangeTimes->{{3.728584593952027*^9, 3.728584596514532*^9}, 
   3.7286448555025234`*^9},ExpressionUUID->"0a65bea2-a54e-421e-b78e-\
d8a201b600af"],

Cell[BoxData[
 RowBox[{"/.", 
  RowBox[{"x_Integer", "\[Rule]", 
   RowBox[{"Style", "[", 
    RowBox[{"x", ",", "Bold", ",", "12"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.730632300751326*^9, 
  3.7306323253294983`*^9}},ExpressionUUID->"a490552d-fce5-4d93-9653-\
12115ded88a9"],

Cell[BoxData[
 RowBox[{"complexgraphslotkavolterra", "=", 
  RowBox[{"GraphicsRow", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"GraphPlot", "[", 
       RowBox[{"#", ",", 
        RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", "\[Rule]", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", "\[Rule]", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", "\[Rule]", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", "\[Rule]", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", "\[Rule]", "0"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6353449282662745`*^9, 3.6353450139151735`*^9}, {
   3.635345058914747*^9, 3.6353450615608983`*^9}, {3.6353452129005547`*^9, 
   3.635345324138917*^9}, {3.7033923382569695`*^9, 3.703392366413274*^9}, {
   3.7033925366792316`*^9, 3.7033925464605*^9}, {3.7045379967823105`*^9, 
   3.70453803289538*^9}, 3.7306323314701366`*^9, {3.7306323657045794`*^9, 
   3.730632381032731*^9}, {3.730632432454708*^9, 3.730632477532921*^9}, 
   3.730632599017533*^9},ExpressionUUID->"afa22efc-9e4c-4455-97f6-\
43c1fb9796aa"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{
  "\"\<TothNagyPapp-Fig14.11\>\"", ",", "complexgraphslotkavolterra"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.635345356033741*^9, 3.6353453797270966`*^9}, {
  3.7033924025383463`*^9, 3.703392407944607*^9}, {3.728584618139574*^9, 
  3.7285846251239624`*^9}},ExpressionUUID->"834b9a50-c877-4e6c-866a-\
72153661eef6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.12", "Subsubsection",
 CellChangeTimes->{{3.7285846110145597`*^9, 3.7285846134833145`*^9}, 
   3.7286448639869146`*^9},ExpressionUUID->"a4e17fef-4201-4ae4-ba12-\
a369a3a88f90"],

Cell[BoxData[
 RowBox[{"complexgraphlotkavolterra", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "\[Rule]", "1"}], ",", 
      RowBox[{"0", "\[Rule]", "0"}], ",", 
      RowBox[{"2", "\[Rule]", "2"}], ",", 
      RowBox[{"1", "->", "2"}], ",", "\[IndentingNewLine]", 
      RowBox[{"1", "\[Rule]", "1"}]}], "}"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.635345051922347*^9, 3.6353451242714853`*^9}, {
  3.703392436725911*^9, 3.703392513147936*^9}, {3.730633025680199*^9, 
  3.730633081445935*^9}},ExpressionUUID->"b442afc7-1dc0-4aaf-9bae-\
ef32e9f66a54"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.12\>\"", ",", "complexgraphlotkavolterra"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.6353451971976566`*^9, 3.6353451990037594`*^9}, {
  3.635345335449564*^9, 3.6353453446890926`*^9}, {3.6353453874005356`*^9, 
  3.635345389466654*^9}, {3.703393094602197*^9, 3.7033930969147024`*^9}, {
  3.7285846312333508`*^9, 
  3.72858463898337*^9}},ExpressionUUID->"d0865587-8c2e-4ce8-a008-\
ecba4b625906"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.13", "Subsubsection",
 CellChangeTimes->{{3.7285847118897576`*^9, 3.728584714483513*^9}, {
  3.7286448893627806`*^9, 
  3.728644899534675*^9}},ExpressionUUID->"905c121c-8268-4662-b13c-\
e1b7457ff4bb"],

Cell[BoxData[
 RowBox[{"nflux", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(N\), \(2\)]\)\!\(\*SubscriptBox[\(O\), \
\(5\)]\)\>\"", ",", "Italic"}], "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(N\), \(2\)]\)\!\(\*SubscriptBox[\(O\), \
\(5\)]\)\>\"", ",", "Italic"}], "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(3\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(N\), \(2\)]\)\!\(\*SubscriptBox[\(O\), \
\(5\)]\)\>\"", ",", "Italic"}], "]"}]}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<NO\>\"", ",", "Italic"}], "]"}]}], ",", 
        RowBox[{"1", "/", "4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(3\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(N\), \(2\)]\)\!\(\*SubscriptBox[\(O\), \
\(5\)]\)\>\"", ",", "Italic"}], "]"}]}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(3\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", 
        RowBox[{"3", "/", "4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(3\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<NO\>\"", ",", "Italic"}], "]"}]}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<NO\>\"", ",", "Italic"}], "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"EdgeRenderingFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", 
          RowBox[{"0.01", "*", "#3"}], "]"}], ",", "Red", ",", 
         RowBox[{"Arrowheads", "\[Rule]", "0.07"}], ",", 
         RowBox[{"Arrow", "[", "#1", "]"}]}], "}"}], "&"}], ")"}]}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6094129235295897`*^9, 3.609412962964845*^9}, {
   3.6094130355979996`*^9, 3.6094131891357813`*^9}, {3.6094132366214976`*^9, 
   3.6094133002291355`*^9}, 3.609413382846861*^9, {3.609413427657424*^9, 
   3.6094135140603657`*^9}, 3.609413544320097*^9, {3.609413765078724*^9, 
   3.609413768613926*^9}, {3.6094138507746253`*^9, 3.6094138571309886`*^9}, {
   3.609413999842151*^9, 3.6094140208883553`*^9}, {3.6094142262030983`*^9, 
   3.6094142298103046`*^9}, {3.609414262354166*^9, 3.60941428078422*^9}, {
   3.609414392278597*^9, 3.6094144192771416`*^9}, {3.609414484230857*^9, 
   3.6094144850419035`*^9}, {3.609414553728832*^9, 3.6094147560584044`*^9}, {
   3.6094148441044407`*^9, 3.6094148654056587`*^9}, {3.6099275014711704`*^9, 
   3.609927870979305*^9}},ExpressionUUID->"b38e858e-bbf1-4c97-97bc-\
5fc90edab1a5"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.13A\>\"", ",", "nflux"}], "]"}]], "Input",
 CellChangeTimes->{{3.7105643112356005`*^9, 3.71056434774769*^9}, {
  3.728584733467924*^9, 
  3.7285847411085653`*^9}},ExpressionUUID->"8623f307-e43e-4db9-bedc-\
4882149fbef6"],

Cell[BoxData[
 RowBox[{"oflux", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(N\), \(2\)]\)\!\(\*SubscriptBox[\(O\), \
\(5\)]\)\>\"", ",", "Italic"}], "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(N\), \(2\)]\)\!\(\*SubscriptBox[\(O\), \
\(5\)]\)\>\"", ",", "Italic"}], "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(3\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", 
        RowBox[{"3", "/", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(N\), \(2\)]\)\!\(\*SubscriptBox[\(O\), \
\(5\)]\)\>\"", ",", "Italic"}], "]"}]}], ",", "1"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", 
        RowBox[{"2", "/", "5"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<NO\>\"", ",", "Italic"}], "]"}]}], ",", 
        RowBox[{"1", "/", "5"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(O\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", 
        RowBox[{"2", "/", "5"}]}], "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(3\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(N\), \(2\)]\)\!\(\*SubscriptBox[\(O\), \
\(5\)]\)\>\"", ",", "Italic"}], "]"}]}], ",", 
        RowBox[{"3", "/", "5"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(3\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", 
        RowBox[{"21", "/", "10"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(3\)]\)\>\"", ",", "Italic"}], 
          "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<NO\>\"", ",", "Italic"}], "]"}]}], ",", 
        RowBox[{"3", "/", "10"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<NO\>\"", ",", "Italic"}], "]"}], "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(NO\), \(2\)]\)\>\"", ",", "Italic"}], 
          "]"}]}], ",", 
        RowBox[{"3", "/", "5"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"EdgeRenderingFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", 
          RowBox[{"0.01", "*", "#3"}], "]"}], ",", "Red", ",", 
         RowBox[{"Arrowheads", "\[Rule]", "0.07"}], ",", 
         RowBox[{"Arrow", "[", "#1", "]"}]}], "}"}], "&"}], ")"}]}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6094129235295897`*^9, 3.609412962964845*^9}, {
   3.6094130355979996`*^9, 3.6094131891357813`*^9}, {3.6094132366214976`*^9, 
   3.6094133002291355`*^9}, 3.609413382846861*^9, {3.609413427657424*^9, 
   3.6094135140603657`*^9}, 3.609413544320097*^9, {3.609413765078724*^9, 
   3.609413768613926*^9}, {3.6094138507746253`*^9, 3.6094138571309886`*^9}, {
   3.609413999842151*^9, 3.6094140208883553`*^9}, {3.6094142262030983`*^9, 
   3.6094142298103046`*^9}, {3.609414262354166*^9, 3.60941428078422*^9}, {
   3.609414392278597*^9, 3.6094144192771416`*^9}, {3.609414484230857*^9, 
   3.6094144850419035`*^9}, {3.609414553728832*^9, 3.6094147560584044`*^9}, {
   3.6094148441044407`*^9, 3.6094148654056587`*^9}, {3.6099275014711704`*^9, 
   3.609927870979305*^9}, {3.6099279013570423`*^9, 
   3.6099280343736506`*^9}},ExpressionUUID->"063b34dd-1047-4390-a28a-\
eab1ac56dd4d"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.13B\>\"", ",", "oflux"}], "]"}]], "Input",
 CellChangeTimes->{{3.7105643112356005`*^9, 3.710564318534017*^9}, {
  3.7285847489679546`*^9, 
  3.728584755577342*^9}},ExpressionUUID->"03fbfd4a-b651-4f5b-94b7-\
bb88b041488e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.14", "Subsubsection",
 CellChangeTimes->{{3.7285848122493286`*^9, 3.7285848135462065`*^9}, 
   3.728644917690961*^9},ExpressionUUID->"aa36637a-ecda-4c66-83d7-\
37e822a516ed"],

Cell[BoxData[
 RowBox[{"DeterministicModel", "[", 
  RowBox[{
   RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"ExternalSpecies", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6099478300051193`*^9, 3.6099478326932735`*^9}, {
  3.609947882695133*^9, 3.6099479503790045`*^9}, {3.6099480010889053`*^9, 
  3.609948070881897*^9}},ExpressionUUID->"6671232e-1693-49b8-aacc-\
aecc5ed75384"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "inf", "]"}], ";", 
  RowBox[{
   RowBox[{"inf", "[", 
    RowBox[{"pm1_", ",", "pm2_", ",", "pm3_", ",", "pm4_"}], "]"}], ":=", 
   RowBox[{"GraphPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<X\>\"", "\[Rule]", "\"\<X\>\""}], ",", 
          RowBox[{"\"\<   \>\"", "<>", "pm1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<X\>\"", "\[Rule]", "\"\<Y\>\""}], ",", 
          RowBox[{"\"\<\\n\>\"", "<>", "pm2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<Y\>\"", "\[Rule]", "\"\<X\>\""}], ",", 
          RowBox[{"pm3", "<>", "\"\<\\n\>\""}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<Y\>\"", "\[Rule]", "\"\<Y\>\""}], ",", 
          RowBox[{"pm4", "<>", "\"\<   \>\""}]}], "}"}]}], "}"}], "/.", 
      RowBox[{"x_String", "\[Rule]", 
       RowBox[{"Style", "[", 
        RowBox[{"x", ",", "Bold", ",", "16"}], "]"}]}]}], ",", 
     RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
     RowBox[{"EdgeLabeling", "\[Rule]", "True"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.717322523240983*^9, 3.7173225872759457`*^9}, {
  3.7173226835105085`*^9, 
  3.7173228494483333`*^9}},ExpressionUUID->"0ad78456-efd8-462b-b696-\
fea40f4e36e0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"influLL", "=", 
   RowBox[{"inf", "[", 
    RowBox[{
    "\"\<+\>\"", ",", "\"\<+\>\"", ",", "\"\<-\>\"", ",", "\"\<-\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"influRL", "=", 
   RowBox[{"inf", "[", 
    RowBox[{
    "\"\<+\>\"", ",", "\"\<+\>\"", ",", "\"\<-\>\"", ",", "\"\<+\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"influLU", "=", 
   RowBox[{"inf", "[", 
    RowBox[{
    "\"\<-\>\"", ",", "\"\<+\>\"", ",", "\"\<-\>\"", ",", "\"\<-\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"influRU", "=", 
   RowBox[{"inf", "[", 
    RowBox[{
    "\"\<-\>\"", ",", "\"\<+\>\"", ",", "\"\<-\>\"", ",", "\"\<+\>\""}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{"influ", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"influLL", ",", "influRL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"influLU", ",", "influRU"}], "}"}]}], "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7173243251074705`*^9, 3.717324347216887*^9}, {
   3.717324738264527*^9, 3.7173248420772305`*^9}, {3.7173248869210663`*^9, 
   3.717324890092948*^9}, 
   3.7302144547549906`*^9},ExpressionUUID->"33fa3cde-29ca-4186-82fe-\
dbd930c2ebd1"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.14\>\"", ",", "influ"}], "]"}]], "Input",
 CellChangeTimes->{{3.7045405317287364`*^9, 3.7045405449943867`*^9}, {
  3.728584847749399*^9, 
  3.7285848544369106`*^9}},ExpressionUUID->"32cd007d-40f9-4426-a985-\
45019ea77c70"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"723c9ca8-8ebb-464a-b404-\
4da6acb2245f"],

Cell["Solution 8.3", "Subsubsection",
 CellChangeTimes->{{3.7303585515802*^9, 
  3.7303585576114635`*^9}},ExpressionUUID->"cdb8d12f-476a-450a-8056-\
fd61fc43fb11"],

Cell[CellGroupData[{

Cell["Solution 8.9", "Subsubsection",
 CellChangeTimes->{{3.7303585515802*^9, 3.7303585576114635`*^9}, {
  3.7303586655624313`*^9, 
  3.7303586664530582`*^9}},ExpressionUUID->"d8e02ef6-9b13-4d55-9270-\
9ac607d9755b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Y", ",", "x0", ",", "y0"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"DeterministicModel", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"X", "\[Rule]", 
     RowBox[{"Y", "\[Rule]", 
      RowBox[{"4", "X"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"con", "=", 
  RowBox[{"ReplaceAll", "@@", 
   RowBox[{"Concentrations", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"X", "\[Rule]", 
       RowBox[{"Y", "\[Rule]", 
        RowBox[{"4", "X"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "0"], ",", 
       SubscriptBox["y", "0"]}], "}"}], ",", "t"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.7303587177656555`*^9, 3.730358842656526*^9}, {
  3.7303589190316763`*^9, 3.7303589351723337`*^9}, {3.7306333139463882`*^9, 
  3.7306333247432833`*^9}},ExpressionUUID->"ceb13eb7-e672-4c09-b3eb-\
30bf7a5ca8a1"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"con", ",", 
   RowBox[{"t", "\[Rule]", 
    RowBox[{"+", "\[Infinity]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7303588478596625`*^9, 
  3.730358868687829*^9}},ExpressionUUID->"33c32a0e-86d4-4644-a0c1-\
e1c937ea57d2"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"X", "\[Rule]", 
     RowBox[{"Y", "\[Rule]", 
      RowBox[{"4", "X"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x0", ",", "y0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.73035899960996*^9, 
  3.7303590264225135`*^9}},ExpressionUUID->"e9221f6b-4ea1-4174-9704-\
82f5bc21c726"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", 
    RowBox[{"X", "\[Rule]", 
     RowBox[{"Y", "\[Rule]", 
      RowBox[{"4", "X"}]}]}], "}"}], "]"}], "[", "\"\<deficiency\>\"", 
  "]"}]], "Input",
 CellChangeTimes->{{3.730359035375656*^9, 
  3.730359058125698*^9}},ExpressionUUID->"5b34b4aa-aab2-4ce5-adb2-\
cebab62b6bc0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.12", "Subsubsection",
 CellChangeTimes->{{3.7303585515802*^9, 3.7303585576114635`*^9}, {
  3.7303586655624313`*^9, 3.7303586664530582`*^9}, {3.7303591394696074`*^9, 
  3.7303591398446083`*^9}},ExpressionUUID->"a6c9ccd0-77c8-4379-92a2-\
56191803b0f9"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Rho]", "#"], "&"}], ",", "3"}], "]"}], ".", 
     RowBox[{
      RowBox[{"ReactionsData", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Z", "\[LeftArrow]", "X"}], "\[Rule]", "Y"}], ",", 
         RowBox[{
          RowBox[{"Y", "+", "Z"}], "\[Rule]", 
          RowBox[{"2", "X"}]}]}], "}"}], "]"}], "[", "\"\<\[Gamma]\>\"", 
      "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Rho]", "#"], "&"}], ",", "3"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730378103400258*^9, 
  3.730378232322385*^9}},ExpressionUUID->"e6c5cb1e-b978-4276-bf06-\
db0bccfa25f8"],

Cell[BoxData[
 RowBox[{"GammaLeftNullSpace", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"\"\<Z\>\"", "\[LeftArrow]", "\"\<X\>\""}], "\[Rule]", 
     "\"\<Y\>\""}], ",", 
    RowBox[{
     RowBox[{"\"\<Y\>\"", "+", "\"\<Z\>\""}], "\[Rule]", 
     RowBox[{"2", "\"\<X\>\""}]}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.730378103400258*^9, 3.730378232322385*^9}, {
  3.7306334170715885`*^9, 3.730633458040419*^9}, {3.730633579071906*^9, 
  3.7306336307751317`*^9}},ExpressionUUID->"d0cf78a5-0de6-4a2c-9859-\
8faa97f25ff4"],

Cell[BoxData[
 RowBox[{"dm", "=", 
  RowBox[{
   RowBox[{"DeterministicModel", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Z", "\[LeftArrow]", "X"}], "\[Rule]", "Y"}], ",", 
       RowBox[{
        RowBox[{"Y", "+", "Z"}], "\[Rule]", 
        RowBox[{"2", "X"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7303782582443123`*^9, 
  3.7303783219475594`*^9}},ExpressionUUID->"785fed2d-b979-4534-9d72-\
73d5b1bfdd45"],

Cell[BoxData[
 RowBox[{"sa", "=", 
  RowBox[{"SolveAlways", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], ".", 
       RowBox[{"RightHandSide", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"Z", "\[LeftArrow]", "X"}], "\[Rule]", "Y"}], ",", 
           RowBox[{
            RowBox[{"Y", "+", "Z"}], "\[Rule]", 
            RowBox[{"2", "X"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "]"}], 
     "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730378344681981*^9, 3.7303784341352787`*^9}, {
  3.7303784660259666`*^9, 
  3.7303784679790964`*^9}},ExpressionUUID->"3031dbf5-c72a-4906-bab2-\
3181df389b94"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sa", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "2"}], ",", 
    RowBox[{"b", "\[Rule]", "1"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.730378471244726*^9, 
  3.7303784978697777`*^9}},ExpressionUUID->"c3dc3c13-5217-4add-8256-\
ee451a893f63"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.13", "Subsubsection",
 CellChangeTimes->{{3.7303585515802*^9, 3.7303585576114635`*^9}, {
  3.7303586655624313`*^9, 3.7303586664530582`*^9}, {3.7303591394696074`*^9, 
  3.7303591398446083`*^9}, {3.730378514072933*^9, 
  3.7303785150885625`*^9}},ExpressionUUID->"48e691fb-ade7-4537-bf5d-\
65b7bd63911d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{
    RowBox[{"ToReversible", "[", "\"\<Lotka-Volterra\>\"", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
  "\"\<deficiency\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.73037854772925*^9, 
  3.7303785805886903`*^9}},ExpressionUUID->"276cbb37-e7d0-4e75-9ede-\
187664abd681"],

Cell[BoxData[
 RowBox[{"DetailedBalanced", "[", 
  RowBox[{
   RowBox[{"ToReversible", "[", "\"\<Lotka-Volterra\>\"", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "1"], ",", 
     SubscriptBox["k", 
      RowBox[{"-", "1"}]], ",", 
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", 
      RowBox[{"-", "2"}]], ",", 
     SubscriptBox["k", 
      RowBox[{"-", "3"}]], ",", 
     SubscriptBox["k", "3"]}], "}"}], ",", 
   RowBox[{"ExternalSpecies", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730378726213978*^9, 3.7303787627765465`*^9}, {
  3.7303788573236065`*^9, 3.7303788646829967`*^9}, {3.730378970089452*^9, 
  3.7303790386677113`*^9}},ExpressionUUID->"6f683840-fc6a-49dd-9902-\
674e31f6514c"],

Cell[BoxData[
 RowBox[{"rhs", "=", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"ToReversible", "[", "\"\<Lotka-Volterra\>\"", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", 
       RowBox[{"-", "1"}]], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", 
       RowBox[{"-", "2"}]], ",", 
      SubscriptBox["k", 
       RowBox[{"-", "3"}]], ",", 
      SubscriptBox["k", "3"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"ExternalSpecies", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730378726213978*^9, 3.7303787627765465`*^9}, {
  3.7303788573236065`*^9, 3.7303788646829967`*^9}, {3.730378970089452*^9, 
  3.7303790386677113`*^9}, {3.73037909869908*^9, 3.730379123949128*^9}, {
  3.730379443777878*^9, 
  3.7303794453403797`*^9}},ExpressionUUID->"4ad2dd2e-9cf1-4901-8a18-\
7077c9bc6837"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["k", "2"], 
     FractionBox[
      SubscriptBox["k", "1"], 
      SubscriptBox["k", 
       RowBox[{"-", "1"}]]], 
     FractionBox[
      SubscriptBox["k", 
       RowBox[{"-", "3"}]], 
      SubscriptBox["k", "3"]]}], "==", 
    RowBox[{
     SubscriptBox["k", 
      RowBox[{"-", "2"}]], 
     FractionBox[
      SuperscriptBox[
       SubscriptBox["k", 
        RowBox[{"-", "3"}]], "2"], 
      SuperscriptBox[
       SubscriptBox["k", "3"], "2"]]}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["k", "1"], ",", 
        SubscriptBox["k", 
         RowBox[{"-", "1"}]], ",", 
        SubscriptBox["k", "2"], ",", 
        SubscriptBox["k", 
         RowBox[{"-", "2"}]], ",", 
        SubscriptBox["k", 
         RowBox[{"-", "3"}]], ",", 
        SubscriptBox["k", "3"]}], "}"}], ">", "0"}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7303799505288744`*^9, 
  3.7303800153571186`*^9}},ExpressionUUID->"9326d7dd-52e6-4d5b-9e22-\
643c89cda783"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.14", "Subsubsection",
 CellChangeTimes->{{3.7303585515802*^9, 3.7303585576114635`*^9}, {
  3.7303586655624313`*^9, 3.7303586664530582`*^9}, {3.7303591394696074`*^9, 
  3.7303591398446083`*^9}, {3.730378514072933*^9, 3.7303785150885625`*^9}, {
  3.7303800564196997`*^9, 
  3.730380056700949*^9}},ExpressionUUID->"179c2a2f-5385-4f0a-8885-\
3c5382ec1704"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"dm", ",", "a", ",", "b"}], "]"}], ";", 
  RowBox[{"dm", "=", 
   RowBox[{
    RowBox[{"DeterministicModel", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<P\>\"", "\[Rule]", "\"\<A\>\""}], ",", 
        RowBox[{
         RowBox[{"\"\<A\>\"", "+", 
          RowBox[{"2", "\"\<B\>\""}]}], "\[Rule]", 
         RowBox[{"3", "\"\<B\>\""}]}], ",", 
        RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<C\>\""}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["k", "1"], "p"}], ",", 
        SubscriptBox["k", "2"], ",", 
        SubscriptBox["k", "3"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"ExternalSpecies", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<P\>\"", ",", "\"\<C\>\""}], "}"}]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7303801370604825`*^9, 3.7303802631007767`*^9}, {
   3.73038033382232*^9, 3.730380334462945*^9}, {3.730380372275519*^9, 
   3.7303803726817703`*^9}, {3.7303804561819315`*^9, 3.730380477150725*^9}, 
   3.730380533088338*^9, {3.7308929392515554`*^9, 
   3.7308929426734414`*^9}},ExpressionUUID->"3baa97a0-62b3-4cee-91a6-\
ac71daa06371"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<P\>\"", "\[Rule]", "\"\<A\>\""}], ",", 
      RowBox[{
       RowBox[{"\"\<A\>\"", "+", 
        RowBox[{"2", "\"\<B\>\""}]}], "\[Rule]", 
       RowBox[{"3", "\"\<B\>\""}]}], ",", 
      RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<C\>\""}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "1"], "p"}], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"ExternalSpecies", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<P\>\"", ",", "\"\<C\>\""}], "}"}]}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["k", "1"], "\[Rule]", 
     FractionBox["\[Mu]", "p"]}], ",", 
    RowBox[{
     SubscriptBox["k", "2"], "\[Rule]", "1"}], ",", 
    RowBox[{
     SubscriptBox["k", "3"], "\[Rule]", "1"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.730380302416009*^9, 3.730380345556716*^9}, {
   3.730380379025532*^9, 3.73038038771305*^9}, {3.7303804951195126`*^9, 
   3.7303805006507697`*^9}, 3.7303805367758403`*^9, {3.7306340397134314`*^9, 
   3.730634096729168*^9}},ExpressionUUID->"7ca70dd0-f6c5-4378-8e20-\
22a7053982ba"],

Cell[BoxData[
 RowBox[{"evj", "=", 
  RowBox[{
   RowBox[{"EigensystemJacobian", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<P\>\"", "\[Rule]", "\"\<A\>\""}], ",", 
       RowBox[{
        RowBox[{"\"\<A\>\"", "+", 
         RowBox[{"2", "\"\<B\>\""}]}], "\[Rule]", 
        RowBox[{"3", "\"\<B\>\""}]}], ",", 
       RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<C\>\""}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Mu]", "/", "p"}], ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"ExternalSpecies", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<P\>\"", ",", "\"\<C\>\""}], "}"}]}]}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"1", "/", "\[Mu]"}]}], ",", 
     RowBox[{"b", "\[Rule]", "\[Mu]"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7306338678380957`*^9, 3.7306338909162655`*^9}, {
  3.730634011400876*^9, 3.730634017916512*^9}, {3.730634115588579*^9, 
  3.7306341659168024`*^9}, {3.7306342049637547`*^9, 3.7306342063075075`*^9}, {
  3.7308929142515097`*^9, 3.730892920157771*^9}, {3.730892975173505*^9, 
  3.730892975954756*^9}},ExpressionUUID->"ecbc5ce4-41e2-4e80-b08a-\
7a0fbff8fdbd"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "[", "\[Mu]", "]"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "[", "\[Mu]", "]"}]}], "}"}], "=", 
   RowBox[{"evj", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7306342123231454`*^9, 3.7306342280106745`*^9}, {
  3.7306342772607713`*^9, 
  3.7306342789638996`*^9}},ExpressionUUID->"045ad276-c3d2-4ec2-bdf6-\
235c3bf2c47e"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["\[Mu]", "2"]}], "+", 
    SuperscriptBox["\[Mu]", "4"]}], "\[Equal]", "0"}], "]"}]], "Input",
 CellChangeTimes->{{3.7303848685004773`*^9, 
  3.7303848738286114`*^9}},ExpressionUUID->"94afeee3-8ba1-46af-91ca-\
769cf74c774d"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["\[Mu]", "2"]}], "+", 
    SuperscriptBox["\[Mu]", "4"]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Mu]", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7303848936255236`*^9, 
  3.7303849210787034`*^9}},ExpressionUUID->"dbb9d543-0d39-4c67-9d9e-\
cbbecc0e56a7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Lambda]", "-"], "[", "\[Mu]", "]"}], ",", 
    RowBox[{
     SubscriptBox["\[Lambda]", "+"], "[", "\[Mu]", "]"}]}], "}"}], "/.", 
  RowBox[{"\[Mu]", "\[Rule]", "1"}]}]], "Input",
 CellChangeTimes->{{3.730385025610158*^9, 
  3.7303850300007906`*^9}},ExpressionUUID->"b9af0142-0c57-4ed2-a54d-\
80a54d9d7d81"],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "[", "\[Mu]", "]"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "[", "\[Mu]", "]"}]}], "}"}], ",", 
    "\[Mu]"}], "]"}], "/.", 
  RowBox[{"\[Mu]", "\[Rule]", "1"}]}]], "Input",
 CellChangeTimes->{{3.73038504948521*^9, 
  3.7303850629071045`*^9}},ExpressionUUID->"7e41247b-285e-4023-8e85-\
6fd3359bb9ed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "x"}], " ", 
      SuperscriptBox["y", "2"]}], "+", "\[Mu]"}], ",", 
    RowBox[{
     RowBox[{"-", "y"}], "+", 
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7306343092920837`*^9, 
  3.7306343196514797`*^9}},ExpressionUUID->"821d1e06-d968-44db-9c22-\
23854cc79f21"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.730385273345022*^9, 3.730385277829401*^9}, {
  3.730634330448373*^9, 
  3.7306343323546286`*^9}},ExpressionUUID->"46c00470-3d20-4894-83a2-\
7dd8e33fe761"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "16"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ff", "[", 
         RowBox[{"x", ",", "y"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "3"}], "}"}]}], "]"}], "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ff", "[", 
         RowBox[{"x", ",", "y"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "2"}], "}"}]}], "]"}], "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ff", "[", 
         RowBox[{"x", ",", "y"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}], "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ff", "[", 
         RowBox[{"x", ",", "y"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "3"}], "}"}]}], "]"}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"16", " ", "1"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ff", "[", 
         RowBox[{"x", ",", "y"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ff", "[", 
           RowBox[{"x", ",", "y"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "+", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ff", "[", 
           RowBox[{"x", ",", "y"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ")"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.7303851366416273`*^9, 3.7303852009229994`*^9}, {
   3.730385297095063*^9, 3.730385352485798*^9}, {3.73038539451713*^9, 
   3.7303855233142557`*^9}, 
   3.730385590158141*^9},ExpressionUUID->"2bde357e-30f1-4f46-96a0-\
4ee2ea86dec0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.15", "Subsubsection",
 CellChangeTimes->{{3.730634411307909*^9, 
  3.730634421464182*^9}},ExpressionUUID->"a982e97f-3f70-45b9-815b-\
2fd7fc4fc949"],

Cell[BoxData[
 RowBox[{"nos", "=", 
  RowBox[{
   RowBox[{"GetReaction", "[", 
    RowBox[{"{", "\"\<Explodator\>\"", "}"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"aExplodator", "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Beta]", "1"], "-", "1"}]}], ",", 
     RowBox[{"bExplodator", "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Beta]", "2"], "-", "1"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7130162360660644`*^9, 3.7130162612855616`*^9}, 
   3.728798202840169*^9, 
   3.7306351415905867`*^9},ExpressionUUID->"c8fa88f5-d425-44a1-9e23-\
8905ef8bfe29"],

Cell[BoxData[
 RowBox[{"rhs", "=", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", "nos", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"], ",", 
      SubscriptBox["k", "4"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"ExternalSpecies", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<P\>\""}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.713016608395878*^9, 3.7130166677848597`*^9}, {
   3.730634690183454*^9, 3.730634707105361*^9}, {3.7306350325434985`*^9, 
   3.730635073309203*^9}, 
   3.730635137106202*^9},ExpressionUUID->"8b5adb2f-4428-4a0c-a983-\
e5546fb09543"],

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"StationaryPoints", "[", 
   RowBox[{
    RowBox[{"{", "nos", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"], ",", 
      SubscriptBox["k", "4"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0", ",", "z0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"ExternalSpecies", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<P\>\""}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7130162303327117`*^9, 3.7130162303327117`*^9}, {
  3.7130162744735117`*^9, 3.713016452659653*^9}, {3.713016770832526*^9, 
  3.713016788254447*^9}, {3.730635164262506*^9, 
  3.7306351688093896`*^9}},ExpressionUUID->"57f7b2a7-14c7-48bc-8c7c-\
653a65c08975"],

Cell[BoxData[
 RowBox[{"stp", "=", 
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "2"}], "]"}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.7130164552540274`*^9, 3.7130164780979013`*^9}, {
  3.7306346374958515`*^9, 3.730634638667729*^9}, {3.730635199309449*^9, 
  3.7306352198094893`*^9}},ExpressionUUID->"2e8dca9f-95b7-4fbd-b104-\
41f164457e59"],

Cell[BoxData[
 RowBox[{"ejm0", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"EigensystemJacobian", "[", 
      RowBox[{
       RowBox[{"{", "nos", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["k", "1"], ",", 
         SubscriptBox["k", "2"], ",", 
         SubscriptBox["k", "3"], ",", 
         SubscriptBox["k", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
       RowBox[{"ExternalSpecies", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<A\>\"", ",", "\"\<P\>\""}], "}"}]}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "0"}], ",", 
      RowBox[{"y", "\[Rule]", "0"}], ",", 
      RowBox[{"z", "\[Rule]", "0"}]}], "}"}]}], "//", 
   "ToRadicals"}]}]], "Input",
 CellChangeTimes->{{3.713016608395878*^9, 3.7130166677848597`*^9}, {
  3.730634690183454*^9, 3.7306348812150774`*^9}, {3.730635333028464*^9, 
  3.7306353479034905`*^9}, {3.73089303128299*^9, 
  3.730893036954878*^9}},ExpressionUUID->"2e29da28-87af-4b70-842b-\
9f410e7d7016"],

Cell[BoxData[
 RowBox[{"stp", "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7306349221214066`*^9, 
  3.730634959574605*^9}},ExpressionUUID->"0c69ae6c-a382-4551-8e27-\
cb9a66ac2d7f"],

Cell[BoxData[
 RowBox[{"ejm1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"EigensystemJacobian", "[", 
     RowBox[{
      RowBox[{"{", "nos", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["k", "1"], ",", 
        SubscriptBox["k", "2"], ",", 
        SubscriptBox["k", "3"], ",", 
        SubscriptBox["k", "4"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"ExternalSpecies", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<A\>\"", ",", "\"\<P\>\""}], "}"}]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "/.", 
   RowBox[{"stp", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.713016608395878*^9, 3.7130166677848597`*^9}, {
   3.730634690183454*^9, 3.730634906965128*^9}, 3.730634970746504*^9, 
   3.730635300622147*^9, 3.730635337215971*^9, {3.730893039861131*^9, 
   3.730893044829892*^9}, {3.7308932370856824`*^9, 
   3.730893240279868*^9}},ExpressionUUID->"1676b426-0056-401e-ad05-\
3a492ee0d1e4"],

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"jac", "=", 
   RowBox[{"D", "[", 
    RowBox[{"rhs", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "1"}], "}"}]}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.713016670817464*^9, 3.7130166891294303`*^9}, {
  3.730635496778781*^9, 
  3.7306355034506693`*^9}},ExpressionUUID->"93220d5e-322b-4510-bcfa-\
506ec3003fd5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"jac", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.7130166919416914`*^9, 
  3.7130167159664984`*^9}},ExpressionUUID->"fb046407-9e78-4cfe-8342-\
ed5f1b69633d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"jac", "/.", 
   RowBox[{"stp", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}], "]"}], "]"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{
  3.730635480153747*^9},ExpressionUUID->"353f16d7-b2e4-46d4-a6d1-\
e970644cf6f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tr", "[", 
   RowBox[{"jac", "/.", 
    RowBox[{"stp", "[", 
     RowBox[{"[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5"}], "}"}], "]"}], "]"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.7308937489191504`*^9, 3.7308937491535244`*^9}, {
  3.7308939166382275`*^9, 
  3.7308939266069965`*^9}},ExpressionUUID->"f071784e-59aa-4d46-bfdb-\
9e660efccf00"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", 
   RowBox[{"jac", "/.", 
    RowBox[{"stp", "[", 
     RowBox[{"[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5"}], "}"}], "]"}], "]"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.7308936840596504`*^9, 
  3.7308937057940655`*^9}},ExpressionUUID->"41eef70f-e87f-4071-9deb-\
c4384ea81ab8"],

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CharacteristicPolynomial", "[", 
     RowBox[{
      RowBox[{"jac", "/.", 
       RowBox[{"stp", "[", 
        RowBox[{"[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "5"}], "}"}], "]"}], "]"}]}], ",", 
      "x"}], "]"}], "//", "FullSimplify"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.7308939329820094`*^9, 3.7308939359038906`*^9}, {
  3.7308939971071334`*^9, 
  3.7308940519509916`*^9}},ExpressionUUID->"84278b59-1214-4b8c-8e52-\
93312471bd57"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.16", "Subsubsection",
 CellChangeTimes->{{3.730636332227199*^9, 
  3.7306363421147676`*^9}},ExpressionUUID->"b03fe876-e37e-4f54-a32a-\
bde999b40177"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vichaos", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[Rule]", 
      RowBox[{"2", "\"\<B\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<B\>\"", "+", "\"\<C\>\""}], "\[Rule]", 
      RowBox[{"2", "\"\<C\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<C\>\"", "+", "\"\<A\>\""}], "\[Rule]", 
      RowBox[{"2", "\"\<A\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<A\>\"", "+", "\"\<D\>\""}], "\[Rule]", 
      RowBox[{"2", "\"\<D\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<D\>\"", "+", "\"\<E\>\""}], "\[Rule]", 
      RowBox[{"2", "\"\<E\>\""}]}], ",", 
     RowBox[{
      RowBox[{"\"\<E\>\"", "+", "\"\<A\>\""}], "\[Rule]", 
      RowBox[{"2", "\"\<A\>\""}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7130235202879734`*^9, 3.7130235301157694`*^9}, {
  3.713023630070469*^9, 3.713023685022703*^9}, {3.713023723397668*^9, 
  3.713023775444295*^9}},ExpressionUUID->"36dd6e21-e4cf-421b-ae4a-\
e71144016782"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", "vichaos", "}"}], "]"}], "[", 
  RowBox[{"\"\<species\>\"", ",", "\"\<reactionsteps\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.713023813992098*^9, 
  3.713023849288148*^9}},ExpressionUUID->"e5b34e85-1d43-4bca-8aae-\
4b4a769d389d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"spvi", "=", 
    RowBox[{
     RowBox[{"StationaryPoints", "[", 
      RowBox[{
       RowBox[{"{", "vichaos", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "100", ",", "660", ",", "600", ",", "100", ",", "660", ",", "360"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"aa", ",", "bb", ",", "cc", ",", "dd", ",", "ee"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "//", "Column"}]], "Input",
 CellChangeTimes->{{3.713023540053816*^9, 3.713023622381693*^9}, {
  3.7130237123812084`*^9, 3.713023715554431*^9}, {3.7130238705695314`*^9, 
  3.713023937647108*^9}, {3.713023990758198*^9, 
  3.713024003084756*^9}},ExpressionUUID->"79ce0a41-df9b-4b50-926e-\
f4c670b3e1a1"],

Cell[BoxData[
 RowBox[{"spvi", "[", 
  RowBox[{"[", "7", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.713024006319519*^9, 
  3.7130240089600744`*^9}},ExpressionUUID->"0f426ab9-483f-4cd4-ac8c-\
e5e5fe6f37b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"RightHandSide", "[", 
     RowBox[{
      RowBox[{"{", "vichaos", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "100", ",", "660", ",", "600", ",", "100", ",", "660", ",", "360"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"aa", ",", "bb", ",", "cc", ",", "dd", ",", "ee"}], "}"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"aa", ",", "bb", ",", "cc", ",", "dd", ",", "ee"}], "}"}], ",",
       "1"}], "}"}]}], "]"}], "/.", 
  RowBox[{"spvi", "[", 
   RowBox[{"[", "7", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7130240605394382`*^9, 
  3.713024155506549*^9}},ExpressionUUID->"3492c567-0ed8-44f2-922c-\
9b87a1ad23a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.18", "Subsubsection",
 CellChangeTimes->{{3.713024294173381*^9, 3.71302430028765*^9}, {
  3.730636310426951*^9, 
  3.730636314213168*^9}},ExpressionUUID->"d2594a38-85f6-4298-a1d0-\
9ce54dbf7de3"],

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2", ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.713024303992567*^9, 
  3.7130243781479454`*^9}},ExpressionUUID->"06c26587-01e4-4754-9d58-\
98bf6d3d26fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.19", "Subsubsection",
 CellChangeTimes->{{3.730636303588097*^9, 
  3.730636321251573*^9}},ExpressionUUID->"d7758bb7-3350-4ba9-8a1c-\
cf815ab602b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"a", ",", "b", ",", "A", ",", "B"}], "]"}], ";", 
  RowBox[{"Tr", "@", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"x", " ", "y"}]], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "x"}], "+", 
           RowBox[{"b", " ", "y"}], "+", "c"}], ")"}]}], ",", 
        RowBox[{"y", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "x"}], "+", 
           RowBox[{"B", " ", "y"}], "+", "C"}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "1"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7306363814490194`*^9, 
  3.7306364846619315`*^9}},ExpressionUUID->"43ccedff-0e5d-4f1d-8e24-\
6835bdb0a134"],

Cell[BoxData[
 RowBox[{"sat", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", "x"}], "+", 
            RowBox[{"b", " ", "y"}], "+", "c"}], ")"}]}], "\[Equal]", "0"}], 
        ",", 
        RowBox[{
         RowBox[{"y", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"A", " ", "x"}], "+", 
            RowBox[{"B", " ", "y"}], "+", "C"}], ")"}]}], "\[Equal]", "0"}]}],
        "}"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "0"}], ",", 
        RowBox[{"B", "\[Rule]", "0"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.7306365867377768`*^9, 3.7306366356602917`*^9}, {
  3.730636717301076*^9, 
  3.7306367256604695`*^9}},ExpressionUUID->"4a4def27-6e55-47aa-8ea0-\
0c60f4a330fd"],

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "y"}], "+", "c"}], ")"}]}], ",", 
       RowBox[{"y", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"A", " ", "x"}], "+", "C"}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "1"}], "}"}]}], "]"}], "/.", 
   RowBox[{"sat", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7306365474815273`*^9, 3.730636573834038*^9}, {
  3.7306366463009405`*^9, 3.730636661222842*^9}, {3.7306367359261136`*^9, 
  3.7306367631761665`*^9}},ExpressionUUID->"7c61f872-396d-4904-9e54-\
0aaf8f0376a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.20", "Subsubsection",
 CellChangeTimes->{{3.730636303588097*^9, 3.730636321251573*^9}, {
  3.730636800223115*^9, 
  3.730636801394992*^9}},ExpressionUUID->"9516d3b4-1a9f-4063-895d-\
a4e88afd8168"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ris", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "b"}], " ", "x", " ", "y"}], "+", 
      RowBox[{"d", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Beta]"}], " ", "x", " ", "y"}], "+", 
      RowBox[{"\[Delta]", " ", "y"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sa", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"ris", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7306411219344363`*^9, 3.730641172700163*^9}, {
  3.7306412036220984`*^9, 
  3.7306412069502287`*^9}},ExpressionUUID->"967d2e96-ff0f-4a16-a3ce-\
aaa3ca29cdba"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"ris", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "1"}], "}"}]}], "]"}], "/.", 
   RowBox[{"sa", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.7306411834970584`*^9, 
  3.7306412233408866`*^9}},ExpressionUUID->"b58ec13b-bada-4c1c-b470-\
fe9380d5f958"],

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"ris", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "1"}], "}"}]}], "]"}], "/.", 
   RowBox[{"sa", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730641264622216*^9, 
  3.7306412691691008`*^9}},ExpressionUUID->"00a59bf4-58c5-4b13-a71a-\
e2d50857df98"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.21", "Subsubsection",
 CellChangeTimes->{{3.730636303588097*^9, 3.730636321251573*^9}, {
  3.730636800223115*^9, 3.730636801394992*^9}, {3.730641308731679*^9, 
  3.730641309403554*^9}},ExpressionUUID->"f0ed0d82-fc11-4dfb-8c12-\
c8607cf4bab8"],

Cell[BoxData[
 RowBox[{"rha", "=", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"0", "\[DoubleLeftRightArrow]", "X"}], "\[Rule]", "Y"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "X"}], "+", "Y"}], "\[Rule]", 
       RowBox[{"3", "X"}]}], ",", 
      RowBox[{
       RowBox[{"X", "+", 
        RowBox[{"2", "Y"}]}], "\[Rule]", "Y"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "1", ",", "b", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7306413183723235`*^9, 
  3.730641388841211*^9}},ExpressionUUID->"6be7e695-a4fa-4ecd-9e29-\
c2df2d42a26b"],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"rha", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730641399622482*^9, 
  3.730641413778758*^9}},ExpressionUUID->"24e20d3d-aaba-405e-80f9-\
e4b6703598ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.22", "Subsubsection",
 CellChangeTimes->{{3.730636303588097*^9, 3.730636321251573*^9}, {
  3.730636800223115*^9, 3.730636801394992*^9}, {3.730641308731679*^9, 
  3.730641309403554*^9}, {3.730641443497565*^9, 
  3.730641444075693*^9}},ExpressionUUID->"aabd903e-d9fe-403c-bab5-\
9aa56799e1b8"],

Cell[BoxData[
 RowBox[{"rbr", "=", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"0", "\[DoubleLeftRightArrow]", "X"}], "\[Rule]", "Y"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "X"}], "+", "Y"}], "\[Rule]", 
       RowBox[{"3", "X"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "b", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730641460060099*^9, 
  3.7306414927320385`*^9}},ExpressionUUID->"ab937018-fbad-4de2-9b96-\
40020f104081"],

Cell[BoxData[
 RowBox[{"sbr", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"rbr", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7306415220445957`*^9, 
  3.730641527341481*^9}},ExpressionUUID->"58a28110-35c1-4e3f-8cb9-\
d35357a6c599"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"EigensystemJacobian", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"0", "\[DoubleLeftRightArrow]", "X"}], "\[Rule]", "Y"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"2", "X"}], "+", "Y"}], "\[Rule]", 
        RowBox[{"3", "X"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", 
  RowBox[{"sbr", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7306415367008743`*^9, 3.730641638029198*^9}, {
  3.730896235004108*^9, 
  3.730896239794382*^9}},ExpressionUUID->"07131897-4b75-46cd-bd3f-\
9be57e15f108"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.23", "Subsubsection",
 CellChangeTimes->{{3.730636303588097*^9, 3.730636321251573*^9}, {
  3.730636800223115*^9, 3.730636801394992*^9}, {3.730641308731679*^9, 
  3.730641309403554*^9}, {3.730641443497565*^9, 3.730641444075693*^9}, {
  3.7306417028730736`*^9, 
  3.7306417034668283`*^9}},ExpressionUUID->"e545c45c-147e-4731-a0e0-\
f9d8d7ca2282"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EigensystemJacobian", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"0", "\[DoubleLeftRightArrow]", "X"}], "\[Rule]", "Y"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "X"}], "+", "Y"}], "\[Rule]", 
         RowBox[{"3", "X"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "b", ",", "a"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "/.", 
   RowBox[{"sbr", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
  RowBox[{"b", "\[Rule]", 
   RowBox[{"a", "+", "1"}]}]}]], "Input",
 CellChangeTimes->{{3.730641737654393*^9, 3.730641759513811*^9}, {
  3.73089624270955*^9, 
  3.730896246879788*^9}},ExpressionUUID->"26964ac8-3179-4863-9a32-\
7784bf0b6989"],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"EigensystemJacobian", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"0", "\[DoubleLeftRightArrow]", "X"}], "\[Rule]", "Y"}], 
          ",", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "X"}], "+", "Y"}], "\[Rule]", 
           RowBox[{"3", "X"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "b", ",", "a"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "/.", 
     RowBox[{"sbr", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", "b"}], "]"}], "/.", 
  RowBox[{"b", "\[Rule]", 
   RowBox[{"a", "+", "1"}]}]}]], "Input",
 CellChangeTimes->{{3.730641804701398*^9, 3.7306418634515133`*^9}, {
  3.730896249419933*^9, 
  3.7308962550202556`*^9}},ExpressionUUID->"e1755d04-66f7-488e-9b45-\
7b1c59a120d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.24", "Subsubsection",
 CellChangeTimes->{{3.730636303588097*^9, 3.730636321251573*^9}, {
  3.730636800223115*^9, 3.730636801394992*^9}, {3.730641308731679*^9, 
  3.730641309403554*^9}, {3.730641443497565*^9, 3.730641444075693*^9}, {
  3.7306417028730736`*^9, 3.7306417034668283`*^9}, {3.7306421346239185`*^9, 
  3.7306421352176685`*^9}},ExpressionUUID->"360e9304-6d3e-4228-b799-\
c9686979a7fb"],

Cell[BoxData[
 RowBox[{"rsd", "=", 
  RowBox[{
   RowBox[{"RightHandSide", "[", 
    RowBox[{
     RowBox[{"ToReversible", "[", 
      RowBox[{"GetReaction", "[", "\"\<Triangle\>\"", "]"}], "]"}], ",", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        SubscriptBox["k", "#"], "&"}], ",", "6"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "/.", 
   RowBox[{"z", "\[Rule]", 
    RowBox[{"x0", "+", "y0", "+", "z0", "-", "x", "-", "y"}]}]}]}]], "Input",
 CellChangeTimes->{{3.730641911857858*^9, 3.7306419533266883`*^9}, {
  3.730641992670517*^9, 3.7306420410143604`*^9}, {3.7306420962332177`*^9, 
  3.730642107248867*^9}},ExpressionUUID->"0ac8c2d4-21a3-42b4-9f57-\
46d2fc7b3785"],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{
   RowBox[{"rsd", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730642046561247*^9, 
  3.730642077139431*^9}},ExpressionUUID->"d5fdb842-8a46-4404-902a-\
70bc90b7b623"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.25", "Subsubsection",
 CellChangeTimes->{
  3.7130255030078382`*^9, {3.7306426132029786`*^9, 
   3.730642620038657*^9}},ExpressionUUID->"18159500-ec3f-4f5a-9dd7-\
7288e5c2c147"],

Cell[BoxData[
 RowBox[{"trirev", "=", 
  RowBox[{"ToReversible", "[", 
   RowBox[{"GetReaction", "[", "\"\<Triangle\>\"", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7130255202256985`*^9, 3.71302555267981*^9}, 
   3.728798202855794*^9, 
   3.7306096821315203`*^9},ExpressionUUID->"41c0b401-ed27-4e8a-bd02-\
b4d7a2b93354"],

Cell["Case 1", "Text",
 CellChangeTimes->{{3.730642836340043*^9, 
  3.73064283765612*^9}},ExpressionUUID->"d29dc327-a9d7-4e57-a64e-\
a606bf453a1e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EigensystemJacobian", "[", 
   RowBox[{
    RowBox[{"{", "trirev", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}]}],
    "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7130260017114534`*^9, 3.713026063929929*^9}, {
   3.7306421965302896`*^9, 3.730642204389681*^9}, {3.730642254561653*^9, 
   3.73064227834295*^9}, 3.730642310389886*^9, 3.7306426492673316`*^9, {
   3.7308953894668665`*^9, 
   3.730895397560629*^9}},ExpressionUUID->"aefa48e1-9691-4519-95e7-\
1d2ad6d88269"],

Cell[BoxData[
 RowBox[{"conI", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ReplaceAll", "@@", 
      RowBox[{"Concentrations", "[", 
       RowBox[{
        RowBox[{"{", "trirev", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", "t"}], "]"}]}], "//", 
     "Simplify"}], ")"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.713025608446288*^9, 3.713025689079177*^9}, {
  3.7130257193991427`*^9, 3.7130257521321263`*^9}, {3.713025861804527*^9, 
  3.7130258831640973`*^9}, {3.7306426965340405`*^9, 
  3.730642733620163*^9}},ExpressionUUID->"b684eb14-b4fe-401e-97ed-\
51263c216f81"],

Cell["\<\
The derivative of the function has an infinite number of zeros, as it is\
\>", "Text",
 CellChangeTimes->{{3.7309555805418015`*^9, 3.7309556011043415`*^9}, 
   3.730959154426973*^9},ExpressionUUID->"64f62fb8-f0ff-40a8-92ed-\
c18fa5adc7ae"],

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"conI", ",", "t"}], "]"}], "//", "Simplify"}], "]"}]], "Input",
 CellChangeTimes->{{3.7309549066654835`*^9, 3.730954921446762*^9}, {
  3.7309550878064632`*^9, 
  3.7309550962283545`*^9}},ExpressionUUID->"c087f864-06d1-4310-9ce0-\
5442c91dc772"],

Cell["The zeros are as follows", "Text",
 CellChangeTimes->{{3.7309556656665115`*^9, 
  3.7309556735259013`*^9}},ExpressionUUID->"bd3e9e72-1ea4-4e69-aeca-\
6f85be4e3871"],

Cell[BoxData[
 RowBox[{"rc", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", "t"}], "/", "2"}]], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          FractionBox["\[Pi]", "6"], "-", 
          FractionBox[
           RowBox[{
            SqrtBox["3"], " ", "t"}], "2"]}], "]"}]}], 
       SqrtBox["3"]]}], "\[Equal]", "0"}], ",", "t"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7309557055415883`*^9, 
  3.7309557417135353`*^9}},ExpressionUUID->"ee1f384b-1fea-4d43-a1fc-\
d6ee59d9cc7c"],

Cell[BoxData[
 RowBox[{"nulls", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"List", "@@", 
     RowBox[{"rc", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "/.", 
   RowBox[{"Equal", "\[Rule]", "Rule"}]}]}]], "Input",
 CellChangeTimes->{{3.7309557479010468`*^9, 
  3.7309557942136364`*^9}},ExpressionUUID->"da14a4b2-b2a1-439c-b296-\
82908eb6d53b"],

Cell[BoxData[
 RowBox[{"nulls", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "2"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7309567136722007`*^9, 
  3.7309567410628786`*^9}},ExpressionUUID->"b7d94d4f-6456-4952-8896-\
235c2be1045d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nulls", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
    "}"}]}]}]], "Input",
 CellChangeTimes->{{3.73095678445359*^9, 
  3.730956804203627*^9}},ExpressionUUID->"5bb785f2-73e5-461e-ba3b-\
cef80b1f9044"],

Cell[BoxData[
 RowBox[{
  RowBox[{"num", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"nulls", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "/.", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
        "}"}]}]}], ",", "30"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.73095678445359*^9, 3.730956804203627*^9}, {
   3.730957089297935*^9, 3.730957093719819*^9}, {3.73095716428246*^9, 
   3.7309571651262083`*^9}, {3.73095926766157*^9, 3.7309592975522532`*^9}, 
   3.730959336489829*^9},ExpressionUUID->"9d0ce8ed-807e-4faa-80db-\
d2900d298d31"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Riffle", "@@", "num"}], ";"}]], "Input",
 CellChangeTimes->{{3.730957168126216*^9, 3.730957197954397*^9}, 
   3.730959341942965*^9},ExpressionUUID->"7f941aee-1bdb-447a-a7fe-\
3ea16fb134c1"],

Cell["\<\
At the times where the first derivetives are zero the second derivatives are \
positive and negative, alternatingly, implying that minima and maxima are \
changing each other.\
\>", "Text",
 CellChangeTimes->{{3.730956040339117*^9, 3.730956062495412*^9}, 
   3.7309561248236585`*^9, {3.730957264251402*^9, 3.730957293517084*^9}, {
   3.73095734223593*^9, 3.7309573565328336`*^9}, {3.730959309849152*^9, 
   3.7309593238023043`*^9}},ExpressionUUID->"d8e468e2-ae0e-4274-bf51-\
6c6e6e3b7443"],

Cell[BoxData[
 RowBox[{"firstorder", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"conI", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1"}], "}"}]}], "]"}], "/.", 
   RowBox[{"t", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"Riffle", "@@", "num"}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.730959232489625*^9, 
  3.730959239911516*^9}},ExpressionUUID->"57653a9a-33ad-47f3-864b-\
b8b67d76091c"],

Cell[BoxData[
 RowBox[{"secondder", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"conI", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "2"}], "}"}]}], "]"}], "/.", 
   RowBox[{"t", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"Riffle", "@@", "num"}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7309558929794555`*^9, 3.730955971901484*^9}, {
   3.730956005182799*^9, 3.7309560108078103`*^9}, {3.7309564813123703`*^9, 
   3.73095649898428*^9}, {3.730956938938266*^9, 3.7309569469070315`*^9}, {
   3.7309572463607416`*^9, 3.730957254517006*^9}, {3.7309574425955005`*^9, 
   3.73095745272052*^9}, 
   3.730957500251864*^9},ExpressionUUID->"278b0ec3-d3a9-4974-9234-\
2981bd07e2af"],

Cell["\<\
The reason why it is extremely hard to make a convincing figure lies in the \
fact that the function values are quite different:\
\>", "Text",
 CellChangeTimes->{{3.730957527283168*^9, 3.730957563830112*^9}, 
   3.7309591442707033`*^9},ExpressionUUID->"3186624d-118c-47ec-b25a-\
ab31d0398c4d"],

Cell[BoxData[
 RowBox[{"funvalues", "=", 
  RowBox[{"conI", "/.", 
   RowBox[{"t", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"Riffle", "@@", "num"}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7309558929794555`*^9, 3.730955971901484*^9}, {
  3.730956005182799*^9, 3.7309560108078103`*^9}, {3.7309564813123703`*^9, 
  3.73095649898428*^9}, {3.730956938938266*^9, 3.7309569469070315`*^9}, {
  3.7309572463607416`*^9, 3.730957254517006*^9}, {3.7309574425955005`*^9, 
  3.7309574912049713`*^9}},ExpressionUUID->"11128fa8-7831-4c1b-af01-\
82668ae75fc6"],

Cell["Case 2", "Text",
 CellChangeTimes->{{3.730642861645492*^9, 
  3.7306428644936566`*^9}},ExpressionUUID->"3b8f8923-e4db-4aa6-89fc-\
5b71d8a0f86c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EigensystemJacobian", "[", 
   RowBox[{
    RowBox[{"{", "trirev", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
    "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7130260017114534`*^9, 3.713026063929929*^9}, {
   3.7306421965302896`*^9, 3.730642204389681*^9}, {3.730642254561653*^9, 
   3.73064227834295*^9}, 3.730642310389886*^9, 3.7306426492673316`*^9, {
   3.7306428855348606`*^9, 3.7306428887460485`*^9}, {3.7308954881233053`*^9, 
   3.7308954962170725`*^9}},ExpressionUUID->"b5571093-2b88-4cd9-94b2-\
9d9e0f18bb4e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReactionsData", "[", 
   RowBox[{"{", "trirev", "}"}], "]"}], "[", "\"\<deficiency\>\"", 
  "]"}]], "Input",
 CellChangeTimes->{{3.730642903016863*^9, 
  3.7306429243241615`*^9}},ExpressionUUID->"793d79aa-e5c0-4474-b53e-\
3545ccbf8905"],

Cell[BoxData[
 RowBox[{"DetailedBalanced", "[", 
  RowBox[{
   RowBox[{"{", "trirev", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.730642933292932*^9, 
  3.7306429557460995`*^9}},ExpressionUUID->"a90e615d-d18c-4486-a034-\
85453b169cae"],

Cell["Case 3", "Text",
 CellChangeTimes->{{3.7306429890430403`*^9, 
  3.7306429949493012`*^9}},ExpressionUUID->"51925615-804e-43aa-a076-\
e7a9a0331af9"],

Cell[BoxData[
 RowBox[{"DetailedBalanced", "[", 
  RowBox[{
   RowBox[{"{", "trirev", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7306430083555765`*^9, 
  3.7306430087930784`*^9}},ExpressionUUID->"e425692d-ad71-40b6-afb7-\
4284d9d2e1e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EigensystemJacobian", "[", 
   RowBox[{
    RowBox[{"{", "trirev", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
    "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7306430289181185`*^9, 3.7306430294024925`*^9}, {
  3.7308962607565813`*^9, 
  3.7308962729532814`*^9}},ExpressionUUID->"4a366955-5ec2-452b-bc27-\
f3869ca73cdc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.26", "Subsubsection",
 CellChangeTimes->{
  3.7130255030078382`*^9, {3.7306426132029786`*^9, 3.730642620038657*^9}, {
   3.730643336536067*^9, 
   3.7306433370829425`*^9}},ExpressionUUID->"9c1e2837-996f-42aa-ac74-\
311138b8d53c"],

Cell[BoxData[
 RowBox[{"SymmetricMatrixQ", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"RightHandSide", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", "X"}], "->", 
         RowBox[{
          RowBox[{"3", "X"}], "+", 
          RowBox[{"3", "Y"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", "Y"}], "->", 
         RowBox[{
          RowBox[{"3", "X"}], "+", 
          RowBox[{"3", "Y"}]}]}], ",", 
        RowBox[{
         RowBox[{"X", "+", "Y"}], "->", 
         RowBox[{
          RowBox[{"3", "X"}], "+", 
          RowBox[{"3", "Y"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k2", ",", "k2", ",", 
        RowBox[{"3", " ", "k2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7130265156019664`*^9, 3.713026537711113*^9}, {
  3.71302659139874*^9, 
  3.713026638133954*^9}},ExpressionUUID->"09907237-5951-492c-9456-\
09b2f8bf0ab6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.27", "Subsubsection",
 CellChangeTimes->{
  3.7130255030078382`*^9, {3.7306426132029786`*^9, 3.730642620038657*^9}, {
   3.7306433487704663`*^9, 
   3.730643349348591*^9}},ExpressionUUID->"500f7fd9-dfc1-40bd-b930-\
a5ca26dd41a4"],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{
   RowBox[{"RightHandSide", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "X"}], "->", 
        RowBox[{
         RowBox[{"X", "+", "Y"}], "->", 
         RowBox[{
          RowBox[{"2", "X"}], "+", "Y"}]}]}], ",", 
       RowBox[{
        RowBox[{"X", "+", "Y"}], "->", 
        RowBox[{
         RowBox[{"2", "Y"}], "->", 
         RowBox[{
          RowBox[{"2", "X"}], "+", "Y"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "2", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7130266631497498`*^9, 
  3.7130267187891245`*^9}},ExpressionUUID->"05254a93-471d-478d-ad45-\
55623fd9474b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.28", "Subsubsection",
 CellChangeTimes->{
  3.7130255030078382`*^9, {3.7306426132029786`*^9, 3.730642620038657*^9}, {
   3.730643367114251*^9, 
   3.730643367786128*^9}},ExpressionUUID->"d95c5a33-db39-4a95-a90b-\
50e493bd0d93"],

Cell[BoxData[
 RowBox[{"rhs", "=", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "X"}], "->", 
       RowBox[{
        RowBox[{"X", "+", "Y"}], "->", "0"}]}], ",", 
      RowBox[{
       RowBox[{"2", "Y"}], "->", 
       RowBox[{"X", "+", "Y"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"2", "k"}], ",", "k"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.713026756179907*^9, 
  3.713026784438059*^9}},ExpressionUUID->"f529718d-7c36-4ec5-b42b-\
87e636194569"],

Cell[BoxData[{
 RowBox[{"Div", "[", 
  RowBox[{
   RowBox[{"Reverse", "[", "rhs", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\n", 
 RowBox[{"Div", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "rhs"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\n"}], "Input",
 CellChangeTimes->{{3.7130268025709386`*^9, 
  3.7130268298521132`*^9}},ExpressionUUID->"c7af2dbc-2553-4124-9cbb-\
5f86369bb0b7"],

Cell[BoxData[
 RowBox[{"DSolveValue", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"z", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"k", 
       RowBox[{"(", 
        RowBox[{"I", "-", "1"}], ")"}], 
       SuperscriptBox[
        RowBox[{"z", "[", "t", "]"}], "2"]}]}], ",", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"z", "[", "0", "]"}], "]"}], "\[Equal]", "x0"}], ",", 
     RowBox[{
      RowBox[{"Im", "[", 
       RowBox[{"z", "[", "0", "]"}], "]"}], "\[Equal]", "y0"}]}], "}"}], ",", 
   RowBox[{"z", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.730643391254924*^9, 3.730643451645666*^9}, {
  3.7306434910832434`*^9, 
  3.7306435540521173`*^9}},ExpressionUUID->"155d8a5c-1c7b-4401-9f08-\
81ea19f01f86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Evaluate", "[", 
   RowBox[{
    RowBox[{"ComplexExpand", "[", 
     RowBox[{"Re", "[", 
      RowBox[{
       RowBox[{"DSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"z", "'"}], "[", "t", "]"}], "\[Equal]", 
            RowBox[{"k", 
             RowBox[{"(", 
              RowBox[{"I", "-", "1"}], ")"}], 
             SuperscriptBox[
              RowBox[{"z", "[", "t", "]"}], "2"]}]}], ",", 
           RowBox[{
            RowBox[{"Re", "[", 
             RowBox[{"z", "[", "0", "]"}], "]"}], "\[Equal]", "\[Pi]"}], ",", 
           RowBox[{
            RowBox[{"Im", "[", 
             RowBox[{"z", "[", "0", "]"}], "]"}], "\[Equal]", "E"}]}], "}"}], 
         ",", 
         RowBox[{"z", "[", "t", "]"}], ",", "t"}], "]"}], "/.", 
       RowBox[{
        RowBox[{"z", "[", "t", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "+", 
         RowBox[{"I", " ", 
          RowBox[{"y", "[", "t", "]"}]}]}]}]}], "]"}], "]"}], "//", 
    "Together"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Pi", "\[Rule]", 
     SubscriptBox["x", "0"]}], ",", 
    RowBox[{"E", "\[Rule]", 
     SubscriptBox["y", "0"]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7306437189586906`*^9, 3.730643820912013*^9}, 
   3.7306438581152124`*^9, {3.730643937771617*^9, 3.730643945474758*^9}, {
   3.7306439817717047`*^9, 
   3.7306439867717133`*^9}},ExpressionUUID->"438870e0-c7c9-44b8-a1ea-\
26547a54a4fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Evaluate", "[", 
   RowBox[{
    RowBox[{"ComplexExpand", "[", 
     RowBox[{"Im", "[", 
      RowBox[{
       RowBox[{"DSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"z", "'"}], "[", "t", "]"}], "\[Equal]", 
            RowBox[{"k", 
             RowBox[{"(", 
              RowBox[{"I", "-", "1"}], ")"}], 
             SuperscriptBox[
              RowBox[{"z", "[", "t", "]"}], "2"]}]}], ",", 
           RowBox[{
            RowBox[{"Re", "[", 
             RowBox[{"z", "[", "0", "]"}], "]"}], "\[Equal]", "\[Pi]"}], ",", 
           RowBox[{
            RowBox[{"Im", "[", 
             RowBox[{"z", "[", "0", "]"}], "]"}], "\[Equal]", "E"}]}], "}"}], 
         ",", 
         RowBox[{"z", "[", "t", "]"}], ",", "t"}], "]"}], "/.", 
       RowBox[{
        RowBox[{"z", "[", "t", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "+", 
         RowBox[{"I", " ", 
          RowBox[{"y", "[", "t", "]"}]}]}]}]}], "]"}], "]"}], "//", 
    "Together"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Pi", "\[Rule]", 
     SubscriptBox["x", "0"]}], ",", 
    RowBox[{"E", "\[Rule]", 
     SubscriptBox["y", "0"]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7306437189586906`*^9, 3.7306438555527067`*^9}, {
  3.730643916880951*^9, 3.730643927443473*^9}, {3.7306439923810997`*^9, 
  3.730643998459235*^9}},ExpressionUUID->"8ad1e2cd-da7b-44bd-983b-\
ecf89e995ff3"],

Cell[BoxData[
 RowBox[{"dv", "=", 
  RowBox[{
   RowBox[{"DSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"z", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"k", 
         RowBox[{"(", 
          RowBox[{"I", "-", "1"}], ")"}], 
         SuperscriptBox[
          RowBox[{"z", "[", "t", "]"}], "2"]}]}], ",", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{"z", "[", "0", "]"}], "]"}], "\[Equal]", "\[Pi]"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", 
         RowBox[{"z", "[", "0", "]"}], "]"}], "\[Equal]", "E"}]}], "}"}], ",", 
     RowBox[{"z", "[", "t", "]"}], ",", "t"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"E", "\[Rule]", 
      SubscriptBox["x", "0"]}], ",", 
     RowBox[{"Pi", "\[Rule]", 
      SubscriptBox["y", "0"]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.730643391254924*^9, 3.730643451645666*^9}, {
  3.7306434910832434`*^9, 
  3.7306436348178997`*^9}},ExpressionUUID->"16484f6b-8580-4bc3-8f85-\
9409c2b9c6c1"],

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "0"], ",", 
      SubscriptBox["y", "0"]}], "}"}], "\[Element]", "Reals"}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Re", "[", "dv", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7306436370210323`*^9, 3.730643642677292*^9}, {
  3.7306440207249045`*^9, 
  3.7306440809281473`*^9}},ExpressionUUID->"da9c1c27-a46a-4a60-90ef-\
196e27541910"],

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "0"], ",", 
      SubscriptBox["y", "0"]}], "}"}], "\[Element]", "Reals"}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Im", "[", "dv", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7306436370210323`*^9, 3.730643642677292*^9}, {
  3.7306440207249045`*^9, 
  3.7306441077407007`*^9}},ExpressionUUID->"6293c9c8-ebcb-4232-a8b5-\
053c19fd1fa2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.30", "Subsubsection",
 CellChangeTimes->{
  3.7130255030078382`*^9, {3.7306426132029786`*^9, 3.730642620038657*^9}, {
   3.730643367114251*^9, 3.730643367786128*^9}, {3.7306456135561438`*^9, 
   3.7306456137905197`*^9}},ExpressionUUID->"6baba51f-a36f-4198-94c1-\
63a3ef18d7eb"],

Cell[BoxData[
 RowBox[{"dec", "=", 
  RowBox[{
   RowBox[{"ReplaceAll", "@@", 
    RowBox[{"Concentrations", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"B", "\[Rule]", 
        RowBox[{"P", "\[Rule]", "L"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"Log", "[", "2", "]"}], "/", 
       RowBox[{"{", 
        RowBox[{"5", ",", "138"}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "//", 
   "Expand"}]}]], "Input",
 CellChangeTimes->{{3.730645664368743*^9, 3.73064573682201*^9}, {
  3.7306458055096455`*^9, 3.7306458097752786`*^9}, {3.7306458454472237`*^9, 
  3.7306458980723257`*^9}},ExpressionUUID->"9da82745-5172-4901-8fed-\
716ffcee3ec3"],

Cell[BoxData[
 RowBox[{"mx", "=", 
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"dec", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "t"}], "]"}], "\[Equal]", "0"}], 
    ",", "t", ",", "Reals"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730645936306776*^9, 3.730645988994379*^9}, {
  3.730646021244444*^9, 
  3.7306460245725737`*^9}},ExpressionUUID->"dcc3a3b4-de72-4786-924a-\
54dcb8362b3b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"dec", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "2"}], "}"}]}], "]"}], "/.", 
  RowBox[{"mx", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730646008431916*^9, 
  3.7306460303225856`*^9}},ExpressionUUID->"20f9573b-af3d-4036-aae1-\
131c8acc0b39"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"dec", "[", 
    RowBox[{"[", "3", "]"}], "]"}], ",", 
   RowBox[{"t", "\[Rule]", 
    RowBox[{"+", "\[Infinity]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730646046541366*^9, 
  3.7306460720570407`*^9}},ExpressionUUID->"ec2cca44-d413-48ef-b435-\
491b492281b1"],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"dec", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "==", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"t", ">", "0"}]}], "}"}], ",", "t", ",", "Reals"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.730646106588358*^9, 
  3.730646200947918*^9}},ExpressionUUID->"85e73e65-3ff3-4fb4-8ab2-\
f1e197a04a1c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 8.45", "Subsubsection",
 CellChangeTimes->{
  3.7130255030078382`*^9, {3.7306426132029786`*^9, 3.730642620038657*^9}, {
   3.730643367114251*^9, 3.730643367786128*^9}, {3.7306456135561438`*^9, 
   3.7306456137905197`*^9}, {3.7306464077920723`*^9, 
   3.7306464079951973`*^9}},ExpressionUUID->"1ffc5f6f-39dd-43c0-888d-\
4ca9e4713d75"],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], "]"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "1"}], "}"}]}], "]"}], ".", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"A", "+", "B"}], "->", 
       RowBox[{"2", "B"}]}], ",", 
      RowBox[{
       RowBox[{"B", "+", "C"}], "->", 
       RowBox[{"2", "C"}]}], ",", 
      RowBox[{
       RowBox[{"C", "+", "A"}], "->", 
       RowBox[{"2", "A"}]}], ",", 
      RowBox[{
       RowBox[{"A", "+", "D"}], "->", 
       RowBox[{"2", "D"}]}], ",", 
      RowBox[{
       RowBox[{"D", "+", "E"}], "->", 
       RowBox[{"2", "E"}]}], ",", 
      RowBox[{
       RowBox[{"E", "+", "A"}], "->", 
       RowBox[{"2", "A"}]}]}], "}"}], ",", 
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "#"], "&"}], ",", "6"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7306464226202264`*^9, 3.730646492807865*^9}, {
  3.7306465403704567`*^9, 
  3.730646632964388*^9}},ExpressionUUID->"d035de8e-3c60-40e6-8526-\
328e3051ef1c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Times", "@@", 
      SuperscriptBox[
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["k", "2"], 
          SubscriptBox["k", "5"]}], ",", 
         RowBox[{
          SubscriptBox["k", "3"], 
          SubscriptBox["k", "5"]}], ",", 
         RowBox[{
          SubscriptBox["k", "1"], 
          SubscriptBox["k", "5"]}], ",", 
         RowBox[{
          SubscriptBox["k", "2"], 
          SubscriptBox["k", "6"]}], ",", 
         RowBox[{
          SubscriptBox["k", "2"], 
          SubscriptBox["k", "4"]}]}], "}"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
       "1"}], "}"}]}], "]"}], ".", 
   RowBox[{"RightHandSide", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"A", "+", "B"}], "->", 
        RowBox[{"2", "B"}]}], ",", 
       RowBox[{
        RowBox[{"B", "+", "C"}], "->", 
        RowBox[{"2", "C"}]}], ",", 
       RowBox[{
        RowBox[{"C", "+", "A"}], "->", 
        RowBox[{"2", "A"}]}], ",", 
       RowBox[{
        RowBox[{"A", "+", "D"}], "->", 
        RowBox[{"2", "D"}]}], ",", 
       RowBox[{
        RowBox[{"D", "+", "E"}], "->", 
        RowBox[{"2", "E"}]}], ",", 
       RowBox[{
        RowBox[{"E", "+", "A"}], "->", 
        RowBox[{"2", "A"}]}]}], "}"}], ",", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        SubscriptBox["k", "#"], "&"}], ",", "6"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], "]"}]}],
   "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.7306464226202264`*^9, 3.730646492807865*^9}, {
  3.7306465403704567`*^9, 3.730646755433632*^9}, {3.7306474940913267`*^9, 
  3.7306474998100877`*^9}},ExpressionUUID->"bc77ba29-ff81-4094-850f-\
5331b8bfdadc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Approximations", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
  3.710510272827979*^9, 3.710510273999857*^9}, {3.712919706370204*^9, 
  3.7129197108763714`*^9}},ExpressionUUID->"b2de62bd-f1f3-41e8-a2a6-\
c8a74073159d"],

Cell[CellGroupData[{

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"475b4372-9fe5-4a59-a7a4-\
834e7ac4abde"],

Cell[CellGroupData[{

Cell["Fig. 14.15", "Subsubsection",
 CellChangeTimes->{{3.7285849176401587`*^9, 3.7285849189839125`*^9}, 
   3.7286449323784885`*^9},ExpressionUUID->"601977b5-b719-4245-b82e-\
6445449318a7"],

Cell[BoxData[
 RowBox[{"feinberghorn", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<F\>\"", " ", "\[LeftRightArrow]", 
       RowBox[{"\"\<D\>\"", "+", "\"\<E\>\""}], "\[LeftArrow]", " ", 
       "\"\<C\>\"", " ", "\[LeftRightArrow]", " ", 
       RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}]}], "\[Rule]", 
      RowBox[{"\"\<G\>\"", "\[Rule]", 
       RowBox[{
        RowBox[{"\"\<H\>\"", " ", "\[LeftRightArrow]", " ", 
         RowBox[{"2", "\"\<J\>\""}]}], "\[Rule]", "\"\<G\>\""}]}]}], "}"}], 
    ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.540461749014663*^9, {3.710564101278573*^9, 
   3.7105641147393465`*^9}},ExpressionUUID->"2f66316f-85b1-41aa-a628-\
445cc0c98c89"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.15\>\"", ",", "feinberghorn"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7105641275550785`*^9, 3.7105641382586904`*^9}, {
  3.7285849310133634`*^9, 
  3.7285849384647884`*^9}},ExpressionUUID->"a6f9cf75-26bc-4671-baa4-\
9e960d17f7d0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"c63ac811-e54d-4926-8afc-\
9a9adbec32e3"],

Cell[CellGroupData[{

Cell["Solution 9.1", "Subsubsection",
 CellChangeTimes->{{3.7129197234899945`*^9, 3.71291972452131*^9}, {
  3.730569540173594*^9, 
  3.730569545720479*^9}},ExpressionUUID->"81832819-25e7-4045-a74f-\
c97216e1506f"],

Cell[BoxData[
 RowBox[{"VolpertIndexing", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[DoubleLeftRightArrow]", 
     "\"\<C\>\""}], "}"}], ",", " ", 
   RowBox[{"{", "\"\<C\>\"", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712919726470426*^9, 
  3.7129197698352633`*^9}},ExpressionUUID->"efa5230b-7016-40f0-930b-\
fbe91da11d75"],

Cell[BoxData[
 RowBox[{"VolpertIndexing", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}], "\[DoubleLeftRightArrow]", 
     "\"\<C\>\""}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", 
   RowBox[{"Verbose", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712919726470426*^9, 
  3.7129198083927956`*^9}},ExpressionUUID->"339aa605-2fd3-42ec-8b7d-\
0fa712581cac"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 9.4", "Subsubsection",
 CellChangeTimes->{{3.7129197234899945`*^9, 3.71291972452131*^9}, {
  3.730569540173594*^9, 3.730569545720479*^9}, {3.7305696265175133`*^9, 
  3.730569627220639*^9}},ExpressionUUID->"db1cee2c-2115-42f2-91bf-\
3e74aea3d3d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rhs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["k", "1"]}], "s", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["e", "0"], "-", "c"}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["k", 
        RowBox[{"-", "1"}]], "c"}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "1"], "s", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["e", "0"], "-", "c"}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["k", 
          RowBox[{"-", "1"}]], "+", 
         SubscriptBox["k", "2"]}], ")"}], "c"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.730569675751984*^9, 
  3.7305697797521877`*^9}},ExpressionUUID->"e816597e-455a-4633-aca1-\
d680d9c03303"],

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{"CharacteristicPolynomial", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"rhs", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"s", ",", "c"}], "}"}], ",", "1"}], "}"}]}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"s", "\[Rule]", "0"}], ",", 
        RowBox[{"c", "\[Rule]", "0"}]}], "}"}]}], ",", "\[Lambda]"}], "]"}], 
   ",", "\[Lambda]"}], "]"}]], "Input",
 CellChangeTimes->{{3.730569781986569*^9, 3.7305698247210283`*^9}, {
  3.7305699080493135`*^9, 
  3.730569966471304*^9}},ExpressionUUID->"cf2b1029-1be0-4ca5-95f6-\
da6517d7e3ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 9.6", "Subsubsection",
 CellChangeTimes->{{3.7129197234899945`*^9, 3.71291972452131*^9}, {
  3.730569540173594*^9, 3.730569545720479*^9}, {3.7305696265175133`*^9, 
  3.730569627220639*^9}, {3.730570017580777*^9, 
  3.730570018346404*^9}},ExpressionUUID->"bbf08fa9-6a11-4af6-ae11-\
dee0db3a9329"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DSolveValue", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"S", "'"}], "[", "t", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", "1"}], ")"}], 
        RowBox[{"S", "[", "t", "]"}]}], 
       RowBox[{"1", "-", "\[Alpha]", "+", 
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"S", "[", "t", "]"}]}]}]]}], ",", 
     RowBox[{"S", "[", "t", "]"}], ",", "t"}], "]"}], "//", "PowerExpand"}], "//",
   "Simplify"}]}], "Input",
 CellChangeTimes->{{3.7305700226276627`*^9, 3.730570129143496*^9}, {
  3.7305701709717035`*^9, 
  3.730570206393648*^9}},ExpressionUUID->"a6577bb5-b2a1-4dfe-832f-\
afd2d02e9076"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 9.7", "Subsubsection",
 CellChangeTimes->{{3.7129290585393343`*^9, 3.7129290647464604`*^9}, {
  3.730570291596939*^9, 
  3.7305702941438184`*^9}},ExpressionUUID->"f88cb85c-b88f-4b58-acdc-\
ed26d06076b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"stat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "==", 
      RowBox[{"2", "+", "x", "-", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]}], ",", 
     RowBox[{"0", "==", 
      RowBox[{"3", "+", 
       RowBox[{"x", " ", "y"}], "-", 
       SuperscriptBox["y", "3"], "+", 
       RowBox[{"x", " ", "z"}]}]}], ",", 
     RowBox[{"0", "==", 
      RowBox[{"2", "+", 
       SuperscriptBox["x", "3"], "-", 
       RowBox[{"y", " ", "z"}], "-", 
       SuperscriptBox["z", "2"]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.712929076007942*^9, 3.7129291590531363`*^9}, {
  3.730570302893836*^9, 
  3.7305703268157587`*^9}},ExpressionUUID->"a4d5f81b-ac72-4093-980a-\
e4b898476055"],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"stat", ",", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ">", "0"}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellChangeTimes->{{3.7129291649590645`*^9, 3.7129291858099184`*^9}, {
  3.730570355237688*^9, 
  3.730570385628372*^9}},ExpressionUUID->"965024c8-f1aa-4b93-99e9-\
6b19bbd6e042"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"stat", ",", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ">", "0"}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellChangeTimes->{{3.7129291649590645`*^9, 3.712929201627432*^9}, 
   3.7305704733629208`*^9},ExpressionUUID->"eeb63d9b-2fbf-43f2-85cb-\
1c37f57ba560"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"stat", ",", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ">", "0"}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellChangeTimes->{{3.7129291649590645`*^9, 3.712929201627432*^9}, {
   3.7129292528624854`*^9, 3.712929259667029*^9}, 
   3.730570481784811*^9},ExpressionUUID->"c75b9bf5-8093-4520-8878-\
32df4d9471c4"],

Cell[BoxData[
 RowBox[{"gball", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"GroebnerBasis", "[", 
      RowBox[{
       RowBox[{"Last", "/@", "stat"}], ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{"Permutations", "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7129825942436457`*^9, 3.712982624864628*^9}, {
  3.73057041465968*^9, 
  3.7305704243315735`*^9}},ExpressionUUID->"d2b3b972-a2e4-4d17-8d96-\
793b5cfbce3b"],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exponent", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "&"}], ",", "gball",
    ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7129826379428988`*^9, 3.7129826752562866`*^9}, {
  3.712982714567553*^9, 
  3.712982726083041*^9}},ExpressionUUID->"dc2e711f-4207-4c2c-896f-\
5e30224fc7d0"],

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", "%"}]], "Input",
 CellChangeTimes->{{3.712982768895302*^9, 3.712982776079233*^9}, {
  3.7305706021444216`*^9, 
  3.730570611113186*^9}},ExpressionUUID->"39e47075-356b-466f-a91a-\
5c2b54ad7da4"],

Cell[BoxData[
 RowBox[{"gball", "[", 
  RowBox[{"[", "4", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.712982690715703*^9, 
  3.7129826951461926`*^9}},ExpressionUUID->"e51de066-8533-4f40-a491-\
a4b1a9595928"],

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"stat", ",", 
   RowBox[{"{", "z", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7129291649590645`*^9, 3.712929201627432*^9}, {
  3.7129292528624854`*^9, 3.7129293021662507`*^9}, {3.712929344936678*^9, 
  3.712929348760219*^9}, {3.7129294318714547`*^9, 
  3.7129294567189703`*^9}},ExpressionUUID->"49ae587d-5343-42c2-9c68-\
ae6c2a6189a6"],

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"stat", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7129291649590645`*^9, 3.712929201627432*^9}, {
  3.7129292528624854`*^9, 3.7129293021662507`*^9}, {3.712929344936678*^9, 
  3.712929348760219*^9}, {3.7129294318714547`*^9, 
  3.712929491254922*^9}},ExpressionUUID->"97138cc9-40c8-42be-b23d-\
edc9b7b5444d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Y", ",", "Z"}], "]"}], ";", 
  RowBox[{"Sort", "@", 
   RowBox[{"RightHandSide", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"3", "Y"}], "\[Rule]", 
        RowBox[{"0", "\[Rule]", 
         RowBox[{"X", "\[DoubleLeftRightArrow]", 
          RowBox[{"2", "X"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"2", "Y"}], "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "Y"}], "+", "X"}], "\[LeftArrow]", 
         RowBox[{"X", "+", "Y"}]}]}], ",", 
       RowBox[{"0", "\[Rule]", 
        RowBox[{"Y", "\[LeftArrow]", 
         RowBox[{"Y", "+", "Z"}]}]}], ",", 
       RowBox[{
        RowBox[{"X", "+", "Z"}], "\[Rule]", 
        RowBox[{"X", "+", "Y", "+", "Z"}]}], ",", 
       RowBox[{"0", "\[Rule]", "Z"}], ",", 
       RowBox[{
        RowBox[{"3", "X"}], "\[Rule]", 
        RowBox[{
         RowBox[{"3", "X"}], "+", "Z"}]}], ",", 
       RowBox[{
        RowBox[{"2", "Z"}], "\[Rule]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", "2", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "3", ",", "1", ",", "1", ",", "2", ",", "1", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "x", ",", "z"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7129353105906563`*^9, 3.712935551770327*^9}, {
  3.7307764206213713`*^9, 
  3.730776471762096*^9}},ExpressionUUID->"94b1aff9-bb2e-42db-a6cc-\
2c1cac68898c"],

Cell[BoxData[
 RowBox[{"Last", "/@", "stat"}]], "Input",
 CellChangeTimes->{{3.7305706687851768`*^9, 3.7305706782539444`*^9}, {
  3.7307764801371117`*^9, 
  3.730776489152754*^9}},ExpressionUUID->"ee9ea42b-1b64-4fe1-9ba3-\
370f50e3aff5"],

Cell[BoxData[
 RowBox[{"StationaryPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "Y"}], "->", 
      RowBox[{"0", "\[Rule]", 
       RowBox[{"X", "\[DoubleLeftRightArrow]", 
        RowBox[{"2", "X"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"2", "Y"}], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "Y"}], "+", "X"}], "\[LeftArrow]", 
       RowBox[{"X", "+", "Y"}]}]}], ",", 
     RowBox[{"0", "\[Rule]", 
      RowBox[{"Y", "\[LeftArrow]", 
       RowBox[{"Y", "+", "Z"}]}]}], ",", 
     RowBox[{
      RowBox[{"X", "+", "Z"}], "\[Rule]", 
      RowBox[{"X", "+", "Y", "+", "Z"}]}], ",", 
     RowBox[{"0", "\[Rule]", "Z"}], ",", 
     RowBox[{
      RowBox[{"3", "X"}], "\[Rule]", 
      RowBox[{
       RowBox[{"3", "X"}], "+", "Z"}]}], ",", 
     RowBox[{
      RowBox[{"2", "Z"}], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.", "/", "3"}], ",", "2", ",", "1", ",", "1", ",", "1", ",", 
     "1", ",", "3", ",", "1", ",", "1", ",", "2", ",", "1", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7129350780127316`*^9, 3.712935283516814*^9}, {
  3.712935572278536*^9, 3.7129356047309246`*^9}, {3.7305707076915035`*^9, 
  3.730570735519681*^9}},ExpressionUUID->"9de270c1-67a9-4b3d-9093-\
7e2a4b0e7b92"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 9.17", "Subsubsection",
 CellChangeTimes->{{3.7129290585393343`*^9, 3.7129290647464604`*^9}, {
   3.730570291596939*^9, 3.7305702941438184`*^9}, 
   3.7306480456728687`*^9},ExpressionUUID->"df47aeb1-d44d-4ae2-813f-\
9dac97329bb7"],

Cell[BoxData[
 RowBox[{"ssm", "=", 
  RowBox[{"StateSpaceModel", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "k"}], ",", "k", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{
          RowBox[{"-", "2"}], "k"}], ",", "k"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "k", ",", 
         RowBox[{"-", "k"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"IdentityMatrix", "[", "3", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.712989344849896*^9, 3.7129894616300936`*^9}, {
  3.712989519907044*^9, 3.7129895242392426`*^9}, {3.7306481711990585`*^9, 
  3.7306482074689097`*^9}, {3.7306483066722293`*^9, 
  3.7306483094691086`*^9}},ExpressionUUID->"cee4adcf-a362-45ab-891b-\
8ff8e3d80c95"],

Cell[BoxData[
 RowBox[{"ControllableModelQ", "[", "ssm", "]"}]], "Input",
 CellChangeTimes->{{3.730648274203417*^9, 
  3.730648282859682*^9}},ExpressionUUID->"22b9459e-e530-4f79-b89a-\
3712c59d9a1f"],

Cell[BoxData[
 RowBox[{"ssmlumped", "=", 
  RowBox[{"StateSpaceModel", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "k"}], "/", "2"}], ",", 
         RowBox[{"k", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k", "/", "2"}], ",", 
         RowBox[{
          RowBox[{"-", "k"}], "/", "2"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"IdentityMatrix", "[", "2", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.712989344849896*^9, 3.7129894616300936`*^9}, {
  3.712989519907044*^9, 3.7129895242392426`*^9}, {3.7306481711990585`*^9, 
  3.7306482074689097`*^9}, {3.7306483066722293`*^9, 
  3.730648401781789*^9}},ExpressionUUID->"d8a5ce5c-ff58-4f39-be9f-\
894199ca1981"],

Cell[BoxData[
 RowBox[{"ControllableModelQ", "[", "ssmlumped", "]"}]], "Input",
 CellChangeTimes->{{3.730648274203417*^9, 3.730648282859682*^9}, {
  3.7306484168286943`*^9, 
  3.7306484183755713`*^9}},ExpressionUUID->"126b4424-64a5-42a0-abb1-\
24cfce6886e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 9.20", "Subsubsection",
 CellChangeTimes->{{3.7129290585393343`*^9, 3.7129290647464604`*^9}, {
   3.730570291596939*^9, 3.7305702941438184`*^9}, 3.7306480456728687`*^9, {
   3.730648509453876*^9, 
   3.730648510641377*^9}},ExpressionUUID->"4687f9bc-a500-4905-a53a-\
9fc71376ad31"],

Cell[BoxData[
 RowBox[{"fhjreac", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<F\>\"", " ", "\[LeftRightArrow]", 
     RowBox[{"\"\<D\>\"", "+", "\"\<E\>\""}], "\[LeftArrow]", " ", 
     "\"\<C\>\"", " ", "\[LeftRightArrow]", " ", 
     RowBox[{"\"\<A\>\"", "+", "\"\<B\>\""}]}], "\[Rule]", 
    RowBox[{"\"\<G\>\"", "\[Rule]", 
     RowBox[{
      RowBox[{"\"\<H\>\"", " ", "\[LeftRightArrow]", " ", 
       RowBox[{"2", "\"\<J\>\""}]}], "\[Rule]", "\"\<G\>\""}]}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.730877892776595*^9, 
  3.730877905026621*^9}},ExpressionUUID->"4d090a56-dd6a-45df-8cc0-\
d09b1b36eec3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rdatafhjreac", "=", 
   RowBox[{"ReactionsData", "[", "fhjreac", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7308786647781057`*^9, 
  3.730878665418734*^9}},ExpressionUUID->"2ae2ddfc-9dbc-4348-8a58-\
bf7417e24c7c"],

Cell[BoxData[
 RowBox[{"Row", "@@", 
  RowBox[{"{", 
   RowBox[{"Column", "/@", 
    RowBox[{"(", 
     RowBox[{"sod", "=", 
      RowBox[{"DeterministicModel", "[", 
       RowBox[{"fhjreac", ",", 
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{"1", "&"}], ",", "10"}], "]"}]}], "]"}]}], ")"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.730877809370183*^9, 3.730877819245204*^9}, {
  3.7308779095891304`*^9, 
  3.730877966229866*^9}},ExpressionUUID->"53d8a69c-3817-4498-bafa-\
bd89946105e2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"vars", ",", "saw"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{
    RowBox[{"sod", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "/.", 
    RowBox[{
     RowBox[{
      SubscriptBox["c", "x_"], "[", "t", "]"}], "\[Rule]", 
     SubscriptBox["\[Rho]", "x"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"saw", "=", 
  RowBox[{"SolveAlways", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"vars", ".", 
      RowBox[{"(", 
       RowBox[{"Last", "/@", 
        RowBox[{"sod", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], "\[Equal]", "0"}], ",", 
    RowBox[{"sod", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.730655702569614*^9, 3.7306557241946583`*^9}, {
  3.730655760679104*^9, 3.730655898960623*^9}, {3.7306559328825645`*^9, 
  3.730655934163816*^9}, {3.73077666301247*^9, 3.730776696825036*^9}, {
  3.7308778702140512`*^9, 3.7308778894640903`*^9}, {3.730877987323656*^9, 
  3.7308780068236957`*^9}, {3.7308780552769136`*^9, 3.7308780771988335`*^9}, {
  3.7308781324020653`*^9, 3.730878146058343*^9}, {3.7308781773084035`*^9, 
  3.730878248574168*^9}, {3.73087832396494*^9, 3.730878337496219*^9}, {
  3.7308783753400407`*^9, 
  3.730878430918274*^9}},ExpressionUUID->"5f109ebe-ece0-47f4-8445-\
2f22bb40e8d0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"vars", "/.", "saw"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<B\>\""], "\[Rule]", "1"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<E\>\""], "\[Rule]", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<F\>\""], "\[Rule]", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<J\>\""], "\[Rule]", "0"}]}], "}"}]}], 
   ")"}], ".", 
  RowBox[{"rdatafhjreac", "[", "\[Gamma]", "]"}]}]], "Input",
 CellChangeTimes->{{3.7308784509339385`*^9, 3.7308784681839695`*^9}, {
  3.7308785270903378`*^9, 3.7308786134498816`*^9}, {3.7308786559343395`*^9, 
  3.7308786744656253`*^9}},ExpressionUUID->"771117b9-4cf6-4f3a-89f1-\
f81f16b3906a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"vars", "/.", "saw"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<B\>\""], "\[Rule]", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<E\>\""], "\[Rule]", "1"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<F\>\""], "\[Rule]", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<J\>\""], "\[Rule]", "0"}]}], "}"}]}], 
   ")"}], ".", 
  RowBox[{"rdatafhjreac", "[", "\[Gamma]", "]"}]}]], "Input",
 CellChangeTimes->{{3.7308786949656663`*^9, 
  3.73087869604379*^9}},ExpressionUUID->"b409b9d4-3c3a-4eb9-a0a5-\
853bef4fd620"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"vars", "/.", "saw"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<B\>\""], "\[Rule]", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<E\>\""], "\[Rule]", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<F\>\""], "\[Rule]", "1"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<J\>\""], "\[Rule]", "0"}]}], "}"}]}], 
   ")"}], ".", 
  RowBox[{"rdatafhjreac", "[", "\[Gamma]", "]"}]}]], "Input",
 CellChangeTimes->{{3.730878691481286*^9, 
  3.730878712981325*^9}},ExpressionUUID->"f3edb1f2-e9df-450f-8ec3-\
f7258ff63e6f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"vars", "/.", "saw"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<B\>\""], "\[Rule]", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<E\>\""], "\[Rule]", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<F\>\""], "\[Rule]", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Rho]", "\"\<J\>\""], "\[Rule]", "1"}]}], "}"}]}], 
   ")"}], ".", 
  RowBox[{"rdatafhjreac", "[", "\[Gamma]", "]"}]}]], "Input",ExpressionUUID->\
"4a70ecb5-2039-40f9-9390-2611b62cc00a"],

Cell["\<\
Here we have two linear first integrals which are different form the left \
null vectors of \[Gamma].\
\>", "Text",
 CellChangeTimes->{{3.730656305570793*^9, 
  3.7306563340083485`*^9}},ExpressionUUID->"f42b916d-79a0-4500-a7d5-\
bef637f22c98"],

Cell[BoxData[
 RowBox[{"saw", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Rho]", "\"\<B\>\""], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["\[Rho]", "\"\<E\>\""], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["\[Rho]", "\"\<F\>\""], "\[Rule]", "1"}], ",", 
    RowBox[{
     SubscriptBox["\[Rho]", "\"\<J\>\""], "\[Rule]", "0"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{
  3.730878747512644*^9},ExpressionUUID->"ef2ac684-1a04-428b-b501-\
8d300fc2d765"],

Cell[BoxData[
 RowBox[{"saw", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Rho]", "\"\<B\>\""], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["\[Rho]", "\"\<E\>\""], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["\[Rho]", "\"\<F\>\""], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["\[Rho]", "\"\<J\>\""], "\[Rule]", "1"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.730878756747039*^9, 
  3.7308787637626724`*^9}},ExpressionUUID->"a97bc159-fe46-44a3-b393-\
b711e83b266b"],

Cell[BoxData[
 RowBox[{"NullSpace", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"rdata", "[", "\[Gamma]", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7308788262002974`*^9, 
  3.730878838669072*^9}},ExpressionUUID->"727caed9-f545-499d-989a-\
bf53ae8a4ee8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GammaLeftNullSpace", "[", "fhjreac", "]"}], "//", 
  "Column"}]], "Input",
 CellChangeTimes->{{3.7306563404458647`*^9, 3.730656372570924*^9}, {
  3.7308787768408284`*^9, 3.7308788139658985`*^9}, {3.7308788446222115`*^9, 
  3.7308788469034615`*^9}},ExpressionUUID->"cd95da27-1d46-447d-b232-\
47e101c09938"],

Cell["\<\
From the result of SolveAlways above we have received two of these vectors \
generatng the left null space. The third one can be obtained as a linear \
combination of the two ,,wrong\[CloseCurlyDoubleQuote] solutions: \
\>", "Text",
 CellChangeTimes->{{3.7308795721548786`*^9, 3.730879628139366*^9}, {
  3.7308797376083317`*^9, 
  3.730879746186472*^9}},ExpressionUUID->"188abaa8-2554-4946-9240-\
da090bf1c60e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"vars", "/.", "saw"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Rho]", "\"\<B\>\""], "\[Rule]", "0"}], ",", 
         RowBox[{
          SubscriptBox["\[Rho]", "\"\<E\>\""], "\[Rule]", "0"}], ",", 
         RowBox[{
          SubscriptBox["\[Rho]", "\"\<F\>\""], "\[Rule]", "1"}], ",", 
         RowBox[{
          SubscriptBox["\[Rho]", "\"\<J\>\""], "\[Rule]", "0"}]}], "}"}]}], 
      ")"}]}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"vars", "/.", "saw"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Rho]", "\"\<B\>\""], "\[Rule]", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Rho]", "\"\<E\>\""], "\[Rule]", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Rho]", "\"\<F\>\""], "\[Rule]", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Rho]", "\"\<J\>\""], "\[Rule]", "1"}]}], "}"}]}], 
     ")"}]}], ")"}], ".", 
  RowBox[{"rdatafhjreac", "[", "\[Gamma]", "]"}]}]], "Input",
 CellChangeTimes->{{3.730879642076893*^9, 
  3.7308796614050555`*^9}},ExpressionUUID->"f592a0d1-0e72-469a-a121-\
b28057252373"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 9.16", "Subsubsection",
 CellChangeTimes->{{3.71299723481329*^9, 3.7129972407591777`*^9}, {
  3.730779011914184*^9, 
  3.7307790222167716`*^9}},ExpressionUUID->"aff6d064-eb1d-441b-ad03-\
255b42607dac"],

Cell[BoxData[
 RowBox[{"rhs", "=", 
  RowBox[{"RightHandSide", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<Br2\>\"", "\[Rule]", 
       RowBox[{"2", "\"\<Br\>\""}]}], ",", 
      RowBox[{
       RowBox[{"\"\<H2\>\"", "+", "\"\<Br\>\""}], "\[Rule]", 
       RowBox[{"\"\<H\>\"", "+", "\"\<HBr\>\""}]}], ",", 
      RowBox[{
       RowBox[{"\"\<H\>\"", "+", "\"\<Br2\>\""}], "\[Rule]", 
       RowBox[{"\"\<Br\>\"", "+", "\"\<HBr\>\""}]}], ",", 
      RowBox[{
       RowBox[{"\"\<H\>\"", "+", "\"\<HBr\>\""}], "\[Rule]", 
       RowBox[{"\"\<H2\>\"", "+", "\"\<Br\>\""}]}], ",", 
      RowBox[{
       RowBox[{"2", "\"\<Br\>\""}], "\[Rule]", "\"\<Br2\>\""}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"], ",", 
      SubscriptBox["k", "4"], ",", 
      SubscriptBox["k", "5"]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7129972612093782`*^9, 3.712997409837718*^9}, {
  3.7307790517274637`*^9, 
  3.7307790883625593`*^9}},ExpressionUUID->"61f09920-95bc-47a0-8991-\
8aebc08385d3"],

Cell[BoxData[
 RowBox[{"ex", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"rhs", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"rhs", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", " ", 
       RowBox[{
        SubscriptBox["c", "\"\<Br\>\""], ",", 
        SubscriptBox["c", "\"\<H\>\""]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}], "//", "PowerExpand"}]}]], "Input",
 CellChangeTimes->{{3.712997436821902*^9, 3.7129975116980352`*^9}, {
  3.730779186699191*^9, 
  3.7307791892453365`*^9}},ExpressionUUID->"679072b0-3bd3-495c-9193-\
d1dc704c98c9"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stochastic", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
  3.7105102793123665`*^9, 
  3.7105102814217463`*^9}},ExpressionUUID->"d99ed372-a59a-4775-8bdc-\
884d8982ad95"],

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"e63e06de-58b2-4e76-b2ae-\
e993ff9dc23b"],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"a550bcaa-af77-4290-bc7d-\
5ef4687d7eb2"],

Cell[CellGroupData[{

Cell["Solution 10.1", "Subsection",
 CellChangeTimes->{{3.714643905377195*^9, 3.7146439144397125`*^9}, {
  3.7292425189448357`*^9, 3.7292425333511133`*^9}, {3.730386698881101*^9, 
  3.73038670453736*^9}},ExpressionUUID->"bbf7c209-8f9c-4023-ad55-\
fd32c0f0379a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gene", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
      "\"\<inactive gene\>\"", "\[DoubleLeftRightArrow]", " ", 
       "\"\<active gene\>\""}], " ", "\[Rule]", 
      RowBox[{"\"\<messenger\>\"", "\[Rule]", 
       RowBox[{"\"\<protein\>\"", "\[Rule]", "0"}]}]}], ",", 
     RowBox[{"\"\<messenger\>\"", "\[Rule]", "0"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7146439341741247`*^9, 3.714643951017909*^9}, {
  3.730386685943576*^9, 3.7303867300374117`*^9}, {3.7305541718804274`*^9, 
  3.7305542143180094`*^9}},ExpressionUUID->"ae16c2e7-8590-45bc-a465-\
31bb1ddc83a2"],

Cell[BoxData[
 RowBox[{"MasterEquation", "[", 
  RowBox[{
   RowBox[{"{", "gene", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Lambda]", "1"], ",", 
     SubscriptBox["\[Lambda]", 
      RowBox[{"-", "1"}]], ",", 
     SubscriptBox["\[Lambda]", "2"], ",", 
     SubscriptBox["\[Lambda]", "3"], ",", 
     SubscriptBox["\[Gamma]", "+"], ",", 
     SubscriptBox["\[Gamma]", "-"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "i", ",", "a", ",", "m", ",", "p"}], "}"}], ",", "P"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.730386747553075*^9, 3.7303868287563553`*^9}, {
  3.7303869151315236`*^9, 3.7303869426159525`*^9}, {3.730554235536801*^9, 
  3.73055426352123*^9}},ExpressionUUID->"9996d933-a8c1-4015-a2cb-\
ca871e7e88ff"],

Cell[BoxData[
 RowBox[{"ProbabilityGeneratingFunctionEquation", "[", 
  RowBox[{
   RowBox[{"{", "gene", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Lambda]", "1"], ",", 
     SubscriptBox["\[Lambda]", 
      RowBox[{"-", "1"}]], ",", 
     SubscriptBox["\[Lambda]", "2"], ",", 
     SubscriptBox["\[Lambda]", "3"], ",", 
     SubscriptBox["\[Gamma]", "+"], ",", 
     SubscriptBox["\[Gamma]", "-"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y", ",", "u", ",", "v"}], "}"}], ",", "G"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.730386865912679*^9, 3.7303868816314588`*^9}, {
   3.7303869541159754`*^9, 3.7303869548503523`*^9}, 
   3.730554281427516*^9},ExpressionUUID->"21b78a43-7d0c-450a-8205-\
879766bc0a7c"],

Cell[BoxData[
 RowBox[{"SolveProbabilityGeneratingFunctionEquation", "[", 
  RowBox[{
   RowBox[{"{", "gene", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{".1", ",", ".2", ",", ".3", ",", ".4", ",", ".5", ",", ".6"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y", ",", "u", ",", "v"}], "}"}], ",", "G", 
   ",", 
   RowBox[{"Method", "\[Rule]", "\"\<MatrixExponential\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.730386865912679*^9, 3.7303868816314588`*^9}, {
   3.7303869541159754`*^9, 3.7303869548503523`*^9}, {3.730554281427516*^9, 
   3.7305543120057*^9}, {3.7305543517870293`*^9, 3.730554448912218*^9}, {
   3.730554618865676*^9, 3.730554662662636*^9}, 3.7307793654202676`*^9, 
   3.730895672045542*^9},ExpressionUUID->"fc2ef69b-70b7-4c67-a002-\
7ad241a92c7e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SolveProbabilityGeneratingFunctionEquation", "[", 
    RowBox[{
     RowBox[{"{", "gene", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "3.", ",", "4.", ",", "5.", ",", "6."}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "x", ",", "y", ",", "u", ",", "v"}], "}"}], ",", "G", 
     ",", 
     RowBox[{"Method", "\[Rule]", "\"\<Characteristics\>\""}]}], "]"}], "//", 
   "Quiet"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.730386865912679*^9, 3.7303868816314588`*^9}, {
   3.7303869541159754`*^9, 3.7303869548503523`*^9}, {3.730554281427516*^9, 
   3.7305543120057*^9}, {3.7305543517870293`*^9, 3.730554448912218*^9}, {
   3.7305544789435267`*^9, 3.7305544994123154`*^9}, {3.7305546804595456`*^9, 
   3.7305547403034124`*^9}, 3.7307794126859846`*^9, {3.7307794654360905`*^9, 
   3.730779469748597*^9}},ExpressionUUID->"c9d622a4-8556-42a0-839f-\
5850e113569c"],

Cell["\<\
One should not try to use the program to obtain symbolic solution; pen and \
paper may be preferred.\
\>", "Text",
 CellChangeTimes->{{3.730554766803464*^9, 
  3.7305548051160398`*^9}},ExpressionUUID->"99c4c045-adeb-4bf1-bf7c-\
62ceee9631b9"],

Cell[BoxData[
 RowBox[{"SolveProbabilityGeneratingFunctionEquation", "[", 
  RowBox[{
   RowBox[{"{", "gene", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Lambda]", "1"], ",", 
     SubscriptBox["\[Lambda]", 
      RowBox[{"-", "1"}]], ",", 
     SubscriptBox["\[Lambda]", "2"], ",", 
     SubscriptBox["\[Lambda]", "3"], ",", 
     SubscriptBox["\[Gamma]", "+"], ",", 
     SubscriptBox["\[Gamma]", "-"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y", ",", "u", ",", "v"}], "}"}], ",", "G", 
   ",", 
   RowBox[{"Method", "\[Rule]", "\"\<MatrixExponential\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.730386865912679*^9, 3.7303868816314588`*^9}, {
  3.7303869541159754`*^9, 3.7303869548503523`*^9}, {3.730554281427516*^9, 
  3.7305543120057*^9}, {3.7305543517870293`*^9, 3.730554374552697*^9}, {
  3.7307796250301523`*^9, 3.730779651764579*^9}, {3.7308957062331095`*^9, 
  3.730895721076888*^9}},ExpressionUUID->"12f4a8c5-a615-47d5-9432-\
2a990e2b218a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 10.2", "Subsection",
 CellChangeTimes->{{3.714643905377195*^9, 3.7146439144397125`*^9}, {
  3.7292425189448357`*^9, 3.7292425333511133`*^9}, {3.730386698881101*^9, 
  3.73038670453736*^9}, {3.730386988819168*^9, 
  3.7303869896004195`*^9}},ExpressionUUID->"6cff933a-c49e-4903-b844-\
ea0fe22b78a6"],

Cell[BoxData[
 RowBox[{"MasterEquation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", "k", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x"}], "}"}], ",", "P"}], "]"}]], "Input",
 CellChangeTimes->{{3.713798693981098*^9, 3.713798748348211*^9}, {
  3.7137988013342447`*^9, 3.7137988025933175`*^9}, {3.7303871227881804`*^9, 
  3.7303871612570047`*^9}},ExpressionUUID->"0a6e3673-1d51-473d-98dd-\
bd4f3fb5d95f"],

Cell[BoxData[
 RowBox[{"ProbabilityGeneratingFunctionEquation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", "k", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "z"}], "}"}], ",", "G"}], "]"}]], "Input",
 CellChangeTimes->{{3.713798693981098*^9, 3.713798748348211*^9}, {
  3.7137988013342447`*^9, 3.7137988025933175`*^9}, {3.7303871227881804`*^9, 
  3.730387127553816*^9}},ExpressionUUID->"10202ba5-1c9e-4fcd-88e8-\
60fc11ee3a45"],

Cell[BoxData[
 RowBox[{"SolveProbabilityGeneratingFunctionEquation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", "k", "}"}], ",", 
   RowBox[{"{", "x0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "z"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Characteristics\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7131874664115005`*^9, 3.713187505802203*^9}, {
  3.7131876018180175`*^9, 3.71318761186491*^9}, {3.7137988201903253`*^9, 
  3.7137988321600103`*^9}},ExpressionUUID->"0c9fb72b-a81a-4d67-a8b4-\
0df25096c8c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"G", "[", 
   RowBox[{"t_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"SolveProbabilityGeneratingFunctionEquation", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], ",", 
    RowBox[{"{", "k", "}"}], ",", 
    RowBox[{"{", "x0", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "z"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", "\"\<MatrixExponential\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7131874664115005`*^9, 3.713187505802203*^9}, {
  3.7131876018180175`*^9, 3.71318761186491*^9}, {3.7137988201903253`*^9, 
  3.7137988321600103`*^9}, {3.7303872380696573`*^9, 3.7303872477102995`*^9}, {
  3.7303872893353815`*^9, 
  3.7303872978197727`*^9}},ExpressionUUID->"f1213dfc-311d-4933-85bf-\
836305f8ea4e"],

Cell[BoxData[
 RowBox[{"G", "[", 
  RowBox[{"t", ",", "z"}], "]"}]], "Input",
 CellChangeTimes->{{3.7305548896318307`*^9, 
  3.7305548941318393`*^9}},ExpressionUUID->"83731775-025e-4534-a8ce-\
d255e44bb15d"],

Cell["One can verify that the distribution is binomial.", "Text",
 CellChangeTimes->{{3.730554918991262*^9, 3.7305549387881765`*^9}, 
   3.7308958224833374`*^9},ExpressionUUID->"e34f33bf-4af3-435e-b8b7-\
55b0d3fa38b9"],

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x0", ">", "0"}], "&&", 
    RowBox[{"x0", "\[Element]", "Integers"}]}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"G", "[", 
      RowBox[{"t", ",", "z"}], "]"}], "\[Equal]", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"x", "=", "0"}], "x0"], 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"x0", ",", "x"}], "]"}], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "k"}], " ", "t", " ", "x"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "k"}], " ", "t"}]]}], ")"}], 
        RowBox[{"x0", "-", "x"}]], 
       SuperscriptBox["z", "x"]}]}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7303873110385485`*^9, 3.7303874286637783`*^9}, {
  3.730387467940666*^9, 3.7303874736594267`*^9}, {3.730387514628256*^9, 
  3.7303876334566145`*^9}},ExpressionUUID->"2700e810-3797-4d23-8189-\
c44bf259f376"],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"BinomialDistribution", "[", 
   RowBox[{"x0", ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "k"}], " ", "t"}]]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7303876635972967`*^9, 3.730387696847363*^9}, {
  3.7303877298474245`*^9, 
  3.7303877303474293`*^9}},ExpressionUUID->"b33bdf15-1b5c-475e-bcf3-\
1c2944171669"],

Cell[BoxData[
 RowBox[{"Expectation", "[", 
  RowBox[{
   SuperscriptBox["X", "2"], ",", 
   RowBox[{"X", "\[Distributed]", 
    RowBox[{"BinomialDistribution", "[", 
     RowBox[{"x0", ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "k"}], " ", "t"}]]}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7303877619724936`*^9, 3.730387779144399*^9}, {
  3.730387809378832*^9, 
  3.7303878296132474`*^9}},ExpressionUUID->"f044aa63-5802-4c6c-ad56-\
89273f4a6d21"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mom", "[", "i_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Moment", "[", 
    RowBox[{
     RowBox[{"BinomialDistribution", "[", 
      RowBox[{"x0", ",", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "k"}], " ", "t"}]]}], "]"}], ",", "i"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.71379812215335*^9, 3.713798161123583*^9}, {
  3.7137985054413004`*^9, 3.713798534478963*^9}, {3.730388425973987*^9, 
  3.730388426598987*^9}},ExpressionUUID->"e69669de-612b-4874-9d4e-\
fa1105dec985"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mom", "/@", 
   RowBox[{"Range", "[", "4", "]"}]}], "//", "Column"}]], "Input",
 CellChangeTimes->{{3.730388433927129*^9, 
  3.730388452505287*^9}},ExpressionUUID->"aca7d3e8-6f45-4162-8bb8-\
917e672f87f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MomentEquations", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], ",", 
      RowBox[{"{", "#", "}"}], ",", 
      RowBox[{"{", "k", "}"}]}], "]"}], "&"}], "/@", 
   RowBox[{"Range", "[", "4", "]"}]}], "//", "Column"}]], "Input",
 CellChangeTimes->{{3.7303885094272738`*^9, 
  3.730388537755454*^9}},ExpressionUUID->"81cb1186-6e18-44d4-8911-\
1c9f73b09efa"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 10.3", "Subsection",
 CellChangeTimes->{{3.714643905377195*^9, 3.7146439144397125`*^9}, {
  3.7292425189448357`*^9, 3.7292425333511133`*^9}, {3.730386698881101*^9, 
  3.73038670453736*^9}, {3.7303878681758227`*^9, 
  3.7303878690664487`*^9}},ExpressionUUID->"e5079650-a246-497b-a567-\
0f37d17663e5"],

Cell[BoxData[
 RowBox[{"MasterEquation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "Y"}], "\[LeftArrow]", 
      RowBox[{"X", "+", "Y"}]}], "\[Rule]", " ", 
     RowBox[{"2", "X"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y"}], "}"}], ",", "P"}], "]"}]], "Input",
 CellChangeTimes->{{3.7303878863789825`*^9, 3.730387985285426*^9}, {
   3.7303881230981956`*^9, 3.730388124941949*^9}, 
   3.730388633521269*^9},ExpressionUUID->"882a0979-7d3f-488d-8531-\
b3430e605193"],

Cell[BoxData[
 RowBox[{"pgfe", "=", 
  RowBox[{"ProbabilityGeneratingFunctionEquation", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "Y"}], "\[LeftArrow]", 
       RowBox[{"X", "+", "Y"}]}], "->", 
      RowBox[{"2", "X"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "1"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      SubscriptBox["z", "1"], ",", 
      SubscriptBox["z", "2"]}], "}"}], ",", "G"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7303878863789825`*^9, 3.730388036504276*^9}, {
  3.730388165301403*^9, 3.730388169598287*^9}, {3.7303882183954554`*^9, 
  3.73038822014546*^9}},ExpressionUUID->"31d55e4c-bb0e-42b5-b4c6-\
7f5222d5e6a9"],

Cell[BoxData[
 RowBox[{"simple", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["k", "1"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubsuperscriptBox["z", "1", "2"], "-", 
       RowBox[{
        SubscriptBox["z", "1"], " ", 
        SubscriptBox["z", "2"]}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["G", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", 
       SubscriptBox["z", "1"], ",", 
       SubscriptBox["z", "2"]}], "]"}]}], "+", 
    RowBox[{
     SubscriptBox["k", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["z", "1"]}], " ", 
        SubscriptBox["z", "2"]}], "+", 
       SubsuperscriptBox["z", "2", "2"]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["G", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", 
       SubscriptBox["z", "1"], ",", 
       SubscriptBox["z", "2"]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7305553202108*^9, 
  3.7305553328983216`*^9}},ExpressionUUID->"70f51f7f-2a8e-4dd7-aaf1-\
e5488e659e12"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "G", "]"}], ";", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["G", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"z1", ",", "z2"}], "]"}], "==", "0"}], ",", 
    RowBox[{"G", "[", 
     RowBox[{"z1", ",", "z2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z1", ",", "z2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7305552554450455`*^9, 3.7305552882419844`*^9}, {
  3.7305553475389752`*^9, 3.7305553481483517`*^9}, {3.730557173281046*^9, 
  3.73055727504687*^9}},ExpressionUUID->"2f7bfead-dd3c-48c8-a3cb-\
56089bd216a6"],

Cell[BoxData[
 RowBox[{"StationaryProbabilityDistributionEquation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "Y"}], "\[LeftArrow]", 
      RowBox[{"X", "+", "Y"}]}], "\[Rule]", " ", 
     RowBox[{"2", "X"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["k", "2"], ",", 
     SubscriptBox["k", "1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "P"}], "]"}]], "Input",
 CellChangeTimes->{{3.730555000319548*^9, 3.7305550322727337`*^9}, 
   3.7306098863810062`*^9},ExpressionUUID->"1d855de3-5188-4e49-b703-\
cdcd82b2b7e5"],

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"StationaryProbabilityDistributionEquation", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "Y"}], "\[LeftArrow]", 
        RowBox[{"X", "+", "Y"}]}], "\[Rule]", " ", 
       RowBox[{"2", "X"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "P"}], "]"}], ",", 
   RowBox[{"P", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7305550532883997`*^9, 3.730555146491708*^9}, 
   3.730609888325117*^9},ExpressionUUID->"9e62075c-cd0c-4534-bd15-\
bb228d0dcc8e"],

Cell[BoxData[
 RowBox[{"dm", "=", 
  RowBox[{
   RowBox[{"DeterministicModel", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "Y"}], "\[LeftArrow]", 
        RowBox[{"X", "+", "Y"}]}], "->", 
       RowBox[{"2", "X"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["k", "2"], ",", 
       SubscriptBox["k", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730388053863686*^9, 3.7303880744574766`*^9}, {
  3.730388281176828*^9, 
  3.7303882902862206`*^9}},ExpressionUUID->"59858e41-7428-482d-a922-\
49a513d2c510"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dm", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], "\[Rule]", 
     RowBox[{
      SubscriptBox["x", "0"], "+", 
      SubscriptBox["y", "0"], "-", 
      RowBox[{"x", "[", "t", "]"}]}]}], "}"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.730388293848728*^9, 
  3.730388348348835*^9}},ExpressionUUID->"fddef02d-77da-4bda-8510-\
5f79fa0576b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 10.4", "Subsection",
 CellChangeTimes->{{3.714643905377195*^9, 3.7146439144397125`*^9}, {
  3.7292425189448357`*^9, 3.7292425333511133`*^9}, {3.730386698881101*^9, 
  3.73038670453736*^9}, {3.7303878681758227`*^9, 3.7303878690664487`*^9}, {
  3.7303883722707586`*^9, 
  3.7303883730051327`*^9}},ExpressionUUID->"083d9b27-1b39-4167-9368-\
1adff1e5747b"],

Cell[BoxData[
 RowBox[{"avogadronumber", "=", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{"Quantity", "[", 
    RowBox[{"1", ",", "\"\<AvogadroConstant\>\""}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7136777886774883`*^9, 3.7136778057790117`*^9}},
 NumberMarks->False,ExpressionUUID->"fb9d2864-8c81-4629-ba7f-f884638b60e8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ksto", "[", 
   RowBox[{"reactionstep_", ",", "kdet_", ",", "V_"}], "]"}], ":=", 
  RowBox[{"kdet", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"avogadronumber", " ", "V"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"ReactionsData", "[", 
        RowBox[{"{", "reactionstep", "}"}], "]"}], "[", 
       "\"\<reactionsteporders\>\"", "]"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7136770855586*^9, 3.713677136440983*^9}, {
   3.7136775916002784`*^9, 3.7136775958188195`*^9}, {3.7136778188947134`*^9, 
   3.7136778260915585`*^9}, {3.713678426530613*^9, 3.7136784309357176`*^9}, 
   3.713678479468896*^9, {3.7302154683282585`*^9, 
   3.730215469031386*^9}},ExpressionUUID->"3d15562d-1566-46ce-acdd-\
4aed9cfa1bbd"],

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ksto", "[", 
     RowBox[{"#1", ",", "#2", ",", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "12"}]], "\"\<L\>\""}]}], "]"}], "&"}], ",", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{
      RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}], "]"}], "[", 
    "\"\<reactionsteps\>\"", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", 
      SuperscriptBox["\"\<s\>\"", 
       RowBox[{"-", "1"}]]}], ",", 
     RowBox[{"40", "\"\<L\>\"", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", 
        SuperscriptBox["\"\<Moles\>\"", 
         RowBox[{"-", "1"}]]}], "]"}], 
      SuperscriptBox["\"\<s\>\"", 
       RowBox[{"-", "1"}]]}], ",", 
     RowBox[{"0.5", 
      SuperscriptBox["\"\<s\>\"", 
       RowBox[{"-", "1"}]]}]}], "}"}], ",", "List"}], "]"}]], "Input",
 CellChangeTimes->{{3.730392017131225*^9, 3.7303920600219345`*^9}, {
   3.730392208631598*^9, 3.7303922605223246`*^9}, {3.7303922952880177`*^9, 
   3.730392302881782*^9}, 3.7303923992257204`*^9, {3.7303924379914217`*^9, 
   3.730392457694585*^9}, {3.730392504632178*^9, 3.7303925458510065`*^9}, {
   3.730392592444851*^9, 3.730392604116747*^9}, {3.730393075539542*^9, 
   3.730393120649007*^9}, {3.730558000974527*^9, 3.730558002771405*^9}, {
   3.7305582399437447`*^9, 3.7305582576000285`*^9}, {3.7305584636004314`*^9, 
   3.7305584698660693`*^9}, {3.730558813491452*^9, 3.730558823288348*^9}, {
   3.730558861694675*^9, 3.7305589091791415`*^9}, {3.730558963991747*^9, 
   3.7305590223668623`*^9}, {3.7305592197266226`*^9, 
   3.7305592205547495`*^9}, {3.7305594725085945`*^9, 
   3.730559491993007*^9}},ExpressionUUID->"d303116a-45eb-4822-affe-\
182b3f164f2f"],

Cell["\<\
Can you solve it easier? Quantities seem to work quite awkwardly.\
\>", "Text",
 CellChangeTimes->{{3.7305595405712276`*^9, 3.7305595539931326`*^9}, {
  3.730567938623587*^9, 
  3.7305679597173786`*^9}},ExpressionUUID->"97776d27-710c-4991-a774-\
529a214c4e9f"],

Cell[CellGroupData[{

Cell["Michaelis--Menten", "Subsubsection",
 CellChangeTimes->{{3.71368271643395*^9, 3.713682724148647*^9}, 
   3.713682768933937*^9},ExpressionUUID->"219311ba-6f14-4c52-9495-\
30c950c2bc31"],

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ksto", "[", 
     RowBox[{"#1", ",", "#2", ",", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "12"}]], "\"\<L\>\""}]}], "]"}], "&"}], ",", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "\"\<Michaelis-Menten\>\"", "}"}], "]"}], "[", 
    "\"\<reactionsteps\>\"", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<L\>\"", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", 
        SuperscriptBox["\"\<Moles\>\"", 
         RowBox[{"-", "1"}]]}], "]"}], 
      RowBox[{"Quantity", "[", 
       RowBox[{"40", ",", 
        SuperscriptBox["\"\<Seconds\>\"", 
         RowBox[{"-", "1"}]]}], "]"}]}], ",", 
     RowBox[{"Quantity", "[", 
      RowBox[{"5", ",", 
       SuperscriptBox["\"\<Seconds\>\"", 
        RowBox[{"-", "1"}]]}], "]"}], ",", 
     RowBox[{"Quantity", "[", 
      RowBox[{"0.5", ",", 
       SuperscriptBox["\"\<Seconds\>\"", 
        RowBox[{"-", "1"}]]}], "]"}]}], "}"}], ",", "List"}], "]"}]], "Input",
 CellChangeTimes->{{3.730392017131225*^9, 3.7303920600219345`*^9}, {
   3.730392208631598*^9, 3.7303922605223246`*^9}, {3.7303922952880177`*^9, 
   3.730392302881782*^9}, 3.7303923992257204`*^9, {3.7303924379914217`*^9, 
   3.730392457694585*^9}, {3.730392504632178*^9, 3.7303925458510065`*^9}, {
   3.730392592444851*^9, 3.730392604116747*^9}, {3.730393075539542*^9, 
   3.730393120649007*^9}, {3.730558000974527*^9, 3.730558002771405*^9}, {
   3.7305582399437447`*^9, 3.7305582576000285`*^9}, {3.7305584636004314`*^9, 
   3.7305584698660693`*^9}, {3.730558813491452*^9, 3.730558823288348*^9}, {
   3.730558861694675*^9, 3.7305589091791415`*^9}, {3.730558963991747*^9, 
   3.7305590223668623`*^9}, {3.7305592197266226`*^9, 
   3.7305592205547495`*^9}, {3.7305594725085945`*^9, 3.730559491993007*^9}, {
   3.7305636952700367`*^9, 3.7305637307076054`*^9}, {3.7305637611920385`*^9, 
   3.7305638258327894`*^9}, {3.7305640176313066`*^9, 3.730564089350197*^9}, 
   3.7308959259991627`*^9},ExpressionUUID->"f6370c2b-f487-4937-b940-\
992b03bf66da"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Robertson", "Subsubsection",
 CellChangeTimes->{{3.713682992467518*^9, 3.713683004242058*^9}, {
  3.7302153942968693`*^9, 
  3.7302153946718645`*^9}},ExpressionUUID->"7abdf999-c924-4686-9f94-\
7e9e328ba913"],

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ksto", "[", 
     RowBox[{"#1", ",", "#2", ",", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "12"}]], "\"\<L\>\""}]}], "]"}], "&"}], ",", 
   RowBox[{
    RowBox[{"ReactionsData", "[", 
     RowBox[{"{", "\"\<Robertson\>\"", "}"}], "]"}], "[", 
    "\"\<reactionsteps\>\"", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Quantity", "[", 
      RowBox[{"0.04", ",", 
       SuperscriptBox["\"\<Seconds\>\"", 
        RowBox[{"-", "1"}]]}], "]"}], ",", 
     RowBox[{"\"\<L\>\"", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", 
        SuperscriptBox["\"\<Moles\>\"", 
         RowBox[{"-", "1"}]]}], "]"}], 
      RowBox[{"Quantity", "[", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["10", "7"]}], ",", 
        SuperscriptBox["\"\<Seconds\>\"", 
         RowBox[{"-", "1"}]]}], "]"}]}], ",", 
     RowBox[{"\"\<L\>\"", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", 
        SuperscriptBox["\"\<Moles\>\"", 
         RowBox[{"-", "1"}]]}], "]"}], 
      RowBox[{"Quantity", "[", 
       RowBox[{
        SuperscriptBox["10", "4"], ",", 
        SuperscriptBox["\"\<Seconds\>\"", 
         RowBox[{"-", "1"}]]}], "]"}]}]}], "}"}], ",", "List"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.730563902177956*^9, 3.730563994443762*^9}, {
   3.730564122100261*^9, 3.7305641676316*^9}, {3.73056424708488*^9, 
   3.7305642636317883`*^9}, {3.7305677539826*^9, 3.730567786217039*^9}, 
   3.7305679152016664`*^9, {3.730895930639799*^9, 
   3.7308959352179337`*^9}},ExpressionUUID->"8eec9dcf-2b70-4232-842f-\
2460acabc0e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 10.6", "Subsubsection",
 CellChangeTimes->{{3.714643905377195*^9, 3.7146439144397125`*^9}, {
  3.7292425189448357`*^9, 3.7292425333511133`*^9}, {3.730386698881101*^9, 
  3.73038670453736*^9}, {3.7303878681758227`*^9, 3.7303878690664487`*^9}, {
  3.7303883722707586`*^9, 3.7303883730051327`*^9}, {3.7303932803836937`*^9, 
  3.7303933093837504`*^9}},ExpressionUUID->"abb88fb0-d045-46d7-b608-\
77c551137d03"],

Cell[BoxData[
 RowBox[{
  RowBox[{"probabilityGeneratingFunctionEquation", "[", 
   RowBox[{"alpha_", ",", "beta_", ",", "rates_", ",", "vars_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"g", "@@", "vars"}], ",", 
     RowBox[{"First", "[", "vars", "]"}]}], "]"}], "\[Equal]", 
   RowBox[{"Total", "[", 
    RowBox[{"rates", " ", 
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Times", "@@", 
            RowBox[{"(", 
             SuperscriptBox[
              RowBox[{"Rest", "[", "vars", "]"}], "#1"], ")"}]}], "-", 
           RowBox[{"Times", "@@", 
            RowBox[{"(", 
             SuperscriptBox[
              RowBox[{"Rest", "[", "vars", "]"}], "#2"], ")"}]}]}], ")"}], 
         "*", 
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", 
            RowBox[{"0", ",", 
             RowBox[{"Sequence", "@@", "#2"}]}], "]"}], "[", "g", "]"}], "@@",
           "vars"}]}], "&"}], ",", 
       RowBox[{"Transpose", "/@", 
        RowBox[{"{", 
         RowBox[{"beta", ",", "alpha"}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7303933268837852`*^9, 3.7303933268837852`*^9}, {
  3.7303933916651616`*^9, 
  3.7303934055089397`*^9}},ExpressionUUID->"2fc24fd9-374a-47ff-bfab-\
b5489e5473d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"probabilityGeneratingFunctionEquation", "[", 
    RowBox[{"#1", ",", "#2", ",", 
     RowBox[{"{", "k", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "z"}], "}"}]}], "]"}], "&"}], "@@", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], "]"}], "[", 
   RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730393697572009*^9, 
  3.7303937558690004`*^9}},ExpressionUUID->"ff094ceb-3813-47eb-8503-\
62fce0be2d35"],

Cell["Compare it with", "Text",
 CellChangeTimes->{{3.7303934451496415`*^9, 
  3.7303934494465284`*^9}},ExpressionUUID->"af337efc-4165-4080-8802-\
da9e42a981b2"],

Cell[BoxData[
 RowBox[{"ProbabilityGeneratingFunctionEquation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", "k", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "z"}], "}"}], ",", "G"}], "]"}]], "Input",
 CellChangeTimes->{{3.713798693981098*^9, 3.713798748348211*^9}, {
  3.7137988013342447`*^9, 3.7137988025933175`*^9}, {3.7303871227881804`*^9, 
  3.730387127553816*^9}},ExpressionUUID->"d726aae2-43ee-4531-bd90-\
492b8418d0b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 10.7", "Subsubsection",
 CellChangeTimes->{{3.714643905377195*^9, 3.7146439144397125`*^9}, {
  3.7292425189448357`*^9, 3.7292425333511133`*^9}, {3.730386698881101*^9, 
  3.73038670453736*^9}, {3.7303878681758227`*^9, 3.7303878690664487`*^9}, {
  3.7303883722707586`*^9, 3.7303883730051327`*^9}, {3.7303932803836937`*^9, 
  3.7303933093837504`*^9}, {3.7303937800877976`*^9, 
  3.730393780697173*^9}},ExpressionUUID->"2e7906b5-dc63-4668-96f0-\
7ca837c9b30c"],

Cell[BoxData[
 RowBox[{"MomentEquations", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "X"}], " ", "\[LeftArrow]", 
      RowBox[{"X", "+", "Y"}]}], "\[Rule]", 
     RowBox[{"2", "Y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "k"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730393801681591*^9, 3.7303938825879974`*^9}, {
  3.730393918963068*^9, 
  3.730393928259961*^9}},ExpressionUUID->"5db66be6-543b-405c-8920-\
5d732aacabbd"],

Cell[BoxData[
 RowBox[{"MomentEquations", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "X"}], " ", "\[LeftArrow]", 
      RowBox[{"X", "+", "Y"}]}], "\[Rule]", 
     RowBox[{"2", "Y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "k"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730393801681591*^9, 3.7303938825879974`*^9}, {
  3.730393918963068*^9, 
  3.7303939378849792`*^9}},ExpressionUUID->"06534afe-ac6a-43ff-ade7-\
8eba584b0cf8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 10.9", "Subsubsection",
 CellChangeTimes->{{3.714643905377195*^9, 3.7146439144397125`*^9}, {
  3.7292425189448357`*^9, 3.7292425333511133`*^9}, {3.730386698881101*^9, 
  3.73038670453736*^9}, {3.7303878681758227`*^9, 3.7303878690664487`*^9}, {
  3.7303883722707586`*^9, 3.7303883730051327`*^9}, {3.7303932803836937`*^9, 
  3.7303933093837504`*^9}, {3.7303937800877976`*^9, 3.730393780697173*^9}, {
  3.7303939631819086`*^9, 3.7303939639944057`*^9}, {3.7303943121357107`*^9, 
  3.730394312354463*^9}, {3.7305682316866603`*^9, 
  3.730568232171036*^9}},ExpressionUUID->"f6e66d1d-4f6c-4955-90d8-\
00fd62531548"],

Cell[BoxData[
 RowBox[{"StationaryProbabilityDistributionEquation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "\[Rule]", "X"}], ",", 
     RowBox[{
      RowBox[{"a", " ", "X"}], "\[DoubleLeftRightArrow]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "1"}], ")"}], "X"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2", ",", "km2"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}], ",", "P"}], "]"}]], "Input",
 CellChangeTimes->{{3.730568236983547*^9, 3.7305683094211884`*^9}, {
   3.7305683504837694`*^9, 3.730568355202529*^9}, 
   3.7306098899312086`*^9},ExpressionUUID->"a5646f84-9410-44c0-9a73-\
74ba92486690"],

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"StationaryProbabilityDistributionEquation", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0", "\[Rule]", "X"}], ",", 
       RowBox[{
        RowBox[{"3", " ", "X"}], "\[DoubleLeftRightArrow]", 
        RowBox[{"2", "X"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k1", ",", "k2", ",", "km2"}], "}"}], ",", 
     RowBox[{"{", "x", "}"}], ",", "P"}], "]"}], ",", 
   RowBox[{"P", "[", "x", "]"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7305550532883997`*^9, 3.730555146491708*^9}, {
   3.730568382311954*^9, 3.730568428983921*^9}, {3.7305684946403*^9, 
   3.7305684980778055`*^9}, 
   3.730609891343292*^9},ExpressionUUID->"e8bb83b5-7436-4545-b986-\
2a91213b4506"],

Cell[BoxData[
 RowBox[{"StationaryProbabilityDistributionEquation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"X", "\[DoubleLeftRightArrow]", 
      RowBox[{"2", "X"}]}], ",", 
     RowBox[{"0", "\[DoubleLeftRightArrow]", "Y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k1", ",", "km1", ",", "k2", ",", "km2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "P"}], "]"}]], "Input",
 CellChangeTimes->{{3.730568236983547*^9, 3.7305683094211884`*^9}, {
   3.7305683504837694`*^9, 3.730568355202529*^9}, {3.7305684689215*^9, 
   3.730568482046525*^9}, {3.730568514218465*^9, 3.7305685403747673`*^9}, 
   3.730609893374405*^9},ExpressionUUID->"fc7ce800-ad23-48bf-9df9-\
6a221cf51387"],

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"StationaryProbabilityDistributionEquation", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"X", "\[DoubleLeftRightArrow]", 
        RowBox[{"2", "X"}]}], ",", 
       RowBox[{"0", "\[DoubleLeftRightArrow]", "Y"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k1", ",", "km1", ",", "k2", ",", "km2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "P"}], "]"}], ",", 
   RowBox[{"P", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7305550532883997`*^9, 3.730555146491708*^9}, {
   3.730568382311954*^9, 3.730568428983921*^9}, {3.7305685826248465`*^9, 
   3.730568588921734*^9}, 
   3.7306098949814997`*^9},ExpressionUUID->"7a075868-f52e-4aa1-a377-\
fb1fbd7d6eed"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 10.10", "Subsubsection",
 CellChangeTimes->{{3.714643905377195*^9, 3.7146439144397125`*^9}, {
  3.7292425189448357`*^9, 3.7292425333511133`*^9}, {3.730386698881101*^9, 
  3.73038670453736*^9}, {3.7303878681758227`*^9, 3.7303878690664487`*^9}, {
  3.7303883722707586`*^9, 3.7303883730051327`*^9}, {3.7303932803836937`*^9, 
  3.7303933093837504`*^9}, {3.7303937800877976`*^9, 3.730393780697173*^9}, {
  3.7303939631819086`*^9, 3.7303939639944057`*^9}, {3.7303943121357107`*^9, 
  3.730394312354463*^9}},ExpressionUUID->"58446146-194d-48ee-bd50-\
8471f6d8b8af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Propensity", "[", 
   RowBox[{"X_", ",", "alpha_", ",", "rates_"}], "]"}], ":=", 
  RowBox[{"rates", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Times", "@@", 
       RowBox[{"FactorialPower", "[", 
        RowBox[{"X", ",", "#"}], "]"}]}], "&"}], "/@", 
     RowBox[{"Transpose", "[", "alpha", "]"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.7303943226357336`*^9, 3.730394342276396*^9}, {
  3.730394380870222*^9, 
  3.7303943860264807`*^9}},ExpressionUUID->"1d14c46f-1f70-47cd-80bc-\
0354ab922320"],

Cell[BoxData[
 RowBox[{"FactorialPower", "[", 
  RowBox[{"3", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.7307804773821325`*^9, 
  3.7307804795071344`*^9}},ExpressionUUID->"200276b9-1504-47a7-a321-\
4389f83d2411"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"m", ",", "n"}], "]"}], ";", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m", ",", "n"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}], ";", 
  RowBox[{"Propensity", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"m", ",", "n"}], "}"}], ",", 
    RowBox[{
     RowBox[{"ReactionsData", "[", 
      RowBox[{
       RowBox[{"{", "\"\<Lotka-Volterra\>\"", "}"}], ",", 
       RowBox[{"ExternalSpecies", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}], "[", 
     "\"\<\[Alpha]\>\"", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"], ",", 
      SubscriptBox["k", "3"]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7303944051671443`*^9, 3.730394458026623*^9}, {
  3.730394510073596*^9, 3.7303945243392515`*^9}, {3.7307803730850525`*^9, 
  3.730780396506974*^9}, {3.7307804901165295`*^9, 
  3.730780520022842*^9}},ExpressionUUID->"b7d15364-442b-4323-af82-\
a73896c99b52"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DirectMethod", "[", 
   RowBox[{
   "X0_", ",", "alpha_", ",", "beta_", ",", "rates_", ",", "maxiter_", ",", 
    "maxtime_"}], "]"}], ":=", "\n", 
  RowBox[{"NestWhileList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", "+", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{"ExponentialDistribution", "[", "Lambda", "]"}], "]"}], ",", 
         RowBox[{"First", "[", 
          RowBox[{"RandomChoice", "[", 
           RowBox[{
            RowBox[{"lambdas", "\[Rule]", 
             RowBox[{"Transpose", "[", 
              RowBox[{"beta", "-", "alpha"}], "]"}]}], ",", "1"}], "]"}], 
          "]"}]}], "}"}]}], ")"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "X0"}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"First", "[", "#", "]"}], "\[LessEqual]", "maxtime"}], "&&", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Lambda", "=", 
          RowBox[{"Total", "[", 
           RowBox[{"lambdas", "=", 
            RowBox[{"Propensity", "[", 
             RowBox[{
              RowBox[{"Last", "[", "#", "]"}], ",", "alpha", ",", "rates"}], 
             "]"}]}], "]"}]}], ")"}], ">", "0"}]}], ")"}], "&"}], ",", "1", 
    ",", "maxiter"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.730394540964284*^9, 3.7303945552143126`*^9}, {
  3.7303946184175606`*^9, 3.730394632683214*^9}, {3.730568771172089*^9, 
  3.7305688216096883`*^9}, {3.730569354813857*^9, 
  3.73056935597011*^9}},ExpressionUUID->"2db25dad-ed60-4170-acec-\
4810ffc6c167"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "/@", 
    RowBox[{"DirectMethod", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", "0", "}"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", "1", "}"}], "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", "20", ",", "20"}], "]"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Thickness", "[", "0.02", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"20", ",", "20"}], "}"}]}], "}"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.73056880764091*^9, 3.730568904703601*^9}, {
  3.7305690118600626`*^9, 3.7305690754383106`*^9}, {3.7305692318604918`*^9, 
  3.7305692363605003`*^9}, {3.730569300829376*^9, 
  3.730569350110722*^9}},ExpressionUUID->"35ee8ad7-fafc-4b75-a89b-\
a8ae1315b1ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 10.13", "Subsubsection",
 CellChangeTimes->{{3.7303947548418784`*^9, 
  3.7303947688575296`*^9}},ExpressionUUID->"1c0e54c3-9c9d-47de-a630-\
4e5361076847"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MomentEquations", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"X", "\[DoubleLeftRightArrow]", 
      RowBox[{"2", "X"}]}], "}"}], ",", 
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"]}], "}"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.7303947899669485`*^9, 3.730394844842055*^9}, {
  3.7303949392953634`*^9, 
  3.7303949442172484`*^9}},ExpressionUUID->"af644612-1a38-414b-b84f-\
8755c7057c1f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MomentEquations", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"X", "\[DoubleLeftRightArrow]", 
      RowBox[{"2", "X"}]}], "}"}], ",", 
    RowBox[{"{", "2", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "1"], ",", 
      SubscriptBox["k", "2"]}], "}"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.7303947899669485`*^9, 3.730394844842055*^9}, {
  3.7303949392953634`*^9, 
  3.7303949442172484`*^9}},ExpressionUUID->"2b0d41d3-670d-41a1-ae37-\
0e96e9585140"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 10.15", "Subsubsection",
 CellChangeTimes->{{3.730395019029894*^9, 
  3.730395022608028*^9}},ExpressionUUID->"ac8838ab-f0c6-46d9-a27b-\
9beb6a6fc492"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ProbabilityGeneratingFunctionEquation", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"X", "\[DoubleLeftRightArrow]", "Y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "x", ",", "y"}], "}"}], ",", "G"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.730395037733057*^9, 3.7303951383270044`*^9}, {
  3.730395169764566*^9, 3.7303951728114448`*^9}, {3.7305694040483274`*^9, 
  3.730569406938958*^9}},ExpressionUUID->"92d4b160-fe3a-4a8b-92f1-\
7413ef48a50c"],

Cell["\<\
Let us verify that the given generating function solves the generating \
function equation\
\>", "Text",
 CellChangeTimes->{{3.7303953664993243`*^9, 
  3.730395387655615*^9}},ExpressionUUID->"9bd811e1-c0dd-476a-8dcb-\
5bb802c7150b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "[", 
   RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "2"}], "t"}], "]"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ")"}], 
      RowBox[{"Sinh", "[", 
       RowBox[{"2", "t"}], "]"}]}], "+", 
     RowBox[{"x", " ", "y", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"2", "t"}], "]"}]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.7303951882333584`*^9, 
  3.730395292077303*^9}},ExpressionUUID->"774a8181-0616-4474-9cdb-\
ca4d2b6ea5e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[CapitalGamma]", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "y"}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["\[CapitalGamma]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "x"}], "+", "y"}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["\[CapitalGamma]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], "}"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.7303953149523487`*^9, 
  3.7303953483117895`*^9}},ExpressionUUID->"532d8b6a-c509-498b-b2d6-\
4edbe279da68"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 10.16", "Subsubsection",
 CellChangeTimes->{{3.7308959713586283`*^9, 
  3.7308959791398926`*^9}},ExpressionUUID->"da19bc56-5434-41d1-8456-\
36d0088c56a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SolveCCSProbabilityGeneratingFunctionEquation", "[", 
   RowBox[{"alpha_", ",", "beta_", ",", "rratecoeffs_", ",", "init_"}], "]"}],
   ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"zb", ",", "bb", ",", "Ab"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"zb", "=", 
      RowBox[{"Array", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Subscript", "[", 
          RowBox[{"z", ",", "#"}], "]"}], "&"}], ",", 
        RowBox[{"Length", "[", "alpha", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"bb", ",", "Ab"}], "}"}], "=", 
      RowBox[{"CoefficientArrays", "[", 
       RowBox[{
        RowBox[{"alpha", ".", 
         RowBox[{"(", 
          RowBox[{"rratecoeffs", "*", 
           RowBox[{"MapThread", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Times", "@@", 
                 RowBox[{"(", 
                  RowBox[{"zb", "^", "#1"}], ")"}]}], "-", 
                RowBox[{"Times", "@@", 
                 RowBox[{"(", 
                  RowBox[{"zb", "^", "#2"}], ")"}]}]}], ")"}], "&"}], ",", 
             RowBox[{"Transpose", "/@", 
              RowBox[{"{", 
               RowBox[{"beta", ",", "alpha"}], "}"}]}]}], "]"}]}], ")"}]}], 
        ",", "zb"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Times", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"MatrixExp", "[", 
           RowBox[{"Ab", " ", "t"}], "]"}], ".", "zb"}], ")"}], "^", "init"}],
        ")"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7308960225931025`*^9, 
  3.7308960346066313`*^9}},ExpressionUUID->"315fcb5c-560f-49f4-96ca-\
327c75aca69b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SolveCCSProbabilityGeneratingFunctionEquation", "[", 
   RowBox[{
    RowBox[{"Sequence", "@@", 
     RowBox[{
      RowBox[{"ReactionsData", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<X\>\"", "\[Rule]", "\"\<Y\>\""}], "}"}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}]}], ",", 
    RowBox[{"{", "k1", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.7308960410029993`*^9, 3.7308960469963417`*^9}, {
  3.730896091242874*^9, 3.7308961271439304`*^9}, {3.7308961665371885`*^9, 
  3.730896168368291*^9}},ExpressionUUID->"eaf00a31-2a1e-4f2b-95d3-\
bfe8e8cf466c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SolveProbabilityGeneratingFunctionEquation", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", "\[Rule]", "\"\<Y\>\""}], "}"}], ",", 
    RowBox[{"{", "k1", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", "\"\<MatrixExponential\>\""}]}], "]"}], "//",
   "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.7308960410029993`*^9, 3.7308960469963417`*^9}, {
  3.730896091242874*^9, 
  3.730896162899979*^9}},ExpressionUUID->"079451fd-f962-4468-a11f-\
856d36c87bbf"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inverse", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
  3.7105102885467596`*^9, 3.710510289703012*^9}, {3.712582193257133*^9, 
  3.712582198174922*^9}},ExpressionUUID->"0f7f37a3-20d5-428f-9c0d-\
5a16c30f0a60"],

Cell[CellGroupData[{

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"30dead6c-d4ee-481f-8464-\
cb2c19f6921a"],

Cell[CellGroupData[{

Cell["Fig. 14.16", "Subsubsection",
 CellChangeTimes->{{3.728584997474168*^9, 3.728584998990254*^9}, 
   3.7286449523472786`*^9},ExpressionUUID->"5b53f197-ee53-4e1b-a26e-\
adfaa7b3d8f3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  SuperscriptBox[
   RowBox[{"Sin", "[", 
    RowBox[{"2", "\[Pi]", " ", "x"}], "]"}], "2"]}], "\n", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"ParametricNDSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "\[Equal]", 
        RowBox[{"d", " ", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", 
        RowBox[{"f", "[", "x", "]"}]}], ",", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "0"}], "]"}], "\[Equal]", 
        RowBox[{"f", "[", "0", "]"}]}], ",", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "1"}], "]"}], "\[Equal]", 
        RowBox[{"f", "[", "1", "]"}]}]}], "}"}], ",", "u", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "d", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "100", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "x", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"sol", "[", "0.0271", "]"}], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "+", 
        RowBox[{"RandomVariate", "[", 
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"0", ",", "0.07"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10", ",", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.1", ",", "0.9", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"nlm", "=", 
  RowBox[{
   RowBox[{"NonlinearModelFit", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"data", ",", "1"}], "]"}], ",", 
     RowBox[{
      RowBox[{"sol", "[", "d", "]"}], "[", 
      RowBox[{"t", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"d", ",", "0.01"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "x"}], "}"}]}], "]"}], "//", "Quiet"}]}]}], "Input",
 CellChangeTimes->{{3.703259384162733*^9, 3.703259389143346*^9}, {
   3.703259624166597*^9, 3.7032597344333153`*^9}, {3.703259770144014*^9, 
   3.7032597776233263`*^9}, {3.7032598409098*^9, 3.70325987268484*^9}, {
   3.70326082187952*^9, 3.703260822013878*^9}, {3.703260881052374*^9, 
   3.703260941388957*^9}, {3.7032609745534887`*^9, 3.7032610534224453`*^9}, 
   3.7287147844792056`*^9, {3.7302881058103085`*^9, 3.7302881074196873`*^9}, {
   3.7305224472319217`*^9, 3.7305224551538134`*^9}, {3.7305225990290947`*^9, 
   3.730522610372867*^9}},ExpressionUUID->"45c338ae-eb78-4847-b90c-\
792c200750a7"],

Cell[BoxData[
 RowBox[{"pdefit", "=", 
  RowBox[{"Show", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"nlm", "[", 
       RowBox[{"t", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "40"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"#", ",", "Bold", ",", "12"}], "]"}], "&"}], "/@", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Time\>\"", ",", " ", "\"\<Space\>\"", ",", 
           "\"\<Mass density \>\""}], "}"}]}], ")"}]}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"data", ",", "1"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{"nlm", "[", "\"\<BestFitParameters\>\"", "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7029970017243156`*^9, 3.702997018830935*^9}, {
   3.702998131934821*^9, 3.702998159484486*^9}, {3.702998280919437*^9, 
   3.7029984201896753`*^9}, 3.70325599936989*^9, {3.70326047215065*^9, 
   3.703260516792019*^9}, {3.7053759528433523`*^9, 3.705375953597396*^9}, {
   3.705375992622634*^9, 3.7053759964928527`*^9}, {3.705377732100031*^9, 
   3.7053777942251525`*^9}, {3.705377881444073*^9, 3.705377889069089*^9}, {
   3.7105654412485046`*^9, 3.710565489701727*^9}, {3.73052255663839*^9, 
   3.730522575997798*^9}},ExpressionUUID->"f29de295-6965-4205-8359-\
ee90626a5b74"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.16\>\"", ",", "pdefit"}], "]"}]], "Input",
 CellChangeTimes->{{3.7053760079685116`*^9, 3.7053760202022104`*^9}, {
  3.728585009001829*^9, 
  3.7285850167662745`*^9}},ExpressionUUID->"d15c278b-b2f7-4126-9b86-\
aed4ec06ede1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. 14.17", "Subsubsection",
 CellChangeTimes->{{3.7285851171730227`*^9, 3.7285851193951483`*^9}, 
   3.728644959816043*^9},ExpressionUUID->"66535452-1878-4377-bbbf-\
306b4a2eedb4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "predatorPrey", ",", "x0", ",", "data", ",", "nlm", ",", "predata", ",", 
    "preydata", ",", "indexedData", ",", "model", ",", "x", ",", "y", ",", 
    "\[Alpha]", ",", "\[Beta]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"predatorPrey", "=", 
   RowBox[{"ParametricNDSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], 
         RowBox[{"(", 
          RowBox[{"\[Alpha]", "-", 
           RowBox[{"\[Beta]", " ", 
            RowBox[{"y", "[", "t", "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"y", "[", "t", "]"}]}], 
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "-", 
           RowBox[{"\[Delta]", " ", 
            RowBox[{"x", "[", "t", "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "y0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "50"}], ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Delta]", ",", "x0",
        ",", "y0"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.606452925623268*^9, {3.606453484479418*^9, 3.60645348791354*^9}, {
   3.606458275434423*^9, 3.606458278104397*^9}, {3.6254017545723753`*^9, 
   3.625401757339534*^9}, 3.625660248207349*^9, 3.625660285397476*^9, 
   3.710565868422*^9, {3.710566069100505*^9, 3.710566119131854*^9}, {
   3.728585159896474*^9, 3.7285851704660754`*^9}, 3.7287148024011154`*^9, {
   3.730522762107541*^9, 
   3.730522765154419*^9}},ExpressionUUID->"2b27a4ad-2eae-49cc-a0c8-\
e4d4d245fd69"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "100", "]"}], ";", 
  RowBox[{"ClearAll", "[", 
   RowBox[{"error", ",", "data", ",", "predata", ",", "preydata"}], "]"}], 
  ";", 
  RowBox[{"error", "=", "0.05"}], ";", 
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prepend", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Through", "[", 
         RowBox[{
          RowBox[{"predatorPrey", "[", 
           RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "3"}], 
           "]"}], "[", "t", "]"}], "]"}], 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"error", " ", 
           RowBox[{"RandomReal", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}]}], ")"}]}], ",", 
       "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "20", ",", "0.2"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.625401835198987*^9, 3.625402089832552*^9}, {
   3.625402427150845*^9, 3.6254024515092382`*^9}, {3.625403978482576*^9, 
   3.6254040058711424`*^9}, {3.62540405791912*^9, 3.6254043425664005`*^9}, 
   3.6256574968072486`*^9, {3.625657642683322*^9, 3.625657643322358*^9}, {
   3.6256585167203135`*^9, 3.62565854340084*^9}, {3.6256599504383173`*^9, 
   3.625659957199704*^9}, {3.6256601701378837`*^9, 3.625660173601082*^9}, 
   3.7105660830692825`*^9, {3.7305452623102922`*^9, 3.7305452693571835`*^9}, {
   3.73054589932763*^9, 3.730545928780814*^9}, {3.7305463391566167`*^9, 
   3.7305463907817173`*^9}, 3.73054647387563*^9, {3.730546552422659*^9, 
   3.7305465545789127`*^9}, 
   3.7305466626416245`*^9},ExpressionUUID->"f9e907ff-3e24-44be-9245-\
99e62f9f38ce"],

Cell[BoxData[
 RowBox[{
  RowBox[{"predata", "=", 
   RowBox[{"Most", "/@", "data"}]}], ";", 
  RowBox[{"preydata", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"#", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", "data"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7105659566627855`*^9, 3.7105659659128036`*^9}, 
   3.7305228233732853`*^9},ExpressionUUID->"12c335c4-b1bf-4e38-b920-\
b83256fae059"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"predata", ",", "preydata"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "Red", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Darker", "@", 
        RowBox[{"Darker", "@", "Green"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<preadator\>\"", ",", "\"\<prey\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.606411884328767*^9, 3.606411972604891*^9}, {
  3.6064124943504877`*^9, 3.606412512256751*^9}, {3.606412866263331*^9, 
  3.6064128729896193`*^9}, {3.606413096054832*^9, 3.6064131033755417`*^9}, {
  3.606419356536392*^9, 3.606419361525119*^9}, {3.606452782219595*^9, 
  3.606452801799183*^9}, {3.7305462522189484`*^9, 
  3.7305462803596287`*^9}},ExpressionUUID->"073cb2c9-bb8e-4008-b4ed-\
106e8fee3f7d"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Rest", "/@", "data"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<prey\>\"", ",", "\"\<predator\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.730545322607286*^9},ExpressionUUID->"ad087d71-eee7-4dd3-b520-\
8ec958653144"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "indexedData", "]"}], ";", 
  RowBox[{"indexedData", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "i", "}"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"#", "\[LeftDoubleBracket]", 
              RowBox[{"i", "+", "1"}], "\[RightDoubleBracket]"}]}], "}"}], 
           "&"}], ",", "data"}], "]"}]}], "]"}], "/@", 
      RowBox[{"Range", "[", "2", "]"}]}], ",", "1"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.606416550149086*^9, 3.60641670487827*^9}, {
   3.606461852056641*^9, 3.6064618613933268`*^9}, 3.6256600901453085`*^9, 
   3.7105659779128275`*^9, 3.7285851863009853`*^9, {3.7305464289692907`*^9, 
   3.7305464405161896`*^9}},ExpressionUUID->"65c78251-f798-48a2-8c92-\
3ced8c493b0c"],

Cell[BoxData[
 RowBox[{"ListPlot3D", "@", "indexedData"}]], "Input",
 CellChangeTimes->{{3.7305233627024655`*^9, 
  3.7305233768899918`*^9}},ExpressionUUID->"b1797e03-4723-4dbe-a256-\
7a81c529e118"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "model", "]"}], ";", 
  RowBox[{
   RowBox[{
    RowBox[{"model", "[", 
     RowBox[{
      RowBox[{"\[Alpha]_", "?", "NumericQ"}], ",", 
      RowBox[{"\[Beta]_", "?", "NumericQ"}], ",", 
      RowBox[{"\[Gamma]_", "?", "NumericQ"}], ",", 
      RowBox[{"\[Delta]_", "?", "NumericQ"}], ",", 
      RowBox[{"x0_", "?", "NumericQ"}], ",", 
      RowBox[{"y0_", "?", "NumericQ"}]}], "]"}], "[", 
    RowBox[{
     RowBox[{"i_", "?", "NumericQ"}], ",", 
     RowBox[{"t_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{"Part", "[", 
    RowBox[{
     RowBox[{"Through", "[", 
      RowBox[{
       RowBox[{"predatorPrey", "[", 
        RowBox[{
        "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Delta]", ",", 
         "x0", ",", "y0"}], "]"}], "[", "t", "]"}], "]"}], ",", "i"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.606413267472252*^9, 3.606413297452489*^9}, {
   3.606415245381559*^9, 3.606415260926138*^9}, {3.606415306807961*^9, 
   3.606415364401084*^9}, {3.6064154137860737`*^9, 3.606415535749516*^9}, {
   3.60641561349512*^9, 3.606415626704464*^9}, {3.606415721029229*^9, 
   3.606415758881249*^9}, {3.606415838791881*^9, 3.6064158389063168`*^9}, {
   3.60641617868883*^9, 3.606416196466015*^9}, {3.606416722150957*^9, 
   3.606416724105995*^9}, {3.60641726349702*^9, 3.606417314528941*^9}, {
   3.6064621396002893`*^9, 3.606462139717496*^9}, 3.6256594853807178`*^9, {
   3.7105661128818417`*^9, 3.7105661142880945`*^9}, {3.7305233871087604`*^9, 
   3.7305233964681563`*^9}},ExpressionUUID->"33cb1993-87ea-47bb-b4e0-\
8b2ee6295fb3"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"model", "[", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "3"}], 
        "]"}], "[", 
       RowBox[{"#", ",", "t"}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Darker", "@", 
       RowBox[{"Darker", "@", "Green"}]}]}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Predator\>\"", ",", "\"\<Prey\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.730523439561989*^9, 3.730523451202636*^9}, {
  3.7305454086387033`*^9, 
  3.730545444576275*^9}},ExpressionUUID->"7e90ab84-f559-44a1-9871-\
5e5b8a353d16"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "nlm", ",", "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Delta]", 
    ",", "x0", ",", "y0", ",", "i"}], "]"}], ";", 
  RowBox[{"nlm", "=", 
   RowBox[{
    RowBox[{"NonlinearModelFit", "[", 
     RowBox[{"indexedData", ",", 
      RowBox[{
       RowBox[{"model", "[", 
        RowBox[{
        "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Delta]", ",", 
         "x0", ",", "y0"}], "]"}], "[", 
       RowBox[{"i", ",", "t"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", "1.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Beta]", ",", "1.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Gamma]", ",", "1.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Delta]", ",", "1.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x0", ",", "2.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y0", ",", "3.5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "t"}], "}"}], ",", 
      RowBox[{"PrecisionGoal", "\[Rule]", "4"}], ",", 
      RowBox[{"AccuracyGoal", "\[Rule]", "4"}]}], "]"}], "//", 
    "Quiet"}]}]}]], "Input",
 CellChangeTimes->{{3.606415883633232*^9, 3.606415948533102*^9}, {
   3.6064162051383533`*^9, 3.60641620744807*^9}, {3.606416752167*^9, 
   3.606416783293447*^9}, {3.606416957621545*^9, 3.606416964743733*^9}, {
   3.6064171948818293`*^9, 3.6064172009644947`*^9}, {3.606417286017577*^9, 
   3.6064172894242487`*^9}, {3.606417544206238*^9, 3.606417628846737*^9}, {
   3.60641766059615*^9, 3.6064177284464073`*^9}, {3.6064198621189947`*^9, 
   3.6064199669993563`*^9}, {3.606420248864717*^9, 3.606420328491152*^9}, {
   3.606461954200822*^9, 3.606461956142454*^9}, {3.625659562299117*^9, 
   3.6256596054315844`*^9}, {3.625659805325018*^9, 3.6256598142585287`*^9}, {
   3.625659846715385*^9, 3.6256598853445945`*^9}, {3.625660487561039*^9, 
   3.6256605036379585`*^9}, {3.6256606145973053`*^9, 
   3.6256606785699644`*^9}, {3.625660750547081*^9, 3.625660842786357*^9}, {
   3.7105660210066624`*^9, 3.710566023600417*^9}, 3.7105661238349876`*^9, {
   3.7285852205659475`*^9, 3.7285852633209953`*^9}, {3.728585299961692*^9, 
   3.728585338821142*^9}, {3.7305230776081553`*^9, 3.7305230787644067`*^9}, {
   3.7305235164371395`*^9, 
   3.730523522577776*^9}},ExpressionUUID->"8d9412f1-2b8c-40fc-b457-\
e27f2558909e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "fit", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fit", "[", 
    RowBox[{"i_", ",", "t_"}], "]"}], "=", 
   RowBox[{"nlm", "[", "\"\<BestFit\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"nlm", "[", "\"\<BestFitParameters\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"nlm", "[", "\"\<ParameterTable\>\"", "]"}]}], "Input",
 CellChangeTimes->{{3.7305235859997807`*^9, 3.730523689687479*^9}, {
  3.7305457441393585`*^9, 3.730545771576913*^9}, {3.7305458291239004`*^9, 
  3.730545837327042*^9}},ExpressionUUID->"6f52a444-423b-44f2-a2b8-\
508e0bd968c0"],

Cell[BoxData[
 RowBox[{"plfit", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"fit", "[", 
       RowBox[{"1", ",", "t"}], "]"}], ",", 
      RowBox[{"fit", "[", 
       RowBox[{"2", ",", "t"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "Red", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Darker", "@", 
         RowBox[{"Darker", "@", "Blue"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
       RowBox[{"Point", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Drop", "[", 
           RowBox[{"#", ",", 
            RowBox[{"{", "3", "}"}]}], "]"}], "&"}], "/@", "data"}], "]"}], 
       ",", 
       RowBox[{"Darker", "@", 
        RowBox[{"Darker", "@", "Blue"}]}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Drop", "[", 
           RowBox[{"#", ",", 
            RowBox[{"{", "2", "}"}]}], "]"}], "&"}], "/@", "data"}], "]"}]}], 
      "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQA2IQXeBc4rjx3itHHf6JniA6JXdJJoieHvYOTAtEsK4D
0a+TX24E0Zsebz4OoleemX4CRH8yj3kKolXuyj0D0f/6D3wA0UWTdT+C6IaZ
bIKbgHSFxGxpEL1SeLI8iP7hwacBos+dO2y0GUjv+nXfHkQfXi2dDKJbtvPn
gmilXLcDx4H0n74WMB03yXNqKvNrx67za2eB6J60VZtB9D3XE1tAdP6TaztA
9Gu21XtBNMeXjxxpQFoj6wsXiFaQvSwBotVsLymA6A2NFzVB9DXNSFMQfTfr
SlEWkOY7Vl8Lom8cXdoNol/Gnp4Iog0bNE9knH7tWN/QcwpEm33yzS8G0geK
qopBdEx59XQQXfJdZgaIBgCx4sDp
  "],ExpressionUUID->"41cda3bd-de41-4acb-9cd8-4c1055f71ccb"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.17A\>\"", ",", "plfit"}], "]"}]], "Input",
 CellChangeTimes->{{3.710565694058014*^9, 3.7105657052396545`*^9}, {
  3.7285851280516453`*^9, 
  3.7285851344440117`*^9}},ExpressionUUID->"31eb18da-e979-42ad-8882-\
2e7146c3a6b0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "ppfit", "]"}], ";", 
  RowBox[{"ppfit", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fit", "[", 
        RowBox[{"1", ",", "t"}], "]"}], ",", 
       RowBox[{"fit", "[", 
        RowBox[{"2", ",", "t"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"Rest", "/@", "data"}], "]"}]}], "}"}]}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6256699133431635`*^9, 3.6256699137841883`*^9}, {
  3.730523748281342*^9, 3.730523753937606*^9}, {3.7305455781702847`*^9, 
  3.7305455835296707`*^9}, {3.730545865639597*^9, 3.7305458704521055`*^9}, {
  3.7305465240476055`*^9, 
  3.730546538110131*^9}},ExpressionUUID->"168a52b3-e4f4-4b9c-b796-\
ffeb728be5cf"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.17B\>\"", ",", "ppfit"}], "]"}]], "Input",
 CellChangeTimes->{{3.710565718465411*^9, 3.7105657189184375`*^9}, {
  3.728585139010275*^9, 
  3.7285851422764626`*^9}},ExpressionUUID->"adc8aecf-73f7-4f3a-b466-\
7f10bd62b546"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"9368458e-1bd7-43c9-94e0-\
5bc34e33b8bd"],

Cell[CellGroupData[{

Cell["Solution 11.2", "Subsubsection",
 CellChangeTimes->{{3.712582228380831*^9, 3.712582229595292*^9}, {
  3.730288323748234*^9, 
  3.730288330857624*^9}},ExpressionUUID->"3f1c7eba-a40c-46dd-96ae-\
4e74bddff088"],

Cell[BoxData[
 RowBox[{"fm", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"FindMinimum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "0.1"}], "p"}], "]"}], 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{"Sin", "[", "p", "]"}]}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", "200", "]"}]}], "//", "Quiet"}]}]], "Input",
 CellChangeTimes->{{3.7125822308340545`*^9, 3.712582267648766*^9}, {
  3.7302884061897645`*^9, 
  3.7302884073238325`*^9}},ExpressionUUID->"37fd5ee6-b635-4177-a1a5-\
ab8b16e0e8f5"],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "10"}], "p"}], "]"}], 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"Sin", "[", "p", "]"}]}], ")"}]}], ",", 
      RowBox[{"{", "p", "}"}]}], "]"}], "\[Equal]", "0"}], ",", "p"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7305468820951805`*^9, 
  3.7305469396421657`*^9}},ExpressionUUID->"61983b02-f9f6-4a17-9068-\
a1be5b203b2e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Union", "[", 
   RowBox[{
    RowBox[{"p", "/.", 
     RowBox[{"(", 
      RowBox[{"Last", "/@", "fm"}], ")"}]}], ",", 
    RowBox[{"SameTest", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"#1", "-", "#2"}], "]"}], "<", "0.0001"}], "&"}], ")"}]}]}], 
   "]"}], "//", "Length"}]], "Input",
 CellChangeTimes->{{3.730288471893527*^9, 
  3.730288621870116*^9}},ExpressionUUID->"5fc16306-0157-4add-9e56-\
1c6fcc5b1eca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Union", "[", 
   RowBox[{
    RowBox[{"p", "/.", 
     RowBox[{"(", 
      RowBox[{"Last", "/@", "fm"}], ")"}]}], ",", 
    RowBox[{"SameTest", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"#1", "-", "#2"}], "]"}], "<", "0.0001"}], "&"}], ")"}]}]}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{
  3.730546878360797*^9},ExpressionUUID->"29f11e03-13fd-44da-99a7-\
ba8afcd9f3ef"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "0.1"}], "p"}], "]"}], 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"Sin", "[", "p", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"-", "1.5"}], ",", "2700"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712582286141982*^9, 3.712582326735918*^9}, {
  3.7302887097410517`*^9, 3.7302887343504734`*^9}, {3.7302887941318417`*^9, 
  3.7302887963974695`*^9}},ExpressionUUID->"3b9e2a89-eaf5-4415-84ea-\
fb6d885c7ace"],

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", " ", 
    RowBox[{"First", "@", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "0.1"}], "p"}], "]"}], 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{"Sin", "[", "p", "]"}]}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", 
         RowBox[{"-", "1.5"}], ",", "40"}], "}"}]}], "]"}]}]}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7305474110024643`*^9, 3.7305474170649796`*^9}, {
  3.7305474517525425`*^9, 
  3.730547509315154*^9}},ExpressionUUID->"4b7266fc-c14a-4d25-9183-\
d1f154a6f377"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "0.1"}], "p"}], "]"}], 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"Sin", "[", "p", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"-", "15"}], ",", "27"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712582286141982*^9, 3.712582326735918*^9}, {
  3.7302887097410517`*^9, 3.7302887343504734`*^9}, {3.7302887941318417`*^9, 
  3.7302888056006117`*^9}, {3.730547004689169*^9, 3.7305470387517357`*^9}, {
  3.730547099564355*^9, 3.730547313080394*^9}, {3.7305473616586137`*^9, 
  3.7305473968149357`*^9}, {3.7305475325652003`*^9, 
  3.730547562393384*^9}},ExpressionUUID->"8adf3f2f-a99c-444d-9094-\
9e32665c89d1"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "0.1"}], "p"}], "]"}], 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"Sin", "[", "p", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"-", "1.5"}], ",", "40"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.712582286141982*^9, 3.712582326735918*^9}, 
   3.730288705022292*^9, {3.730288748334875*^9, 
   3.73028875020988*^9}},ExpressionUUID->"596ee434-d514-4172-9469-\
263eda4cc6a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 11.3", "Subsubsection",
 CellChangeTimes->{{3.712582228380831*^9, 3.712582229595292*^9}, {
  3.730288323748234*^9, 3.730288330857624*^9}, {3.730289065632372*^9, 
  3.730289066038622*^9}},ExpressionUUID->"44a333ab-f304-421c-ba0b-\
0e68d773d19e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"kk", ",", "mm", ",", "times"}], "]"}], ";", 
  RowBox[{"kk", "=", "0.01"}], ";", 
  RowBox[{"mm", "=", "2.5"}], ";", 
  RowBox[{"times", "=", 
   RowBox[{"N", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "100"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.712582400786479*^9, 3.712582409035488*^9}, 
   3.7125824396459727`*^9, 3.7125828106428227`*^9, {3.730547614299736*^9, 
   3.7305476226435013`*^9}, 
   3.7307816545719337`*^9},ExpressionUUID->"2167e43a-dcca-4f30-99e7-\
9c080393edcf"],

Cell["\<\
An 5% relative, normally distributed error is quite acceptable with \
experimentalists.\
\>", "Text",
 CellChangeTimes->{{3.730289262367132*^9, 3.7302892897421837`*^9}, {
  3.7305475937215695`*^9, 
  3.730547601455964*^9}},ExpressionUUID->"b1c44d3b-867f-46c1-9fb0-\
cd79f6e14e9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"data", ",", "nlm"}], "]"}], ";", 
  RowBox[{"SeedRandom", "[", "37", "]"}], ";", 
  RowBox[{"data", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"mm", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "kk"}], " ", "#"}], "]"}], 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"0.05", 
           RowBox[{"RandomVariate", "[", 
            RowBox[{"NormalDistribution", "[", "]"}], "]"}]}]}], ")"}]}]}], 
      "}"}], "&"}], " ", "/@", "times"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.712582400786479*^9, 3.712582475877926*^9}, 
   3.712582813157712*^9, {3.7302892309451942`*^9, 3.73028925457024*^9}, {
   3.7305476299247665`*^9, 3.7305476486123023`*^9}, {3.7307815751655283`*^9, 
   3.7307815832124195`*^9}, {3.730781629478137*^9, 
   3.7307816591188188`*^9}},ExpressionUUID->"a66056ac-5ed5-4ba0-a39e-\
6b7f8f818204"],

Cell[BoxData[
 RowBox[{"nlm", "=", 
  RowBox[{"NonlinearModelFit", "[", 
   RowBox[{"data", ",", 
    RowBox[{"\[Mu]", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "\[Kappa]"}], " ", "t"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", "\[Kappa]"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.712582400786479*^9, 3.7125825076733336`*^9}, 
   3.712582544474712*^9, {3.712582596479619*^9, 
   3.712582607835494*^9}},ExpressionUUID->"556ddf0b-0f2f-484e-b3cf-\
c26d69a576b4"],

Cell[BoxData[
 RowBox[{"nlm", "[", "\"\<BestFitParameters\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.712582400786479*^9, 3.7125825076733336`*^9}, {
  3.712582616572693*^9, 
  3.712582620336026*^9}},ExpressionUUID->"67f8c47a-3310-4c85-99cc-\
3c7f5aab8bd3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"f", ",", "logdata", ",", "lm"}], "]"}], ";", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "x_"}], "}"}], "]"}], ":=", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"Log", "[", "x", "]"}]}], "}"}]}], ";", 
  RowBox[{"logdata", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"f", ",", "data"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.712582400786479*^9, 3.7125825076733336`*^9}, {
   3.712582616572693*^9, 3.712582676552459*^9}, 3.730289409742418*^9, {
   3.7305476857217493`*^9, 
   3.730547701299905*^9}},ExpressionUUID->"df66d185-445b-4ebc-bbfb-\
be654f0bebbf"],

Cell[BoxData[
 RowBox[{"lm", "=", 
  RowBox[{"LinearModelFit", "[", 
   RowBox[{"logdata", ",", "t", ",", "t"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.712582400786479*^9, 3.7125825076733336`*^9}, {
   3.712582616572693*^9, 3.7125826931443205`*^9}, 
   3.7307817211501904`*^9},ExpressionUUID->"686204dc-f749-49f7-a88b-\
e511112d3504"],

Cell[BoxData[
 RowBox[{"lm", "[", "\"\<BestFitParameters\>\"", "]"}]], "Input",ExpressionUUI\
D->"df71731a-3c0e-418a-95df-b78573ffb89c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", "0.908942", "]"}], "\[Equal]", "2.47389"}]], "Input",
 CellChangeTimes->{{3.7307828653562403`*^9, 
  3.7307828886375327`*^9}},ExpressionUUID->"72ef3df5-a3f5-44a7-85f1-\
17287df6919e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 11.4", "Subsubsection",
 CellChangeTimes->{{3.712582228380831*^9, 3.712582229595292*^9}, {
  3.730288323748234*^9, 3.730288330857624*^9}, {3.730289065632372*^9, 
  3.730289066038622*^9}, {3.7302896833210793`*^9, 
  3.7302896837117043`*^9}},ExpressionUUID->"55d5e326-6789-4107-9383-\
72aa7c855970"],

Cell["See the calculations to Fig. 14.16.", "Text",
 CellChangeTimes->{{3.730289707852377*^9, 
  3.7302897162586403`*^9}},ExpressionUUID->"ec91979e-1cce-4cfe-87b4-\
3343c67c6271"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 11.5", "Subsubsection",
 CellChangeTimes->{{3.712582228380831*^9, 3.712582229595292*^9}, {
  3.730288323748234*^9, 3.730288330857624*^9}, {3.730289065632372*^9, 
  3.730289066038622*^9}, {3.7302896833210793`*^9, 3.7302896837117043`*^9}, {
  3.7302897373368096`*^9, 
  3.730289737602435*^9}},ExpressionUUID->"eece80e9-b6a8-4ef1-96af-\
7db8c067f8f3"],

Cell["See the calculations to Fig. 14.17.", "Text",
 CellChangeTimes->{{3.730289707852377*^9, 3.7302897162586403`*^9}, {
  3.7302897469149528`*^9, 
  3.730289747664954*^9}},ExpressionUUID->"92b22b7c-958f-4816-987f-\
a0fc46eca25a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 11.7", "Subsubsection",
 CellChangeTimes->{{3.712582228380831*^9, 3.712582229595292*^9}, {
  3.730288323748234*^9, 3.730288330857624*^9}, {3.730289065632372*^9, 
  3.730289066038622*^9}, {3.7302901758220387`*^9, 
  3.7302901759470425`*^9}},ExpressionUUID->"19133c42-92c2-4961-9808-\
ef2ef2ce03b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"ReplaceAll", "@@", 
     RowBox[{"Concentrations", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"X", " ", "\[Rule]", " ", "Y"}], ",", " ", 
         RowBox[{"X", " ", "\[Rule]", " ", "Z"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["k", "1"], ",", 
         SubscriptBox["k", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "0"], ",", 
         SubscriptBox["y", "0"], ",", 
         SubscriptBox["z", "0"]}], "}"}], ",", "t"}], "]"}]}], ")"}], 
   "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.712584119735933*^9, 3.712584190144811*^9}, {
  3.7302898422588906`*^9, 3.730289861133926*^9}, {3.7302898995090036`*^9, 
  3.7302899316028137`*^9}},ExpressionUUID->"42230983-5008-4248-b33f-\
6543f3e6c6fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 11.8", "Subsubsection",
 CellChangeTimes->{{3.712582228380831*^9, 3.712582229595292*^9}, {
  3.730288323748234*^9, 3.730288330857624*^9}, {3.730289065632372*^9, 
  3.730289066038622*^9}, {3.7302901758220387`*^9, 
  3.730290204822099*^9}},ExpressionUUID->"b7afae56-4a22-4b25-b907-\
28ac1234d8d1"],

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"ff", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"aa", ",", "gg"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"zz", ",", "uu"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.730290372765554*^9, 
  3.7302903993906064`*^9}},ExpressionUUID->"c5e02304-2427-4d02-85e7-\
3cccd815afeb"],

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"First", "@", 
     RowBox[{"DeterministicModel", "[", 
      RowBox[{"#1", ",", "#2", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "X"}], "\[DoubleLeftRightArrow]", 
         RowBox[{"X", "+", "Y"}], "\[DoubleLeftRightArrow]", 
         RowBox[{"2", "Y"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"X", "+", "Y"}], "\[DoubleLeftRightArrow]", 
         RowBox[{"2", "X"}], "\[DoubleLeftRightArrow]", 
         RowBox[{"2", "Y"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "3", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7302902100877357`*^9, 3.730290370187425*^9}, {
  3.7302904209218993`*^9, 3.730290492062663*^9}, {3.730290548437774*^9, 
  3.730290548875274*^9}},ExpressionUUID->"ae4b0ae4-529b-43c6-88f1-\
433f56f6bf05"],

Cell[BoxData[
 RowBox[{"Equal", "@@", "%"}]], "Input",
 CellChangeTimes->{{3.7305478570345864`*^9, 
  3.7305478610814676`*^9}},ExpressionUUID->"3b281ee9-3e06-4142-ba92-\
8e8f6e4ec221"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 11.9", "Subsubsection",
 CellChangeTimes->{{3.712582228380831*^9, 3.712582229595292*^9}, {
  3.730288323748234*^9, 3.730288330857624*^9}, {3.730289065632372*^9, 
  3.730289066038622*^9}, {3.7302901758220387`*^9, 3.7302901759470425`*^9}, {
  3.730290584500344*^9, 
  3.730290585406596*^9}},ExpressionUUID->"7027a3bc-da7a-470a-bd56-\
a398480c1700"],

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"First", "@", 
     RowBox[{"DeterministicModel", "[", 
      RowBox[{"#1", ",", "#2", ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "1"], ",", 
         SubscriptBox["x", "2"]}], "}"}]}], "]"}]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"3", 
            SubscriptBox["X", "1"]}], "+", 
           SubscriptBox["X", "2"]}], "\[DoubleLeftRightArrow]", 
          RowBox[{"2", 
           SubscriptBox["X", "2"]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"2", 
            SubscriptBox["X", "1"]}], "+", 
           SubscriptBox["X", "2"]}], "\[DoubleLeftRightArrow]", " ", 
          SubscriptBox["X", "1"]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["X", "1"], "\[DoubleLeftRightArrow]", 
           RowBox[{
            RowBox[{"2", 
             SubscriptBox["X", "1"]}], "+", 
            SubscriptBox["X", "2"]}]}], "\[Rule]", " ", 
          RowBox[{"2", 
           SubscriptBox["X", "2"]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"2", 
            SubscriptBox["X", "1"]}], "+", 
           SubscriptBox["X", "2"]}], "\[Rule]", 
          RowBox[{
           RowBox[{"3", 
            SubscriptBox["X", "1"]}], "+", 
           SubscriptBox["X", "2"]}]}], ",", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["X", "2"]}], "\[DoubleLeftRightArrow]", " ", 
          RowBox[{
           RowBox[{"3", 
            SubscriptBox["X", "1"]}], "+", 
           SubscriptBox["X", "2"]}]}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "1", ",", "3", ",", "3", ",", "2"}], 
        "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7302902100877357`*^9, 3.730290370187425*^9}, {
  3.7302904209218993`*^9, 3.730290492062663*^9}, {3.730290548437774*^9, 
  3.730290548875274*^9}, {3.7302906112503953`*^9, 3.7302907942820044`*^9}, {
  3.73029082995395*^9, 3.730290888219688*^9}, {3.730290989407386*^9, 
  3.73029114568894*^9}, {3.730291188579651*^9, 3.7302914714552026`*^9}, {
  3.730291567721019*^9, 3.7302915685491433`*^9}, {3.7302921744097023`*^9, 
  3.730292219441042*^9}, {3.7302923759569716`*^9, 3.730292377894477*^9}, {
  3.73029266130128*^9, 3.7302926695669217`*^9}, {3.7302927138170075`*^9, 
  3.7302927146920104`*^9}, {3.730293668874055*^9, 
  3.7302936716553116`*^9}},ExpressionUUID->"332a6257-69b4-4b23-b173-\
3d438717ab6f"],

Cell[BoxData[
 RowBox[{"Equal", "@@", "%"}]], "Input",
 CellChangeTimes->{{3.7302936830772123`*^9, 
  3.730293687905343*^9}},ExpressionUUID->"696d9209-7ab7-4cbd-a576-\
d14bfd2573b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 11.10", "Subsubsection",
 CellChangeTimes->{{3.712582228380831*^9, 3.712582229595292*^9}, {
  3.730288323748234*^9, 3.730288330857624*^9}, {3.730289065632372*^9, 
  3.730289066038622*^9}, {3.7302901758220387`*^9, 3.7302901759470425`*^9}, {
  3.7302930552294135`*^9, 
  3.7302930561584673`*^9}},ExpressionUUID->"22103abc-d98e-4e18-81cd-\
284c8c66fa63"],

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"RightHandSide", "[", 
     RowBox[{"#1", ",", "#2", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["A", "1"]}], "\[Rule]", 
          SubscriptBox["A", "2"]}], ",", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["A", "1"]}], "\[Rule]", " ", 
          RowBox[{
           RowBox[{"2", 
            SubscriptBox["A", "1"]}], "+", 
           SubscriptBox["A", "2"]}]}], ",", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["A", "1"]}], "\[Rule]", " ", 
          RowBox[{"3", 
           SubscriptBox["A", "1"]}]}], ",", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["A", "1"]}], "\[Rule]", " ", 
          RowBox[{
           SubscriptBox["A", "1"], "+", 
           SubscriptBox["A", "2"]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["A", "1"]}], "\[Rule]", 
          SubscriptBox["A", "2"]}], ",", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["A", "1"]}], "\[Rule]", " ", 
          RowBox[{
           RowBox[{"2", 
            SubscriptBox["A", "1"]}], "+", 
           SubscriptBox["A", "2"]}]}], ",", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["A", "1"]}], "\[Rule]", " ", 
          RowBox[{"3", 
           SubscriptBox["A", "1"]}]}], ",", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["A", "1"]}], "\[Rule]", " ", 
          RowBox[{
           SubscriptBox["A", "1"], "+", 
           SubscriptBox["A", "2"]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           SubscriptBox["A", "1"], "+", 
           SubscriptBox["A", "2"]}], "\[Rule]", " ", 
          RowBox[{
           RowBox[{"2", 
            SubscriptBox["A", "1"]}], "+", 
           SubscriptBox["A", "2"]}]}], ",", 
         RowBox[{
          RowBox[{
           SubscriptBox["A", "1"], "+", 
           SubscriptBox["A", "2"]}], "\[Rule]", " ", 
          SubscriptBox["A", "2"]}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Array", "[", 
        RowBox[{
         RowBox[{"1", "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"19", "/", "10"}], ",", 
         RowBox[{"1", "/", "10"}], ",", "\[IndentingNewLine]", 
         RowBox[{"1", "/", "10"}], ",", 
         RowBox[{"1", "/", "10"}], ",", 
         RowBox[{"1", "/", "10"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7302902100877357`*^9, 3.730290370187425*^9}, {
  3.7302904209218993`*^9, 3.730290492062663*^9}, {3.730290548437774*^9, 
  3.730290548875274*^9}, {3.7302906112503953`*^9, 3.7302907942820044`*^9}, {
  3.73029082995395*^9, 3.730290888219688*^9}, {3.730290989407386*^9, 
  3.73029114568894*^9}, {3.7302931986543865`*^9, 
  3.7302932339044557`*^9}},ExpressionUUID->"2e510475-bd52-4f83-8a8e-\
8673a4093ddf"],

Cell[BoxData[
 RowBox[{"DeterministicModel", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "Y"}], " ", "\[LeftArrow]", 
      RowBox[{"X", "+", "Y"}]}], "\[Rule]", " ", 
     RowBox[{"2", "X"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7302930825589786`*^9, 
  3.730293127091749*^9}},ExpressionUUID->"6fa344bf-8612-4406-b764-\
198108cfa706"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 11.11", "Subsubsection",
 CellChangeTimes->{{3.712582228380831*^9, 3.712582229595292*^9}, {
  3.730288323748234*^9, 3.730288330857624*^9}, {3.730289065632372*^9, 
  3.730289066038622*^9}, {3.7302901758220387`*^9, 3.7302901759470425`*^9}, {
  3.7302930552294135`*^9, 3.7302930561584673`*^9}, {3.7302932791545424`*^9, 
  3.730293279779545*^9}},ExpressionUUID->"10efb11e-426e-4301-bc3d-\
b994735726a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"origr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"X", "+", "Y"}], "\[DoubleLeftRightArrow]", 
       RowBox[{"X", "+", 
        RowBox[{"2", "Y"}]}], "\[DoubleLeftRightArrow]", 
       RowBox[{
        RowBox[{"2", "X"}], "+", 
        RowBox[{"3", "Y"}]}]}], "\[Rule]", " ", 
      RowBox[{
       RowBox[{"2", "Y"}], "\[LeftArrow]", 
       RowBox[{"X", "+", "Y"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", "Y"}], "\[DoubleLeftRightArrow]", 
      RowBox[{"X", "+", 
       RowBox[{"2", "Y"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.7053160010934486`*^9},ExpressionUUID->"1293accb-7c00-4050-95f9-\
c69d6521d8be"],

Cell[BoxData[
 RowBox[{"orig", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"origr", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"#", ",", "Bold", ",", "16"}], "]"}], "&"}], "/@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(2\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(5\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(4\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(8\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(3\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(7\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(k\), \(6\)]\)\>\""}], "}"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(1\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(2\)]\)\>\"", "\[Rule]", " ", 
          "\"\<11/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(5\)]\)\>\"", "\[Rule]", " ", 
          "\"\<11/10\>\""}], ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(4\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(8\)]\)\>\"", "\[Rule]", " ", "1"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(3\)]\)\>\"", "\[Rule]", "1"}], " ", 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(7\)]\)\>\"", "\[Rule]", " ", "3"}], 
         ",", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(k\), \(6\)]\)\>\"", "\[Rule]", " ", 
          "\"\<1/10\>\""}]}], "}"}]}], ")"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "1300"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7053003944762497`*^9, 3.7053003992575045`*^9}, {
   3.7053005750855665`*^9, 3.7053005950387297`*^9}, {3.7053006263512917`*^9, 
   3.7053007023045645`*^9}, {3.7053009556019354`*^9, 
   3.7053010269770746`*^9}, {3.705312859778368*^9, 3.7053128884659233`*^9}, {
   3.7053129501847954`*^9, 3.7053129899817467`*^9}, {3.70531303996622*^9, 
   3.7053130442318525`*^9}, {3.7053130954038277`*^9, 
   3.7053131285601425`*^9}, {3.7053155489363146`*^9, 3.705315564592595*^9}, {
   3.705315704030368*^9, 3.705315729842918*^9}, {3.7053159422027082`*^9, 
   3.7053159627496223`*^9}, 3.705316005421581*^9, 
   3.7105891612572966`*^9},ExpressionUUID->"7eb8ded4-6cf3-42c1-873f-\
c188b10e78df"],

Cell[BoxData[
 RowBox[{"DeterministicModel", "[", 
  RowBox[{"origr", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"11", "/", "10"}], ",", 
     RowBox[{"11", "/", "10"}], ",", "1", ",", "1", ",", "1", ",", "3", ",", 
     RowBox[{"1", "/", "10"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7302935525457034`*^9, 3.7302935780613785`*^9}, {
  3.730548107653339*^9, 
  3.7305481587912683`*^9}},ExpressionUUID->"1deefdc7-5563-4b00-9953-\
4c87e253c335"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Programs", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
  3.710510299187405*^9, 
  3.7105103004374065`*^9}},ExpressionUUID->"4b578b80-4865-496c-8d9f-\
789b54ffd436"],

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"6786efb9-598b-4ac0-867c-\
679b1dad30cd"],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"b06cd949-103b-4350-a308-\
398b5b89ca06"],

Cell[TextData[{
 "Let us mention here the function ",
 Cell[BoxData[
  RowBox[{"CHEMKINImport", "[", "]"}]], "Input",ExpressionUUID->
  "c8fe98e5-a5fa-411b-b266-6ffc5c22c744"],
 " through which the communication with data files produced by the progam \
CHEMKIN becomes possible. Find a data file and use it."
}], "Text",
 CellChangeTimes->{{3.7302874716684437`*^9, 3.7302875784342794`*^9}, 
   3.730520355027051*^9},ExpressionUUID->"bf3b41ae-ff5c-48ec-bd66-\
737acae42a4c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Appendix", "Chapter",
 CellChangeTimes->{{3.710510135515211*^9, 3.710510138562091*^9}, {
  3.7105103108905535`*^9, 
  3.71051031482806*^9}},ExpressionUUID->"7ea6ceb0-47e2-4728-b759-\
d392f389956c"],

Cell[CellGroupData[{

Cell["Figures", "Subchapter",
 CellChangeTimes->{{3.709723867511118*^9, 
  3.7097238690082045`*^9}},ExpressionUUID->"699e28dd-68d7-4414-b12b-\
e4af948fae36"],

Cell[CellGroupData[{

Cell["Fig. 14.18", "Subsubsection",
 CellChangeTimes->{{3.728585404321271*^9, 3.728585405946273*^9}, 
   3.728644986128595*^9},ExpressionUUID->"4c499b6a-74f1-47fd-9f35-\
0ddd2c3c775f"],

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "->", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.710567610303071*^9, 3.710567723725167*^9}, {
  3.7105677944596806`*^9, 
  3.710567809256585*^9}},ExpressionUUID->"0da21ec9-e627-4c58-a23e-\
74e2d50d3b11"],

Cell[BoxData[
 RowBox[{"graphexample", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"3", "\[Rule]", "1"}], ",", 
      RowBox[{"4", "\[Rule]", "1"}], ",", 
      RowBox[{"4", "->", "5"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"5", "\[Rule]", "4"}], ",", 
      RowBox[{"4", "\[Rule]", "6"}]}], "}"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.710567610303071*^9, 3.7105677728190126`*^9}, {
  3.710567830678502*^9, 3.710567833584757*^9}, {3.710567986678808*^9, 
  3.7105679881944346`*^9}, {3.730285574952329*^9, 3.7302855885251064`*^9}, {
  3.7302857166404448`*^9, 
  3.7302857938278646`*^9}},ExpressionUUID->"b4cf7a3e-05b2-4ff0-a1ab-\
d4a8367380c7"],

Cell[BoxData[
 RowBox[{"figurexp", "[", 
  RowBox[{"\"\<TothNagyPapp-Fig14.18\>\"", ",", "graphexample"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7105679991007133`*^9, 3.710568008819476*^9}, {
  3.7285854151494164`*^9, 
  3.728585423446308*^9}},ExpressionUUID->"92cce48f-b2e7-4319-a92f-\
8337772a52f7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculations", "Subchapter",
 CellChangeTimes->{{3.7097238792197886`*^9, 
  3.709723882195959*^9}},ExpressionUUID->"ec8a08ea-ea7c-406a-b835-\
a52005bcf734"],

Cell[CellGroupData[{

Cell["Solution 13.3", "Subsubsection",
 CellChangeTimes->{{3.712593502560855*^9, 3.7125935053302593`*^9}, {
  3.7302858455098224`*^9, 
  3.730285848513994*^9}},ExpressionUUID->"1df2631f-db12-4ee3-b8bb-\
a84c2af4ae46"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"power", "[", 
   RowBox[{
    RowBox[{"a_", "?", "VectorQ"}], ",", " ", "b_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Times", " ", "@@", " ", 
    SuperscriptBox["a", "b"]}], "/;", 
   RowBox[{
    RowBox[{"VectorQ", "[", "a", "]"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"VectorQ", "[", "b", "]"}], "||", 
      RowBox[{"MatrixQ", "[", "b", "]"}]}], ")"}]}]}]}], "\n", 
 RowBox[{"power", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7125934868882093`*^9, 3.7125936089797077`*^9}, {
   3.712593802374752*^9, 3.712593804536832*^9}, {3.7125938363027573`*^9, 
   3.7125938494774857`*^9}, 
   3.712636950770582*^9},ExpressionUUID->"79226008-6b41-4812-9b52-\
582396b0ecca"],

Cell[BoxData[
 RowBox[{"power", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7302861082556286`*^9, 
  3.7302861231619086`*^9}},ExpressionUUID->"64dde704-edbb-40fa-b60c-\
33fae53d2954"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"a_", "?", "VectorQ"}], "\[CircleDot]", 
   RowBox[{"b_", "?", "VectorQ"}]}], ":=", 
  RowBox[{"a", " ", "b"}]}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[CircleDot]", 
  RowBox[{"{", 
   RowBox[{"l", ",", "k", ",", "o"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.712636324865093*^9, 3.7126363309031763`*^9}, {
   3.7126363678888965`*^9, 3.7126364292137117`*^9}, 3.7126365553208694`*^9, 
   3.712636958299821*^9, {3.730519998307601*^9, 
   3.730520010370127*^9}},ExpressionUUID->"9f341fe7-6ab3-4736-9911-\
79246124c164"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"div", "[", 
   RowBox[{
    RowBox[{"a_", "?", "VectorQ"}], ",", 
    RowBox[{"b_", "?", "VectorQ"}]}], "]"}], ":=", 
  RowBox[{"a", "/", "b"}]}], "\n", 
 RowBox[{"div", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"l", ",", "k", ",", "o"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.712636491499895*^9, 3.712636499925063*^9}, 
   3.7126369007787023`*^9, {3.7305200261670327`*^9, 
   3.730520027932661*^9}},ExpressionUUID->"1cbd34c3-6d58-4e17-a50f-\
6afe19f73df3"],

Cell[BoxData[
 RowBox[{"Divide", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"l", ",", "k", ",", "o"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.73028593673967*^9, 
  3.7302859492865677`*^9}},ExpressionUUID->"f5cc3ef8-b2bf-4e44-b4c5-\
9f6aefca8157"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "log", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"log", "[", "a_", "]"}], ":=", 
  RowBox[{"Log", "[", "a", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"log", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "3", ",", "\[ExponentialE]"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.712636991737008*^9, 3.712637017874657*^9}, {
  3.730520187557974*^9, 
  3.7305201977923694`*^9}},ExpressionUUID->"764f784f-e13e-4feb-ae6a-\
8719c37dfd72"],

Cell[BoxData[
 RowBox[{"log", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.730520039901439*^9, 
  3.730520059588975*^9}},ExpressionUUID->"8b34ae75-ddc1-485c-bcb3-\
e24b032ddd82"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"exp", "[", "a_", "]"}], ":=", 
  RowBox[{"Exp", "[", "a", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"exp", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], ",", 
    RowBox[{"Log", "[", "3", "]"}], ",", "1"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.7126370227139664`*^9, 
  3.7126370532336655`*^9}},ExpressionUUID->"53d1396d-6502-43bb-86ae-\
d02c319164d1"],

Cell["Shortly:", "Text",
 CellChangeTimes->{{3.730285958802212*^9, 
  3.7302859611615925`*^9}},ExpressionUUID->"b11fc8b6-bfb8-4df1-962a-\
531444caa9a7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"div", ",", "log", ",", "exp"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"div", "=", "Divide"}], ";", 
  RowBox[{"log", "=", "Log"}], ";", 
  RowBox[{"exp", "=", "Exp"}], ";"}]}], "Input",
 CellChangeTimes->{{3.730285966130354*^9, 
  3.730285998255415*^9}},ExpressionUUID->"9c90c11d-e35f-4253-a558-\
f3c7cd17b730"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 13.9", "Subsubsection",
 CellChangeTimes->{{3.712593502560855*^9, 3.7125935053302593`*^9}, {
  3.7302858455098224`*^9, 3.730285848513994*^9}, {3.730286170052625*^9, 
  3.7302861706776276`*^9}},ExpressionUUID->"fe21fc8a-74e7-4548-a4fc-\
4b1ee1313ad5"],

Cell[BoxData[
 RowBox[{"tr", "=", 
  RowBox[{
   RowBox[{"ReactionsData", "[", 
    RowBox[{"{", "\"\<Triangle\>\"", "}"}], "]"}], "[", 
   "\"\<fhjgraphedges\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.7126381248672104`*^9, 3.7126381649137273`*^9}, {
   3.730286180740147*^9, 3.7302861828964005`*^9}, 
   3.7306096858597336`*^9},ExpressionUUID->"b28acd6e-ebdf-4e80-84e8-\
d38f982bc9af"],

Cell[BoxData[
 RowBox[{"TransitiveClosureGraph", "[", 
  RowBox[{"Graph", "[", "tr", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.712638198298663*^9, 3.712638209076333*^9}, {
  3.730968504617831*^9, 
  3.7309685208053617`*^9}},ExpressionUUID->"26a23354-478b-4f25-9d84-\
e9050295493c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"weaklyreversibleQ", "[", "reaction_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{
     RowBox[{"a", "=", 
      RowBox[{"AdjacencyMatrix", "[", 
       RowBox[{"TransitiveClosureGraph", "[", 
        RowBox[{"Graph", "[", 
         RowBox[{
          RowBox[{"ReactionsData", "[", 
           RowBox[{"{", "reaction", "}"}], "]"}], "[", 
          "\"\<fhjgraphedges\>\"", "]"}], "]"}], "]"}], "]"}]}], ";", 
     RowBox[{"a", "\[Equal]", 
      RowBox[{"Transpose", "[", "a", "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7126388528521914`*^9, 3.71263896638387*^9}, {
  3.7126390101627407`*^9, 3.7126390278522186`*^9}, {3.712639086734174*^9, 
  3.7126390966750803`*^9}, {3.730286209099579*^9, 3.730286209896453*^9}, {
  3.730968541414777*^9, 
  3.7309685504616704`*^9}},ExpressionUUID->"3e24d2d1-a5bb-4c9f-8bde-\
b48485243c31"],

Cell[BoxData[
 RowBox[{"weaklyreversibleQ", "[", "\"\<Triangle\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7126389696695805`*^9, 3.7126389878578224`*^9}, {
   3.712639043138998*^9, 3.7126390656608915`*^9}, 
   3.730609686703783*^9},ExpressionUUID->"22344662-2f18-4cc6-a90d-\
51c04af28c4a"],

Cell[BoxData[
 RowBox[{"weaklyreversibleQ", "[", "\"\<Lotka-Volterra\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7126389696695805`*^9, 3.7126389878578224`*^9}, {
  3.712639043138998*^9, 3.7126390656608915`*^9}, {3.7126391040372896`*^9, 
  3.7126391476481495`*^9}},ExpressionUUID->"d221dc8d-4334-4666-9204-\
e339f702def5"],

Cell[BoxData[
 RowBox[{"WeaklyReversibleQ", "[", 
  RowBox[{"{", "tr", "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.730286397599946*^9, 3.7302864238499966`*^9}, {
  3.730286471850091*^9, 
  3.7302864771938505`*^9}},ExpressionUUID->"3c36ad95-6e8f-443d-a46c-\
e69eaef09d13"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 13.15", "Subsubsection",
 CellChangeTimes->{{3.712593502560855*^9, 3.7125935053302593`*^9}, {
  3.7302858455098224`*^9, 3.730285848513994*^9}, {3.730286170052625*^9, 
  3.7302861706776276`*^9}, {3.7302865829909325`*^9, 
  3.7302865842096853`*^9}},ExpressionUUID->"074cf554-44d9-4a0b-bfc0-\
b5e0ac85376b"],

Cell[BoxData[
 RowBox[{"ProbabilityGeneratingFunctionEquation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", "\[Rule]", "\"\<X\>\""}], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["k", "1"], "}"}], ",", "g"}], "]"}]], "Input",
 CellChangeTimes->{{3.714575924923525*^9, 
  3.7145759269547777`*^9}},ExpressionUUID->"af99c43d-e752-424e-8c15-\
b2091f8d9fe3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SolveProbabilityGeneratingFunctionEquation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", "\[Rule]", "\"\<X\>\""}], "}"}], ",", 
      RowBox[{"{", 
       SubscriptBox["k", "1"], "}"}], ",", 
      RowBox[{"{", "D", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "z"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}], "//", "Quiet"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.7145757009003286`*^9, 3.7145757241925707`*^9}, {
  3.730286643284563*^9, 
  3.730286695167533*^9}},ExpressionUUID->"1e3ddc00-05b5-4a87-8ecd-\
20a552c91a76"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution 13.16", "Subsubsection",
 CellChangeTimes->{{3.712593502560855*^9, 3.7125935053302593`*^9}, {
  3.7302858455098224`*^9, 3.730285848513994*^9}, {3.730286170052625*^9, 
  3.7302861706776276`*^9}, {3.7302865829909325`*^9, 3.7302865842096853`*^9}, {
  3.7302867184788675`*^9, 
  3.730286719125902*^9}},ExpressionUUID->"686ac07c-2412-4c9f-9ad8-\
42f2e39b6897"],

Cell[BoxData[
 RowBox[{"ProbabilityGeneratingFunctionEquation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<X\>\"", "\[Rule]", 
     RowBox[{"2", "\"\<X\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["k", "1"], "}"}], ",", "G"}], "]"}]], "Input",
 CellChangeTimes->{{3.7145759506579494`*^9, 3.7145759516110764`*^9}, {
  3.730286729414494*^9, 
  3.730286763902469*^9}},ExpressionUUID->"256b0993-2ff5-42c3-97cd-\
d76fc22cfe1a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SolveProbabilityGeneratingFunctionEquation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<X\>\"", "\[Rule]", 
        RowBox[{"2", "\"\<X\>\""}]}], "}"}], ",", 
      RowBox[{"{", 
       SubscriptBox["k", "1"], "}"}], ",", 
      RowBox[{"{", "D", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "z"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}], "//", "Quiet"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.714575620275172*^9, 3.714575652556484*^9}, {
  3.7145757331575236`*^9, 3.7145757430794187`*^9}, {3.7302867961503153`*^9, 
  3.730286839685809*^9}},ExpressionUUID->"4c5e8b9b-9927-48bc-8151-\
43efcf0ed9b0"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1048, 965},
WindowMargins->{{Automatic, 80}, {-29, Automatic}},
Magnification:>1.25 Inherited,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 156, 3, 121, "Title",ExpressionUUID->"fa12775a-e440-4712-852d-620818d131fe"],
Cell[739, 27, 944, 17, 55, "Input",ExpressionUUID->"59047852-c904-402b-9e31-84b46a17c1dc",
 InitializationCell->True,
 InitializationGroup->True],
Cell[1686, 46, 1559, 32, 128, "Input",ExpressionUUID->"be69a8af-c433-4d78-bd77-9879a532de87",
 InitializationCell->True,
 InitializationGroup->True],
Cell[3248, 80, 924, 16, 55, "Input",ExpressionUUID->"d150c58b-8960-4fb3-9572-81a8d251c0a0",
 InitializationCell->True,
 InitializationGroup->True],
Cell[4175, 98, 197, 4, 55, "Input",ExpressionUUID->"27731ee5-22a8-43d2-af1d-44069f0596f9",
 InitializationCell->True],
Cell[4375, 104, 1708, 39, 128, "Input",ExpressionUUID->"8e86e716-d236-4a03-9104-77418a898af3",
 InitializationCell->True,
 InitializationGroup->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[6120, 148, 157, 3, 121, "Title",ExpressionUUID->"821e660a-ae23-4a01-b116-943c5b26bde0"],
Cell[CellGroupData[{
Cell[6302, 155, 152, 3, 107, "Chapter",ExpressionUUID->"9636287c-8921-4a91-94de-b1efca56adff"],
Cell[CellGroupData[{
Cell[6479, 162, 383, 6, 70, "Subsubsection",ExpressionUUID->"68990d16-3e3a-4f02-bd11-9a96892a1a4d"],
Cell[6865, 170, 370, 7, 53, "Text",ExpressionUUID->"20e1aac2-d442-4bf9-bb54-49ac9955d824"],
Cell[7238, 179, 886, 16, 105, "Input",ExpressionUUID->"dfccd107-7986-4ee9-8bd0-a64b2ef5cc20"],
Cell[8127, 197, 362, 8, 88, "Text",ExpressionUUID->"6afbd8fe-9e25-404a-870c-a98e9e557cbb"],
Cell[8492, 207, 1221, 24, 75, "Input",ExpressionUUID->"022bacaa-e1cb-4f4f-afb9-108fe3280d9d"],
Cell[9716, 233, 586, 11, 43, "Input",ExpressionUUID->"13b6e46f-a7ee-4ac4-9ad3-c7975d65c155"]
}, Open  ]]
}, Open  ]],
Cell[10329, 248, 157, 3, 107, "Chapter",ExpressionUUID->"c46c8b28-fbd0-4bff-94b8-5597a057c4ab"]
}, Closed]],
Cell[CellGroupData[{
Cell[10523, 256, 157, 3, 87, "Title",ExpressionUUID->"ac2d20c3-4b0e-44fe-845d-9cdae3aa7400"],
Cell[10683, 261, 152, 3, 107, "Chapter",ExpressionUUID->"fee0c949-a159-4990-b237-33502f7fa1a6"],
Cell[CellGroupData[{
Cell[10860, 268, 161, 3, 88, "Chapter",ExpressionUUID->"c6f9e77e-82f9-43ba-af41-6ea5ce331286"],
Cell[CellGroupData[{
Cell[11046, 275, 224, 4, 103, "Section",ExpressionUUID->"eb35b42d-97a8-4b0a-8f0c-753f02f75b8c"],
Cell[CellGroupData[{
Cell[11295, 283, 216, 4, 70, "Subsubsection",ExpressionUUID->"ccfd0b81-6666-4096-b2d1-a0156a626fdc"],
Cell[11514, 289, 432, 11, 43, "Input",ExpressionUUID->"58c254e9-7b1a-4a57-aa96-b1e6c6a13cd5"],
Cell[11949, 302, 250, 5, 43, "Input",ExpressionUUID->"1ba2591e-bdcf-46ff-a6a4-146dcb5b686c"],
Cell[12202, 309, 483, 8, 43, "Input",ExpressionUUID->"908c3245-260d-4ebd-bf7d-344357038872"],
Cell[12688, 319, 196, 4, 43, "Input",ExpressionUUID->"a2024d4f-5853-4601-a3a8-98a746e8ea53"],
Cell[12887, 325, 205, 4, 43, "Input",ExpressionUUID->"1bfcf46d-f896-4b75-8d62-92da2846ba6e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13129, 334, 243, 4, 70, "Subsubsection",ExpressionUUID->"9d5141b5-cb64-491d-8d9b-93d9e5695d72"],
Cell[13375, 340, 1225, 29, 105, "Input",ExpressionUUID->"a0309dcc-1481-4613-a9ca-07f6a34cb425"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14637, 374, 239, 4, 70, "Subsubsection",ExpressionUUID->"27c964e0-d3cb-4333-97ec-328257935880"],
Cell[14879, 380, 622, 13, 43, "Input",ExpressionUUID->"e54e7606-cc54-498c-a4e4-a616e8a342dc"],
Cell[15504, 395, 358, 8, 43, "Input",ExpressionUUID->"e9e05cad-b6e2-4d50-abd2-2a462b31b716"],
Cell[15865, 405, 710, 16, 43, "Input",ExpressionUUID->"e380fca0-1d1e-49d8-baa0-0d556f952fb3"],
Cell[16578, 423, 233, 5, 43, "Input",ExpressionUUID->"84c3dde2-a141-4d05-83d2-bd3d26b4520d"],
Cell[16814, 430, 868, 17, 105, "Input",ExpressionUUID->"69686ae9-802f-4e5c-ac2f-e6fbce9131dd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17719, 452, 230, 4, 70, "Subsubsection",ExpressionUUID->"5cacf332-6110-4e97-b4d8-2808c9f907a2"],
Cell[17952, 458, 507, 12, 43, "Input",ExpressionUUID->"88a8c17c-51d6-4247-b02c-e28f960c954f"],
Cell[18462, 472, 319, 8, 43, "Input",ExpressionUUID->"64fb543a-9a7b-4333-9f87-2eda4bab88ab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18818, 485, 239, 4, 70, "Subsubsection",ExpressionUUID->"c1741677-551e-455e-8956-6bbe04c54913"],
Cell[19060, 491, 664, 14, 43, "Input",ExpressionUUID->"74172c01-10cc-4927-b29b-1d293c5e8bc7"],
Cell[19727, 507, 367, 9, 43, "Input",ExpressionUUID->"48f25082-5640-47dd-827f-371b95adb785"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20131, 521, 234, 4, 70, "Subsubsection",ExpressionUUID->"90cbe85c-c280-4f9c-bbea-060ab192abb2"],
Cell[20368, 527, 849, 19, 75, "Input",ExpressionUUID->"b649b018-9c48-44f8-b21b-e492114faee0"],
Cell[21220, 548, 967, 24, 75, "Input",ExpressionUUID->"b4ed77f6-cc77-46d2-b48e-dc68ace21ce9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22224, 577, 231, 4, 70, "Subsubsection",ExpressionUUID->"317f72e1-b7a3-4918-b794-8e8b8784f3ad"],
Cell[22458, 583, 994, 21, 75, "Input",ExpressionUUID->"1adb1a61-cb32-4b87-9815-76efd1341b11"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23489, 609, 279, 4, 70, "Subsubsection",ExpressionUUID->"0731e034-ae93-4afa-9aeb-c5fa7b7acc95"],
Cell[23771, 615, 1179, 23, 75, "Input",ExpressionUUID->"e488a7f3-4d72-4c82-a756-f7ea0c495dcd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24987, 643, 334, 5, 70, "Subsubsection",ExpressionUUID->"0a146e53-c4fc-4825-be8e-defd7b271a33"],
Cell[25324, 650, 567, 12, 75, "Input",ExpressionUUID->"687b1836-917f-4bc1-916b-507e09b5d195"],
Cell[25894, 664, 1025, 28, 111, "Input",ExpressionUUID->"74201a7f-f113-4bfb-951a-224e40e5951f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26968, 698, 347, 8, 103, "Section",ExpressionUUID->"8b73e01d-2d7f-46e6-b530-462fc8862fae"],
Cell[27318, 708, 309, 7, 43, "Input",ExpressionUUID->"64165d92-62b8-4a4e-ac84-30ddae8beb49"],
Cell[27630, 717, 358, 9, 75, "Input",ExpressionUUID->"d0ba9c68-4a10-4908-9477-42cb7f5c347d"],
Cell[27991, 728, 317, 6, 105, "Input",ExpressionUUID->"e93b4964-1aa3-4eeb-8a94-9be88a61a8cf"],
Cell[28311, 736, 184, 3, 43, "Input",ExpressionUUID->"0096bf5e-ab29-4a0a-9676-552a959db092"],
Cell[28498, 741, 111, 1, 43, "Input",ExpressionUUID->"3c46964f-011f-4663-8f37-35dd7267f972"],
Cell[28612, 744, 341, 10, 43, "Input",ExpressionUUID->"31e18e3f-ba26-4877-9a54-6dcadd120916"],
Cell[28956, 756, 342, 10, 43, "Input",ExpressionUUID->"a36723ac-e864-48d1-adb8-3b91f9295671"],
Cell[CellGroupData[{
Cell[29323, 770, 273, 4, 83, "Subsection",ExpressionUUID->"7001d07c-6455-4aee-ae39-0e9804201762"],
Cell[29599, 776, 186, 4, 43, "Input",ExpressionUUID->"27c8d5e2-79ed-438b-b96d-b3520d6772e1"],
Cell[29788, 782, 236, 5, 43, "Input",ExpressionUUID->"56293842-cfca-4b17-a1a9-f4dbca412488"],
Cell[30027, 789, 181, 4, 43, "Input",ExpressionUUID->"e7b23247-f01e-4be8-ad51-b7290ff96e76"],
Cell[30211, 795, 179, 4, 43, "Input",ExpressionUUID->"3c2f0971-5781-4b36-8f90-33b03fb106f2"],
Cell[30393, 801, 179, 4, 43, "Input",ExpressionUUID->"76fd57f4-3164-48b6-b04b-acd1e922866a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30609, 810, 303, 9, 83, "Subsection",ExpressionUUID->"418dd874-20ce-46d0-8f78-78f91b6c7cb4"],
Cell[CellGroupData[{
Cell[30937, 823, 194, 3, 70, "Subsubsection",ExpressionUUID->"c459b24f-391b-478a-8a01-a5917c942421"],
Cell[31134, 828, 214, 4, 43, "Input",ExpressionUUID->"e92130f1-15a3-4dfd-9e7f-4d1543f6d678"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31385, 837, 185, 3, 70, "Subsubsection",ExpressionUUID->"b4713e57-e8fc-4367-8845-390eca436ec2"],
Cell[31573, 842, 217, 5, 43, "Input",ExpressionUUID->"3e3624b6-06e9-41c6-9bd8-08ae288b2673"],
Cell[31793, 849, 184, 4, 43, "Input",ExpressionUUID->"bc2f8b98-d2f3-4ec7-b8a5-9647d5a51c61"],
Cell[31980, 855, 220, 4, 43, "Input",ExpressionUUID->"f3de6c5a-eb6c-480a-8c33-f277920bfb5c"],
Cell[32203, 861, 368, 8, 75, "Input",ExpressionUUID->"1f4e341f-a630-44e1-8f14-066a5f4f81f5"],
Cell[32574, 871, 369, 8, 43, "Input",ExpressionUUID->"c24cc613-0877-4644-95c4-6e7c63c47260"],
Cell[32946, 881, 373, 9, 43, "Input",ExpressionUUID->"4a4aa172-388d-4f04-92ee-80fccf88e6ff"],
Cell[33322, 892, 385, 9, 75, "Input",ExpressionUUID->"bb38f6e3-5458-4aed-b931-aa116b1bd73d"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33768, 908, 231, 4, 103, "Section",ExpressionUUID->"be513f2e-faae-4b6d-a35b-00b0be7adb41"],
Cell[34002, 914, 201, 3, 53, "Text",ExpressionUUID->"a9cb7fa3-d1a9-4006-b16f-7e47f64fb65d"],
Cell[CellGroupData[{
Cell[34228, 921, 159, 3, 70, "Subsubsection",ExpressionUUID->"fcd9a7e1-77a1-44c1-a824-36dabd94a0a9"],
Cell[34390, 926, 210, 4, 43, "Input",ExpressionUUID->"cede5cd2-a282-45cb-b373-3d59f36e2c43"],
Cell[34603, 932, 205, 4, 43, "Input",ExpressionUUID->"62ec1199-3634-4824-aec3-f55f59f42265"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34845, 941, 191, 3, 70, "Subsubsection",ExpressionUUID->"cac920a8-2363-4dc3-97dd-1e066b46f3c3"],
Cell[35039, 946, 596, 14, 43, "Input",ExpressionUUID->"98ceeca0-e4c0-4049-9094-033963ea15ce"],
Cell[35638, 962, 352, 8, 43, "Input",ExpressionUUID->"0bd68ef3-a6dc-4128-b0d8-6e218f1a3e84"],
Cell[35993, 972, 293, 6, 43, "Input",ExpressionUUID->"514d2f9d-a98f-4e25-af83-40e5c029147f"],
Cell[36289, 980, 301, 6, 43, "Input",ExpressionUUID->"a190ead0-c58f-4791-9c16-22772da24dac"],
Cell[36593, 988, 468, 12, 43, "Input",ExpressionUUID->"74344a7a-778a-49e0-880d-3eeb9ad9a2f5"],
Cell[37064, 1002, 215, 4, 43, "Input",ExpressionUUID->"ebf18895-8055-4339-8dc2-3a2263d48d43"],
Cell[37282, 1008, 212, 4, 43, "Input",ExpressionUUID->"5ac6aa46-1607-4af7-a5da-6763fe6d0be5"],
Cell[37497, 1014, 160, 3, 43, "Input",ExpressionUUID->"e473a054-061e-45bb-ae06-7a374397c37d"],
Cell[37660, 1019, 264, 7, 43, "Input",ExpressionUUID->"ce4669f9-8bda-4c25-bc2c-ea01c1a23b9e"],
Cell[37927, 1028, 254, 5, 43, "Input",ExpressionUUID->"2e59902b-35de-482d-8ed7-2e2b505bcc39"],
Cell[38184, 1035, 354, 9, 43, "Input",ExpressionUUID->"4e13e6bd-3282-47fe-aeb6-e6c368c16aba"],
Cell[38541, 1046, 259, 5, 43, "Input",ExpressionUUID->"a3a79730-8033-4d27-b6f8-fd0b338257d8"],
Cell[38803, 1053, 448, 12, 43, "Input",ExpressionUUID->"16864b89-66d0-418d-b284-445cb29c9880"],
Cell[39254, 1067, 358, 8, 43, "Input",ExpressionUUID->"d138b7d1-1b1f-49cb-9b4e-96d2574bd147"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39685, 1083, 213, 4, 87, "Title",ExpressionUUID->"90b20476-3cbe-4c1a-96fd-c1be0fc54506"],
Cell[CellGroupData[{
Cell[39923, 1091, 154, 3, 86, "Chapter",ExpressionUUID->"2de6aa78-1951-4329-a7a0-ec1c55d35b29"],
Cell[CellGroupData[{
Cell[40102, 1098, 286, 5, 56, "Subsubsection",ExpressionUUID->"a440f012-1553-412f-9520-d0142793eb8e"],
Cell[40391, 1105, 555, 11, 60, "Input",ExpressionUUID->"df199375-5dd0-4208-b7c1-d14480779cf7"],
Cell[40949, 1118, 353, 7, 35, "Input",ExpressionUUID->"986b756e-a544-48ca-bf2d-b2fadc6aefc1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41339, 1130, 237, 4, 56, "Subsubsection",ExpressionUUID->"50a9d85d-fd72-4603-aafe-bbf2ce6e177f"],
Cell[41579, 1136, 594, 12, 35, "Input",ExpressionUUID->"a9d70427-1fd8-40b1-82c5-0770c4cb3a07"],
Cell[42176, 1150, 350, 7, 35, "Input",ExpressionUUID->"e403619d-06cc-4ae8-a8e3-2d444ee40224"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42563, 1162, 234, 4, 56, "Subsubsection",ExpressionUUID->"73e48c27-d266-456a-8ea8-904d27e5e3ca"],
Cell[42800, 1168, 1111, 24, 108, "Input",ExpressionUUID->"5831caf3-7240-4319-99b3-e7e9b128b502"],
Cell[43914, 1194, 685, 12, 35, "Input",ExpressionUUID->"13932ef2-27d2-4b1c-a839-f5cd7c21aafe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44636, 1211, 211, 4, 56, "Subsubsection",ExpressionUUID->"c38c9b86-f2d6-44ab-863b-77f9cd858371"],
Cell[44850, 1217, 644, 13, 35, "Input",ExpressionUUID->"63430af3-78ba-444f-b7f8-88b9bce71858"],
Cell[45497, 1232, 353, 7, 35, "Input",ExpressionUUID->"c04b5715-e6ad-4ed4-8e1c-c84da8357acc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45887, 1244, 234, 4, 56, "Subsubsection",ExpressionUUID->"9dc315a5-4d2f-4470-b7f6-aeba2db5b860"],
Cell[46124, 1250, 655, 14, 35, "Input",ExpressionUUID->"c51a4e56-8326-4a0e-95cd-fbbb3fc1560b"],
Cell[46782, 1266, 190, 4, 35, "Input",ExpressionUUID->"0e98d3df-14e7-4de4-974f-60dfdc5897dc"],
Cell[46975, 1272, 401, 10, 35, "Input",ExpressionUUID->"0584a64b-719a-45fc-9c7d-409e99394835"],
Cell[47379, 1284, 858, 17, 60, "Input",ExpressionUUID->"69e7b158-85b8-46ce-b76a-48aec8734e20"],
Cell[48240, 1303, 296, 6, 35, "Input",ExpressionUUID->"8a126430-121e-4675-9d65-a68820685707"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48573, 1314, 238, 4, 56, "Subsubsection",ExpressionUUID->"43737555-5270-47b0-b532-0a803b75c9f1"],
Cell[48814, 1320, 265, 6, 35, "Input",ExpressionUUID->"e1efd8cd-6b7e-4247-9253-1d6725f1b575"],
Cell[49082, 1328, 377, 9, 35, "Input",ExpressionUUID->"01834079-2fbd-4d4d-86c5-91e1870a4084"],
Cell[49462, 1339, 890, 19, 60, "Input",ExpressionUUID->"790aec4e-6fdf-439c-9117-fbdcb28ca078"],
Cell[50355, 1360, 374, 7, 35, "Input",ExpressionUUID->"80ceec5a-7198-46cf-b5a0-0d11afa47b7c"],
Cell[50732, 1369, 336, 8, 35, "Input",ExpressionUUID->"a6c8847b-8e96-428d-a224-32fb07f80e6b"],
Cell[51071, 1379, 668, 15, 35, "Input",ExpressionUUID->"37b2f44c-c344-4dbf-83b8-278bf707c1fa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51776, 1399, 289, 5, 56, "Subsubsection",ExpressionUUID->"126f8e61-f1f5-40c4-ba61-4c850038fc9e"],
Cell[52068, 1406, 441, 9, 35, "Input",ExpressionUUID->"bc4c0dfc-8d68-4cdf-8b24-c2ac78ff4319"],
Cell[52512, 1417, 1158, 26, 84, "Input",ExpressionUUID->"2ad68830-443b-4701-ac1c-1fff164f8e18"],
Cell[53673, 1445, 414, 7, 35, "Input",ExpressionUUID->"5db78fbf-af57-4c4a-8408-c5b187ae420f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54124, 1457, 238, 4, 56, "Subsubsection",ExpressionUUID->"1c76a83d-66ea-486f-9923-ba7469e43d4d"],
Cell[54365, 1463, 1710, 44, 88, "Input",ExpressionUUID->"831e9c09-fa06-48df-9aab-7dbdefd33089"],
Cell[56078, 1509, 618, 14, 35, "Input",ExpressionUUID->"bc5250b7-8938-4c72-8132-9b2a70c92540"],
Cell[56699, 1525, 1327, 25, 84, "Input",ExpressionUUID->"a92b7a76-2f03-4688-b57c-454a6e52fad2"],
Cell[58029, 1552, 341, 6, 35, "Input",ExpressionUUID->"98a279c9-f335-4038-a454-18b44632be74"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58407, 1563, 236, 4, 56, "Subsubsection",ExpressionUUID->"e6a4a06a-0e28-49ad-b513-ec08f5c0c3dd"],
Cell[58646, 1569, 1867, 49, 132, "Input",ExpressionUUID->"8d784ebe-a1ec-4f47-ad95-76e5015625de"],
Cell[60516, 1620, 154, 3, 35, "Input",ExpressionUUID->"bf06e64a-aca9-408e-a260-768f9716dbeb"],
Cell[60673, 1625, 404, 8, 35, "Input",ExpressionUUID->"884ed2e5-3eb8-43fb-a858-5b26d65e9aa8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61114, 1638, 214, 4, 56, "Subsubsection",ExpressionUUID->"9a8f53bd-7113-4386-ad06-281cad48e430"],
Cell[61331, 1644, 438, 12, 35, "Input",ExpressionUUID->"510322c5-8ef4-4ef5-89bc-74cfcc53ee7f"],
Cell[61772, 1658, 1888, 47, 156, "Input",ExpressionUUID->"31368b24-83d3-4f50-9ca0-11de9729084f"],
Cell[63663, 1707, 388, 8, 43, "Input",ExpressionUUID->"750616a0-9671-43be-8eb1-cffa11cfbad8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64088, 1720, 236, 4, 70, "Subsubsection",ExpressionUUID->"44497e00-c924-40c7-a0b5-ebbbed7e1185"],
Cell[64327, 1726, 624, 15, 75, "Input",ExpressionUUID->"0e76c4aa-d01f-468f-8bb8-70b3727e2f60"],
Cell[64954, 1743, 414, 8, 43, "Input",ExpressionUUID->"5502588d-d78c-406f-83bf-bca460eca7dd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65417, 1757, 159, 3, 107, "Chapter",ExpressionUUID->"99dff737-c900-46c8-a40f-163a7939560d"],
Cell[CellGroupData[{
Cell[65601, 1764, 163, 3, 70, "Subsubsection",ExpressionUUID->"2ae39465-1253-4dbc-9c73-1d4f17fe621a"],
Cell[65767, 1769, 671, 15, 43, "Input",ExpressionUUID->"b72523e6-dcf4-4fdf-be9d-51ad3a24f986"],
Cell[66441, 1786, 690, 14, 75, "Input",ExpressionUUID->"ff1b2f6c-3d3c-459a-9f50-e8afe283dc07"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67168, 1805, 209, 4, 70, "Subsubsection",ExpressionUUID->"d4d685c7-0b2f-417f-a8ff-109c41a98ffb"],
Cell[67380, 1811, 282, 7, 43, "Input",ExpressionUUID->"9ed65bb1-7c94-476b-be1e-812d17f1a795"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67723, 1825, 164, 3, 87, "Title",ExpressionUUID->"c8f7b3ed-c1ad-4e65-9c73-a5374b2656b2"],
Cell[CellGroupData[{
Cell[67912, 1832, 154, 3, 107, "Chapter",ExpressionUUID->"79340305-ada1-47e2-a66a-3b96dc45e683"],
Cell[CellGroupData[{
Cell[68091, 1839, 185, 3, 70, "Subsubsection",ExpressionUUID->"84750d02-e6e0-49b1-a5f7-024977a2dc4b"],
Cell[68279, 1844, 2894, 75, 225, "Input",ExpressionUUID->"ed96dfa1-f509-436c-95f7-eb9a6ab3622e"],
Cell[71176, 1921, 865, 21, 75, "Input",ExpressionUUID->"da701f49-d1c9-4a43-86cf-7ab0ace5127c"],
Cell[72044, 1944, 326, 6, 43, "Input",ExpressionUUID->"248f33e1-4176-4563-b6a0-0dacd489fb56"],
Cell[72373, 1952, 5717, 129, 315, "Input",ExpressionUUID->"dc0f1871-73b3-4fa0-92ee-5b3fe4c5585a"],
Cell[78093, 2083, 292, 6, 43, "Input",ExpressionUUID->"c7c42884-a67b-413a-b8b0-903d9b3a09d9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78422, 2094, 185, 3, 70, "Subsubsection",ExpressionUUID->"0d244654-6570-4f03-ab30-fe8a43574c4f"],
Cell[78610, 2099, 1462, 36, 105, "Input",ExpressionUUID->"d28aa450-498d-4c60-baa5-42c1e6617e69"],
Cell[80075, 2137, 289, 6, 43, "Input",ExpressionUUID->"bf8436ff-50c3-4368-8f6a-192121829bab"],
Cell[80367, 2145, 1925, 50, 135, "Input",ExpressionUUID->"9c8a9fd1-a5cf-49ef-ad1c-ebd3c6623ee4",
 CellID->29675792],
Cell[82295, 2197, 299, 6, 43, "Input",ExpressionUUID->"6edf3da5-7c2d-4133-8818-8e1b2d172620"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82643, 2209, 159, 3, 88, "Chapter",ExpressionUUID->"9b633dec-6c42-4676-a2ef-674ffff2b00e"],
Cell[CellGroupData[{
Cell[82827, 2216, 216, 4, 98, "Subchapter",ExpressionUUID->"631934b4-6c1a-4d1d-983e-5483c07c30d4"],
Cell[83046, 2222, 581, 15, 43, "Input",ExpressionUUID->"ad015f9b-1f23-45bc-ad85-9ccea4eced64"],
Cell[CellGroupData[{
Cell[83652, 2241, 164, 3, 70, "Subsubsection",ExpressionUUID->"7c9b5683-0f62-4ad4-831a-c11fadaa2197"],
Cell[83819, 2246, 455, 11, 43, "Input",ExpressionUUID->"f3e34e86-400f-4316-8922-61a588265023"],
Cell[84277, 2259, 452, 11, 43, "Input",ExpressionUUID->"6c4e8c7d-a958-4367-ba4a-675d0db5a935"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84766, 2275, 161, 3, 70, "Subsubsection",ExpressionUUID->"dd5f712a-13a5-4759-a9ec-bca2390577be"],
Cell[84930, 2280, 450, 8, 43, "Input",ExpressionUUID->"770e12e0-12d7-4505-a2d6-0986ee846e8e"],
Cell[85383, 2290, 446, 8, 43, "Input",ExpressionUUID->"30d872f8-6a04-4a94-81ba-1cff4f27f3ec"],
Cell[85832, 2300, 657, 13, 43, "Input",ExpressionUUID->"5138a872-cb77-428b-9eb4-7348724fb56c"],
Cell[86492, 2315, 419, 10, 43, "Input",ExpressionUUID->"e3472c10-df33-44f8-89a3-09976d186125"],
Cell[86914, 2327, 510, 12, 43, "Input",ExpressionUUID->"393b328d-60d9-4a3c-bebf-e8492c4f3a8b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87461, 2344, 348, 5, 70, "Subsubsection",ExpressionUUID->"0460232f-eb23-4398-8a8a-595b9581f99f"],
Cell[87812, 2351, 657, 13, 43, "Input",ExpressionUUID->"e66a0844-3754-493e-96d8-d3861916029d"],
Cell[88472, 2366, 400, 11, 43, "Input",ExpressionUUID->"6f925681-8ae1-4979-ba59-4e9d2742e8b6"],
Cell[88875, 2379, 1802, 51, 135, "Input",ExpressionUUID->"5a894d95-3cf8-4cc8-83ee-fd038bf3e705"],
Cell[90680, 2432, 228, 5, 53, "Text",ExpressionUUID->"0955b2b4-2492-4919-966d-7126ba43f916"],
Cell[90911, 2439, 330, 8, 43, "Input",ExpressionUUID->"b71d8194-60d9-406d-8848-36bfa020cb53"],
Cell[91244, 2449, 1852, 52, 135, "Input",ExpressionUUID->"ddfd077e-29ba-4072-97c4-4d0930727830"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93133, 2506, 302, 4, 70, "Subsubsection",ExpressionUUID->"7e68e11e-dea6-445e-babb-cadb11b0a26b"],
Cell[93438, 2512, 347, 8, 43, "Input",ExpressionUUID->"66e7b9f6-dc88-473e-b881-dd4b178c641c"],
Cell[93788, 2522, 454, 9, 43, "Input",ExpressionUUID->"5c535681-117f-41d8-89ea-3e021c838a53"],
Cell[94245, 2533, 938, 21, 75, "Input",ExpressionUUID->"f5a94b39-a721-459d-a40f-be90ca4c34a9"],
Cell[95186, 2556, 420, 11, 43, "Input",ExpressionUUID->"178e0db3-cc5f-4243-b665-058f7b60cd8c"],
Cell[95609, 2569, 1226, 35, 75, "Input",ExpressionUUID->"1b419c43-3943-4978-84d6-df2867e96fe6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96872, 2609, 263, 4, 70, "Subsubsection",ExpressionUUID->"ce559a70-e293-4d45-ac3f-cb24684e8e8e"],
Cell[97138, 2615, 529, 14, 75, "Input",ExpressionUUID->"ad56822e-d29c-4cc3-bd6d-e229002cf136"],
Cell[97670, 2631, 223, 5, 53, "Text",ExpressionUUID->"d48a37cb-c6f6-4df7-bea7-0fa2c573cc3a"],
Cell[97896, 2638, 183, 4, 43, "Input",ExpressionUUID->"dab928b9-b7e9-42ef-b96b-353ff2e137ad"],
Cell[98082, 2644, 236, 4, 43, "Input",ExpressionUUID->"bef78550-4beb-4d3b-8a29-2721a6b5ad69"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98355, 2653, 215, 4, 70, "Subsubsection",ExpressionUUID->"67b7c8a3-b6e1-4b61-ac95-1d72cbe36bbe"],
Cell[98573, 2659, 544, 13, 75, "Input",ExpressionUUID->"e473f59b-1a49-4b5a-b6eb-22a00219a5f0"],
Cell[99120, 2674, 243, 6, 53, "Text",ExpressionUUID->"fb8b60f7-5523-4cd7-84c0-b0c943d14dd9"],
Cell[99366, 2682, 347, 8, 43, "Input",ExpressionUUID->"fd57c018-8709-4888-8210-1f0103a0d8ed"],
Cell[99716, 2692, 359, 9, 43, "Input",ExpressionUUID->"3f7641b1-844d-46aa-8750-5bdd40d1cb2e"],
Cell[100078, 2703, 280, 6, 53, "Text",ExpressionUUID->"6afc18f7-575e-4d15-a545-0a9edcd3b2d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100395, 2714, 164, 3, 70, "Subsubsection",ExpressionUUID->"26f25687-2f16-4481-a709-f146fdab3fb9"],
Cell[100562, 2719, 465, 12, 43, "Input",ExpressionUUID->"34d60615-0e2f-4d2b-b8fe-191a02ef5dd5"],
Cell[101030, 2733, 493, 13, 43, "Input",ExpressionUUID->"175e9058-538c-4c25-b23c-3b2585dddff5"],
Cell[101526, 2748, 549, 11, 43, "Input",ExpressionUUID->"5deadfce-87d6-414f-a422-63190ffc98a9"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[102148, 2767, 212, 4, 87, "Title",ExpressionUUID->"6a485d68-1b99-4ebf-9a28-6d8418261510"],
Cell[102363, 2773, 154, 3, 86, "Chapter",ExpressionUUID->"d7f777ea-f953-41ec-b8af-55bedfd38520"],
Cell[CellGroupData[{
Cell[102542, 2780, 159, 3, 71, "Chapter",ExpressionUUID->"ac57b396-2b57-43f8-8d2e-45ecd130f7d7"],
Cell[CellGroupData[{
Cell[102726, 2787, 166, 3, 56, "Subsubsection",ExpressionUUID->"6085ec1f-b493-4cc5-9d73-bf7c22551e0e"],
Cell[102895, 2792, 190, 4, 35, "Input",ExpressionUUID->"6e0d5be1-e4a1-4405-94b0-820607d150fb"],
Cell[103088, 2798, 378, 9, 35, "Input",ExpressionUUID->"a30530ef-c30a-485b-80a3-a1d94db37914"]
}, Open  ]],
Cell[CellGroupData[{
Cell[103503, 2812, 215, 4, 56, "Subsubsection",ExpressionUUID->"9c65f59f-27e4-4f64-b078-88e2afd98588"],
Cell[103721, 2818, 442, 13, 35, "Input",ExpressionUUID->"19c38eef-5304-41d1-9847-d9268ae0abc0"],
Cell[104166, 2833, 889, 26, 35, "Input",ExpressionUUID->"6d9df51c-671d-49c9-ba07-2683cb64a10e"],
Cell[105058, 2861, 826, 23, 35, "Input",ExpressionUUID->"26bf8083-d416-4129-90c6-a8d4500c5a3a"],
Cell[105887, 2886, 1345, 38, 60, "Input",ExpressionUUID->"f2a9cef7-7451-4729-94b3-e8f91ad2ffa6"],
Cell[107235, 2926, 452, 13, 35, "Input",ExpressionUUID->"a9c3599c-f3a2-42bc-8966-5b0635a364fb"],
Cell[107690, 2941, 172, 3, 43, "Text",ExpressionUUID->"92281682-ada1-4b5e-9dec-8147a8a4bfe7"],
Cell[107865, 2946, 218, 4, 43, "Text",ExpressionUUID->"6ea63998-f26d-402b-ab14-35992385506d"],
Cell[108086, 2952, 1366, 38, 60, "Input",ExpressionUUID->"b85a83e9-b36e-4d2e-95a6-fcc41d420256"],
Cell[109455, 2992, 1457, 42, 60, "Input",ExpressionUUID->"c0bbbd27-b879-4371-8897-fc817472a129"],
Cell[110915, 3036, 1461, 42, 60, "Input",ExpressionUUID->"775e27a0-aee4-4878-b0bf-7c44d239482b"],
Cell[112379, 3080, 390, 11, 35, "Input",ExpressionUUID->"23502f53-653f-4476-9345-db069a7d8ed3"],
Cell[112772, 3093, 1478, 42, 60, "Input",ExpressionUUID->"38378a08-7edf-4da7-9660-aca44ff628a5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114287, 3140, 217, 4, 56, "Subsubsection",ExpressionUUID->"39c51fdf-e51c-438b-b685-f314a4e4947a"],
Cell[114507, 3146, 1241, 28, 84, "Input",ExpressionUUID->"e95aab66-355b-40db-96b1-c23a91d07369"],
Cell[115751, 3176, 1227, 30, 84, "Input",ExpressionUUID->"a3b6dcb1-1883-4142-b806-a57aaac505ad"],
Cell[116981, 3208, 432, 10, 35, "Input",ExpressionUUID->"258bab00-2714-4111-982f-36e21bf278ff"],
Cell[117416, 3220, 1757, 46, 60, "Input",ExpressionUUID->"fcd27b93-8f7f-4005-bf0b-16cecc5d5571"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119210, 3271, 168, 3, 56, "Subsubsection",ExpressionUUID->"2ee1f8d9-b4d5-469d-a3a2-48644585ee7d"],
Cell[119381, 3276, 3323, 82, 276, "Input",ExpressionUUID->"3eeb0e51-ff48-45b2-8235-2338d5ff4843"],
Cell[122707, 3360, 519, 14, 35, "Input",ExpressionUUID->"ecdb6a15-bf86-4c06-aaa3-736658902793"],
Cell[123229, 3376, 519, 14, 35, "Input",ExpressionUUID->"170d0822-2d1f-4946-a5ae-b09fa218781d"],
Cell[123751, 3392, 574, 14, 35, "Input",ExpressionUUID->"06f16e52-0202-48b2-98cd-cc2b8162c1a1"],
Cell[124328, 3408, 520, 13, 35, "Input",ExpressionUUID->"2b7a641f-e7ae-4729-8adc-d3b0a1619561"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124885, 3426, 214, 4, 56, "Subsubsection",ExpressionUUID->"e829bea4-dbf5-471a-9b71-2ac6b5c227e8"],
Cell[125102, 3432, 216, 4, 43, "Text",ExpressionUUID->"e14b8369-8868-4cc4-a601-5296024af341"],
Cell[125321, 3438, 1632, 36, 108, "Input",ExpressionUUID->"ec4484cc-15ea-43f1-aea4-7ac810cc63ec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126990, 3479, 262, 4, 56, "Subsubsection",ExpressionUUID->"b581df21-4446-4396-892e-0da7a5c0b262"],
Cell[127255, 3485, 589, 15, 35, "Input",ExpressionUUID->"e79c5c96-df55-4dab-8d6e-ed3bfb6aa036"],
Cell[127847, 3502, 1029, 25, 84, "Input",ExpressionUUID->"c6ff13f5-3b77-4fc3-ad30-1a69d943bf0b"],
Cell[128879, 3529, 999, 24, 60, "Input",ExpressionUUID->"51ebeb07-049c-466f-9c6e-ad786d51f54f"],
Cell[129881, 3555, 1059, 25, 84, "Input",ExpressionUUID->"a16980fa-8604-4b25-8730-5af4a2414986"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[131001, 3587, 207, 4, 121, "Title",ExpressionUUID->"644a6aa5-cbd2-473d-88ac-0deace544432"],
Cell[CellGroupData[{
Cell[131233, 3595, 154, 3, 86, "Chapter",ExpressionUUID->"004c0b99-8609-4751-bf5e-0eb2c84cf6ed"],
Cell[CellGroupData[{
Cell[131412, 3602, 240, 4, 56, "Subsubsection",ExpressionUUID->"c9f35050-4567-4e76-a63f-a67674a95693"],
Cell[131655, 3608, 4509, 105, 276, "Input",ExpressionUUID->"9de3ae2e-b170-4184-ba32-a3923449f862"],
Cell[136167, 3715, 390, 7, 35, "Input",ExpressionUUID->"92d02842-2250-4294-b9a0-27c74981b5b1"],
Cell[136560, 3724, 3333, 75, 180, "Input",ExpressionUUID->"56f5f659-66bc-4428-97c0-2b9288dc0063"],
Cell[139896, 3801, 393, 7, 35, "Input",ExpressionUUID->"d1b7800f-5e26-4f5a-b5dc-eacc5f135664"],
Cell[140292, 3810, 4348, 103, 276, "Input",ExpressionUUID->"b727511d-5607-4376-afef-794f0f622a33"],
Cell[144643, 3915, 390, 7, 35, "Input",ExpressionUUID->"345c4524-c4bd-4167-aed0-24b92a4378f5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145070, 3927, 234, 4, 56, "Subsubsection",ExpressionUUID->"0ed5bfb7-aeb7-4d98-b576-12d49cbd86b9"],
Cell[145307, 3933, 722, 17, 43, "Text",ExpressionUUID->"e41d0d76-2ec5-4ac9-b37b-91d2f62b661e"],
Cell[146032, 3952, 813, 17, 35, "Input",ExpressionUUID->"952d58f8-eb3d-4754-8263-2a80eaba08d4"],
Cell[146848, 3971, 1202, 28, 108, "Input",ExpressionUUID->"b92291a9-a38f-44a4-9ae5-8268339394b2"],
Cell[148053, 4001, 2635, 64, 132, "Input",ExpressionUUID->"fccffba7-8206-4631-b53d-f7517588deb9"],
Cell[150691, 4067, 408, 8, 35, "Input",ExpressionUUID->"ab001014-d727-4eb6-8c23-63743fa7bd1d"],
Cell[151102, 4077, 2079, 57, 132, "Input",ExpressionUUID->"e0fd7a0e-e2ee-428d-8088-3d29695fd372"],
Cell[153184, 4136, 406, 8, 35, "Input",ExpressionUUID->"064c38aa-a805-43be-aab2-73f3d9b41bb6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[153627, 4149, 185, 3, 56, "Subsubsection",ExpressionUUID->"11375171-71cc-41f6-8453-e399bee610be"],
Cell[153815, 4154, 551, 15, 43, "Text",ExpressionUUID->"18587ed7-3f5e-4bed-967c-23ddae58d52f"],
Cell[154369, 4171, 558, 14, 35, "Input",ExpressionUUID->"9fbdbb34-93e7-4689-b566-81a83596f000"],
Cell[154930, 4187, 927, 24, 108, "Input",ExpressionUUID->"d54a4613-9cc7-4ed0-ae65-b1b9a709cfc9"],
Cell[155860, 4213, 2232, 62, 156, "Input",ExpressionUUID->"724a0466-fbe0-46e9-8b8a-3b30ecd017d6"],
Cell[158095, 4277, 406, 8, 35, "Input",ExpressionUUID->"66a6860c-dab9-43b5-b08d-64f904bc6818"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158538, 4290, 186, 3, 56, "Subsubsection",ExpressionUUID->"0e6d2dd2-0537-4b3d-a204-2db76bd5278f"],
Cell[158727, 4295, 2261, 54, 60, "Input",ExpressionUUID->"6440319d-e584-4d47-a3a3-56b878f8b264",
 CellID->125414378],
Cell[160991, 4351, 1402, 35, 84, "Input",ExpressionUUID->"e478d82b-0a20-42c0-9b37-496f5025ad85"],
Cell[162396, 4388, 325, 6, 35, "Input",ExpressionUUID->"df110def-4b7b-409f-a3c9-b305af7260af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162758, 4399, 184, 3, 56, "Subsubsection",ExpressionUUID->"4780abde-4d85-4694-baac-e4a1205977c5"],
Cell[162945, 4404, 580, 15, 35, "Input",ExpressionUUID->"f25ac3ca-0e00-4409-a962-cdf4d2ccfb80"],
Cell[163528, 4421, 2410, 55, 180, "Input",ExpressionUUID->"d12422e4-fd25-47d3-996d-9e52f5a0140a"],
Cell[165941, 4478, 277, 7, 35, "Input",ExpressionUUID->"437752c8-bf24-45a8-bb98-9348ccd1c701"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[166267, 4491, 159, 3, 86, "Chapter",ExpressionUUID->"9a131250-6a2d-416f-9b2e-5b130782d2dd"],
Cell[166429, 4496, 283, 6, 56, "Subsubsection",ExpressionUUID->"9d90d175-7161-43f7-b547-e71106e7e1d3"],
Cell[CellGroupData[{
Cell[166737, 4506, 280, 4, 45, "Subsubsection",ExpressionUUID->"e6d2fb1f-8cb4-4566-8edd-8d1419738bb5"],
Cell[167020, 4512, 552, 15, 35, "Input",ExpressionUUID->"36493308-508d-49fc-a05f-234c43d110b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167609, 4532, 333, 7, 89, "Subsubsection",ExpressionUUID->"bd6ff6b2-14b1-44b7-883e-d28e1d6b005a"],
Cell[167945, 4541, 632, 15, 35, "Input",ExpressionUUID->"9df425b0-f1dd-4a19-8bd7-59d63f883e25"],
Cell[168580, 4558, 581, 14, 35, "Input",ExpressionUUID->"4d6ba9a5-3e2e-4daa-acea-4760116af1a1"],
Cell[169164, 4574, 544, 16, 35, "Input",ExpressionUUID->"2224b2aa-e59f-41b5-885b-a5f2dad20ac4"],
Cell[169711, 4592, 157, 3, 43, "Text",ExpressionUUID->"8f784922-169d-4b60-a7bf-028bebd6c5a3"],
Cell[169871, 4597, 529, 16, 38, "Input",ExpressionUUID->"70c7031a-6c7f-4b6a-9f0f-66a2d6dc30ad"],
Cell[170403, 4615, 674, 17, 35, "Input",ExpressionUUID->"425a30aa-0032-4b37-99df-35d29d04daf0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[171114, 4637, 325, 5, 56, "Subsubsection",ExpressionUUID->"7e2b713a-cc02-4214-aee6-08a2d4171457"],
Cell[171442, 4644, 341, 7, 43, "Text",ExpressionUUID->"a5d53028-d0ad-496d-8ed3-91bdec2bf4b4"],
Cell[171786, 4653, 394, 9, 35, "Input",ExpressionUUID->"bd7837b3-ba06-4f7b-89c6-9dcc9f75b787"],
Cell[172183, 4664, 301, 9, 35, "Input",ExpressionUUID->"06dcdca6-1d0f-4ea3-a671-c44ea0022c6f"],
Cell[172487, 4675, 462, 13, 35, "Input",ExpressionUUID->"0129fb41-cfb1-4a31-875b-408404e73092"],
Cell[172952, 4690, 979, 25, 84, "Input",ExpressionUUID->"3f6a1ebe-0351-4b14-b5d9-78de83eae7ae"],
Cell[173934, 4717, 191, 4, 35, "Input",ExpressionUUID->"c4cb7eea-5b2a-47a9-8565-67a260332fbf"],
Cell[174128, 4723, 1274, 32, 140, "Input",ExpressionUUID->"d21222fe-fd6a-4373-bd1e-0a40c1b7f524"],
Cell[175405, 4757, 264, 6, 43, "Text",ExpressionUUID->"95acb202-a1e1-443e-80c3-2bbf98c1c1c1"],
Cell[175672, 4765, 796, 20, 38, "Input",ExpressionUUID->"b8cc1e3a-c99d-454f-8749-1288093aeac1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[176505, 4790, 284, 4, 56, "Subsubsection",ExpressionUUID->"c7c7f6dd-c62f-432a-9b02-dea63165c4ab"],
Cell[176792, 4796, 412, 9, 35, "Input",ExpressionUUID->"12808716-b3a0-4d07-935e-9ac1a531e99e"],
Cell[177207, 4807, 616, 13, 35, "Input",ExpressionUUID->"49797228-79ff-4ce2-9b0b-d70d62b96212"],
Cell[177826, 4822, 679, 17, 84, "Input",ExpressionUUID->"259d21c7-e196-4cb9-95fe-43d1d11ab59f"],
Cell[178508, 4841, 438, 12, 35, "Input",ExpressionUUID->"68efb01c-7e11-45c7-b107-212390bb567f"],
Cell[178949, 4855, 971, 29, 84, "Input",ExpressionUUID->"e36d4686-9686-437a-be70-4055438a6388"],
Cell[179923, 4886, 1502, 39, 156, "Input",ExpressionUUID->"18d7e62b-1d6f-480e-af7e-6f6b497a668d"],
Cell[181428, 4927, 998, 26, 44, "Input",ExpressionUUID->"8d636c8e-2970-4493-89e6-fe1c185eb405"]
}, Open  ]],
Cell[CellGroupData[{
Cell[182463, 4958, 249, 4, 56, "Subsubsection",ExpressionUUID->"60b172e8-aa08-490c-ad66-723deb684187"],
Cell[182715, 4964, 935, 24, 84, "Input",ExpressionUUID->"d1fc426e-d767-460e-bc95-e9dbbd2d8a97"],
Cell[183653, 4990, 246, 6, 35, "Input",ExpressionUUID->"2b8562b3-501e-4e89-a540-9d566679e945"],
Cell[183902, 4998, 336, 8, 35, "Input",ExpressionUUID->"2c894ae2-a0cd-4c92-94f8-40675cc36cb9"],
Cell[184241, 5008, 510, 13, 35, "Input",ExpressionUUID->"b5f948ee-559a-4d06-8d7c-f7ca4e4480f8"],
Cell[184754, 5023, 156, 3, 43, "Text",ExpressionUUID->"15036d89-f4fc-4555-ab2e-17f8e682661a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184947, 5031, 165, 3, 56, "Subsubsection",ExpressionUUID->"c7c4fc42-65e9-4411-a63f-4d035b501a45"],
Cell[185115, 5036, 282, 7, 35, "Input",ExpressionUUID->"2bff77ed-d907-456d-9f79-f7e0abec11d2"],
Cell[185400, 5045, 779, 20, 60, "Input",ExpressionUUID->"551691c5-87fd-403d-b34a-749d6c465cc6"],
Cell[186182, 5067, 992, 29, 35, "Input",ExpressionUUID->"a987d9b0-f781-4365-8cee-5421f244ee19"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187211, 5101, 298, 4, 56, "Subsubsection",ExpressionUUID->"1d310eb6-6685-4915-8459-9773d2620bc5"],
Cell[187512, 5107, 430, 12, 35, "Input",ExpressionUUID->"1ab8cbf1-3b5d-436e-8523-7a3833cabe36"],
Cell[187945, 5121, 1085, 32, 89, "Input",ExpressionUUID->"6740321f-e5a3-44bf-9223-b45af9bca7ad"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189067, 5158, 296, 4, 83, "Section",ExpressionUUID->"52be1dd3-b686-4b2b-a11d-a069ec2e5679"],
Cell[CellGroupData[{
Cell[189388, 5166, 214, 4, 56, "Subsubsection",ExpressionUUID->"29851799-5473-4ab6-a457-75fdbc164880"],
Cell[189605, 5172, 1376, 35, 84, "Input",ExpressionUUID->"7788ead9-b36d-4489-b73f-3c450a4612be"],
Cell[190984, 5209, 679, 20, 35, "Input",ExpressionUUID->"41af5e85-05fe-4559-9329-7aa20fed538a"],
Cell[191666, 5231, 212, 4, 43, "Text",ExpressionUUID->"15ae7ca6-ffa4-4a3d-947d-63f276a74155"],
Cell[191881, 5237, 1998, 54, 165, "Input",ExpressionUUID->"24d121be-a11d-4da3-8af9-7abf3563b589"],
Cell[193882, 5293, 703, 20, 43, "Input",ExpressionUUID->"47ce7a19-b59c-4555-ad54-01fed2dbad75"],
Cell[194588, 5315, 270, 8, 43, "Input",ExpressionUUID->"15ce9b16-4696-48a5-a8f9-525ad7ed9b53"],
Cell[194861, 5325, 274, 7, 43, "Input",ExpressionUUID->"c569c74e-53e1-4e9c-bea4-7ae9a9dba0f3"],
Cell[195138, 5334, 275, 7, 43, "Input",ExpressionUUID->"52f0ccc8-904e-4ee8-8fe3-590dde27611f"],
Cell[195416, 5343, 620, 18, 43, "Input",ExpressionUUID->"c98a3ac2-9937-4ec9-8191-fcfe8d0a46af"],
Cell[196039, 5363, 599, 18, 43, "Input",ExpressionUUID->"04bd681a-aa94-40d4-89b6-60cc85fcd2d3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196675, 5386, 248, 5, 70, "Subsubsection",ExpressionUUID->"fb4f8094-8372-4749-8cee-1b985f616bec"],
Cell[196926, 5393, 473, 13, 43, "Input",ExpressionUUID->"8016d5b8-3588-467e-b4e0-141bac471e7d"],
Cell[197402, 5408, 376, 10, 43, "Input",ExpressionUUID->"cfdd897b-d158-43f3-88ae-8ce57975134f"],
Cell[197781, 5420, 391, 11, 43, "Input",ExpressionUUID->"d70ac236-fe42-4619-87b6-2174f72ac04b"],
Cell[198175, 5433, 393, 11, 43, "Input",ExpressionUUID->"89ecded9-6fbe-4f38-a491-fef243791e63"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198605, 5449, 295, 5, 70, "Subsubsection",ExpressionUUID->"ea4eb9a0-c79f-4b03-bea1-0fa417338b3e"],
Cell[198903, 5456, 445, 12, 43, "Input",ExpressionUUID->"5c7f8693-5a75-4b51-92b7-1e33b1cfa451"],
Cell[199351, 5470, 491, 13, 43, "Input",ExpressionUUID->"93e2e6cb-3596-4efc-beff-82cd87002e99"],
Cell[199845, 5485, 567, 15, 62, "Input",ExpressionUUID->"8de2fff0-acbe-4f82-bed1-ca5c018c90ad"],
Cell[200415, 5502, 542, 14, 62, "Input",ExpressionUUID->"5c600d11-f0fe-47eb-94ec-d9651e624b7e"],
Cell[200960, 5518, 665, 18, 75, "Input",ExpressionUUID->"ffe2db4c-5b9d-401b-bc24-49126b41aaa7"],
Cell[201628, 5538, 683, 20, 75, "Input",ExpressionUUID->"92c3c69a-ee01-4648-bedb-17d3a3c3e8f2"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[202384, 5566, 210, 4, 87, "Title",ExpressionUUID->"bcdf597f-fe59-4f80-880d-43aa68eec81c"],
Cell[CellGroupData[{
Cell[202619, 5574, 154, 3, 107, "Chapter",ExpressionUUID->"6f098ca5-476c-4812-98bb-77b23c7f1b96"],
Cell[CellGroupData[{
Cell[202798, 5581, 331, 5, 98, "Subchapter",ExpressionUUID->"71191337-4aeb-4507-8560-9ebcce713e48"],
Cell[CellGroupData[{
Cell[203154, 5590, 184, 3, 70, "Subsubsection",ExpressionUUID->"5d6e4062-9b80-422e-90e3-16561f9564d5"],
Cell[203341, 5595, 5258, 139, 495, "Input",ExpressionUUID->"28b97972-9704-4d78-825f-9908c6e3d8e3"],
Cell[208602, 5736, 380, 7, 43, "Input",ExpressionUUID->"12b73b5c-0e5c-440e-a7d7-30f8f388faf4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[209019, 5748, 184, 3, 70, "Subsubsection",ExpressionUUID->"bf25bc44-aff5-40d4-adef-9085f176e2df"],
Cell[209206, 5753, 1972, 45, 135, "Input",ExpressionUUID->"7527b3d6-0a40-41a1-a13d-5fb78545058f"],
Cell[211181, 5800, 347, 6, 43, "Input",ExpressionUUID->"1eec6799-40da-4da0-9ae0-dfd623c108c4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[211565, 5811, 184, 3, 70, "Subsubsection",ExpressionUUID->"29295aa4-cff8-45e2-8078-2088429e23fc"],
Cell[211752, 5816, 1880, 48, 281, "Input",ExpressionUUID->"9da814cd-393f-411c-9b5d-cb71d673c047"],
Cell[213635, 5866, 4255, 111, 435, "Input",ExpressionUUID->"57f60476-22a2-4a7f-8fe3-171c7457ba97"],
Cell[217893, 5979, 347, 6, 43, "Input",ExpressionUUID->"4944ee24-c2c4-4dad-818c-08f5b0308aef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218277, 5990, 186, 3, 70, "Subsubsection",ExpressionUUID->"00b2e660-6493-40d2-b296-3b0605d607b1"],
Cell[218466, 5995, 1026, 24, 105, "Input",ExpressionUUID->"e20a7b1c-f2ba-460c-9d2f-082d97199a07"],
Cell[219495, 6021, 301, 8, 43, "Input",ExpressionUUID->"50a16243-b454-48a9-b90b-02e8acf591b4"],
Cell[219799, 6031, 972, 24, 105, "Input",ExpressionUUID->"344f7429-668c-42ea-af51-ca479abebb3d"],
Cell[220774, 6057, 298, 6, 43, "Input",ExpressionUUID->"d4f61544-0aba-45d5-a322-d77939cca9ed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[221109, 6068, 186, 3, 70, "Subsubsection",ExpressionUUID->"7fc02df2-a23f-48ea-958d-74ee85ed242f"],
Cell[221298, 6073, 377, 9, 43, "Input",ExpressionUUID->"a74986ce-c2f3-488f-b9d0-b6b26d90f308"],
Cell[221678, 6084, 1143, 27, 105, "Input",ExpressionUUID->"3920eaeb-e940-4a67-a0b2-a690a6af8129"],
Cell[222824, 6113, 341, 6, 43, "Input",ExpressionUUID->"0bef21aa-7fd6-4033-88f6-9a6f42a49bd8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[223202, 6124, 184, 3, 70, "Subsubsection",ExpressionUUID->"539ffc67-fe61-40a7-82e1-3f5adf527bbd"],
Cell[223389, 6129, 401, 11, 43, "Input",ExpressionUUID->"2d3ec95a-8df0-4dfc-bcdc-12e0c32de205"],
Cell[223793, 6142, 277, 7, 43, "Input",ExpressionUUID->"bd6e9e2d-ee84-4ecc-9d49-a32c64cc05e0"],
Cell[224073, 6151, 792, 18, 43, "Input",ExpressionUUID->"1563a8cf-5992-48c1-8744-59eddcc97808"],
Cell[224868, 6171, 5566, 139, 465, "Input",ExpressionUUID->"d6866011-8c85-487c-a491-45d7812084ee"],
Cell[230437, 6312, 344, 6, 43, "Input",ExpressionUUID->"bbc12566-5a0b-4621-b067-44a2af712f6c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[230818, 6323, 183, 3, 70, "Subsubsection",ExpressionUUID->"377e7ad3-a916-420d-8b6e-674f06669b82"],
Cell[231004, 6328, 1201, 29, 105, "Input",ExpressionUUID->"67e440bd-62d8-49ac-ad9b-7f88ec64a34a"],
Cell[232208, 6359, 431, 8, 43, "Input",ExpressionUUID->"b6b37e64-7657-4f39-962d-47570f4009b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[232676, 6372, 186, 3, 70, "Subsubsection",ExpressionUUID->"a0980852-39f4-47df-a38b-baf88111c455"],
Cell[232865, 6377, 981, 26, 46, "Input",ExpressionUUID->"cea98ac9-7b67-449e-9c41-79f985299b9a"],
Cell[233849, 6405, 304, 8, 43, "Input",ExpressionUUID->"9060892b-c721-45f1-a730-53d5b3e0deee"],
Cell[234156, 6415, 1005, 25, 135, "Input",ExpressionUUID->"ed0f93d5-9557-4f5b-aec1-3f910e950eb4"],
Cell[235164, 6442, 312, 6, 43, "Input",ExpressionUUID->"647ff4a0-cff7-4cc1-acb0-da88007662e3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[235537, 6455, 159, 3, 107, "Chapter",ExpressionUUID->"7d03d53b-bfc8-4750-a8db-315a45d9d3b0"],
Cell[CellGroupData[{
Cell[235721, 6462, 164, 3, 70, "Subsubsection",ExpressionUUID->"8d143937-1404-4bdd-9418-6386282a8dd1"],
Cell[235888, 6467, 312, 8, 43, "Input",ExpressionUUID->"7c4c841a-95ca-4e9e-ae1d-54ea36500abc"],
Cell[236203, 6477, 434, 13, 43, "Input",ExpressionUUID->"f5258ae4-2075-4ee6-9ec0-fec843513327"],
Cell[236640, 6492, 226, 5, 53, "Text",ExpressionUUID->"09009ec2-8c87-4c39-9a1e-5ce393c49f1c"],
Cell[236869, 6499, 814, 26, 75, "Input",ExpressionUUID->"078a3e40-07ee-4bd0-bd25-0ce85f8e11f0"],
Cell[237686, 6527, 291, 8, 43, "Input",ExpressionUUID->"9cc7b30e-72dc-4019-9797-a5c1e5a4298a"],
Cell[237980, 6537, 812, 25, 75, "Input",ExpressionUUID->"2e7fc78f-9bdf-4f86-97e3-1ee40add7d9b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[238829, 6567, 165, 3, 70, "Subsubsection",ExpressionUUID->"1bb6a8b7-1419-4408-ae28-97cbe72b54d3"],
Cell[238997, 6572, 320, 8, 43, "Input",ExpressionUUID->"a4d09fb5-7926-419a-b5d6-9c76854b8e3f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[239354, 6585, 190, 3, 70, "Subsubsection",ExpressionUUID->"abe802fc-62bc-446b-b076-cb3bdd684ed5"],
Cell[239547, 6590, 737, 23, 47, "Input",ExpressionUUID->"08bd5827-a0fe-4708-808d-00faf898fc9a"],
Cell[240287, 6615, 518, 17, 47, "Input",ExpressionUUID->"b9486378-46ef-4001-b65e-94f23c17321d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[240842, 6637, 167, 3, 70, "Subsubsection",ExpressionUUID->"c2a0c90b-62c4-4d24-93df-ae713a8d0274"],
Cell[241012, 6642, 932, 24, 81, "Input",ExpressionUUID->"49e837c9-2c90-4eaa-8838-698dc5c033ee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[241981, 6671, 216, 4, 70, "Subsubsection",ExpressionUUID->"600e2995-d231-4317-827e-65a6b6f2403b"],
Cell[242200, 6677, 1055, 26, 77, "Input",ExpressionUUID->"290ae7f4-1df4-45e6-9530-66bede5ec6e1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[243292, 6708, 190, 3, 70, "Subsubsection",ExpressionUUID->"672e7efb-e24c-4980-9e30-cd44c27363ec"],
Cell[243485, 6713, 841, 22, 47, "Input",ExpressionUUID->"785ffd0a-7f6a-40ce-8a81-08f33a8396c1"],
Cell[244329, 6737, 589, 16, 43, "Input",ExpressionUUID->"931feb7d-c908-4c9a-99f0-41baecbf910f"],
Cell[244921, 6755, 454, 12, 43, "Input",ExpressionUUID->"6e564c51-e2d8-4792-ae47-7e5d1f4da99e"],
Cell[245378, 6769, 382, 9, 43, "Input",ExpressionUUID->"dc2b4014-1111-4331-a171-1ed9d568fd14"],
Cell[245763, 6780, 465, 12, 43, "Input",ExpressionUUID->"4a456977-2607-4b9e-ad4b-7720b294c9b3"],
Cell[246231, 6794, 220, 5, 53, "Text",ExpressionUUID->"709723c4-f103-4fd8-bfdc-831de0aaf846"],
Cell[246454, 6801, 1437, 36, 105, "Input",ExpressionUUID->"28dc5e71-984f-419a-9257-617df71ed23e"],
Cell[247894, 6839, 174, 3, 53, "Text",ExpressionUUID->"e7ae6404-41f3-4f3b-95d2-8a9209677866"],
Cell[248071, 6844, 392, 10, 43, "Input",ExpressionUUID->"bf387967-7985-46d5-99b2-1d03788ea297"],
Cell[248466, 6856, 1139, 33, 81, "Input",ExpressionUUID->"1d28c2f3-9627-47fa-b0c8-090591d0cac0"],
Cell[249608, 6891, 229, 4, 53, "Text",ExpressionUUID->"97dd7bf5-2228-40aa-bcc4-696b55ede144"]
}, Open  ]],
Cell[CellGroupData[{
Cell[249874, 6900, 218, 4, 70, "Subsubsection",ExpressionUUID->"e4f8321e-aabb-42d6-b2e6-36310003c50a"],
Cell[250095, 6906, 1003, 27, 47, "Input",ExpressionUUID->"2ca7d1e0-2ff8-4082-b0ac-75b31a67e8e6"],
Cell[251101, 6935, 926, 31, 88, "Input",ExpressionUUID->"3a28823b-de0c-49f7-9c7a-3519a00088e0"],
Cell[252030, 6968, 752, 22, 81, "Input",ExpressionUUID->"40e663f3-19a4-412c-a1e4-a745130eb06f"],
Cell[252785, 6992, 787, 21, 123, "Text",ExpressionUUID->"f81b3387-bad6-4d82-b333-614d7faf3566"]
}, Open  ]],
Cell[CellGroupData[{
Cell[253609, 7018, 167, 3, 70, "Subsubsection",ExpressionUUID->"599ebded-a16d-44b3-a9ce-ae6fbbad6074"],
Cell[253779, 7023, 216, 5, 53, "Text",ExpressionUUID->"1252a6c6-c7c0-4bf9-abb7-1c225e09e903"],
Cell[253998, 7030, 608, 13, 43, "Input",ExpressionUUID->"18c3bd32-132a-4447-a5b3-cffcce55412f"],
Cell[254609, 7045, 539, 15, 43, "Input",ExpressionUUID->"7c725d25-72a3-4488-bd63-fd648dd31f0d"],
Cell[255151, 7062, 453, 11, 43, "Input",ExpressionUUID->"76957c4a-377d-4460-8910-8dcc5b4c8a06"]
}, Open  ]],
Cell[CellGroupData[{
Cell[255641, 7078, 165, 3, 70, "Subsubsection",ExpressionUUID->"dd6947ba-0593-47f0-a817-3cdcf270bbdf"],
Cell[255809, 7083, 358, 8, 43, "Input",ExpressionUUID->"09106187-ef25-4743-82b3-8f2d6bde1fa4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[256204, 7096, 216, 4, 70, "Subsubsection",ExpressionUUID->"4e151619-2f63-4ffb-aa60-a6f48e39a7ac"],
Cell[256423, 7102, 507, 11, 43, "Input",ExpressionUUID->"e438f593-73d8-454c-a550-d6d955bd314b"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[256991, 7120, 257, 4, 87, "Title",ExpressionUUID->"13ec504a-9ea2-4484-92fb-f7972e86bbb1"],
Cell[CellGroupData[{
Cell[257273, 7128, 154, 3, 107, "Chapter",ExpressionUUID->"4d38b30a-344c-453c-8370-3baf6a970db3"],
Cell[CellGroupData[{
Cell[257452, 7135, 184, 3, 70, "Subsubsection",ExpressionUUID->"3472313c-d537-4a8a-a20c-7fbe8abc66bf"],
Cell[257639, 7140, 2138, 48, 135, "Input",ExpressionUUID->"1489ea29-3c6d-4083-8ebb-16ef993b0803"],
Cell[259780, 7190, 2430, 56, 165, "Input",ExpressionUUID->"a269a150-d48b-4ce3-af66-5aaaff7bc18e"],
Cell[262213, 7248, 349, 7, 43, "Input",ExpressionUUID->"e469829c-12c0-4f1b-acfc-13fc1a059be8"],
Cell[262565, 7257, 5076, 125, 345, "Input",ExpressionUUID->"65ab2452-d12f-4e67-a3cc-09a8417ad059"],
Cell[267644, 7384, 356, 7, 43, "Input",ExpressionUUID->"fc26ec23-6aa9-43f9-8ca0-abbbbd593d1a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[268037, 7396, 184, 3, 70, "Subsubsection",ExpressionUUID->"6490bc86-6928-4ec2-9ec3-8521cfa5b922"],
Cell[268224, 7401, 918, 24, 110, "Input",ExpressionUUID->"46ca7ba4-fd00-4fc2-b57a-3f10bcd5595d"],
Cell[269145, 7427, 294, 6, 43, "Input",ExpressionUUID->"f092f491-59c3-4e88-93c5-788b6ac222b0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[269476, 7438, 188, 3, 70, "Subsubsection",ExpressionUUID->"c12d753c-2aab-4023-9ce3-fa532a460061"],
Cell[269667, 7443, 846, 21, 75, "Input",ExpressionUUID->"8eeec56b-4b62-4928-b922-d69029148744"],
Cell[270516, 7466, 291, 6, 43, "Input",ExpressionUUID->"bedb4de6-c2ba-4c30-a5b1-27b8f3d477c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[270844, 7477, 186, 3, 70, "Subsubsection",ExpressionUUID->"a33dd808-ba43-4ec1-baec-3d2642819c8f"],
Cell[271033, 7482, 1087, 26, 105, "Input",ExpressionUUID->"4ceeefaa-9f13-41e8-95e0-59d067fa4807"],
Cell[272123, 7510, 294, 6, 43, "Input",ExpressionUUID->"39453167-1e66-42e2-b88e-5d392acf3b9d"],
Cell[272420, 7518, 1483, 37, 135, "Input",ExpressionUUID->"5ff11107-aed7-4608-b835-0d6d35a4e3ec"],
Cell[273906, 7557, 328, 6, 43, "Input",ExpressionUUID->"14a276a7-e89d-4add-9379-5bd50d774dd5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[274271, 7568, 184, 3, 70, "Subsubsection",ExpressionUUID->"12d554b9-d1e1-4dc0-861a-92056c319572"],
Cell[274458, 7573, 1994, 52, 195, "Input",ExpressionUUID->"73cd7896-5338-4de3-bd58-d70ee1142418",
 CellID->333142762],
Cell[276455, 7627, 335, 8, 75, "Input",ExpressionUUID->"1e9b7cb4-a1dd-4178-a7a4-c60a695cfe36"]
}, Open  ]],
Cell[CellGroupData[{
Cell[276827, 7640, 186, 3, 70, "Subsubsection",ExpressionUUID->"26fc109e-9b7f-4286-8c5d-ccb19552846a"],
Cell[277016, 7645, 2342, 57, 195, "Input",ExpressionUUID->"725c1ebe-1fac-49ba-b86d-765e005a9980"],
Cell[279361, 7704, 342, 6, 43, "Input",ExpressionUUID->"39d096b5-d708-4f3c-b33a-71c658fa93d8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[279740, 7715, 185, 3, 70, "Subsubsection",ExpressionUUID->"2b5c5d14-1a75-405c-8adb-01f4aec55082"],
Cell[279928, 7720, 1473, 31, 75, "Input",ExpressionUUID->"c3570fc1-b341-41cc-a06a-68e1dc3fddd5"],
Cell[281404, 7753, 2342, 55, 165, "Input",ExpressionUUID->"c0cfcc0c-4b23-4b15-9a50-b9f0466ef3ac"],
Cell[283749, 7810, 295, 6, 43, "Input",ExpressionUUID->"67e7e987-1b4b-49f3-bbd0-f084a26848ea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[284081, 7821, 184, 3, 70, "Subsubsection",ExpressionUUID->"6992ea7f-7e1e-4e0e-8c11-b81be8033ecc"],
Cell[284268, 7826, 1147, 25, 105, "Input",ExpressionUUID->"feb73613-3653-4e08-b4a7-d99c9a470e43"],
Cell[285418, 7853, 311, 7, 43, "Input",ExpressionUUID->"369ef10c-efd2-4cb8-a4fc-dbbaecc17001"]
}, Open  ]],
Cell[CellGroupData[{
Cell[285766, 7865, 184, 3, 70, "Subsubsection",ExpressionUUID->"1264d9e1-0864-40c2-91a4-5d00875a3000"],
Cell[285953, 7870, 1083, 26, 75, "Input",ExpressionUUID->"db063798-bf0c-484f-a786-c061a0fdf1ca"],
Cell[287039, 7898, 294, 6, 43, "Input",ExpressionUUID->"4edb6ec7-1660-43d3-afcb-f90bec18be8a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[287370, 7909, 189, 3, 70, "Subsubsection",ExpressionUUID->"11c154d5-b343-443e-ac49-e88b36bcc8c3"],
Cell[287562, 7914, 522, 13, 43, "Input",ExpressionUUID->"b1d64e82-7626-4641-be75-e377f552be63"],
Cell[288087, 7929, 3741, 99, 195, "Input",ExpressionUUID->"e054dd7a-e58b-4f41-8a54-2eccd1b01299"],
Cell[291831, 8030, 292, 6, 43, "Input",ExpressionUUID->"be3492bd-64c1-45b1-bc01-f4aaccfec0af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[292160, 8041, 190, 4, 70, "Subsubsection",ExpressionUUID->"1742d999-f196-4268-91ef-d30cc267291e"],
Cell[292353, 8047, 1083, 27, 75, "Input",ExpressionUUID->"29d51e7f-42e2-4dd9-88ab-0a3c1890ddec"],
Cell[293439, 8076, 1312, 37, 165, "Input",ExpressionUUID->"d7d45f2a-4b17-47f4-88de-3907d7ca6844"],
Cell[294754, 8115, 289, 6, 43, "Input",ExpressionUUID->"a5e7ecf7-4859-4352-a92f-c08933fd02ad"]
}, Open  ]],
Cell[CellGroupData[{
Cell[295080, 8126, 185, 3, 70, "Subsubsection",ExpressionUUID->"bec0a47c-c4ad-4941-8be5-3859957c554b"],
Cell[295268, 8131, 882, 16, 75, "Input",ExpressionUUID->"d2c56977-958e-4362-a28c-58758f22e088"],
Cell[296153, 8149, 288, 6, 43, "Input",ExpressionUUID->"0dad1e3e-da37-4028-9092-9f563ac690e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[296478, 8160, 185, 3, 70, "Subsubsection",ExpressionUUID->"d11b8c07-0d8f-4c92-9894-9054b6f00bbb"],
Cell[296666, 8165, 1171, 32, 105, "Input",ExpressionUUID->"5b3e74db-8049-4c77-9254-8e8f9cbc1736"],
Cell[297840, 8199, 296, 6, 43, "Input",ExpressionUUID->"0b135ee5-18e1-41c8-8fa2-698117378e53"]
}, Open  ]],
Cell[CellGroupData[{
Cell[298173, 8210, 189, 3, 70, "Subsubsection",ExpressionUUID->"7472bd12-ffda-48b1-a2ae-c68c90ecf42f"],
Cell[298365, 8215, 1170, 27, 75, "Input",ExpressionUUID->"fabde943-ce9d-46ad-9718-48a8a4a5a82e"],
Cell[299538, 8244, 297, 6, 43, "Input",ExpressionUUID->"84cd5c77-dc96-4aae-852b-24510f93bf25"]
}, Open  ]],
Cell[CellGroupData[{
Cell[299872, 8255, 187, 3, 70, "Subsubsection",ExpressionUUID->"20680bc3-b96e-42e2-9667-3592c5f5520c"],
Cell[300062, 8260, 883, 22, 75, "Input",ExpressionUUID->"d6eba4be-767b-4aa6-a18f-fdbaa0316350"],
Cell[300948, 8284, 295, 6, 43, "Input",ExpressionUUID->"54a3fbf0-1f74-4056-8865-d4b7268d0ffd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[301292, 8296, 159, 3, 107, "Chapter",ExpressionUUID->"d1b72095-b9f1-4c34-8738-77ff09979b5c"],
Cell[301454, 8301, 520, 13, 43, "Input",ExpressionUUID->"0d953a14-5fd3-4328-9ea6-a3457bb582cc"],
Cell[301977, 8316, 567, 14, 43, "Input",ExpressionUUID->"b1c6fa10-fb69-4a7d-9187-faf8c0e2d242"],
Cell[302547, 8332, 556, 15, 43, "Input",ExpressionUUID->"9023057a-f530-4b6b-b0cf-1a9dc473d49a"],
Cell[303106, 8349, 717, 15, 43, "Input",ExpressionUUID->"3bfa35fa-f40e-4df0-8a88-7002ea8f575b"],
Cell[303826, 8366, 617, 12, 43, "Input",ExpressionUUID->"aded7be7-f2ce-45ac-85f6-55fdcc3cfbe2"],
Cell[CellGroupData[{
Cell[304468, 8382, 163, 3, 70, "Subsubsection",ExpressionUUID->"768dd80c-53ab-4ebb-bd37-8cc85f275204"],
Cell[304634, 8387, 540, 14, 43, "Input",ExpressionUUID->"2dd44c52-5a11-49b9-bc64-e4d412ed247d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[305211, 8406, 165, 3, 70, "Subsubsection",ExpressionUUID->"b9939d78-d170-4495-9365-655f08f42ea8"],
Cell[305379, 8411, 882, 23, 75, "Input",ExpressionUUID->"b710d0ba-1a6e-4ce9-be46-8394799a7442"],
Cell[306264, 8436, 272, 7, 43, "Input",ExpressionUUID->"4d6ea6e7-dbe8-4b6d-9614-5511f445d878"]
}, Open  ]],
Cell[CellGroupData[{
Cell[306573, 8448, 218, 4, 70, "Subsubsection",ExpressionUUID->"d874666f-9ab9-4246-a208-af0582064b5a"],
Cell[306794, 8454, 859, 22, 75, "Input",ExpressionUUID->"71a5d31b-5025-4b8c-b894-4301a7c2efe4"],
Cell[307656, 8478, 476, 12, 43, "Input",ExpressionUUID->"eef09176-fa6a-4a35-b510-9c91d9c136db"]
}, Open  ]],
Cell[CellGroupData[{
Cell[308169, 8495, 163, 3, 70, "Subsubsection",ExpressionUUID->"c8ea18dd-6743-4731-8c37-58ca58cfd2fd"],
Cell[308335, 8500, 805, 23, 75, "Input",ExpressionUUID->"f9532ffd-4c67-4c75-8706-47428b2f4e2c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[309177, 8528, 264, 4, 70, "Subsubsection",ExpressionUUID->"6714a319-4aec-4c0a-9239-f0a5194f5543"],
Cell[309444, 8534, 860, 24, 75, "Input",ExpressionUUID->"510acac3-45a4-4016-a4b9-3f248714098b"],
Cell[310307, 8560, 860, 24, 75, "Input",ExpressionUUID->"0bbd9f76-6843-4b0b-9ac7-6ddd00cd04e4"],
Cell[311170, 8586, 643, 19, 47, "Input",ExpressionUUID->"b5ef6688-299b-4342-b859-0825250363a5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[311850, 8610, 216, 4, 70, "Subsubsection",ExpressionUUID->"863ea350-1541-414b-a7e5-d909d7346a88"],
Cell[312069, 8616, 1122, 26, 75, "Input",ExpressionUUID->"1be2b678-e484-4049-b10c-07141e262adf"],
Cell[313194, 8644, 1743, 36, 105, "Input",ExpressionUUID->"f29160f7-845c-4552-b91a-d20f93f3acb6"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[314998, 8687, 257, 4, 87, "Title",ExpressionUUID->"9d321898-a020-4950-9882-cd524bdfd4bd"],
Cell[CellGroupData[{
Cell[315280, 8695, 154, 3, 107, "Chapter",ExpressionUUID->"4972cdba-19e5-44fa-bb9d-1d98fb6e1e75"],
Cell[CellGroupData[{
Cell[315459, 8702, 186, 3, 70, "Subsubsection",ExpressionUUID->"3f1609a9-bdf8-4b47-9a50-1a20a65bab13"],
Cell[315648, 8707, 906, 25, 75, "Input",ExpressionUUID->"576f0dff-27f1-4c9c-b988-a93fba43d861"],
Cell[316557, 8734, 316, 8, 43, "Input",ExpressionUUID->"1d7eee88-90ee-4bce-b019-d6bd4df2447a"],
Cell[316876, 8744, 735, 20, 105, "Input",ExpressionUUID->"5c6eb377-ea7d-4f99-b8d8-bc79f0cfd1bb"],
Cell[317614, 8766, 1154, 30, 105, "Input",ExpressionUUID->"57111269-2e02-4926-b9b4-cd65d4be5412"],
Cell[318771, 8798, 296, 6, 43, "Input",ExpressionUUID->"51546a36-8403-4094-b92f-dd45911c896f"],
Cell[319070, 8806, 2822, 81, 296, "Input",ExpressionUUID->"df503c34-c3be-4e47-878f-7edd0e321d1b"],
Cell[321895, 8889, 745, 23, 100, "Input",ExpressionUUID->"fc6175e2-28a1-47d4-93c2-7023c6514fb6"],
Cell[322643, 8914, 3637, 89, 311, "Input",ExpressionUUID->"3764497d-19ba-44a2-8058-c26706686dc0"],
Cell[326283, 9005, 295, 6, 43, "Input",ExpressionUUID->"f4dbc531-fc37-49c8-b9cc-d0cf9d787445"]
}, Open  ]],
Cell[CellGroupData[{
Cell[326615, 9016, 182, 3, 70, "Subsubsection",ExpressionUUID->"e15fb3de-2766-4543-a447-f3ebe64b3db3"],
Cell[326800, 9021, 1179, 32, 75, "Input",ExpressionUUID->"0c6dd3ed-d699-4fa7-ae1b-6a3539b4037a"],
Cell[327982, 9055, 296, 6, 43, "Input",ExpressionUUID->"69cbbabb-2392-4741-9a39-af0c5e42c02a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[328315, 9066, 182, 3, 70, "Subsubsection",ExpressionUUID->"dd61a2dc-817d-44e4-80ff-f0e5a72d30e5"],
Cell[328500, 9071, 352, 8, 43, "Input",ExpressionUUID->"266cae3e-c127-4a6a-8319-7b5e3173df07"],
Cell[328855, 9081, 648, 15, 43, "Input",ExpressionUUID->"ef18e903-3bd9-41b7-a67d-cea5c9024ea1"],
Cell[329506, 9098, 302, 6, 43, "Input",ExpressionUUID->"3acae987-f72d-4758-bc54-acc82fe6697f"],
Cell[329811, 9106, 1154, 30, 165, "Input",ExpressionUUID->"561a33f1-61bd-42af-b882-35fa7f82a9a9"],
Cell[330968, 9138, 296, 6, 43, "Input",ExpressionUUID->"e771617e-8f60-4f48-bf3d-800d455d6175"]
}, Open  ]],
Cell[CellGroupData[{
Cell[331301, 9149, 184, 3, 70, "Subsubsection",ExpressionUUID->"01d04d34-1ca8-4c2a-a4b1-534d1ad8a921"],
Cell[331488, 9154, 374, 8, 88, "Text",ExpressionUUID->"6b4ba302-aac6-43c9-b616-de46f4206475"],
Cell[331865, 9164, 578, 14, 75, "Input",ExpressionUUID->"e9219eba-a1cd-403d-8b88-4b9e557a0546"],
Cell[332446, 9180, 350, 9, 43, "Input",ExpressionUUID->"bbcd9e30-042e-4469-8a59-16a97cc0dfe4"],
Cell[332799, 9191, 1317, 38, 81, "Input",ExpressionUUID->"d8b806ff-4ea8-4ee7-adc1-2c82fb74a7b0"],
Cell[334119, 9231, 1271, 30, 75, "Input",ExpressionUUID->"e3686549-5ca7-4182-8d71-91c9050cfeff"],
Cell[335393, 9263, 354, 7, 43, "Input",ExpressionUUID->"fb660d44-7057-4303-a96d-9be646786996"],
Cell[335750, 9272, 2065, 48, 115, "Input",ExpressionUUID->"317c95a3-e698-4c30-9018-29391fb45dcf"],
Cell[337818, 9322, 1632, 35, 75, "Input",ExpressionUUID->"dd5db4f6-412f-4d61-a724-592f71be6ff5"],
Cell[339453, 9359, 308, 7, 43, "Input",ExpressionUUID->"4f7fafb3-ba64-41ab-9c36-b48ff67b1fe5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[339798, 9371, 183, 3, 70, "Subsubsection",ExpressionUUID->"726e0960-448b-4d27-a18f-dfe61a82c819"],
Cell[339984, 9376, 2109, 51, 195, "Input",ExpressionUUID->"047bf6ba-9eca-4e00-a66f-f1fd17e6fea0"],
Cell[342096, 9429, 307, 7, 43, "Input",ExpressionUUID->"c4cee7e4-0a0f-4dbc-a4e4-54523d079407"]
}, Open  ]],
Cell[CellGroupData[{
Cell[342440, 9441, 180, 2, 70, "Subsubsection",ExpressionUUID->"885a47d8-4388-4f43-bbb2-15b39056ccdd"],
Cell[342623, 9445, 346, 7, 43, "Input",ExpressionUUID->"2b2bf2f1-8b2e-45d1-a196-413410e93295"],
Cell[342972, 9454, 694, 19, 47, "Input",ExpressionUUID->"8f594a11-e057-4783-a00b-b1785b27275d"],
Cell[343669, 9475, 1607, 36, 115, "Input",ExpressionUUID->"91ca0b2d-0589-4cbc-8bd8-a89308edf588"],
Cell[345279, 9513, 304, 7, 43, "Input",ExpressionUUID->"15659a3b-f9e4-4769-8422-4e7514c266de"],
Cell[345586, 9522, 551, 15, 47, "Input",ExpressionUUID->"aaaf0a13-e7ce-4ab6-a640-ece62f847b49"],
Cell[346140, 9539, 1734, 48, 81, "Input",ExpressionUUID->"870154e8-fc5d-4a7b-b2e2-6975089606c4"],
Cell[347877, 9589, 2245, 51, 143, "Input",ExpressionUUID->"22948f73-0049-4ad1-a8bb-526581aa9593"],
Cell[350125, 9642, 180, 3, 53, "Text",ExpressionUUID->"ee93a177-6842-4739-b166-a223013ccfb3"],
Cell[350308, 9647, 304, 7, 43, "Input",ExpressionUUID->"ac92e434-46f2-48bf-8576-817474afd1a5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[350649, 9659, 186, 3, 70, "Subsubsection",ExpressionUUID->"e48b8529-3045-45b9-ad78-ad26183e7d1f"],
Cell[350838, 9664, 3983, 122, 345, "Input",ExpressionUUID->"5fe5d309-4fdf-4528-a0df-6b250e137431"],
Cell[354824, 9788, 994, 27, 75, "Input",ExpressionUUID->"a2ff8867-e495-42ff-a7f2-ce3e8d77b319"],
Cell[355821, 9817, 305, 7, 43, "Input",ExpressionUUID->"46770fb7-03d2-4626-a69b-3fc1f9121f1f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[356163, 9829, 186, 3, 70, "Subsubsection",ExpressionUUID->"1142e1f9-ab16-401b-9f3f-d34546389cec"],
Cell[356352, 9834, 654, 17, 75, "Input",ExpressionUUID->"5ee36278-a3a5-4267-97f1-515d07dcf191"],
Cell[357009, 9853, 342, 6, 43, "Input",ExpressionUUID->"54be22fc-dac9-47c0-af17-882bec7cb34d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[357400, 9865, 212, 4, 107, "Chapter",ExpressionUUID->"feaad711-c9f1-4b8b-aea2-6630fddc1c93"],
Cell[CellGroupData[{
Cell[357637, 9873, 317, 5, 70, "Subsubsection",ExpressionUUID->"1f624a41-f892-43fd-ad8e-2c34bf77200c"],
Cell[357957, 9880, 513, 11, 43, "Input",ExpressionUUID->"54dfb051-3d19-4744-98c6-60f0afe34135"],
Cell[358473, 9893, 466, 10, 43, "Input",ExpressionUUID->"00a85358-d999-4fef-81bd-70c6b7695d9b"],
Cell[358942, 9905, 433, 9, 43, "Input",ExpressionUUID->"4dea4989-8f97-4e32-8d4b-29a9553df92e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[359412, 9919, 164, 3, 70, "Subsubsection",ExpressionUUID->"2456b37b-9a58-4b95-b7ad-5c4e5583d3f9"],
Cell[359579, 9924, 516, 11, 43, "Input",ExpressionUUID->"cf00e8b1-3170-432a-9c94-96896f01af2b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[360132, 9940, 162, 3, 70, "Subsubsection",ExpressionUUID->"13d3d45c-0d30-4abe-b03d-aec8d3561684"],
Cell[360297, 9945, 518, 13, 43, "Input",ExpressionUUID->"3270722f-f555-4077-bc4e-87ea91fde2e1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[360852, 9963, 167, 3, 70, "Subsubsection",ExpressionUUID->"b135897a-b759-4f96-b8ee-c97c1cadbc33"],
Cell[361022, 9968, 532, 12, 43, "Input",ExpressionUUID->"ff40148f-4ed2-4986-97ce-73d067233c8e"],
Cell[361557, 9982, 575, 15, 43, "Input",ExpressionUUID->"3f25fb7f-7fc0-4550-ad04-6d59becaf5fc"],
Cell[362135, 9999, 1583, 49, 75, "Input",ExpressionUUID->"6c016f92-d1d6-4764-9151-9cdfb398aa89"],
Cell[363721, 10050, 208, 5, 43, "Input",ExpressionUUID->"82ce8e51-3322-41f5-b892-cb1e408cb5b9"],
Cell[363932, 10057, 600, 19, 43, "Input",ExpressionUUID->"4771353c-e6c5-42aa-ac74-ca8b4568f681"],
Cell[364535, 10078, 213, 5, 43, "Input",ExpressionUUID->"10daf517-ba58-4a2f-bc57-2c792c64d214"],
Cell[364751, 10085, 693, 17, 43, "Input",ExpressionUUID->"5dc31ef3-7b9d-4566-a996-e91c6e1698ef"],
Cell[365447, 10104, 849, 25, 75, "Input",ExpressionUUID->"b8fbf1a7-4cae-47b5-a0ec-d8936761351f"],
Cell[366299, 10131, 241, 6, 43, "Input",ExpressionUUID->"37c9d59c-0955-4991-9b73-10662a381244"],
Cell[366543, 10139, 183, 4, 43, "Input",ExpressionUUID->"c56c1bf5-5fd5-4145-a915-39b806c367f4"],
Cell[366729, 10145, 179, 4, 43, "Input",ExpressionUUID->"934de54f-e207-401e-ab5d-04cecac29f0b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[366945, 10154, 167, 3, 70, "Subsubsection",ExpressionUUID->"7e21b1a7-9c68-4769-8407-c6667bd1c8a4"],
Cell[367115, 10159, 494, 14, 43, "Input",ExpressionUUID->"5fdc598e-becf-4ffb-b004-e9cc64e912df"],
Cell[367612, 10175, 897, 26, 75, "Input",ExpressionUUID->"33373288-0840-4b03-8570-5aa0b185a7e7"],
Cell[368512, 10203, 405, 13, 43, "Input",ExpressionUUID->"1d1d1045-9dbd-4763-a3cc-7bb98ca0ba2c"],
Cell[368920, 10218, 776, 23, 43, "Input",ExpressionUUID->"cc26103f-0e81-4d6a-af1c-35eb161f351b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[369733, 10246, 163, 3, 70, "Subsubsection",ExpressionUUID->"f10ec9b2-eb72-45ac-a06c-e5c3371bf17c"],
Cell[369899, 10251, 386, 11, 43, "Input",ExpressionUUID->"196ca35f-e326-498a-81fc-5b50f5ba3b73"],
Cell[370288, 10264, 754, 17, 75, "Input",ExpressionUUID->"e490c3cb-a299-4909-af0a-f8188ef352fa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[371079, 10286, 297, 4, 70, "Subsubsection",ExpressionUUID->"4988d3e3-7241-40bc-a3f6-3272951b4328"],
Cell[371379, 10292, 1545, 40, 105, "Input",ExpressionUUID->"15a132a2-a86c-4d5c-89f9-9c3895209015"],
Cell[372927, 10334, 1402, 39, 173, "Input",ExpressionUUID->"6ef7ed33-920a-4ee0-bb34-6d3ebb59860a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[374366, 10378, 167, 3, 70, "Subsubsection",ExpressionUUID->"06a6ef47-19d5-4012-b13c-cb750c84899f"],
Cell[374536, 10383, 714, 22, 75, "Input",ExpressionUUID->"bd20c908-7d58-4c17-b41f-2b2f3feb1ff3"],
Cell[375253, 10407, 646, 19, 43, "Input",ExpressionUUID->"ac9e9653-b50b-4f8a-88cf-cac85f8c6751"],
Cell[375902, 10428, 189, 4, 43, "Input",ExpressionUUID->"84c46906-e408-4938-9c0d-d52cf3673fb3"],
Cell[376094, 10434, 192, 4, 43, "Input",ExpressionUUID->"4eedec35-1c78-4296-b640-8c463a4e5d90"]
}, Open  ]],
Cell[CellGroupData[{
Cell[376323, 10443, 190, 3, 70, "Subsubsection",ExpressionUUID->"2670de50-8c63-44c1-ab6e-2261d4574b79"],
Cell[376516, 10448, 424, 13, 47, "Input",ExpressionUUID->"20702e06-5d82-458d-8ce7-574edf24396a"],
Cell[376943, 10463, 424, 13, 47, "Input",ExpressionUUID->"8846e811-c058-4f61-9248-3473626722a3"],
Cell[377370, 10478, 405, 12, 47, "Input",ExpressionUUID->"43446ec7-71e9-4e58-af57-34640f9c5a8e"],
Cell[377778, 10492, 484, 15, 47, "Input",ExpressionUUID->"98201ea1-73f0-4143-8b29-dd27ac263add"],
Cell[378265, 10509, 660, 17, 47, "Input",ExpressionUUID->"091d73ff-8370-4ff7-99e3-4b149b53f464"],
Cell[378928, 10528, 660, 17, 47, "Input",ExpressionUUID->"31ebb274-0d64-4e3a-a1d5-ca577357d6d5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[379625, 10550, 176, 3, 70, "Subsubsection",ExpressionUUID->"c0a1a2b1-cd2a-4d15-9fff-9d84a8411245"],
Cell[379804, 10555, 958, 24, 75, "Input",ExpressionUUID->"8dd8865f-9a03-48ae-84c5-f7b5582369a4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[380799, 10584, 252, 4, 70, "Subsubsection",ExpressionUUID->"0c4a579a-80a4-4c7d-8719-d0fac793f436"],
Cell[381054, 10590, 2360, 70, 233, "Input",ExpressionUUID->"dd24ff23-b833-45b5-8f24-c71cfd6060e0"],
Cell[383417, 10662, 1966, 57, 175, "Input",ExpressionUUID->"51e7c6ad-172f-4115-af9b-ddc8e03fff2b"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[385444, 10726, 307, 5, 87, "Title",ExpressionUUID->"0239921e-cf04-49d9-98d7-1fb15f1b5da9"],
Cell[CellGroupData[{
Cell[385776, 10735, 154, 3, 107, "Chapter",ExpressionUUID->"bbd20199-d969-41c5-9694-0258d31e34dd"],
Cell[CellGroupData[{
Cell[385955, 10742, 186, 3, 70, "Subsubsection",ExpressionUUID->"047247d2-708d-4c54-a7ca-477b2161394a"],
Cell[386144, 10747, 4426, 103, 465, "Input",ExpressionUUID->"ccd2a4c6-56c7-44b1-8589-1371fecc232c"],
Cell[390573, 10852, 302, 7, 43, "Input",ExpressionUUID->"f71a76d0-440b-4b10-a786-fbe932b9be9b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[390912, 10864, 185, 3, 70, "Subsubsection",ExpressionUUID->"c43aa409-0362-45b4-9b06-0eaf733f0b48"],
Cell[391100, 10869, 10876, 312, 795, "Input",ExpressionUUID->"16ae1143-39fe-40a1-9a71-eebb5260cd68"],
Cell[401979, 11183, 343, 7, 43, "Input",ExpressionUUID->"918e1f33-7085-44f5-8349-72ea1aa5ca66"]
}, Open  ]],
Cell[CellGroupData[{
Cell[402359, 11195, 187, 3, 70, "Subsubsection",ExpressionUUID->"9653c61b-ee5b-438a-95fb-7b7e5c32ad7f"],
Cell[402549, 11200, 2572, 58, 225, "Input",ExpressionUUID->"35c9e197-3338-4554-a19a-46188847f48f"],
Cell[405124, 11260, 300, 7, 43, "Input",ExpressionUUID->"9e6ed457-b455-4af6-a53d-2ef6ce4e4b65"]
}, Open  ]],
Cell[CellGroupData[{
Cell[405461, 11272, 185, 3, 70, "Subsubsection",ExpressionUUID->"82e6216c-cf6f-47d1-8ead-7a8c1a966d7a"],
Cell[405649, 11277, 5537, 152, 525, "Input",ExpressionUUID->"aba32035-4f1b-4c4f-aa1d-5ebd10df3090"],
Cell[411189, 11431, 348, 6, 43, "Input",ExpressionUUID->"a6303d7e-316a-4fb0-be50-f6a149da3237"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[411586, 11443, 159, 3, 107, "Chapter",ExpressionUUID->"f3498d07-6ddd-41fe-9ab2-9eb8a5c3b51d"],
Cell[411748, 11448, 275, 6, 43, "Input",ExpressionUUID->"14f1cd6f-a735-4e26-bbb0-9c2e0505cd9c"],
Cell[412026, 11456, 494, 11, 75, "Input",ExpressionUUID->"9c6f178d-07c8-4f8e-967c-264ed07a2e0b"],
Cell[412523, 11469, 497, 11, 75, "Input",ExpressionUUID->"34befdde-affe-40b8-a685-d62c35140c1b"],
Cell[413023, 11482, 2075, 42, 160, "Input",ExpressionUUID->"347555dc-34f6-4e29-82c7-4ea655049eed"],
Cell[415101, 11526, 410, 9, 75, "Input",ExpressionUUID->"7c9b35b4-c070-448b-81a6-07f6cd99c3aa"],
Cell[CellGroupData[{
Cell[415536, 11539, 161, 3, 70, "Subsubsection",ExpressionUUID->"3e2ea42e-6903-424a-a60c-6bc543800621"],
Cell[415700, 11544, 520, 15, 43, "Input",ExpressionUUID->"7f2b61c3-c93a-4bbb-bfd0-b442506e973c"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[416281, 11566, 306, 5, 87, "Title",ExpressionUUID->"9b62fb72-ebe4-4f31-b6ff-7e084ad3c682"],
Cell[CellGroupData[{
Cell[416612, 11575, 154, 3, 107, "Chapter",ExpressionUUID->"83de4827-0f76-4735-94d0-73b6dbd78fa0"],
Cell[CellGroupData[{
Cell[416791, 11582, 189, 3, 70, "Subsubsection",ExpressionUUID->"67b0ca66-81f4-4c1c-bd03-64d795db48e9"],
Cell[416983, 11587, 829, 20, 75, "Input",ExpressionUUID->"6390389d-c044-4d72-97ee-e5ea4e0dc0e4"],
Cell[417815, 11609, 957, 28, 75, "Input",ExpressionUUID->"dc852909-3dde-4444-abab-84ecc089a2b2"],
Cell[418775, 11639, 417, 10, 43, "Input",ExpressionUUID->"2dad9881-4c82-47da-a38b-e855f674fde7"],
Cell[419195, 11651, 350, 6, 43, "Input",ExpressionUUID->"fc91ef13-c525-4060-92f5-779d2b95b21b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[419582, 11662, 187, 3, 70, "Subsubsection",ExpressionUUID->"d373a9f9-46b4-4329-a225-fb8afa5e72c5"],
Cell[419772, 11667, 1287, 38, 105, "Input",ExpressionUUID->"4b18a4c8-e0fd-4e84-b503-50187d4a4af7"],
Cell[421062, 11707, 981, 23, 43, "Input",ExpressionUUID->"57c89d24-13b2-4c18-bc56-8c3d3d84c6e6",
 CellID->151944537],
Cell[422046, 11732, 1082, 26, 105, "Input",ExpressionUUID->"63a5b259-4bc3-4aee-bc5d-008a935bc682"],
Cell[423131, 11760, 607, 15, 75, "Input",ExpressionUUID->"85eae8ee-5965-4b0c-98e9-c84d510d6846"],
Cell[423741, 11777, 472, 10, 43, "Input",ExpressionUUID->"8e74566d-b75d-43cb-8853-919909f61383"],
Cell[424216, 11789, 343, 6, 43, "Input",ExpressionUUID->"a042c122-a6a4-4421-9d9b-89ecf152b731"],
Cell[424562, 11797, 242, 5, 43, "Input",ExpressionUUID->"08a1d7bf-4600-45a7-954f-170650380ab5"],
Cell[424807, 11804, 189, 3, 53, "Text",ExpressionUUID->"7195de7c-d5ea-42e5-bdf3-438e4cca3da4"],
Cell[424999, 11809, 1579, 38, 195, "Input",ExpressionUUID->"eb3f7a8f-496a-4e9a-9ba0-1a3e477b048f"],
Cell[426581, 11849, 1134, 25, 43, "Input",ExpressionUUID->"24b03421-b956-4a5f-832d-96dd1cabc42a",
 CellID->38679433],
Cell[427718, 11876, 1158, 27, 105, "Input",ExpressionUUID->"29e42d55-6b32-441c-af15-c7b27cd99c50"],
Cell[428879, 11905, 218, 6, 43, "Input",ExpressionUUID->"21c69e25-3ef2-4a70-bdf8-54f8ca33fe3c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[429134, 11916, 185, 3, 70, "Subsubsection",ExpressionUUID->"6f89f6fd-c551-4569-9b9b-6690b31e91df"],
Cell[429322, 11921, 1010, 22, 43, "Input",ExpressionUUID->"26fe0db0-b20b-45cb-9364-5ad6e6759947"],
Cell[430335, 11945, 620, 14, 43, "Input",ExpressionUUID->"47ab12db-5cfb-4d30-a4f8-d056c3d1f169"],
Cell[430958, 11961, 293, 6, 43, "Input",ExpressionUUID->"174259f8-6794-47a6-ba26-c22ce7b94134"],
Cell[431254, 11969, 596, 14, 43, "Input",ExpressionUUID->"96e19dd0-e131-49cb-81fd-10aca5432cbf"],
Cell[431853, 11985, 295, 6, 43, "Input",ExpressionUUID->"4463386b-2422-4a03-a090-853b90195f5b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[432185, 11996, 187, 3, 70, "Subsubsection",ExpressionUUID->"1d3d270f-b398-435b-bda6-398ded78b00c"],
Cell[432375, 12001, 1098, 32, 75, "Input",ExpressionUUID->"2186af9f-8b94-49c1-8a8b-06b276012480"],
Cell[433476, 12035, 294, 6, 43, "Input",ExpressionUUID->"e3dfce75-8f45-4712-993a-4050800629d8"],
Cell[433773, 12043, 1377, 37, 75, "Input",ExpressionUUID->"29bd8bd7-d2af-4016-a142-1b9e7c7215a4"],
Cell[435153, 12082, 292, 6, 43, "Input",ExpressionUUID->"66c8fc8b-70f9-4309-90ee-2fcf1df0a885"]
}, Open  ]],
Cell[CellGroupData[{
Cell[435482, 12093, 187, 3, 70, "Subsubsection",ExpressionUUID->"19df5bca-541b-4443-a49a-de6e4007b35f"],
Cell[435672, 12098, 919, 29, 43, "Input",ExpressionUUID->"cd8a4eb5-be69-4090-93c0-1f317a822727"],
Cell[436594, 12129, 642, 14, 43, "Input",ExpressionUUID->"7c6bf17f-415b-424d-8aaa-1d5040411d87"],
Cell[437239, 12145, 289, 6, 43, "Input",ExpressionUUID->"78f205a0-b4d2-43de-bc23-aac007c4b82e"],
Cell[437531, 12153, 1349, 43, 75, "Input",ExpressionUUID->"c60318f3-6579-45dc-ac2c-adf00dfae645"],
Cell[438883, 12198, 674, 15, 75, "Input",ExpressionUUID->"0aff12c1-2b38-4eef-84fc-ea4f9915da09"],
Cell[439560, 12215, 292, 6, 43, "Input",ExpressionUUID->"9c373903-a05d-460e-8fdd-a990375dc71f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[439889, 12226, 186, 3, 70, "Subsubsection",ExpressionUUID->"9a915a77-ea32-45c5-b4b4-1b0c88f79499"],
Cell[440078, 12231, 707, 22, 43, "Input",ExpressionUUID->"a0748e1d-6068-4190-b931-3b36ccf78a8b"],
Cell[440788, 12255, 2543, 57, 165, "Input",ExpressionUUID->"d6f4fba5-b50b-463c-be71-94a6096554f2"],
Cell[443334, 12314, 294, 6, 43, "Input",ExpressionUUID->"fd21d670-e8a7-40d0-b78c-dd8a91747c28"],
Cell[443631, 12322, 950, 25, 43, "Input",ExpressionUUID->"c4e786c2-12fc-4abc-bb80-b48f4992a532"],
Cell[444584, 12349, 2106, 50, 165, "Input",ExpressionUUID->"e64527a3-4ee6-407b-b3bb-34adca172df4"],
Cell[446693, 12401, 296, 6, 43, "Input",ExpressionUUID->"242deb2a-839a-41ac-b9f2-397f27dd18f8"],
Cell[446992, 12409, 813, 23, 43, "Input",ExpressionUUID->"3c6b7d76-7a35-4932-846e-391c57bbd64f"],
Cell[447808, 12434, 3397, 74, 195, "Input",ExpressionUUID->"5010b8ae-c097-476b-9f84-57cb9b46f802"],
Cell[451208, 12510, 293, 6, 43, "Input",ExpressionUUID->"fc73fbe0-8ac1-452d-8f4c-4856ac02e552"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[451550, 12522, 159, 3, 107, "Chapter",ExpressionUUID->"da8df4da-ce5e-4548-ae95-009573508ebb"],
Cell[CellGroupData[{
Cell[451734, 12529, 250, 4, 70, "Subsubsection",ExpressionUUID->"bb82f8ad-ef1f-4a13-9239-79c3fbcd96ee"],
Cell[451987, 12535, 1010, 22, 43, "Input",ExpressionUUID->"6b10b313-3689-4483-9d6e-dfddf4ec015f"],
Cell[453000, 12559, 311, 8, 43, "Input",ExpressionUUID->"1a96240c-2681-4f52-bd22-cc0e42d76312"],
Cell[453314, 12569, 360, 9, 43, "Input",ExpressionUUID->"62c416bf-8a78-4501-a0da-b2185ceb26f2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[453711, 12583, 269, 4, 70, "Subsubsection",ExpressionUUID->"683c243a-297e-424a-bea6-a0418cc0a9af"],
Cell[453983, 12589, 672, 17, 43, "Input",ExpressionUUID->"a22e4845-e70e-4536-869a-9ca3e589b234"]
}, Open  ]],
Cell[CellGroupData[{
Cell[454692, 12611, 165, 3, 70, "Subsubsection",ExpressionUUID->"cd67976b-4e90-4f75-b15f-58dc8e93a520"],
Cell[454860, 12616, 484, 15, 43, "Input",ExpressionUUID->"4a2fe142-8873-4e8b-bc2f-7d9d7944f1cd"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[455405, 12638, 307, 5, 87, "Title",ExpressionUUID->"f85da745-7d88-4a00-b3bb-0af67f0c22ab"],
Cell[CellGroupData[{
Cell[455737, 12647, 154, 3, 107, "Chapter",ExpressionUUID->"699a2fb6-9a2b-4c8d-8ee3-bc70030efa81"],
Cell[CellGroupData[{
Cell[455916, 12654, 185, 3, 70, "Subsubsection",ExpressionUUID->"9ee7f45a-bdc8-4d4f-88ac-88209ce1d453"],
Cell[456104, 12659, 936, 22, 105, "Input",ExpressionUUID->"952d5631-b8df-437e-88ce-e428dfe8b999"],
Cell[457043, 12683, 862, 21, 105, "Input",ExpressionUUID->"5726a8ae-ba7d-4597-9029-3fe981e69ab6"],
Cell[457908, 12706, 501, 11, 43, "Input",ExpressionUUID->"aacd29cd-9fff-4160-b117-d579da4bd1b2"],
Cell[458412, 12719, 305, 7, 43, "Input",ExpressionUUID->"4ca2612d-7053-42bc-8d2d-9a83851fd293"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[458766, 12732, 159, 3, 107, "Chapter",ExpressionUUID->"94b55a7e-8b49-4c84-be45-e4f2de0e7571"],
Cell[458928, 12737, 234, 4, 43, "Input",ExpressionUUID->"44c3a584-03c5-4de8-9d1b-3a4bc40706a5"],
Cell[459165, 12743, 262, 5, 43, "Input",ExpressionUUID->"5f6f5f30-ff38-4cb0-be5d-99e400163c21"],
Cell[459430, 12750, 268, 5, 43, "Input",ExpressionUUID->"bfb6648a-31d4-454c-a392-5996ba714e12"],
Cell[459701, 12757, 187, 4, 43, "Input",ExpressionUUID->"9a81fce1-f1d0-4df9-8ad0-421d8f7aa08e"],
Cell[459891, 12763, 108, 1, 43, "Input",ExpressionUUID->"dd258b76-6675-4c45-9f43-3b2e8095f92d"],
Cell[460002, 12766, 183, 4, 43, "Input",ExpressionUUID->"9a9440e4-b4c7-425c-9eed-a63bfc77646d"],
Cell[460188, 12772, 603, 15, 105, "Input",ExpressionUUID->"27be06b0-6b50-4e69-bbc1-d027a767e224"],
Cell[460794, 12789, 197, 4, 43, "Input",ExpressionUUID->"75134310-1d51-485e-a9db-0c1c6a2be114"],
Cell[460994, 12795, 185, 4, 43, "Input",ExpressionUUID->"2436049f-9331-4b45-bb98-5506dd19aef1"],
Cell[461182, 12801, 162, 3, 43, "Input",ExpressionUUID->"95cbaa0f-88f2-4977-9bfc-ed2a8c100edc"],
Cell[461347, 12806, 160, 3, 43, "Input",ExpressionUUID->"45838817-0dda-419a-8670-716a5b078a87"],
Cell[461510, 12811, 181, 2, 53, "Text",ExpressionUUID->"167c7541-bda0-454d-b2f2-03c7be3a9374"],
Cell[461694, 12815, 205, 4, 43, "Input",ExpressionUUID->"124ffa12-2fde-40ee-a3be-6bbe711a58f5"],
Cell[461902, 12821, 301, 5, 43, "Input",ExpressionUUID->"480964ea-9f5f-4272-b0a6-ff55b170c422"],
Cell[462206, 12828, 329, 6, 43, "Input",ExpressionUUID->"2404d8fd-706e-44ac-8ed5-264ecdd7815f"],
Cell[462538, 12836, 427, 12, 43, "Input",ExpressionUUID->"ab4abbdb-b28d-4cf5-bc92-d54adc68f323"],
Cell[462968, 12850, 539, 11, 75, "Input",ExpressionUUID->"e0e93763-ef54-4127-ad5e-b4d0dc6521b0"],
Cell[463510, 12863, 400, 9, 43, "Input",ExpressionUUID->"96eaa8cb-28cc-400b-8b5c-c664547312fe"],
Cell[463913, 12874, 374, 10, 43, "Input",ExpressionUUID->"50192383-e7fd-417b-8f62-1690eafdc88c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[464336, 12890, 307, 5, 87, "Title",ExpressionUUID->"bc868344-1097-40cd-bcec-b02508843818"],
Cell[CellGroupData[{
Cell[464668, 12899, 154, 3, 107, "Chapter",ExpressionUUID->"1d72a944-a341-4894-87dd-3086e55812ce"],
Cell[CellGroupData[{
Cell[464847, 12906, 183, 3, 70, "Subsubsection",ExpressionUUID->"877c2ffc-5d9f-4c9f-bf7c-6b524a36b7bc"],
Cell[465033, 12911, 2235, 47, 165, "Input",ExpressionUUID->"48a008c4-32c2-403b-aeb6-e8d92248a461"],
Cell[467271, 12960, 358, 7, 43, "Input",ExpressionUUID->"60e0156a-e9c9-4db3-8839-a68f5f6853bd"]
}, Open  ]]
}, Open  ]],
Cell[467656, 12971, 159, 3, 107, "Chapter",ExpressionUUID->"4bbb4d74-fda8-4bc2-a173-29b1872e035b"]
}, Closed]],
Cell[CellGroupData[{
Cell[467852, 12979, 308, 5, 87, "Title",ExpressionUUID->"81106095-4a1d-4a8a-aa4e-ad9a8491d5ca"],
Cell[CellGroupData[{
Cell[468185, 12988, 157, 3, 86, "Chapter",ExpressionUUID->"c9474d64-36da-4906-bd92-82faedda890a"],
Cell[468345, 12993, 157, 3, 98, "Subchapter",ExpressionUUID->"16b53de9-d1bf-4aa6-8bad-09e1a05679e8"],
Cell[468505, 12998, 162, 3, 72, "Subchapter",ExpressionUUID->"6c0b4c1b-6c65-4a8e-866f-f024ca1f971a"]
}, Closed]],
Cell[CellGroupData[{
Cell[468704, 13006, 157, 3, 71, "Chapter",ExpressionUUID->"448f170f-855c-43e1-8f1f-f0f725555975"],
Cell[468864, 13011, 157, 3, 98, "Subchapter",ExpressionUUID->"79d1ebf3-087e-4fc4-b3c2-0fc8a0076276"],
Cell[CellGroupData[{
Cell[469046, 13018, 162, 3, 72, "Subchapter",ExpressionUUID->"079e1dae-1ebc-42d6-8073-c385fd381ee6"],
Cell[CellGroupData[{
Cell[469233, 13025, 165, 3, 70, "Subsubsection",ExpressionUUID->"a1e7c9af-9018-49c7-9ce7-b4b4a853dfac"],
Cell[469401, 13030, 2042, 57, 165, "Input",ExpressionUUID->"3e411d9a-7de2-4347-a320-a3070fda3100"],
Cell[471446, 13089, 802, 22, 75, "Input",ExpressionUUID->"8c9ff642-68d4-4bf6-8199-3166928f11e5"],
Cell[472251, 13113, 288, 7, 43, "Input",ExpressionUUID->"ec0bc094-395b-4d7d-a1a2-8620340eeaa9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[472576, 13125, 167, 3, 70, "Subsubsection",ExpressionUUID->"02888583-46a6-43da-b6ad-fb796494c643"],
Cell[472746, 13130, 493, 13, 43, "Input",ExpressionUUID->"f0147ad6-22c6-4da2-9854-07349a200d04"],
Cell[473242, 13145, 274, 5, 43, "Input",ExpressionUUID->"77407ef5-f774-4e92-a801-d2fbdd169170"],
Cell[473519, 13152, 270, 5, 43, "Input",ExpressionUUID->"a748ca02-d477-465d-8c1c-c5d823ab154f"],
Cell[473792, 13159, 295, 8, 43, "Input",ExpressionUUID->"37c3eb64-928b-4d4c-a2c6-238151a19bf5"],
Cell[474090, 13169, 213, 5, 53, "Text",ExpressionUUID->"8f3d6a81-e2a9-4cdc-845c-972296518a53"],
Cell[474306, 13176, 570, 14, 46, "Input",ExpressionUUID->"28a339cb-aca5-4eb0-b2ae-7f492e48e04d"],
Cell[474879, 13192, 192, 3, 53, "Text",ExpressionUUID->"1da08b8c-892d-4f49-9622-673ecd58661a"],
Cell[475074, 13197, 416, 12, 43, "Input",ExpressionUUID->"09cda2af-8717-4dd0-b1ff-3d86140bc156"],
Cell[475493, 13211, 216, 5, 43, "Input",ExpressionUUID->"f50052d8-b04d-494b-9519-76b812db7c18"],
Cell[475712, 13218, 275, 6, 43, "Input",ExpressionUUID->"9e554db4-80e7-428a-9bb2-ed621a3f3e32"]
}, Open  ]],
Cell[CellGroupData[{
Cell[476024, 13229, 218, 4, 70, "Subsubsection",ExpressionUUID->"686b446d-c99b-4a7d-b87a-ea50f8a83ca5"],
Cell[476245, 13235, 626, 15, 43, "Input",ExpressionUUID->"0a8cd536-6a21-445a-8155-a82f42605c0c"],
Cell[476874, 13252, 240, 6, 53, "Text",ExpressionUUID->"cd096545-2c1e-4514-a96e-1fd8343ad322"],
Cell[477117, 13260, 626, 17, 75, "Input",ExpressionUUID->"9784a52a-f3b6-49e2-934a-516d3c1ea7d4"],
Cell[477746, 13279, 533, 11, 43, "Input",ExpressionUUID->"bd2caaef-925f-4cce-bfb0-718abb18ce15"],
Cell[478282, 13292, 239, 5, 43, "Input",ExpressionUUID->"623badeb-f465-45bf-ab7b-5338701adda3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[478558, 13302, 264, 4, 70, "Subsubsection",ExpressionUUID->"7c48e482-72ab-4163-920a-f94105cb2b40"],
Cell[478825, 13308, 1173, 35, 105, "Input",ExpressionUUID->"3b91d052-ad7b-4612-945d-f3af958e2918"],
Cell[480001, 13345, 363, 9, 43, "Input",ExpressionUUID->"22e850f7-e6c2-4481-a5a8-c26bbb4392c7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[480401, 13359, 315, 5, 70, "Subsubsection",ExpressionUUID->"cdaadfd7-3c4c-438f-8ea2-e19b9cfe8399"],
Cell[480719, 13366, 979, 25, 81, "Input",ExpressionUUID->"5de9bd26-0ace-4ede-b2b1-1651e4e612d0"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[481759, 13398, 263, 4, 71, "Chapter",ExpressionUUID->"74f5f79d-413f-413d-8012-67dc44e772fb"],
Cell[CellGroupData[{
Cell[482047, 13406, 157, 3, 79, "Subchapter",ExpressionUUID->"9995a6f1-5b4f-446d-82c1-81e60fb18327"],
Cell[CellGroupData[{
Cell[482229, 13413, 185, 3, 56, "Subsubsection",ExpressionUUID->"241420ed-7fb1-41ec-91b5-6df90a11482f"],
Cell[482417, 13418, 920, 22, 60, "Input",ExpressionUUID->"3382bb97-fcf5-4267-989e-013770d1d581"],
Cell[483340, 13442, 298, 6, 35, "Input",ExpressionUUID->"af4d9c68-cb82-423a-851b-d4c13e5d3c68"]
}, Open  ]],
Cell[CellGroupData[{
Cell[483675, 13453, 182, 3, 56, "Subsubsection",ExpressionUUID->"aef98bca-eac4-484e-aa79-dac1d58f0829"],
Cell[483860, 13458, 897, 19, 84, "Input",ExpressionUUID->"62529b3c-f83b-40e7-9ef0-ee2d969846b7"],
Cell[484760, 13479, 1219, 21, 60, "Input",ExpressionUUID->"1e406ab2-97bd-4b41-9769-954f3953524b"],
Cell[485982, 13502, 1471, 27, 84, "Input",ExpressionUUID->"efb21e2b-24bf-4600-b344-c21b5da4f035"],
Cell[487456, 13531, 346, 6, 35, "Input",ExpressionUUID->"fe88d5dc-b86f-403f-9239-da684687c7c5"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[487851, 13543, 162, 3, 79, "Subchapter",ExpressionUUID->"25e6a0aa-b9e1-402a-b509-d0b0661e47f1"],
Cell[CellGroupData[{
Cell[488038, 13550, 220, 4, 56, "Subsubsection",ExpressionUUID->"30b8e8e4-756e-4e3e-bae4-62fee87df766"],
Cell[488261, 13556, 389, 9, 35, "Input",ExpressionUUID->"383d3eff-dd89-40f5-96cb-3716f5744c0d"],
Cell[488653, 13567, 198, 4, 35, "Input",ExpressionUUID->"9ea70698-6ca6-4c82-8637-6bf168ef2925"],
Cell[488854, 13573, 309, 6, 35, "Input",ExpressionUUID->"0514ad7a-662a-476d-a785-797c23d7dde6"],
Cell[489166, 13581, 471, 10, 35, "Input",ExpressionUUID->"6e962e61-e6c1-49dc-b4be-6e4b0418514a"],
Cell[489640, 13593, 572, 14, 35, "Input",ExpressionUUID->"428b891c-cdf6-461e-a9a1-ac14bd83c093"],
Cell[490215, 13609, 505, 12, 35, "Input",ExpressionUUID->"0e478a40-8c4a-47f0-a66c-c59a785ef8f2"],
Cell[490723, 13623, 345, 6, 35, "Input",ExpressionUUID->"3df61e14-55f4-409a-a0d2-be93a556fe84"],
Cell[491071, 13631, 421, 7, 35, "Input",ExpressionUUID->"8a6c56f2-527e-432f-a000-a63d699dc76f"],
Cell[491495, 13640, 475, 8, 35, "Input",ExpressionUUID->"612a6ebe-ddb5-4cc3-85bf-c932ea83193d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[492007, 13653, 270, 4, 56, "Subsubsection",ExpressionUUID->"a4367548-a5fd-4845-8b88-831c67e42833"],
Cell[492280, 13659, 495, 11, 35, "Input",ExpressionUUID->"25d6b05d-1690-4229-8464-be6bae2ff600"],
Cell[492778, 13672, 537, 13, 60, "Input",ExpressionUUID->"be459b77-7388-45e3-9c70-0d99aa14e6eb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[493352, 13690, 321, 5, 56, "Subsubsection",ExpressionUUID->"04696935-6fa0-490e-9ba4-059b2ddec404"],
Cell[493676, 13697, 521, 14, 35, "Input",ExpressionUUID->"34795c7f-507d-43f7-9b4a-df9cf5933d40"],
Cell[494200, 13713, 200, 3, 43, "Text",ExpressionUUID->"601b9481-55e4-4e61-a7cf-9eb9fbad7f73"],
Cell[494403, 13718, 381, 10, 35, "Input",ExpressionUUID->"af7529ed-fbf2-4e36-bb5e-344cf5fc9329"]
}, Open  ]],
Cell[CellGroupData[{
Cell[494821, 13733, 323, 5, 56, "Subsubsection",ExpressionUUID->"2624526d-8223-4a43-8d58-23679f6a145d"],
Cell[495147, 13740, 737, 24, 35, "Input",ExpressionUUID->"6ca6a89a-f9eb-487d-a6f7-fb9542a01840"]
}, Open  ]],
Cell[495899, 13767, 323, 5, 56, "Subsubsection",ExpressionUUID->"728c135f-128e-4320-82a1-1d4bd3482996"],
Cell[CellGroupData[{
Cell[496247, 13776, 150, 3, 46, "Subsection",ExpressionUUID->"200c7679-de42-4b74-a41d-b05a9f4f4078"],
Cell[496400, 13781, 669, 16, 35, "Input",ExpressionUUID->"80e38466-fda5-4530-8162-4cf40614243b"],
Cell[497072, 13799, 304, 7, 35, "Input",ExpressionUUID->"b1a8a8d5-e042-460e-9578-772c196e5b32"],
Cell[497379, 13808, 668, 15, 35, "Input",ExpressionUUID->"e4466623-19f0-4715-b304-989d5304a15b"],
Cell[498050, 13825, 197, 3, 43, "Text",ExpressionUUID->"57e02b24-364a-4302-bd14-43816fe8e24f"],
Cell[498250, 13830, 484, 13, 35, "Input",ExpressionUUID->"5f69756c-363b-4aa0-9136-cdff4e01a4f2"],
Cell[498737, 13845, 483, 11, 60, "Input",ExpressionUUID->"4f3ddad8-578b-4428-82ca-9c1191aeb694"],
Cell[499223, 13858, 164, 3, 43, "Text",ExpressionUUID->"ac3b620a-d097-44a7-94a3-75871ba16990"],
Cell[499390, 13863, 509, 13, 84, "Input",ExpressionUUID->"fe6510be-1ece-4127-aacf-d4e5dd98eff4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[499936, 13881, 152, 3, 67, "Subsection",ExpressionUUID->"89531241-f0c5-4027-8b37-d82a1e722fc7"],
Cell[500091, 13886, 687, 17, 60, "Input",ExpressionUUID->"dace345e-55c4-4ac1-b883-38af22df58c9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[500815, 13908, 154, 3, 67, "Subsection",ExpressionUUID->"dd4b7dad-2d2f-4ab9-99c7-7b78a18ed5fb"],
Cell[500972, 13913, 1586, 42, 156, "Input",ExpressionUUID->"25406c21-31c6-4207-86da-a1c65d1fda19"]
}, Open  ]],
Cell[CellGroupData[{
Cell[502595, 13960, 152, 3, 67, "Subsection",ExpressionUUID->"ed00efb4-b68f-4d90-8597-3432323c5f06"],
Cell[502750, 13965, 601, 16, 35, "Input",ExpressionUUID->"f363c0ea-63f4-4afc-88f8-95dbe12a2b03"],
Cell[503354, 13983, 668, 17, 60, "Input",ExpressionUUID->"8292c61c-1fa4-4e18-884d-f15383ef4a9c"],
Cell[504025, 14002, 745, 19, 60, "Input",ExpressionUUID->"3fedf357-fa75-45ce-89c8-c8d86c7fc67c"],
Cell[CellGroupData[{
Cell[504795, 14025, 372, 6, 56, "Subsubsection",ExpressionUUID->"c7223ef0-1d77-4f86-9c23-6e183041ea14"],
Cell[505170, 14033, 166, 3, 43, "Text",ExpressionUUID->"3bbe6cd1-3181-461c-bdc6-930c1967116a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[505373, 14041, 374, 6, 56, "Subsubsection",ExpressionUUID->"8c1695a0-b6cb-4f98-a36b-5b40624c0edd"],
Cell[505750, 14049, 1505, 33, 65, "Input",ExpressionUUID->"fc1b85c3-8720-417f-84f0-b8d63056c02f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[507292, 14087, 377, 6, 56, "Subsubsection",ExpressionUUID->"e652972d-74d5-451b-949f-547f5dd8fc19"],
Cell[507672, 14095, 1560, 34, 65, "Input",ExpressionUUID->"7c621ec4-7ae7-4965-8779-60e52da2a578"]
}, Open  ]],
Cell[CellGroupData[{
Cell[509269, 14134, 473, 7, 56, "Subsubsection",ExpressionUUID->"fe0088af-031a-4844-952c-5319a8f55dd6"],
Cell[509745, 14143, 466, 12, 35, "Input",ExpressionUUID->"b3dbbe8c-3d69-4694-ab96-e3d60e462e96"],
Cell[510214, 14157, 387, 10, 35, "Input",ExpressionUUID->"42d836af-b346-426a-9b08-91216021ebfc"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[510674, 14175, 239, 4, 86, "Chapter",ExpressionUUID->"30846070-2302-4063-a8fc-54777ad90997"],
Cell[510916, 14181, 157, 3, 98, "Subchapter",ExpressionUUID->"96500001-0ec9-44de-aa3f-07ec80e2298f"],
Cell[CellGroupData[{
Cell[511098, 14188, 162, 3, 72, "Subchapter",ExpressionUUID->"e63a440d-529d-4e75-9ecf-e47ffa69b4d8"],
Cell[CellGroupData[{
Cell[511285, 14195, 523, 8, 70, "Subsubsection",ExpressionUUID->"700b2469-c836-421c-8193-5f2529892bd4"],
Cell[511811, 14205, 1910, 52, 225, "Input",ExpressionUUID->"c3dd5d31-f50e-46fa-ac48-b897b19883d0"],
Cell[513724, 14259, 241, 4, 53, "Text",ExpressionUUID->"8116872d-fc4e-4534-858d-16445e89f9e6"],
Cell[513968, 14265, 481, 13, 43, "Input",ExpressionUUID->"355e5601-a0d6-4d11-8aaa-caecb751ff39"],
Cell[514452, 14280, 509, 12, 43, "Input",ExpressionUUID->"7e3940fd-cf6f-4939-94f8-e8f8a5f827ff"],
Cell[514964, 14294, 181, 4, 43, "Input",ExpressionUUID->"2dee84ff-cd5a-4d24-8779-f71c59bda91e"],
Cell[515148, 14300, 223, 5, 43, "Input",ExpressionUUID->"6dd99a47-3050-4166-ad33-71e1a2912ae7"],
Cell[515374, 14307, 298, 7, 43, "Input",ExpressionUUID->"f1b84ad6-02e3-48ad-be1e-81dade3aed67"],
Cell[515675, 14316, 231, 5, 43, "Input",ExpressionUUID->"93c0fef9-168f-4e13-ba41-8855044d2e55"],
Cell[515909, 14323, 275, 6, 43, "Input",ExpressionUUID->"0caefb9d-1b8c-4657-b261-de5d65bccb22"],
Cell[516187, 14331, 655, 14, 75, "Input",ExpressionUUID->"654eaf1d-1b78-4478-ab62-65a5c0aafa49"],
Cell[516845, 14347, 852, 23, 75, "Input",ExpressionUUID->"4c2e08fc-da4f-4528-ab8c-b28c9bffaf34"],
Cell[517700, 14372, 504, 12, 43, "Input",ExpressionUUID->"2083f16c-b8b5-4eac-a72b-f0a0e7a21453"],
Cell[518207, 14386, 875, 23, 135, "Input",ExpressionUUID->"5bdb689b-354d-400d-aea8-c2b72fdacbb9"],
Cell[519085, 14411, 221, 5, 53, "Text",ExpressionUUID->"153dad8d-eee5-4206-ba85-df0cd2973157"],
Cell[519309, 14418, 1003, 30, 75, "Input",ExpressionUUID->"dee973b2-ebdc-4cf3-b6f0-38a323c9b4a2"],
Cell[520315, 14450, 1187, 32, 75, "Input",ExpressionUUID->"4ddbf31a-f72a-445b-a51d-12c598091c25"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[521563, 14489, 209, 4, 71, "Chapter",ExpressionUUID->"1544e1a3-e5ec-49c1-992f-0dc8b7e6309b"],
Cell[521775, 14495, 157, 3, 79, "Subchapter",ExpressionUUID->"72194827-c20d-4967-896a-97aaa9124d8d"],
Cell[CellGroupData[{
Cell[521957, 14502, 162, 3, 58, "Subchapter",ExpressionUUID->"337e1685-a9be-4d63-9965-72af25a70bc9"],
Cell[CellGroupData[{
Cell[522144, 14509, 165, 3, 56, "Subsubsection",ExpressionUUID->"978e3b0d-2117-439b-901e-ec26bc881ed4"],
Cell[522312, 14514, 586, 18, 35, "Input",ExpressionUUID->"745cfe19-fedf-4df9-b593-92ab395fefdf"],
Cell[522901, 14534, 445, 13, 35, "Input",ExpressionUUID->"fb14dc53-8fae-4065-a32e-15dcc75a478a"],
Cell[523349, 14549, 227, 5, 35, "Input",ExpressionUUID->"635b7957-40f9-4831-a11e-efd1d9bf873a"],
Cell[523579, 14556, 325, 8, 35, "Input",ExpressionUUID->"0dd82378-6dea-429d-be7b-6da51a0534f1"],
Cell[523907, 14566, 451, 11, 35, "Input",ExpressionUUID->"72e409f8-6158-4d0a-af81-310924453267"]
}, Open  ]],
Cell[CellGroupData[{
Cell[524395, 14582, 216, 4, 56, "Subsubsection",ExpressionUUID->"0225fc2b-ff1f-4d74-bfbc-708d382d20cc"],
Cell[524614, 14588, 937, 25, 60, "Input",ExpressionUUID->"b08a641b-e50e-498f-813d-e25d5a4a2eb7"],
Cell[525554, 14615, 426, 10, 35, "Input",ExpressionUUID->"9b9a6e60-2940-48c6-baa7-3f0960fb2031"],
Cell[525983, 14627, 408, 9, 35, "Input",ExpressionUUID->"9524b993-3397-4562-8240-6df8b08e3be8"],
Cell[526394, 14638, 459, 10, 35, "Input",ExpressionUUID->"9295c12e-abb2-47ab-b0db-d6e6e42b50ed"],
Cell[526856, 14650, 4928, 157, 325, "Input",ExpressionUUID->"d946fbaf-4a1a-42eb-a73b-5469611f6650"],
Cell[531787, 14809, 402, 8, 35, "Input",ExpressionUUID->"24404e96-f8e2-4d21-9c46-96d50bca7661"],
Cell[532192, 14819, 189, 4, 35, "Input",ExpressionUUID->"378edcd2-bed6-4b3f-9c47-da7fb1cebc43"],
Cell[532384, 14825, 189, 4, 35, "Input",ExpressionUUID->"ce3b1675-b6be-4b9e-8e37-1ef598c03861"]
}, Open  ]],
Cell[CellGroupData[{
Cell[532610, 14834, 262, 4, 56, "Subsubsection",ExpressionUUID->"ecf212d9-25c9-47ef-9e27-ea458f649a04"],
Cell[532875, 14840, 634, 13, 35, "Input",ExpressionUUID->"9726daa0-5ce3-43a8-b262-189dad9aa26d"],
Cell[533512, 14855, 271, 6, 35, "Input",ExpressionUUID->"744ce81e-0834-4232-93b1-b2783144d6d2"],
Cell[533786, 14863, 643, 13, 35, "Input",ExpressionUUID->"75e16032-b4b2-4a37-9e7b-7cfc7f2beb16"],
Cell[534432, 14878, 711, 15, 35, "Input",ExpressionUUID->"a62784d6-6cbd-4a5c-91b3-e42fa7ba0751"],
Cell[535146, 14895, 308, 6, 35, "Input",ExpressionUUID->"9e56291c-3a02-461a-aea2-d2668fad17d1"],
Cell[535457, 14903, 616, 12, 35, "Input",ExpressionUUID->"dde9e835-70aa-4f0f-87dc-a381e1c3037e"],
Cell[536076, 14917, 338, 6, 35, "Input",ExpressionUUID->"984119e6-c093-4852-bee4-c4657f5d5f31"],
Cell[536417, 14925, 174, 3, 43, "Text",ExpressionUUID->"3115f231-40cb-48b0-9739-5fd5b1cdb4dd"],
Cell[536594, 14930, 580, 12, 35, "Input",ExpressionUUID->"2834e998-5134-48fb-b828-8b3898cdd6a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[537211, 14947, 313, 5, 56, "Subsubsection",ExpressionUUID->"22395b0b-155a-4693-b871-2bee73f2a064"],
Cell[537527, 14954, 903, 22, 60, "Input",ExpressionUUID->"30092b47-5d02-40f9-8738-c807373e3361"]
}, Open  ]],
Cell[CellGroupData[{
Cell[538467, 14981, 315, 5, 56, "Subsubsection",ExpressionUUID->"535c46c9-77fe-4b44-bbaf-29d1772d5bb1"],
Cell[538785, 14988, 3527, 79, 252, "Input",ExpressionUUID->"049fc557-0aa4-4d83-b5c7-edd3c494820c"],
Cell[542315, 15069, 1931, 50, 180, "Input",ExpressionUUID->"fe4fdbf2-2cd4-43bc-b576-a8e88fcf81bc"],
Cell[544249, 15121, 1316, 30, 35, "Input",ExpressionUUID->"1820fe16-895a-4077-a76b-459fb78d6cca"],
Cell[545568, 15153, 240, 4, 43, "Text",ExpressionUUID->"1ac23a09-f4ff-4c85-b57a-3fc760658bb0"],
Cell[545811, 15159, 1324, 30, 35, "Input",ExpressionUUID->"c7e33bad-8a7f-4dbb-b683-70dd36ebc1dd"],
Cell[547138, 15191, 396, 6, 43, "Text",ExpressionUUID->"72c4a598-29d0-423f-abcb-cb46a9316fa5"],
Cell[547537, 15199, 1022, 25, 84, "Input",ExpressionUUID->"b27fb308-e0c5-42fc-9fff-fe64c4519cba"],
Cell[548562, 15226, 198, 4, 35, "Input",ExpressionUUID->"11256983-8433-4967-b1e0-b3afc18384b5"],
Cell[548763, 15232, 205, 4, 35, "Input",ExpressionUUID->"0f91028f-9c99-4922-9498-54b97a316883"],
Cell[548971, 15238, 421, 12, 35, "Input",ExpressionUUID->"681c0373-3a9d-4635-9f2b-0b789a0d3033"],
Cell[549395, 15252, 386, 10, 35, "Input",ExpressionUUID->"af3613d6-0d50-4f92-b607-206112667892"],
Cell[549784, 15264, 304, 6, 71, "Text",ExpressionUUID->"a6c0aa20-2636-4542-9bb1-eaaf87dfa841"],
Cell[550091, 15272, 641, 16, 35, "Input",ExpressionUUID->"e90083c4-a503-467e-ae67-1188353e59d5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[550769, 15293, 368, 6, 56, "Subsubsection",ExpressionUUID->"75035a1b-e19c-49fb-b8b4-fbde8999c3a5"],
Cell[551140, 15301, 1498, 42, 180, "Input",ExpressionUUID->"4dafcc29-3c36-442d-b694-03788e70f2c6"],
Cell[552641, 15345, 916, 23, 60, "Input",ExpressionUUID->"70b1cdb4-0d48-449c-acfc-c5c4f0a7b899"],
Cell[553560, 15370, 906, 25, 35, "Input",ExpressionUUID->"a9e39abb-2675-4cd1-8af8-ed8eccfa61f7"],
Cell[554469, 15397, 937, 26, 35, "Input",ExpressionUUID->"026cdf4e-9169-4541-b0e3-fa8c67cb1cb1"],
Cell[555409, 15425, 766, 22, 35, "Input",ExpressionUUID->"8e44a925-6afa-4acc-a052-01715b4d1b2d"],
Cell[556178, 15449, 794, 22, 35, "Input",ExpressionUUID->"6fbd35fa-8016-423d-a466-8347e4ef39a9"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[557033, 15478, 205, 4, 86, "Chapter",ExpressionUUID->"44a96b7d-99ae-476f-ac1f-dbe60de698f8"],
Cell[CellGroupData[{
Cell[557263, 15486, 157, 3, 79, "Subchapter",ExpressionUUID->"d8990e12-1808-40c0-ae88-012f1698157b"],
Cell[CellGroupData[{
Cell[557445, 15493, 189, 3, 56, "Subsubsection",ExpressionUUID->"d5d282c5-4ada-43b4-a514-32d100f9e583"],
Cell[557637, 15498, 363, 7, 35, "Input",ExpressionUUID->"1f335cdc-f60b-4e05-b382-c05244b38a44"],
Cell[558003, 15507, 465, 12, 35, "Input",ExpressionUUID->"cf8a5a37-e884-4ee6-9913-44104d2e7905"],
Cell[558471, 15521, 842, 20, 35, "Input",ExpressionUUID->"904856a8-c0ad-4c2a-bcc5-1600123bfd08"],
Cell[559316, 15543, 844, 20, 35, "Input",ExpressionUUID->"4967c0c6-f3d1-471e-8c83-a7709906d0ce"],
Cell[560163, 15565, 1176, 31, 108, "Input",ExpressionUUID->"2916751b-ff96-4c23-9faf-90cc6b3f91fb"],
Cell[561342, 15598, 303, 7, 35, "Input",ExpressionUUID->"565076af-4eb8-448e-a7b9-2ee708063ccc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[561682, 15610, 189, 3, 56, "Subsubsection",ExpressionUUID->"9b43ad7a-9cf4-4d3e-8046-8dbef39dd2b3"],
Cell[561874, 15615, 838, 20, 60, "Input",ExpressionUUID->"5a4325d9-67b7-42b4-9c5c-067533c1eb7e"],
Cell[562715, 15637, 354, 7, 35, "Input",ExpressionUUID->"18298397-90b7-4eb9-8507-6d6005e57928"]
}, Open  ]],
Cell[CellGroupData[{
Cell[563106, 15649, 183, 3, 56, "Subsubsection",ExpressionUUID->"fe2add60-0ed8-4e47-9444-0374518d3ef7"],
Cell[563292, 15654, 2472, 55, 180, "Input",ExpressionUUID->"2562521b-71ad-4ac4-9686-b8ea51b3a76a"],
Cell[565767, 15711, 292, 6, 35, "Input",ExpressionUUID->"bdd7bf2e-7d02-4f03-b194-9d170ded0e48"]
}, Open  ]],
Cell[CellGroupData[{
Cell[566096, 15722, 185, 3, 56, "Subsubsection",ExpressionUUID->"30800093-9dc9-4483-9b4a-87d4d0dcc30c"],
Cell[566284, 15727, 3918, 91, 285, "Input",ExpressionUUID->"8adb74bb-6abe-4209-8df8-36a0198b8dbe"],
Cell[570205, 15820, 297, 6, 43, "Input",ExpressionUUID->"ba664ef0-a92a-491e-b54d-379e0a7268e1"],
Cell[570505, 15828, 2792, 69, 156, "Input",ExpressionUUID->"541c0ad7-8a28-46a3-ae2e-8b97f2f17bde"],
Cell[573300, 15899, 295, 6, 35, "Input",ExpressionUUID->"2a4f0942-1e72-4cf7-a230-186705289f45"]
}, Open  ]],
Cell[CellGroupData[{
Cell[573632, 15910, 187, 3, 56, "Subsubsection",ExpressionUUID->"39f124ba-70a9-47f9-993c-7ef9c0aa6b69"],
Cell[573822, 15915, 2327, 51, 86, "Input",ExpressionUUID->"2f08817a-2162-4481-9461-527e0a9b25f4"],
Cell[576152, 15968, 3825, 79, 132, "Input",ExpressionUUID->"98cb2abd-28e7-4fef-9b7d-9d68845754dd"],
Cell[579980, 16049, 449, 8, 35, "Input",ExpressionUUID->"f2cbf4f4-bdf2-42a9-b4ae-69a29c7d8b5b"],
Cell[580432, 16059, 2026, 53, 132, "Input",ExpressionUUID->"d24abf7e-5922-40c5-b5f4-df3bd793ebf4"],
Cell[582461, 16114, 448, 8, 35, "Input",ExpressionUUID->"e92e1b59-c2aa-4c04-8ce8-7ad8b8a2a087"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[582958, 16128, 162, 3, 79, "Subchapter",ExpressionUUID->"7a96c0ae-9483-4087-9582-afa1a4e9cf53"],
Cell[CellGroupData[{
Cell[583145, 16135, 218, 4, 56, "Subsubsection",ExpressionUUID->"be072f19-6350-4e90-bcd2-0d010e554a88"],
Cell[583366, 16141, 771, 19, 60, "Input",ExpressionUUID->"b2a0651b-bb58-4de2-8327-8242304909b8"],
Cell[584140, 16162, 829, 22, 84, "Input",ExpressionUUID->"860e6af6-533e-4c41-896e-0543b374d52f"],
Cell[584972, 16186, 175, 3, 43, "Text",ExpressionUUID->"d831b8ae-2887-4cba-a1ff-9856a8b12827"],
Cell[585150, 16191, 760, 22, 84, "Input",ExpressionUUID->"38cca91e-bfab-431c-9890-4dbb46cf42ae"],
Cell[585913, 16215, 586, 15, 35, "Input",ExpressionUUID->"c19cd94b-936d-45a9-907a-96a55a99b602"],
Cell[586502, 16232, 279, 6, 43, "Text",ExpressionUUID->"31b0851c-1647-47ff-aea9-c77d563e5398"],
Cell[586784, 16240, 494, 12, 35, "Input",ExpressionUUID->"7e286165-d158-4761-9874-0e129ff3aae4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[587315, 16257, 214, 4, 56, "Subsubsection",ExpressionUUID->"8040a812-60f6-45ba-9fd0-8157fe32f4f0"],
Cell[587532, 16263, 450, 12, 35, "Input",ExpressionUUID->"8900a1a5-cf1f-4fb6-84b6-f09f5babbee1"],
Cell[587985, 16277, 414, 9, 35, "Input",ExpressionUUID->"df7d33a4-b4d4-4948-b46d-29dbdd8eecc5"],
Cell[588402, 16288, 282, 6, 43, "Text",ExpressionUUID->"893deef9-d9b4-4679-9273-94747784b3aa"],
Cell[588687, 16296, 576, 17, 35, "Input",ExpressionUUID->"2bce7b44-93b3-4fca-a18d-27f22a79b84a"],
Cell[589266, 16315, 536, 14, 35, "Input",ExpressionUUID->"cdbd660e-88a1-4320-8f22-30abb680bde1"],
Cell[589805, 16331, 293, 7, 35, "Input",ExpressionUUID->"9a3c81c8-b188-40de-a575-63926a88ece0"],
Cell[590101, 16340, 370, 9, 35, "Input",ExpressionUUID->"2ddb5a2a-2c5d-4364-9239-d15350e91de3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[590508, 16354, 260, 4, 56, "Subsubsection",ExpressionUUID->"6cc2d81a-bd58-4bb9-9c54-add6d9250bff"],
Cell[590771, 16360, 250, 5, 35, "Input",ExpressionUUID->"40a4cb49-c4c2-4bbe-bbd6-225a1fe8d696"],
Cell[591024, 16367, 933, 23, 35, "Input",ExpressionUUID->"dd792698-0ee6-4812-91a3-2337a66a8c1f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[591994, 16395, 313, 5, 56, "Subsubsection",ExpressionUUID->"24936b84-74e9-41cc-990e-21221e31ed59"],
Cell[592310, 16402, 600, 16, 62, "Input",ExpressionUUID->"0e9be54e-9822-4ca0-bd95-e526b9afe088"],
Cell[592913, 16420, 583, 13, 35, "Input",ExpressionUUID->"1cc25b38-f22b-4238-91c1-b14f71b62bc6"],
Cell[593499, 16435, 429, 11, 35, "Input",ExpressionUUID->"052785d2-3f21-4054-874d-992c5e7401b8"],
Cell[593931, 16448, 591, 15, 35, "Input",ExpressionUUID->"06c5f771-be89-4b1f-bd82-351320b6890f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[594559, 16468, 271, 4, 56, "Subsubsection",ExpressionUUID->"4021757f-3dec-4545-8bdc-cad38fde14e6"],
Cell[594833, 16474, 927, 24, 60, "Input",ExpressionUUID->"8986c6f1-c60a-4f81-96e5-402ad9f9e9dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[595797, 16503, 271, 4, 56, "Subsubsection",ExpressionUUID->"4ddf678f-afd4-4086-b0a7-d3faebae8ad2"],
Cell[596071, 16509, 558, 17, 35, "Input",ExpressionUUID->"8534e428-ec79-4bc4-9dcd-038ac186b856"]
}, Open  ]],
Cell[CellGroupData[{
Cell[596666, 16531, 221, 4, 56, "Subsubsection",ExpressionUUID->"eb16680e-8ec2-4cab-bdfe-7d4ad1618201"],
Cell[596890, 16537, 932, 25, 75, "Input",ExpressionUUID->"a4f9a57e-8b9e-40ed-91cd-5af466145c75"]
}, Open  ]],
Cell[CellGroupData[{
Cell[597859, 16567, 269, 4, 70, "Subsubsection",ExpressionUUID->"d46f45c6-c0cd-4a22-a19c-0af14fcd87e1"],
Cell[598131, 16573, 1105, 25, 75, "Input",ExpressionUUID->"516a5ca4-3c55-4edd-a6c2-fb1b11a21aa6"],
Cell[599239, 16600, 997, 24, 61, "Input",ExpressionUUID->"ef02ccf7-2a6d-4788-a1c5-c32f565c3295"],
Cell[600239, 16626, 401, 9, 43, "Input",ExpressionUUID->"387ee168-16d7-4b52-a4a3-caa9975a3bd9"],
Cell[600643, 16637, 700, 19, 75, "Input",ExpressionUUID->"86345d6c-aea5-46a2-b33a-6eec0b01bebb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[601380, 16661, 166, 3, 70, "Subsubsection",ExpressionUUID->"2153adc5-5755-4df7-aa88-194e319e7bd9"],
Cell[601549, 16666, 177, 4, 43, "Input",ExpressionUUID->"ce96d78e-77f7-4d1f-ae70-79542cac96b7"],
Cell[601729, 16672, 372, 8, 43, "Input",ExpressionUUID->"f3255fdf-d4f6-4593-8683-3c478b3cae94"]
}, Open  ]],
Cell[CellGroupData[{
Cell[602138, 16685, 217, 4, 70, "Subsubsection",ExpressionUUID->"e450bd30-01b3-4b3d-b1aa-ec8f6c385e0a"],
Cell[602358, 16691, 157, 3, 53, "Text",ExpressionUUID->"5afce474-49e1-4900-b663-7b88b9bedad9"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[602576, 16701, 206, 4, 88, "Chapter",ExpressionUUID->"c6b3047e-d8b1-4014-af21-37bd86c920b1"],
Cell[602785, 16707, 157, 3, 98, "Subchapter",ExpressionUUID->"1eaaadff-63f5-41ea-b5ae-50216d3ed70a"],
Cell[CellGroupData[{
Cell[602967, 16714, 162, 3, 72, "Subchapter",ExpressionUUID->"d4ba3008-8915-4fa2-b1a0-b131bebce928"],
Cell[CellGroupData[{
Cell[603154, 16721, 244, 4, 70, "Subsubsection",ExpressionUUID->"d4426faf-698a-432e-9951-33956b74d1d6"],
Cell[603401, 16727, 1129, 30, 135, "Input",ExpressionUUID->"d760995a-2ed9-4a87-b2e1-1914715f37af"],
Cell[604533, 16759, 188, 4, 43, "Input",ExpressionUUID->"39eaa7ad-1c91-4f35-af91-eb510543b473"],
Cell[604724, 16765, 1352, 40, 135, "Input",ExpressionUUID->"2b8ba274-fee9-4471-a607-59665b372772"],
Cell[606079, 16807, 821, 26, 75, "Input",ExpressionUUID->"0e5164a1-169b-45b8-a4e7-8193f4d6181c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[606937, 16838, 242, 4, 70, "Subsubsection",ExpressionUUID->"9a111237-6cb7-4578-b571-be79b29a6f5e"],
Cell[607182, 16844, 511, 14, 43, "Input",ExpressionUUID->"8c64a381-ae77-41a4-b67d-d687a18792ee"],
Cell[607696, 16860, 953, 26, 108, "Input",ExpressionUUID->"303a34b7-7618-4ba7-adff-f88cea856ff4"],
Cell[608652, 16888, 649, 16, 47, "Input",ExpressionUUID->"edfe1cf9-5e07-4adb-8dbb-f0d8008328b5"],
Cell[609304, 16906, 581, 14, 43, "Input",ExpressionUUID->"a7843eaf-ad91-4887-a564-d075fbef90c8"],
Cell[609888, 16922, 163, 3, 53, "Text",ExpressionUUID->"c5d3e799-2fb9-4ee0-93a9-fce1258c5c6a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[610088, 16930, 268, 4, 70, "Subsubsection",ExpressionUUID->"1c25d77c-ca1c-4763-b56c-b70359033e08"],
Cell[610359, 16936, 785, 22, 105, "Input",ExpressionUUID->"a8090dd5-d5ab-47d7-adf4-e8d973af865e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[611181, 16963, 244, 4, 70, "Subsubsection",ExpressionUUID->"8c322028-4425-4084-922b-3709728d1405"],
Cell[611428, 16969, 349, 9, 43, "Input",ExpressionUUID->"5c6d6d1a-5c31-40c9-86f6-d5cf15fb7499"],
Cell[611780, 16980, 728, 19, 81, "Input",ExpressionUUID->"56c01f1e-80cc-4372-936c-531dc887f2f5"],
Cell[612511, 17001, 723, 19, 81, "Input",ExpressionUUID->"0520efc5-0ce3-4f3e-b32e-a780f125eeac"],
Cell[613237, 17022, 867, 24, 81, "Input",ExpressionUUID->"3281aedf-0f3c-4289-8f72-f2a286b6e280"]
}, Open  ]],
Cell[CellGroupData[{
Cell[614141, 17051, 268, 4, 70, "Subsubsection",ExpressionUUID->"fe732191-6c62-416f-ac31-7869e6c298ef"],
Cell[614412, 17057, 391, 11, 72, "Input",ExpressionUUID->"a7f80202-4acc-4d76-8d3f-9968f9a22227"],
Cell[614806, 17070, 662, 20, 43, "Input",ExpressionUUID->"33aa42fa-0d53-4ae9-9408-b6cc616052be"],
Cell[615471, 17092, 466, 13, 43, "Input",ExpressionUUID->"06f256fc-2b0e-4587-b91b-bfa92015ad1c"],
Cell[615940, 17107, 852, 22, 75, "Input",ExpressionUUID->"f3cdb03a-ab7b-4002-9f3f-aacb8d980117"]
}, Open  ]],
Cell[CellGroupData[{
Cell[616829, 17134, 242, 4, 70, "Subsubsection",ExpressionUUID->"e3b76d9a-0624-40a7-9134-ea647e95768e"],
Cell[617074, 17140, 435, 12, 43, "Input",ExpressionUUID->"4edb817f-d798-480a-8dd0-5970b8ea10dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[617546, 17157, 265, 4, 70, "Subsubsection",ExpressionUUID->"50fc3eb1-9125-4f1d-aa3a-46eef848280d"],
Cell[617814, 17163, 434, 11, 43, "Input",ExpressionUUID->"369516c1-443c-4370-8c68-cb4ab062ba60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[618285, 17179, 267, 4, 70, "Subsubsection",ExpressionUUID->"a107ec6e-2c56-4866-b8f9-78a21210ca15"],
Cell[618555, 17185, 494, 14, 43, "Input",ExpressionUUID->"79f2a848-7240-4117-ba19-e4b8b34f57b7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[619086, 17204, 265, 4, 70, "Subsubsection",ExpressionUUID->"8c689e12-d30e-4af9-a912-04b2cb2ca6fc"],
Cell[619354, 17210, 533, 17, 43, "Input",ExpressionUUID->"566e9eb8-3bf4-423b-b3b7-3b029c3c085d"],
Cell[619890, 17229, 464, 14, 43, "Input",ExpressionUUID->"6fd109d3-63ff-4d63-8c1f-88d8e3d73833"]
}, Open  ]],
Cell[CellGroupData[{
Cell[620391, 17248, 267, 4, 70, "Subsubsection",ExpressionUUID->"6ab987a7-753d-4ff9-b58c-4052324bfa8b"],
Cell[620661, 17254, 743, 21, 75, "Input",ExpressionUUID->"2780e245-78a3-4d50-928b-9d5bdea0e029"],
Cell[621407, 17277, 1005, 30, 43, "Input",ExpressionUUID->"20628c60-d243-482b-aabf-6a1391840d29"],
Cell[622415, 17309, 691, 23, 43, "Input",ExpressionUUID->"69b811ac-1b4c-4a65-b02b-9a126a7f0031"],
Cell[623109, 17334, 569, 19, 43, "Input",ExpressionUUID->"08b0fdb8-6836-4b52-9c71-13eed6d4cd4a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[623715, 17358, 267, 4, 70, "Subsubsection",ExpressionUUID->"23b9a72a-5516-4b7a-aa75-82b871c01617"],
Cell[623985, 17364, 491, 14, 43, "Input",ExpressionUUID->"1838fc25-9e28-4ac7-b82a-fac9935ea73e"],
Cell[624479, 17380, 629, 19, 75, "Input",ExpressionUUID->"fc68322b-7066-4e84-978d-a26038aaf497"],
Cell[625111, 17401, 420, 13, 43, "Input",ExpressionUUID->"7e59b36f-abec-4bac-b237-c6021995fd43"],
Cell[625534, 17416, 463, 14, 43, "Input",ExpressionUUID->"4119985b-49d8-467f-a358-4767d7eccfd3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[626034, 17435, 269, 4, 70, "Subsubsection",ExpressionUUID->"167bf759-19dc-4779-9d75-dff45f2a2123"],
Cell[626306, 17441, 393, 9, 43, "Input",ExpressionUUID->"9ff2622c-38fa-4be7-af38-a0d97e71a588"]
}, Open  ]],
Cell[CellGroupData[{
Cell[626736, 17455, 266, 4, 70, "Subsubsection",ExpressionUUID->"8c2950d4-bae8-4daf-890a-2227ae6ae602"],
Cell[627005, 17461, 220, 4, 43, "Input",ExpressionUUID->"cee16339-fc82-4080-a2cd-3a0ce5f41705"],
Cell[627228, 17467, 1074, 26, 76, "Input",ExpressionUUID->"e19bb9ad-e4c8-4bcc-aaa7-63add03caecf"],
Cell[628305, 17495, 166, 3, 53, "Text",ExpressionUUID->"c20b1169-cbdb-489b-996f-80ea429b471c"],
Cell[628474, 17500, 1492, 41, 106, "Input",ExpressionUUID->"7904bc0c-aee3-4adb-9e3d-63e2f11b0b5f"],
Cell[629969, 17543, 194, 4, 43, "Input",ExpressionUUID->"38f30bf7-ce33-4345-8596-56294064907e"],
Cell[630166, 17549, 966, 26, 76, "Input",ExpressionUUID->"b32d4dd5-8a4f-4d7d-b4a0-56496b8fe259"],
Cell[631135, 17577, 875, 26, 68, "Input",ExpressionUUID->"dff076fc-c6f7-43a0-a325-6391e77cfe63"]
}, Open  ]],
Cell[CellGroupData[{
Cell[632047, 17608, 219, 4, 70, "Subsubsection",ExpressionUUID->"f28009cd-dc6a-4273-bc23-d13c08b7434d"],
Cell[632269, 17614, 2538, 75, 178, "Input",ExpressionUUID->"74e4c711-9968-47d7-a777-3f02a2e47166"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[634868, 17696, 207, 4, 88, "Chapter",ExpressionUUID->"e719ab93-8d7b-4256-bd31-5bfc125ab086"],
Cell[CellGroupData[{
Cell[635100, 17704, 157, 3, 98, "Subchapter",ExpressionUUID->"c169eb7d-eda2-487a-9b6f-badf878d71f6"],
Cell[CellGroupData[{
Cell[635282, 17711, 185, 3, 135, "Subsubsection",ExpressionUUID->"aa8e7597-2323-41c4-9875-d690d2202ec0"],
Cell[635470, 17716, 845, 24, 150, "Input",ExpressionUUID->"f7007aff-24ff-41e0-b366-8a0b157e39ca"],
Cell[636318, 17742, 1710, 39, 157, "Input",ExpressionUUID->"be90cd78-8dc3-4853-ba5f-01b5b3d76fd4"],
Cell[638031, 17783, 4043, 96, 832, "Input",ExpressionUUID->"eb1084a2-71a9-4454-8b27-340f38dc93ad"],
Cell[642077, 17881, 311, 7, 82, "Input",ExpressionUUID->"1fcfee80-94fe-4e54-9d85-3e5e2738ed00"]
}, Open  ]],
Cell[CellGroupData[{
Cell[642425, 17893, 182, 3, 135, "Subsubsection",ExpressionUUID->"a9568ddf-a6e9-4191-b217-2428838e30be"],
Cell[642610, 17898, 1198, 37, 215, "Input",ExpressionUUID->"b623e636-337e-4b88-ad0c-2703ff7c30a0"],
Cell[643811, 17937, 299, 6, 82, "Input",ExpressionUUID->"ee09307b-29a9-41b0-9e03-7b9f6b0b36fd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[644147, 17948, 184, 3, 135, "Subsubsection",ExpressionUUID->"089e9422-7198-474b-90ee-b95aa9f1201a"],
Cell[644334, 17953, 1221, 36, 145, "Input",ExpressionUUID->"a72e6ebc-528d-44c9-bc72-30b57823c5bc"],
Cell[645558, 17991, 295, 6, 82, "Input",ExpressionUUID->"e10a97f4-6b30-477e-8acd-d28c801b7e61"],
Cell[645856, 17999, 1221, 36, 145, "Input",ExpressionUUID->"2e42f9c5-101a-42a6-89c3-0e551fe041ac"],
Cell[647080, 18037, 292, 6, 82, "Input",ExpressionUUID->"9f11103a-0119-4179-b711-271553878e62"]
}, Open  ]],
Cell[CellGroupData[{
Cell[647409, 18048, 186, 3, 135, "Subsubsection",ExpressionUUID->"0a65bea2-a54e-421e-b78e-d8a201b600af"],
Cell[647598, 18053, 282, 7, 82, "Input",ExpressionUUID->"a490552d-fce5-4d93-9653-12115ded88a9"],
Cell[647883, 18062, 1271, 29, 203, "Input",ExpressionUUID->"afa22efc-9e4c-4455-97f6-43c1fb9796aa"],
Cell[649157, 18093, 370, 8, 82, "Input",ExpressionUUID->"834b9a50-c877-4e6c-866a-72153661eef6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[649564, 18106, 190, 3, 135, "Subsubsection",ExpressionUUID->"a4e17fef-4201-4ae4-ba12-a369a3a88f90"],
Cell[649757, 18111, 667, 15, 145, "Input",ExpressionUUID->"b442afc7-1dc0-4aaf-9bae-ef32e9f66a54"],
Cell[650427, 18128, 469, 9, 82, "Input",ExpressionUUID->"d0865587-8c2e-4ce8-a008-ecba4b625906"]
}, Open  ]],
Cell[CellGroupData[{
Cell[650933, 18142, 214, 4, 135, "Subsubsection",ExpressionUUID->"905c121c-8268-4662-b13c-e1b7457ff4bb"],
Cell[651150, 18148, 4998, 128, 790, "Input",ExpressionUUID->"b38e858e-bbf1-4c97-97bc-5fc90edab1a5"],
Cell[656151, 18278, 295, 6, 82, "Input",ExpressionUUID->"8623f307-e43e-4db9-bedc-4882149fbef6"],
Cell[656449, 18286, 5597, 144, 965, "Input",ExpressionUUID->"063b34dd-1047-4390-a28a-eab1ac56dd4d"],
Cell[662049, 18432, 296, 6, 82, "Input",ExpressionUUID->"03fbfd4a-b651-4f5b-94b7-bb88b041488e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[662382, 18443, 188, 3, 135, "Subsubsection",ExpressionUUID->"aa36637a-ecda-4c66-83d7-37e822a516ed"],
Cell[662573, 18448, 682, 17, 145, "Input",ExpressionUUID->"6671232e-1693-49b8-aacc-aecc5ed75384"],
Cell[663258, 18467, 1505, 37, 438, "Input",ExpressionUUID->"0ad78456-efd8-462b-b696-fea40f4e36e0"],
Cell[664766, 18506, 1273, 37, 321, "Input",ExpressionUUID->"33fa3cde-29ca-4186-82fe-dbd930c2ebd1"],
Cell[666042, 18545, 297, 6, 82, "Input",ExpressionUUID->"32cd007d-40f9-4426-a985-45019ea77c70"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[666388, 18557, 162, 3, 72, "Subchapter",ExpressionUUID->"723c9ca8-8ebb-464a-b404-4da6acb2245f"],
Cell[666553, 18562, 163, 3, 70, "Subsubsection",ExpressionUUID->"cdb8d12f-476a-450a-8056-fd61fc43fb11"],
Cell[CellGroupData[{
Cell[666741, 18569, 216, 4, 56, "Subsubsection",ExpressionUUID->"d8e02ef6-9b13-4d55-9270-9ac607d9755b"],
Cell[666960, 18575, 1109, 31, 105, "Input",ExpressionUUID->"ceb13eb7-e672-4c09-b3eb-30bf7a5ca8a1"],
Cell[668072, 18608, 271, 7, 43, "Input",ExpressionUUID->"33c32a0e-86d4-4644-a0c1-e1c937ea57d2"],
Cell[668346, 18617, 438, 13, 43, "Input",ExpressionUUID->"e9221f6b-4ea1-4174-9704-82f5bc21c726"],
Cell[668787, 18632, 349, 10, 43, "Input",ExpressionUUID->"5b34b4aa-aab2-4ce5-adb2-cebab62b6bc0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[669173, 18647, 267, 4, 70, "Subsubsection",ExpressionUUID->"a6c9ccd0-77c8-4379-92a2-56191803b0f9"],
Cell[669443, 18653, 816, 25, 43, "Input",ExpressionUUID->"e6c5cb1e-b978-4276-bf06-db0bccfa25f8"],
Cell[670262, 18680, 543, 13, 43, "Input",ExpressionUUID->"d0cf78a5-0de6-4a2c-9859-8faa97f25ff4"],
Cell[670808, 18695, 653, 19, 43, "Input",ExpressionUUID->"785fed2d-b979-4534-9d72-73d5b1bfdd45"],
Cell[671464, 18716, 990, 28, 60, "Input",ExpressionUUID->"3031dbf5-c72a-4906-bab2-3181df389b94"],
Cell[672457, 18746, 340, 10, 35, "Input",ExpressionUUID->"c3dc3c13-5217-4add-8256-ee451a893f63"]
}, Open  ]],
Cell[CellGroupData[{
Cell[672834, 18761, 318, 5, 56, "Subsubsection",ExpressionUUID->"48e691fb-ade7-4537-bf5d-65b7bd63911d"],
Cell[673155, 18768, 394, 10, 35, "Input",ExpressionUUID->"276cbb37-e7d0-4e75-9ede-187664abd681"],
Cell[673552, 18780, 803, 21, 60, "Input",ExpressionUUID->"6f683840-fc6a-49dd-9902-674e31f6514c"],
Cell[674358, 18803, 1001, 26, 60, "Input",ExpressionUUID->"4ad2dd2e-9cf1-4901-8a18-7077c9bc6837"],
Cell[675362, 18831, 1158, 40, 61, "Input",ExpressionUUID->"9326d7dd-52e6-4d5b-9e22-643c89cda783"]
}, Open  ]],
Cell[CellGroupData[{
Cell[676557, 18876, 369, 6, 56, "Subsubsection",ExpressionUUID->"179c2a2f-5385-4f0a-8885-3c5382ec1704"],
Cell[676929, 18884, 1302, 33, 84, "Input",ExpressionUUID->"3baa97a0-62b3-4cee-91a6-ac71daa06371"],
Cell[678234, 18919, 1307, 36, 77, "Input",ExpressionUUID->"7ca70dd0-f6c5-4378-8e20-22a7053982ba"],
Cell[679544, 18957, 1256, 31, 60, "Input",ExpressionUUID->"ecbc5ce4-41e2-4e80-b08a-7a0fbff8fdbd"],
Cell[680803, 18990, 510, 14, 35, "Input",ExpressionUUID->"045ad276-c3d2-4ec2-bdf6-235c3bf2c47e"],
Cell[681316, 19006, 338, 9, 38, "Input",ExpressionUUID->"94afeee3-8ba1-46af-91ca-769cf74c774d"],
Cell[681657, 19017, 414, 12, 38, "Input",ExpressionUUID->"dbb9d543-0d39-4c67-9d9e-cbbecc0e56a7"],
Cell[682074, 19031, 392, 11, 35, "Input",ExpressionUUID->"b9af0142-0c57-4ed2-a54d-80a54d9d7d81"],
Cell[682469, 19044, 464, 14, 35, "Input",ExpressionUUID->"7e41247b-285e-4023-8e85-6fd3359bb9ed"],
Cell[682936, 19060, 487, 16, 38, "Input",ExpressionUUID->"821d1e06-d968-44db-9c22-23854cc79f21"],
Cell[683426, 19078, 307, 8, 35, "Input",ExpressionUUID->"46c00470-3d20-4894-83a2-7dd8e33fe761"],
Cell[683736, 19088, 2508, 80, 119, "Input",ExpressionUUID->"2bde357e-30f1-4f46-96a0-4ee2ea86dec0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[686281, 19173, 164, 3, 56, "Subsubsection",ExpressionUUID->"a982e97f-3f70-45b9-815b-2fd7fc4fc949"],
Cell[686448, 19178, 590, 16, 43, "Input",ExpressionUUID->"c8fa88f5-d425-44a1-9e23-8905ef8bfe29"],
Cell[687041, 19196, 765, 20, 43, "Input",ExpressionUUID->"8b5adb2f-4428-4a0c-a983-e5546fb09543"],
Cell[687809, 19218, 866, 22, 43, "Input",ExpressionUUID->"57f7b2a7-14c7-48bc-8c7c-653a65c08975"],
Cell[688678, 19242, 392, 9, 43, "Input",ExpressionUUID->"2e8dca9f-95b7-4fbd-b104-41f164457e59"],
Cell[689073, 19253, 1114, 30, 75, "Input",ExpressionUUID->"2e29da28-87af-4b70-842b-9f410e7d7016"],
Cell[690190, 19285, 266, 7, 43, "Input",ExpressionUUID->"0c69ae6c-a382-4551-8e27-cb9a66ac2d7f"],
Cell[690459, 19294, 1091, 28, 75, "Input",ExpressionUUID->"1676b426-0056-401e-ad05-3a492ee0d1e4"],
Cell[691553, 19324, 448, 13, 43, "Input",ExpressionUUID->"93220d5e-322b-4510-bcfa-506ec3003fd5"],
Cell[692004, 19339, 370, 10, 43, "Input",ExpressionUUID->"fb046407-9e78-4cfe-8342-ed5f1b69633d"],
Cell[692377, 19351, 309, 10, 43, "Input",ExpressionUUID->"353f16d7-b2e4-46d4-a6d1-e970644cf6f1"],
Cell[692689, 19363, 426, 12, 43, "Input",ExpressionUUID->"f071784e-59aa-4d46-bfdb-9e660efccf00"],
Cell[693118, 19377, 374, 11, 43, "Input",ExpressionUUID->"41eef70f-e87f-4071-9deb-c4384ea81ab8"],
Cell[693495, 19390, 553, 15, 43, "Input",ExpressionUUID->"84278b59-1214-4b8c-8e52-93312471bd57"]
}, Open  ]],
Cell[CellGroupData[{
Cell[694085, 19410, 166, 3, 70, "Subsubsection",ExpressionUUID->"b03fe876-e37e-4f54-a32a-bde999b40177"],
Cell[694254, 19415, 1017, 26, 75, "Input",ExpressionUUID->"36dd6e21-e4cf-421b-ae4a-e71144016782"],
Cell[695274, 19443, 307, 7, 43, "Input",ExpressionUUID->"e5b34e85-1d43-4bca-8aae-4b4a769d389d"],
Cell[695584, 19452, 875, 22, 75, "Input",ExpressionUUID->"79ce0a41-df9b-4b50-926e-f4c670b3e1a1"],
Cell[696462, 19476, 208, 5, 43, "Input",ExpressionUUID->"0f426ab9-483f-4cd4-ac8c-e5e5fe6f37b8"],
Cell[696673, 19483, 763, 23, 75, "Input",ExpressionUUID->"3492c567-0ed8-44f2-922c-9b87a1ad23a9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[697473, 19511, 212, 4, 70, "Subsubsection",ExpressionUUID->"d2594a38-85f6-4298-a1d0-9ce54dbf7de3"],
Cell[697688, 19517, 668, 19, 35, "Input",ExpressionUUID->"06c26587-01e4-4754-9d58-98bf6d3d26fb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[698393, 19541, 164, 3, 56, "Subsubsection",ExpressionUUID->"d7758bb7-3350-4ba9-8a1c-cf815ab602b5"],
Cell[698560, 19546, 898, 29, 55, "Input",ExpressionUUID->"43ccedff-0e5d-4f1d-8e24-6835bdb0a134"],
Cell[699461, 19577, 998, 31, 35, "Input",ExpressionUUID->"4a4def27-6e55-47aa-8ea0-0c60f4a330fd"],
Cell[700462, 19610, 816, 24, 35, "Input",ExpressionUUID->"7c61f872-396d-4904-9e54-0aaf8f0376a5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[701315, 19639, 213, 4, 56, "Subsubsection",ExpressionUUID->"9516d3b4-1a9f-4063-895d-a4e88afd8168"],
Cell[701531, 19645, 735, 23, 60, "Input",ExpressionUUID->"967d2e96-ff0f-4a16-a3ce-aaa3ca29cdba"],
Cell[702269, 19670, 434, 13, 35, "Input",ExpressionUUID->"b58ec13b-bada-4c1c-b470-fe9380d5f958"],
Cell[702706, 19685, 437, 13, 35, "Input",ExpressionUUID->"00a59bf4-58c5-4b13-a71a-e2d50857df98"]
}, Open  ]],
Cell[CellGroupData[{
Cell[703180, 19703, 259, 4, 56, "Subsubsection",ExpressionUUID->"f0ed0d82-fc11-4dfb-8c12-c8607cf4bab8"],
Cell[703442, 19709, 722, 21, 35, "Input",ExpressionUUID->"6be7e695-a4fa-4ecd-9e29-c2df2d42a26b"],
Cell[704167, 19732, 256, 7, 35, "Input",ExpressionUUID->"24e20d3d-aaba-405e-80f9-e4b6703598ff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[704460, 19744, 308, 5, 56, "Subsubsection",ExpressionUUID->"aabd903e-d9fe-403c-bab5-9aa56799e1b8"],
Cell[704771, 19751, 617, 18, 35, "Input",ExpressionUUID->"ab937018-fbad-4de2-9b96-40020f104081"],
Cell[705391, 19771, 320, 9, 35, "Input",ExpressionUUID->"58a28110-35c1-4e3f-8cb9-d35357a6c599"],
Cell[705714, 19782, 791, 23, 35, "Input",ExpressionUUID->"07131897-4b75-46cd-bd3f-9be57e15f108"]
}, Open  ]],
Cell[CellGroupData[{
Cell[706542, 19810, 361, 6, 56, "Subsubsection",ExpressionUUID->"e545c45c-147e-4731-a0e0-f9d8d7ca2282"],
Cell[706906, 19818, 883, 26, 60, "Input",ExpressionUUID->"26964ac8-3179-4863-9a32-7784bf0b6989"],
Cell[707792, 19846, 989, 29, 60, "Input",ExpressionUUID->"e1755d04-66f7-488e-9b45-7b1c59a120d8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[708818, 19880, 411, 6, 56, "Subsubsection",ExpressionUUID->"360e9304-6d3e-4228-b799-c9686979a7fb"],
Cell[709232, 19888, 741, 18, 60, "Input",ExpressionUUID->"0ac8c2d4-21a3-42b4-9f57-46d2fc7b3785"],
Cell[709976, 19908, 363, 11, 35, "Input",ExpressionUUID->"d5fdb842-8a46-4404-902a-70bc90b7b623"]
}, Open  ]],
Cell[CellGroupData[{
Cell[710376, 19924, 194, 4, 56, "Subsubsection",ExpressionUUID->"18159500-ec3f-4f5a-9dd7-7288e5c2c147"],
Cell[710573, 19930, 325, 7, 35, "Input",ExpressionUUID->"41c0b401-ed27-4e8a-bd02-b4d7a2b93354"],
Cell[710901, 19939, 147, 3, 43, "Text",ExpressionUUID->"d29dc327-a9d7-4e57-a64e-a606bf453a1e"],
Cell[711051, 19944, 600, 14, 35, "Input",ExpressionUUID->"aefa48e1-9691-4519-95e7-1d2ad6d88269"],
Cell[711654, 19960, 786, 20, 35, "Input",ExpressionUUID->"b684eb14-b4fe-401e-97ed-51263c216f81"],
Cell[712443, 19982, 249, 5, 43, "Text",ExpressionUUID->"64f62fb8-f0ff-40a8-92ed-c18fa5adc7ae"],
Cell[712695, 19989, 332, 8, 35, "Input",ExpressionUUID->"c087f864-06d1-4310-9ce0-5442c91dc772"],
Cell[713030, 19999, 170, 3, 43, "Text",ExpressionUUID->"bd3e9e72-1ea4-4e69-aeca-6f85be4e3871"],
Cell[713203, 20004, 684, 21, 75, "Input",ExpressionUUID->"ee1f384b-1fea-4d43-a1fc-d6ee59d9cc7c"],
Cell[713890, 20027, 356, 10, 35, "Input",ExpressionUUID->"da14a4b2-b2a1-439c-b296-82908eb6d53b"],
Cell[714249, 20039, 237, 6, 35, "Input",ExpressionUUID->"b7d94d4f-6456-4952-8896-235c2be1045d"],
Cell[714489, 20047, 452, 14, 35, "Input",ExpressionUUID->"5bb785f2-73e5-461e-ba3b-cef80b1f9044"],
Cell[714944, 20063, 764, 20, 35, "Input",ExpressionUUID->"9d0ce8ed-807e-4faa-80db-d2900d298d31"],
Cell[715711, 20085, 224, 5, 35, "Input",ExpressionUUID->"7f941aee-1bdb-447a-a7fe-3ea16fb134c1"],
Cell[715938, 20092, 499, 9, 71, "Text",ExpressionUUID->"d8e468e2-ae0e-4274-bf51-6c6e6e3b7443"],
Cell[716440, 20103, 407, 12, 35, "Input",ExpressionUUID->"57653a9a-33ad-47f3-864b-b8b67d76091c"],
Cell[716850, 20117, 685, 16, 35, "Input",ExpressionUUID->"278b0ec3-d3a9-4974-9234-2981bd07e2af"],
Cell[717538, 20135, 303, 6, 71, "Text",ExpressionUUID->"3186624d-118c-47ec-b25a-ab31d0398c4d"],
Cell[717844, 20143, 551, 11, 35, "Input",ExpressionUUID->"11128fa8-7831-4c1b-af01-82668ae75fc6"],
Cell[718398, 20156, 150, 3, 43, "Text",ExpressionUUID->"3b8f8923-e4db-4aa6-89fc-5b71d8a0f86c"],
Cell[718551, 20161, 652, 14, 35, "Input",ExpressionUUID->"b5571093-2b88-4cd9-94b2-9d9e0f18bb4e"],
Cell[719206, 20177, 271, 7, 35, "Input",ExpressionUUID->"793d79aa-e5c0-4474-b53e-3545ccbf8905"],
Cell[719480, 20186, 341, 9, 35, "Input",ExpressionUUID->"a90e615d-d18c-4486-a034-85453b169cae"],
Cell[719824, 20197, 152, 3, 43, "Text",ExpressionUUID->"51925615-804e-43aa-a076-e7a9a0331af9"],
Cell[719979, 20202, 343, 9, 35, "Input",ExpressionUUID->"e425692d-ad71-40b6-afb7-4284d9d2e1e6"],
Cell[720325, 20213, 455, 12, 35, "Input",ExpressionUUID->"4a366955-5ec2-452b-bc27-f3869ca73cdc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[720817, 20230, 246, 5, 56, "Subsubsection",ExpressionUUID->"9c1e2837-996f-42aa-ac74-311138b8d53c"],
Cell[721066, 20237, 1117, 36, 84, "Input",ExpressionUUID->"09907237-5951-492c-9456-09b2f8bf0ab6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[722220, 20278, 246, 5, 56, "Subsubsection",ExpressionUUID->"500f7fd9-dfc1-40bd-b930-a5ca26dd41a4"],
Cell[722469, 20285, 879, 28, 60, "Input",ExpressionUUID->"05254a93-471d-478d-ad45-55623fd9474b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[723385, 20318, 244, 5, 56, "Subsubsection",ExpressionUUID->"d95c5a33-db39-4a95-a90b-50e493bd0d93"],
Cell[723632, 20325, 624, 20, 35, "Input",ExpressionUUID->"f529718d-7c36-4ec5-b42b-87e636194569"],
Cell[724259, 20347, 509, 16, 84, "Input",ExpressionUUID->"c7af2dbc-2553-4124-9cbb-5f86369bb0b7"],
Cell[724771, 20365, 799, 23, 38, "Input",ExpressionUUID->"155d8a5c-1c7b-4401-9f08-81ea19f01f86"],
Cell[725573, 20390, 1558, 44, 92, "Input",ExpressionUUID->"438870e0-c7c9-44b8-a1ea-26547a54a4fd"],
Cell[727134, 20436, 1528, 43, 92, "Input",ExpressionUUID->"8ad1e2cd-da7b-44bd-983b-ecf89e995ff3"],
Cell[728665, 20481, 1052, 31, 38, "Input",ExpressionUUID->"16484f6b-8580-4bc3-8f85-9409c2b9c6c1"],
Cell[729720, 20514, 473, 13, 35, "Input",ExpressionUUID->"da9c1c27-a46a-4a60-90ef-196e27541910"],
Cell[730196, 20529, 473, 13, 43, "Input",ExpressionUUID->"6293c9c8-ebcb-4232-a8b5-053c19fd1fa2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[730706, 20547, 294, 5, 70, "Subsubsection",ExpressionUUID->"6baba51f-a36f-4198-94c1-63a3ef18d7eb"],
Cell[731003, 20554, 707, 19, 43, "Input",ExpressionUUID->"9da82745-5172-4901-8fed-716ffcee3ec3"],
Cell[731713, 20575, 457, 13, 43, "Input",ExpressionUUID->"dcc3a3b4-de72-4786-924a-54dcb8362b3b"],
Cell[732173, 20590, 392, 12, 43, "Input",ExpressionUUID->"20f9573b-af3d-4036-aae1-131c8acc0b39"],
Cell[732568, 20604, 325, 9, 43, "Input",ExpressionUUID->"ec2cca44-d413-48ef-b435-491b492281b1"],
Cell[732896, 20615, 414, 13, 65, "Input",ExpressionUUID->"85e73e65-3ff3-4fb4-8ab2-f1e197a04a1c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[733347, 20633, 348, 6, 70, "Subsubsection",ExpressionUUID->"1ffc5f6f-39dd-43c0-888d-4ca9e4713d75"],
Cell[733698, 20641, 1378, 45, 105, "Input",ExpressionUUID->"d035de8e-3c60-40e6-8526-328e3051ef1c"],
Cell[735079, 20688, 2029, 63, 107, "Input",ExpressionUUID->"bc77ba29-ff81-4094-850f-5331b8bfdadc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[737169, 20758, 256, 4, 88, "Chapter",ExpressionUUID->"b2de62bd-f1f3-41e8-a2a6-c8a74073159d"],
Cell[CellGroupData[{
Cell[737450, 20766, 157, 3, 98, "Subchapter",ExpressionUUID->"475b4372-9fe5-4a59-a7a4-834e7ac4abde"],
Cell[CellGroupData[{
Cell[737632, 20773, 190, 3, 70, "Subsubsection",Expres