(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[  13173633,     239470]
NotebookOptionsPosition[  13117647,     238659]
NotebookOutlinePosition[  13118270,     238681]
CellTagsIndexPosition[  13118227,     238678]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Read here before starting", "Title",
 CellChangeTimes->{{3.709233690161606*^9, 3.709233726757881*^9}, 
   3.709233806295512*^9, {3.710600974718481*^9, 3.710600978551302*^9}, {
   3.7190640231648617`*^9, 3.719064034784334*^9}, {3.719064119783753*^9, 
   3.719064131847783*^9}},ExpressionUUID->"c2daf3af-062f-4c92-a4c0-\
c098ecfa6d6a"],

Cell["Software version 1.0.0", "Section",
 CellChangeTimes->{{3.7190650717037687`*^9, 3.71906515103926*^9}, {
  3.7348724712435207`*^9, 
  3.734872478650226*^9}},ExpressionUUID->"618d01c2-e7ae-4267-8695-\
35fecac9f4b2"],

Cell[CellGroupData[{

Cell["Citation, updates, copyright, URLs", "Section",
 CellChangeTimes->{{3.7190650717037687`*^9, 
  3.71906515103926*^9}},ExpressionUUID->"46c7ceb8-7097-41b9-8f23-\
a09c0fbaec5b"],

Cell[TextData[{
 "This code provides software associated with the following book.\n\nFrank, \
S. A. 2018. Control theory tutorial: basic concepts illustrated by software \
examples. Springer, Cham, Switzerland.  \n\nThis book is open access and \
freely available at:  ",
 ButtonBox["https://doi.org/10.1007/978-3-319-91707-8",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.1007/978-3-319-91707-8"], None},
  ButtonNote->"https://doi.org/10.1007/978-3-319-91707-8"],
 ".\n\nSoftware version 1.0.0.\n\nThis software and updates may be obtained \
at ",
 ButtonBox["http://extras.springer.com/2018/978-3-319-91707-8",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://extras.springer.com/2018/978-3-319-91707-8"], None},
  ButtonNote->"http://extras.springer.com/2018/978-3-319-91707-8"],
 ".\n\nThis work is licensed under a ",
 ButtonBox["Creative Commons Attribution 4.0 International License",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://creativecommons.org/licenses/by/4.0/"], None},
  ButtonNote->"https://creativecommons.org/licenses/by/4.0/"],
 ", Copyright \[Copyright] 2018 by Steven A. Frank.\n\nThis software code was \
originally released on Zenodo at ",
 ButtonBox["https://doi.org/10.5281/zenodo.1043921 ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.5281/zenodo.1043921"], None},
  ButtonNote->"https://doi.org/10.5281/zenodo.1043921"],
 "under a ",
 ButtonBox["Creative Commons Attribution-NonCommercial 4.0 International \
License,",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://creativecommons.org/licenses/by-nc/4.0/"], None},
  ButtonNote->"https://creativecommons.org/licenses/by-nc/4.0/"],
 " copyright \[Copyright] 2017 by Steven A. Frank. "
}], "Text",
 CellChangeTimes->{{3.719064255025988*^9, 3.7190643289697638`*^9}, {
   3.71906470802849*^9, 3.719064725194725*^9}, 3.719064761916712*^9, {
   3.7190648096875963`*^9, 3.719064809690564*^9}, {3.719064850944173*^9, 
   3.719064937436658*^9}, {3.719064989900496*^9, 3.719065019623425*^9}, {
   3.7190651731965227`*^9, 3.719065175121461*^9}, {3.719140879326412*^9, 
   3.719140964275288*^9}, {3.719141835377434*^9, 3.7191418377077427`*^9}, 
   3.719141871059662*^9, {3.719141917573235*^9, 3.7191420024981737`*^9}, 
   3.7193285858311653`*^9, 3.7193295993055973`*^9, {3.734869609589856*^9, 
   3.734869662417233*^9}, {3.734869699985014*^9, 3.734869703695655*^9}, {
   3.734869734279066*^9, 3.73486978067614*^9}, {3.734869858513637*^9, 
   3.734869890241852*^9}, {3.73486992604834*^9, 3.734870140451339*^9}, {
   3.734870195604788*^9, 3.734870239800288*^9}, {3.7348706753442173`*^9, 
   3.7348706801713*^9}, {3.734870772980722*^9, 3.734870784801754*^9}, {
   3.734870821849058*^9, 3.734870851990468*^9}, {3.734871028848298*^9, 
   3.734871031991111*^9}, {3.734871069231472*^9, 3.7348712192235727`*^9}, {
   3.734871249839225*^9, 3.734871267445405*^9}, {3.7348713759941053`*^9, 
   3.7348713892945967`*^9}, {3.734871449894568*^9, 3.7348714651809883`*^9}, {
   3.734871504017374*^9, 
   3.734871639141487*^9}},ExpressionUUID->"fc845a14-e744-44fe-ade0-\
b0fc7b042477"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Using this code with Mathematica: required programs and files\
\>", "Section",
 CellChangeTimes->{{3.7190650717037687`*^9, 3.71906515103926*^9}, {
  3.719065420360441*^9, 3.719065446130809*^9}, {3.719065803501192*^9, 
  3.71906584222062*^9}},ExpressionUUID->"aeae751b-c9c6-474d-b0b0-\
c42276fa0202"],

Cell[TextData[{
 "This code was developed with Mathematica version 11.2, see ",
 ButtonBox["http://www.wolfram.com/mathematica/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/mathematica/"],
 ". \n\nMathematica is a commercial product that requires a paid license. A \
free reader program is available that allows one to view Mathematica \
notebooks and embedded graphics. See ",
 ButtonBox["https://www.wolfram.com/cdf-player/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://www.wolfram.com/cdf-player/"], None},
  ButtonNote->"https://www.wolfram.com/cdf-player/"],
 ".\n\nAt the download site for this software (see previous section), the \
file with extension .nb is a Mathematica notebook. That notebook includes \
embedded graphics for most of the figures generated in the manuscript. \
Because of the graphics, it is a large file. The file with extension .m is a \
Mathematica m-file. That file does not contain graphics and is much smaller. \
The m-file can be imported into a notebook file for use. "
}], "Text",
 CellChangeTimes->{{3.719064255025988*^9, 3.7190643289697638`*^9}, {
   3.71906470802849*^9, 3.719064725194725*^9}, 3.719064761916712*^9, {
   3.7190648096875963`*^9, 3.719064809690564*^9}, {3.719064850944173*^9, 
   3.719064937436658*^9}, {3.719064989900496*^9, 3.719065019623425*^9}, {
   3.7190651731965227`*^9, 3.719065175121461*^9}, {3.719065465586804*^9, 
   3.71906577298682*^9}, {3.719065869100634*^9, 3.719065882430697*^9}, {
   3.719141084484973*^9, 3.7191410942832336`*^9}, {3.719142036041356*^9, 
   3.719142069436923*^9}},ExpressionUUID->"bb78be29-364b-46af-bbe4-\
ee0b14102a51"]
}, Closed]],

Cell[CellGroupData[{

Cell["Notes on using the code, settings that must be changed", "Section",
 CellChangeTimes->{{3.7190650717037687`*^9, 3.71906515103926*^9}, {
  3.719065420360441*^9, 3.719065446130809*^9}, {3.719065803501192*^9, 
  3.71906584222062*^9}, {3.719065987683613*^9, 
  3.719065998941663*^9}},ExpressionUUID->"33b9c90b-1e00-45e7-8905-\
420cc66df723"],

Cell[TextData[{
 "I originally developed this code for my own use rather than for \
distribution. Please send any comments, bug fixes, or rewritten code to me at \
",
 StyleBox["safrank",
  IgnoreSpellCheck->True],
 " AT ",
 StyleBox["uci",
  IgnoreSpellCheck->True],
 ".",
 StyleBox["edu",
  IgnoreSpellCheck->True],
 " [replace AT with @]. Thanks."
}], "Text",
 CellFrame->{{0, 0}, {2, 0}},
 CellChangeTimes->{{3.719141324842013*^9, 3.719141330811226*^9}, 
   3.7348694629151278`*^9},ExpressionUUID->"9e820761-6582-4b93-9060-\
c515339e02ca"],

Cell[TextData[{
 "In the first section \[OpenCurlyDoubleQuote]Generic transfer function and \
other functions for initialization\[CloseCurlyDoubleQuote] there are settings \
for the directory location for output graphics files. Change the setting for ",
 StyleBox["gdir",
  FontWeight->"Bold"],
 " and ",
 StyleBox["gdirlocal",
  FontWeight->"Bold"],
 " to be appropriate for your system.\n\nThat first section also includes \
code that automatically loads whenever code in any part of the file is used. \
Most sections in the file do not depend on the initialization code, but some \
sections do depend on that code. You can change the requirement for loading \
the initialization cell if you wish. See the Mathematica documentation.\n\n\
Problems in execution can develop if you use the code from different sections \
without clearing all variables. I have added Clear[] statements in several \
places. However, I have not carefully cleared all variables, and clashes will \
likely occur in various places. The simplest quick fix is to quit the \
Mathematica kernel [Menu -> Evaluation -> Quit Kernel -> Make correct choice \
for kernel]. Then restart in the place you want to work, and things should \
work well for a while, until another clash arises. Clashes are not common, \
but they can happen, so be aware of this problem before considering whether \
or not the code works correctly.\n\nThe sections in this file match the order \
of the presentation in the manuscript. In many places in this file, there is \
additional code that was not used in the text. You can use that additional \
code or ignore it.\n\nThe best way to begin with the code is to find a \
graphic in the manuscript and match it with the code in this file that \
generated the graphic. Work through the presentation in the text and how that \
presentation corresponds to the code and the associated graphic. \n\nThe code \
to handle relatively complex control problems can often be fairly simple in \
Mathematica, because of the great power of the Mathematica control library. \
So do not be misled by the simplicity of the code, which can often be used to \
analyze reasonably complex problems. The code here provides the basis for \
research studies in many disciplines. \n\nYou will probably have to spend a \
significant amount of time reading the Mathematica documentation to \
understand how the code works. That time investment is worthwhile, because \
mastery of the Mathematica control library will be repaid by the subsequent \
ease with which one can solve complex control problems."
}], "Text",
 CellChangeTimes->{{3.719064255025988*^9, 3.7190643289697638`*^9}, {
   3.71906470802849*^9, 3.719064725194725*^9}, 3.719064761916712*^9, {
   3.7190648096875963`*^9, 3.719064809690564*^9}, {3.719064850944173*^9, 
   3.719064937436658*^9}, {3.719064989900496*^9, 3.719065019623425*^9}, {
   3.7190651731965227`*^9, 3.719065175121461*^9}, {3.719065465586804*^9, 
   3.71906577298682*^9}, {3.719065869100634*^9, 3.719065882430697*^9}, 
   3.719066004154127*^9, {3.7190660348963957`*^9, 3.719066126865996*^9}, {
   3.719066174808473*^9, 3.719066261030501*^9}, {3.7190664306367702`*^9, 
   3.719066710631255*^9}, {3.719066771878374*^9, 3.719066773940312*^9}, {
   3.719066899080071*^9, 3.7190670818784723`*^9}, {3.7190671662675457`*^9, 
   3.719067272269265*^9}, {3.719141188554697*^9, 3.7191411887919197`*^9}, {
   3.719141482445272*^9, 3.719141482921425*^9}, {3.719141523760689*^9, 
   3.719141524487198*^9}},ExpressionUUID->"0b65227a-e6fb-4ca8-8236-\
a0dfb1ffe60c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Send bug fixes and comments on the code to the author", "Section",
 CellChangeTimes->{{3.7190650717037687`*^9, 3.71906515103926*^9}, {
  3.719065420360441*^9, 3.719065446130809*^9}, {3.719065803501192*^9, 
  3.71906584222062*^9}, {3.719065987683613*^9, 3.719065998941663*^9}, {
  3.719066299780718*^9, 
  3.7190663100637407`*^9}},ExpressionUUID->"36c4ae2d-3b5f-4e09-b71b-\
ba2673646c05"],

Cell["\<\
I originally developed this code for my own use rather than for distribution. \
Please send any comments, bug fixes, or rewritten code to me at safrank AT \
uci.edu [replace AT with @]. Thanks.\
\>", "Text",
 CellChangeTimes->{{3.719064255025988*^9, 3.7190643289697638`*^9}, {
   3.71906470802849*^9, 3.719064725194725*^9}, 3.719064761916712*^9, {
   3.7190648096875963`*^9, 3.719064809690564*^9}, {3.719064850944173*^9, 
   3.719064937436658*^9}, {3.719064989900496*^9, 3.719065019623425*^9}, {
   3.7190651731965227`*^9, 3.719065175121461*^9}, {3.719065465586804*^9, 
   3.71906577298682*^9}, {3.719065869100634*^9, 3.719065882430697*^9}, 
   3.719066004154127*^9, {3.7190660348963957`*^9, 3.719066126865996*^9}, {
   3.719066174808473*^9, 3.719066261030501*^9}, {3.7190663228810368`*^9, 
   3.719066415117244*^9}, 
   3.73486940940419*^9},ExpressionUUID->"cecec471-2971-481e-8388-\
f8faba1c977d"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Control theory tutorial", "Title",
 CellFrame->{{0, 0}, {0, 3}},
 CellChangeTimes->{{3.709233690161606*^9, 3.709233726757881*^9}, 
   3.709233806295512*^9, {3.710600974718481*^9, 3.710600978551302*^9}, {
   3.7190640231648617`*^9, 
   3.719064034784334*^9}},ExpressionUUID->"766356e1-168c-4b6c-8863-\
650345d9443a"],

Cell[CellGroupData[{

Cell["\<\
Generic transfer function and other functions for initialization\
\>", "Section",
 CellChangeTimes->{{3.709200445352656*^9, 3.7092004504509706`*^9}, {
  3.70923376997762*^9, 3.709233772027843*^9}, {3.7106009847274103`*^9, 
  3.710600993211993*^9}, {3.715718175619029*^9, 
  3.715718182150567*^9}},ExpressionUUID->"c0952a4a-94b6-4c5e-9cbc-\
2f087f02042a"],

Cell[CellGroupData[{

Cell["Key functions", "Subsection",
 CellChangeTimes->{{3.709228250898985*^9, 
  3.709228265188377*^9}},ExpressionUUID->"d42692d6-404c-4c6f-9a8b-\
024e565d261e"],

Cell[CellGroupData[{

Cell["Notes, open to see.", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.7092057565747557`*^9, 
  3.7092057797774754`*^9}},ExpressionUUID->"392326fa-48a2-4974-be45-\
f774290096a2"],

Cell["\<\
Generic transfer function to be used as plant. Provides general form for many \
common transfer functions. Can always combine transfer functions with \
SystemsModelSeriesConnect[]. Note use of optional arguments, can skip \
starting with end. Must specify exponents, otherwise will not accept as TF. 

Parameter c provides a sum of proportional and derivative response, whereas \
c=0 is pure derivative response. For step input, pure derivative response \
does not track, whereas with a proportional term c not zero, tracking is \
possible.\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.7092035059264917`*^9, 3.709203507383412*^9}, {
   3.709204102958202*^9, 3.709204162227173*^9}, {3.709204467073516*^9, 
   3.709204538832161*^9}, {3.709204641795519*^9, 3.7092046694915543`*^9}, {
   3.709204817911221*^9, 3.709204819257299*^9}, {3.7092055484297037`*^9, 
   3.7092055671799583`*^9}, 3.7092057647425613`*^9, {3.70928617275394*^9, 
   3.7092862441943808`*^9}},ExpressionUUID->"41c73862-2f28-4363-afb5-\
df8712c9bd5f"]
}, Closed]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gtf", "[", 
    RowBox[{"z_", ",", "n_", ",", "m_", ",", 
     RowBox[{"a_:", "a"}], ",", 
     RowBox[{"b_:", "b"}], ",", 
     RowBox[{"\[Zeta]_:", "\[Zeta]"}], ",", 
     RowBox[{"\[Omega]_:", "\[Omega]"}], ",", 
     RowBox[{"c_:", "c"}]}], "]"}], ":=", 
   RowBox[{"TransferFunctionCancel", "[", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"s", "+", "c"}], ")"}], "z"], "/", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"s", "+", "a"}], ")"}], "n"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"s", "+", "b"}], ")"}], "n"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[Omega]", 
             RowBox[{"-", "2"}]], 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["s", "2"], "+", 
              RowBox[{"2", "\[Zeta]", " ", "\[Omega]", " ", "s"}], "+", 
              SuperscriptBox["\[Omega]", "2"]}], ")"}]}], ")"}], "m"]}], 
        ")"}]}], ",", "s"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FS", "[", "x_", "]"}], ":=", 
    RowBox[{"FullSimplify", "[", "x", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TF", "[", "model_", "]"}], ":=", 
   RowBox[{"TransferFunctionCancel", "[", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{"model", ",", "s"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TFconnect", "[", 
    RowBox[{"tf1_", ",", "tf2_"}], "]"}], ":=", 
   RowBox[{"TransferFunctionCancel", "[", 
    RowBox[{"SystemsModelSeriesConnect", "[", 
     RowBox[{"tf1", ",", "tf2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TFloop", "[", "tf_", "]"}], ":=", 
    RowBox[{"FS", "[", 
     RowBox[{"TransferFunctionCancel", "[", 
      RowBox[{"TF", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"tf", "[", "s", "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"tf", "[", "s", "]"}]}], ")"}]}], ")"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"gtfn", "[", 
     RowBox[{"z_", ",", "n_", ",", "m_", ",", 
      RowBox[{"a_:", "a"}], ",", 
      RowBox[{"b_:", "b"}], ",", 
      RowBox[{"\[Zeta]_:", "\[Zeta]"}], ",", 
      RowBox[{"\[Omega]_:", "\[Omega]"}], ",", 
      RowBox[{"c_:", "c"}]}], "]"}], ":=", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"s", "+", "c"}], ")"}], "z"], "/", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"s", "+", "a"}], ")"}], "n"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"s", "+", "b"}], ")"}], "n"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[Omega]", 
             RowBox[{"-", "2"}]], 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["s", "2"], "+", 
              RowBox[{"2", "\[Zeta]", " ", "\[Omega]", " ", "s"}], "+", 
              SuperscriptBox["\[Omega]", "2"]}], ")"}]}], ")"}], "m"]}], 
        ")"}]}], ",", "s"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TFn", "[", "model_", "]"}], ":=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"model", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TFconnectn", "[", 
    RowBox[{"tf1_", ",", "tf2_"}], "]"}], ":=", 
   RowBox[{"SystemsModelSeriesConnect", "[", 
    RowBox[{"tf1", ",", "tf2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TFloopn", "[", "tf_", "]"}], ":=", 
    RowBox[{"TFn", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"tf", "[", "s", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"tf", "[", "s", "]"}]}], ")"}]}], ")"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PlotTF", "[", 
    RowBox[{"tf_", ",", "freq_", ",", "tmax_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "input", ",", "yout", ",", "t", ",", "i", ",", "p1", ",", "p2", ",", 
       "p3"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"input", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"DiracDelta", "[", "t", "]"}], ",", 
         RowBox[{"UnitStep", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"freq", "*", "t"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"yout", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"OutputResponse", "[", 
          RowBox[{"tf", ",", 
           RowBox[{"input", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p1", "=", 
       RowBox[{"Plot", "[", 
        RowBox[{"yout", ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";", 
      RowBox[{"p2", "=", 
       RowBox[{"BodePlot", "[", 
        RowBox[{"tf", ",", 
         RowBox[{"PlotLayout", "\[Rule]", "\"\<Magnitude\>\""}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"p3", "=", 
       RowBox[{"BodePlot", "[", 
        RowBox[{"tf", ",", 
         RowBox[{"PlotLayout", "\[Rule]", "\"\<Phase\>\""}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"GraphicsColumn", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], ",", 
        RowBox[{"Spacings", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "50"}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PlotTFsin", "[", 
    RowBox[{"tf_", ",", "freq_", ",", "tmax_", ",", 
     RowBox[{"opts_:", "Null"}]}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "input", ",", "yout", ",", "t", ",", "i", ",", "tfa", ",", "popt"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"tfa", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ArrayQ", "[", "tf", "]"}], ",", "tf", ",", 
         RowBox[{"{", "tf", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"input", "=", 
       RowBox[{"Sin", "[", 
        RowBox[{"freq", "*", "t"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"popt", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"opts", "===", "Null"}], ",", 
         RowBox[{"PlotStyle", "->", "Automatic"}], ",", "opts"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"yout", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"OutputResponse", "[", 
          RowBox[{
           RowBox[{"tfa", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", "input", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", "\[Pi]", "*", 
              RowBox[{"tmax", "/", "freq"}]}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "tfa", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"yout", ",", "input"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "\[Pi]", "*", 
           RowBox[{"tmax", "/", "freq"}]}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"Evaluate", "@", "popt"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PlotTFstep", "[", 
    RowBox[{"tf_", ",", "tmax_", ",", 
     RowBox[{"opts_:", "Null"}]}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "input", ",", "yout", ",", "t", ",", "i", ",", "tfa", ",", "popt"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"tfa", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ArrayQ", "[", "tf", "]"}], ",", "tf", ",", 
         RowBox[{"{", "tf", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"popt", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"opts", "===", "Null"}], ",", 
         RowBox[{"PlotStyle", "->", "Automatic"}], ",", "opts"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"input", "=", 
       RowBox[{"UnitStep", "[", "t", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"yout", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"OutputResponse", "[", 
          RowBox[{
           RowBox[{"tfa", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", "input", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "tfa", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{"yout", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"Evaluate", "@", "popt"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"H2", "[", "tf_", "]"}], ":=", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"tf", "[", 
          RowBox[{"I", " ", "w"}], "]"}], "]"}], "^", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"w", ",", 
         RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}]}],
     ")"}], 
   RowBox[{"1", "/", "2"}]]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hinf", "[", "tf_", "]"}], ":=", 
  RowBox[{"Quiet", "[", 
   RowBox[{"FindMaximum", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"tf", "[", 
          RowBox[{"I", " ", "w"}], "]"}], "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"w", "\[GreaterEqual]", "0"}]}], "}"}], ",", "w"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BodeDB", "[", "x_", "]"}], ":=", 
    RowBox[{"20", 
     RowBox[{"Log", "[", 
      RowBox[{"10", ",", "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "returns", " ", "a", " ", "polynomial", " ", "that", " ", "is", " ", "a", 
     " ", "function"}], ",", " ", 
    RowBox[{
     RowBox[{"thus", " ", "aa"}], "=", 
     RowBox[{"den", "[", "tf", "]"}]}], ",", " ", 
    RowBox[{"then", " ", 
     RowBox[{"a", "[", "s", "]"}], " ", "is", " ", "the", " ", "denominator", 
     " ", "as", " ", "polynomial", " ", "of", " ", "s"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"den", "[", "tf_", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Denominator", "[", 
      RowBox[{"tf", "[", "#", "]"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], ")"}], 
   "&"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"num", "[", "tf_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Numerator", "[", 
       RowBox[{"tf", "[", "#", "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], ")"}], "&"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "create", " ", "a", " ", "polynomial", " ", "variables", " ", "of", " ", 
     "vars_List", "_"}], ",", " ", 
    RowBox[{
     RowBox[{"w", "/", "coefficients"}], " ", "a_", " ", "and", " ", "order_",
      " ", "of", " ", "polynomial"}], ",", " ", 
    RowBox[{"ie", " ", "for", " ", "one", " ", "variable"}], ",", " ", 
    RowBox[{
     RowBox[{"poly", "[", 
      RowBox[{
       RowBox[{"{", "s", "}"}], ",", "q", ",", "3"}], "]"}], " ", "=", " ", 
     RowBox[{
      SubscriptBox["q", 
       TemplateBox[{"0"},
        "RowDefault"]], "+", 
      RowBox[{"s", " ", 
       SubscriptBox["q", 
        TemplateBox[{"1"},
         "RowDefault"]]}], "+", 
      RowBox[{
       SuperscriptBox["s", "2"], " ", 
       SubscriptBox["q", 
        TemplateBox[{"2"},
         "RowDefault"]]}], "+", 
      RowBox[{
       SuperscriptBox["s", "3"], " ", 
       SubscriptBox["q", 
        TemplateBox[{"3"},
         "RowDefault"]]}]}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"poly", "[", 
    RowBox[{"vars_List", ",", "a_", ",", "order_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "=", 
        RowBox[{"Length", "@", "vars"}]}], ",", "idx", ",", "z"}], "}"}], ",", 
     RowBox[{
      RowBox[{"idx", "=", 
       RowBox[{"Cases", "[", 
        RowBox[{
         RowBox[{"Tuples", "[", 
          RowBox[{
           RowBox[{"Range", "[", 
            RowBox[{"0", ",", "order"}], "]"}], ",", "n"}], "]"}], ",", 
         RowBox[{"x_", "/;", 
          RowBox[{
           RowBox[{"Plus", "@@", "x"}], "\[LessEqual]", "order"}]}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"z", "=", 
       RowBox[{"Times", "@@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"vars", "^", "#"}], "&"}], "/@", "idx"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"z", ".", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Subscript", "[", 
            RowBox[{"a", ",", 
             RowBox[{"Row", "[", "#", "]"}]}], "]"}], ")"}], "&"}], "/@", 
         "idx"}], ")"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "OutputResponse", " ", "can", " ", "be", " ", "numerically", " ", 
     "unstable"}], ",", " ", 
    RowBox[{
    "so", " ", "sometimes", " ", "will", " ", "need", " ", "to", " ", "get", 
     " ", "the", " ", "StateResponse", " ", "and", " ", "then", " ", 
     "recreate", " ", "the", " ", "output", " ", "from", " ", "the", " ", 
     "state", " ", "model"}], ",", " ", 
    RowBox[{
    "as", " ", "with", " ", "the", " ", "following", " ", "function"}]}], " ",
    "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"StateOutputResponse", "[", 
     RowBox[{"tf_", ",", "input_", ",", "tmax_"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ssm", ",", "ssr", ",", "c", ",", "y"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ssm", "=", 
        RowBox[{"StateSpaceModel", "[", "tf", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"ssr", "=", 
        RowBox[{"StateResponse", "[", 
         RowBox[{"ssm", ",", "input", ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "100"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"c", "=", 
        RowBox[{
         RowBox[{"Normal", "[", "ssm", "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"y", "=", 
        RowBox[{"c", ".", "ssr"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "y", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "set", " ", "default", " ", "directory", " ", "for", " ", "graphics", " ", 
    "output"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gdir", "=", "\"\<~/Desktop/\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "gdirlocal", "=", "\"\<~/text/Submit/Signals/Tracking/Figures/\>\""}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.70920050487645*^9, 3.709200512614806*^9}, {
   3.709200584822381*^9, 3.709200707048627*^9}, {3.709200846422319*^9, 
   3.709200846985845*^9}, {3.709203241961137*^9, 3.709203247668934*^9}, {
   3.709203400393238*^9, 3.709203405936409*^9}, {3.709204633858753*^9, 
   3.709204635983563*^9}, {3.709204675420343*^9, 3.709204677727824*^9}, {
   3.7092047972141953`*^9, 3.70920480764394*^9}, {3.709205406961643*^9, 
   3.709205474808927*^9}, {3.709205517535041*^9, 3.709205520780553*^9}, {
   3.7092094999285*^9, 3.709209539777025*^9}, {3.709209595686901*^9, 
   3.7092096647650757`*^9}, {3.709209771291346*^9, 3.709209776823759*^9}, {
   3.7092107239370623`*^9, 3.70921095880688*^9}, {3.7092111708782063`*^9, 
   3.70921120934595*^9}, {3.7092112815719633`*^9, 3.7092112898710318`*^9}, {
   3.709211666459118*^9, 3.7092117561180058`*^9}, {3.7092118104185143`*^9, 
   3.7092118306237497`*^9}, {3.709211887280673*^9, 3.709211904820394*^9}, {
   3.709211937003148*^9, 3.709211963554554*^9}, {3.70921207408419*^9, 
   3.709212109809703*^9}, 3.709212174217741*^9, {3.709212327744639*^9, 
   3.7092123442737007`*^9}, {3.709212749723672*^9, 3.709212751660359*^9}, {
   3.7092133577630653`*^9, 3.709213357964364*^9}, {3.709227401052218*^9, 
   3.709227401602289*^9}, {3.709227545234581*^9, 3.7092275823535757`*^9}, {
   3.709227631949562*^9, 3.709227657024127*^9}, {3.709227691800951*^9, 
   3.709227732918726*^9}, {3.7092855309319887`*^9, 3.709285543153408*^9}, {
   3.709311740583253*^9, 3.709311821781073*^9}, {3.709312640475788*^9, 
   3.709312773314196*^9}, {3.709378951987034*^9, 3.709378990721219*^9}, {
   3.7093790306460733`*^9, 3.709379037221098*^9}, {3.709383826623777*^9, 
   3.7093838709756117`*^9}, {3.710679565387527*^9, 3.7106796593667917`*^9}, {
   3.710679721718006*^9, 3.71067977427144*^9}, {3.7106800488723297`*^9, 
   3.710680083514872*^9}, {3.710680122436661*^9, 3.7106801391975117`*^9}, {
   3.7106803680006104`*^9, 3.710680369673525*^9}, {3.7106804030539303`*^9, 
   3.710680427938404*^9}, {3.710680461576578*^9, 3.7106804930961313`*^9}, {
   3.7106814725539513`*^9, 3.71068154266998*^9}, {3.710681584297044*^9, 
   3.7106815882862186`*^9}, {3.710762146742568*^9, 3.710762239923633*^9}, {
   3.7107622877262363`*^9, 3.7107622950191593`*^9}, {3.710843281427896*^9, 
   3.7108433090222692`*^9}, {3.7108453858757763`*^9, 3.710845402208673*^9}, {
   3.710853201270802*^9, 3.710853233320982*^9}, 3.710853440046205*^9, {
   3.711112764089658*^9, 3.7111127945194197`*^9}, {3.711112866655895*^9, 
   3.711112936293618*^9}, {3.71111306307448*^9, 3.711113145189745*^9}, {
   3.711113188855489*^9, 3.7111132375612717`*^9}, {3.7111140841951227`*^9, 
   3.711114091987851*^9}, {3.711114286690584*^9, 3.71111431198904*^9}, {
   3.7111143623076687`*^9, 3.711114371652667*^9}, {3.711114421682542*^9, 
   3.711114423482828*^9}, {3.711114535607441*^9, 3.711114539481402*^9}, {
   3.711114759571383*^9, 3.7111147846958113`*^9}, {3.711123639098991*^9, 
   3.711123650840351*^9}, {3.711123687199785*^9, 3.7111236932696247`*^9}, {
   3.711123755610487*^9, 3.711123758816832*^9}, {3.711124500301021*^9, 
   3.711124508174285*^9}, {3.711460302187846*^9, 3.711460432808303*^9}, {
   3.7114605003131313`*^9, 3.711460575715201*^9}, {3.711460782965375*^9, 
   3.711460814939554*^9}, {3.7118053719723377`*^9, 3.711805393736998*^9}, {
   3.711805457233225*^9, 3.711805463098916*^9}, {3.7118055317536383`*^9, 
   3.711805552203384*^9}, {3.7129163060284243`*^9, 3.712916327612761*^9}, {
   3.7129165883483667`*^9, 3.71291660377472*^9}, {3.712916802853314*^9, 
   3.712916866339944*^9}, {3.713186478844677*^9, 3.713186505554504*^9}, {
   3.713187090627838*^9, 3.713187112151312*^9}, {3.7137874414234753`*^9, 
   3.7137874430875063`*^9}},ExpressionUUID->"07a9a291-7e2c-4212-8767-\
699c78820f1c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Frequency, gain and phase", "Section",
 CellChangeTimes->{{3.7111089997637978`*^9, 
  3.711109003461767*^9}},ExpressionUUID->"916a9aa2-d776-4c7b-b54a-\
da2c583240d0"],

Cell[CellGroupData[{

Cell["Dynamics and Bode plot", "Subsection",
 CellChangeTimes->{{3.711282902819522*^9, 
  3.711282926765974*^9}},ExpressionUUID->"dd3ccc32-81fb-43b7-9d88-\
af080cb8cf91"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"llabelx", "=", "0.083"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rlabelx", "=", "0.633"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"flabelx", "=", "0.233"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tf", "=", 
   RowBox[{"TF", "[", 
    RowBox[{"a", "/", 
     RowBox[{"(", 
      RowBox[{"s", "+", "a"}], ")"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"Null", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gr", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"PlotTFsin", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tf", "/.", 
        RowBox[{"a", "\[Rule]", "1"}]}], ",", 
       RowBox[{"tf", "/.", 
        RowBox[{"a", "\[Rule]", "10"}]}]}], "}"}], ",", "1", ",", "4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameLabel", "\[Rule]", "\"\<\>\""}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", "25", ",", "5"}], "]"}], ",", "Automatic"}], 
         "}"}]}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gr", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"PlotTFsin", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tf", "/.", 
        RowBox[{"a", "\[Rule]", "1"}]}], ",", 
       RowBox[{"tf", "/.", 
        RowBox[{"a", "\[Rule]", "10"}]}]}], "}"}], ",", "10", ",", "4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameLabel", "\[Rule]", "\"\<\>\""}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", "2.5", ",", ".5"}], "]"}], ",", "Automatic"}], 
         "}"}]}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gr", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"PlotTFsin", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tf", "/.", 
        RowBox[{"a", "\[Rule]", "1"}]}], ",", 
       RowBox[{"tf", "/.", 
        RowBox[{"a", "\[Rule]", "10"}]}]}], "}"}], ",", "100", ",", "4", ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Time\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", ".25", ",", ".05"}], "]"}], ",", "Automatic"}], 
         "}"}]}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gr", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"PlotTFstep", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tf", "/.", 
        RowBox[{"a", "\[Rule]", "1"}]}], ",", 
       RowBox[{"tf", "/.", 
        RowBox[{"a", "\[Rule]", "10"}]}]}], "}"}], ",", "5", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Time\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Response\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}], "}"}]}]}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gr", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"BodePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TF", "[", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "+", "1"}], ")"}]}], "]"}], ",", 
       RowBox[{"TF", "[", 
        RowBox[{"10", "/", 
         RowBox[{"(", 
          RowBox[{"s", "+", "10"}], ")"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotLayout", "\[Rule]", "\"\<Magnitude\>\""}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Gain\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}], "}"}]}]}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gr", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"BodePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TF", "[", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "+", "1"}], ")"}]}], "]"}], ",", 
       RowBox[{"TF", "[", 
        RowBox[{"10", "/", 
         RowBox[{"(", 
          RowBox[{"s", "+", "10"}], ")"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotLayout", "\[Rule]", "\"\<Phase\>\""}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Frequency\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Phase\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}], "}"}]}]}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"gout", "=", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"gr", ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"50", ",", "20"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Text", "[", "\"\<(a)\>\"", "]"}], ",", 
         RowBox[{"ImageScaled", "[", 
          RowBox[{"{", 
           RowBox[{"llabelx", ",", "0.77"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Text", "[", "\"\<(b)\>\"", "]"}], ",", 
         RowBox[{"ImageScaled", "[", 
          RowBox[{"{", 
           RowBox[{"llabelx", ",", "0.427"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Text", "[", "\"\<(c)\>\"", "]"}], ",", 
         RowBox[{"ImageScaled", "[", 
          RowBox[{"{", 
           RowBox[{"llabelx", ",", "0.087"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Text", "[", "\"\<(d)\>\"", "]"}], ",", 
         RowBox[{"ImageScaled", "[", 
          RowBox[{"{", 
           RowBox[{"rlabelx", ",", "0.77"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Text", "[", "\"\<(e)\>\"", "]"}], ",", 
         RowBox[{"ImageScaled", "[", 
          RowBox[{"{", 
           RowBox[{"rlabelx", ",", "0.427"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Text", "[", "\"\<(f)\>\"", "]"}], ",", 
         RowBox[{"ImageScaled", "[", 
          RowBox[{"{", 
           RowBox[{"rlabelx", ",", "0.087"}], "}"}], "]"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Text", "[", "\"\<\[Omega] = 1\>\"", "]"}], ",", 
         RowBox[{"ImageScaled", "[", 
          RowBox[{"{", 
           RowBox[{"flabelx", ",", "0.99"}], "}"}], "]"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Text", "[", "\"\<\[Omega] = 10\>\"", "]"}], ",", 
         RowBox[{"ImageScaled", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"flabelx", "-", "0.002"}], ",", "0.65"}], "}"}], "]"}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Text", "[", "\"\<\[Omega] = 100\>\"", "]"}], ",", 
         RowBox[{"ImageScaled", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"flabelx", "-", "0.004"}], ",", "0.31"}], "}"}], "]"}]}], 
        "]"}]}], "\[IndentingNewLine]", "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"gdir", "<>", "\"\<lowpass.eps\>\""}], ",", "gout"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7111125527818003`*^9, 3.711112642649434*^9}, {
   3.711112952999398*^9, 3.7111129848166037`*^9}, {3.711113154390779*^9, 
   3.711113156332654*^9}, {3.7111132254600363`*^9, 3.711113227577298*^9}, {
   3.711113349247719*^9, 3.71111335723811*^9}, {3.711113532400695*^9, 
   3.711113545999116*^9}, {3.7111135788826027`*^9, 3.7111135879566402`*^9}, {
   3.71111410441507*^9, 3.711114128910228*^9}, 3.711114206682618*^9, {
   3.71111437839981*^9, 3.71111438905262*^9}, 3.711114439200588*^9, {
   3.711114472924869*^9, 3.711114479841358*^9}, {3.7111147918177433`*^9, 
   3.711114801784326*^9}, {3.711114836374688*^9, 3.7111148415105658`*^9}, {
   3.711115214176423*^9, 3.7111154607289143`*^9}, {3.711122929115018*^9, 
   3.711122936867259*^9}, {3.711123112753585*^9, 3.7111231697541*^9}, {
   3.711123711034272*^9, 3.711123718745533*^9}, {3.7111237756257057`*^9, 
   3.711123870389389*^9}, {3.711123917226019*^9, 3.711123953559169*^9}, {
   3.711124021470709*^9, 3.711124038245116*^9}, {3.711124280873218*^9, 
   3.711124287975403*^9}, {3.711124341310953*^9, 3.711124357082247*^9}, {
   3.711124406321108*^9, 3.711124431575252*^9}, {3.711124477299823*^9, 
   3.711124484561962*^9}, {3.7111245930438232`*^9, 3.711124593410406*^9}, {
   3.711124652914263*^9, 3.711124709291497*^9}, {3.7111247448500767`*^9, 
   3.7111248044274406`*^9}, {3.71112490065213*^9, 3.711124966263761*^9}, {
   3.7111250076914673`*^9, 3.711125104145838*^9}, {3.7111251677644987`*^9, 
   3.711125342807699*^9}, {3.711125424465583*^9, 3.711125450048727*^9}, {
   3.711125678437125*^9, 3.711125912545108*^9}, {3.711126029445015*^9, 
   3.7111261519424*^9}, {3.711126429585503*^9, 3.7111264951417227`*^9}, {
   3.711126531790886*^9, 3.71112653940401*^9}, 3.711126661308551*^9, {
   3.711126844212352*^9, 3.711126852906844*^9}, {3.7111270016309643`*^9, 
   3.711127004806164*^9}, {3.711128690781187*^9, 3.711128907698882*^9}, {
   3.7111289792486677`*^9, 3.711128982092881*^9}, {3.711129017938822*^9, 
   3.71112902366859*^9}, {3.7111290959902897`*^9, 3.7111291026069593`*^9}, {
   3.711135506011133*^9, 3.711135519595042*^9}, {3.711135701934166*^9, 
   3.711135716722077*^9}, {3.711135780733314*^9, 3.7111357813557463`*^9}, {
   3.7111927492087383`*^9, 3.711192759502565*^9}, {3.7111927957399673`*^9, 
   3.7111929291491127`*^9}, {3.711193004115903*^9, 3.7111930213717813`*^9}, {
   3.711193133035912*^9, 3.71119317796704*^9}, {3.711193236838625*^9, 
   3.711193262980117*^9}, {3.7111933047118*^9, 3.711193311389126*^9}, {
   3.711193352032881*^9, 3.711193356188285*^9}, {3.7111934486784267`*^9, 
   3.711193452989243*^9}, {3.7111935746050787`*^9, 3.711193581318316*^9}, {
   3.713186541542963*^9, 3.713186548828933*^9}, {3.7131866926923857`*^9, 
   3.7131866945064077`*^9}},ExpressionUUID->"c799ec5c-693d-4b28-b4e5-\
01332c0143fc"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwUmnc8le8bx62MUlZGZR3r2OM4BxXuK4lKiQhlRVIho0JFNJFKJCpZKSUt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            "]]},
          Annotation[#, "Charting`Private`Tag$3783157#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwUmHk8VV8Xxk0hU5lKmadLXMPlclXYK01CGpV+UUgUJWQoRLOpkCkVGUIi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            "]]},
          Annotation[#, "Charting`Private`Tag$3783157#1"]& ], 
         TagBox[
          {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwkm3k81N/3xyUVorIm+y6MZRhGJfcklfApZUuW0KK0oVBIEkIbiiJbsqXI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            "]]},
          Annotation[#, "Charting`Private`Tag$3783157#2"]& ]}, {}, {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       DisplayFunction->Identity,
       Frame->{{True, False}, {True, False}},
       FrameLabel->{{None, None}, {
          FormBox["\"\"", TraditionalForm], None}},
       FrameTicks->FrontEndValueCache[{{Automatic, 
           Charting`ScaledFrameTicks[{Identity, Identity}]}, {{{0, 
             FormBox["0", TraditionalForm]}, {5, 
             FormBox["5", TraditionalForm]}, {10, 
             FormBox["10", TraditionalForm]}, {15, 
             FormBox["15", TraditionalForm]}, {20, 
             FormBox["20", TraditionalForm]}, {25, 
             FormBox["25", TraditionalForm]}}, {{0, 
             FormBox["0", TraditionalForm]}, {5, 
             FormBox["5", TraditionalForm]}, {10, 
             FormBox["10", TraditionalForm]}, {15, 
             FormBox["15", TraditionalForm]}, {20, 
             FormBox["20", TraditionalForm]}, {25, 
             FormBox["25", TraditionalForm]}}}}, {{Automatic, {{-1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.9, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.7, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.7, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.9, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}}}, {{{0., 
             FormBox["0", TraditionalForm]}, {5., 
             FormBox["5", TraditionalForm]}, {10., 
             FormBox["10", TraditionalForm]}, {15., 
             FormBox["15", TraditionalForm]}, {20., 
             FormBox["20", TraditionalForm]}, {25., 
             FormBox["25", TraditionalForm]}}, {{0., 
             FormBox["0", TraditionalForm]}, {5., 
             FormBox["5", TraditionalForm]}, {10., 
             FormBox["10", TraditionalForm]}, {15., 
             FormBox["15", TraditionalForm]}, {20., 
             FormBox["20", TraditionalForm]}, {25., 
             FormBox["25", TraditionalForm]}}}}],
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       Method->{
        "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
         AbsolutePointSize[6], "ScalingFunctions" -> None, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{All, All},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {205, -121.24611797498106}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwVzX8803kcB/BpqGOc+dKjn7ac7BoZd4+uU/T++FEUdVdI5irmZ6VI1sUU
5wgnWnfKkNtDaXJCPybn6paWH/m1C9cPUe3M6oztq9ZiyO57f7wer8fzn9dr
FSdxV8wCEom0ncj/XXGKY+oWzdtEGq2+6kp06wA9MJQeBge7W27uXx4GhnbJ
j3T6AegZKg/zXnwAKloKaSb0VPiiJDg0mJIKCZ7cw1O0fNgzP1lwbToPBmbj
iydppRB0Xxte2yeAhUMjDDWtBnqlP3nVZF+Fyi7h0XFaM0wtXKLcp2mC+ob8
oQSXLvg40+kRV9cBcdBXOpE8AAXkLaozbY/giHKNQlw/CE2DnqIKxmMwW5XN
ePW1HMYvGfCwY4NQZNXNrIxQgP/vTSUG6gvgDAXfI/e8Br/j45tpO+RwtC2b
k8hQwZXZ5zy/l//AjSRK0JKtaqCIkp7nsRRQyTukcg2dBNY7Jw9Z6ihkCed2
vp94C0D2OWHBVwJpQI7upmmBfTV10e7c1+CYEnsimKmDkyzr8v7UNzCqK9lt
/ucHaE6P/nXNln9hm/LgyZ+PTkNF4+qmZZZjsGOU72RnNwOOEasVTZIxUD3g
ZD6sm4VGnn7Z+SAVuFCfrPTZ/xEK5VFtiUoVmIEuclg7D7m2T0jBEePgp2ZP
2YeQkGR/i1/as3F4Jo02YjsboVexSUbnvCegMa91H11nhF5UNzjoyycg1oQr
l8kWoBr5l6cztRMQlcxrpJSRkc09QYynpxpYcU6ywEhj9FgwdE16Sg1/WTub
c91N0MirHmxeooY79VnlzmRTNCYSrl+pUwPPiPltzwtTZCNyuGjJ1IDZcJr/
EfFC1Bm9NPXRHg0oRauKhemLkCR+BdM9UwPFny81bg75BAXc7fnQL9IAvyy2
I5Juhlwe0b7a06EBdvFeGeWNGbp+u9EYjWpg2veKXigxR7v4578rJeGgUHqf
kOZSkITdlHFyCQ6XPN2W90ZaoFumoYaXLBzqcrjUuLWWKKNo72fnfHDIDYkK
IOssEVu1es4qBId1w5U1ub2fomPFSebrY3EQrCmv6w2wQg37jB1/S8Eho6VQ
ENBshVZMlPl3Z+GwfXnIlS4HKhLU+BZuPouD15GOcGo+FXkxcrI7S3EQruA4
9OioqMqk6IxtFQ4OD6ov7Ai3RsFPj7tIr+HAXytl9kusUS1rRPy9GIdYrXFf
JxNDbZNOFaZ3ceDceEfPP4shbcM3bjFSHBKygua2ncPQItHTjZmEuUHip5Rf
MGRflL6hnHCejlvEv4Ah+aCbTR/henf9bEkFsad87u7xAAf9fcMTUS2Gwo1q
d1m1Ev/9lMLWDgxZDEa/bGjDoezy4fjTnRjqWldwvJPw5RSZj383hrZeP0ZW
EL69mD/TLcOQaZVw1rYdh2E2Fj/wmNinvI/hEWYolvqMKDCUaosxfDtwcBWn
2VUpMRR1s91iL+ENOUP6mDcYwhecHeMSDmRUXB9TYYgTnZxZTTj5EN3u7VsM
TdXbOJs9xCHd4wf9TS2GXBPn79gTzrEY+TtFh6HptY5eGwkLGi4XTE9j6Fag
r1MC4UuZxnF/zGAowuDLzyZcuzPGO30OQ7a7BaqLhMX27Ss3zWOIleazoZGw
ROuoNxgwZHk+IKOX8H9xbFx6
            "]]},
          Annotation[#, "Charting`Private`Tag$3784388#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwt1nk8VF8bAPCxlsgaqWRpQRKplFI9Y0tKipAkWbKlpIVCi6SkiEqSNaKQ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            "]]},
          Annotation[#, "Charting`Private`Tag$3784388#2"]& ]}, {}, {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       DisplayFunction->Identity,
       Frame->{{True, False}, {True, False}},
       FrameLabel->{{
          FormBox[
           StyleBox["\"Response\"", FontSize -> 12, StripOnInput -> False], 
           TraditionalForm], None}, {
          FormBox[
           StyleBox["\"Time\"", FontSize -> 12, StripOnInput -> False], 
           TraditionalForm], None}},
       FrameTicks->FrontEndValueCache[{{Automatic, 
           Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
           Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
          Automatic, {{0., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.15, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.05, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.05, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.15, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.25, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.35, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.45, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.55, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.65, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.7, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.75, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.85, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.9, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.95, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.05, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.15, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {2.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {2.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {2.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {2.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {3.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {3.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {3.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {3.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {4.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {4.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {4.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {4.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {5.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {5.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {5.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {5.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}}}}],
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       Method->{
        "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
         AbsolutePointSize[6], "ScalingFunctions" -> None, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{All, All},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {615, -121.24611797498106}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}]}, {InsetBox[
      GraphicsBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwUV3c4le8bd5AilWyRNJSkQpGQ+/0qyiiSrJRRGiQadskeZWSv7BnCscdx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            "]]},
          Annotation[#, "Charting`Private`Tag$3783578#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwUmHc81f8Xxy9XSCVSIZJESepLaVHOJ6SyQhLSooiMysgo2SS7CCFJKWlJ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            "]]},
          Annotation[#, "Charting`Private`Tag$3783578#1"]& ], 
         TagBox[
          {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwUmnc4Vu8fxx8PKZooklI0SBQqVPI5ScvKiowUkm8iJSlllBCVjKbISghZ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            "]]},
          Annotation[#, "Charting`Private`Tag$3783578#2"]& ]}, {}, {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       DisplayFunction->Identity,
       Frame->{{True, False}, {True, False}},
       FrameLabel->{{None, None}, {
          FormBox["\"\"", TraditionalForm], None}},
       FrameTicks->FrontEndValueCache[{{Automatic, 
           Charting`ScaledFrameTicks[{Identity, Identity}]}, {{{0., 
             FormBox["0.`", TraditionalForm]}, {0.5, 
             FormBox["0.5`", TraditionalForm]}, {1., 
             FormBox["1.`", TraditionalForm]}, {1.5, 
             FormBox["1.5`", TraditionalForm]}, {2., 
             FormBox["2.`", TraditionalForm]}, {2.5, 
             FormBox["2.5`", TraditionalForm]}}, {{0., 
             FormBox["0.`", TraditionalForm]}, {0.5, 
             FormBox["0.5`", TraditionalForm]}, {1., 
             FormBox["1.`", TraditionalForm]}, {1.5, 
             FormBox["1.5`", TraditionalForm]}, {2., 
             FormBox["2.`", TraditionalForm]}, {2.5, 
             FormBox["2.5`", TraditionalForm]}}}}, {{Automatic, {{-1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.9, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.7, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.7, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.9, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}}}, {{{0., 
             FormBox["0.`", TraditionalForm]}, {0.5, 
             FormBox["0.5`", TraditionalForm]}, {1., 
             FormBox["1.`", TraditionalForm]}, {1.5, 
             FormBox["1.5`", TraditionalForm]}, {2., 
             FormBox["2.`", TraditionalForm]}, {2.5, 
             FormBox["2.5`", TraditionalForm]}}, {{0., 
             FormBox["0.`", TraditionalForm]}, {0.5, 
             FormBox["0.5`", TraditionalForm]}, {1., 
             FormBox["1.`", TraditionalForm]}, {1.5, 
             FormBox["1.5`", TraditionalForm]}, {2., 
             FormBox["2.`", TraditionalForm]}, {2.5, 
             FormBox["2.5`", TraditionalForm]}}}}],
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       Method->{
        "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
         AbsolutePointSize[6], "ScalingFunctions" -> None, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{All, All},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {205, -363.73835392494317}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwVlnk41IvDxRkqiSwtpOXaQtYUspSZLJNSSYpS5JKKRKSbulRXQiqhX2Tf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            "]]},
          Annotation[#, "Charting`Private`Tag$3786257#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwVlmc8Ff4fxd2brBJaCCF7FMq6yPfKSggZUfYKlSQKIYRQdmZIkhDKHuFz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            "]]},
          Annotation[#, "Charting`Private`Tag$3786257#2"]& ]}, {}, {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{-1.3010299956639813`, -46.020707015351135`},
       CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
           Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
           Part[#, 2]}& )},
       DisplayFunction->Identity,
       Frame->{{True, False}, {True, False}},
       FrameLabel->{{
          FormBox[
           StyleBox["\"Gain\"", FontSize -> 12, StripOnInput -> False], 
           TraditionalForm], None}, {
          FormBox[
           StyleBox["\"\"", FontSize -> 12, StripOnInput -> False], 
           TraditionalForm], None}},
       FrameTicks->{{{{-50., 
            FormBox[
             RowBox[{"-", "50"}], TraditionalForm]}, {-40., 
            FormBox[
             RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
            FormBox[
             RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
            FormBox[
             RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
            FormBox[
             RowBox[{"-", "10"}], TraditionalForm]}, {0., 
            FormBox["0", TraditionalForm]}, {-50., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-48., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-46., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-44., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-42., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-38., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-36., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-34., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-32., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-28., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-26., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-24., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-22., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-18., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-16., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-14., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-12., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-8., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-6., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-4., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-2., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}}, {{-50., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-40., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-30., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-20., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-10., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-50., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-48., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-46., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-44., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-42., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-38., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-36., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-34., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-32., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-28., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-26., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-24., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-22., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-18., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-16., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-14., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-12., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-8., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-6., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-4., 
            FormBox[
             InterpretationBox[
              StyleBox[
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}}}, {{{-1., 
            FormBox["0.1`", TraditionalForm]}, {0., 
            FormBox["1", TraditionalForm]}, {1., 
            FormBox["10", TraditionalForm]}, {2., 
            FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}}, {{-1., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], 
             TraditionalForm]}, {-0.6989700043360187, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}}}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       Method->{"ScalingFunctions" -> None},
       PlotRange->{{-1.3010299956639813`, 
        2.3010299956639813`}, {-46.020707015351135`, 0.}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.02]}},
       Ticks->{{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
           FormBox[
            RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
           FormBox[
            RowBox[{"-", "10"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-48., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-46., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-44., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-42., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-38., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-36., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-34., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-32., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-28., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-26., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-24., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-22., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-18., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-16., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-14., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-12., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-8., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-6., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}], {615, -363.73835392494317}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}]}, {InsetBox[
      GraphicsBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwUV3k4lG8bRVIhJRIpWQopKsmWHLRJZM1a9oQUCT9UKrKVbWZs2dfITpax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            "]]},
          Annotation[#, "Charting`Private`Tag$3783985#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwUV3c81e8Xl2+UkjLTUlJCUklJ6y1RkpWQrESEZIWQJA0rZGTvvd2Le63L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            "]]},
          Annotation[#, "Charting`Private`Tag$3783985#1"]& ], 
         TagBox[
          {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwUm3k8VO8XxyVEKZFoUZKtIlsLSR0paZGQfV9aJKUoXwqVJUuyJbJk3/dl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            "]]},
          Annotation[#, "Charting`Private`Tag$3783985#2"]& ]}, {}, {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       DisplayFunction->Identity,
       Frame->{{True, False}, {True, False}},
       FrameLabel->{{None, None}, {
          FormBox[
           StyleBox["\"Time\"", FontSize -> 12, StripOnInput -> False], 
           TraditionalForm], None}},
       FrameTicks->FrontEndValueCache[{{Automatic, 
           Charting`ScaledFrameTicks[{Identity, Identity}]}, {{{0., 
             FormBox["0.`", TraditionalForm]}, {0.05, 
             FormBox["0.05`", TraditionalForm]}, {0.1, 
             FormBox["0.1`", TraditionalForm]}, {0.15000000000000002`, 
             FormBox["0.15000000000000002`", TraditionalForm]}, {0.2, 
             FormBox["0.2`", TraditionalForm]}, {0.25, 
             FormBox["0.25`", TraditionalForm]}}, {{0., 
             FormBox["0.`", TraditionalForm]}, {0.05, 
             FormBox["0.05`", TraditionalForm]}, {0.1, 
             FormBox["0.1`", TraditionalForm]}, {0.15000000000000002`, 
             FormBox["0.15000000000000002`", TraditionalForm]}, {0.2, 
             FormBox["0.2`", TraditionalForm]}, {0.25, 
             FormBox["0.25`", TraditionalForm]}}}}, {{Automatic, {{-1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.01, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-1.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.9, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.7, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {-0.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.6, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.7, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.8, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {0.9, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.1, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.2, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.3, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.4, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}, {1.5, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[{0., 0.}], Selectable -> False], StandardForm], {0.005, 
             0.}, {
              AbsoluteThickness[0.1]}}}}, {{{0., 
             FormBox["0.`", TraditionalForm]}, {0.05, 
             FormBox["0.05`", TraditionalForm]}, {0.1, 
             FormBox["0.1`", TraditionalForm]}, {0.15000000000000002`, 
             FormBox["0.15000000000000002`", TraditionalForm]}, {0.2, 
             FormBox["0.2`", TraditionalForm]}, {0.25, 
             FormBox["0.25`", TraditionalForm]}}, {{0., 
             FormBox["0.`", TraditionalForm]}, {0.05, 
             FormBox["0.05`", TraditionalForm]}, {0.1, 
             FormBox["0.1`", TraditionalForm]}, {0.15000000000000002`, 
             FormBox["0.15000000000000002`", TraditionalForm]}, {0.2, 
             FormBox["0.2`", TraditionalForm]}, {0.25, 
             FormBox["0.25`", TraditionalForm]}}}}],
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       Method->{
        "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
         AbsolutePointSize[6], "ScalingFunctions" -> None, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{All, All},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {205, -606.2305898749053}, 
      ImageScaled[{0.5, 0.5}], {360, 222.4922359499621}], InsetBox[
      GraphicsBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwVzXs0lHkcBvCZN0s7uVcSU4zDEWVKIUb8foQKuc8baVwjI5TUrm5ShEpC
oY5ku6nQTUQW7ze2LGmtzRJdpFzCYjDIzLT23T+e85zPP8/DCdnnFUYwGAw/
Ov/3yw1RINcmpg64yWbMBuThWqiTb0KLmNqprDnOnpaHQxd1RbONYuqnoq5s
ZTkF0J9q1xmpE1N5QqMZZT0FSCqzOdFWKqYkPm3dyQEKgE1VbK+liam05LpC
5y4FeMYt+3UjFlNOguAFezsWQqnRt6eRD6co+ccHP8SJWPDpoHvuwUOT1BO5
k4J2FVVwWpZc6eoxQQUHnHMMG1WHrLB+Wd86EaXOElazeRpAquuT9pOj1N/Y
N3dDnBaMKlha7Cgdodic7qI3mjrAuft58In5EJWk/yBPNVkPOL8M9GY2D1DP
DN4O9IoNIMnpdiDrTB9V/LnKbr7cCJLyJA9eaXym8nmVx11judBsslTO+2oP
lVFq597SaAoG7wd5KnrvKLQ+Nbb+lhnU9Awu8XfqoKqyrvvvM7aEZVgw01Pb
RvF/PCy42WkNu0bmp7/eaaIGH3Uwy9gYqiqKdRcTQHmmKbqTMfYQP8AQ1rJK
qfCB5rzGMgdYC8e492Q5aCW7P8DSfAvgoCGT1qeVyCQn8b1T2jb4bQX1XKv6
BQqhxEaKMy7AW6P/qiWyFYnurmEarneDbNwaksJrRzrq413ayh7wemlPjQan
C+UsKPex+u4B9hmHVWLKPyCHf5tje+s9IavkUUSIZi8ai75uw4/2gtB+pW+O
qV9QkDA/vlPJG97sf7TgfEs/Csl0IV5leMNtzxqbdPuvqMdYkRsi7wOl3TFr
F90fRoX3gh+NC33AoyK8YHT0H1Sfeg5/r/KBHf2NVmmB48hkSXNyI5MPxzds
NGp4I0LzU+xZd2s+CH8XqBGTE+iv6Ls3AvfyQX7hM9WCVVOIt9DfODOPDwdE
Fn8IncWoO/jL65hqPlxIGrqRnTyN8OaS8wHdfDhK1ZmP3ptB6Rc8pKen+HDS
fc+t1KZZ5Bg1EXlkIQlWZx2ME5hz6NNls4TH2iRQ0Q4xRfoSJOs7JGk3JuEb
enzikpEEpfM3u6qtJmGd+sqsU1wJClcKittO+8bT2ScBlhLk1TFv94J2ynzx
nIarBLW/1OkrW0PC9iy106lxEmTt1s5P4ZLwrvxjfkS9BL13jq1WXk/CrDS+
yThIii5xeDdKLElI1OZ3M8OkiBsysekDbZa16chboRRNKXIrlK1IYB8ZUkyN
kyKvrXm2sbTtv/l5fEmRovVuDZVmPBLSxbzO/PtStOuhtm+FNQm6o7I+RakU
3cFekwW2JGz7mMgYz5Eh9a7hMDUHEiKFJdN9T78jWcZgrNJ2EjYVsoiNon/R
k5krZ7fwSRizdQoXsBjY2o2seu5Pgsvb/VbUFQbuLPZWMAwmgdloruluzsS7
sxV1tMJJWMlS7Pj5JRMHTvnuY0SSICgzYzCamPh0iW+sKu2rOwXGaa+YuOVo
2R5d2lolDxIu/8nEiQ65ppi2hqun4bNuem8Ty/oEbZWM3HjJGBOvkIyultJm
qHO0jy8jsJd+Td3wXhJQ9TbHH7QI3GMz7T9HOyHkwL7zbAK3E+ljClEkyMoa
Ggo4BNY8NjGlT3vOOzyqbjWBa6PjEgNoT+aU1M4jAhuypUWttE1t2wdT7Qlc
uOZmwQfa+wdkaqqOBNZbrnd2hPaYhVu4rjOB1RbXOyhEkzDcKVK28yHw3EZf
O1vaRonLrZpIAs9KkwddaEessg/19CNwkXFDkh/tgfiLlcEBtIszrx2kbcCp
6R0KIrBOEHfFKdq7m/oWHQil/7dKsi7QvhWrZCEJI/DqM1LZVdpfllsEnYog
cI6dVUAx7f8AlN66aQ==
            "]]},
          Annotation[#, "Charting`Private`Tag$3788799#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwVyXk81Hkcx/GZ3xIrGl2DTlOOLqq1pp2K39css9E8cv6KMiVikaQym3al
UlYKbYekpTY5GleymyPH51uSpmbJ0VQ65BjMTDOGRodUO/vH+/F6PB9vVvBu
n1CCRqMF6PZ/7zlEYb02LXB2Nty7QrXDpRCef4JEC8smb7Y8v70dhGctNe+b
tZBUtsHtzK52sHrbOV/ZoAWbgiz93KR2OFrhdKitRAvB0hb1/Mp2QCsZzpeO
a8H1lXAwy7wDauwralchLfhfWMMt7uuAksUfKiOvvwV5jmuB8OxjeB3reT5W
OAqH+QGHsuufAc/sWBXfawTMifjprM2v4HSobKJ/hQYaHhucdJP2wMZpVhu5
oyrostCmyJAMVAY/sDeVKEGk58S6aiCH6Iov1+JzlZBp7D4j3EIO6sCm2bkX
lKD6ornKWSoHzQ0fuuqYEqxNeusITzlot+ySJAqU8Mt8jza7TDmMX88NLpui
hNmlzgeGFyvAwN/klP4eBSRFTbq7PUAJrGu9g387yqFU6OBn2asCevWDLQbL
5LBbcqXv7TsV9DRXtG5eIAeed/TY48lquDKYWEVnyME6O/V+k6MaWLYLkz2H
huBcoo87dULnghAb5cUhGLHvv76WPQysvP4dC2hDMEQtXFnL1wDrr4GePx4M
wKmTO5dMNI/AUV7+NqOUfngxw7qXptDC0czxsofMXnBvFGV8Hf4AD+xm6vlm
d0NpvL2jMOQzWL8YXM1Y8ByQoda7nEvHdd2DM7bwpKDO4hdlpulhMyR4113f
BoXpsWGMFYY4UPl1bKhQDEesCqeldRnj6ptFltMJDHo2/slSm6k4boAWUW9U
Ak3LD026aDMDL8fx9qKJDFIrC5DLP5thFCS3a62sIgmHkVRnzhx8dy7cnnWr
idRTCBi8Nku8epnVQ0lkK9l3nfd4eGwhPoNag39f3Uk+6ah1WBNqi/+d2V3H
ZD0j3aLEO582LMXc9AOM6H9eklIDvvjRmhX4dHF5eLB5D+kaU1SU3PcdDpGZ
fHBL7iPDJfsO+9uxcUdM+TdpEhkJWfVvWq9ycL53nVMqd4hMktiLslqdcElX
9PLJpQryaUJ5qcDKBXvdDMtRqd6Qf9qkdHoF/og3yZo5x7cNk4rPnS2iLjd8
0GHV4sYODfmiZd+rBId1OOK+YCoxOkKeCNwUFy30wJMMa0xzFr0l15u88HGR
8PFeDbslwkNLzjWd11rduQGfOirPPXNsjITQ0gj/nV74N2hwVInekTNzVsR3
u3jjI54/5yWL35OyQmX6qglvzDnhuiSB/pGMsBeYFpb4YNjlGl1gNU62GXvI
iDW++P2nOPGSoE/kLF9mUCT4YvdXh2nDGROkaRDHq8fOD0dGFI/1V34mZ1c0
P69N8sNrLxsRqzRfyJBdRdQNqR9WO/PCBEY0VN3Udu4Wk8Lrn8ZwIIuGMrze
qJ34FKY3O5p7OtIRlWmhv/cghecZGUv336Mjdcog86c8CgsqvqfRxHTkqn6U
NaBz9mbBkuMP6SjW71dRUj6FZxWXJVx4REdP11IxdwoozOR729Z00ZGBwiyf
LaIwI/183LiajpalJox8W0Zh2jTW7INmBLKqZKCtVRQmb7m76c8iUFiZdGxY
54TgvbvT5hBouRebe6SawhMVjY05LAIJb765nFtD4Y++YVENSwn0sjps/+ta
Co9mFNd/JQlkXh71ZB2m8ErnzsFkLoGMmZcsOnWOGZiYaupGoOSD+u+33qaw
mr0hzNKDQPTa88f23aGw4olmiosfgSI1F0cz71J48WELjngjgWzvUEzLJgqH
L+KGeAcQSC1IfFKo80Dc2artWwnEt1/vUHmPwtasuh55kO7Xj21Z20zhHeL+
yXtDdFbZGjbqnLfHhD0eSiCThpLX6+5TuM+CHZQYTqC0uev8W3T+D0+E3tc=

            "]]},
          Annotation[#, "Charting`Private`Tag$3788799#2"]& ]}, {}, {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{-1.3010299956639813`, -89.71352344123291},
       CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
           Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
           Part[#, 2]}& )},
       DisplayFunction->Identity,
       Frame->{{True, False}, {True, False}},
       FrameLabel->{{
          FormBox[
           StyleBox["\"Phase\"", FontSize -> 12, StripOnInput -> False], 
           TraditionalForm], None}, {
          FormBox[
           StyleBox["\"Frequency\"", FontSize -> 12, StripOnInput -> False], 
           TraditionalForm], None}},
       FrameTicks->{{{{-100., 
            FormBox[
             RowBox[{"-", "100"}], TraditionalForm]}, {-80., 
            FormBox[
             RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
            FormBox[
             RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
            FormBox[
             RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
            FormBox[
             RowBox[{"-", "20"}], TraditionalForm]}, {0., 
            FormBox["0", TraditionalForm]}, {-100., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-95., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-90., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-85., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-75., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-70., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-65., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-55., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-50., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-45., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-35., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-25., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-15., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-5., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}}, {{-100., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-80., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-60., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-40., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-20., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-100., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-95., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-90., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-85., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-75., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-70., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-65., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-55., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-50., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-45., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-35., 
            FormBox[
             InterpretationBox[
              StyleBox[
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-25., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-15., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-5., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}}}, {{{-1., 
            FormBox["0.1`", TraditionalForm]}, {0., 
            FormBox["1", TraditionalForm]}, {1., 
            FormBox["10", TraditionalForm]}, {2., 
            FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}}, {{-1., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], 
             TraditionalForm]}, {-0.6989700043360187, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}}}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       Method->{"ScalingFunctions" -> None},
       PlotRange->{{-1.3010299956639813`, 
        2.3010299956639813`}, {-89.71352344123291, 0.}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.02]}},
       Ticks->{{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-80., 
           FormBox[
            RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
           FormBox[
            RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-95., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-85., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}], {615, -606.2305898749053}, 
      ImageScaled[{0.5, 0.5}], {360, 222.4922359499621}]}}, {}},
  ContentSelectable->True,
  Epilog->{
    InsetBox[
     BoxData[
      FormBox[
       InterpretationBox[
        Cell[
         BoxData[
          FormBox["\"(a)\"", TextForm]], "InlineText"], 
        Text["(a)"]], TraditionalForm]], 
     ImageScaled[{0.083, 0.77}]], 
    InsetBox[
     BoxData[
      FormBox[
       InterpretationBox[
        Cell[
         BoxData[
          FormBox["\"(b)\"", TextForm]], "InlineText"], 
        Text["(b)"]], TraditionalForm]], 
     ImageScaled[{0.083, 0.427}]], 
    InsetBox[
     BoxData[
      FormBox[
       InterpretationBox[
        Cell[
         BoxData[
          FormBox["\"(c)\"", TextForm]], "InlineText"], 
        Text["(c)"]], TraditionalForm]], 
     ImageScaled[{0.083, 0.087}]], 
    InsetBox[
     BoxData[
      FormBox[
       InterpretationBox[
        Cell[
         BoxData[
          FormBox["\"(d)\"", TextForm]], "InlineText"], 
        Text["(d)"]], TraditionalForm]], 
     ImageScaled[{0.633, 0.77}]], 
    InsetBox[
     BoxData[
      FormBox[
       InterpretationBox[
        Cell[
         BoxData[
          FormBox["\"(e)\"", TextForm]], "InlineText"], 
        Text["(e)"]], TraditionalForm]], 
     ImageScaled[{0.633, 0.427}]], 
    InsetBox[
     BoxData[
      FormBox[
       InterpretationBox[
        Cell[
         BoxData[
          FormBox["\"(f)\"", TextForm]], "InlineText"], 
        Text["(f)"]], TraditionalForm]], 
     ImageScaled[{0.633, 0.087}]], 
    InsetBox[
     BoxData[
      FormBox[
       InterpretationBox[
        Cell[
         BoxData[
          FormBox["\"\[Omega] = 1\"", TextForm]], "InlineText"], 
        Text["\[Omega] = 1"]], TraditionalForm]], 
     ImageScaled[{0.233, 0.99}]], 
    InsetBox[
     BoxData[
      FormBox[
       InterpretationBox[
        Cell[
         BoxData[
          FormBox["\"\[Omega] = 10\"", TextForm]], "InlineText"], 
        Text["\[Omega] = 10"]], TraditionalForm]], 
     ImageScaled[{0.231, 0.65}]], 
    InsetBox[
     BoxData[
      FormBox[
       InterpretationBox[
        Cell[
         BoxData[
          FormBox["\"\[Omega] = 100\"", TextForm]], "InlineText"], 
        Text["\[Omega] = 100"]], TraditionalForm]], 
     ImageScaled[{0.229, 0.31}]]},
  ImageSize->Large,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.711115430109185*^9, 3.711115461625458*^9}, 
   3.7111229389363003`*^9, 3.711123173112688*^9, {3.711123712787504*^9, 
   3.711123719916381*^9}, {3.711123765228784*^9, 3.711123783512951*^9}, {
   3.7111238214026203`*^9, 3.7111238721437187`*^9}, {3.711123930392007*^9, 
   3.7111239545034447`*^9}, {3.711124024816183*^9, 3.711124039446542*^9}, 
   3.711124295868123*^9, 3.711124359008257*^9, {3.71112442114062*^9, 
   3.711124432544489*^9}, {3.711124485686489*^9, 3.711124512779757*^9}, 
   3.711124594435092*^9, {3.7111246602080307`*^9, 3.711124710682373*^9}, {
   3.711124758218314*^9, 3.711124806323084*^9}, 3.7111249083698387`*^9, {
   3.711124955543264*^9, 3.711124967614786*^9}, {3.71112502611861*^9, 
   3.711125105230843*^9}, 3.71112517197685*^9, 3.7111252143771152`*^9, 
   3.711125255672162*^9, {3.711125288554083*^9, 3.711125343836887*^9}, {
   3.71112543758541*^9, 3.711125450999239*^9}, {3.711125683206573*^9, 
   3.711125702472423*^9}, 3.7111257413241777`*^9, {3.711125806448948*^9, 
   3.711125913590136*^9}, {3.71112606196488*^9, 3.711126112999009*^9}, 
   3.7111261530602093`*^9, 3.71112649688545*^9, {3.7111265331043577`*^9, 
   3.711126541116928*^9}, 3.71112666292341*^9, 3.711126855382544*^9, 
   3.7111268918251543`*^9, 3.711127005889309*^9, 3.7111287265655537`*^9, {
   3.711128758120495*^9, 3.7111288063803988`*^9}, {3.7111288427678337`*^9, 
   3.7111289085788517`*^9}, 3.711128983360445*^9, 3.7111290253363867`*^9, {
   3.711129085441684*^9, 3.711129103582576*^9}, 3.711135512503995*^9, 
   3.711135581039323*^9, 3.7111357196345167`*^9, 3.711135782410509*^9, 
   3.711192764452446*^9, 3.711192815167913*^9, {3.711192882165477*^9, 
   3.711192930975157*^9}, 3.711193023021337*^9, 3.711193180572493*^9, 
   3.7111932651148787`*^9, 3.711193313438395*^9, 3.711193358827956*^9, 
   3.711193455636055*^9, 3.7111935856021757`*^9, 
   3.713186558134325*^9},ExpressionUUID->"191ba7ce-64c8-44c2-8fda-\
f96991471963"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"gout", "=", 
  RowBox[{"BodePlot", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TF", "[", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"s", "+", "1"}], ")"}]}], "]"}], ",", 
     RowBox[{"TF", "[", 
      RowBox[{"10", "/", 
       RowBox[{"(", 
        RowBox[{"s", "+", "10"}], ")"}]}], "]"}]}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"gdir", "<>", "\"\<bodeExp.pdf\>\""}], ",", "gout"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.711109006985846*^9, 3.7111090762886667`*^9}, {
   3.7111091311541643`*^9, 3.7111091327706537`*^9}, {3.71110916713526*^9, 
   3.711109229875011*^9}, {3.711109647375869*^9, 3.7111096538397923`*^9}, {
   3.7111096846005287`*^9, 3.7111096974064827`*^9}, {3.7111133338338337`*^9, 
   3.711113336364216*^9}, {3.7131865820555487`*^9, 3.713186586618487*^9}, 
   3.713186702919076*^9},ExpressionUUID->"6534fae2-8563-4d4f-ba16-\
a317e2cec133"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVlnk41IvDxRkqiSwtpOXaQtYUspSZLJNSSYpS5JKKRKSbulRXQiqhX2Tf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           "]]},
         Annotation[#, "Charting`Private`Tag$72342#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVlmc8Ff4fxd2brBJaCCF7FMq6yPfKSggZUfYKlSQKIYRQdmZIkhDKHuFz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           "]]},
         Annotation[#, "Charting`Private`Tag$72342#2"]& ]}, {}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1.3010299956639813`, -46.020707015351135`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
           FormBox[
            RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
           FormBox[
            RowBox[{"-", "10"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-48., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-46., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-44., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-42., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-38., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-36., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-34., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-32., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-28., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-26., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-24., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-22., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-18., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-16., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-14., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-12., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-8., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-6., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-23.010353507675568`, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-30., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-10., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-48., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-46., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-44., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-42., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-38., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-36., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-34., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-32., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-28., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-26., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-24., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-22., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-18., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-16., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-14., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-12., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-8., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-6., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-4., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-2., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {2., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1.3010299956639813`, 
       2.3010299956639813`}, {-46.020707015351135`, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {-40., 
          FormBox[
           RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
          FormBox[
           RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
          FormBox[
           RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
          FormBox[
           RowBox[{"-", "10"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-48., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-46., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-44., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-42., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-38., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-36., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-34., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-32., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-28., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-26., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-24., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-22., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-18., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-16., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-14., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-12., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-8., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-6., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-4., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-23.010353507675568`, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVzXs0lHkcBvCZN0s7uVcSU4zDEWVKIUb8foQKuc8baVwjI5TUrm5ShEpC
oY5ku6nQTUQW7ze2LGmtzRJdpFzCYjDIzLT23T+e85zPP8/DCdnnFUYwGAw/
Ov/3yw1RINcmpg64yWbMBuThWqiTb0KLmNqprDnOnpaHQxd1RbONYuqnoq5s
ZTkF0J9q1xmpE1N5QqMZZT0FSCqzOdFWKqYkPm3dyQEKgE1VbK+liam05LpC
5y4FeMYt+3UjFlNOguAFezsWQqnRt6eRD6co+ccHP8SJWPDpoHvuwUOT1BO5
k4J2FVVwWpZc6eoxQQUHnHMMG1WHrLB+Wd86EaXOElazeRpAquuT9pOj1N/Y
N3dDnBaMKlha7Cgdodic7qI3mjrAuft58In5EJWk/yBPNVkPOL8M9GY2D1DP
DN4O9IoNIMnpdiDrTB9V/LnKbr7cCJLyJA9eaXym8nmVx11judBsslTO+2oP
lVFq597SaAoG7wd5KnrvKLQ+Nbb+lhnU9Awu8XfqoKqyrvvvM7aEZVgw01Pb
RvF/PCy42WkNu0bmp7/eaaIGH3Uwy9gYqiqKdRcTQHmmKbqTMfYQP8AQ1rJK
qfCB5rzGMgdYC8e492Q5aCW7P8DSfAvgoCGT1qeVyCQn8b1T2jb4bQX1XKv6
BQqhxEaKMy7AW6P/qiWyFYnurmEarneDbNwaksJrRzrq413ayh7wemlPjQan
C+UsKPex+u4B9hmHVWLKPyCHf5tje+s9IavkUUSIZi8ai75uw4/2gtB+pW+O
qV9QkDA/vlPJG97sf7TgfEs/Csl0IV5leMNtzxqbdPuvqMdYkRsi7wOl3TFr
F90fRoX3gh+NC33AoyK8YHT0H1Sfeg5/r/KBHf2NVmmB48hkSXNyI5MPxzds
NGp4I0LzU+xZd2s+CH8XqBGTE+iv6Ls3AvfyQX7hM9WCVVOIt9DfODOPDwdE
Fn8IncWoO/jL65hqPlxIGrqRnTyN8OaS8wHdfDhK1ZmP3ptB6Rc8pKen+HDS
fc+t1KZZ5Bg1EXlkIQlWZx2ME5hz6NNls4TH2iRQ0Q4xRfoSJOs7JGk3JuEb
enzikpEEpfM3u6qtJmGd+sqsU1wJClcKittO+8bT2ScBlhLk1TFv94J2ynzx
nIarBLW/1OkrW0PC9iy106lxEmTt1s5P4ZLwrvxjfkS9BL13jq1WXk/CrDS+
yThIii5xeDdKLElI1OZ3M8OkiBsysekDbZa16chboRRNKXIrlK1IYB8ZUkyN
kyKvrXm2sbTtv/l5fEmRovVuDZVmPBLSxbzO/PtStOuhtm+FNQm6o7I+RakU
3cFekwW2JGz7mMgYz5Eh9a7hMDUHEiKFJdN9T78jWcZgrNJ2EjYVsoiNon/R
k5krZ7fwSRizdQoXsBjY2o2seu5Pgsvb/VbUFQbuLPZWMAwmgdloruluzsS7
sxV1tMJJWMlS7Pj5JRMHTvnuY0SSICgzYzCamPh0iW+sKu2rOwXGaa+YuOVo
2R5d2lolDxIu/8nEiQ65ppi2hqun4bNuem8Ty/oEbZWM3HjJGBOvkIyultJm
qHO0jy8jsJd+Td3wXhJQ9TbHH7QI3GMz7T9HOyHkwL7zbAK3E+ljClEkyMoa
Ggo4BNY8NjGlT3vOOzyqbjWBa6PjEgNoT+aU1M4jAhuypUWttE1t2wdT7Qlc
uOZmwQfa+wdkaqqOBNZbrnd2hPaYhVu4rjOB1RbXOyhEkzDcKVK28yHw3EZf
O1vaRonLrZpIAs9KkwddaEessg/19CNwkXFDkh/tgfiLlcEBtIszrx2kbcCp
6R0KIrBOEHfFKdq7m/oWHQil/7dKsi7QvhWrZCEJI/DqM1LZVdpfllsEnYog
cI6dVUAx7f8AlN66aQ==
           "]]},
         Annotation[#, "Charting`Private`Tag$72748#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVyXk81Hkcx/GZ3xIrGl2DTlOOLqq1pp2K39css9E8cv6KMiVikaQym3al
UlYKbYekpTY5GleymyPH51uSpmbJ0VQ65BjMTDOGRodUO/vH+/F6PB9vVvBu
n1CCRqMF6PZ/7zlEYb02LXB2Nty7QrXDpRCef4JEC8smb7Y8v70dhGctNe+b
tZBUtsHtzK52sHrbOV/ZoAWbgiz93KR2OFrhdKitRAvB0hb1/Mp2QCsZzpeO
a8H1lXAwy7wDauwralchLfhfWMMt7uuAksUfKiOvvwV5jmuB8OxjeB3reT5W
OAqH+QGHsuufAc/sWBXfawTMifjprM2v4HSobKJ/hQYaHhucdJP2wMZpVhu5
oyrostCmyJAMVAY/sDeVKEGk58S6aiCH6Iov1+JzlZBp7D4j3EIO6sCm2bkX
lKD6ornKWSoHzQ0fuuqYEqxNeusITzlot+ySJAqU8Mt8jza7TDmMX88NLpui
hNmlzgeGFyvAwN/klP4eBSRFTbq7PUAJrGu9g387yqFU6OBn2asCevWDLQbL
5LBbcqXv7TsV9DRXtG5eIAeed/TY48lquDKYWEVnyME6O/V+k6MaWLYLkz2H
huBcoo87dULnghAb5cUhGLHvv76WPQysvP4dC2hDMEQtXFnL1wDrr4GePx4M
wKmTO5dMNI/AUV7+NqOUfngxw7qXptDC0czxsofMXnBvFGV8Hf4AD+xm6vlm
d0NpvL2jMOQzWL8YXM1Y8ByQoda7nEvHdd2DM7bwpKDO4hdlpulhMyR4113f
BoXpsWGMFYY4UPl1bKhQDEesCqeldRnj6ptFltMJDHo2/slSm6k4boAWUW9U
Ak3LD026aDMDL8fx9qKJDFIrC5DLP5thFCS3a62sIgmHkVRnzhx8dy7cnnWr
idRTCBi8Nku8epnVQ0lkK9l3nfd4eGwhPoNag39f3Uk+6ah1WBNqi/+d2V3H
ZD0j3aLEO582LMXc9AOM6H9eklIDvvjRmhX4dHF5eLB5D+kaU1SU3PcdDpGZ
fHBL7iPDJfsO+9uxcUdM+TdpEhkJWfVvWq9ycL53nVMqd4hMktiLslqdcElX
9PLJpQryaUJ5qcDKBXvdDMtRqd6Qf9qkdHoF/og3yZo5x7cNk4rPnS2iLjd8
0GHV4sYODfmiZd+rBId1OOK+YCoxOkKeCNwUFy30wJMMa0xzFr0l15u88HGR
8PFeDbslwkNLzjWd11rduQGfOirPPXNsjITQ0gj/nV74N2hwVInekTNzVsR3
u3jjI54/5yWL35OyQmX6qglvzDnhuiSB/pGMsBeYFpb4YNjlGl1gNU62GXvI
iDW++P2nOPGSoE/kLF9mUCT4YvdXh2nDGROkaRDHq8fOD0dGFI/1V34mZ1c0
P69N8sNrLxsRqzRfyJBdRdQNqR9WO/PCBEY0VN3Udu4Wk8Lrn8ZwIIuGMrze
qJ34FKY3O5p7OtIRlWmhv/cghecZGUv336Mjdcog86c8CgsqvqfRxHTkqn6U
NaBz9mbBkuMP6SjW71dRUj6FZxWXJVx4REdP11IxdwoozOR729Z00ZGBwiyf
LaIwI/183LiajpalJox8W0Zh2jTW7INmBLKqZKCtVRQmb7m76c8iUFiZdGxY
54TgvbvT5hBouRebe6SawhMVjY05LAIJb765nFtD4Y++YVENSwn0sjps/+ta
Co9mFNd/JQlkXh71ZB2m8ErnzsFkLoGMmZcsOnWOGZiYaupGoOSD+u+33qaw
mr0hzNKDQPTa88f23aGw4olmiosfgSI1F0cz71J48WELjngjgWzvUEzLJgqH
L+KGeAcQSC1IfFKo80Dc2artWwnEt1/vUHmPwtasuh55kO7Xj21Z20zhHeL+
yXtDdFbZGjbqnLfHhD0eSiCThpLX6+5TuM+CHZQYTqC0uev8W3T+D0+E3tc=

           "]]},
         Annotation[#, "Charting`Private`Tag$72748#2"]& ]}, {}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1.3010299956639813`, -89.71352344123291},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-80., 
           FormBox[
            RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
           FormBox[
            RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-95., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-85., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-44.856761720616454`, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-100., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-80., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-60., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-100., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-95., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-85., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {2., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1.3010299956639813`, 
       2.3010299956639813`}, {-89.71352344123291, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {-80., 
          FormBox[
           RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
          FormBox[
           RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
          FormBox[
           RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
          FormBox[
           RowBox[{"-", "20"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-95., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-90., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-85., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-44.856761720616454`, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.71110905532486*^9, 3.711109077155821*^9}, 
   3.711109133905964*^9, {3.7111091812045107`*^9, 3.7111092308289757`*^9}, 
   3.711109700093973*^9, 
   3.711113337831024*^9},ExpressionUUID->"df83304d-f57f-4a84-92d2-\
700040be524a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"gtest", "=", 
   RowBox[{"PlotTFsin", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tf", "/.", 
        RowBox[{"a", "\[Rule]", "1"}]}], ",", 
       RowBox[{"tf", "/.", 
        RowBox[{"a", "\[Rule]", "10"}]}]}], "}"}], ",", "100", ",", "4", ",", 
     
     RowBox[{"Axes", "->", "False"}], ",", 
     RowBox[{"Frame", "->", "True"}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.711123238373775*^9, 3.7111232403710537`*^9}, {
   3.711123312097876*^9, 3.711123396686198*^9}, {3.7111234695238733`*^9, 
   3.711123479042204*^9}, {3.711123523627162*^9, 3.7111235440455837`*^9}, 
   3.711123582889353*^9, 3.711123617368433*^9, {3.711123660719149*^9, 
   3.711123665783819*^9}, {3.711123727241683*^9, 
   3.711123731665463*^9}},ExpressionUUID->"3e88e23d-c30a-45c5-84ef-\
dd46cb2d2323"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUV3k4lG8bRVIhJRIpWQopKsmWHLRJZM1a9oQUCT9UKrKVbWZs2dfITpax
vmOfrIVUEhIlCmkhRd98f811rud93/u+zznPM88RsXU1uMTCxMS0i5WJ6f+/
Ypf8VkLXyasyMY0Nvy5ZVJkcbuSWPcKLaR3tvoKZaNWp94UsbEd2w/4Qq4Gl
TLmq5Uvfv+66Mnh/xDRMLaxN1XlC7M+cnBxYz+3/bbDar7rHkt1bXEMJr0Xp
E5vkRlXHXs3/uKCrir8XFe5eufFRtSd3hnqmSB3Wml5OOg9nVfMnLRcn5E7g
totUYO/8d9UQ0b4jd2tPQdpvy/sV5d+qDlYnPQQ1zuCSXMZRyd3/VI8nUcsq
6WdB9GzbLD7IAuE3+77p656DlMBR3VQnNvx70Bv3y1kPfC/qPjlrs+Pa3g0K
J4r04SKytvU/Py6cdbjlOSpnhADB1tvrp3hQw1rJK+19HluedMbU/8cHycy5
p761xqji4vOZlREA25jtwlYNM4iaftoYzLMLHn5JJLtAc8y852F3ERbBhx2D
B0vpFjA29jas7hAFzeyMq7auJTqVe8r3mYvjwJI/VwLZCr2fndrUIAndsyOD
352tUfMh+dpbBSk0fN7mpV5kg5x1s8cC7GSQKP6wfFjOHk8iREtGXxxG30+J
+wGD9jBa8SnfuOUI2FtbDKW8L8FNkOX+kIU8vO1WF/6rdUDYPvgd41SCcdr1
QzwaTjjt61qXMKqKcFcu5poPTqhWuLnAJ6+GFtX859aBzjAVrtkowKyOw+8m
XIvoV8D5wiRUKVsDm7ebFp3RvYasVn2HiD2noPn5x+35+WuYbi1eA+7TuEMl
6cSRXSF7Zjk8nFkT/+Vf8lpwdkNUz/XsX3Nn8PFM6la1ousQ6pdU8l9zDs1B
W4zeynlAryVObOSuIQ5WvJG5GeYBV4mR8koJIyR9SNsgOOEBpivCIjtfGMFD
7QBhTvFEWoZkctA+Y4gvn5Ua+uaFgWOK2ddXTfHgaiDTmyIffL4t19YqYIVf
idpvvdl84RD+aXb2kxXsOngq+S19MXpK4YbCBWuoSGRcMd14E5sKysRkD9pg
dqxh8NWVW1Bd2dD5btIWBkZLBYOSd3BPrLTrdJADGvyJYK+7d/D5lX3tnn8O
2FcaZMv3+g7G6hojuXwugyWYnTP/+F3GPEr5S66OGPoQ3zi9cBdk8VzFr07O
CEuu2O+s74/sMFXWE2HXML95jsWJKxBrlBT/9dfdwC6TjEJ9hUCsdFTY57J4
4FzyeVNl60BY6zZX9Wh6oGBvXSFHWSCMhXa84xz0gJNGqGnR+SCQdz1XPvjD
E+M3xIq+JwXjnGwBz2ZVbwwMmpj57XuAykqtd+xMt1GdRCumaEbChlRdf/1W
AEq8+2aK3CKhsGHNuGhWAHKNJiQ64iPx7aQHx2BnAOI516cxfY6EhMwQm5rg
fag0SNArT0ThYML6Xu6a+9gh40oVm4yC6c0QHvHFQLzduBq/soeMolr2/DHn
EAz+YVPgUCZjo42U/xNSCPo+b3rJf44MnuiwszbUEHS0inDLeZHBXspumrg2
FDW3T4Y6t5FRLhnWJZkaioSvYT6vHCiQyrJ5safnAcy7Bc1Lc6JRa/dIvnpb
ONi/jvO610fj7eNbWidVw1HDmdcr2x+NLesffcqxD8d2bcWT5avR2Cs7Mva1
JBxvO4wOVp2PQZy/7qTT6QhcoIez1a+JxTi/eQH5SiQ4p4wabwvEQvZp+TuF
yEjUrdtxS/VALDKeB+x7UhaJHafzvhHmsciOvRH+dSkS71rbhptKY1FZmEHz
VI+CZfO/MrpVHN5P71jla4sC14e2q6Gecbjnxpe2ezAKDSwRkloP4/BX+rc7
z8coCGnsSOmsjMMCH3ssZS0JozTF0J6N8ejcqHmU7zgJ1g3XrQZq40H8ytGf
qiJh84ji9pgX8aAqc92ZaiWBtvJv4PyneKg8Twpu7SdB5FiE1qstj6BUfYN3
6xwJ47V5R4acHiGn2GfHmt1k2FV/4BjbloAr0QL/poPIiCox2CO9PwGCbELW
gyQy6nIaVX3VEsC6S40rLYkMvtjU67xOCfhagozuUjLo7havNGsSMHLs3duw
ITJ+OHXMx/QkYF/fndeXJsgQsVFi/zCegLvjrM2Cs2T46m47dpsjEZnv+ct2
MlOwf39/RumFRHx2+GjquYcCUzGNulW3RAw7NasfkqEgcHvpy7OBidDhzZ6l
y1Mwsj5y/cfCRGxZM7Xz4WkKSJNa17b/S8RWWnC0yWUKGoargy/zJOG9V7bV
7DUKpvsl08slkrAqmM9s7UXBiSa2gXN6SUgdGDXsv0/Br5QmpYD0JJj9x/79
VyoForGHDJ9XJCGXP0DB5jEFuuFpLjs7krBrru1SdgEFuTf9UqsWkrAwIrKh
lkrBS/evVNZ1yVjT8U0jrIECFucLffqCycgNX52Tb6HAwlR57ZfjyQijXpXm
76UgRPeJkJJpMmZeGYWfG6Cg/BS/YpBLMuxPHWC1fEMB15FfzsIxyUjr41ld
94ECGnfZc6OPyfj283tM0A8KvqwXmU5fTsbE227h+0sUCDBFrZnjSsFI9Cl9
878UuM9elQ9VSMGourNz1JpopE4O6w6eTcEYH01+ni0aXcNnncSsGet32d0k
2aOxp3NvUn1ICjpf9s2LbI6GQVN8BXtyCp6m/xH8sCUaftXrek1KUxDZcu3m
ra3RyC/xmspqTcHbImbm2W3ReJ0zybzwJoXx/xmaorA9GqypRoKYTUF94vBJ
sx3ROBTbLBfGkgqdO71TBkLRsAyXPfeGLxUnvij47BaOxoP76ZfF96VC2HBm
qlskGlcKe5LF1VNRVl8Rd1UsGtqDf/rFTVIRILWdY2R3NKT/SbJLXE1F/VTd
yV3i0eCSNFaTCEjFS7W1mockojGnF+Al8SgVokfMt/BKRuO5T0mBRHEq/rWL
ZrczcEnGu3GJ1lQ0/2ll0t4bDVInu4Dk21S09+XtSWdg9x8KupLfUmGnq8jb
zsBPIso0otek4duNl131DLxd7NnFaK40PNP4rBvIwA+qRr2jBdJwvGEoeScD
L5/9RYnenQbq1OaqIEa9K2OcxdEH0uDfspBIY/Q37CHWEa2chkXDT9qdjP61
NyhPRp9Mg/uj8x2P90SjLlmPKUYvDVpxWbyG/59X9rJgjEUa3uge3f9cNBop
bbflYxzS4NV6l1uIwReXRbR+zPU03Fp+26Kyi6HXXJ5LzK009I4/PbV/ZzRm
AxqDY4LT8Od8TOIXhj69BbP1MclpEOk9uzrK0FNNfe2bmNw0CBplyfDwMPh5
Kfgj5mkazJ8aeG5j+CFqVVMq9lkaHq9WPaBsiAYTxepk7EAaypwWbnIw/HRd
wss6djQNawpD6UYsDP/oZcbG/kyDW81LqsUyBU0T1aWxTOkIW8N1R+AXBYd9
nnfFcqTji2jeZO43CngzVljiRNLhOc77RmWKgvvyvEJx+9ORynw5RJ3h/x8d
UkpxCung/Cm2k3+Esd++m7jG6aSj2Hjy6NF+Ck6FXHsQZ5qOqKOhU8HdFFTu
CMyOs0vHtm6FtsftFMSeLHsb55OO86/b4i1qGedLHKdmfHY69tVtOZmdRgF9
n5hdfEk6Rg737gp+RIESTckvvjYdtosbFFTIFGz/7FAe/yIdD5bXpwsHUPBW
uVH40Qqj/52UjYO2FFiOeP5+dD4DmJTg595OgRr/BNXBOgOLnOXnL22mQMzA
wPvwlQx4iFAro9gomGqVWey6mwH2Femkqwtk3Cj89ONffgYaf/xec5JORsgt
s/lLLJlQibOkkV3IcK5sL5bdmIm6C2kT16zJ0Jk/4vpvWyZSHZv49xiRscV+
y2y8dCYiG6xThI+SkXS2c6bTNBOr60vTzdeRUbr92KdDxZkIPf0zmesRCdFG
+Y9XqzNh9+9ods4DErwiBBw6WzJR/ybLQ+gWCSosvybshzJBGP80e2xJQtvn
ovG4tVnoa6nhExclYYgqPLJikYVXO90qRTOjwGrC+vLZ+mxwdttc2CAUiexb
bc3DW7Kx/dp3rf1/I3AqI6Rsbkc2tCmijmJDEQj+yhm19VA2KMOSGlExEWC/
v/WsjVk2qh7e++fOHgHuUvHGpSfZkLvU8uP5lzAIcZwplDj7GPeX6rVy4h5A
iQgPDAzPgdtOd+3c7ECUrxSxuMfnYG8413KjTyBkVJ7fsczMgdbhgtk+nUDs
rt7iq1Cdg+vfz9De/byPzU/jrn2eyEHV0uOwgpP3MfU43URHJRfch/TfDk/4
IzaiYu/WmVxwimS+XRS/C+7uwcfMv3IhP9W37+evOwjjWBKbZXqCvJ+J9dvT
7sA/RFmone8J+l7dC+9a8MNVf2KLj8YTBOyMufjz0W2c8Hr2Z/jRE6xKHeB6
Mu+L7xffdWdp5kHoZYkUS4cn9ocY+L4yyEO/sH2a+h1POJS1i7NfzANVm0ui
Tc4Tr9nK7rhez8Ph/TGvMtI8UFccdEg5IQ/R5hGvnt28gSDmgzG9M3lg/qs4
0aZ2HfzZ/heWI/Lx0aqyyWy7M/R7F9dLP8qHmRrbF/MEJzz47VJhlZkPx3MF
glKCTvirY8LVWpWPGynlKsq7HPH+1z5a5Fg+OmqfaZscckCe5kuxPbIF6DDN
fCd7xxYqXyRmdF8WYLorlYVIMsFU7Y+juqMFaDrJt+v4W2NQHjaGnftcAKP0
iuo6QWNMS1nI6KwU4L9AOYXEDCPEOUVc19pTCL7Hj77r0fWx8PHH4gnPQog/
d5lemtFEcmWj5ok7hVjQahRVyjsNzaCIR8dDCyFaTmmtcTmF1D2SRzWSCzFs
cexj3OpxaNtb+KG1EP+Rx3PTC1SR876RVXlrEeITltpGHPbBoDTivNKuIoR8
afzH6SOB1bsWjxX3FuH58XKPU8liMBL+eVrhWBFeF7dd5FfkB4uV5EO5S0UY
E9Fpl7KcbyiU+fn2sGsRFK8+nY9JXUuYrjbuP+xThPkOPZODdtxEcbJFz6Hw
IoRhQXy9oBBxYTiC+0BFEdLfvzwu9FGKWF9gYStDFCHS8SDbzUJp4ulNyafS
z4oQpUPmYj10kGAXbDLa/64IhqaBfOrPZImK6YjsfZ+KQPdg1963To6wrrH4
JfWtCA71P3bGHD1CVJn9jNu7thjX93Jv6A1WIGz3Nk1JbirG0H+6b8mpigTX
7wglSYFieJiVKTcUKhH28ZJvxaWLYbxldO+pwqPEZsef+8QVilEgOmOSmqJC
1Co03dqjXox0wtTHLOgYseWVhdDu88U4P0Ja81kRRDwRvPLXqhgv3hRIH2dX
I3bmPh1+6VyMd3Wyd+3c1YiMqNHaIs9iSJzqPj4woEZI+nAkBt8txn2xOY3o
Q+pEoY2Cr/XDYpSxcGhmhKgTslp2ZkqxxQgiUXauvFEnjgnWbpvJL4a1Z4Vd
9BUNomnNp1/NlcX4s0fOqSdfg9D8smUwqbEY3semHfU+ahDdA6oVnl3FSHLS
khYQPE4Y1DtHn3tVDCXT9rsSWseJ14yLuMR4MUSq+qV9bxwnLkY0GTB9LYaA
3PjqprjjxLjX7KE3i8X4cetSw6fy40T5gfD1ZswluIfn8kzdx4lFMTHvVrYS
hO2NkTUdPU4o81d/OsRZgvdT4rdmZ44Ttzh1TVK4S6C72D3RuHCcIJgm29i3
lcCdwqvR9/04wfLTV/6/HSX4T5qvUnjuOHHi8+bHH0RKIDzt6l00cZwIfvd4
q55ECaRmG2i3Bo4THS9UAuv2l8DYMq0trOE4sbGt74ekbAnsrUobRzOOE3o1
jvYxCiXg4Yv87HXvOEEuWu1nPlaC/TmDnobmx4mXGdHHr2mUwFphT4qX9HGC
P07q6dDpEnjNbEt4v6xBmD+kiZ7WKYHS1Nn0mCYNIvmOMfmpQQkMDSxnKPc1
iLEbX5iFTUsQee5L8Ts1DULM0f962MUSFDBTxD0W1QmHC/zvl2xLcCVqLsg0
V53I1SvSu+RYgqRdqevDDNWJmRMnaC+ulmC0X/XDpt9qhIzS0AHVGyVg7bty
bjJejXCTdkvN8y7BO9XmexsPqxG/tib5BQSUIHm2U7WyQJVQYpednQspwXf+
V9/WEseIW6vtFy9ElODhKeEF1jYVgvnTd5Ujj0rAJO15RbBMmeCknv3zsagE
RlZrxHTXyBO6Be+dDctLYBfztSOnVo4gp/03RFQz+lMzDh9zPExsC82sjm8p
QbjZ5cRNGQcJUfM//2kNlcAtoue9tfAewv4c6VPlaAlYyk+zFI6JEDkaEiZi
k4z1pJTbF/h2Evv3Gcr/nStBebrW6t5bXITC37wfhWtLoZhl+25hnhOmH6dv
1rOXQny/+VDCs63wfS61pntTKdxJTp8msBMNWXncXwRKUc768sczHXGc0smT
kZIpBdfXzS9Yjh+GUcoTx8fGpbhzfM3LtbEa8Ar5PFdhUQoFXofL/vTjiHff
+1+rdSnW2arrXfh3AsOnngROOJci5IDGAq/vadjN5WaI3imFbAGJmydTG+5q
ucMpOaXoizzyKGjUENFSU3ZFBaUITGJ7E5ZghEpeyZn60lJcEYp7GW9yHr+n
cn4P15bCavqbSMUrY9wl5fAJPi9F3t1rfVlzZogcf6wXt1SK3acbPdqPWaPg
fnZL5Jky8Nr+3WfvdRlH//DycOqWYaP8Rdq1P5fRcf2+TYhRGZaXLoo63XPE
lKXd6l2rMgh5O5qJRTlBTElE0d2zDOnkxqHL1CuMPJ+Ub5ReBsHfTaXMAm4I
MY4mC/wuw8fxxNLctx6wlwywzsx9irpqg8riI3dQcF2Ima3oKWKLPTfPh97B
j5rqdMenTzEWfa1Xe+QO7uvMj0s3PAVJ+3hl3vG7yHK/eIna/xQqOvXpKl/v
YqJOwbl79SksjP8ojar7w07/y41Fo3KMKJYUzszcR15CMK+5eTleee3ItOYL
xMIH0Yo6q3LYs5/506kWCH8vs1/3nMvhuUJ/4R8TiIzENm/Ou+XwGB2OtlAN
wvhk2m2R/HI8kW57sS08GLa+54PPMlfgrI/jjXKBBwitToA+WwVKc7l+vFN9
gJKl0UVjjgq8Sfq5Om33AKtezo62Wyvw5Pouq8LCB0i8ceeMz94KDCad72/C
Qwy4POHI0a/AY4WLRVUXw3DSaiWSJaMCF8cL8yVuR8AlRUNzfU4FAr4+U6xK
jkD0u2AmroIKHE1ptRJoiMC4xZbrApUVOLJ81dFwNQJ+phIGBzsqsHGcaSzy
ViQq9fV5LRcqIBIvZP9OIQqSJ7LjqzUqUTp6W/0rHwl1m7bz79esRGHhM+qa
PSTovY2IS9GpxPDQceFFWRK83b1jA0wrsVdXrOTGORKepZ2N1rlWCVqgjENd
AAnOK98i3z+qxJrfv8r0P5GwSnfYZJRaiX+NUar830kgR7+NaMuqhKTbiZmq
VRJq9rWG5xdXokugau7eVjI4zOMferZW4sPCUsJRdTIKKlWDN3yrhJ+a0/6d
JDLU/J+y3fpVib9v3hyyTiBjQEcyaPZPJV70mv/nk0nG3wnuwH62Kpy4dpZd
poJxn+aZ9E/eUYWxNr5TCYNkjI+YsWwWrUIMRUnjwQgZXnk99/wlqnBo6dNG
3Y9kpKhT716WrWL822dbGP8kY9b1od8hzSrcbiWsTbgp8D/KtJqpUwUpQ3Lo
520U8K3zvM1nWAWZpG9+ukIUIMXy1p+LVWC5cPBWrBQFA079f67aVaH8+S3z
/w5S4HhE8+aYYxXu/T1Qtk+egqiuQ76tN6og65nly6VOwe74x78VfKqwRPQ1
qpyigGon6JPnV4XUevUDqmcpGFtm9Y4MrYJBd+3eGiMKPNp8Fpkjq6D+7nC4
nBkF68mzXh7RVRhIbGu+d5GCQ3tfe5qlVqFImM8k+hIFWdO/OF2zqsBdOJG9
3YkC/oKtWfefVOGGAAx8XChYlTHsK35ahX0fl+8Q7hRcn7/u1Eqtwt358NHH
nhRMlEYxva2vQo/MZjMHbwo65Xpk2OhV0E08aXz1NgWqv760CnZX4c4NKWr5
HQrKqjguHuqrQma/zXz/PQr2+Ej9OPWqCtQo1tkORt6KVz7z8MJwFRru7Et7
FEgBx9/Lou7vq/DUc+4nginwqw+qDv5YhdjTTiP1IRQs+GXrJc9UIW2LyRme
BxRcUmv5VDbPmEev55DaQwpeM3/wo/+sQvfYtaQTYRRoNzPzjSxXYSJONEI4
nALivnDh939VcNbs5xhgYNlTOLFhLRWurc7brSIoyF5n+VaInYp1430NjQzM
/+yWu9wmKjSu/1z5w8BhDxI3aPFSGe/VDW+MpODf2Zo0KwEqZg5zWy8y1t03
vlHwFKLi9saRMCoDf+xZ7HkgRsWfbE5HfQY2i+JzSJOkwut50K9GRv0u/SMr
FdJUMFvLH2NnYPAYRXfKUlEgsVZditF/2YD7vvcKVIQtD7OJMuYTjyU1/VKh
oiQ/h/ItlIJHJiVmnBpU7OPS/RLP4IdToHde5DQVm3/WbeVn8Hd36GuwgjZj
vsNveV0Z/H5P5Nylo0/FhSTKbDKDf4eL+yptjan4xPI8J4uhzxshLR1vCyp2
K/ueDGDopz3mOBFuTYXY1ltdSgx9D9s93lLtzKjPIpMnw9D/8e7WJz2uVNjV
lrJfZfhj+8cPahMeVAjbyzkGMPzD5CTiuukOFSx976QVGf66IaXGtuc+FVrH
XqcOOjL4mbFMVg6lYmLCW1SH4c/ua0mdlyhUmBwxutrE8K/awVrbm/FUGN23
RSPD3+Xf3vyOSqZi4PzskfjzFCR4bJOsy2HUq3g60KNNwWVf8v0tdVQ0G+pV
2ihRMHS0VFCykQp7PrMju+UoOLfSW3asjYqnYz9TCBkK5O5ufO/4nIr2XVaJ
98QoYA4KOUZMUPFQV0DwCAcF4/2DierTVNwbl+CVZ6WgSWTPcvMcFTxPaGLs
K2T41zdW0pep6BCq4dw/Swbrz+UDfZur0dP1tcS8h4wJjTMRRnzVmNnhumGp
lYyWqLgvg4LVkFTpvu9UT0bgfrknb8Wr0XzkjPOzfDLY7K+KTqpUo++ITeLd
IDI+ltbevaxRDeyarmi6RUbbvw2jn09XQ+9Gxr837mQEJz5OnDWoxs3pZ7kh
lmSs7x/lXXKshtHnDPrMYTLYNQzWccRUIz1oYPffQRKmI9MuhSdUI1zaMvpJ
Bwkd72abN6VVQ52em3mggYSHPg/v8uZXo2uk+0FbFgmcpS2/dzZWQ7jafXiP
GwmbhBW+HPxajbzLTLHv/kWBd1XwhfHJGmxbfFk7whqFIqHYe4RWDU6FHgvp
nIrEaWyWldSrwa4unb7k9kj43mWl/Davwe/7/P+R7kdilOWrUZJbDWIvJ9Ba
/0Qgb13D6/eJNQD31WNTo+FQ47Yec1mowUGhy8dOBjzE1d1Zc/6ptbhztXJL
sEUQIpqeLHmM12Hx27utfdHe8Li0Evz1Ux1S9l429lbzhtl6/W0OX+tA9Kh2
GH/5D7vPLR0xWarDGs65rU0n/kPNm1M3lLjqEbE63ey75IlP8x++rijVI1qE
q5jqcgNqu4Q+BJHqsfSPO5V7z1WIN113/xdbjwOaghLrolzAcamV2TupHvQy
n3/0P1cwmOci7JRTD2Lbkb81L53hIl978Wx9PTzU0jIeURzxSMf09abP9ZBZ
J/BQR8keCzfJ3fFqDZD3Udwy4mOKKt4oj/KTDXD0uDWYlWiCW4Xhgs+1GsDy
wG29AWGMtaMhTuvON6BGYnXuGud58GvcWevl1ICxW2ucdzbo49h6l2OG5Abw
y+nmx7GeBku608S1uAZ85JdXkw05iTalyw8fJDVg2Tdg5e+mE9C7Yvum8XED
ioxGEuT3q8O2x9TzYG0D5LzesIUcUEBI9MnCjRMNOCi4IKX1ew20pY8b7f3c
AKb1y/OK/0pUudvU/pyYbcDmSYMyp3QWImHx6JlbSw2gtZ3Ojdu4gyg0l52c
5iQwxe3YFDR1gHD/fiCMbQuB82ttVK8KyBLyYdKHRbcRjLy497XWETmCVi95
z0yEgOhOj9nfeopEn/CunfQjBEJ27zr4gEONiKve0fJBmcCj0LPX7JfUiAsG
26/8AwFf7wKF62PqxGTA1mp5LQLXTw83cjHy1dJHjvPZlgT2s7L+npk+RdTd
2fCXZkdgpIDPZLbkNHGPf13msCOBOvEsdw53TYJdi+Ubzw0CfnJCepGTZ4id
hUth/sEEaFpbH0eStIkEftGg+2EESLvjb0lK6xD898/eCSIRuMh5Qo6pRYfg
tUi5/iCRgNSGA3wOH84R5LZ257A0AkzCyxLfrugSm2W/2UVkEzDVZJsun9Ml
ODecMCYXE0ia+ivu5qFHPPC4qhtdTuDZo8orosV6xPqxWM3YagJhL3fMX/2k
R6yp+qyc0EwgcdY3tVtPn7gryiOXRCfQ36WoOnZPn1gNV5FO6SZwW+EAa2iJ
PrFsH7kr4xWB8af6Xx+xGRDez6n8WcMEgtuO32eSMSB+HR3nfvyegNPl5b3L
BgaERw4HR+5HAiuxpvxBngbEty1HWPNmCJSdVw/NjDEgrvlZruTPE1ibFVep
/9SA+PI5+FfhTwKu/qpDkT0GhPP50rniZQJW3/hlLn4yIKZoQ1Ol/wic/bbh
C3XFgDjMx/LNjIWGXP8fOhnchsRCZ+zXIVYaprNrw/nFDInSe/umLdbREGSh
Mbld1pBwU6B9HN5Aw0LmlYhcVUPiwFejDxc5aci4s72ZpmlIzGZ8Hh3hooFj
7lC9rZ4hUWDqN2zFzVhfiK4MP29IXOHieTPGQ8PoA/HPaqaGhFRLzksbPhq4
162n3GTgKR+VvnF+GkI4LFOOGRsSOQde9NgJMurxpL4K1jckHCYvdU7spIGl
M3y7hZYhsSdxuf2SMA1X3n7RoKoZEhN6kS0fRWkYmvPbnyZnSGSy7W68vIcG
1qdsT3nEDQnbOmr9lAQNcb2nyni2GhIi7jo1TlI0nJpnZktnNiTGJMYrp/fT
0EQsh9bNGBCp77yeXjlAQ+3Ud4HL/QaEJYWj5MshGj5sLSGlUw2InWfSCq7K
0fDl27cul0QDYnhV7smsPA2BErdynt00IMycLTPmj9KgquXx5OgRA4Jf+HvK
dVUaysIuhxhwGRCDL4MTF9RoiOgv9Fyd0CeM1Eujf5yk4TO/6jT/Q32CZ/Ek
yVOThmGXjXtDzfWJvoKh8F9aNEy5Kk+SJPQJPX7W4CVdGnhlqCfcavSITT3x
AT4GNMSqRqSevqtH9ARI3102ouFXbtfHmuN6hPacsc9fMxpkXLYbfgvSJU63
PbnCZE9DSU3vlj5tHUJFY7CzyoEGoyvMxkLZ2oRsA8t+VycaijguKg0tniV2
VFp8eXeNBpOco9lPwrSIheyNV2t9aJjnVnKfuHGamBJR7na/RcMSx8VtM6mn
iHfJDtJSd2hw5FiddG87SdBjiK/x92l4m2ndwrXmBJESeP2aVyQNs8U9294o
qxHRzCk90mQaTM/VRcR6qRKhtztkJqMZ33PuQpuLCuHhKTZnmECDW8eRq4pK
isSZSy9dD2Uz8B967M0cGeLHCaXrX2oY/Zw8N7ElnhvTtEsvMutp0Gu2H6ZL
7cCoCvmQBY0GSZ2i7RnuYuiQm/n2rJUGpp+cQ3aOMkjdneye85wG68t/MqRS
laHFyuxh+5EGek9jYlbqGajdlR4Q+MzwB0dmwhPVszjy10zuxQwNKvIVCSfH
tSH8o+wHvtFg3vxaIEZQD78+2Hvu/EuDV3ank/dDQ6Q3071eczdiVUSbYtNv
jiDlDlsb3ka8bjzgF1hhAefSznPTfI04v8v/xLVHFyCX2iP+V7ARKz9MTtxx
sATdd2Bwl3gjBHgDExPYbTB/aEz+snIj5ge1N74Ys4da2uKvn7aN4EjwqmAV
uoqRW+L/8ZQ3InlxS7pa+X+ob/a8+MmuCdTX3xv+JQZBfnr34COHJoT5Nry5
3RqEos0D57SdmqA9LpA9ORuElIuyaqXXmrAw3OHjqh4Mv8VZ0Zs+TTjlyqlv
OhkM1X2OU1yRjKT8sNVhTCIUDWTzG/I1TShuZ85+RX4I+eoNX6bqmrD9+S0h
aepDFI1S7ROJJtQ7nXh8/t1DpOzfZszU2gRJ8mzoTokw+LX1K3b0NoHNX0zD
mxoG1WXt1YuTTTh/qNJn8EU4CBuEBm5uxj+nUlGht5EQD2gO38DTDFKMR9Lj
xUhEZJ0mh29thvPaXyN/NkTB8pNuYsz2ZpzuZ9/we08U/rpYF2bvboax4pa3
SReioOh970WrYjOkzII2mbREIe3R2sEzR5uxSyzfpPV5FNbVhg51H2tGRqdP
Fu+7KAyukD681GjGB4ps7vmfUfAMyPg5qd2MOOYPwxd2k1AW0SzAZtOM20bt
IhdukbC95LTQA7tmsNI23G0PIuHei05RLodmrPW+ashNYuR53oF9fFea8Te3
sgLZJMw9mjgm7tmMzZtEvrJ0kWBc66iR918zXo2o+lx8SULD8JdTMr7N4Cmr
lo0ZISFi109d+TvNuKA6EZo4T8L+7LW2p0KbcX/2nc6/LWREt4U6dDxshuJQ
+TNVQTL+fNp45VxEM3Tv7t5nLkZGhxSfhzGlGYdezSyLMe6njiXiQQ7JjO+F
bbT8p0fG8xd5D6ZTm6EVLkQVMCVD4btM5LWMZgTdpX3msmLcj+UV4r1ymuH6
uCIy1IWM7NrTeUGlzbjWacbeEEjGiUy7LerlzXhRMfZ6Xxgj7z+44/unkqHP
43aDq2QyhMyrtNzqmqEtsfzNOYWMOvX+MimiGQKrn2bEs8gw3zu3fbKxGXsc
fZUrn5ARuyQ+Y9bO4C/ghd+5cjLkxjQMeTsY/foqnjGpJqOv3bK2p6sZy6QQ
7sMNZHDFxT483teMrcWSJ+3aySjwK/u+MtAMvj/bA6s6ydBy6LGgvmrGpR/K
LiO9ZAQdYdsv/a4Zv29qvsl8RcbunaLRn0ab0aj3+rDGWzKaWFX/po83473V
0EjZCBnWX8zsL0w2I74rteXnezJW+z27+Kaasa/Gp5d9koykWpLci+lmDJ2t
/vztExnKmYVJD78241NW8UreNBn/uU+6MH1vhrjy2jryHBl85swva342420d
29HGb2SUq+885rnUjJ+UNRcbv5NhsFcp+8CfZlDHtTkpP8mY33x+4/RKM+y7
Dh+WXyQjYsnNM4upBcc8NtTlLZGxfyzsneWaFgSsCJHmfzP0bs89KcDWggTh
kaR1fxh6F7cU9q9vQWKIwMAcA7PFjW2N4GgBzfUonvwlI8vv721Nrha893w9
dZiRrzQc+D+ycLfghXLg20gGHtORO1fP0wJHy0GRegb2O6JX+R9fCyNXWLfV
MvCOnS5CsgIteKdG7X/IwDWsIUFfBFtwGe5G0gxs9iVz9rFQC2YFxQzTGPWW
+gljG5EWnPayGppg9BNb+7ZBcHcLNGdrfywvM/TOXBQfFG9Bm1h3wThjnr4H
PJFRe1sQXymxMYkxr5v7gUWt/S2gnLIWlmDwwWV+1mrtgRaE3+D4FsDgq0D9
cjtxqAUW7+pDyxh8au0NOOAr14J+Mc6fZQy+pzanxskptKDz44NjgQw9gpZq
/s0qtYC/refq3q8MP4wNXn6i0oIoG5eoVIZ+Te0LvXZoAbvZUvEnhr7WxVyK
QhotMNNe94qZof9qrFTa6xMtOP9WevMswx9HHWzddLRa8Pgs7wcVhp+GdPxe
r9NhYJcVUirDb95HEtSadFuQn6t3e6CfoT9r32aF8y3g/RZ8uILh1/2Z6qXC
1i1oUr15ypDh95pA2ewC2xaYFJmppDH2g6aj2CPFSwy+8t0TWovJsJNee0/P
uQWePo2lj7LJSKii6931aMFOGwMnx0gyJBOqT3D+14Lbw+KrPqFkVNzKU4z3
acEof3CCfQBj/6uHCZf4MZ7v+ebY6kXGui7d+dGQFvT9TXtJtWCcL0VqE1ce
tuCBAatwrBEZoqRDrxfDW3D4ArObjg4ZqsY8tE2UFgze703VUiXDY2wwEskt
aFz5UuUvxDgPflw8kFrK4FP4KWXtaxLcXp0T21fegpJv/tvJPSSsVGNbVWUL
Ci+sz1xuIYH/jsi/ntoWZP9WVrQuJUF3w2TPamsL5kXcvtwNIaFup8s1y6EW
FDV2iysdJEGL6aLt9HALRvau/RrLOJ9fj+sYe4224OiXsrP9/CR8zzmgGjHR
Aq7PtQlTTCRIyX7f2DDbgpXssN8PeqMQd8q3cOeaVtSfcHsw5BAF/y33OpLW
toLcIWPoZxYFl5HgT4LrWxF4fYRlrXYU1LxiRLZvbMUW18b+2oNRmMouieHb
1opuv+f03G+RUF776famfa2I2OwcVLUuEiPNhueYDVsRkHaLWrUxHHvUpecm
MlrBpNbpfj4pBKf6O10TsltxM3883uVGCBwuOc/r5rZC7Cwz3U4rBLmhOd9q
ClvxN11468/FYEj1ifyIorYicuOdI1X6wThox/dbpacVrwY8P5gwBUEl8B9L
zO9W/Dg4oLFPNwBGz17wndRrg6pCplxqzU3YG58U6zJoQ1r3+1FZ55vw+EA9
YHi+DXf9tlDfC9xEzEqqpo15G3okS+gxPr4YPHTN97Z9G+zcHl/wUfaBWQL7
SIV3G05rd7871uwFyyvHs8XT2xDaBGmh39dxbamytDCzDW77t+xzKroOv0Cp
BrnHbWCa4h76YXcdqancrzTy2zBWTmvs63XDWP/oequKNmg8GpmMPO8KW5Vb
LnHP2mCjY+Es9s4ZlzdWHF6/0AZ1i2aZFGdbFFnTMlt/tCH+npxsz4gNfjzt
5AlYbMPlDfJBk4Y28Dcf/77yl7Eu5Pa0X80aKTmbyr+va8cp4X7j8bMXMKDu
LDe6sx0GvF6FJFUjCMZ4ZiUJt+NwWKvZ9lOGsJ26y2su1o4Nr+2PN+gaYD4i
7seAZDvmilN+OjvpgWO4pbzjcDtsuqRvdF49Aw2vXUcqz7TjnM6WLfmL8gh9
JpV9Q7sdDw5/ca7OOoznO+S3HtJtx68/a6kHLA7iYrP2z3yjdtQ1y7HyPBOD
92bfinSrdswfeSDaXsBKEHaBe6xs2zF2Si3C2JWPYKuKitlxqR0leBR156AI
EX0xxzPOuR0uJUdHuj/uJ4rzBo6Ee7aD/6aiy8NSJeLXymi2lnc7FkRuczdc
ViFU9Ge2rr/ZDv2DK55PeUB0LDL/8r/bDrJ0e7SpuAbx8cSBSu+HjP70g3wb
hU8TO0ZD5e3T2xH7VexGBbseYSDtLPs9sx2vQ0OSxQP1iNCbWjL+j9th9iO9
7+CKHvFrG4d4Wn47tI1EeTg/6hO9emFbhyvaoSeROUUkGBJsqS7cV6jt+L59
ye4tsxGh8lV743JNO64IWRsHOxgRuaEb1/LTGO97xRuHSZ4n/Jsifhh2tGNY
7wexP9KYoG52nR/vasf6/H1zhePGxJyl7pfrve1QNxlgrjpsQlz4s2kicoDB
f1tu8IUeE4J8Zn5U6FU70gS+vPy1zZSgxz1/W/imHYOjvfW8VqbEETlSf+dI
O1g+5mx+NWlKuPhf7zV/347rlU+NffaYERnP9Ts/f2hH5vbILwm2ZgTX1S3N
6z63g0J8qDd5aUacqF1oiJ1pR3eUx8A8uzlxc0N/zZ7ZdszysX5jVTUnprIp
Zce/t+Oh7bmFR0nmhNCPG0V9P9sRRBUu46ebE+c1jPJsltphMSEsw/XNnAiL
kns8v9wOhaIhQ59tFkTTCG/GnZV2aI282Wx21IJY2v8zmYuJjg8qeQYFFywI
mZsvHyWz0AHyKzb3mxaE/bOKmP1r6Uh8/HX7kzgLInFbLKl2HR1qGt639Eot
iL5LXuFa7HRYSa8RuEy3INaXG4e+4aTjwMHtIzPDFoQqi0Kg4yY6FrecqX43
a0F46G27t8hNh2nYkYKjqxZEXsrirSBeOn4327aycVwg3n955b11Gx1yfz22
qW29QPAfpXpkCTDqNxZLTu24QJwLjXc7vIMOWprxnX8iF4j7r7xdmoToUBUv
TA/afYGo3WPmqC9CR97Ir61+DLxwQ8l+TIyOOOP/bD8ynpdsErB2FacjZbv7
Rhrje5ably1WJekwqpJK5mDUi7YcMgnfR8e56om4Z+wXiI6CGsMdMnSIFX4I
WF6xIJj/JOjmH6TDZteVTymMeRTP3DyrfJiOzKQGzSrGvNfiLE4/O0JHUKmI
zAkGH1mTR4+bKtKRMP1q5ykGX0OHd+CTMh0eA7tT6hl8bvb/q+x1jNHvn7NH
8hl8n34+LL9WjY62L1FOmy5aEOUuyTJiJ+k4ZOXfdIyfsZ5FMcw+TcfeAymf
ehbMiaG3od4SWnTsmdN8/63DnGA669W0T5eO0igb7bkb5gTF3+VToT4daxKH
ajpOmBPiNbacB43oGPu4tKjEY05o79U1ljOjoy766OuXuWbEqPXJm5UWdPjt
uuK9xs2McI8/mqZoSYfeMeP3bXJmRPw6yWkVOzpyAjzXcVeZEh8mmfxOXqVj
7V6X27QUE8Jr52JGuysdKg0t9DwDE2L9+a/tZ9zpUPTwTD/IakLItLzhPvcf
HX1uR0X5rI0J34yybON7dCz/HPHw/WNEbBzK7XgdQMe717dVbyQZEWncqXPm
QQw/KktPbD1qRLTdfahk9ZCOGzkCM1bXDYktVvbdl2Po2OxRtKzYpE9kx5ov
fI5jrFOMqWV6+oRij942lwQ6Dka2p00M6xGWx47ZuKXSoR9Dk50f1iWeCPL9
9H5CR4jchM+ur2cJtdftOx7U03G4wb9/t+Jxon9TgzonjY4/waHvOzZqEA6n
yx0imugYv7fm7vZRNSKsMq2E3M7ot32Lb+hnFeJ1tM+JxBd0JHHOJz54I0u4
6u9zKZikQ1jzSeTHSjYo6lb/sJ9i4EsffqoQ28Cic/r2zhk64ncKmOnsFkW0
pl1ExDxjf1C3VkVNyqAGiSVufxj9/Vq4fChDBWwyHD/luJ+hQNn7mbyxNlLY
Z27XqzzD5oxjCw9oF+G43ofNC89wPfPPKfsOSxxiWxcpo/EMS56a17gHrdDC
LJaWevoZ2Lulnjr9tsb0knnTPYNnIEgmBRXCdjjyqYPtlOMzuFf94D0bdxld
zXmRPZRnyAgaPe8Z6obAuo1ZprHPEG08azPU5wbVCjfqePwzyL4rE7+34zpK
Hsu//5X8DBEscvsjS64jOrRJdlfuM1DNF+3C3rrjgu7QS9e6Z5DODb66VsUT
X4Y27OCeZKy3DIg1CPmCc8Ex11C+AxE/jvXf5vHH3xI7YV6lDuzW5A7ggD9m
XC3jB452gJ19dJLk7I+Or4Yh59U74BOs+iSw0R8hn1UdTbQ78FR6xPH7tQCw
vueVtLDtAI+e+JBS+32s9NJybCM6EHaQ4zeLYzC+RNTuEiN1wLXn4OgeUjCG
dSrjPlA6oF6xhixZE4y6zvxg+0cdOPCR0OvgCIFve+xlh6wOBGjtfHilMAS/
GlwknGs68F/5CWrw51DMFvLnXP/YAc1WdsFjamFQNt6ruedzB/4a47GRXRiC
VpU+v57pQMJXiptCUBiEdC32qX3rgNpUEOeFzjCcm08u5vrbgS11IYrchuEo
lhWj5nN3grlrdKTUJAJ/hw6bWfF2wljj23+K/0VAM+DE8pZtnZhNybW6FxvB
uO9cUvHd0Ql5nfo5k4EIbPbMpWlKdOKYjsuH9TqRcKuSfjap0gn2PAk9JoEo
1FmpOj9CJzi9XUMqxKOwfr0uh45GJ4Lr3Umn5aKQZuqmU366E6u9a5mYdaPw
4nfZC3+DTlzfUaHQ5B8FWRXFoV2Onbi/UeOb/oco+E1o3ux37sQe3Rmv6tko
dISZ7Qi+2olTlA7f5d9RsH3naznr3olE6WtH128mgexXP153uxONP4SMdJQZ
92maxowZpRMGQi/uGQaTIGMvyT8a04n0ey8MsyJJcF7HddI+vhMPeNVZX8SR
MK7zJuVacieGTkrZ1eeQ8HzI1SAgpxPdwRX971pJ4PQ7f2d9XifqfDRdN3ST
oClytCC8oBMxjntHNg2QQFxmY4sv7YSc4qupgvckFP1Iqi6o7YTv7fnYPX9I
mI7z/3iooRPrjjCX7WEmY89RR54qGqPeqB0b0zpGPr93+GpjayfC2UW4jm8h
4/VugYRT9E6whvxNyN9GBi99ta2zoxPfv+/jnd1BxkOuDuHB3k5cIof4MUmQ
0VZarGPR14l7TfJnnu8jg+V8jO/YQCdODis/9TlIhm+i9cD0G8b77af4zZQY
eVtyMfjfh06IW97k0DzDyNedw+X3P3aivfpjxbg2GaPXmt5v+NyJKz/zLxnr
kWFcEX6Ud7YTP9adCqEbk0E2veH4aJ6h33DiQJsZGT1/TGOEvndCNEznTfIF
Mk5q7J6TXOqEnndbw0sbMu5ObthRtMzot4zLR96ejLqQOc3DK50YaSpPcXVg
5O19Lz2p/zphxxO5454jI1/31mQcY+nCsvrcR2fn/+fptN4m1i6MuM+s7nch
I39r0N/T67pg4Nfn0H6VjI/UK3u7N3QhQeW7sLIrI/9d0Dc24GS8H5h0INCN
DMt/8gGvuLpQIbszJvc6GY8ydpRc4O4Cl2CLYZY7GQMnWd695+nCmW1jV71v
kLH586cNl/m6kPePmNztQYZ2WLf8F/4ueBSU1T9h4JADT+2uC3Zh+ifbEpsn
GS198VG/dnZBv5wjToWB/3n61d8U7sIMsSlZi4GVBeynmcS68HfehvMQA3vV
ndkWtKcL7bv0P80xvldmdeAEh2QXSLv3Hwxm4FmWrdejpLqQ9Er98y9GP1KP
l5O3SndhP/d7XjDwpTNjHQkHunD/iWmFFaP/tC+ti7tku/DZe7HLlDHfcGT+
7my5LiSbcFpKMeY/91uywlqhC/Tfi/SKa2TQbB+f3KHMqHeVr3ELgz/ZLrHB
VypdeD9jekb9CsMPR9IdKOhCemGJvboTGXypQovnNLpQO8PFx3OZMf/6pGD2
k13YNmpvXcnQ8+rb2Nx7Wl1QflbXed2KjLETvErHdLrQfyh9IZThB4Mi0rMl
3S4YHdZouMHwi/y9sGnX810onvDTrTMgI3d6w819pl24wLayXVCXjO1GwRyf
zLvguSIed/YsGavi/vstrbsgqXN6SuQ4ww9R/+oE7LqQopy/1M7I8+O/b+m8
vNSFBjk5ETVlMtq7/rumfaULTZ9vHc5h+F9Z/ufqumtdWO+eZhbL2B8Fqe6R
zW5dINJLNpuKkxHlfrVE2asLx8mWeYaCjP0zPK32y7sL7sLWz8K3kuFx0vFF
6c0uDM5vXUjYRIYpv92C5L0urP1+6Y3MGjJEGkzltoV1wZLKqaM2RUK0xGBL
XwSDf8qedXyM84CNZHg+gtSF1I/36og3jPPA7pzX2rguPInoIkV2kFC24QT1
e3oX1EV3ye3OI2H3jUbN4qwuzP6ib01OJyF2WPWNc04XJr1PTkzHk3CzWGn5
fUEXfHf50dYyzrcT5w+oPK/qwo245fajNiRUNhR0PazpQubnldtWJiRISkpd
PF3fhev2UqfNdBjn2Z/dfg1NXfj30H2uV5GEl2nbaQXdjP2R/zmldyMJDl/W
ngj9wNDXo7lMsyQKdD1Ta76PXRC00uWrzYqCVEXercypLhwsuP2F41EUvt7W
raj/2gXFoN1ZZ+5FwWPTI/GFxS5s/KonqawXBX/Z/RssOLtxQiMrQPp5JJK9
DXr2H+lGIZ9/njxLBFaHs6arFbrxqmGrnOeHcFirL7KdVu7GybCOmdst4djN
ngQbdEOoYrBvLjAceYmTJTFnunGQ+/BfW7ZwUBu8KasXu/H1fkf6wspDDLCm
mj4P6kbQtSFp6c5QkA3WpeiFdiN/E6+8VU4o9NJcPzx/2I35CWb3qwGh6D6q
du1FVDfYUv4rET4aijb39wF9Cd0476zk/S03BNQxseKBom7YOQZXVvgFI6ku
d+2bwW5MpH4oj+cLxCWPsrL34j34YLnxCAf/XZiHlFnE7+3B7n/+A5TXd3Au
qYxVd38PbETFH/PcuwPFljLjukM9UFnaEizc5wdO3qfLsSo90D6r9t8jj9so
e/pUQ9ugB7kvy3vM6nyxulDeV3m7B+uLrTQzbDzxna3i5tW7PViSNr1nutET
U9srdu8O6IHpI/8w9WoPvNCo8CKFMPD+nbWl3B7IIldsd6H0QLXQy/9Qqzu0
ZCttRZ70INBVnOWTghvirlctPBzoQdmhHO7X+Q64dTdMgvdVD0ZnFrdf2eUA
60ibC0lvGPWtN8plUS5BspCjrWCkB7d2BM9x+9mjZsrqUfdUDyLL7k/wWNhi
2Gq92qaVHjwxlbpUfe0CaNfeecT968Fn8/kBfxcLZN8ue7KLpRff3hmwvbpi
jmuJF3gOruvF5qy4LzKupvg3WPJRj7sXbgPtt9eFGkH0nFk4eU8vzF7/67UV
0ALbRZmm7ZK9cBRkoYyd0cTMlTWLGVK9OKce2fP19imUhxZaPz3QC3pJyv6X
8xo42cosN6DUCyahuIu2axXhqJI3tPVcL2jpT+o05VkI7bN3NqXo9UJPvylE
oWIrcdDc6IS4YS/4d7zQ7N0mQvz+b7VQ3rQX3skxapa20sSDpwb3TGx74fd7
l/P7BGWiUOqPxCOvXpAddntUuWkSklME4eLTi+mXL5N5Pp8hMrLvm6jd6oVy
zrp1Wy+cJWKFuYI/3etFQ4po7edD5wg/PpGPR8J7URNp+py1R59Y6p+8vSGq
F8JubpZWHgaEOylv6ztyL+SK/YpntxkSlznlTt6P74W5tUBBkrERocdyOqsv
sxfWH5RedZcaEx0Eh8rjx72IpyjPOKmbECduP+/3edKLv2Eve0V7TAjFJbM1
IsW9qPy07eX4iCkhMuti61rTiy88t01s35kTSfmHljXqexE1sfpf/nkLgs/p
F4mP1ov122JXmDotCPaJO431rYz6MhoszwoY+fgNWZjzRS8cVuBD0bYkXOJM
qKP9vSgsF9RiK7QkPhrt0Hs62Ivmj8G8nuxWxFBv9h3z4V60n9a1Vq2zIozC
nbfJjPbCI8XeTmu9NdGjdaCYebwX6Ukh3nMHrYnmVupI7qde1IlmSmfetiZU
A2573ZruxfbfP6eL060JqpoGl97XXlioqiofbrEmGHevY4sLvVCl3lBPYrUh
xH2iXnb87MVe1WaDe6I2RJr8+aspS72IedmV+1bVhoguHUk6udoL/7d9L2fd
bYjgKv2EMKbnOJt4iC3ngQ1xgk/O4Rfzc0hs2iTTn2ZDMHvyyVqveY4aqx3L
7hU2REP/0soz1ufIqWDfFkS3IW7Kvn12mO05YpQeHuIcsiEUSfUxyeueQ5xX
9xfrtA3xcy7VZt2G5/h3dd0WtyUbouycv/R19udocb10SGetLeFaaP+/AH0A
gv/52gvQPxtCGgGcEGK/LAxHxUQN0D+mDdctXBpiv+lqKZGuDtA/C/tMZI0i
Yr+myQtdGBDQP+0yLVEvKWK/YyjuKIIR0D/x3SihQS5ivyCH0PTrEtA/vCTx
AMQxYr/e5bLAVRTQP/MvNx22M2K/m0SVjL8V0D82KKyiFzRiv5kwC5c=
       "]]},
     Annotation[#, "Charting`Private`Tag$209826#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUV3c81e8Xl2+UkjLTUlJCUklJ6y1RkpWQrESEZIWQJA0rZGTvvd2Le63L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       "]]},
     Annotation[#, "Charting`Private`Tag$209826#1"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUm3k8VO8XxyVEKZFoUZKtIlsLSR0paZGQfV9aJKUoXwqVJUuyJbJk3/dl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       "]]},
     Annotation[#, "Charting`Private`Tag$209826#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.711123596550798*^9, 3.7111236188592873`*^9}, {
   3.7111236626690693`*^9, 3.711123666220736*^9}, 
   3.711123732295664*^9},ExpressionUUID->"55cde38e-9fba-4e4b-b9e6-\
d55537c27298"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"gtest", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Text", "[", " ", 
     RowBox[{"\"\<Frequency\>\"", ",", "Bottom"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"fd04b1da-d92a-462e-8e00-8c16f51b8d51"]
}, Closed]],

Cell[CellGroupData[{

Cell["Gain and phase angle for low pass filter", "Subsection",
 CellChangeTimes->{{3.711282902819522*^9, 3.711282947980447*^9}, {
  3.71128302875941*^9, 
  3.711283030931107*^9}},ExpressionUUID->"5aa0f14a-bbf0-4599-8d7c-\
4308048fea90"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"I", " ", "w"}], " ", "+", "a"}], ")"}]}], "]"}], "\[Equal]", 
     RowBox[{"a", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"w", "^", "2"}], "+", 
        RowBox[{"a", "^", "2"}]}], "]"}]}]}], ")"}], "/.", 
   RowBox[{"a", "\[Rule]", "3"}]}], "/.", 
  RowBox[{"w", "\[Rule]", "7"}]}]], "Input",
 CellChangeTimes->{{3.711202663099886*^9, 3.711202680488488*^9}, {
  3.711202711298686*^9, 
  3.711202772142417*^9}},ExpressionUUID->"f874c98b-2bd7-4ecb-ac0b-\
32507918f69f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.711202680985465*^9, {3.7112027299447412`*^9, 
   3.7112027725042973`*^9}},ExpressionUUID->"1f8f1367-b5eb-421d-bf1d-\
257d9ad54dfb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Im", "[", 
       RowBox[{"a", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"I", " ", "w"}], " ", "+", "a"}], ")"}]}], "]"}], "/", 
      RowBox[{"Re", "[", 
       RowBox[{"a", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"I", " ", "w"}], " ", "+", " ", "a"}], ")"}]}], "]"}]}], 
     "]"}], "/.", 
    RowBox[{"a", "\[Rule]", " ", "3"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"w", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7112035669455843`*^9, 3.711203581557145*^9}, {
   3.711203833246616*^9, 3.711203873111609*^9}, {3.711203937547632*^9, 
   3.7112039962241077`*^9}, {3.711204072485697*^9, 3.711204115027852*^9}, {
   3.711204211789719*^9, 3.71120421204957*^9}, {3.7112046313526297`*^9, 
   3.711204668881344*^9}, 
   3.711282964180402*^9},ExpressionUUID->"6e546f7c-a8ce-49d8-80f7-\
45b482d25519"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcTan", "[", 
   FractionBox["w", "3"], "]"}]}]], "Output",
 CellChangeTimes->{
  3.711203583044154*^9, {3.711203855321372*^9, 3.7112038736593733`*^9}, {
   3.711203944697657*^9, 3.711204003594089*^9}, {3.711204074051339*^9, 
   3.711204115490966*^9}, 3.711204212471735*^9, {3.7112046460490723`*^9, 
   3.711204669271245*^9}, {3.7112829646414757`*^9, 
   3.71128298813278*^9}},ExpressionUUID->"ef41601b-bbe6-423a-8802-\
959a768428bd"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Open loop control", "Section",
 CellChangeTimes->{{3.709200445352656*^9, 3.7092004504509706`*^9}, {
   3.70923376997762*^9, 3.709233772027843*^9}, {3.7106009847274103`*^9, 
   3.710600993211993*^9}, {3.710601089465126*^9, 3.710601096556562*^9}, {
   3.710667147354513*^9, 3.710667150591134*^9}, {3.7106673296156797`*^9, 
   3.710667332031584*^9}, {3.711297480015491*^9, 3.711297482986656*^9}, 
   3.711297882543729*^9, 
   3.71130168085322*^9},ExpressionUUID->"71add0e6-5436-4648-931c-\
dc7da12611f8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "[", 
   RowBox[{"\[Omega]_", ",", "\[Omega]\[Epsilon]_"}], "]"}], ":=", 
  RowBox[{"TF", "[", 
   RowBox[{
    FractionBox["\[Omega]\[Epsilon]", "\[Omega]"], 
    FractionBox[
     SuperscriptBox["\[Omega]", "3"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"s", "+", "\[Omega]"}], ")"}], "3"]], 
    FractionBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["s", "2"], "+", 
       SuperscriptBox["\[Omega]", "2"]}], ")"}], "\[Omega]"], 
    FractionBox["\[Omega]\[Epsilon]", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["s", "2"], "+", 
       SuperscriptBox["\[Omega]\[Epsilon]", "2"]}], ")"}]]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"L", "[", 
      RowBox[{"\[Omega]", ",", "\[Omega]\[Epsilon]"}], "]"}], "[", "0", "]"}],
     "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"gout", "=", 
  RowBox[{"BodePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TF", "[", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"s", " ", "+", "1"}], ")"}]}], ")"}], "^", "3"}], ")"}], 
       "]"}], ",", 
      RowBox[{"L", "[", 
       RowBox[{"1", ",", "1.2"}], "]"}]}], "}"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Gain\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Frequency\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Phase\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}], "}"}]}], 
      "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"gdir", "<>", "\"\<openL.pdf\>\""}], ",", "gout"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7113121888264236`*^9, 3.711312241551609*^9}, {
   3.711312289245266*^9, 3.711312297901599*^9}, {3.711312333105245*^9, 
   3.711312432806675*^9}, 3.711312479771722*^9, {3.711312510305656*^9, 
   3.711312549439575*^9}, 3.711312585342309*^9, {3.71131283708423*^9, 
   3.711312920234918*^9}, 3.7113129681251802`*^9, {3.711313082613194*^9, 
   3.711313100480459*^9}, {3.711313159870564*^9, 3.711313164632004*^9}, {
   3.711313268451531*^9, 3.711313295308016*^9}, {3.711313349060639*^9, 
   3.71131336891398*^9}, {3.7113134529545383`*^9, 3.711313453615863*^9}, {
   3.711313534148478*^9, 3.7113136213777447`*^9}, {3.7113136585469093`*^9, 
   3.711313670289928*^9}, {3.7113175900996027`*^9, 3.711318009756777*^9}, {
   3.711318048128912*^9, 3.711318054349704*^9}, {3.711363231105651*^9, 
   3.7113632440320187`*^9}, {3.711363284386177*^9, 3.7113633077355328`*^9}, {
   3.711363536115343*^9, 3.7113636666586533`*^9}, {3.711363702555563*^9, 
   3.711363707159842*^9}, {3.7113639313991623`*^9, 3.711364043362117*^9}, {
   3.711364090319903*^9, 3.7113641075902023`*^9}, {3.7131865930349483`*^9, 
   3.713186607020206*^9}},ExpressionUUID->"da47b2e2-bffc-49a2-96d9-\
87d5cf194ba4"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.711312527823195*^9, 3.711312550266424*^9}, 
   3.711312585922565*^9, {3.71131283774142*^9, 3.711312926747439*^9}, 
   3.711312968620933*^9, 3.7113131114507027`*^9, {3.7113131604947166`*^9, 
   3.711313165501258*^9}, {3.7113132701466722`*^9, 3.711313296021297*^9}, {
   3.7113133496416273`*^9, 3.711313376011181*^9}, 3.711313455737577*^9, {
   3.7113135621798687`*^9, 3.711313621928137*^9}, {3.711313659618573*^9, 
   3.7113136708390408`*^9}, {3.7113175975240793`*^9, 3.711318010472488*^9}, {
   3.711318049165604*^9, 3.711318055226829*^9}, {3.711363235561304*^9, 
   3.71136324453237*^9}, {3.711363286425577*^9, 3.711363308116662*^9}, 
   3.711363556980502*^9, {3.711363587008951*^9, 3.7113636189142313`*^9}, 
   3.711363710708521*^9, {3.7113639332113523`*^9, 3.7113639387180357`*^9}, {
   3.711363968770091*^9, 3.711364011961711*^9}, 3.711364045809022*^9, 
   3.711364109703491*^9},ExpressionUUID->"1b7cc4b1-7f2e-4c68-b401-\
c6574bc5f4cd"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVlnk01P0Xx5EklEilpJCKngqRaPGtCFEiY2lRlkJUSkU9qSSpJEIp6SkP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           "]]},
         Annotation[#, "Charting`Private`Tag$2324967#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVV3c4F/4TtyMkUkYIIaSQURHvj9UwosxEWUWIjK8oyk6SETJDQiHZI8m9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           "]]},
         Annotation[#, "Charting`Private`Tag$2324967#2"]& ]}, {}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1.3010299956639813`, -82.83527111720944},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{
         FormBox[
          StyleBox["\"Gain\"", FontSize -> 12, StripOnInput -> False], 
          TraditionalForm], None}, {None, None}},
      FrameTicks->{{{{-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-75., 
           FormBox[
            RowBox[{"-", "75"}], TraditionalForm]}, {-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {-25., 
           FormBox[
            RowBox[{"-", "25"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {25., 
           FormBox["25", TraditionalForm]}, {50., 
           FormBox["50", TraditionalForm]}, {75., 
           FormBox["75", TraditionalForm]}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-95., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-85., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-12.995086200282394`, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-100., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-75., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-25., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {25., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {75., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-100., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-95., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-85., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1.3010299956639813`, 
       1.380211241711606}, {-82.83527111720944, 56.84509871664466}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {-75., 
          FormBox[
           RowBox[{"-", "75"}], TraditionalForm]}, {-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {-25., 
          FormBox[
           RowBox[{"-", "25"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {25., 
          FormBox["25", TraditionalForm]}, {50., 
          FormBox["50", TraditionalForm]}, {75., 
          FormBox["75", TraditionalForm]}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-95., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-90., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-85., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-12.995086200282394`, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV0Xs01HkYBnARhWrosrVFa7Du58xUOrnEV0kppZRbpVxnjJmYXzkRSbGK
kqihsiQJM6VJe6wuKt9XptUSFVEaYVxHcp/f5FLa3/7xnud8/nue89KD+HtZ
qioqKruo+z9/Xot+OfedAq99VntPaEWHhiUj8cX1Chwpn+89ZU2HvHS2jWut
AgelhajtdqCDY7JXSWq1Ar89bHhMw50OcVHrLi9+qMCfJPeai/h0mPQc8TPI
UeB4h8uhojI6jOuGKuxZCjyecT+21tEQelK9jSKnJvCg1OHsRKARVPZGXcW0
CXzyfa513QoToB3eUJ6yfhzH55Usz580A+9H9QXZ/mPYGZ/ZZGBiBYKooqKU
6FE8PrralKfBhDSRnUjuMIJlNj5psmVroYMhZsRxhrCPKFZX64Y16MfUed7M
GcROtP4EVsQG2P7T/N3ToQEsbBQouCw7CPDQPpG5So7NnXKFkeqOENJpFcXm
9GGRFNPyvjiB15pp3VfPe3DCXlp77BxnWOO+42PvcBeOXrlbbJXqAtPCT+R3
RxkONFucq8Z0hcM50pP5ze3YMKXNNjjADW5x929jO0rx0eTEEpdP7oDLfKpW
937ALaWM7ClrDyjLPJix2/k9XnKn2+Lgnn2QMNKxMLLjLc7oz3kzQ3iBm6QJ
9Nm1OPe+1XO53Ae2/XW1TcCoxrf/Nh6xjz0Ao0bld9sHHmOdGt/Sgik/8Dxf
3DlUWIhNXtzZr/PCH85ls84wwy6g498j1IRrAqE4Z5HRVtEDZM78sPKP2CCo
Np6WJf2OUb++UF/wMRjsu49Gxnn9g1xfaLzav5QFnCRpncudepRlkY+CDrBh
bFGdNye8Ea3yb/q35lwoNMlMf7V/1YzcIpx0jqdyoEPv9LksXiuqEnB/qUsP
A912L5cfb9vQ5+E2zfxwLpSncXsKFneiqp1XOXnreBAdIJzRkskQow83ZpA8
cFPefhqT0Y2MeYaqC68fAeqDHlYhvSi7bFievD4cmLt80ntX9KP6hzaP4h+H
A1rRy6C9lKNMqXmphWUEBC8fLYrL+oJm6TcSRNkR8GdrhWR061ekYnvtijYZ
AX1vVJ+I9IaRmJNZKNzJB5e5N2nvBkbQZqOUxIDrfJCeOjVP5fUoEiWfv9La
woe8JV+O2paPoSrbH92+mgQMXnjIVF4aR5Oz7I2zdAI20cUGvJAJlCgUv+Zt
IKDAI2hmzk4FGgivUCfdCLgYHG2hZ0yizJu7iM9+BJhNrFwlMyWRVjEONj5E
gCSxUrvYkkTHBwaZPMozt9SHGOtI5DQm8Z2kzO0UlDpvJtG0TVmnjj8Broce
WPMCSFQjZnTbBRIw12fAsSKXRElvvjtEsgjI77vIOJ1PIneHS+nllDdGMQ22
FJJo1tPz+TfKkVnRcxpKSHTEsE58kk1AV5O6RFZBIm1OTE9CKAGwx3C7ZiuJ
Gq6HPUkOI8Cv86VtQxuJopotP9RQnuSHWQg6SWRauadxHpcARvoDbX05iTye
LQhMppxX79jA/EYiftjeriQeAXaHuirJaaqPK2OomnLL17OlFbPUHjPVFtUj
BCxaUJ+xRUOJ7nc3bjpD+W4OkaCppUSvfyMllZS3Wi491rBQifrp3iY/KHdV
PAoS6CqRjdp8tn04Aad2HNznu0yJTjTpJcVQ/g8n7I7A
           "]]},
         Annotation[#, "Charting`Private`Tag$2325660#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1Xk01P0XB3BrC0JptT0mouR5RkWRZj5fy0iUUrbK8mXswkhJyJZKi1Io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           "]]},
         Annotation[#, "Charting`Private`Tag$2325660#2"]& ]}, {}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1.3010299956639813`, -262.84216700802017`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{
         FormBox[
          StyleBox["\"Phase\"", FontSize -> 12, StripOnInput -> False], 
          TraditionalForm], None}, {
         FormBox[
          StyleBox["\"Frequency\"", FontSize -> 12, StripOnInput -> False], 
          TraditionalForm], None}},
      FrameTicks->{{{{-300., 
           FormBox[
            RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {100., 
           FormBox["100", TraditionalForm]}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-108.96296434254869`, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-300., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-200., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-100., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {100., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-300., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {100., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            InterpretationBox[
             StyleBox[
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1.3010299956639813`, 
       1.380211241711606}, {-262.84216700802017`, 44.916238322922794`}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-300., 
          FormBox[
           RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {100., 
          FormBox["100", TraditionalForm]}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-280., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-260., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-240., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-220., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-108.96296434254869`, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.711312527823195*^9, 3.711312550266424*^9}, 
   3.711312585922565*^9, {3.71131283774142*^9, 3.711312926747439*^9}, 
   3.711312968620933*^9, 3.7113131114507027`*^9, {3.7113131604947166`*^9, 
   3.711313165501258*^9}, {3.7113132701466722`*^9, 3.711313296021297*^9}, {
   3.7113133496416273`*^9, 3.711313376011181*^9}, 3.711313455737577*^9, {
   3.7113135621798687`*^9, 3.711313621928137*^9}, {3.711313659618573*^9, 
   3.7113136708390408`*^9}, {3.7113175975240793`*^9, 3.711318010472488*^9}, {
   3.711318049165604*^9, 3.711318055226829*^9}, {3.711363235561304*^9, 
   3.71136324453237*^9}, {3.711363286425577*^9, 3.711363308116662*^9}, 
   3.711363556980502*^9, {3.711363587008951*^9, 3.7113636189142313`*^9}, 
   3.711363710708521*^9, {3.7113639332113523`*^9, 3.7113639387180357`*^9}, {
   3.711363968770091*^9, 3.711364011961711*^9}, 3.711364045809022*^9, 
   3.711364110092854*^9},ExpressionUUID->"d8413ff7-a28f-4d19-8cb7-\
2102e4555e47"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Feedback control", "Section",
 CellChangeTimes->{{3.709200445352656*^9, 3.7092004504509706`*^9}, {
   3.70923376997762*^9, 3.709233772027843*^9}, {3.7106009847274103`*^9, 
   3.710600993211993*^9}, {3.710601089465126*^9, 3.710601096556562*^9}, {
   3.710667147354513*^9, 3.710667150591134*^9}, {3.7106673296156797`*^9, 
   3.710667332031584*^9}, {3.711297480015491*^9, 3.711297482986656*^9}, 
   3.711297882543729*^9, {3.71130168085322*^9, 
   3.711301689741878*^9}},ExpressionUUID->"ba990ec6-7e44-4bbf-870c-\
55774894e54e"],

Cell[CellGroupData[{

Cell["PID control of exponential cascade", "Subsection",
 CellChangeTimes->{{3.711630691810279*^9, 
  3.7116307072158823`*^9}},ExpressionUUID->"4747cfa8-a918-4e7f-bd75-\
bb2c607abc45"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tf", "=", 
   RowBox[{"TF", "[", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"s", "+", ".1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"s", "+", "10"}], ")"}]}], ")"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tfalt", "=", 
   RowBox[{"TF", "[", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"s", "+", ".01"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"s", "+", "100"}], ")"}]}], ")"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"BodePlot", "[", 
  RowBox[{"{", 
   RowBox[{"tf", ",", "tfalt"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.711709439038176*^9, 3.7117094549084053`*^9}, {
  3.71170949229515*^9, 3.7117095299229183`*^9}, {3.711709707829423*^9, 
  3.711709719285911*^9}},ExpressionUUID->"462317c2-a2b4-4b7e-809a-\
b658ab4dd5fb"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwtmHk0FI7Xxsfso6ylVEMiFJK1lJgRSSglsqb5SpNEKoRKIaVos1MqCmUr
SgvRvSFbRcgSQihCsq8z/HrPef+65/nnPuee89xzP+eucfa0PEIkEAimAgTC
/9WYU/M2wa6C+Oa+51TPGSbYP1MDRxdBjMpvbFj3lgnSf5wVNnME8Z7mkeOi
BClIcy0fH7ARxK5wya4v4VLw6tDtCOudgtgzBc3bM6Whebfsx3UKgshJGFDM
vCwDieFWGiRZQcyUUZkzzZYBTuWVhO9SgnjANbxhV4MM/DYaOBopIYjkAUd1
V4U1MKubR+aRBVFn/MsM+/MaYCoZ69d0M3DZhYS32qpy0HnULzW9g4EiAZwU
bUc5SEnNWBzSysDXiXrtj8LkYMMakVadegbKXew/VtMnB/qSzb4PixmYLsL3
CMxYCxyqW65PMgM9Z0IoLCMFSOm6sZZ5iIHan6I+u3xbD8UONPY9ewYqDFOu
JTGV4MfXQAfpAwyU72uXDecogXS5V6TMbgZWzdwU8+5XgvhMO4K8LgMdJ0lQ
TlWBcG/5tg3LGRjk12cudVgVMv7cn3oqzsDF8eYRCs9VoYIruURNmIGJBSe5
fIGNQLZbZKpBYeCKv/2yzJSNcEFv5PWmMTq2HcttVfFXg9PUoihWDR1L51/q
H25Th9sXNz3DKjqeUw1vbhLUgGfTz6oMyuj4Izdyx4ctGjDY/1DAqIiOj2xs
LoskaAC35qqnSSYdZV8s+xByUBPs463M9oXS0UvU/8KyBS0wUBokHmbR0dEY
x58/1QHu+iFnNV06evu4bXrQrwPX1w0X8zfR8Zpn/TBTcQs0K4wHx6vS0elW
vk1d8hY4IccjVkvR8UnuzH/m97dCInMxaQuPhkuDn/qW5m2D4lXCh6nTNPyR
983OZ3Yb9K0ULakfo6GuaZVbDVsPNFcsvXRigIbRu66FXq7RgyoJJimlhYYE
jRs3FSf0YVpYhSSST0N/bVLcoVw2SAurHm7Lo6FCRIHsr29sMBJSK0nPoSEr
+5hIDdEAbi3SumT0hIYyDOnKj9YGoEDfRjobR8O2iO7j4YTtYCVgTvrpQ8Nz
Y48TCG6GkDN2nPRWg4YzjCbpjdHGsOdlp+89VRouTmKN9Vcaw+AZ68GLSjQM
1QhIVSDshHWz+g1GsjRUrt14VPbETkgiiD+uFqOhfbGt3e69JnBb6I1p1zAV
g03OuoepmoJqjQqUDlLxw8YFyW/upvDpdrLm4z4qVrSYMQozTYG+NJzp3knF
AKq/rpGyGQSudBqaqKEi4w3N7LK6OZxUJEcynlHRRVrRXdRxDwj/9qMOZlDx
TnyO2N6UPZCV8edsdRoVM1tSknX/7IG+DU2Ho+5TUS32Wh8zyAI4WhnaUjep
OG8b1XHHdi/sNdj7Tc2Dih0U5zNSd/bBRodEGVtlKpb2TU3JHLOCdba2u34o
UPGakIxe4z0rkLFeetpNlop/2oYTltRbgajF9ZLzK6j4XVFvlQrLGoa3n+cm
06j4VSnq2pzUAXiu5JjV303BT8af79pP2UCGomSDVwcF6ddqqPratvBw7Vc+
r4WCTeUBuu+9bCFK2txCpI6CjSbpvtmjtuAtvm1UEylIMfvkZDZtB5tmV+kE
JFL+7SvoMdc6gupUE4caT8HEFbYzZe6OoDAede1WFAW9WaMWG145wvKhRa3J
YRR80pByWMvsIEz/mAso86Ngi5u8hfMFJyiobC0RsaagbTYn8eJlDugl3LV4
KETBK7YR3Vrcw7CN2Vnoy6Bg2Vs3yeHof/rBWqXdFAq+03rRtKr0MGxNzSZP
88g4b5qoWSnnAjq5kL97kIwir/48TOhzAa3KbrmZKjJGtaquXnyNC1rm6yKq
y8h42ncqxwq4oFnjPv+omIx3rXVmV09yQaNhonlPARmxyCHJ8MhRUPtBu5mS
TsbFT5Kcuna5gsqM8rTFVTJmPpWsT9rgBirnTx6RDyFjjnzKzFN3N1BeyKub
vUhGk1HRMassN1Ci6Gen+pKxpFJ6+YkNx2Gd2F7nOS4Z2y6+H+Fvcoe1670/
pe0go31Eptgv1xPAtCtM4hPJeH4u6lVc+ik4s9yk2H+ehAkSFcUvm07Bl4b6
7okZEiqOHV1vTj0NlywHFIaGSXjEdsPwL5fT0G+2Mru9nYQq48TAKUUveKPv
lw8FJBxUPe7zpMwbxPmkVt1XJEx6eej0L543uL+9xXudS8LmVQencjV9YLXO
Y1bOExIWGsRyph76wBX1xg9JsSS8f7RrwuXqGdi/Vqsu6DQJe+Z/bpA96QdZ
XTDG9yAh8WwAY+iZH1CTzSTOHiNhf+8KS86wHxRIHbY9zfnn9318XN/LH2SW
R7Y77yGh9relZImgszDEGO43VCKhq+OeE6/fnYewv5kkahcRA1irk173BoLj
yYwtcd+JSP+xZgdtSRCojjzxXPeNiHqXWB8+6AdB3Whqq+kXIq4csiuLiguC
lZMPXtx6R8RjdlJ+UXuCIYMXdXjFXSLKHcQ76+ovwfmAyISMWCLK6sYvGqGE
wJ752zW6kUS85mbhrrslBEYXbug6XSPipLf/RofkENhKurrkkS8Re0WgYcD3
MlQyzpeoWBHRZ51P1mVWKNwJOztTZEHEA1eE6aLnQsF9kf9GCzMimmskZ2m8
DgVRoTN3T20nIs/G7pex+lWwFT3p9UqNiFuVbW80qlyDvmUucmwhIjqhxsG5
7eFAX2t+aX+ZAJZZdZwPnLoFP5Tq+WrFAvghpVCpd81tKFC39xN+J4CVf7/y
XU1ugwfL1aPypQAK9YfmB8behjr7EBtWqgA+95B4ILk5AhIjCpWVQwTwFj/v
SW5YJPjEG6bRAwVwKOl28vCrSNjzoErm1zkBrDrrPxnfHQkC2c0SyV4CmHaX
f2+9fhRwK8YXlh0WwF73zRXc6ShQW1D5StwugP/JFAVsDo4BBjVvT6eeAB7Z
VHnuyssY6FqsW1m0RQCpHxmRFr9jIGblrnd+6gJY8FPtppVlLMxqH3kyJCOA
LmHdi0yV4qDU/d75lgUC6j6m2w6NxoNNi5D88yIC/vl08IHwcCKEMdv2b8on
IPPmjvDOrffgnVNGcEEeAfmdfsZeV+7B2m7jzuJMAp6kf/zZtfo+jA5cvFuf
QMDnByKm1zg+gJv8EbEJHwKKG3tWjvOToJiFbP9TBPRuvO3yfX0yTATd9OS7
E3BpzEbK5gPJ4EhV/kxxIaA5k91mkJMMSiIuV5dZEvDKFRvFxmMPoUymcX6z
KgE1ByQWUcYfwaxzyobC9QQM9NV7Gq6YAhtSTzuy5Qloz/YsjXVIgej1IgUm
TALWqYZEsj6kgLOGiY+dIAGlf90+LvAgFWZDvZsmPi2AX1Xo/AWPx3Cselvu
Ob0F+ENyjO8NzIR2p/44pvYCGP33oVG8JBOs/sZdKFJZgMQ7vB1tlCzQFx0z
W1i1ABFPMm5Z3MiCpZbpv4Jn52Grteq5H4+yARskmGGv52Gu6O6pRSPPYBO3
hKj8bB7avCLl+6RzIHPy5O+PafNglDSjkLYjB2KXf3olFDsPUn7pxjrROeBu
F7wvwnseEvyj5j9p54Lk96Er8erzcLNFeu5C+HO46ZHosWX9PIRc3tZHevMc
SPO7rFpk5v9x4fbPoz3PYUg6dQ1TdB4s3ldwxNkvoJTjUPhgiA+XDjtae8+9
AM+e8pG0TD60cVNWPQl9CWUDSY4v5fmgY5zMOMV/AyoCWu6BUnxQCDYPW6KT
D5HLys+ZSfBBbUZCSN8rH5wM/tz5QeaDnJ/m4MaBfJiM3fJNqIcHlwL1j6X/
KACF7XXW3Ic8yGt7PSDcXwjXbY4cUb/DA6r3vi/lG4pg1H3amxfBAyvfPF2p
00XwLk46OjKIB4GkrvWPeEVw4I9b3TsOD6KTHt7bvgLgcjzJYvlqHkRyA8oY
+Qj92bFOXct4UJdcpCXTibC3ZP2JbGEeOMtcv3ub9h6YQxY3DOfn4L3I5Jlg
m/eQZ5j40fP7HNjqdRbh3HvoGdIyqbg7B6ThB18PHSgBox1cA3/JOWhshS3G
9mXgVBuaHyEyBxphJjufR5aB/8F09QzqHBSY0VvSP5bBU5/BNa3js/DBYPYt
m1UOkmmniXq1sxBaV7lTY0MFDFAvlhDCZuGtIeW6lXwVUKOSdFcEzUJt3hmh
lUerQGZ18Qt1v1mYop1fEpReBVabKSnO3FkQDnscvUXtI7w7Gh5Sun0WguqL
jl/Y8QkiK+J2XJ2bgRNvXr/JvV0NWVb5RUmjM6DiTZXc+b0ayjtbtPN//4MD
8zPUOKUa4E1LKfQ3zcD4eI6RR3kNHFmfQjXPmwEJEUFfsctfQCcsp1zEYwbc
/H5n32uphQ6zyl1x7dNwytug9EbTV6D3zJmaNE7DWOFi8QpaA6idVzWf+TwN
smbRpR46DRCcFbXHoWga4mPyK+fvNICCkNP+1YnTwLz75b3FkUY4UT3q+Nju
X7+7eRE+Is0Qx5V3st03DdM74y5+MW4GnLc5xNg1DaO1LgapF5pBfGPRf8d1
puF5T5II/m2GV7dCuRuXT4PBJoPahqZvML+XefL11ynoWvEh1glbQfH3nlOu
n6YgvLRC5NNCK+wNCjq9onQK1F1CDEtYbfAw95f3uRdTkG4WS9//vg2MxXP9
WZFTkKz+M0Hi43e4Wb/jUrnFFGi7FKlLznaA1AHP2KaqSbgi57lygtsFsy5q
hMb3k7C6oL+tIaoLmr1Gjn19MwkTlrEtzPddEBnhpVebNgn1VwRTO5ndQP/s
21MVPAlGk5J+1t+6YdwwUOPd1km47i676DH3J9RZGiQWqk9C0o4H1aZ3fsKz
/4jUt+smQXCvS/p/1T/B7WLIt9fLJkGkeHR6YPMv6Ci4Gpg7OgGSNVv8wkR7
oUo9ojolYwI8afHM7OY+eMK21HmUPAG2Ffff9C75DZctljxMjp8Apxsqoo8s
fgPbI8bn/pUJ2Pau4NSDit/w6kkCM955AkS+5CeWYz8kr37oFr5yAooLB9Yl
Vg2Cn9AL6umwcdh6UjnHInUYjJPtEu4EjYOA3qpamY/DsFSboFLiNw4htevr
9EaGIcdx976lR8fB9bH9hoP6I9CX2Xv3leE4dIpFWuq1jYCNKVN9jjcGRHuy
a7fCGGwKvewQ4jkGhal7Z97NTgB5lcpQFncM3jATdnUoTULd07rAhoNjoFwU
NGbrMAknGlenKZiPwTaf3L92RZOQJl8wXLFuDPTN9XLuXZ4CidKhy0JdoyAH
oh2XFP/lnGCbE2s1Cl9DufKuL3jwJUnkk435KHTmOD79b4AH2ezyXkmjUfjc
bin1Qo4P3MBNq+9qjsKy1GcvnWL40Lyw9OYD8VEIio7v6Tg/D4XztceffBmB
E6wyNuff3bnEM1MsMB+BsEaPpcX/OIKTSDI8Z/Rv7ii6+hlLIm7b9tZp27YR
MLnWnGrnTcTxc0qx75RH4Ouijt6nb4jInaNTSgRHgGNs8SPakISmsx+6PlYM
g5CfRM5BZzKKT7PufzcaBm4ALZ5dSsVHwldkB3WHYSTu5pDDXypqyX9Km9UY
BgNhhfKclTQ8YGn7bPmaYTie5SVKO01DTbsfgY9m/0Io2ceGK0fH7cXbP4Qf
/wvLygt//r3NQE40ZY/j7iGos7KPYMQtxkSd8EN80UGYJN4v6EsVw9aALWfN
CIMwndESFYNiuLKkNzrh7wDUfhG6btcqhvG7jaq0qweA31h0R0FMHKOd+Von
wgfg1rTWyfoAcQy/7inYQRmAXdBy4JjDEjzbuf8lzv6G2guuRLqiBNpdZS4K
6emFmZh8u+w5Sdyn8Zv/zqkbsniSX2NXrEGJ9OEyZtt3uHeJd+O3iAKK8VY+
MopqAK3uLXI7/yohmea3KmNjJQzK5a/crKaGU0dS5Avqc+D2k1aRuDINFA6M
st4mksO6+PTlJl1bbZQx9TMzaa9kfXq788+Ykg5GOtDkhw0aWMcNDPM2ftuK
D763xuzf2c7iydQXZzXoYczrGNGdEd2s/AP+Q0lebJTwf/35wfNeVvGd8mv0
OQO077xnaLRhkJV1kR3t+tEQVWUuStZtGGb1nmtVv5S1A4WXVjf4bh1lNck2
kXfk7cRa+4ueJV7jrGn2rawBSVMcufendPDKJKu6x9//pa85jmu+m3xbNs06
uU9zp7qcBVqVmfW4ds6ydN/nDKxt3otRTL/48L88VpgmucmOaYkvP1DXWykv
sFYK+0Pshf14Rzt9a0ASgf3rOKUtrMoKP6oTLB69F2Bv/WwdJax5AAdupRmH
fCeyRRc5THrE2OBWd2Wm1S8Su4lDCNDqtMXZUz86zlAo7Nr3jkyesT3+nvAJ
uipGZbMurjUkxDpgRasd1VqSxvaeLdl+pt0RJQdO+Htr09lPe+R6m7Y7YZyf
c1Uwi8F+OSQ6wb11CM/2xVcoGDHYgfzE35oxh9DJtqasyoTBvhVu0E64ewgV
dLaViFsy2LimvvxO2iF8NSVR+NCFweYZiCVWFx3CxjOV2cXXGOzozyUmmwYP
4TIftQjiVwa7raegOXgtB2d7uLfSmhnsyJ8WVscUOdhude+G6XcGuzrzT42F
EgfTtATDIn8x2C3KhuVMNQ5uGu8Olp3553d+/6tXuhw84BXnvV1akC2gMxnT
b8nBrd2fT/+SFWSvVhQSr7XmoPR+8qkwRUH2hWDlm69tOfhL45RHnZog23rj
hSshThw8M2rKdTYUZDfv8PeVduOgvXOQC9VEkC12tnKM7MFB/brXzhnmguyD
wTInBzw5SH2+9tCotSC7uqzL9Y0PB/vXOByMtRdkb+7Y/fO+HwerIyIcth4S
ZOuHwH+Xz3HwuUCFXfthQXZAyub24xc4+P//SPYb1Vf2lkEc/B+OdK0r
           "]]},
         Annotation[#, "Charting`Private`Tag$29792#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwtl2k0FQoXhs88ZShR6JCbMSSUMpRzyBQuMpOPg65URGWsDE2ShEiUoWQo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           "]]},
         Annotation[#, "Charting`Private`Tag$29792#2"]& ]}, {}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-3.3010299956639813`, -132.0520382568733},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-150., 
           FormBox[
            RowBox[{"-", "150"}], TraditionalForm]}, {-125., 
           FormBox[
            RowBox[{"-", "125"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-75., 
           FormBox[
            RowBox[{"-", "75"}], TraditionalForm]}, {-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {-25., 
           FormBox[
            RowBox[{"-", "25"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-145., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-135., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-125., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-125., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-115., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-105., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-95., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-85., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-66.02601912843664, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-150., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-125., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-100., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-75., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-25., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-150., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-145., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-135., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-125., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-125., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-115., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-105., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-95., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-85., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-3., 
           FormBox["0.001`", TraditionalForm]}, {-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {3., 
           FormBox["1000", TraditionalForm]}, {-2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-3., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-2., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {2., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {3., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], 
            TraditionalForm]}, {-2.6989700043360187`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-3.3010299956639813`, 
       3.3010299956639813`}, {-132.0520382568733, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-3., 
          FormBox["0.001`", TraditionalForm]}, {-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {3., 
          FormBox["1000", TraditionalForm]}, {-2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5228787452803374`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.221848749616356, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0969100130080562`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0457574905606752`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.4771212547196626`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6020599913279625`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.7781512503836434`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9030899869919438`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9542425094393248`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-150., 
          FormBox[
           RowBox[{"-", "150"}], TraditionalForm]}, {-125., 
          FormBox[
           RowBox[{"-", "125"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {-75., 
          FormBox[
           RowBox[{"-", "75"}], TraditionalForm]}, {-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {-25., 
          FormBox[
           RowBox[{"-", "25"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-145., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-135., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-130., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-125., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-125., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-115., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-110., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-105., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-95., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-90., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-85., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-66.02601912843664, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwt2Xk0Vt33APBnHpQxVFIhU4aikEruNbxeIWWeMz3PE0qmlDSXJmlAGUIy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           "]]},
         Annotation[#, "Charting`Private`Tag$30400#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwt2Xc8VY//B3DrLpEIoWsULgnFByGcQ8ied9j73naEpFIaGpSEhkplJSll
VEZx3hnJllnJyt57U9/7ezx+f53H83Ee57xf79f555zH2eHj78Dk4uDgKObk
4Pi/4/1TfxlXDvPCCO2pZ80gHlze7cXc/HihOLf+njwXAaQmfCj7vHjhgUSz
U5IkAdIPV86PMXjhTuEkZZlKgI+ed2NpB3nh7nFDMc0KAvyw3lmjSOGFzRs/
K/FviEBWMjVo6CNB4g3KWco9Xug5FPriVTcJWss+GPXk8ULai0y+iA4SHBQs
LcGaeUFlh0CHdjMJksia4dNbN4GB2I8zKaUk6F5/wiX1YBN44Y/mnE4mwdOX
Bl8ak/kg7U+0HNmTBHbGnRKd7Zuh1JWAPnUhgb8+oxL+bYbelkuuUnQSjIqE
F7YrCIBUZVCcjDUJhDhaTiWFCkDCa2cO+f0koFkrKDts3gK3guV/q2wjQYSw
iIhT/hYIxBfHIw1E0JddaHKTEoK74VrvoJoIHdHlL8o1heDd8rtqw69EGBjS
CbKwFoLx0RRO42IivP7RGZ8dJgSshpv+Zq+JICr5h3/stxC4JFAt7W8QISCy
8rJu6lYwVBrn8kWIkKLi4OZsJgKsXZM+e/cTISeednvFWwRuK06XbmgRwcVo
RbfgvAj8oMxfSVAlwoWV/5Ji34nASdl1rnpJImhEFbEKxEQhkczHrbNOgIcH
jPcvTIvC8mZlboFCArw8oLBTtUgMpDar+v5+TwDfK6QX/e1iYMy/t+xVNgGE
eFstSxbEIGaTxlXjDAIwaKzUDjVxoBD1uM89JMAVsklb6WtxoHJacQ+cJgBi
mJDKSpeA7Llj3J/UCZC2Kd2UUkAGmw89Z56qEiBnU9rpvp9kGA+hjYcrEeB0
jZ5/5RoZFFcNWo13EqDXqvswDyoJSRxCL+sFCbBfr3QTo1oS7vIXWPyZxsMU
n6RqxKAUBCjwxJHe4cEdsF+iz2Vg80gofjwTD6/O8n64lSsDbzInztWn4yHB
m/+d6FcZGFZp941/hgeafbW7/4QMeGlkakrewcO+hmNKqvo7wM7Q7ufeE3ig
d31oWejZAXtcE2WcduPh5sa4kKOuLCg6OZn3UvDgYc0VkeQgCzI04cCjO/Fg
U/Dt4qZjsrDF9nZZmDgegu4YxegmysK0URgrmYCHj1eP3+XgkINcJbc3o304
4FuhjR6skwOt1e3aFxJx4BkleOlFOAVUl9q98Ak4kK7QUf3zhAKU+fjImHgc
kAO6T6IFFNg2uakjOQoHKl4+u31mKLDcu3bhaygOYh9kKxswFaCoqqNMgIaD
yP0p2qcdFUH/0RPbFH4chEwc7/1qoQR65J7PZ0g46NLhsDU9wvZzOSVrHA6q
kOcxgzeUQPdFFs/yOg/0e8nNR1YogXYOVmg9zgN2I9J7PI12g0ZVn+xKNQ+I
mcAJFyNlUF7ZvWx7kwduv+XnMndTBeWwAKZ8BA+Qlqf1RcJVYfe/902r4TwQ
phJyGZeiCko4g6wXZ3jgjYLzJYdhVVAUtPNZY/FAYHT6RlLIHpDbFVybbsID
9dVSB4Ws9wLZ+XPSBhcPRE5sTsi5qAYh28xKz/7lhpDvZCvRe2rQ2Nrct7DC
DZ/04ytjX6nBVYcxyuQ0NwhbiJrUtajBqKVEVlcXN7QddkljKKtDgUFoIVbE
DXeRgsKybnVwlNNouhzIDUczynv0nTQgauo1N/4PF3x7z9KXj90HbgGZOg87
uSC2ksNw7fU+UJ3J8Ff8yQUVXFVXhr/ug6bZFx0WjVyw52tqDnFjH0gsPs+L
KeGCrSI/DDyPakPmeryv+BMu6NuD4r3MdaCKFFamTOWCJoprQrDYfiDKWV11
/MoJVpb9VGzJABi/+OVzizngEX+/qU/oAThSr5dzXv8fBp+qMv9uMYOvY0lu
H+Q3sKo0ivWEjhUoc2ocvyS5gfnP9PZeMreCONHK85YiG9h+PU+U39kKPAwn
HvfybGAZ56Slt4RaweIDnZ/8/evYtL1+7ecPVkAxaqKxUtYxd6c/OS/2WMO1
BG7bbdLr2KC6Sb6bpA0Ym7AMz4qtYWffxtza2WULHt9vFMYKrGE18ifoOeO2
cNb9lVomfg3L3dRfqrFmC29Pj+/omF/FBMix7/n47EAsPZBL//sqNp7YkPFG
0Q7G8OFlHFGrWF0C18d2LzuI+/bQ5ObaCrYoEPmqvtYO3lALi5NmVzCWSckB
t2Y7qOz5pVk4soJNb9rzt++nHawvS1JG21cw4VO+zb2DdsDclYa3er+C0cPy
OB5y2IN2VHalwIkVbFejRM6Quj10W1aZP+xaxoa3mVspxtsDsX/NwqxtGdM8
7HnpYYI97A1TtVqpW8YkhENzOJ/Zw5U38TauxcuYTfa/LZUZ9kDh93CUTlzG
Gizy50RK7OFk/azbS+dlDE7y/KwYsoe/duSA/JYlbOetjJNh+xxAYcTm1OHa
JezJasKqjZ4D2F2+HChevoR5nT35lWzoACk5g8Hn85aw1AQ+xUwLBzAVyjmL
xC1h3Ve13W67O8CdZpOrlbZLGMPrdF/AFQeQpPs/aK9exEykO03qvznAqt9e
jrYvi1jB4ybrI3UO8CNo5khLwSI2n5Kh/O+7A8TFBul/T1/EutWbLm7vcABi
3Zn+6ivs60Xm+0UnHGD+wCX1Et1FLI5y1Yi8xRGq1WLr0zIXsPzoadmLDo6Q
gTpopyYvYM20zunzdEe4Zrs1JTlhASv81it22sUR0BP3Tz+7voD1WCrfcvZx
hI8Zj8gJPgvYm4YK/7FTjpAsnXL0lsQCFnbdZFbrriOE8ufhA6PmsUVxjrSo
KkcwTXZ+9PjyPLag92dtrNYRhDU5lMtC5zGtnlI380ZHyHazthc+NI/hn/qZ
L7c5wvDroScfD8xjRZwK+gr9jsCwIKutrc9hUm38XHUbjqB145prhP8cNrIa
YOaoSgWe7cqTb1hz2JekUbq+GhWa3jZdanWfw6i7r4/KalDhZJt0OsVqDgtx
p2QP6lAhXb5o+pviHCZn+ELygAkVRMonr/H/mcX+DTWXuLhSYZ7DKfsBdRYz
CVaOkLpGhcYkgVqG1SyWs1ypcPoGFbLQyiEx41ns4GCdYlUkFViXtKSf/DeL
YVzGNkfuUOHHP+E7z4VmMdPA+OCoh1T4/Pf7sYzGGUzgacV9h1dUuLpuqVBk
NYMFmEbP89VQwSuR+8B54xms5cLsdeE6KujpffLQ05vBFhvIteIN7DznlR6U
7J7BWG86QyWb2fPWiLgy3hlMMMwnhdRBBYvVij8136YxqjSH95lRKggtI886
jacxi9duoYUEGqRuvr5zfP80RuaTUkoh0UBDvjZ9VX0aG9NzuHxzEw3oDk7v
tu2Yxq5dStxtI0CD/5x7L6WuTmEt6A+sWJQGRqVGFbeOTWE3agI99srTwOse
zsbNehJ7eCXvcQhKgytfYuln909iNz/puoob0SBtUtLzwa5JrEJUUKzoAA2G
zbQCGnGT2AOJ2rsLpjTw32DFGZdMYIhtdTnVmgYXWd/alPdMYEYR970+OtMg
UfuW58aWcSxNrEZp2ykadFzQOWfJMY49vvPGmhVIA4myoXuPpsawbk2fmbwg
GiRYG1dr1o9h8W7nSi1CaHDPZ0Pj5K0x7MtWs2LWeRrcuu3P240bwyQj0545
X6PBuR7HD7A6guWeC1rXSqBBoTxX4+bREeyGz2Kc8yMaLB/NHnX7OYJp3/Hp
OfeYBiELfDIr+SNYhbdJemEiDQJ5v0apnR7BQlX+kRSTaXBUQ9srZWoYS72o
HVX1igbON8mbIvqHsPKst727imjA8Wlo8XjTEOZ1cN12/ycaZEzk/qHBEPZi
0/sgy8/seQ7mRQqJQxh1+fCfQyXsfSRDjtQ4DmFZJzKiY0tp0J7bUClUNoh5
vuR+8qqaBrTOKxHJyQOYUEKS4vJPGqwL2ARExQxgMhrV1/t+sfs3EncLujCA
qWaM1dd10GD+5bv/TJwHsBh/Fdnnnex+An//Gd4ygGldncJp9tKgmaBluPdS
P/b00BLHnmEa2KuPbJR49GHPh9U6mAs0+HUyfP+6VR+mGrL+SGWRBj6vRc7q
7O/DQj3eh86zHSxnNJ+3rQ+ruTz5OHyZnV/0yWhG4x8sdsz2/q01GvSsWrXH
Gf3Blr2vBZ3npMPJsuxsFqUXExTsky7jo4PIq+mv5N+dmN/L7fF7d9DBy8Gb
tVLUifGdeCuLsf1m7Tuu7VEn5qz0XNV6Jx2MbfKMYxidWM7dzx8PydIheO50
KWfzb+zKpqwXD+Tp0KK/VjxY1YHVPTXJ/L2LDvFNuA/Z+T+xY78KIjer00Fw
XSLVOL4VU/fhOqZmSAfVSxX9dP9WTMFEeCOLbSueAMoRy1aMb5eqgpIRHW7y
VbyK5m7F+hPem+44QAcOSf/stqAWTKPwchWvCR0m9cuKD1ObMS/0bUyNGR2q
w4/9uC3yHVMSxKJIdnTgIYRuz9xThXHt296Y5E6HJWaafFFzNtbwm7unI5gO
my/F0/QEspEFYqNEchQdZCxCLc26qhCxXd26HqnsfVIDX3fJVCM3b+S0Y2zf
3Di+6bRvNZJn9uXljjQ6TGd71yQPVyObPlX1DbAN2ywt12ZrkBfb+38FpNPB
e0DS8i2hHsENHDaMfUUHe/CWjxL7jsheq+z9944Oca4E+WnDViT7bYzKh2I6
PM6qzsWxWpFuVaGvaiV0SPkXjW6PakVuH9WvfMt2Xqqwm2lTKzLY3YbPxNj5
xnbEJ/q0ITHzOnEvvrCfZ5gep/nVdmROUON+TgUdEhJPdSaX/0Q0Y/1tZOvp
kDSpcSx/+CfipbaW9JbtDHR5uZbvF1L3uuuMbgMdCvsvCi9TfyGs204fHRvp
8Ev5tqXNwC+kSng55nYTHcjF6YWruN9IFn/DDbF2Ojzv7LjveLALUZW6Z57U
Q4fB7aRLcLQL+ZyeQ97fSwdlF62jKne6EFFlWnQb2wVtdw0IrV1IX7qEpUAf
HRobTIaKfLoRm1Vr6s0BOnD2MsiCSA+y20Ds4qNROqg3fzkR6tKLZF8VPY4s
0IEW+OOP6vFexCave2SK7VDBKcbAhV5E90QMJXmRDiW2ZCOH5F5kqEWsF7dM
B8vaEFHl4V5EerfDuR+rdPCr2I11n/6DYIYW+qkcDLiff3/Lwdg+ZJC417Sd
jwFPDKKCapP7kMhHT7Tv8TMgueJim31uH2KdoTBrv5kBWc2HEt2a+xB+ckVJ
gwADKqZ0FANF+pHDHZYdLUIMWFDoQp4+6kfuvP66GS/OAFoCxX8ueQCphXfc
fBQGuEpvbwrNHUAOVelO97HtnS6g+bd0ANmatbPyswIDTrxfXiX2DyCpWSXa
p3Yx4Fpj9XUpyiDyTdrPakCZAR+I/s/MMwcRwkGfA2v/MUDkbH7d89whxEnn
nOyQEQNyhWI8o8qHkMjrAjlzBxhg94Y1E9w2hHy5f+8ypwkDorpFRCxWh5D4
PQdnZQ4y4K9JsNu84TAyYPXGyN+SAYNCamNm34eRb5HDipZUBhS8ySTOTo0g
vHplX/gOsfcxvfL4N+co8t7olpzJYQbMdjsrV24dRWaSJnnCjzBAeSvJLnHf
KNL88pjp0jEGJJ099NA0fBSZVl3lXg1gQKSpHOXJ5jFk9PkHVYvzDHDpeXrA
WGUcSX8kNCQby4Bf3o5lG/rjiLrm3IczcezzfcQD+TbjSPx/4nx18WwPBhkp
BYwjYjkPaGEP2B43N9ySN468tDkeO/GE7eUFg9/aE8jFw+GO5JfsvrfY6AYb
TyJaoclJBSUM+B3LXaRCm0TGj2pvMQQGuG0t1BliTiI7FHpMar6wLSqn43Jj
Emn0Kts0UM42eXUfWj2JlE0t6anWsK2YrslnN4Ucj/8nLP6DAaoy4WJNKtNI
/+1tm7zm2H26Br/j0ZpGandJXyYvMKDu4RHTfQbTiM3Bhqlfiww4LkANTrSZ
RpRvC4H7KgMy/yo2svynkeu7146e53QCSmfTjbXsaeSKTM2Q2BYnkHpMWZLT
mEGkjdXbxlWdYLJ1+x2G3gyyTTzy5/heJygWFJSPMp5BjkCVzJS6E7hFrjlM
UWcQo/z1iFUtJ3gc2vi28PQMYttnOaqMOIEo4xzLJp99vzOXvLjsnGCzcH3r
Gd1ZRHJsVeFKkBPs+qnB435gFslj4Mc4Q5zA+NkTdSOrWWQauf8pItQJzike
ieHzmEVmMg7Gx19wgkE9HvPky7OIgWxPeNsNJ8CYup+rv80iTnHtJ+YTnSAg
Pz1FkjGH/Kr1U8iscoJbYfzfubzmkE/qno/jap0g3TD439DhOSSFrHX3YoMT
/K4xdMs9N4dEqlZv9W51ArOe3yIHn80hfn/1Bu16nUCGtDUyYGAO8awYJHev
OMF3l3D/sqB5RHUtyP27ijN0bW0V3hI2j6Q2Xs5f2usMo7VKRW4R84hbdX70
Dg1n4EbaeBbvzSMNLeWfwnWdQVNW5bHix3lEovXdOdZBZ3g09qs8enke2eOU
fLjH2xm8w7QknC4sIK1VP0yfPnKGk5q3sbRrC0jDbZ9YnafOcG6y128megFx
DaCV/kxyhniv6HdRzxaQj3Fl/fIZzlBh3G9cjC0gJ5ewmxMfnWEXf5z/Tq5F
ZI24qK7f6gwzTyfKx68vIk019wgLwi5g0fOeczxmEXmlFHX0hLgLpOwMMxhL
WERuUNo6RyVdwOElb8FI5iJSevYCboHiArnZCq8H6xcR7eiYb6Y6LhBY5h3b
I7qEOCbU3O7zcIHZ4Vb3lvQlJDk6OpL81gXm/ytZ/PR1GTEJjr5l4e4KBkeD
M3c2sF9arZbrMB9XuJGk5BHZvoy45Jaq6h52BQn+hxX04WXEXqLX3iDIFdBB
/3szpBXEffqnWUSkK9xO2KGuYL2CnOcv30XMdwW5jYgTcc0rSFXi5OdFETeg
frXsP9yzihAHfELP9rlB1hmy/4vhVSSfVT8hNuoG+F0TK73Tq0jWPGZRPO0G
BbfuCLhyriGeX1tzhf+6Adn+u671zjXkk4fMxoaYO/R30GPV/NaQifLPpgW2
7hA8422wOrSGNJWqbPkI7hBPDk24NbWOfA7yVht85wEfKvC7qLv/IQr+3Q7B
gV7wWPOV7oUkDjTY4BqvZ4Q31Khx2KZ+4USLzu8ULEv0AeOariahr5zobud4
/bokH/jsV0y/Us2Jit9N32hJ84Gsh+c8vJs50ch9Wkqdb3wgZmP+hPQAJyql
+aGp4bMPOFaN3H5C5ELVXUIu7v/tAx1ezdXxtlyoioO0hJi4L4zFpJtGdHKh
hXnRuoFRvuCWun7tZS8X6vWfylx8tC/Uf3SoqB7gQm+KHpXNu+sL2Z1/DwhO
cqHt1y6NjDzwheDdDMNnf7nQ5G37cDqpvvD3K0GvQJobXd8c6eb+yReE/h5W
G/fmRl+XbQhiI75wVRALEGBxo9tLVHJixn1hXk4kW/0oNyrR+bPGfcoX2i2/
qJ4N5Ea59zednp33hcRH4sr4q9yortnbNxv/fIGiWU2RSeNG3S0I+xNF/ED3
+G4ydZAbVdr14do/Az+wN9Z92TjKjZbZvVv9aOgHh8nm6tZT3Gi3ROyjY8Z+
8KCWZWa6zI2SPEpdas39YFY5JViblwcdpY1uPU71g8wJsTqyKg/a+/hLgfwR
P5Dwx18cOM2DFsm3uUXf9QO1gyIkn3M8aLP9fbmJOD8wk5a713WRB73x3ydL
i/t+ENJgmNl+gweNXyzH1h/5QdOeC21Vj3jQv8Lbg41S/SBqek71bTEPupJp
jTl88IPVU73dITgc+qrhfvW9dj/gLT9EeUnCoU/MNRiXf7Lni04eb+fHoaYv
t34/1uEHOkWrK/tEcainPD1et9sPQrmEhVcoOHSoxPoyNugHi3GmZufNcCjj
1unwwwvs/fJeZ4ffwqFSevh5I0EmcOHVl97F4ND3z/8LnhZigpBTgX5PPA4t
6ZQWSxRmgtp6eTWaiENPXeVqmtjGhADjrn7OLBy6kHhR/7wUEyZbtohH1ONQ
yom7J5HdTBhZOH35piAeHQzTWQ09wIRL1yLzUkXwqN2zpL5BYyaIiTwdKBHH
o908JVqOpkww1Sg3X9iBR/dZGskomDMhLVBIyEcdj1Zm0Hd/tmGC19TblP2O
eJTXwTsk0ZkJP4aHyibv4dF12yUX9CQ7T+jaAukRHr0ovvnQRX8mEIgCivJP
8Sj39+t8nwKYoKWgddv1BR6N2Om0a28QE+4xI6jfPuDRDj3XJlIoE+z+yAwk
t+HRC8cKJMMuM+FbhzOeJkZA5+9uNmbFMwG3lxJRRSagp7ZkxcbeY4JRxCyn
wQ4CKhG4cfzTfSYUK9/aoCgR0PQu92beBCbkXvg8v7yfgPrfPhWdkMiERGnp
vkRPAiqV9l7u1At2Xt9+rD+dgI7/KuHY+ZEJWfnZ+s6vCWgVVUl2Zz4TRjdd
+FT3joBel6zC7ShgAvO9SP7HAgJK7osW3F7EBBfcwbc3qwno8ojHcY4SJhi/
fJWoPElAB8ZeBMVWsPsdO3k2WJOIKuTlJbU1M8GmMDc3UYeIHlXNmUlpYULE
jcWxcn0iGliFczzZyoRp2YseIqZENGRyyoKrnb2/W/SBj3Qi+u+Zior0LyaE
1r/mXz5DRLXFSakqPez+c4aTzxcR0d6kLNe0MSb7+0S5I7WEiIqR3mdTx9l5
bAKEa0uJ6ILJvCbPBBOyR5euk2uI6MPpXy1ek0y4KUs4XtxBRPdpbbu4ZYYJ
2vfltf6tE9HHrxvMLRaZ8DDUp/oKQkJTPM5Pq3Cw4NxwwjeKMQnVGkx80862
h1PD12ozEnpUpfrmJU4WULT1yoQcSKjst7oXDVws+Lgk8jnFj4RqcrTG+uJY
0BZSlVUaSUK3jdgq+vKyQPT03liuFhIqvjT0+dtWFqz2s2LSf5DQzhhSnJMw
C7qoT6MtOkmognJ3xhDb6Rq8UXGDJPRIwPXn3KIs0Jrvu7JzhYT+epxcoy7G
AnrQw2AjKV50aRo3e5LMAt2+usDBnbzoeK0qdY5tKUeeU1EKvOjqNCfhjCQL
BtVPnWjay4ve59LzCZNiQcisBcvnAC96rrqJEC7DAhefy354M170pu8u4l+2
DZryfTKteNEWjn1eYTtYgM+V85yl8aLLCcMSZ3ayYHSHq/sDF1507xWj8Dm2
62NjXXU9edEuG8zAX5YFuZzfnLt8edF8w30uo2z///87NCPqcpOfHAv+BwA3
9mE=
           "]]},
         Annotation[#, "Charting`Private`Tag$30400#2"]& ]}, {}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-3.3010299956639813`, -179.71065861098563`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-150., 
           FormBox[
            RowBox[{"-", "150"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-190., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-170., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-89.85532930549282, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-200., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-150., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-100., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-200., 
           
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-190., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-170., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
           0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-3., 
           FormBox["0.001`", TraditionalForm]}, {-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {3., 
           FormBox["1000", TraditionalForm]}, {-2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-3., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-2., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {2., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {3., 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], 
            TraditionalForm]}, {-2.6989700043360187`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.00375,
            0.}, {
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-3.3010299956639813`, 
       3.3010299956639813`}, {-179.71065861098563`, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-3., 
          FormBox["0.001`", TraditionalForm]}, {-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {3., 
          FormBox["1000", TraditionalForm]}, {-2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5228787452803374`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.221848749616356, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0969100130080562`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0457574905606752`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.4771212547196626`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6020599913279625`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.7781512503836434`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9030899869919438`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9542425094393248`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-150., 
          FormBox[
           RowBox[{"-", "150"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-190., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-170., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-130., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-110., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-90., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-89.85532930549282, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.711709455829661*^9, 3.711709498634956*^9, 3.7117095307222557`*^9, {
   3.711709708621047*^9, 3.711709720096274*^9}, 3.711888664685285*^9, 
   3.7119749889469967`*^9, 
   3.711990091479804*^9},ExpressionUUID->"6922e53c-408c-4424-adcb-\
167beb2304c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pid", "=", 
   RowBox[{"PIDTune", "[", 
    RowBox[{"tf", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<PID\>\"", ",", "\"\<ZieglerNichols\>\""}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PIDTune", "[", 
   RowBox[{"tf", ",", "\"\<PID\>\"", ",", "\"\<TuningRule\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<PID controller = \>\"", ",", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"pid", "[", "s", "]"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", " ", 
   "\"\< \[TildeTilde] \>\"", ",", 
   RowBox[{"Rationalize", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Expand", "[", 
       RowBox[{"pid", "[", "s", "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "0.1"}], "]"}], ",", 
   "\"\< \[TildeTilde] \>\"", ",", " ", 
   RowBox[{"Rationalize", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"pid", "[", "s", "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "0.0001"}], "]"}], ",", 
   " ", "\"\< \[TildeTilde] \>\"", ",", 
   RowBox[{"Rationalize", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"pid", "[", "s", "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "0.001"}], "]"}], ",", 
   " ", "\"\< \[TildeTilde] \>\"", ",", 
   RowBox[{"Rationalize", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"pid", "[", "s", "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "0.01"}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pidff", "=", 
   RowBox[{"PIDTune", "[", 
    RowBox[{"tf", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<PID\>\"", ",", "\"\<ZieglerNichols\>\""}], "}"}], ",", 
     "\"\<Feedforward\>\"", ",", 
     RowBox[{"PIDFeedforward", "\[Rule]", "Automatic"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<PID FF control = \>\"", ",", 
    RowBox[{
     RowBox[{"pidff", "[", "s", "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", " ", 
    "\"\< \[TildeTilde] \>\"", ",", 
    RowBox[{"Rationalize", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"pidff", "[", "s", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "0.0001"}], "]"}], ",", 
    " ", "\"\< \[TildeTilde] \>\"", ",", 
    RowBox[{"Rationalize", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"pidff", "[", "s", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "0.01"}], "]"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"olp", "=", 
   RowBox[{"FS", "[", 
    RowBox[{"TFconnect", "[", 
     RowBox[{"tf", ",", "pid"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"olpalt", "=", 
   RowBox[{"FS", "[", 
    RowBox[{"TFconnect", "[", 
     RowBox[{"tfalt", ",", "pid"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rout", "=", 
   RowBox[{"FS", "[", 
    RowBox[{"TFloop", "[", "olp", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"routalt", "=", 
   RowBox[{"TFloop", "[", "olpalt", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Denominator", "[", 
       RowBox[{"rout", "[", "s", "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "\[Equal]", "0"}], ",", "s"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Denominator", "[", 
       RowBox[{"routalt", "[", "s", "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "\[Equal]", "0"}], ",", "s"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"routff", "=", 
   RowBox[{"TFconnect", "[", 
    RowBox[{"pidff", ",", "rout"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"routaltff", "=", 
    RowBox[{"TFconnect", "[", 
     RowBox[{"pidff", ",", "routalt"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"FS", "[", 
     RowBox[{"PIDTune", "[", 
      RowBox[{"tf", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<PID\>\"", ",", "\"\<ZieglerNichols\>\""}], "}"}], ",", 
       "\"\<ReferenceOutput\>\""}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "test", " ", "equivalence", " ", "of", " ", "my", " ", "closed", " ", 
    "loop", " ", "and", " ", "MMA", " ", "ReferenceOutput"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FS", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"rout", "[", "s", "]"}], "]"}], "]"}], "\[Equal]", 
   RowBox[{"Rationalize", "[", 
    RowBox[{"FS", "[", 
     RowBox[{"Expand", "[", 
      RowBox[{"tmp", "[", "s", "]"}], "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ppairs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tf", ",", "tfalt"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"olp", ",", "olpalt"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"rout", ",", "routalt"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"routff", ",", "routaltff"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"popts", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PlotLayout", "\[Rule]", "\"\<Magnitude\>\""}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.006", ",", "100"}], "}"}], ",", "Automatic"}], 
          "}"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PlotLayout", "\[Rule]", "\"\<Phase\>\""}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.01", ",", "100"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "180"}], ",", "0"}], "}"}]}], "}"}]}]}], "}"}]}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labely1", "=", "0.925"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labely2", "=", "0.41"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labely3", "=", "0.655"}], ";", 
  RowBox[{"gout", "=", 
   RowBox[{"GraphicsGrid", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "=", "i"}], ",", 
           RowBox[{"j", "=", "j"}]}], "}"}], ",", 
         RowBox[{"BodePlot", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"ppairs", "[", 
             RowBox[{"[", "j", "]"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.01", ",", "100"}], "}"}], ",", 
           RowBox[{"Evaluate", "[", 
            RowBox[{"popts", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"Length", "[", "ppairs", "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Spacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<(a)\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.215", ",", "labely1"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<(b)\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.215", ",", "labely2"}], "}"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<(c)\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.465", ",", "labely1"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<(d)\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.465", ",", "labely2"}], "}"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<(e)\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.715", ",", "labely1"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<(f)\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.715", ",", "labely2"}], "}"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<(g)\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.965", ",", "labely1"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<(h)\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.965", ",", "labely2"}], "}"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<Process\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.085", ",", "labely3"}], "}"}], "]"}], ",", 
          RowBox[{"BaseStyle", "\[Rule]", 
           RowBox[{"FontSize", "\[Rule]", "11"}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<PID open loop\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.352", ",", "labely3"}], "}"}], "]"}], ",", 
          RowBox[{"BaseStyle", "\[Rule]", 
           RowBox[{"FontSize", "\[Rule]", "11"}]}]}], "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<PID feedback\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.61", ",", "labely3"}], "}"}], "]"}], ",", 
          RowBox[{"BaseStyle", "\[Rule]", 
           RowBox[{"FontSize", "\[Rule]", "11"}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Text", "[", "\"\<PID w/filter\>\"", "]"}], ",", 
          RowBox[{"ImageScaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.845", ",", "labely3"}], "}"}], "]"}], ",", 
          RowBox[{"BaseStyle", "\[Rule]", 
           RowBox[{"FontSize", "\[Rule]", "11"}]}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}]}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"gdir", "<>", "\"\<pidLoops.pdf\>\""}], ",", "gout"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.71171060114043*^9, 3.711710668756435*^9}, {
   3.711710785011265*^9, 3.711710800142652*^9}, {3.71171085397112*^9, 
   3.711710866042522*^9}, {3.71171095755764*^9, 3.71171110748123*^9}, {
   3.7117111461500387`*^9, 3.7117111536246643`*^9}, {3.7117111902308083`*^9, 
   3.711711197202736*^9}, {3.7117116763936043`*^9, 3.711711873180024*^9}, {
   3.711711910190954*^9, 3.7117119310401583`*^9}, {3.711711985354636*^9, 
   3.7117120243520527`*^9}, {3.711712080244577*^9, 3.711712149294537*^9}, {
   3.7117122222252483`*^9, 3.711712229994986*^9}, {3.7117123268161497`*^9, 
   3.711712413781702*^9}, {3.711712591747616*^9, 3.711712637008298*^9}, {
   3.7117127241867723`*^9, 3.7117127927539663`*^9}, {3.711712840376945*^9, 
   3.711712842583126*^9}, {3.711712889212092*^9, 3.711713006027718*^9}, {
   3.711713548335443*^9, 3.7117136129575043`*^9}, {3.711713890305347*^9, 
   3.7117140793366547`*^9}, {3.711714110122923*^9, 3.711714157611958*^9}, {
   3.711714374767685*^9, 3.711714378861459*^9}, 3.711714412545145*^9, {
   3.711714931743958*^9, 3.711714971309031*^9}, {3.711715252400589*^9, 
   3.711715263503317*^9}, {3.7117155296931343`*^9, 3.711715629533147*^9}, {
   3.711715726823214*^9, 3.7117157420580893`*^9}, {3.711715786609335*^9, 
   3.711715800347567*^9}, {3.711716013117923*^9, 3.711716025182069*^9}, {
   3.711716059404916*^9, 3.711716143544702*^9}, {3.7117164014357843`*^9, 
   3.711716455416753*^9}, {3.7117165029772663`*^9, 3.7117165794425297`*^9}, {
   3.711716929321094*^9, 3.711716971420681*^9}, {3.711717147742943*^9, 
   3.711717205304575*^9}, {3.7117172519724483`*^9, 3.711717263573564*^9}, 
   3.711717471002493*^9, {3.7117176473392076`*^9, 3.7117176790613317`*^9}, {
   3.71171775988253*^9, 3.711717817706188*^9}, {3.711717870423399*^9, 
   3.711717887267342*^9}, {3.711717943282126*^9, 3.7117179631143847`*^9}, {
   3.711718054439104*^9, 3.7117180590047293`*^9}, 3.711718108334537*^9, {
   3.7117181608951893`*^9, 3.7117181633508167`*^9}, {3.71171922289075*^9, 
   3.711719230386753*^9}, {3.711719303957315*^9, 3.711719332536076*^9}, {
   3.711729398418104*^9, 3.711729483857109*^9}, {3.7117295260315533`*^9, 
   3.711729535901329*^9}, {3.7117296262305107`*^9, 3.711729705852292*^9}, {
   3.71173099834489*^9, 3.7117310917105007`*^9}, {3.711895256618572*^9, 
   3.711895279867072*^9}, {3.711895340066551*^9, 3.711895480650092*^9}, {
   3.711895519745434*^9, 3.7118956108321657`*^9}, {3.7118967553471613`*^9, 
   3.7118967674526367`*^9}, {3.711896799723467*^9, 3.7118968968061943`*^9}, {
   3.7118969380417557`*^9, 3.711896945700591*^9}, {3.711897039510919*^9, 
   3.711897235226577*^9}, {3.711975033265152*^9, 3.711975049047387*^9}, 
   3.711975079974086*^9, {3.713186614581925*^9, 
   3.713186620364481*^9}},ExpressionUUID->"fdd0111e-7197-481e-8ee6-\
5ce54c3a03eb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"PID controller = \"\>", "\[InvisibleSpace]", 
    "120.6090299242541`"}], "\[VeryThinSpace]", "+", 
   FractionBox["606.0754511212346`", "s"], "+", 
   RowBox[{
    RowBox[{"6.000299992500375`", " ", "s"}], 
    "\[InvisibleSpace]", "\<\" \[TildeTilde] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     FractionBox["362", "3"], "+", 
     FractionBox["606", "s"], "+", 
     RowBox[{"6", " ", "s"}]}], 
    "\[InvisibleSpace]", "\<\" \[TildeTilde] \"\>", "\[InvisibleSpace]", 
    FractionBox[
     RowBox[{"19999", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["13333", "132"], "+", 
        FractionBox[
         RowBox[{"3397", " ", "s"}], "169"], "+", 
        SuperscriptBox["s", "2"]}], ")"}]}], 
     RowBox[{"3333", " ", "s"}]], 
    "\[InvisibleSpace]", "\<\" \[TildeTilde] \"\>", "\[InvisibleSpace]", 
    FractionBox[
     RowBox[{"6", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["13333", "132"], "+", 
        FractionBox[
         RowBox[{"201", " ", "s"}], "10"], "+", 
        SuperscriptBox["s", "2"]}], ")"}]}], "s"], 
    "\[InvisibleSpace]", "\<\" \[TildeTilde] \"\>", "\[InvisibleSpace]", 
    FractionBox[
     RowBox[{"6", " ", 
      RowBox[{"(", 
       RowBox[{"101", "+", 
        FractionBox[
         RowBox[{"201", " ", "s"}], "10"], "+", 
        SuperscriptBox["s", "2"]}], ")"}]}], "s"]}]}],
  SequenceForm[
  "PID controller = ", 120.6090299242541 + 606.0754511212346/$CellContext`s + 
   6.000299992500375 $CellContext`s, " \[TildeTilde] ", Rational[362, 3] + 
   606/$CellContext`s + 6 $CellContext`s, " \[TildeTilde] ", 
   Rational[19999, 3333] $CellContext`s^(-1) (Rational[13333, 132] + 
    Rational[3397, 169] $CellContext`s + $CellContext`s^2), " \[TildeTilde] ",
    6 $CellContext`s^(-1) (Rational[13333, 132] + 
    Rational[201, 10] $CellContext`s + $CellContext`s^2), " \[TildeTilde] ", 
   6 $CellContext`s^(-1) (101 + 
    Rational[201, 10] $CellContext`s + $CellContext`s^2)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.711712934460409*^9, {3.711712976843255*^9, 3.711713007840519*^9}, 
   3.711713615087121*^9, 3.711714170673882*^9, 3.7117143820423594`*^9, 
   3.7117149738459883`*^9, 3.711715264647861*^9, 3.711715537425202*^9, 
   3.711715571855537*^9, 3.7117157454480543`*^9, 3.7117158020307207`*^9, 
   3.7117160262145643`*^9, {3.711716060155121*^9, 3.711716112782172*^9}, 
   3.7117161444488783`*^9, {3.7117164154936934`*^9, 3.71171647239229*^9}, 
   3.711716541627335*^9, 3.7117165806570683`*^9, 3.711716973050436*^9, {
   3.711717164379434*^9, 3.711717206149167*^9}, {3.7117172565678787`*^9, 
   3.7117172641022043`*^9}, 3.711717472955793*^9, {3.711717660530684*^9, 
   3.7117176797833223`*^9}, {3.711717760662373*^9, 3.711717789438402*^9}, 
   3.711717888201284*^9, {3.711717947009413*^9, 3.7117179641858177`*^9}, 
   3.711718060433337*^9, 3.7117181090603657`*^9, 3.711718164051167*^9, 
   3.711719231756338*^9, 3.711719318144867*^9, 3.711719446813963*^9, {
   3.711729399905368*^9, 3.711729484713099*^9}, 3.7117295369865427`*^9, 
   3.711729657656632*^9, 3.7117297136655827`*^9, {3.71173103313962*^9, 
   3.711731093115066*^9}, 3.711888708205428*^9, 3.71189529441143*^9, 
   3.711895359646852*^9, {3.711895401261533*^9, 3.711895481592537*^9}, {
   3.7118955240272827`*^9, 3.711895611732277*^9}, {3.711896756362588*^9, 
   3.71189676803655*^9}, {3.711896847253137*^9, 3.7118968975350943`*^9}, 
   3.7118969547761803`*^9, {3.7118970404168653`*^9, 3.7118972362175417`*^9}, {
   3.711974965335064*^9, 3.7119749924717417`*^9}, {3.7119750347322073`*^9, 
   3.7119750502119923`*^9}, 3.711975081163478*^9, 3.711989856824102*^9, 
   3.711990094365324*^9},ExpressionUUID->"98d1b3bf-2c2e-4323-883d-\
1161bdfa070c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PID FF control = \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{"0.10339384965774019`", " ", "s"}], "+", 
     RowBox[{"0.009900252487375739`", " ", 
      SuperscriptBox["s", "2"]}]}], 
    RowBox[{"1", "+", 
     RowBox[{"0.19900002499874958`", " ", "s"}], "+", 
     RowBox[{"0.009900252487375739`", " ", 
      SuperscriptBox["s", "2"]}]}]], 
   "\[InvisibleSpace]", "\<\" \[TildeTilde] \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{"3", " ", "s"}], "29"], "+", 
     FractionBox[
      SuperscriptBox["s", "2"], "101"]}], 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{"37", " ", "s"}], "186"], "+", 
     FractionBox[
      SuperscriptBox["s", "2"], "101"]}]], 
   "\[InvisibleSpace]", "\<\" \[TildeTilde] \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"1", "+", 
     FractionBox["s", "9"]}], 
    RowBox[{"1", "+", 
     FractionBox["s", "5"]}]]}],
  SequenceForm[
  "PID FF control = ", (1 + 0.10339384965774019` $CellContext`s + 
    0.009900252487375739 $CellContext`s^2)/(1 + 
   0.19900002499874958` $CellContext`s + 
   0.009900252487375739 $CellContext`s^2), 
   " \[TildeTilde] ", (1 + Rational[3, 29] $CellContext`s + 
    Rational[1, 101] $CellContext`s^2)/(1 + Rational[37, 186] $CellContext`s + 
   Rational[1, 101] $CellContext`s^2), 
   " \[TildeTilde] ", (1 + Rational[1, 9] $CellContext`s)/(1 + 
   Rational[1, 5] $CellContext`s)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.711712934460409*^9, {3.711712976843255*^9, 3.711713007840519*^9}, 
   3.711713615087121*^9, 3.711714170673882*^9, 3.7117143820423594`*^9, 
   3.7117149738459883`*^9, 3.711715264647861*^9, 3.711715537425202*^9, 
   3.711715571855537*^9, 3.7117157454480543`*^9, 3.7117158020307207`*^9, 
   3.7117160262145643`*^9, {3.711716060155121*^9, 3.711716112782172*^9}, 
   3.7117161444488783`*^9, {3.7117164154936934`*^9, 3.71171647239229*^9}, 
   3.711716541627335*^9, 3.7117165806570683`*^9, 3.711716973050436*^9, {
   3.711717164379434*^9, 3.711717206149167*^9}, {3.7117172565678787`*^9, 
   3.7117172641022043`*^9}, 3.711717472955793*^9, {3.711717660530684*^9, 
   3.7117176797833223`*^9}, {3.711717760662373*^9, 3.711717789438402*^9}, 
   3.711717888201284*^9, {3.711717947009413*^9, 3.7117179641858177`*^9}, 
   3.711718060433337*^9, 3.7117181090603657`*^9, 3.711718164051167*^9, 
   3.711719231756338*^9, 3.711719318144867*^9, 3.711719446813963*^9, {
   3.711729399905368*^9, 3.711729484713099*^9}, 3.7117295369865427`*^9, 
   3.711729657656632*^9, 3.7117297136655827`*^9, {3.71173103313962*^9, 
   3.711731093115066*^9}, 3.711888708205428*^9, 3.71189529441143*^9, 
   3.711895359646852*^9, {3.711895401261533*^9, 3.711895481592537*^9}, {
   3.7118955240272827`*^9, 3.711895611732277*^9}, {3.711896756362588*^9, 
   3.71189676803655*^9}, {3.711896847253137*^9, 3.7118968975350943`*^9}, 
   3.7118969547761803`*^9, {3.7118970404168653`*^9, 3.7118972362175417`*^9}, {
   3.711974965335064*^9, 3.7119749924717417`*^9}, {3.7119750347322073`*^9, 
   3.7119750502119923`*^9}, 3.711975081163478*^9, 3.711989856824102*^9, 
   3.711990094550227*^9},ExpressionUUID->"c6d804a7-13f8-4386-88f6-\
2fdd5496c739"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.7117165829234467`*^9, 3.711716974727478*^9, {3.711717166273621*^9, 
   3.711717208123105*^9}, {3.71171725818552*^9, 3.711717265722803*^9}, 
   3.711717474581978*^9, {3.711717662211707*^9, 3.711717681410038*^9}, {
   3.711717762315209*^9, 3.711717791063776*^9}, 3.711717889822483*^9, {
   3.71171794863631*^9, 3.711717965811613*^9}, 3.7117180620585613`*^9, 
   3.711718110706044*^9, 3.71171816568281*^9, 3.711719232118021*^9, 
   3.7117193183797073`*^9, 3.7117194471834927`*^9, {3.7117294002942944`*^9, 
   3.711729485111511*^9}, 3.711729537355277*^9, 3.711729658029107*^9, 
   3.711729714035479*^9, {3.711731033507822*^9, 3.7117310934893723`*^9}, 
   3.7118887090152597`*^9, 3.711895294933227*^9, 3.711895360120234*^9, {
   3.711895401735853*^9, 3.711895482062701*^9}, {3.711895524485261*^9, 
   3.711895612246992*^9}, {3.711896756807467*^9, 3.711896768474506*^9}, {
   3.711896847686059*^9, 3.711896898010379*^9}, 3.7118969552691*^9, {
   3.7118970408686132`*^9, 3.711897236697978*^9}, {3.711974966175527*^9, 
   3.711974992977271*^9}, {3.7119750350898952`*^9, 3.7119750505729847`*^9}, 
   3.7119750815152683`*^9, 3.711989857181478*^9, 
   3.71199009484433*^9},ExpressionUUID->"83d13b82-e219-4f15-b82c-\
87dd950c8722"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwtV3k41Pv/RYW4yRIiRZaR0mJfSh9JCiGGiLKltKIpES6R5EbXXKWoroSG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            "]]},
          Annotation[#, "Charting`Private`Tag$42182#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwtlPk71HkcwMWqwYap6BxnKYVcjZA+KHeu8XW0kaGwHc5nM2PtFtZuU4/i
sRSSygwl7Tg6rGaazzvHlpatJJOjw5myjmFcI/Pd3efZH17P63n9Ay/9yHhG
lKKCgoL3v/xnM6T9mSRJPBhkUrBOiwLxC4acBRmJk290XXYyo0D1XQuj6RkS
75XWNPzgRgHLbd6Rw6MkfsA/XGj8PQVsqJndrWISB+W/dQ77QAHHAcmzwqp/
27pTxaRaBRhn2yqtwkncoikqDQ9TA9bzzNgYkRzXkqG93DF16OhQ+/w4YglX
Ukc4156tBhrEr7HZ9AU3abS0mB5aB/dPNClrvJVhLecgykZHGjCzLCa7Mhbw
uJz60putD/O5qRyM5jGnMLns7L7NwFV/t76gbxZf12a258dshWJPi6RX52bw
TWFcgG/udsg4GcE29pDinW0+FdvyTCFV6TYraWwK+6z5M70uwRwi0p5v7rwl
wWc4qVgot4D8R0MFxccn8dxNXwurs1bw8P22r+8YjOPq+tjPrZa7wFDT0Zko
GcWjWdEfphroULudc7x/YARzBV7pOad2w/vmGj06fRizM019O/XsYMgk3xI/
GMC+ocvZVVX2QD1dQTdb1oePVkjdLjIdwIQ+YVI23YtjXkqimqR74af9Yy/q
2WLM6Iy/mhToCFoEP+fg2nacIDhimmviBLWzzRpPNz/Ddx5WhXvOOEFZz9CF
T5kiPOqgIpz4yxnC/Dfd6znCw1t4tuXGRfugXjX1dcMpLgq+N373WMR+2NW/
TCc9BCN1ganRJVsXMJwULNg1tKDZsMmdQUqu4MHtavMJaUf8wn6m8jtXcPFe
pTRzX4xKWPtt8T03yA4Xp5nX9aJs8cEa6o/u8MSHttJvVR8yX9Q0ZQZ5wJi+
1un2ogG0J37wjL++J5z6bkdEtvYw8r072hg54gniXk1G9NMRlCPONrkMXsBM
2fNxxYFRpNCTaJZ3/gA07rA536g8jirB7++5KG8wUhGO8NwnkQLPTDvGygdo
whMuyhwJYtjQa/OXfEBBpliR1D+FSneHORl2+8Kc/6PDzVukqCtw7y+vCD/o
sQ7fuCVzBrE0EwNy//CDhGBNqkHvLHpe0s3S3e0P6/MGQ76izaPoOPvAKJ4/
8A9dvznNXkBRaRsy/GgMCHY44/70kQxlyz8qXsllQM3hWAO7L4to+QXZ3Ihq
AMyr7lOqD1xCPSEXbrflBQDjpT2dViBHDYyStmIaAar2ao+FV+WIc0dNZbUe
AY953V6hXDnS+SZ5+pwBAebslIgrfDmSL+p2pmwlQF23Lmt9sxzBtatvIiwI
aDlpOaA1JUdNayPlDBcCHCnGOeoHSGSvaq0oiCVgPnF+A9+fREXV8Wy3BAKq
ep6UeQeTSOmgtLQjiQCdqmhBViSJMpe5a0lYBHwJ5A2rppAoLV2SaJlBQB1X
12FFOYmOoQ264ksExK2ceFJeSaL8aepQXCEBRiwRw7WGRGt/K2euKCYgzzPs
25+FJPLU62Xb3SAgSVL0q9IrEnFb75tVVBKw/dBxHe4bEiUOdZe68gnoa7Kt
cH5HouEX462D1QT4FbwRpX8ikeiozNnwAQEUxVse+hMkCgldvNj4OwH4BKsD
pCTqa1rKOSogIPm1azhTRiKvKSWP5SIC/v8XsvbUqLsFBPwDZJCFqQ==
            "]]},
          Annotation[#, "Charting`Private`Tag$42182#2"]& ]}, {}, {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{-2.221848749616356, -83.01029755108976},
       CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
           Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
           Part[#, 2]}& )},
       DisplayFunction->Identity,
       Frame->{{True, True}, {True, True}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{{{-100., 
            FormBox[
             RowBox[{"-", "100"}], TraditionalForm]}, {-80., 
            FormBox[
             RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
            FormBox[
             RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
            FormBox[
             RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
            FormBox[
             RowBox[{"-", "20"}], TraditionalForm]}, {0., 
            FormBox["0", TraditionalForm]}, {-100., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-95., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-90., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-85., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-75., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-70., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-65., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-55., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-50., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-45., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-35., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-25., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-15., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-5., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}}, {{-100., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-80., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-60., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-40., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-20., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-100., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-95., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-90., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-85., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-75., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-70., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-65., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox[
             InterpretationBox[
              StyleBox[
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-55., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-50., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-45., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-35., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-25., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-15., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-5., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}}}, {{{-2., 
            FormBox["0.01`", TraditionalForm]}, {-1., 
            FormBox["0.1`", TraditionalForm]}, {0., 
            FormBox["1", TraditionalForm]}, {1., 
            FormBox["10", TraditionalForm]}, {2., 
            FormBox["100", TraditionalForm]}, {-1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.5228787452803376`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3979400086720375`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.2218487496163564`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.154901959985743, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.0969100130080565`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.045757490560675, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.6989700043360187, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}}, {{-2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-1., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], 
             TraditionalForm]}, {-1.6989700043360187`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.5228787452803376`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3979400086720375`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3010299956639813`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.2218487496163564`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.154901959985743, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.0969100130080565`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.045757490560675, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.6989700043360187, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}}}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       Method->{"ScalingFunctions" -> None},
       PlotRange->{{-2.221848749616356, 2}, {-83.01029755108976, 0.}},
       PlotRangeClipping->True,
       PlotRangePadding->{{0, 0}, {
          Scaled[0.02], 
          Scaled[0.02]}},
       Ticks->{{{-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-80., 
           FormBox[
            RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
           FormBox[
            RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-95., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-85., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}], {180, -116.24611797498106}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAALj8W6v///79YdDBg3uZXQG/5I4j5
+v+/Wu7oY0jlV0CwszEm8/X/v0tj5mGy41dAMihNYubr/78eno9MhuBXQDcR
hNrM1/+/THq02y3aV0BA4/HKma//v0ze6tl7zVdAUofNqzNf/7/Uq64YE7RX
QHfPhG1nvv6/subUiiyBV0DU1AvqwWH9v36kdzVXEldAHcBvFDcc/L9TaKCk
EKpWQLVrxAUP3fq/Oj8fDclCVkBgjDHw2YL5vxI05PYX0VVA+JJ7iL8/+L8K
QC/i0WRVQKMO3hmY4fa/bvtEIzXsVECcSjFy04n1v/IQcGtRcVRAgmxheClJ
9L8TN70EdflTQHsDqndy7fK/895twVFwU0BhgM8k1qjxv4q68xNI6FJAlb3l
mJxq8L9+F0B4eVpSQLrfKAysIu6/H2sSiaS2UUAjEEBCVJ7rv1leFyiLFFFA
siqIauLj6L+mkZZhkltQQN/FsSA2Nua/37ogcco7T0DlLJUyv7bjv6Sy3kA3
zk1AEX6pNi4B4b/mONNksDdMQCw27yyl89y/bvB8ayW1SkCDRO3QuXjXv8PJ
2V6xDElAFVSukFkX0r+JGzR1+mdHQLL2xQ/IJMq/eUZmChTdRUCl2+WN6YS+
v0/YHhg/L0RAXVEctNtjpL8ngSM0DJ1CQLkKe9XCdaM/59WOWXkSQUA14gEe
gVi/P5nwhudizT5AI/C7+TrCyT/BWMWMo7A7QEmj2c1OWNI/8EOEGnBUOEBF
TRID9bXXP0j2yq0+DTVAj1/XgDC33D8TvzRifwUyQMdOHQ1QEuE/JOVFfiGO
LUDtIRV+0prjP05XcOWbmydAdXQrYY8W5j+wtJoCw+khQNfcEFJmyOg/H1mY
oTzbF0BgeTznB0zrP5OVMyVfRQpAwys3isMF7j8GkyPSfangPyYJvOikSPA/
a3FkdYWc/r8dvGtFBYjxP7WDs6LDohDAAPoCqXLi8j+f8K2eM8cZwPdRvV7F
JfQ/6LB7VfHmIMDbNF8bJYT1Pzveh+vGBCXAcFcQESLc9j88p8I4U98owBmU
5FgEHfg/CmqdEbBWLMCuW6Cn83j5P1iRcvUr/i/AVz1/SMi9+j9HF7u/nqox
wLFebSI6/Ps/aBcBDJhHM8D4CkMDuVX9PyUAz+6/AjXAUtE7Nh2Y/j/cHUxZ
B502wAo7C8G8nf4/wB2hySmkNsDBpNpLXKP+PypHCA9MqzbAMHh5YZuu/j92
fhkakLk2wA4ft4wZxf4/XCiIOBbWNsDJbDLjFfL+P3HoVM8aDzfAQAgpkA5M
/z/o/eMWB4E3wPhx+BquUf8/FOVHpCSIN8Cv28elTVf/P3twaQ5CjzfAHq9m
u4xi/z+kH8N5fJ03wPxVpOYKef8/VgrOsu+5N8C3ox89B6b/P1aLGt3P8jfA
bg3vx6ar/z985aVP6/k3wCZ3vlJGsf8/QgVAogYBOMCUSl1ohbz/P6bgaeg8
DzjAcvGakwPT/z+fLAT+pys4wCpbah6j2P8/ov93dsIyOMDhxDmpQt7/P2Ri
hdDcOTjAUJjYvoHp/z8VoCwqEUg4wAgCqEkh7/8/XaYlKitPOMC/a3fUwPT/
P/CTdgxFVjjAdtVGX2D6/z9LR07RXl04wC4/Fur///8/YlbbeHhkOMBrimRy

            "]]},
          Annotation[#, "Charting`Private`Tag$42781#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwtlms4lAkfxknSqhwKm3JYx7KU0xyamfJ/OgqNNbNOZRhs2c0qpURJKIm3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            "]]},
          Annotation[#, "Charting`Private`Tag$42781#2"]& ]}, {}, {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{-2.221848749616356, -27.359545977773642`},
       CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
           Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
           Part[#, 2]}& )},
       DisplayFunction->Identity,
       Frame->{{True, True}, {True, True}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{{{-50., 
            FormBox[
             RowBox[{"-", "50"}], TraditionalForm]}, {-25., 
            FormBox[
             RowBox[{"-", "25"}], TraditionalForm]}, {0., 
            FormBox["0", TraditionalForm]}, {25., 
            FormBox["25", TraditionalForm]}, {50., 
            FormBox["50", TraditionalForm]}, {75., 
            FormBox["75", TraditionalForm]}, {100., 
            FormBox["100", TraditionalForm]}, {-50., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-45., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-35., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-25., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-25., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-15., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-5., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {5., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {15., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {25., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {25., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {35., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {45., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {50., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {50., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {55., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {60., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {65., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {70., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {75., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {75., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {80., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {85., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {90., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {95., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {100., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}}, {{-50., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-25., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {25., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {50., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {75., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {
           100., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-50., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-45., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-35., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-25., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-25., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-15., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-5., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {5., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {10., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {15., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {20., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {25., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {25., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {30., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {35., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {40., 
            FormBox[
             InterpretationBox[
              StyleBox[
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {45., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {50., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {50., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {55., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {60., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {65., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {70., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {75., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {75., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {80., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {85., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {90., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {95., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {100., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}}}, {{{-2., 
            FormBox["0.01`", TraditionalForm]}, {-1., 
            FormBox["0.1`", TraditionalForm]}, {0., 
            FormBox["1", TraditionalForm]}, {1., 
            FormBox["10", TraditionalForm]}, {2., 
            FormBox["100", TraditionalForm]}, {-1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.5228787452803376`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3979400086720375`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.2218487496163564`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.154901959985743, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.0969100130080565`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.045757490560675, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.6989700043360187, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}}, {{-2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-1., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], 
             TraditionalForm]}, {-1.6989700043360187`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.5228787452803376`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3979400086720375`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3010299956639813`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.2218487496163564`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.154901959985743, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.0969100130080565`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.045757490560675, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.6989700043360187, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}}}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       Method->{"ScalingFunctions" -> None},
       PlotRange->{{-2.221848749616356, 2}, {-27.359545977773642`, 
         95.60732273799783}},
       PlotRangeClipping->True,
       PlotRangePadding->{{0, 0}, {
          Scaled[0.02], 
          Scaled[0.02]}},
       Ticks->{{{-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {-25., 
           FormBox[
            RowBox[{"-", "25"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {25., 
           FormBox["25", TraditionalForm]}, {50., 
           FormBox["50", TraditionalForm]}, {75., 
           FormBox["75", TraditionalForm]}, {100., 
           FormBox["100", TraditionalForm]}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {85., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {95., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}], {540, -116.24611797498106}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwtWnc819/397F377dRSBnZqaxszosoyUqSUZRKhYQyQilKomQnSVYSkr3C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            "]]},
          Annotation[#, "Charting`Private`Tag$43404#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJwtWmk0lt/XrhCRIUrCI2SIzPPYvkmmIkOGkKmSKKGICClCSIpMISRFCKX8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            "]]},
          Annotation[#, "Charting`Private`Tag$43404#2"]& ]}, {}, {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{-2.221848749616356, -27.568045620455038`},
       CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
           Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
           Part[#, 2]}& )},
       DisplayFunction->Identity,
       Frame->{{True, True}, {True, True}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{{{-30., 
            FormBox[
             RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
            FormBox[
             RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
            FormBox[
             RowBox[{"-", "10"}], TraditionalForm]}, {0., 
            FormBox["0", TraditionalForm]}, {10., 
            FormBox["10", TraditionalForm]}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-28., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-26., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-24., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-22., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-18., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-16., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-14., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-12., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-8., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-6., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-4., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-2., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {2., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {4., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {6., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {8., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}}, {{-30., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-20., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-10., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {10., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-30., 
            
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-28., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-26., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-24., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-22., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-18., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-16., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-14., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-12., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-8., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-6., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-4., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {-2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {4., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {6., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {8., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}, {10., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {0.005, 
            0.}, {
             AbsoluteThickness[0.1]}}}}, {{{-2., 
            FormBox["0.01`", TraditionalForm]}, {-1., 
            FormBox["0.1`", TraditionalForm]}, {0., 
            FormBox["1", TraditionalForm]}, {1., 
            FormBox["10", TraditionalForm]}, {2., 
            FormBox["100", TraditionalForm]}, {-1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.5228787452803376`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3979400086720375`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.2218487496163564`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.154901959985743, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.0969100130080565`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-1.045757490560675, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.6989700043360187, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}}, {{-2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {-1., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {0., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {1., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm]}, {2., 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], 
             TraditionalForm]}, {-1.6989700043360187`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.5228787452803376`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3979400086720375`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.3010299956639813`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.2218487496163564`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.154901959985743, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.0969100130080565`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-1.045757490560675, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.6989700043360187, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox[
             InterpretationBox[
              StyleBox[
               
               GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                Baseline], "CacheGraphics" -> False], 
              Spacer[{0, 0}], Selectable -> False], TraditionalForm], {
            0.00375, 0.}, {
             Thickness[0.001]}}}}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       Method->{"ScalingFunctions" -> None},
       PlotRange->{{-2.221848749616356, 2}, {-27.568045620455038`, 
         7.425880992155507}},
       PlotRangeClipping->True,
       PlotRangePadding->{{0, 0}, {
          Scaled[0.02], 
          Scaled[0.02]}},
       Ticks->{{{-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.0