pdf_datei<-"balkendiagramme_mehrfach_alle_2.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=13,height=10.5)

par(omi=c(0.25,0.75,1,0.75),mai=c(1.8,3.75,0.25,0),lheight=1.15,
	family="Lato Light",las=1)  
library(RColorBrewer)

# Daten einlesen und Grafik vorbereiten

source("skripte/inc_beschriftungen_za4753.r",encoding="UTF-8")
source("skripte/inc_daten_za4753.r",encoding="UTF-8")

f1<-rgb(0,208,226,maxColorValue=255)
f2<-rgb(109,221,225,maxColorValue=255)
f3<-rgb(255,138,238,maxColorValue=255)
f4<-rgb(255,0,210,maxColorValue=255)
farben<-c("grey",f1,f2,f3,f4)

daten0<-cbind(z[,1]+z[,2],z[,3],z[,4],z[,5],z[,6])
daten1<-t(daten0)

# Grafik erstellen

barplot(-rep(100,7),names.arg=namen,cex.names=1.1,horiz=T,
	border=par("bg"),xlim=c(-100,70),col=farben[1],axes=F)
barplot(-(100-daten1[1,]),names.arg=namen,cex.names=1.1,horiz=T,
	border=par("bg"),xlim=c(-100,70),col=par("bg"),axes=F,add=T)
barplot(-daten1[3:2,],names.arg=namen,cex.names=1.1,horiz=T,
	border=NA,xlim=c(-100,70),col=farben[3:2],axes=F,add=T)
barplot(daten1[4:5,],names.arg=namen,cex.names=1.1,horiz=T,
	border=NA,xlim=c(-100,70),col=farben[4:5],axes=F,add=T)

# weitere Elemente

arrows(0,-0.1,0,8.6,lwd=2.5,length=0,xpd=T,col="skyblue3") 
px<-c(-98,-87,-41,15,65); tx<-c(-105,-48,-21,8,60); y<-rep(-1,5)
points(px,y,pch=15,cex=4,col=farben,xpd=T)
text(tx,y,antworten,adj=1,xpd=T,font=3)
mtext(c(80,60,40,20,0,20,40,60),at=c(-80,-60,-40,-20,0,20,40,60),1,
	line=0,cex=0.95)
	
# Betitelung

mtext("Man spricht ja oft davon, dass sich heutzutage die Rollen von Mann und Frau verändern",3,line=2.2,adj=0,cex=1.8,outer=T,family="Lato Black")
mtext("Alle Angaben in Prozent",3,line=1,adj=1,cex=0.95,font=3)
mtext("Quelle: European Values Study 2008 Deutschland, ZA4753. www.gesis.org. Design: Stefan Fichtel, ixtract",1,line=5.2,adj=1,cex=0.95,font=3)
mtext("N=2.075",3,line=1,adj=0,cex=1.15,family="Lato",font=3)
dev.off()
