pdf_datei<-"dotcharts_uebereinander.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=7,height=10)

library(Hmisc) # wegen dotchart2,nur da kann man add=T angeben
par(omi=c(0.15,0.75,0.95,0.75),mai=c(0.9,1.75,0.25,0),family="Lato Light",
	las=1)  

# Daten einlesen und Grafik vorbereiten

daten<-read.xls("daten/Bechert_Graph.xlsx",sheet=1)
row.names(daten)<-daten$Countries
daten$Countries<-NULL

insgesamt<-daten["Mean . . . . . . . . . . ",]
daten<-daten[rownames(daten)!="Mean . . . . . . . . . . ",] 

datensort<-daten[order(-daten$Happiness),]
datensort<-rbind(datensort,insgesamt)
attach(datensort)

f1<-rgb(255,165,0,190,maxColorValue=255)
f2<-rgb(0,0,139,190,maxColorValue=255)
f3<-rgb(100,0,0,190,maxColorValue=255)

f1g<-rgb(255,165,0,60,maxColorValue=255)
f2g<-rgb(0,0,139,60,maxColorValue=255)
f3g<-rgb(100,0,0,60,maxColorValue=255)

# Grafik erstellen und weitere Elemente

dotchart2(Religiosity.,labels=row.names(datensort),pch=17,dotsize=4,
	cex=0.6,cex.labels=0.75,xlab="",col=f1,xaxis=F,xlim=c(1,100))
dotchart2(Involvement,labels=row.names(datensort),pch=15,dotsize=4,
	cex=0.6,xlab="",col=f2,xaxis=F,add=T)
dotchart2(Happiness,
	labels=row.names(datensort),pch=19,dotsize=4,cex=0.6,xlab="",
	col=f3,xaxis=F,add=T)

axis(1)
axis(3)	

abline(v=insgesamt,col=c(f1g,f2g,f3g),lwd=12)
legend(-5,-2.6,c("Religious Involvement"),ncol=1,pch=15,col=f2,bty="n",cex=1.5,pt.cex=1.5,xpd=T)
legend(35,-2.6,c("Self-assessed Religiosity"),ncol=1,pch=17,col=f1,bty="n",cex=1.5,pt.cex=1.5,xpd=T)

legend(80,-2.6,c("Happiness"),ncol=1,pch=19,col=f3,bty="n",cex=1.5,pt.cex=1.5,xpd=T)


# Betitelung

mtext("Religious Involvement, Self-assessed Religiosity, and Happiness ",3,line=3.75,adj=0,cex=1.05,family="Lato Black",outer=T)
mtext("(Mean values scaled from 0 to 100, Data from 2008)",3,line=1.25,adj=0,cex=0.90,font=3,outer=T)
mtext("Source: ISSP Data Report Religious Attitudes and Religious Change",1,line=-1,adj=1,cex=0.90,font=3,outer=T)

dev.off()

