pdf_datei<-"grafiktabellen_ballonplot.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=9,height=9)

par(omi=c(0.75,0.25,0.5,0.25),mai=c(0.25,0.55,0.25,0),
	family="Lato Light",cex=1.15)  
library(gplots)

# Daten einlesen und Grafik vorbereiten

data(Titanic)
daten<-as.data.frame(Titanic) # convert to 1 entry per row format
attach(daten)
farben<-Titanic
farben[,,,"Yes"]<-"LightSkyBlue"
farben[,,,"No"]<-"plum1"
farben<-as.character(as.data.frame(farben)$Freq)

# Grafik erstellen

balloonplot(x=list(Age,Sex),main="",
            y=list(Class=Class,
            Survived=gdata::reorder.factor(Survived,c(2,1))),
            z=Freq,dotsize=18,
            zlab="Number of Passengers",
            sort=T,
            dotcol=farben,
            show.zeros=T,
            show.margins=T)

# Betitelung

mtext("Titanic - Passenger and Crew statistics",3,line=0,adj=0,cex=2,family="Lato Black",outer=T)
mtext("Balloon Plot for Age, Sex by Class, Survived",3,line=-2,adj=0,cex=1.25,font=3,outer=T)
mtext("Quelle: R library gplots",1,line=1,adj=1.0,cex=1.25,font=3,outer=T)
mtext("Area is proportional to Number of Passengers",1,line=1,adj=0,cex=1.25,font=3,outer=T)
dev.off()

