pdf_datei<-"karten_deutschland_choropleth_kreise_1x2.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=15,height=8)

par(omi=c(0.5,0,0,0), mai=c(0,6,1,1),family="Lato Light",las=1)
library(maptools)
library(RColorBrewer)

f0<-rgb(0,0,0,0,maxColorValue=255)
f1a<-rgb(68,90,111,50,maxColorValue=255)
f1b<-rgb(68,90,111,150,maxColorValue=255)
f1c<-rgb(68,90,111,250,maxColorValue=255)
f2a<-rgb(255,97,0,50,maxColorValue=255)
f2b<-rgb(255,97,0,150,maxColorValue=255)
f2c<-rgb(255,97,0,250,maxColorValue=255)

# zuerst die rechte Karte

x<-readShapeSpatial("daten/VG250_Kreise_Shapefile_UTM32_VZ_2011.shp")
kreisstrukturdaten<-read.xls("daten/konfession_vz_2011.xlsx",sheet=1)
n<-length(x)
nr<-as.numeric(as.character(x$RS))
position<-vector()
for (i in 1:n){
	position[i]<-match(nr[i], kreisstrukturdaten$AGS)
}
farb_nr<-cut(100*kreisstrukturdaten$RKAT[position]/ kreisstrukturdaten$BEV[position],c(0,50,70,90,100))
farbpalette<-c(f0,f1a,f1b,f1c)
plot(x,col=farbpalette[farb_nr],border=grey(.8),lwd=.3)

farb_nr<-cut(100*kreisstrukturdaten$EVANG[position]/ kreisstrukturdaten$BEV[position],c(0,50,70,90,100))
farbpalette<-c(f0,f2a,f2b,f2c)
plot(x,col=farbpalette[farb_nr],border=grey(.8),lwd=.3,add=T)

# dann die linke Karte

par(mai=c(0,0,0,7),plt=c(0,0.5,0,0.95),new=T)
x<-readShapeSpatial("daten/OGP86/SDE2_GERMAN1895ELECTORALDISTRICTS.shp")
kreisstrukturdaten<-read.xls("daten/ZA8145_1912.xlsx",sheet=1)
n<-length(x)
nr<-x$DISTRICT_N
position<-vector()
for (i in 1:n){
	position[i]<-match(nr[i], kreisstrukturdaten$wkr_nr)
}
farb_nr<-cut(kreisstrukturdaten$kat05p[position],c(0,50,70,90,100))
farbpalette<-c(f0,f1a,f1b,f1c)
plot(x,col=farbpalette[farb_nr],border=grey(.8),lwd=.3,xpd=T)

farb_nr<-cut(kreisstrukturdaten$ev05p[position], c(0,50,70,90,100))
farbpalette<-c(f0,f2a,f2b,f2c)
plot(x,col=farbpalette[farb_nr],border=grey(.8),lwd=.3,add=T,xpd=T)

# Betitelung

mtext("Evangelische und katholische Kreise 1905 ...",3,line=-2.75,adj=0.05,family="Lato Black",outer=T,cex=2,xpd=T)
mtext("... und 2011",3,line=-2.75,adj=0.65,family="Lato Black",outer=T,cex=2,xpd=T)
mtext("Karte 1905: geodata.tufts.edu (goo.gl/Lq3QU); Daten 1905: Schmädeke (GESIS: doi:10.4232/1.8145 ); Karte 2011: www.zensus2011.de; Daten 2011: www.destatis.de",1,line=-0.7,adj=0.04,cex=0.95,font=3,outer=T,xpd=T)

# zuletzt die Balkendiagramme als Legende

par(mai=c(0.75,5,5.5,9),fg="white",new=T)
kreisstrukturdaten<-read.xls("daten/ZA8145_1912.xlsx",sheet=1)

evangelisch<-kreisstrukturdaten[kreisstrukturdaten$ev05p>50,]
attach(evangelisch)
klassen<-c(50,70,90,100)
levels(klassen)<-c("50 bis 70 %","70 bis 90 %","über 90  %")
barplot(table(cut(ev05p,klassen)),col=farbpalette<-c(f2a,f2b,f2c),
	xlim=c(-150,150),names.arg=levels(klassen),main="",cex.axis=0.75,
	cex.names=0.75,cex.main=0.75,col.axis="black",col.main="red",horiz=T)
text(130,4.5,"evangelisch",pos=1,col="black",xpd=T,cex=1)

katholisch<-kreisstrukturdaten[kreisstrukturdaten$kat05p>50,]
attach(katholisch)
klassen<-c(50,70,90,100)
levels(klassen)<-c("50 bis 70 %","70 bis 90 %","über 90  %")
barplot(-table(cut(kat05p,klassen)),col=farbpalette<-c(f1a,f1b,f1c),
	names.arg=levels(klassen),main="",cex.axis=0.75,cex.names=0.75,
	cex.main=0.75,col.axis="black",col.main="red",horiz=T,add=T)
text(-120,4.5,"katholisch",pos=1,col="black",xpd=T,cex=1)

par(mai=c(0.75,13,5.5,1),fg="white",new=T)
kreisstrukturdaten<-read.xls("daten/konfession_vz_2011.xlsx",sheet=1)

evangelisch<-kreisstrukturdaten[kreisstrukturdaten$PEVANG>50,]
attach(evangelisch)
klassen<-c(50,70,90,100)
levels(klassen)<-c("50 bis 70 %","70 bis 90 %","über 90  %")
barplot(table(cut(PEVANG,klassen)),col=farbpalette<-c(f2a,f2b,f2c),
	xlim=c(-150,150),names.arg=levels(klassen),main="",cex.axis=0.75,
	cex.names=0.75,cex.main=0.75,col.axis="black",col.main="red",horiz=T)
text(130,4.5,"evangelisch",pos=1,col="black",xpd=T,cex=1)

katholisch<-kreisstrukturdaten[kreisstrukturdaten$PRKAT>50,]
attach(katholisch)
klassen<-c(50,70,90,100)
levels(klassen)<-c("50 bis 70 %","70 bis 90 %","über 90  %")
barplot(-table(cut(PRKAT,klassen)),col=farbpalette<-c(f1a,f1b,f1c),
	names.arg=levels(klassen),main="",cex.axis=0.75,cex.names=0.75,
	cex.main=0.75,col.axis="black",col.main="red",horiz=T,add=T)
text(-120,4.5,"katholisch",pos=1,col="black",xpd=T,cex=1)
dev.off()
