pdf_datei<-"karten_deutschland_plz_ausschnitt.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=10,height=10)

par(bg="darkolivegreen1",mai=c(0,0,0,0),oma=c(1,1.5,1,1),
	family="Lato Light",las=1)
library(maptools)
library(rgdal)

# Daten einlesen und Grafik vorbereiten

y<-readShapeSpatial("daten/PLZ/post_pl.shp",
	proj4string=CRS("+proj=longlat"))
x<-spTransform(y,CRS=CRS("+proj=merc"))
y<-subset(x,substr(x$PLZ99,1,3)=="539")

# Grafik erstellen

plot(y,col="darkblue",border="white",lwd=3)
text(getSpPPolygonsLabptSlots(y),labels=y$PLZ99,cex=1.5,
	col="white",family="Lato Bold")

# Betitelung

mtext("PLZ Grenzen, Bezirke 539..",side=3,line=-4,adj=0,cex=2.7,family="Lato Black")
mtext("Quelle: arnulf.us/PLZ",side=1,line=-1,adj=1,cex=1.3)
dev.off()
