pdf_datei<-"karten_tunesien_symbole.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=10,height=10)
DD_bg<-rgb(220,220,220,maxColorValue=255)

par(bg="lightskyblue1",mai=c(0,0,0,0),oma=c(0,0,0,0),family="Lato Light",las=1)
library(maptools)
library(rgdal)

# Daten einlesen und Grafik vorbereiten

tun<-readShapeSpatial("daten/TUN_adm/TUN_adm0.shp",
	proj4string=CRS("+proj=longlat"))
plot(tun,col="mintcream",border="white",lwd=3, xlim=c(8,14), ylim=c(32,38))
dza<-readShapeSpatial("daten/DZA_adm/DZA_adm0.shp",
	proj4string=CRS("+proj=longlat"))
plot(dza,col="burlywood1",border="white",lwd=3, add=T)
lby<-readShapeSpatial("daten/LBY_adm/LBY_adm0.shp",
	proj4string=CRS("+proj=longlat"))

# Grafik erstellen und weitere Elemente

plot(lby,col="burlywood1",border="white",lwd=3, add=T)

orte<-read.xls("daten/tunesien.xlsx")
attach(orte)
n<-nrow(orte)
for (i in 1:n)
{
text(long[i]+hoffset[i], lat[i]+voffset[i], ort[i], cex=1.75,col="black", 
	adj=adjust[i])
}
text(10.12, 36.43, "Tunis", cex=3, family="Lato Black")
text(12.5, 33.5, "Mittelmeer", adj=0, cex=2, family="Lato Regular", 
	col="darkblue")
text(7.25, 32, "ALGERIEN", adj=0, cex=2, family="Lato Black")
text(9,33, "TUNESIEN", adj=0, cex=2, family="Lato Black")
text(12, 32, "LIBYEN", adj=0, cex=2, family="Lato Black")

par(family="Datendesign")
text(long, lat, "a", cex=groesse, col="red")

# Betitelung

mtext("Unruhen in Tunesien",side=3,line=-4,adj=0.05,cex=2.7,family="Lato Black",col="black")

# separate Grafik

par(mai=c(6,6,0,0), bg="white",new=T)
data(wrld_simpl) 
w=wrld_simpl[wrld_simpl@data[,"NAME"] != "Antarctica",] 
m=spTransform(w,CRS=CRS("+proj=merc"))
plot(m,xlim=c(-900000,2800000),ylim=c(3300000,7000000),
	col=rgb(160,160,160,100,maxColorValue=255),border=F)
w=wrld_simpl[wrld_simpl@data[,"NAME"] == "Tunisia",] 
m=spTransform(w,CRS=CRS("+proj=merc"))
plot(m, add=T,col="red",border=F)
dev.off()

