pdf_datei<-"karten_welt_gapminder_regionen.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=8.4,height=6)

par(omi=c(0,0,0,0),mai=c(0,0.82,0.82,0),family="Lato Light",las=1)

library(maptools) # enthält wrld_simpl
library(rgdal) # für spTransform

# Daten einlesen und Grafik vorbereiten

data(wrld_simpl) 
w<-wrld_simpl[wrld_simpl@data[,"NAME"] != "Antarctica",] 
m<-spTransform(w,CRS=CRS("+proj=merc"))

laender<-m@data$ISO2
n<-length(laender) 
kartenfarben<-numeric(n) 

r1<-"Sub-Saharan Africa"
r2<-"South Asia"
r3<-"Middle East &amp; North Africa"
r4<-"America"
r5<-"Europe &amp; Central Asia"
r6<-"East Asia &amp; Pacific"

f1<-rgb(0,115,157,150,maxColorValue=255)
f2<-rgb(158,202,229,150,maxColorValue=255)
f3<-rgb(84,196,153,150,maxColorValue=255)
f4<-rgb(255,255,0,150,maxColorValue=255)
f5<-rgb(246,161,82,150,maxColorValue=255)
f6<-rgb(255,0,0,150,maxColorValue=255)

region<-c(r1,r2,r3,r4,r5,r6)
farbe<-c(f1,f2,f3,f4,f5,f6)

regionen<-read.xls("daten/gapminder/regionen.xlsx")

for (i in 1:length(region)) 
{
regionauswahl<-subset(regionen$ID,regionen$Group==region[i])
laenderauswahl<-NULL
for (j in 1:length(regionauswahl)) laenderauswahl<-c(laenderauswahl, trim(as.character(regionauswahl[j])))
for (j in 1:length(laenderauswahl))
{
kartenfarben[grep(paste("^",laenderauswahl[j],"$",sep=""),laender)]<-farbe[i]
} 
}

# Grafik erstellen

plot(m,col=kartenfarben,border=F)

# Betitelung

mtext("Colour by region",3,line=0,adj=0,cex=4,family="Lato Black")


dev.off()

