pdf_datei<-"radial_saeulendiagramme_inc.pdf"
cairo_pdf(bg=par("bg"), pdf_datei,width=9,height=9)

par(bg=rgb(0.8627,0.8627,0.8627))
par(omi=c(0,0,0,0),mai=c(0,2,0,0.5),family="Droid Sans Mono", col.lab=par("bg"))
library(plotrix)

# Daten einlesen und Grafik vorbereiten

source("skripte/inc_daten_radial_saeulendiagramm.r")
namen<-c("Rooms", 
		 "Dwelling", 
		 "Income", 
		 "Wealth", 
		 "Employment", 
		 "Unemployment", 
		 "Network", 
		 "Educational", 
		 "Reading", 
		 "Air", 
		 "Consultation", 
		 "Voter", 
		 "Life", 
		 "Health", 
		 "Satisfaction  ", 
		 "  Homicide", 
		 "Assault", 
		 "Long", 
		 "Children", 
		 "Time")

g1<-rgb(150,150,150,maxColorValue=255)
g2<-rgb(80,80,80,maxColorValue=255)
m<-rgb(180,180,180,maxColorValue=255)

n<-length(namen)
radialfarben<-rep(rgb(255,128,0,maxColorValue=255),n)
randfarben<-c(rep(g1,6),rep(g2,n-6))
mittefarben<-rep(m,n)

radial_mar<-c(7,7,7,7)

land<-daten["DEU",3:length(daten)]+1 
land[is.na(land)]<-1   

landdaten<-NULL

for (j in 1:length(land)) landdaten<-c(landdaten,list(0:as.numeric(land[j])))

# Grafik erstellen

radial.pie(datenrand,label.prop=1.35,show.grid.labels=F,radlab=T,
	boxed.radial=F,show.radial.grid=F,grid.bg=par("bg"),
	grid.col="white",labels=namen,sector.colors=randfarben,
	mar=radial_mar,radial.lim=c(0,11),xpd=T)

radial.pie(landdaten,label.prop=1.35,show.grid.labels=F,radlab=T,
	boxed.radial=F,show.radial.grid=T,grid.bg=par("bg"),
	grid.col="white",labels=namen,sector.colors=radialfarben,
	mar=radial_mar,radial.lim=c(0,11),xpd=T,add=T)

radial.pie(datenmitte,label.prop=1.35,show.grid.labels=F,radlab=T,
	boxed.radial=F,show.radial.grid=F,grid.bg=par("bg"),
	grid.col="white",labels=namen,sector.colors=mittefarben,
	mar=radial_mar,radial.lim=c(0,11),xpd=T,add=T)

par(family="Droid Sans Mono")
arctext("Economic Indicators",col="white",radius=12,start=1.3)
arctext("Social and Other Indicators",col="white",radius=12,start=4.3)
dev.off()



