pdf_datei<-"saeulendiagramme_1x4.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=12,height=6)

library(RColorBrewer)
par(mfrow=c(2,4),omi=c(0.5,0.5,0.75,0.5),mai=c(0.5,0.5,0.5,0.5),cex=1.1
	,family="Lato Light",las=1)
	
# Daten einlesen

source("skripte/0inc_datendesign_dbconnect.r")
sql<-"select * from v_za4972_laender"
datensatz<-dbGetQuery(con,sql)
attach(datensatz)

# Grafiken erstellen und weitere Elemente

grenzen<-c(0,1.5,2,2.5,3)
barplot(table(cut(v84,grenzen)),col=brewer.pal(4,"Reds"), ylim=c(0,20), 
	names.arg=table(cut(v84,grenzen)),axes=F,
	main="Life Satisfaction")
grenzen<-c(0,1.5,2,2.5,3)
barplot(table(cut(v85,grenzen)),col=brewer.pal(4,"Greens"), ylim=c(0,20),
	names.arg=table(cut(v85,grenzen)),axes=F,
	main="Situation:\nArea you live in")
grenzen<-c(-0.1,0,0.1,0.2,0.3)
barplot(table(cut(v100,grenzen)),col=brewer.pal(4,"Blues"), ylim=c(0,20),
	names.arg=table(cut(v100,grenzen)),axes=F,
 	main="Expectations:\nArea you live in")
grenzen<-c(-0.6,-0.4,0,0.2,0.4)
barplot(table(cut(v114,grenzen)),col=brewer.pal(4,"Purples"), ylim=c(0,20),
	names.arg=table(cut(v114,grenzen)),axes=F,
	main="Change 5 years:\nLife in general")
par(family="Lato", cex=0.7)
plot.new()
bez<-c("0.0 to 1.5","1.5 to 2.0","2.0 to 2.5","2.5 to 3.0")
legend("center",bez,cex=2.05,border=F,bty="n",
	fill= brewer.pal(4,"Reds"),y.intersp=1.3)
plot.new()
bez<-c("0.0 to 1.5","1.5 to 2.0","2.0 to 2.5","2.5 to 3.0")
legend("center",bez,cex=2.05,border=F,bty="n",
	fill= brewer.pal(4,"Greens"),y.intersp=1.3)
plot.new()
bez<-c("−0.1 to ±0.0","±0.0 to +0.1","+0.1 to +0.2","+0.2 to +0.3")
legend("center",bez,cex=2.05,border=F,bty="n",
	fill= brewer.pal(4,"Blues"),y.intersp=1.3)
plot.new()
bez<-c("−0.6 to −0.4","−0.4 to ±0.0","±0.0 to +0.2","+0.2 to +0.4")
legend("center",bez,cex=2.05,border=F,bty="n",
	fill= brewer.pal(4,"Purples"),y.intersp=1.3)

# Betitelung

mtext("Eurobarometer 71.2: Number of countries",3,line=1,adj=0,cex=2.15,family="Lato Black",outer=T)
mtext("mean values of response categories",1,line=1,adj=0,cex=1.25,font=3,outer=T)
mtext("Source: Eurobarometer 71.2",1,line=1,adj=1.0,cex=1.25,font=3,outer=T)
dev.off()
