pdf_datei<-"streudiagramme_drei_punkte.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=14,height=9)

par(mai=c(2,1,1,1),omi=c(0,0,0,0),xpd=T,family="Lato Light",las=1)

# Daten definieren und Grafik vorbereiten

namen<-c("BMW:\n44,6 Mrd.","Daimler:\n45,5 Mrd.","","Facebook:\n75-100 Mrd.")
wert<-c(44.6,45.5,100,75)
umsatz<-c(60.5,97.8,2.5,2.5)
gewinn<-c(4.8,4.7,1,1)

f1<-rgb(80,80,80,maxColorValue=255)
f2<-rgb(255,97,0,maxColorValue=255)
f3<-"grey"
f4<-rgb(58,87,151,maxColorValue=255)

# Grafik definieren und weitere Elemente

plot(umsatz,gewinn,axes=F,type="n",
	xlab="Umsatz (Jahreszahlen)",
	ylab="Gewinn (Jahreszahlen)",
	xlim=c(-20,100),ylim=c(-1,6),cex.lab=1.5)
for (i in 1:3) 
{
arrows(umsatz[i],-1,umsatz[i],gewinn[i],length=0.10,lty="dotted",
	angle=10,code=0,lwd=1,col="grey70")
arrows(-20,gewinn[i],umsatz[i],gewinn[i],length=0.10,lty="dotted",
	angle=10,code=0,lwd=1,col="grey70")
}
points(umsatz,gewinn,pch=19,cex=wert/2.6,col=c(f1,f2,f3,f4))
text(umsatz,gewinn,namen,col="white",cex=1.3)
axis(1,at=c(2.5,60.5,97.8),labels=c("2.5*","60.5","97.8"),cex.axis=1.25)
axis(2,at=c(1,4.8),labels=c("1.0","4.8\n4.7"),cex.axis=1.25)
text(-25.5,5.08,"**")
text(-26.5,1.08,"*")

# Betitelung

mtext(line=1,"Facebook, BMW und Daimler im Vergleich",cex=3.5,adj=0,family="Lato Black")
mtext(line=-1,"Gewinn, Umsatz und Börsenwert (Kreisgröße, Stand: 30.01.2012)",cex=1.75,adj=0,font=3)
mtext(line=-3,"alle Angaben in Mrd. Euro",cex=1.75,adj=0,font=3)
mtext(side=1,line=6.5,"Quelle: www.spiegel.de",cex=1.75,adj=1,font=3)
mtext(side=1,line=4.5,"* Geschätzt ",cex=1.75,adj=0)
mtext(side=1,line=6.5,"** Ergebnis vor Steuern",cex=1.75,adj=0)
dev.off()
