pdf_datei<-"streudiagramme_pfad_ellipse.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=10,height=10)

source("skripte/0inc_datendesign_dbconnect.r")
par(mai=c(1,1,0.25,0.25),omi=c(1,0.5,1,0.5), mgp=c(4,1,0),
	family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

sql<-"select * from gemeinden"
dataset<-dbGetQuery(con,sql)
attach(dataset)
auswahl<-subset(dataset,bevinsg >= 12000 & bevinsg <= 16000)
attach(auswahl)
library(ellipse)
mx<-mean(bevm)
my<-mean(bevw)
mxy<-c(mx,my)
sxy<-sapply(auswahl[,c("bevm","bevw")],sd)
r<-cor(bevm,bevw)

# Grafik definieren und weitere Elemente

plot(bevm,bevw,type="n",axes=F,xlab="Anzahl Männer",ylab="Anzahl Frauen",
	xlim=c(4000,9000),ylim=c(4000,9000))
lines(ellipse(r,scale=sxy,centre=mxy))
abline(v=seq(4000,9000,by=1000),col="black",lty=3,lwd=1) 
abline(h=seq(4000,9000,by=1000),col="black",lty=3,lwd=1) 
axis(1,cex.axis=1.2,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)
axis(2,cex.axis=1.2,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)
symbols(bevm,bevw,bg="red",circles=rep(2,nrow(auswahl)),inches=0.15,
	add=T,xpd=T,fg="white")
auswahl2<-subset(auswahl,bevm >= 7500 & bevw <= 6500)
attach(auswahl2)
text(bevm,bevw,iconv(gemeinde,"LATIN1","UTF-8"),family="Lato Black",
	pos=3,offset=1.1)
text(182.5,52,"Mittlere Körpergröße: 182 cm",adj=0,font=3)

# Betitelung

mtext("Anzahl Männer und Frauen in Deutschland",3,adj=0,line=1.5,cex=2.5,family="Lato Black",outer=T)
mtext("Gemeinden zwischen 12.000 und 16.000 Einwohner",3,adj=0,line=-0.25,cex=1.5,font=3,outer=T)
mtext("Quelle: Gemeindeverzeichnis Informationssystem (GV-ISys)",1,line=2,adj=1,cex=1.25,font=3,outer=T)
dev.off()
