pdf_datei<-"zeitreihen_monatswerte_2x1.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=9,height=6.2)

source("skripte/0inc_datendesign_dbconnect.r")
par(omi=c(0.65,0.55,0.55,0.25),mai=c(0.25,0.25,0.25,0.25),mfcol=c(2,1),
	family="Lato Light",las=1)

# Daten einlesen

sql<-"select dezjahr,v8,v9,v11,v12 from t_za2391_zeitreihen"
dataset<-dbGetQuery(con,sql)
attach(dataset)

# Grafiken definieren und weitere Elemente

plot(type="n",xlab="",ylab="Mittelwert",dezjahr, v8,
	col=rgb(255,97,0,150,maxColorValue=255),lwd=2,ylim=c(-2.5,2.5))
vars1<-c("dezjahr","v8")
vars2<-c("dezjahr","v9")
farbe1<-rgb(255,0,0,150,maxColorValue=255)
farbe2<-rgb(0,0,0,150,maxColorValue=255)
points(dataset[vars1],col=farbe1,lwd=1,type="l")
points(dataset[vars2],col=farbe2,lwd=1,type="l")
text(2007.5,0,"SPD",col=farbe1)
text(2007.5,2,"CDU",col=farbe2)

plot(type="n",xlab="",ylab="Mittelwert",dezjahr, v8,
	col=rgb(255,97,0,150,maxColorValue=255),lwd=2,ylim=c(-2.5,2.5))
vars3<-c("dezjahr","v11")
vars4<-c("dezjahr","v12")
farbe3<-"orange"
farbe4<-rgb(0,128,0,150,maxColorValue=255)
points(dataset[vars3],col=farbe3,lwd=1,type="l")
points(dataset[vars4],col=farbe4,lwd=1,type="l")
text(2007.5,1,"FDP",col=farbe3)
text(2007.5,-0.5,"Grüne",col=farbe4)

# Betitelung

mtext("Skalometer SPD, CDU, FDP, Grüne: 1977–2007",3,line=0,adj=0,cex=1.5,family="Lato Black",outer=T)
mtext("Monatswerte. Quelle: ZA2391 Partielle Kumulation der  Politbarometer West 1977-2007",1,line=3,adj=1.0,cex=0.95,font=3)
dev.off()

