pdf_datei<-"histogramme_ueberlagert.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11,height=7)

source("skripte/0inc_datendesign_dbconnect.r")
par(omi=c(0.75,0.2,0.75,0.2),mai=c(0.25,1.25,0.25,0.25),
	family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

sql<-"select * from v_frauen_maenner"
dataset<-dbGetQuery(con,sql)
attach(dataset)
col1<-rgb(191,239,255,180,maxColorValue=255)
col2<-rgb(255,0,210,80,maxColorValue=255)
brandenburg<-subset(dataset,bundesland == 'Brandenburg')

# Grafik erstellen

hist(brandenburg$wm,col=col1,xlim=c(0.9,1.2),border=F,main='',
	xlab="Verhältnis",ylab="Anzahl Kreise",axes=F)
axis(1,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)
axis(2,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)
rp<-subset(dataset,bundesland == 'Rheinland-Pfalz')
hist(rp$wm,col=col2,xlim=c(0.9,1.2),border=F,add=T,main='')
legend("right",c("Brandenburg","Rheinland-Pfalz"),border=F,
	pch=15,col=c(col1,col2),bty="n",cex=1.25,xpd=T,ncol=1)

# Betitelung

mtext("Verteilung Frauen-Männer-Verhältnis Brandenburg und Rheinland-Pfalz",3,line=1.8,adj=0,family="Lato Black",cex=1.5,outer=T)
mtext("Auf 100 Männer kommen zwischen 95 und 115 Frauen",3,line=-0.2,adj=0,font=3,cex=1.2,outer=T)
mtext("Quelle: Bundeswahlleiter",1,line=2,adj=1.0,font=3,cex=1.2,outer=T)
dev.off()

