pdf_datei<-"karten_deutschland_orte_punkte_umriss_1x2.pdf"
cairo_pdf(bg="lavender", pdf_datei,width=12,height=6)

par(mai=c(0,0,0,0), omi=c(0.15,0.25,0.55,0.25),mfcol=c(1,2),
	family="Lato Light",las=1)
library(sp); library(RColorBrewer); library(geoR)
source("skripte/0inc_datendesign_dbconnect.r")

# Daten einlesen und Grafik vorbereiten

sql<-"select * from v_ufos"
dataset<-dbGetQuery(con,sql)
dataset$jahr<-as.numeric(dataset$jahr)
attach(dataset)

jahr1<-2006; jahr2<-2012

jahr1id<-subset(dataset,jahr == jahr1 & Identifikation != "-")
jahr1ui<-subset(dataset,jahr == jahr1 & Identifikation == "-")

jahr2id<-subset(dataset,jahr == jahr2 & Identifikation != "-")
jahr2ui<-subset(dataset,jahr == jahr2 & Identifikation == "-")

daten<-c(jahr1ui,jahr2ui,jahr1id,jahr2id)
con<-url("http://gadm.org/data/rda/DEU_adm1.RData")
load(con)
farbe<-"linen"
farbe_uid<-rgb(128,0,0,200,maxColorValue=255)
farbe_id<-rgb(0,153,0,120,maxColorValue=255)

# Grafik erstellen und weitere Elemente

plot(gadm,border="white",col=farbe)
par(family="Quivira")
text(jitterDupCoords(cbind(jahr1ui$lng,jahr1ui$lat),max=0.01),
	"👽",col=farbe_uid,cex=2.3)
points(jitterDupCoords(cbind(jahr1id$lng,jahr1id$lat),max=0.01),
	pch=15,col=farbe_id,cex=1.6)

mtext("👽", side=1, line=-3, col=farbe_uid, cex=1.5, adj=0)
mtext("◼", side=1, line=-1.9, col=farbe_id, cex=1.15, adj=0)
par(family="Lato Light")
mtext("nicht identifiziert", side=1, line=-3, cex=1.1, adj=0.05)
mtext("identifiziert", side=1, line=-2, cex=1.1, adj=0.05)

text(5,53,jahr1,cex=2.7,col="azure4")

plot(gadm,border="white",col=farbe)
par(family="Quivira")
text(jitterDupCoords(cbind(jahr2ui$lng,jahr2ui$lat),max=0.01),
	"👽",col=farbe_uid,cex=2.3)
par(family="Lato Light")
points(jitterDupCoords(cbind(jahr2id$lng,jahr2id$lat),max=0.01),
	pch=15,col=farbe_id,cex=1.6)
text(5,53,jahr2,cex=2.7,col="azure4")

# Betitelung

mtext("UFO-Sichtungen in Deutschland",line=0,adj=0,cex=2.2,family="Lato Black",outer=T)
mtext("Quelle: www.ufo-datenbank.de",side=1,line=-1,adj=1,cex=0.9,font=3,outer=T)
dev.off()

