pdf_datei<-"zeitreihen_saeulen_anteile_wachstum.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11,height=9)

par(las=1,cex=0.9,omi=c(0.75,0.5,1.25,0.5),mai=c(0.5,1,0,1),
	family="Lato Light",las=1)

# Daten definieren

daten<-c(25296,28365,32187,36835,39788,44282,51122,60420,58437,62484)/1000
beschriftung<-c(2002:2011)
zuwachs<-0
for (i in 2:length(daten)) zuwachs<-c(zuwachs,daten[i]-daten[i-1])
wertlinks<-daten-zuwachs

x<-rbind(t(daten),t(daten))
y<-rbind(t(wertlinks),rep(0,length(daten)))
f1<-"darkgreen"; f2<-"grey60"
farben<-c(f1,f2)
for (i in 1:length(daten)-1) farben<-c(farben,f1,f2)

for (i in 1:length(daten))
{
if (y[1,i]>x[1,i]) 
{
	tmp<-x[1,i]; x[1,i]<-y[1,i]; y[1,i]<-tmp
	farben[(2*i)-1]<-"darkred"
}
}

# Grafiken erstellen und weitere Elemente

barplot(x,beside=T,border=NA,col=farben,space=c(0,2),axes=F)
barplot(y,beside=T,border=NA,col=rep("grey60",2*length(daten)),
	add=T,names.arg=beschriftung,space=c(0,2),axes=F)
axis(2,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)

hoehe<-0.1*max(daten)
j<-1
k<-j
for (i in 1:length(daten))
{
if (j > 1) k<-k+4 
text(k+1.3,hoehe,format(round(x[2,i]),nsmall=0),cex=1.25,adj=0,xpd=T,
	col="white")
j<-j+3
if (i<length(daten)) text(k+3.1,y[1,i+1]+((x[1,i+1]-y[1,i+1])/2), 
	format(round(zuwachs[i+1],1),cex=0.75,nsmall=1),adj=0)
}

# Betitelung

mtext("Umsatzentwicklung Microsoft",3,line=4,adj=0,family="Lato Black",outer=T,cex=2)
mtext("Angaben in Mrd. US-Dollar",3,line=1,adj=0,cex=1.35,font=3,outer=T)
mtext("Quelle: Layout nach claro Geschäftsbericht 2007/08, Daten: money.cnn.com",1,line=2,adj=1.0,cex=1.1,font=3,outer=T)
dev.off()
