pdf_datei<-"zeitreihen_seasonalsubseries_inc.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=8,height=8)
par(omi=c(1,0,1,0.5),mai=c(2,0.80,0,0.5),family="Lato Light",las=1)


# Daten einlesen und Grafik vorbereiten

source("skripte/0inc_datendesign_dbconnect.r")
sql<-"select month(STR_TO_DATE(Woche,'%b %d %Y')) monat,
	  year(STR_TO_DATE(Woche,'%b %d %Y')) jahr,
	  avg(chicken_soup) chicken_soup 
	  from google_trends 
	  group by month(STR_TO_DATE(Woche,'%b %d %Y')),
	  		   year(STR_TO_DATE(Woche,'%b %d %Y')) 
	  order by jahr,monat"
dataset<-dbGetQuery(con,sql)
attach(dataset)
y<-ts(chicken_soup,frequency =12,start=c(2004,1))

# Grafik erstellen

monthplot(y,axes=F,box=F,type="h",lwd=3,col="darkred",
	ylab="Normalized Search Activity")
axis(2,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)

# Betitelung

mtext("Google Trend für 'chicken soup': Saisonfigur",3,line=2,adj=0,cex=2.0,family="Lato Black",outer=T)
mtext("Jan 2004 bis Feb 2012, Wochenwerte",3,line=0,adj=0,cex=1.5,font=3,outer=T)
mtext("Quelle: www.google.com/trends",1,line=3,adj=1.0,cex=0.95,font=3,outer=T)
dev.off()
