pdf_datei<-"grafiktabellen_treemap.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11.69,height=7.5)

par(omi=c(0.65,0.25,1.25,0.75),mai=c(0.3,2,0.35,0),
	family="Lato Light",las=1)  
library(treemap)

# Daten einlesen

bundeshaushalt<-read.xls("daten/bundeshaushalt.xlsx",sheet=1)

# Grafik definieren und erstellen

plot.new()
treemap(bundeshaushalt,title="",index="Titel",type="index",
	vSize="Ausgaben",palette="YlOrRd",aspRatio=1.9,inflate.labels=T)

# Betitelung

mtext("Bundeshaushalt 2011",3,line=3.8,adj=0,cex=2.2,family="Lato Black",outer=T)
mtext("Anteile der Ausgaben einzelner Titel",3,line=2.3,adj=0,cex=1.5,outer=T,font=3)
mtext("Quelle: bund.offenerhaushalt.de",1,line=1,adj=1.0,cex=0.95,outer=T,font=3)
dev.off()
