# inc_prognoseintervall_05.r
Land<-subset(UNPop,UNPop$Country==auswahl[i] & UNPop$Variant=="Medium variant")
Prognosen<-subset(UNPop,UNPop$Country == auswahl[i] & Year >= 2010)
Prognose_L<-subset(Prognosen,Prognosen$Variant=="Low variant")$Value/1000
Prognose_M<-subset(Prognosen,Prognosen$Variant=="Medium variant")$Value/1000
Prognose_H<-subset(Prognosen,Prognosen$Variant=="High variant")$Value/1000
Jahre<-seq(2010,2100,by=5)
attach(Land)

plot(axes=F,type="n",xlab="",ylab="",Year,Value/1000,
	ylim=c(ymin[[i]],ymax[[i]]))
axis(1,tck=-0.01,col="grey",at=c(1950,2010,2100),cex.axis=1.2) 
axis(2,tck=-0.01,col="grey",at=py<-pretty(c(Prognose_L,
	Value/1000,Prognose_H)),labels=format(py,big.mark="."),
	cex.axis=1.2) 

xx<-c(Jahre,rev(Jahre))
yy<-c(Prognose_H,rev(Prognose_L))
polygon(xx,yy,col=rgb(68,90,111,50,maxColorValue=255),border=F)

lines(Year,Value/1000,col="grey",lwd=2)
lines(Jahre,Prognose_H,col="black",lwd=2)
lines(Jahre,Prognose_L,col="orange",lwd=2)
lines(Jahre,Prognose_M,col="white",lwd=2)