pdf_datei<-"karten_deutschland_streudiagramm.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=8,height=11)

par(mai=c(1.1,0,0,0),omi=c(0.25,0.5,0.75,0.5),family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

source("skripte/0inc_datendesign_dbconnect.r")
sql<-"select * from v_frauen_maenner"
dataset<-dbGetQuery(con,sql)
attach(dataset)

legmaxgroesse<-max(transbev); legmaxwert<-max(bevinsg)
legmaxbez<-dataset[which(dataset$transbev==legmaxgroesse),"gemeinde"]
if (length(legmaxbez) > 1) 
{
n<-length(legmaxbez)
for (i in 2:n) legmaxbez<-c(legmaxbez,paste(",",legmaxbez[i,]))
}
legmidgroesse<-quantile(transbev,0.5); legmidwert<-quantile(bevinsg,0.5)

# Grafik definieren und weitere Elemente

plot(lng,lat,type="n",axes=F,xlab="",ylab="")
niedrig<-subset(dataset,wm < 0.90)
mittel<-subset(dataset,wm >= 0.90 & wm <= 1.10)
hoch<-subset(dataset,wm > 1.10)

f1<-rgb(0,191,255,200,maxColorValue=255)
f2<-rgb(150,150,150,80,maxColorValue=255)
f3<-rgb(128,0,0,200,maxColorValue=255)

attach(niedrig)
points(lng,lat,pch=19,col=f1,cex=transbev)
attach(mittel)
points(lng,lat,pch=19,col=f2,cex=transbev)
attach(hoch)
points(lng,lat,pch=19,col=f3,cex=transbev)

l1<-paste("Max.: ",format(legmaxwert,digits=2),
	" Mio. (",legmaxbez,")",sep="")
l2<-paste("Median: ",format(legmidwert,digits=2)," Mio.",sep="")
legend(6.2,47.1,c(l1,l2),text.col="azure4",
	title="Punktgröße: Bevölkerungszahl",title.adj=0.3,border=F,
	pch=19,col=rgb(150,150,150,80,maxColorValue=255),bty="n",
	cex=1.1,pt.cex=c(legmaxgroesse,legmidgroesse),xpd=T,ncol=2)
legend(13,50.25,text.col="azure4",
	c("weniger als 90 Frauen","90 bis 110 Frauen","über 110 Frauen"),
	title="auf 100 Männer kommen",title.adj=0,pt.cex=1,xpd=T,
	border=F,pch=19,col=c(f1,f2,f3),bty="n",cex=0.8)

# Betitelung

mtext("Männer-/Frauenverhältnis in Deutschland 2005",line=0,adj=0,cex=1.8,family="Lato Black",outer=T)
mtext("Quelle: www.destatis.de, opengeodb.giswiki.org, www.lichtblau-it.de",side=1,line=-1,adj=1,cex=0.9,font=3,outer=T)
dev.off()
