pdf_datei<-"karten_nrw_symbole.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=8,height=6.5)

par(mai=c(0.5,0.0,0.0,0.5),omi=c(0,0.5,0.75,0),family="Lato Light") 
library(sp); library(plotrix)

# Daten einlesen und Grafik vorbereiten

akwnrw<-read.xls("daten/akwnrw.xlsx",head=T)
x<-akwnrw$long; y<-akwnrw$lat
dm<-rep(0.2,length(x))
akw<-function(x,y,dm,... ){
floating.pie(x,y,c(1,1,1,1,1,1),radius=dm,startpos=45,border=F,
	col=c("yellow","black","yellow","black","yellow","black"))
points(x,y,pch=19,cex=2,col="yellow")
points(x,y,pch=19,cex=1,col="black")
}
con<-url("http://gadm.org/data/rda/DEU_adm1.RData")
load(con)
nrw<-gadm[gadm$NAME_1=="Nordrhein-Westfalen",]

# Grafik erstellen

plot(nrw,border="black",axes=F,lwd=0.5)
n<-length(x)
for (i in 1:n) akw(x[i],y[i],dm[i])
text(akwnrw$namlong,akwnrw$namlat-0.2,akwnrw$Name,xpd=T)

# Betitelung

mtext("Atomland Nordrhein-Westfalen",3,line=1,adj=0,cex=2,family="Lato Black",outer=T)
mtext("wichtige Betriebe der Atomwirtschaft sind in NRW beheimatet",3,line=-0.5,adj=0,cex=1.25,font=3,outer=T)
mtext("Quelle: www.bund-nrw.de",1,line=-1,adj=1.0,cex=0.95,font=3)
dev.off()
