pdf_datei<-"karten_welt_orthodrome.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=13.75,height=8)

par(omi=c(0.5,0.5,1.25,0.5),mai=c(0,0,0,0),lend=1,bg="antiquewhite",family="Lato Light") 
library(mapdata) 
library(geosphere)

# Daten einlesen und Grafik vorbereiten

proj.typ<-"mercator"
proj.orient<-c(90,0,30)
x<-map(proj=proj.typ,orient=proj.orient,wrap=T) 

# Grafik erstellen und weitere Elemente

plot(x,xlim=c(-3,3),ylim=c(-1,2),type="n",axes=F,xaxs="i",yaxs="i")
rect(-3,-1,3,3,col="aliceblue",border=NA)
map("worldHires","Germany",fill=T,add=T,col="antiquewhite",
    proj=proj.typ,orient=proj.orient)
lines(x,col="darkgrey")
data(world.cities)
daten<-read.xls("daten/orthodat.xlsx")
attach(daten)
 
tfarbe<-rgb(128,128,128,100,maxColorValue=255)
for (i in 1:nrow(daten))
{
start<-world.cities[11769,] # Frankfurt
ziel<-subset(world.cities,name==stadt[i] & country.etc==land[i])
gc1<-gcIntermediate(c(start$long,start$lat),c(ziel$long,ziel$lat),
    addStartEnd=T, n=50)
merc<-mapproject(gc1[,1],gc1[,2],projection=proj.typ,
    orientation=proj.orient) 
lines(merc$x,merc$y,lwd=10,col=tfarbe)
 
zielp<-mapproject(ziel$long,ziel$lat,proj=proj.typ,orient=proj.orient)
points(zielp,col="darkred",pch=19,cex=2)
}
startp<-mapproject(start$long,start$lat,proj=proj.typ,orient=proj.orient)
points(startp,col="darkblue",pch=19,cex=2)

# Betitelung

mtext("Zielflughäfen des Airbus A380 (Lufthansa)",3,line=3,adj=0,cex=3,family="Lato Black",outer=T)
mtext("Stand: August 2013",3,line=1,adj=0,cex=1.75,font=3,outer=T)
mtext("Quelle: de.wikipedia.org/wiki/Lufthansa",1,line=0.8,adj=1.0,cex=1.25,font=3)
dev.off()
