pdf_datei<-"zeitreihen_fehlende_werte.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=13,height=9)

par(omi=c(0.65,0.75,0.95,0.75),mai=c(0.9,0.85,0.25,0.02),
	bg="antiquewhite2",family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

daten<-read.xls("daten/Arbeitszeitdaten.xls")
farbe<-rgb(139,35,35,maxColorValue=255)
y<-ts(daten$v1,start=1850,frequency=1)

# Grafik definieren

plot(y,typ="n",axes=F,xlim=c(1850,2010),ylim=c(35,85),xlab="",ylab="Stunden")

# weitere Elemente

axis(1,cex.axis=1.25)
axis(2,cex.axis=1.25,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)

hoehen<-c(40,50,60,70,80)
n<-length(hoehen)
for (i in 1:n) segments(1850,hoehen[i],2000,hoehen[i],col="white")
text(1905,68,"Großbritannien",col=farbe,cex=1.5)

ptyp=19
source("skripte/inc_fehlende_werte.r")

farbe<-rgb(39,139,16,maxColorValue=255)
y<-ts(daten$v2,start=1850,frequency=1)
source("skripte/inc_fehlende_werte.r")
text(1960,38,"Frankreich",col=farbe,cex=1.5)

farbe<-rgb(0,0,139,maxColorValue=255)
y<-ts(daten$v3,start=1850,frequency=1)
source("skripte/inc_fehlende_werte.r")
text(1872,52,"Deutschland",col=farbe,cex=1.5)

farbe<-rgb(205,149,12,maxColorValue=255)
y<-ts(daten$v4,start=1850,frequency=1)
source("skripte/inc_fehlende_werte.r")
text(1990,44,"Belgien",col=farbe,cex=1.5)

# Betitelung

mtext("Entwicklung der wöchentlichen Arbeitszeit 1850–2010",3,line=0.2,adj=0,cex=2.6,family="Lato Black",outer=T)
mtext("Jahreswerte",3,line=-2,adj=0,cex=2,font=3,outer=T)
mtext("Quelle: Sonderauswertung",1,line=0,adj=1,cex=1.25,font=3,outer=T)
dev.off()

