pdf_datei<-"zeitreihen_tageswerte.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=10,height=8.27)

par(cex.axis=1.1,omi=c(1,0.5,0.95,0.5),mai=c(0.1,1.25,0.1,0.2),
	mgp=c(5,1,0),family="Lato Light",las=1) 

# Daten einlesen

weihnachten<-read.csv(file="daten/allyears.calendar.byday.dat.a",head=F,sep=" ",dec=".")
attach(weihnachten)

# Grafik erstellen

plot(axes=F,type="n",xlab="",ylab="Anzahl Todesfälle",V1,V2)

# weitere Elemenete 

axis(1,tck=-0.01,col="grey",cex.axis=0.9,at=V1[c(1,length(V1))],
	labels=c("01. Juli","30. Juni")) 
axis(2,at=py<-pretty(V2),labels=format(py,big.mark="."),cex.axis=0.9,
	col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)
points(V1,V2,type="l")
points(lowess(V2,f=1/5),type="l",lwd=25,col=rgb(255,97,0,70,maxColorValue=255))
text(123,V2[179],"Weihnachten",cex=1.1)
arrows(157,V2[179],172,V2[179],length=0.10,angle=10,code=0,lwd=2,
	col=rgb(100,100,100,100,maxColorValue=255))
arrows(192,V2[185],220,V2[185],length=0.10,angle=10,code=0,lwd=2,
	col=rgb(100,100,100,100,maxColorValue=255))
text(240,V2[185],"Neujahr",cex=1.1)

# Betitelung

mtext("Todesrisiko Weihnachten und Neujahr 1979–2004 (USA)",3,line=1.5,adj=0,cex=2,family="Lato Black",outer=T)
mtext("Anzahl der Todesfälle vor Erreichen der Notaufnahme , Summen der Jahre pro Tag",3,line=-0.2,adj=0,cex=1.35,font=3,col="black",outer=T)
mtext("Quelle: David Phillips, Gwendolyn E. Barker, Kimberly M. Brewer, Christmas and New Year as risk factors for death, Social Science & Medicine 71 (2010) 1463-1471",1,line=3,adj=1,cex=0.75,font=3,outer=T)
dev.off()

