pdf_datei<-"streudiagramme_bereiche.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11.69,height=9)


par(mai=c(0.85,1,0.25,0.25),omi=c(1,0.5,1,0.5),family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

personen<-read.xls("daten/personen.xlsx")
attach(personen)
daten<-subset(personen,w>0 & s=="m" & name!="Max Schmeling")
attach(daten)

# Grafik definieren und weitere Elemente

plot(type="n",xlab="Körpergröße (cm)",ylab="Gewicht (kg)",h,w,
	xlim=c(160,220),ylim=c(50,125),axes=F)
axis(1,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)
axis(2,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)

f1<-rgb(255,0,210,maxColorValue=255)
f2<-rgb(0,208,226,100,maxColorValue=255)

p1<-subset(daten[c("h","w")],w>20*(h/100*h/100) & w<25*(h/100*h/100))
p2<-subset(daten[c("h","w")],w<20*(h/100*h/100))
p3<-subset(daten[c("h","w")],w>25*(h/100*h/100))

bez2<-as.matrix(subset(name,w<20*(h/100*h/100)))
bez3<-as.matrix(subset(name,w>25*(h/100*h/100)))

symbols(p1,bg=f1,fg="white",circles=rep(1,nrow(p1)),inches=0.25,add=T)
symbols(p2,bg=f2,fg="white",circles=rep(1,nrow(p2)),inches=0.25,add=T)
symbols(p3,bg=f2,fg="white",circles=rep(1,nrow(p3)),inches=0.25,add=T)

text(p2,bez2,cex=0.75,pos=1,offset=1.1,family="Lato Black")
text(p3,bez3,cex=0.75,pos=3,offset=1.1,family="Lato Black")

curve(20*(x/100*x/100),xlim=c(160,220),add=T)
curve(25*(x/100*x/100),xlim=c(160,220),add=T)

abline(v=mean(h,na.rm=T),lty=3)
abline(h=mean(w,na.rm=T),lty=3)
text(182.5,52,"Mittlere Körpergröße: 182 cm",adj=0,font=3)
text(222,80,"Mittleres Gewicht: 78 kg",adj=1,font=3)

# Betitelung

mtext("Zusammenhang zwischen Körpergröße und Gewicht",3,adj=0,line=2,cex=2.1,outer=T,family="Lato Black")
mtext("ausgewählte Prominente",3,adj=0,line=0,cex=1.4,outer=T,font=3)
mtext("Quelle: celebrityheights.com, howmuchdotheyweigh.com",1,line=1,adj=1,cex=0.95,outer=T,font=3)
dev.off()

