pdf_datei<-"zeitreihen_saeulen_entwicklung.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=6,height=9)

par(las=1,cex=0.9,omi=c(0.75,0.25,1.25,0.25),mai=c(0.5,0.25,0.5,0.75),
	family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

daten<-c(25296,28365,32187,36835,39788,44282,51122,60420,58437,62484)/1000
beschriftung<-c(2002:2011)
farben<-c(rep("olivedrab",length(daten)-1),"darkred")

# Grafik erstellen und weitere Elemente

barplot(daten,border=NA,col=farben,names.arg=substr(beschriftung,3,4),
	axes=F,cex.names=0.8)
abline(h=c(10,20,30,40,50,60,70,80),col=par("bg"),lwd=1.5) 
axis(4,at=c(0,20,40,60))
text(11.5,daten[10]+0.025*daten[10],format(round(daten[10]),nsmall=1),
	adj=0.5,xpd=T,col="darkgrey")

# Betitelung

mtext("Umsatzentwicklung Microsoft",3,line=4,adj=0,family="Lato Black",outer=T,cex=2)
mtext("2002–2011, Angaben in Mrd. US-Dollar",3,line=1,adj=0,cex=1.35,font=3,outer=T)
mtext("Quelle: money.cnn.com",1,line=2,adj=1.0,cex=1.1,font=3,outer=T)
dev.off()

