pdf_datei<-"zeitreihen_spannweiten.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=9,height=9)

par(omi=c(0.75,0.5,1,0.5),mai=c(0.5,1.25,0.5,0.1),mgp=c(4.5,1,0),
	family="Lato Light",las=1)    

# Daten einlesen und Grafik vorbereiten

daten<-read.xls("daten/histat_Studien.xlsx")
attach(daten)
n<-nrow(daten)
farbe<-rgb(240,24,24,30,maxColorValue=255)

# Grafik definieren und weitere Elemente

plot(1:1,type="n",axes=F,xlab="Beginn und Ende der Studie",ylab="Anzahl",
	xlim=c(min(von),max(bis)),ylim=c(log10(min(Anzahl_Zeitreihen)),
	log10(max(Anzahl_Zeitreihen))))
axis(1,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)
axis(2,at=c(log10(10),log10(100),log10(1000),log10(10000),log10(50000)),
	labels=c("10","100","1.000","10.000","50.000"),col=par("bg"),
	col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)
for (i in 1:n) segments(von[i],log10(Anzahl_Zeitreihen)[i],bis[i],
	log10(Anzahl_Zeitreihen)[i],col=farbe,lwd=8)

# Betitelung

mtext("histat-Zeitreihen",3,line=2,adj=0,family="Lato Black",outer=T,cex=2)
mtext("Anfang, Ende und Anzahl der Zeitreihen pro Studie, Jahreswerte",3,line=0,adj=0,cex=1.35,font=3,outer=T)
mtext("Quelle: gesis.org/histat",1,line=2,adj=1.0,cex=1.1,font=3,outer=T)
dev.off()

