pdf_datei<-"balkendiagramme_mehrfach.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=13,height=10.5)

par(omi=c(0.65,0.75,1.25,0.75),mai=c(0.9,3.85,0.55,0),lheight=1.15,
	family="Lato Light",las=1)  
source("skripte/inc_beschriftungen_za4753.r")
library(memisc)

# Daten einlesen und Grafik vorbereiten

ZA4753<-spss.system.file("daten/ZA4753_v1-1-0.sav")
daten<-subset(ZA4753,select=c(v159,v160,v161,v162,v163,v164,v165))
attach(daten)
z<-NULL
y<-table(as.matrix(v165))
z<-c(z,100*(y["1"]+y["2"])/sum(y))
y<-table(as.matrix(v164))
z<-c(z,100*(y["1"]+y["2"])/sum(y))
y<-table(as.matrix(v163))
z<-c(z,100*(y["1"]+y["2"])/sum(y))
y<-table(as.matrix(v162))
z<-c(z,100*(y["1"]+y["2"])/sum(y))
y<-table(as.matrix(v161))
z<-c(z,100*(y["1"]+y["2"])/sum(y))
y<-table(as.matrix(v160))
z<-c(z,100*(y["1"]+y["2"])/sum(y))
y<-c(0,table(as.matrix(v159)))
z<-c(z,100*(y["1"]+y["2"])/sum(y))

# Grafik erstellen

bp<-barplot(z,names.arg=F,horiz=T,border=NA,xlim=c(0,100),
	col="grey",axes=F,family="Lato")
f4<-rgb(255,0,210,maxColorValue=255)
rect(0,-0.1,20,8.6,col=rgb(191,239,255,80,maxColorValue=255),border=NA)
rect(20,-0.1,40,8.6,col=rgb(191,239,255,120,maxColorValue=255),border=NA)
rect(40,-0.1,60,8.6,col=rgb(191,239,255,80,maxColorValue=255),border=NA)
rect(60,-0.1,80,8.6,col=rgb(191,239,255,120,maxColorValue=255),border=NA)
rect(80,-0.1,100,8.6,col=rgb(191,239,255,80,maxColorValue=255),border=NA)
z2<-c(0,0,84.81928,0,0,0,0)
bp<-barplot(z2,names.arg=F,horiz=T,border=NA,xlim=c(0,100),
	col=f4,axes=F,add=T)

# weitere Elemente

for (i in 1:length(namen))
{
if (i == 3) {schrift<-"Lato Bold"} else {schrift<-"Lato Light"}
text(-3,bp[i],namen[i],xpd=T,adj=1,family=schrift,cex=1.1)
text(10,bp[i],format(round(z[i],1),nsmall=1),family=schrift,cex=1.25,
	col=ifelse(i==3,"white","black"))
}
arrows(50,-0.1,50,8.8,lwd=1.5,length=0,xpd=T,col="skyblue3") 
arrows(50,-0.25,50,-0.1,lwd=5,length=0,xpd=T)
arrows(50,8.8,50,8.95,lwd=5,length=0,xpd=T)
text(48,8.9,"Mehrheit",adj=1,xpd=T,cex=0.9,font=3)
text(52,8.9,"50%",adj=0,xpd=T,cex=0.9,family="Lato Bold",font=3)
text(100,8.9,"alle Angaben in Prozent",adj=1,xpd=T,cex=0.9,font=3)
mtext(c(0,20,40,60,80,100),at=c(0,20,40,60,80,100),1,line=0.75)

# Betitelung

mtext("Man spricht ja oft davon, dass sich heutzutage die Rollen von Mann und Frau verändern",3,line=2.2,adj=0,cex=1.8,family="Lato Black",outer=T)
mtext("Stimme voll und ganz zu / stimme zu",3,line=0,adj=0,cex=1.5,outer=T)
mtext("Quelle: European Values Study 2008 Deutschland, ZA4753. www.gesis.org. Design: Stefan Fichtel, ixtract",1,line=0,adj=1,cex=0.95,outer=T,font=3)
dev.off()
