pdf_datei<-"karten_deutschland_orte_saeulen_umriss_inc.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=13,height=11)

par(omi=c(0.5,0.5,0.5,0),mai=c(0,0,0,2),lend=1)  
library(sp)

# Daten einlesen und Grafiken erstellen

orte<-read.xls("daten/daten_karten_deutschland_orte_balken.xlsx",head=T)
attach(orte)

con<-url("http://gadm.org/data/rda/DEU_adm1.RData")
load(con)
plot(gadm,border=rgb(151,151,151,50,maxColorValue=255),lwd=0.5)

con<-url("http://gadm.org/data/rda/DEU_adm0.RData")
load(con)
plot(gadm,border="darkgrey",lwd=0.95,add=T)

# weitere Elemente

n<-nrow(orte)
for (i in 1:n) 
{
balken1<-data.frame(c(long[i],long[i]),c(lat[i],lat[i]+neu[i]/4000))
lines(balken1,lwd=17,col="darkred")
text(long[i]+0.2,lat[i]+0.08+neu[i]/4000,neu[i],adj=1)

balken2<-data.frame(c(long[i]+0.3,long[i]+0.3),c(lat[i],lat[i]+gebraucht[i]/4000))
lines(balken2,lwd=17,col="darkgrey")
text(long[i]+0.2,lat[i]+0.08+gebraucht[i]/4000,gebraucht[i],adj=0)
text(long[i],lat[i]-0.09,Name[i],adj=0.5)
}
legend(14,50,c("neu","gebraucht"),border=F,pch=15,
	col=c("darkred","darkgrey"),bty="n",cex=1.3,pt.cex=4,xpd=NA,ncol=2)

# Betitelung

mtext("Preise für Eigentumswohnungen in ausgewählten Städten 2011",3,line=-0.5,adj=0,cex=2.25,family="Lato Black",outer=T)
mtext("Quelle: Immobilienpreisspiegel aus der LBS-Broschüre 'Markt für Wohnimmobilien 2011'",1,line=0,adj=0.9,cex=1.25,font=3)
dev.off()
