pdf_datei<-"lorenzkurven_lc_uebereinander.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=6.5,height=6.5)

par(mai=c(0.25,0,0,0),omi=c(0.4,0.2,0.5,0.2),pin=c(4,4),
	family="Lato Light",las=1)
library(Hmisc) 
library(ineq)

# Daten einlesen und Grafik vorbereiten

daten<-spss.get("daten/AEQU+.por",use.value.labels=T)
x2008<-subset(daten$EQINCOM1,daten$EQINCOM1 > 0 & daten$V2 == "STUDIEN-NR. 4600")
Lc.Eplus2008<-Lc(x2008)
x1988<-subset(daten$EQINCOM1,daten$EQINCOM1 > 0 & daten$V2 == "STUDIEN-NR. 1670")
x1988<-x1988[1:length(x2008)]
Lc.Eplus1988<-Lc(x1988)
DD_x1<-Lc.Eplus1988$p
DD_y1<-Lc.Eplus1988$L
DD_x2<-Lc.Eplus2008$p
DD_y2<-Lc.Eplus2008$L

# Grafik definieren und weitere Elemente

plot(DD_x1,DD_y1,type="n",axes=F,xlab="aufsummierter Anteil Bevölkerung",
	ylab="aufsummierter Anteil Einkommen")
lines(DD_x1,DD_y1)
lines(DD_x2,DD_y2)
xx<-c(DD_x1,rev(DD_x1))
yy1<-c(DD_y1,rev(DD_y2))
yy2<-c(DD_y1,rev(DD_x1))
polygon(xx,yy1,col=rgb(191,239,255,80,maxColorValue=255),border=F)
polygon(xx,yy2,col=rgb(191,239,255,120,maxColorValue=255),border=F)
x<-array(c(0,1,0,1),dim=c(2,2))
lines(x,lwd=2,col="black")
text(0.12,0.585,"Gleichverteilung",adj=c(0,0))
text(0.82,0.29,"1988",adj=c(0,0))
text(0.92,0.435,"2008",adj=c(0,0))
arrows(0.4,0.3,0.8,0.3,length=0.10,angle=10,code=1,lwd=2,col="black")
arrows(0.65,0.45,0.9,0.45,length=0.10,angle=10,code=1,lwd=2,col="black")
arrows(0.49,0.6,0.6,0.6,length=0.10,angle=10,code=2,lwd=2,col="black")
source("skripte/inc_achsen_mit_linien_lorenz.r")

# Betitelung

mtext("Lorenzkurve der Einkommensverteilung 1988 und 2008",side=3,line=0.25,cex=1.45,family="Lato Black",outer=T,adj=0)
mtext("Allgemeine Bevölkerungsumfrage der Sozialwissenschaften",3,line=-2,adj=0,outer=T,cex=1.05,font=3)
mtext("Source: GESIS ZA 4600, ZA 1670",1,line=0.6,adj=1,outer=T,cex=0.85,font=3)
dev.off()
