pdf_datei<-"profildiagramm.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=12,height=8)

source("skripte/funktionen/profile.plot.r")
par(lheight=1.15,mai=c(0.25,0.25,0.25,0.25), omi=c(0.5,0.5,1.1,0.5),
	family="Lato Light",las=1)

# Beschriftungen einlesen
	
text.left<-NULL
text.right<-NULL
text.left<-c(text.left,"Jeder einzelne Bürger sollte mehr\nVerantwortung für sich selbst übernehmen")
text.right<-c(text.right,"Der Staat sollte mehr Verantwortung\ndafür übernehmen,dass jeder\nBürger abgesichert ist.")
text.left<-c(text.left,"Arbeitslose sollten jede Arbeit machen müssen,\ndie sie bekommen,oder ihre Arbeitslosen\n-unterstützung verlieren")
text.right<-c(text.right,"Arbeitslose sollten Arbeit,die sie\nnicht machen möchten, ablehnen können")
text.left<-c(text.left,"Wettbewerb ist gut. Er bringt die\nMenschen dazu,hart zu arbeiten\nund neue Ideen zu entwickeln")
text.right<-c(text.right,"Wettbewerb ist schädlich. Er bringt das\nSchlechte im Menschen zum Vorschein")
text.left<-c(text.left,"Der Staat sollte den\nUnternehmen mehr Freiheit lassen")
text.right<-c(text.right,"Der Staat sollte die\nUnternehmen besser kontrollieren.")
text.left<-c(text.left,"Einkommensunterschiede sollten\nverringert werden")
text.right<-c(text.right,"Es sollte größere Anreize für\npersönliche Leistung geben")
text.left<-c(text.left,"Mehr staatliche Unternehmen\nsollten privatisiert werden")
text.right<-c(text.right,"Mehr private Unternehmen\nsollten verstaatlicht werden")

# Daten einlesen und vorbereiten

library(Hmisc)
ZA4753<-spss.get("daten/ZA4753_v1-1-0.sav",use.value.labels=F)
variablen<-c("v302","v194","v195", "v196","v197","v198","v199")
ergebnis<-dim(2)
daten<-ZA4753[, variablen]
for (i in 2:length(variablen))
{
auswahl<-subset(daten[, c(1, i)], daten[, i] >= 1 & daten[, i] <= 10)
werte<-t(aggregate(auswahl[, 2], by=list(auswahl[, 1]), FUN=mean, na.rm=T))
ergebnis<-rbind(ergebnis, werte[2, ])
}

# Grafik erstellen 

colnames(ergebnis)=c("Männer","Frauen")
f1<-"skyblue"
f2<-"darkred"
profile.plot(ergebnis,text.left,text.right,colors=c(f1,f2),legend.n.col=2)

# Betitelung

mtext("Nun würde ich Sie bitten, mir Ihre Meinung zu verschiedenen Aussagen zu sagen",3,line=3,adj=0,cex=1.5,family="Lato Black",outer=T)
mtext("Quelle: ZA4753: European Values Study 2008: Germany (EVS 2008). N=2.075",1,line=1,adj=1.0,cex=1.1,font=3,outer=T)
dev.off()


