pdf_datei<-"saeulendiagramme_anteile.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11,height=7)

par(cex=0.9,omi=c(0.75,0.5,1.25,0.5),mai=c(0.5,1,0.75,1),mgp=c(3,2,0),
	family="Lato Light",las=1)

# Daten einlesen

source("skripte/inc_daten_dfg.r")

# Grafiken erstellen und weitere Elemente

barplot(x,col=c(f1a,f1a,f2a,f2a,f3a,f3a,f4a,f4a),beside=T,
	border=NA,axes=F,names.arg=c("","","",""))
barplot(2*y,col=c(f1a,f1b,f2a,f2b,f3b,f3b,f4a,f4b),beside=T,
	border=NA,axes=F,add=T,names.arg=beschriftung,cex.names=1.25)
z<-1
for (i in 1:4)
{
text(z+0.25,x[1,i]/2,format(round(x[1,i],1),nsmall=1),adj=0)
text(z+1.25,y[2,i],format(round(y[2,i],1),nsmall=1),adj=0,col="white")
text(z+0.65,x[1,i]+50,paste(format(round(100*y[2,i]/x[1,i],1),
	nsmall=1),"%",sep=" "),adj=0,cex=1.5,xpd=T)
z<-z+3
}

# Betitelung

mtext("DFG-Bewilligungen 2010",3,line=4,adj=0,family="Lato Black",outer=T,cex=2)
mtext("Einzelförderung nach Wissenschaftsbereichen, Angaben in Mio. Euro. Prozentangabe: Bewilligungsquote",3,line=1,adj=0,cex=1.35,font=3,outer=T)
mtext("Quelle: DFG Information Cards, www.dfg.de",1,line=2,adj=1.0,cex=1.1,font=3,outer=T)
dev.off()
