pdf_datei<-"saeulendiagramme_beschriftung_45.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=7,height=5)

library(plotrix)
par(mai=c(0.95,0.5,0.0,0.5),omi=c(0,0.5,1.0,0),las=1,
	family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

links<-read.xls("daten/listserv_discussion_traffic.xlsx",sheet=2)
attach(links)
sort.links<-links[order(-Anzahl) ,]
namen<-sort.links$Software
anzahl<-sort.links$Anzahl
par(col.axis="black",fg=par("bg"),bty="n",tck=0)
par(bty="n",tck=0)
py<-c(0,500,1000,1500,2000,2500,3000,3500)
fpy<-format(py,big.mark=".")

# Grafik erstellen

barp(anzahl,cex.axis=0.75,names.arg=namen,border=NA,col="grey",
	staxx=T,ylim=c(0,4000),height.at=py,height.lab=fpy)
par(col="black")
staxlab(1,1:length(namen),namen,srt=45,top.line=1.75,font=3)
abline(h=c(500,1000,1500,2000,2500,3000,3500),col=par("bg"),lwd=3) 

# Betitelung

mtext("Anzahl Verweise auf Homepages von Statistik-Software",3,line=2,adj=0,cex=1.4,family="Lato Black",outer=T)
mtext("Quelle: r4stats.com/popularity",1,line=3,adj=1.0,cex=0.65,font=3)
dev.off()
