pdf_datei<-"streudiagramme_verbunden.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=10,height=10)

par(mai=c(1.1,1.25,0.15,0),omi=c(1,0.5,1,0.5), mgp=c(4.5,1,0),
	family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

daten<-read.xls("daten/gapminder/greece.xlsx")
daten<-daten[daten$Year>=1985, ]

attach(daten)
n<-nrow(daten)
wrGDP<-vector()
wrLEXP<-vector()
for (i in 2:n) 
{
wrGDP[i]<-(GDP[i]-GDP[i-1])/GDP[i-1]
wrLEXP[i]<-(LEXP[i]-LEXP[i-1])/LEXP[i-1]
}
daten$wrGDP<-wrGDP*100
daten$wrLEXP<-wrLEXP*100
daten<-daten[2:n, ]

n<-nrow(daten)

t <- 1:n
ts <- seq(1, n, by = 1/10)
xs <- splinefun(t, daten$wrGDP)(ts)
ys <- splinefun(t, daten$wrLEXP)(ts)

# Grafik definieren und weitere Elemente

plot(daten$wrGDP, daten$wrLEXP, type="n", xlab="Wachstumsrate GDP (%)", 
	ylab="Wachstumsrate Lebenserwartung (%)", cex.lab=1.5, axes=F)
axis(1,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025,cex.axis=1.25)
axis(2,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025,cex.axis=1.25)

lines(xs, ys,lwd=7,col="grey")
for (i in 1:n)
{
symbols(daten$wrGDP[i],daten$wrLEXP[i],bg="brown",fg="white",circles=1,inches=0.25,add=T)
text(daten$wrGDP[i],daten$wrLEXP[i], daten$Year[i],col="white")
}

# Betitelung

mtext("GDP und Lebenserwartung in Griechenland",3,adj=0,line=1.5,cex=2.5,family="Lato Black",outer=T)
mtext("Zusammenhang der Wachstumsraten, 1986-2010",3,adj=0,line=-0.25,cex=1.5,font=3,outer=T)
mtext("Quelle: gapminder.org",1,line=2,adj=1,cex=1.25,font=3,outer=T)
dev.off()

