pdf_datei<-"zeitreihen_flaechen_gestapelt.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=9,height=7)

library(plotrix)
par(mai=c(0.5,1.1,0,0.5),omi=c(0.5,0.5,0.8,0.5),family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

daten<-read.xls("daten/Stromerzeugung_Bayern.xlsx")

f1<-"brown"
f2<-"black"
f3<-"grey"
f4<-"forestgreen"
f5<-"blue"
f6<-"lightgoldenrod"

Jahre<-daten$Jahr
daten$Jahr<-NULL
Gesamt<-daten$Gesamt
daten$Gesamt<-NULL

fg_org<-par("fg")
par(fg=par("bg"))

# Grafik erstellen und weitere Elemente

stackpoly(daten,main="",xaxlab=rep("", nrow(daten)),border="white",
	stack=TRUE,col=c(f1,f2,f3,f4,f5,f6), axis2=F, ylim=c(0,95000))
lines(Gesamt, lwd=4, col="lightgoldenrod4")
par(fg=fg_org)
mtext(seq(1990,2010,by=5), side=1, at=seq(1,21,by=5), line=0.5)
segments(0.25,0,22.25,0,xpd=T)
ypos<-c(7000,12000,16000,24000,30500,55000)
bez<-names(daten)
text(rep(0.5,6), ypos, bez, xpd=T, adj=1)

# Betitelung

mtext("Bruttostromerzeugung in Bayern 1990–2011",3,line=1.5,adj=0,family="Lato Black",cex=1.75,outer=T)
mtext("Alle Angaben in Mill. kWh, Jahreswerte",3,line=-0.2,adj=0,font=3,cex=1.25,outer=T)
mtext("Quelle: www.statistik.bayern.de",1,line=1,adj=1,cex=0.9,font=3,outer=T)
dev.off()
