pdf_datei<-"zeitreihen_kurz_inc.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=9,height=4.2)

source("skripte/0inc_datendesign_dbconnect.r")
par(mar=c(3,5,0.5,2),omi=c(0,0,0,0),family="Lato Light",las=1)

# Daten einlesen

sql<-"select dezjahr, v39_weitere, v39_nutzen, v39_stilllegen from t_za2391_zeitreihen"
dataset<-dbGetQuery(con,sql)
attach(dataset)

# Grafik definieren und weitere Elemente

plot(type="n",xlab="",ylab="Anteil in Prozent",dezjahr,
	v39_weitere,ylim=c(0,80))

vars1<-c("dezjahr","v39_weitere")
punkte1<-subset(dataset[vars1],!is.na(dataset[vars1]$v39_weitere))

vars2<-c("dezjahr","v39_nutzen")
punkte2<-subset(dataset[vars2],!is.na(dataset[vars2]$v39_nutzen))

vars3<-c("dezjahr","v39_stilllegen")
punkte3<-subset(dataset[vars3],!is.na(dataset[vars3]$v39_stilllegen))

farbe1<-rgb(200,97,0,150,maxColorValue=255)
farbe2<-rgb(100,97,0,maxColorValue=255)
farbe3<-rgb(130,130,130,maxColorValue=255)

points(punkte1,col=farbe1,lwd=2,type="b")
points(punkte2,col=farbe2,lwd=2,type="b")
points(punkte3,col=farbe3,lwd=2,type="b")

text(2006,2,"weitere bauen",col=farbe1)
text(2005.5,78,"vorhandene nutzen",col=farbe2)
text(2005.5,25,"vorhandene stilllegen",col=farbe3)

dev.off()

