pdf_datei<-"zeitreihen_streudiagramme_9x5.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=8.27,height=11.7)
par(omi=c(0.25,0.1,0.7,0.1),mai=c(0.1,0.1,0.45,0.1),mfrow=c(9,5),
	family="Lato Light",las=1)  

source("skripte/0inc_datendesign_dbconnect.r")

# Daten einlesen und Grafik vorbereiten

land<-c("ARG","AUS","AUT","BGR", "CAN","CHL", "CHN", "CZE", "DEU", "DNK",
	 "DOM", "EST", "FIN", "FRA", "GBR", "HRV", "HUN", "IRL", "ISR", "ITA", 
	 "JPN", "KOR", "LVA", "MEX", "NLD", "NOR", "NZL", "PHL", "POL", "PRT", 
	 "RUS", "SVK", "SVN", "ESP", "SWE", "TUR", "TWN", "UKR", "USA", "ZAF")
teil1<-"select Year, Gini from v_wiid2c_Gini where Country3='"
teil2<-"'"
for (i in 1:length(land))
{
sql1<-paste(teil1,land[i],teil2,sep="")
sql2<-paste(teil1,land[i],teil2," and Gini > 36",sep="")
daten<-dbGetQuery(con,sql1)
daten2<-dbGetQuery(con,sql2)

# Grafik definieren und weitere Elemente

plot(daten,xlim=c(1950,2010),ylim=c(10,75),main=land[i], type="n",axes=F)
rect(1950,36,2010,75,col=rgb(255,0,0,50,maxColorValue=255),lwd=0)
rect(1950,0,2010,36,col=rgb(68,90,111,50,maxColorValue=255),lwd=0)
points(daten,col=rgb(68,90,111,100,maxColorValue=255),pch=19,type="b")
axis(1,at=c(1950,2010),col=par("bg"),cex.axis=0.95)
if (length(daten2) > 0)
{
points(daten2,pch=19,col=rgb(255,0,0,100,maxColorValue=255))
}
}

# Betitelung

mtext("Ungleichheit in 40 Ländern 1950–2010",3,outer=T,line=2,xpd=T,adj=0,family="Lato Black",cex=1.3)
mtext("Entwicklung des Gini-Koeffizienten der Einkommensverteilung (Jahreswerte)",3,outer=T,line=0,xpd=T,adj=0,font=3)
mtext("Quelle: World Income Inequality Database V2.0c May 2008",1,outer=T,line=-3,xpd=T,adj=0.9,font=3)
mtext("Blau: bis 0.36. Rot: über 0.36.",1,outer=T,line=-3,xpd=T,adj=0,font=3)
dev.off()

