pdf_datei<-"grafiktabellen_heatmap.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=7,height=8)

library(RColorBrewer)
library(pheatmap)
par(mai=c(0.25,0.25,0.25,1.75),omi=c(0.25,0.25,0.75,0.85),
	family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

noten<-read.xls("daten/noten.xlsx")
x<-as.matrix(noten[,2:13])
rownames(x)<-noten$namen
x<-x[order(rowSums(x)), ]
x<-x[,order(colSums(x))]

# Grafik erstellen

plot.new()
pheatmap(x,col=brewer.pal(6,"Spectral"),
	cluster_rows=F,cluster_cols=F,cellwidth=25,cellheight=14,
	border_color="white",fontfamily="Lato Light")

# Betitelung

mtext("Heatmap der Schulnoten einer fiktiven Klasse ",3,line=1,adj=0.2,cex=1.75,family="Lato Black",outer=T)
mtext("fiktive Daten, Namen mit de.fakenamegenerator.com generiert",1,line=-1,adj=1,cex=0.85,font=3,outer=T)
dev.off()

