pdf_datei<-"grafiktabellen_mosaikplot_1x2.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=10,height=6)

par(mai=c(0.25,0.0,0.0,0.25),omi=c(0.5,0.5,1.25,0.5),las=1,mfcol=c(1,2),
	family="Lato Light",las=1) 
library(RColorBrewer)

# Daten einlesen und Grafik vorbereiten

data<-read.csv("daten/1000.csv",as.is=c(F,T,F,T,T),sep=";")
data$DEKADE<-floor(data$YEAR/10) * 10
data$KDEKADE<-paste(data$DEKADE,"s",sep="")
data$KDEKADE[data$DEKADE < 1960]<-"1910s-50s"
tab<-table(data$KDEKADE,data$THEME)
utab<-chisq.test(tab)

# Grafik erstellen

mosaicplot(utab$expected,col=brewer.pal(7,"Accent"),main="",border=par("bg"))
mosaicplot(tab,col=brewer.pal(7,"Accent"),main="",border=par("bg"))

# Betitelung

mtext("1000 songs to hear before you die",3,line=3,adj=0,cex=1.5,family="Lato Black",outer=T)
mtext("Guardian 1000 Songs Distribution",3,line=1.5,adj=0,cex=0.9,font=3,outer=T)
mtext("Source: www.stubbornmule.net",1,line=1,adj=1.0,cex=0.85,font=3,outer=T)
dev.off()

