# inc_plot_karten_europa_choropleth_laender.r
data(wrld_simpl) 
w=wrld_simpl[wrld_simpl@data[,"NAME"] != "Antarctica",] 
m=spTransform(w,CRS=CRS("+proj=merc"))

plot(m,xlim=c(-2000000,5000000),ylim=c(4000000,10000000),
	col=rgb(120,120,120,maxColorValue=255),border=F)

x<-readShapeSpatial("daten/NUTS-2006/NUTS_RG_03M_2006.shp",
	proj4string=CRS("+proj=longlat"))

xls<-read.xls("daten/eb_nuts.xlsx")

y<-x[x$NUTS_ID %in% xls$nuts_id,]

m=spTransform(y,CRS=CRS("+proj=merc")) 

source("skripte/0inc_datendesign_dbconnect.r")
sql<-paste("select ",auswahl," auswahl from v_za4972_laender",sep="")
datensatz<-dbGetQuery(con,sql)
attach(datensatz)

nr<-m$NUTS_ID
datensatz$ref_NUTS_ID<-xls$nuts_id

position<-vector()
for (i in 1:30){
	position[i]<-match(m$NUTS_ID[i], datensatz$ref_NUTS_ID)
}

farb_nr<-cut(datensatz$auswahl[position],klassen)
levels(farb_nr)<-klass_bez

plot(m,col=farbpalette[farb_nr],border="white",add=T)
legend("right",levels(farb_nr),cex=0.95,border=F,bty="n",fill= farbpalette,
	text.col="white")

