pdf_datei<-"karten_deutschland_orte_kreisdiagramme_umriss.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=13,height=11)
farbe_h<-rgb(240,240,240,maxColorValue=255)

par(omi=c(0.5,0.5,0.5,0),mai=c(0,0,0,0),lend=1,family="Lato Light",las=1)  
library(sp)
library(plotrix)

# Daten einlesen und Grafik erstellen

daten<-"daten/daten_karten_deutschland_orte_kreisdiagramme.xlsx"
laender<-read.xls(daten,head=T)
attach(laender)

con<-url("http://biogeo.ucdavis.edu/data/gadm2/R/DEU_adm1.RData")
load(con)
plot(gadm,border=rgb(151,151,151,maxColorValue=255),lwd=0.5)

con<-url("http://biogeo.ucdavis.edu/data/gadm2/R/DEU_adm0.RData")
load(con)
plot(gadm,border="black",lwd=0.95,add=T)

# weitere Elemente

n<-nrow(laender)
for (i in 1:n) 
{
kreis<-c(Landwirtschaft[i],Wald[i],Siedlung[i])
floating.pie(long[i],lat[i],kreis,radius=0.5,
	col=c(rgb(215,215,0,150,maxColorValue=255),
	rgb(34,139,34,150,maxColorValue=255),
	rgb(178,34,34,150,maxColorValue=255)),border=F)
text(long[i],lat[i],Name[i])
}
floating.pie(16,48.25,c(1,1,1),radius=0.5,
	col=c(rgb(215,215,0,150,maxColorValue=255),
	rgb(34,139,34,150,maxColorValue=255),
	rgb(178,34,34,150,maxColorValue=255)),border=F)
text(16.75,47.75,"Siedlungsfläche")
text(14.7,48.25,"Waldfläche")
text(16.75,48.75,"Landwirtschaft")

# Betitelung

mtext("Anteile der Landwirtschafts-, Wald- und Siedlungsfläche in Deutschland",3,line=-0.25,adj=0,cex=2.25,outer=T,family="Lato Black")
mtext("Quelle: Statistisches Bundesamt Fachserie 3  Reihe 5.1",1,line=0,adj=0.9,cex=1.25,font=3)
dev.off()

