pdf_datei<-"kreisdiagramme_1x4.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=14,height=6)

library(plotrix)
par(omi=c(0.5,0.5,1,0.5),mai=c(0,0,0,0),xpd=T,mfcol=c(1,4),
	family="Lato Light",las=1)

# Daten einlesen

source("skripte/inc_daten_dfg.r")

# Grafiken definieren und weitere Elemente

for (i in 1:4)
{ 
plot(1:5,type="n",axes=F,xlab="",ylab="")
werte<-c(x[2,i]-y[2,i],y[2,i])
kreis<-floating.pie(3,3,werte,border="white",
	radius=2.1*sqrt(x[1,i]/max(x[1,])),col=c(farben1[i],farben2[i]))
pie.labels(3,3,kreis,werte,bg=NA,border=NA,
	radius=x[1,i]/max(x[1,]),cex=2,col="white")
if (i==1) pie.labels(3,3,kreis,c("abgelehnt","bewilligt"),
	bg=NA,border=NA,radius=1.95,font=3)
text(3,4.7,cex=2,adj=0.5,
	paste(format(round(100*y[2,i]/x[1,i],1),nsmall=1),"%",sep=" "))
text(3,1.2,beschriftung[i],cex=2,adj=0.5)
}

# Betitelung

mtext("DFG-Bewilligungen 2010",3,line=4,adj=0,family="Lato Black",outer=T,cex=2)
mtext("Einzelförderung nach Wissenschaftsbereichen, Angaben in Mio. Euro. Prozentangabe: Bewilligungsquote",3,line=1,adj=0,cex=1.35,font=3,outer=T)
mtext("Quelle: DFG Information Cards 2011, www.dfg.de",1,line=2,adj=1.0,cex=1.1,font=3,outer=T)
dev.off()

