pdf_datei<-"kreisdiagramme_einfach.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11,height=11)

par(omi=c(2,0.5,1,0.25),mai=c(0,1.25,0.5,0.5),family="Lato Light",las=1)
library(RColorBrewer)

# Grafik erstellen

pie.daten<-c(5.8,27.0,0.2,21.1,12.8,33.1)
energiearten<-c("Kernenergie:","Kohle:**","sonstige***:","Gas:",
	"erneuerbare\nEnergien:****","Öl:")
names(pie.daten)<-paste(energiearten,pie.daten,"%",sep=" ")
pie(pie.daten,col=brewer.pal(length(pie.daten),"Reds"),border=0,
	cex=1.75,radius=0.9,init.angle=90)

# Betitelung

mtext("Energiemix der Welt (inklusive See- und Luftverkehr)",3,line=2,adj=0,family="Lato Black",outer=T,cex=2.5)
mtext("Anteile der Energieträger an der Primärenergie-Versorgung* in Prozent, 2008",3,line=-0.75,adj=0,cex=1.65,font=3,outer=T)
mtext("* Primärenergie-Versorgung=Primärenergie-Produktion + Importe - Exporte +/- Veränderung der Lagerbestände",1,line=2,adj=0,cex=1.05,outer=T)
mtext("** einschließlich Torf",1,line=3.2,adj=0,cex=1.05,outer=T)
mtext("*** Biomasse,biologisch abbaubare Abfälle (ohne Industrieabfälle), Wasserkraft,geoth.Energie,Solar-,Wind- und Meeresenergie",1,line=4.4,adj=0,cex=1.05,outer=T)
mtext("**** Industrieabfälle und brennbare Abfälle,die der Energieerzeugung dienen und die nicht biologisch abbaubar sind",1,line=5.6,adj=0,cex=1.05,outer=T)
mtext("Quelle: Bundeszentrale für politische Bildung: Stichwort 'Energiemix', www.bpb.de",1,line=8,adj=1,cex=1.35,font=3,outer=T)
dev.off()

