pdf_datei<-"pdf/netzwerkbeziehungen_multiples_balkendiagramm.pdf"
cairo_pdf(bg="grey99", pdf_datei,width=10,height=12)

library(igraph)
library(RColorBrewer)

# Daten einlesen und Grafik vorbereiten

df0 <- read.csv("daten/reg_flow.csv", stringsAsFactors=FALSE)
df1 <- read.csv("daten/reg_plot.csv", stringsAsFactors=FALSE)

net <- graph_from_data_frame(d=df0, vertices=df1, directed=T)
netm <- get.adjacency(net, attr="flow", sparse=F)

maxwert<-max(netm)
n<-nrow(netm)
m<-n
par(mfrow=c(n,m), omi=c(1,4,4,2), mai=c(0,0,0,0), family="Lato Light")

farbe1<-rgb(255,0,210,maxColorValue=255)
farbe2<-rgb(0,208,226,maxColorValue=255)

# Grafik erstellen

for(i in 1:n)
{
for(j in 1:m)
{
plot(1:1, xlim=c(0,1), ylim=c(0,1), type="n", axes=F)
if(i<j) farbe<-farbe1 
if(i==j) farbe<-"grey80"
if(i>j) farbe<-farbe2 

if (i==1) text(0.5,1.2, df1$region[j], cex=2, xpd=NA, adj=0, srt=45, col=farbe1)
if (j==1) text(-0.1,0.5, df1$region[i], cex=2, xpd=NA, adj=1, col=farbe2)

rect(0,0,1,1, col="grey95", border=NA)
rect(0,0,1,netm[i,j]/maxwert, col=farbe, border=NA)
text(0.5, 0.5, format(round(netm[i,j], 2), nsmall=2), cex=1.5, col="grey40")
}
}

# Betitelung

mtext("Migration to:", side=3, outer=T, cex=2.5, line=14, col=farbe1, adj=0)
mtext("Migration from:", side=2, outer=T, cex=2.5, line=25, col=farbe2, srt=90)
mtext("Migration 2010-2015", side=3, outer=T, cex=3, adj=1, at=0.4, , line=22, col="grey50", family="Lato Black")
mtext("All figures in millions. Data Source: https://github.com/cran/migest/tree/master/inst/vidwp",1,line=2.5, adj=1, at=0.6, font=3, outer=T)

dev.off()
