pdf_datei<-"pyramiden_mehrfarbig.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=9,height=9)

par(mai=c(0.5,1,0.5,0.5),omi=c(0.5,0.5,0.5,0.5),family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

frauen<-read.csv("daten/frauen.txt",header =F,sep=",")
for(i in 1:111) colnames(frauen)[i]<-paste("x",i+1949,sep="")
maenner<-read.csv("daten/maenner.txt",header =F,sep=",")
for(i in 1:111) colnames(maenner)[i]<-paste("x",i+1949,sep="")

rechts<-frauen$x2010
links<-maenner$x2010

farbe_rechts<-c(rep(rgb(210,210,210,maxColorValue=255),15),
			rep(rgb(144,157,172,maxColorValue=255),50),
			rep(rgb(225,152,105,maxColorValue=255),
			length(rechts)-65))
farbe_links<-farbe_rechts

# Grafik erstellen und weitere Elemente

barplot(rechts,axes=F,horiz=T,axis.lty=0,border=NA,
	col=farbe_rechts,xlim=c(-750,750))
barplot(-links,axes=F,horiz=T,axis.lty=0,border=NA,
	col=farbe_links,xlim=c(-750,750),add=T)

abline(v=0,lwd=28,col=par("bg"))
for (i in seq(10,90,by=10)) text(0,i+i*0.2,i,cex=1.1)
mtext(abs(seq(-600,600,by=200)),at=seq(-600,600,by=200),1,line=-1,cex=0.80)

rect(-1000,15+15*0.2,1000,66+66*0.2,xpd=T,
	col=rgb(210,210,210,90,maxColorValue=255), border=NA)

mtext("erwerbsfähiges Alter",2,line=1.5,las=3,adj=0.38)
mtext("Männer",3,line=-5,adj=0.25,cex=1.5,col="grey")
mtext("Frauen",3,line=-5,adj=0.75,cex=1.5,col="grey")

# Betitelung

mtext("Altersaufbau der Bevölkerung in Deutschland 2010",3,line=-1.5,adj=0,cex=1.75,family="Lato Black",outer=T)
mtext("Angaben in Tausend je Altersjahr",3,line=-3.25,adj=0,cex=1.25,font=3,outer=T)
mtext("Quelle: www.destatis.de/bevoelkerungspyramide/",1,line=0,adj=1.0,cex=0.95,font=3,outer=T)
dev.off()

