pdf_datei<-"zeitreihen_tageswerte_monatsbeschriftung.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=14,height=8)

par(omi=c(0.65,0.75,0.95,0.75),mai=c(0.9,0.75,0.25,0),
	family="Lato Light",las=1)
	
# Daten einlesen und Grafik vorbereiten
  
euro<-read.csv("daten/eurofxref-hist.csv")
euro<-euro[as.Date(euro$Date)>as.Date("2010-08-01"),]
monatsanfang<-seq(as.Date("2010-08-01"),as.Date("2012-08-01"),by="1 months")
tage<-rev(as.Date(euro$Date))
werte<-rev(euro$USD)

# Grafik definieren und weitere Elemente

plot(tage,werte,axes=F,type="n",xlab="",ylab="")
lines(tage,werte,col="grey")
lfarbe<-rgb(255,97,0,100,maxColorValue=255)
lines(lowess(tage,werte,f=1/25),col=lfarbe,lwd=5)
par(mgp=c(3,1.5,0))
axis(1,at=monatsanfang,labels=format(monatsanfang,"%b\n%Y"),cex.axis=0.75)
axis(2)
legend("bottomleft","lowess-Filter f=1/25",pch=15,col=lfarbe,bty="n",cex=2)

# Betitelung

mtext("Wechselkurs US-Dollar/Euro 2010–2012",3,line=0,adj=0,cex=2.5,family="Lato Black",outer=T)
mtext("Tageswerte",3,line=-2,adj=0,cex=1.75,font=3,outer=T)
mtext("Quelle: www.ecb.int/stats/exchange/eurofxref/html/index.en.html",1,line=4,adj=1.0,cex=1.25,font=3)
dev.off()

