library(tcltk) 

# Number of time steps 
N=1000 

# Time horizon 
T=1.0 

# Length of time step 
h=T/N 

# Dimension of the transition matrix
dim=5 
 
# Definition of the identity matrix 
I=matrix(c(
1,0,0,0,0, 
0,1,0,0,0, 
0,0,1,0,0, 
0,0,0,1,0, 
0,0,0,0,1 
),nrow=dim,ncol=dim,byrow=TRUE)

# Definition of the infinitesimal generator 
Q=matrix(c(
-40,40,0,0,0, 
20,-40,20,0,0, 
0,10,-30,20,0, 
0,0,20,-60,40,
0,0,0,20,-20 
),nrow=dim,ncol=dim,byrow=TRUE)

# Definition of the transition matrix
P=I+h*Q 

A=array(2);
B=array(2);
C=array(2);

Y=array(N+1);

X=array(N+1); for(l in seq(1,N+1)) { X[l]=l-1; }

B[1]=2
B[2]=2

split.screen(c(1,1)) 
 
A[1]=0;A[2]=h;

screen(1,FALSE) 
plot(A,B-1,type="o", xlim=c(0,T),ylim=c(0,4),xlab="", ylab="", yaxt="n",xaxt="n",xaxs="i",col="red", main = "Birth and death process - embedded chain",cex=1.2,bty="n")

for(l in seq(0:N))
{
A[1]=(l-1)*h;
A[2]=A[1]+h;
B[1]=B[2];
B[2]=sample(dim,size=1,prob=P[B[1],])

screen(1,FALSE)

plot(A,B-1,type="o", xlim=c(0,T),ylim=c(0,4),xlab="", ylab="", yaxt="n",xaxt="n",xaxs="i",col="black", main = "Birth and death process - embedded chain",cex=0.4,bty="n")

if (B[2]!=B[1]) {alarm();
screen(1,FALSE)
C[1]=B[2];C[2]=B[2]
plot(A,C-1,type="o", xlim=c(0,T),ylim=c(0,4),xlab="", ylab="", yaxt="n",xaxt="n",xaxs="i",col="red", main = "Birth and death process - embedded chain",cex=1.2,bty="n")
} 

axis(2,pos=0,at=seq(0,4,1)) 

axis(1,pos=0,at=seq(0,T,T/10),outer=TRUE) 

Sys.sleep(0.02) 

} 

