a=20; b=40;

# Number of time steps 
N=1000 

# Time horizon 
T=1.0 

# Length of time step 
h=T/N 

# Dimension of the transition matrix
dim=2 
 
# Transition matrix P = I + hQ over a small time interval 
P=matrix(c(1-a*h,a*h,b*h,1-b*h),nrow=dim,ncol=dim,byrow=TRUE)

Z=array(N+1);

for(ll in seq(1,N)) {

Z[1]=sample(dim,size=1,prob=P[2,])

# Random simulation of Z[j+1] given Z[j] 
for (j in seq(1,N)) Z[j+1]=sample(dim,size=1,prob=P[Z[j],])

Y=array(N+1);

S=0; 

# Computation of the average over the l first steps 

for(l in seq(1,N+1)) { Z[l]=Z[l]-1;  S=S+Z[l]; Y[l]=S/l; }

X=array(N+1); for(l in seq(1,N+1)) { X[l]=(l-1)*T/N; }

par(mfrow=c(2,1))

plot(X,Z,type="o",xlab="",ylab="",xlim=c(0,T),yaxt="n",xaxt="n",xaxs="i",col="black",main="",pch=20,cex=0.4,bty="n")

axis(1,pos=1,at=seq(0,T,T/10),outer=TRUE,padj=-4,tcl=0.5) 
axis(1,pos=0,at=seq(0,T,T/10),outer=TRUE) 
axis(2,las=2,at=0:1)

plot(X,Y,type="l",yaxt="n",xaxt="n",xlim=c(0,T),xlab="",ylim=c(0,1),ylab="",xaxs="i",col="black",main="",bty="n")

segments( 0 , a/(a+b), N, a/(a+b)) 

axis(2,pos=0,at=c(0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0))

axis(1,pos=0,at=seq(0,T,T/10),outer=TRUE) 

readline(prompt = "Pause. Press <Enter> to continue...") 

} 

dev.off() 